/*
 * Decompiled with CFR 0.152.
 */
package com.twilight.h264.decoder;

import com.twilight.h264.decoder.CAVLCTables;
import com.twilight.h264.decoder.GetBitContext;
import com.twilight.h264.decoder.H264Context;
import com.twilight.h264.decoder.H264Data;
import com.twilight.h264.decoder.MpegEncContext;
import com.twilight.h264.decoder.Rectangle;
import com.twilight.h264.decoder.VLC;
import com.twilight.h264.util.Arrays;

public class CAVLCContext {
    public static final int[] golomb_to_inter_cbp_gray = new int[]{0, 1, 2, 4, 8, 3, 5, 10, 12, 15, 7, 11, 13, 14, 6, 9};
    public static final int[] golomb_to_intra4x4_cbp_gray = new int[]{15, 0, 7, 11, 13, 14, 3, 5, 10, 12, 1, 2, 4, 8, 6, 9};
    public static final int[] chroma_dc_coeff_token_len = new int[]{2, 0, 0, 0, 6, 1, 0, 0, 6, 6, 3, 0, 6, 7, 7, 6, 6, 8, 8, 7};
    public static final int[] chroma_dc_coeff_token_bits = new int[]{1, 0, 0, 0, 7, 1, 0, 0, 4, 6, 1, 0, 3, 3, 2, 5, 2, 3, 2, 0};
    public static final int[][] coeff_token_len = new int[][]{{1, 0, 0, 0, 6, 2, 0, 0, 8, 6, 3, 0, 9, 8, 7, 5, 10, 9, 8, 6, 11, 10, 9, 7, 13, 11, 10, 8, 13, 13, 11, 9, 13, 13, 13, 10, 14, 14, 13, 11, 14, 14, 14, 13, 15, 15, 14, 14, 15, 15, 15, 14, 16, 15, 15, 15, 16, 16, 16, 15, 16, 16, 16, 16, 16, 16, 16, 16}, {2, 0, 0, 0, 6, 2, 0, 0, 6, 5, 3, 0, 7, 6, 6, 4, 8, 6, 6, 4, 8, 7, 7, 5, 9, 8, 8, 6, 11, 9, 9, 6, 11, 11, 11, 7, 12, 11, 11, 9, 12, 12, 12, 11, 12, 12, 12, 11, 13, 13, 13, 12, 13, 13, 13, 13, 13, 14, 13, 13, 14, 14, 14, 13, 14, 14, 14, 14}, {4, 0, 0, 0, 6, 4, 0, 0, 6, 5, 4, 0, 6, 5, 5, 4, 7, 5, 5, 4, 7, 5, 5, 4, 7, 6, 6, 4, 7, 6, 6, 4, 8, 7, 7, 5, 8, 8, 7, 6, 9, 8, 8, 7, 9, 9, 8, 8, 9, 9, 9, 8, 10, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10}, {6, 0, 0, 0, 6, 6, 0, 0, 6, 6, 6, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6}};
    public static final int[][] coeff_token_bits = new int[][]{{1, 0, 0, 0, 5, 1, 0, 0, 7, 4, 1, 0, 7, 6, 5, 3, 7, 6, 5, 3, 7, 6, 5, 4, 15, 6, 5, 4, 11, 14, 5, 4, 8, 10, 13, 4, 15, 14, 9, 4, 11, 10, 13, 12, 15, 14, 9, 12, 11, 10, 13, 8, 15, 1, 9, 12, 11, 14, 13, 8, 7, 10, 9, 12, 4, 6, 5, 8}, {3, 0, 0, 0, 11, 2, 0, 0, 7, 7, 3, 0, 7, 10, 9, 5, 7, 6, 5, 4, 4, 6, 5, 6, 7, 6, 5, 8, 15, 6, 5, 4, 11, 14, 13, 4, 15, 10, 9, 4, 11, 14, 13, 12, 8, 10, 9, 8, 15, 14, 13, 12, 11, 10, 9, 12, 7, 11, 6, 8, 9, 8, 10, 1, 7, 6, 5, 4}, {15, 0, 0, 0, 15, 14, 0, 0, 11, 15, 13, 0, 8, 12, 14, 12, 15, 10, 11, 11, 11, 8, 9, 10, 9, 14, 13, 9, 8, 10, 9, 8, 15, 14, 13, 13, 11, 14, 10, 12, 15, 10, 13, 12, 11, 14, 9, 12, 8, 10, 13, 8, 13, 7, 9, 12, 9, 12, 11, 10, 5, 8, 7, 6, 1, 4, 3, 2}, {3, 0, 0, 0, 0, 1, 0, 0, 4, 5, 6, 0, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63}};
    public static final int[][] total_zeros_len = new int[][]{{1, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 9}, {3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 6, 6, 6, 6, 0}, {4, 3, 3, 3, 4, 4, 3, 3, 4, 5, 5, 6, 5, 6, 0, 0}, {5, 3, 4, 4, 3, 3, 3, 4, 3, 4, 5, 5, 5, 0, 0, 0}, {4, 4, 4, 3, 3, 3, 3, 3, 4, 5, 4, 5, 0, 0, 0, 0}, {6, 5, 3, 3, 3, 3, 3, 3, 4, 3, 6, 0, 0, 0, 0, 0}, {6, 5, 3, 3, 3, 2, 3, 4, 3, 6, 0, 0, 0, 0, 0, 0}, {6, 4, 5, 3, 2, 2, 3, 3, 6, 0, 0, 0, 0, 0, 0, 0}, {6, 6, 4, 2, 2, 3, 2, 5, 0, 0, 0, 0, 0, 0, 0, 0}, {5, 5, 3, 2, 2, 2, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {4, 4, 3, 3, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {4, 4, 2, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {3, 3, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    public static final int[][] total_zeros_bits = new int[][]{{1, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 1}, {7, 6, 5, 4, 3, 5, 4, 3, 2, 3, 2, 3, 2, 1, 0, 0}, {5, 7, 6, 5, 4, 3, 4, 3, 2, 3, 2, 1, 1, 0, 0, 0}, {3, 7, 5, 4, 6, 5, 4, 3, 3, 2, 2, 1, 0, 0, 0, 0}, {5, 4, 3, 7, 6, 5, 4, 3, 2, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 7, 6, 5, 4, 3, 2, 1, 1, 0, 0, 0, 0, 0, 0}, {1, 1, 5, 4, 3, 3, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 3, 3, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 1, 3, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 1, 3, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 2, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    public static final int[][] chroma_dc_total_zeros_len = new int[][]{{1, 2, 3, 3}, {1, 2, 2, 0}, {1, 1, 0, 0}};
    public static final int[][] chroma_dc_total_zeros_bits = new int[][]{{1, 1, 1, 0}, {1, 1, 0, 0}, {1, 0, 0, 0}};
    public static final int[][] run_len = new int[][]{{1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 2, 2, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 2, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {2, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {3, 3, 3, 3, 3, 3, 3, 4, 5, 6, 7, 8, 9, 10, 11, 0}};
    public static final int[][] run_bits = new int[][]{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {3, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {3, 2, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {3, 0, 1, 3, 2, 5, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {7, 6, 5, 4, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}};
    public static VLC[] coeff_token_vlc = new VLC[4];
    public static final int[] coeff_token_vlc_tables_size = new int[]{520, 332, 280, 256};
    public static VLC chroma_dc_coeff_token_vlc = new VLC();
    public static final int chroma_dc_coeff_token_vlc_table_size = 256;
    public static VLC[] total_zeros_vlc = new VLC[15];
    public static final int total_zeros_vlc_tables_size = 512;
    public static VLC[] chroma_dc_total_zeros_vlc = new VLC[3];
    public static final int chroma_dc_total_zeros_vlc_tables_size = 8;
    public static VLC[] run_vlc = new VLC[6];
    public static final int run_vlc_tables_size = 8;
    public static VLC run7_vlc = new VLC();
    public static final int run7_vlc_table_size = 96;
    public static final int LEVEL_TAB_BITS = 8;
    public static int[][][] cavlc_level_tab = new int[7][256][2];
    public static final int[] ff_log2_tab = new int[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    public static int calvc_inited = 0;

    public static int av_log2(long v) {
        int n = 0;
        if ((v & 0xFFFF0000L) != 0L) {
            v >>= 16;
            n += 16;
        }
        if ((v & 0xFF00L) != 0L) {
            v >>= 8;
            n += 8;
        }
        return n += ff_log2_tab[(int)v];
    }

    public static int pred_non_zero_count(H264Context h, int n) {
        short index8 = H264Context.scan8[n];
        int left = h.non_zero_count_cache[index8 - 1];
        int top = h.non_zero_count_cache[index8 - 8];
        int i = left + top;
        if (i < 64) {
            i = i + 1 >> 1;
        }
        return i & 0x1F;
    }

    public static void init_cavlc_level_tab() {
        for (int suffix_length = 0; suffix_length < 7; ++suffix_length) {
            for (int i = 0; i < 256; ++i) {
                int prefix = 8 - CAVLCContext.av_log2(2 * i);
                int level_code = (prefix << suffix_length) + (i >> 8 - prefix - 1 - suffix_length) - (1 << suffix_length);
                int mask = -(level_code & 1);
                level_code = (2 + level_code >> 1 ^ mask) - mask;
                if (prefix + 1 + suffix_length <= 8) {
                    CAVLCContext.cavlc_level_tab[suffix_length][i][0] = level_code;
                    CAVLCContext.cavlc_level_tab[suffix_length][i][1] = prefix + 1 + suffix_length;
                    continue;
                }
                if (prefix + 1 <= 8) {
                    CAVLCContext.cavlc_level_tab[suffix_length][i][0] = prefix + 100;
                    CAVLCContext.cavlc_level_tab[suffix_length][i][1] = prefix + 1;
                    continue;
                }
                CAVLCContext.cavlc_level_tab[suffix_length][i][0] = 108;
                CAVLCContext.cavlc_level_tab[suffix_length][i][1] = 8;
            }
        }
    }

    public void ff_h264_decode_init_vlc() {
        if (0 == calvc_inited) {
            int i;
            calvc_inited = 1;
            CAVLCContext.chroma_dc_coeff_token_vlc.table_base = CAVLCTables.expandTable(CAVLCTables.chroma_dc_coeff_token_vlc_table);
            CAVLCContext.chroma_dc_coeff_token_vlc.table_offset = 0;
            CAVLCContext.chroma_dc_coeff_token_vlc.table_allocated = 256;
            for (i = 0; i < 4; ++i) {
                CAVLCContext.coeff_token_vlc[i] = new VLC();
                CAVLCContext.coeff_token_vlc[i].table_base = CAVLCTables.expandTable(CAVLCTables.coeff_token_vlc_table[i]);
                CAVLCContext.coeff_token_vlc[i].table_offset = 0;
                CAVLCContext.coeff_token_vlc[i].table_allocated = coeff_token_vlc_tables_size[i];
            }
            for (i = 0; i < 3; ++i) {
                CAVLCContext.chroma_dc_total_zeros_vlc[i] = new VLC();
                CAVLCContext.chroma_dc_total_zeros_vlc[i].table_base = CAVLCTables.expandTable(CAVLCTables.chroma_dc_total_zeros_vlc_table[i]);
                CAVLCContext.chroma_dc_total_zeros_vlc[i].table_offset = 0;
                CAVLCContext.chroma_dc_total_zeros_vlc[i].table_allocated = 8;
            }
            for (i = 0; i < 15; ++i) {
                CAVLCContext.total_zeros_vlc[i] = new VLC();
                CAVLCContext.total_zeros_vlc[i].table_base = CAVLCTables.expandTable(CAVLCTables.total_zeros_vlc[i]);
                CAVLCContext.total_zeros_vlc[i].table_offset = 0;
                CAVLCContext.total_zeros_vlc[i].table_allocated = 512;
            }
            for (i = 0; i < 6; ++i) {
                CAVLCContext.run_vlc[i] = new VLC();
                CAVLCContext.run_vlc[i].table_base = CAVLCTables.expandTable(CAVLCTables.run_vlc_table[i]);
                CAVLCContext.run_vlc[i].table_offset = 0;
                CAVLCContext.run_vlc[i].table_allocated = 8;
            }
            CAVLCContext.run7_vlc.table_base = CAVLCTables.expandTable(CAVLCTables.run7_vlc_table);
            CAVLCContext.run7_vlc.table_offset = 0;
            CAVLCContext.run7_vlc.table_allocated = 96;
            CAVLCContext.init_cavlc_level_tab();
        }
    }

    public static int get_level_prefix(GetBitContext gb) {
        int re_index = gb.index;
        long re_cache = 0L;
        int pos = gb.buffer_offset + (re_index >> 3);
        re_cache = gb.buffer[pos + 0];
        re_cache = re_cache << 8 | (long)gb.buffer[pos + 1];
        re_cache = re_cache << 8 | (long)gb.buffer[pos + 2];
        re_cache = re_cache << 8 | (long)gb.buffer[pos + 3];
        re_cache <<= re_index & 7;
        long buf = re_cache &= 0xFFFFFFFFL;
        int log = 32 - CAVLCContext.av_log2(buf);
        gb.index = re_index += log;
        return log - 1;
    }

    public static int decode_residual(H264Context h, GetBitContext gb, short[] block_base, int block_offset, int n, int[] scantable_base, int scantable_offset, long[] qmul_base, int qmul_offset, int max_coeff) {
        int zeros_left;
        int total_coeff;
        int coeff_token;
        int[] coeff_token_table_index = new int[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3};
        int[] level = new int[16];
        if (n >= 25) {
            coeff_token = gb.get_vlc2(CAVLCContext.chroma_dc_coeff_token_vlc.table_base, CAVLCContext.chroma_dc_coeff_token_vlc.table_offset, 8, 1, "coeff_token_CROMA_DC");
            total_coeff = coeff_token >> 2;
        } else if (n == 24) {
            total_coeff = CAVLCContext.pred_non_zero_count(h, 0);
            coeff_token = gb.get_vlc2(CAVLCContext.coeff_token_vlc[coeff_token_table_index[total_coeff]].table_base, CAVLCContext.coeff_token_vlc[coeff_token_table_index[total_coeff]].table_offset, 8, 2, "coeff_token_LUMA_DC");
            total_coeff = coeff_token >> 2;
        } else {
            total_coeff = CAVLCContext.pred_non_zero_count(h, n);
            coeff_token = gb.get_vlc2(CAVLCContext.coeff_token_vlc[coeff_token_table_index[total_coeff]].table_base, CAVLCContext.coeff_token_vlc[coeff_token_table_index[total_coeff]].table_offset, 8, 2, "coeff_token_LUMA(2)_DC");
            total_coeff = coeff_token >> 2;
        }
        h.non_zero_count_cache[H264Context.scan8[n]] = total_coeff;
        if (total_coeff == 0) {
            return 0;
        }
        if (total_coeff > max_coeff) {
            return -1;
        }
        int trailing_ones = coeff_token & 3;
        int i = (int)gb.show_bits(3);
        gb.skip_bits(trailing_ones);
        level[0] = 1 - ((i & 4) >> 1);
        level[1] = 1 - (i & 2);
        level[2] = 1 - ((i & 1) << 1);
        if (trailing_ones < total_coeff) {
            int mask;
            int prefix;
            int suffix_length = (total_coeff > 10 ? 1 : 0) & (trailing_ones < 3 ? 1 : 0);
            int bitsi = (int)gb.show_bits(8);
            int level_code = cavlc_level_tab[suffix_length][bitsi][0];
            gb.skip_bits(cavlc_level_tab[suffix_length][bitsi][1]);
            if (level_code >= 100) {
                prefix = level_code - 100;
                if (prefix == 8) {
                    prefix += CAVLCContext.get_level_prefix(gb);
                }
                if (prefix < 14) {
                    level_code = suffix_length != 0 ? (int)((long)(prefix << 1) + gb.get_bits1("level_code")) : prefix;
                } else if (prefix == 14) {
                    level_code = suffix_length != 0 ? (int)((long)(prefix << 1) + gb.get_bits1("level_code")) : (int)((long)prefix + gb.get_bits(4, "level_code"));
                } else {
                    level_code = 30 + (int)gb.get_bits(prefix - 3, "level_code");
                    if (prefix >= 16) {
                        if (prefix > 28) {
                            return -1;
                        }
                        level_code += (1 << prefix - 3) - 4096;
                    }
                }
                if (trailing_ones < 3) {
                    level_code += 2;
                }
                suffix_length = 2;
                mask = -(level_code & 1);
                level[trailing_ones] = (2 + level_code >> 1 ^ mask) - mask;
            } else {
                level_code += (level_code >> 31 | 1) & -(trailing_ones < 3 ? 1 : 0);
                suffix_length = 1 + ((0xFFFFFFFFL & (long)(level_code + 3)) > 6L ? 1 : 0);
                level[trailing_ones] = level_code;
            }
            for (i = trailing_ones + 1; i < total_coeff; ++i) {
                int[] suffix_limit = new int[]{0, 3, 6, 12, 24, 48, Integer.MAX_VALUE};
                bitsi = (int)gb.show_bits(8);
                level_code = cavlc_level_tab[suffix_length][bitsi][0];
                gb.skip_bits(cavlc_level_tab[suffix_length][bitsi][1]);
                if (level_code >= 100) {
                    prefix = level_code - 100;
                    if (prefix == 8) {
                        prefix += CAVLCContext.get_level_prefix(gb);
                    }
                    if (prefix < 15) {
                        level_code = (int)((long)(prefix << suffix_length) + gb.get_bits(suffix_length, "level_code"));
                    } else {
                        level_code = (int)((long)(15 << suffix_length) + gb.get_bits(prefix - 3, "level_code"));
                        if (prefix >= 16) {
                            level_code += (1 << prefix - 3) - 4096;
                        }
                    }
                    mask = -(level_code & 1);
                    level_code = (2 + level_code >> 1 ^ mask) - mask;
                }
                level[i] = level_code;
                suffix_length += (0xFFFFFFFFL & (long)(suffix_limit[suffix_length] + level_code)) > 2L * (long)suffix_limit[suffix_length] ? 1 : 0;
            }
        }
        if ((scantable_offset += (zeros_left = total_coeff == max_coeff ? 0 : (n >= 25 ? gb.get_vlc2(CAVLCContext.chroma_dc_total_zeros_vlc[total_coeff - 1].table_base, CAVLCContext.chroma_dc_total_zeros_vlc[total_coeff - 1].table_offset, 3, 1, "coeff_token_CROMA_DC_TOTAL_ZERO") : gb.get_vlc2(CAVLCContext.total_zeros_vlc[total_coeff - 1].table_base, CAVLCContext.total_zeros_vlc[total_coeff - 1].table_offset, 9, 1, "coeff_token_TOTAL_ZEROS"))) + total_coeff - 1) < 0) {
            int[] new_scantable_base = new int[scantable_base.length + -scantable_offset];
            System.arraycopy(scantable_base, 0, new_scantable_base, -scantable_offset, scantable_base.length);
            scantable_base = new_scantable_base;
            scantable_offset = 0;
        }
        if (n >= 24) {
            int run_before;
            block_base[block_offset + scantable_base[scantable_offset]] = (short)level[0];
            for (i = 1; i < total_coeff && zeros_left > 0; zeros_left -= run_before, ++i) {
                run_before = zeros_left < 7 ? gb.get_vlc2(CAVLCContext.run_vlc[zeros_left - 1].table_base, CAVLCContext.run_vlc[zeros_left - 1].table_offset, 3, 1, "RUN_VLC") : gb.get_vlc2(CAVLCContext.run7_vlc.table_base, CAVLCContext.run7_vlc.table_offset, 6, 2, "RUN7_VLC");
                block_base[block_offset + scantable_base[scantable_offset -= 1 + run_before]] = (short)level[i];
            }
            while (i < total_coeff) {
                block_base[block_offset + scantable_base[--scantable_offset]] = (short)level[i];
                ++i;
            }
        } else {
            int run_before;
            block_base[block_offset + scantable_base[scantable_offset]] = (short)((long)level[0] * qmul_base[qmul_offset + scantable_base[scantable_offset]] + 32L >> 6);
            for (i = 1; i < total_coeff && zeros_left > 0; zeros_left -= run_before, ++i) {
                run_before = zeros_left < 7 ? gb.get_vlc2(CAVLCContext.run_vlc[zeros_left - 1].table_base, CAVLCContext.run_vlc[zeros_left - 1].table_offset, 3, 1, "RUN_VLC") : gb.get_vlc2(CAVLCContext.run7_vlc.table_base, CAVLCContext.run7_vlc.table_offset, 6, 2, "RUN7_VLC");
                block_base[block_offset + scantable_base[scantable_offset -= 1 + run_before]] = (short)((long)level[i] * qmul_base[qmul_offset + scantable_base[scantable_offset]] + 32L >> 6);
            }
            while (i < total_coeff) {
                block_base[block_offset + scantable_base[--scantable_offset]] = (short)((long)level[i] * qmul_base[qmul_offset + scantable_base[scantable_offset]] + 32L >> 6);
                ++i;
            }
        }
        if (zeros_left < 0) {
            return -1;
        }
        return 0;
    }

    public int ff_h264_decode_mb_cavlc(H264Context h) {
        short partition_count;
        MpegEncContext s = h.s;
        int dct8x8_allowed = h.pps.transform_8x8_mode;
        int mb_xy = h.mb_xy = s.mb_x + s.mb_y * s.mb_stride;
        int cbp = 0;
        if (h.slice_type_nos != 1) {
            if (s.mb_skip_run == -1) {
                s.mb_skip_run = s.gb.get_ue_golomb("mb_skip_run");
            }
            if (0 != s.mb_skip_run--) {
                if (h.mb_aff_frame != 0 && (s.mb_y & 1) == 0 && s.mb_skip_run == 0) {
                    h.mb_mbaff = h.mb_field_decoding_flag = (int)s.gb.get_bits1("mb_mbaff");
                }
                h.decode_mb_skip();
                return 0;
            }
        }
        if (h.mb_aff_frame != 0 && (s.mb_y & 1) == 0) {
            h.mb_mbaff = h.mb_field_decoding_flag = (int)s.gb.get_bits1("mb_field_decoding_flag");
        }
        h.prev_mb_skipped = 0;
        int mb_type = s.gb.get_ue_golomb("mb_type");
        if (h.slice_type_nos == 3) {
            if (mb_type < 23) {
                partition_count = H264Data.b_mb_type_info[mb_type].partition_count;
                mb_type = H264Data.b_mb_type_info[mb_type].type;
            } else {
                if ((mb_type -= 23) > 25) {
                    return -1;
                }
                partition_count = 0;
                cbp = H264Data.i_mb_type_info[mb_type].cbp;
                h.intra16x16_pred_mode = H264Data.i_mb_type_info[mb_type].pred_mode;
                mb_type = H264Data.i_mb_type_info[mb_type].type;
            }
        } else if (h.slice_type_nos == 2) {
            if (mb_type < 5) {
                partition_count = H264Data.p_mb_type_info[mb_type].partition_count;
                mb_type = H264Data.p_mb_type_info[mb_type].type;
            } else {
                if ((mb_type -= 5) > 25) {
                    return -1;
                }
                partition_count = 0;
                cbp = H264Data.i_mb_type_info[mb_type].cbp;
                h.intra16x16_pred_mode = H264Data.i_mb_type_info[mb_type].pred_mode;
                mb_type = H264Data.i_mb_type_info[mb_type].type;
            }
        } else {
            if (h.slice_type == 5 && mb_type != 0) {
                --mb_type;
            }
            if (mb_type > 25) {
                return -1;
            }
            partition_count = 0;
            cbp = H264Data.i_mb_type_info[mb_type].cbp;
            h.intra16x16_pred_mode = H264Data.i_mb_type_info[mb_type].pred_mode;
            mb_type = H264Data.i_mb_type_info[mb_type].type;
        }
        if (h.mb_field_decoding_flag != 0) {
            mb_type |= 0x80;
        }
        h.slice_table_base[h.slice_table_offset + mb_xy] = h.slice_num;
        if (0 != (mb_type & 4)) {
            s.gb.align_get_bits();
            for (int x = 0; x < (h.sps.chroma_format_idc != 0 ? 384 : 256); x += 2) {
                int val = (int)s.gb.get_bits(8, "val");
                h.mb[x / 2] = (short)(val |= (int)s.gb.get_bits(8, "val") << 8);
            }
            s.current_picture.qscale_table[mb_xy] = 0;
            Arrays.fill(h.non_zero_count[mb_xy], 0, 32, 16);
            s.current_picture.mb_type_base[s.current_picture.mb_type_offset + mb_xy] = mb_type;
            return 0;
        }
        if (h.mb_mbaff != 0) {
            h.ref_count[0] = h.ref_count[0] << 1;
            h.ref_count[1] = h.ref_count[1] << 1;
        }
        h.fill_decode_neighbors(mb_type);
        h.fill_decode_caches(mb_type);
        if (0 != (mb_type & 7)) {
            if (0 != (mb_type & 1)) {
                int di = 1;
                if (dct8x8_allowed != 0 && s.gb.get_bits1("MB_TYPE_8x8DCT?") != 0L) {
                    mb_type |= 0x1000000;
                    di = 4;
                }
                for (int i = 0; i < 16; i += di) {
                    int mode = h.pred_intra_mode(i);
                    if (0L == s.gb.get_bits1("rem_mode")) {
                        int rem_mode;
                        mode = rem_mode + ((rem_mode = (int)s.gb.get_bits(3, "rem_mode")) >= mode ? 1 : 0);
                    }
                    if (di == 4) {
                        Rectangle.fill_rectangle_sign(h.intra4x4_pred_mode_cache, H264Context.scan8[i], 2, 2, 8, mode, 1);
                        continue;
                    }
                    h.intra4x4_pred_mode_cache[H264Context.scan8[i]] = mode;
                }
                h.ff_h264_write_back_intra_pred_mode();
                if (h.ff_h264_check_intra4x4_pred_mode() < 0) {
                    return -1;
                }
            } else {
                h.intra16x16_pred_mode = h.ff_h264_check_intra_pred_mode(h.intra16x16_pred_mode);
                if (h.intra16x16_pred_mode < 0) {
                    return -1;
                }
            }
            if (h.sps.chroma_format_idc != 0) {
                int pred_mode = h.ff_h264_check_intra_pred_mode(s.gb.get_ue_golomb_31("pred_mode"));
                if (pred_mode < 0) {
                    return -1;
                }
                h.chroma_pred_mode = pred_mode;
            }
        } else if (partition_count == 4) {
            int i;
            int[] sub_partition_count = new int[4];
            int[][] ref = new int[2][4];
            if (h.slice_type_nos == 3) {
                for (i = 0; i < 4; ++i) {
                    h.sub_mb_type[i] = s.gb.get_ue_golomb_31("sub_mb_type");
                    if (h.sub_mb_type[i] >= 13) {
                        return -1;
                    }
                    sub_partition_count[i] = H264Data.b_sub_mb_type_info[h.sub_mb_type[i]].partition_count;
                    h.sub_mb_type[i] = H264Data.b_sub_mb_type_info[h.sub_mb_type[i]].type;
                }
                if (0 != ((h.sub_mb_type[0] | h.sub_mb_type[1] | h.sub_mb_type[2] | h.sub_mb_type[3]) & 0x100)) {
                    mb_type = h.ff_h264_pred_direct_motion(mb_type);
                    h.ref_cache[1][H264Context.scan8[12]] = -2;
                    h.ref_cache[0][H264Context.scan8[12]] = -2;
                    h.ref_cache[1][H264Context.scan8[4]] = -2;
                    h.ref_cache[0][H264Context.scan8[4]] = -2;
                }
            } else {
                for (i = 0; i < 4; ++i) {
                    h.sub_mb_type[i] = s.gb.get_ue_golomb_31("sub_mb_type");
                    if (h.sub_mb_type[i] >= 4) {
                        return -1;
                    }
                    sub_partition_count[i] = H264Data.p_sub_mb_type_info[h.sub_mb_type[i]].partition_count;
                    h.sub_mb_type[i] = H264Data.p_sub_mb_type_info[h.sub_mb_type[i]].type;
                }
            }
            int list = 0;
            while ((long)list < h.list_count) {
                int ref_count = (mb_type & 0x200) != 0 ? 1 : (int)h.ref_count[list];
                for (i = 0; i < 4; ++i) {
                    if (0 != (h.sub_mb_type[i] & 0x100)) continue;
                    if (0 != (h.sub_mb_type[i] & 4096 << 0 + 2 * list)) {
                        int tmp;
                        if (ref_count == 1) {
                            tmp = 0;
                        } else if (ref_count == 2) {
                            tmp = (int)s.gb.get_bits1("ref_count?") ^ 1;
                        } else {
                            tmp = s.gb.get_ue_golomb_31("ref_count?");
                            if (tmp >= ref_count) {
                                return -1;
                            }
                        }
                        ref[list][i] = tmp;
                        continue;
                    }
                    ref[list][i] = -1;
                }
                ++list;
            }
            if (dct8x8_allowed != 0) {
                dct8x8_allowed = h.get_dct8x8_allowed();
            }
            list = 0;
            while ((long)list < h.list_count) {
                for (i = 0; i < 4; ++i) {
                    if (0 != (h.sub_mb_type[i] & 0x100)) {
                        h.ref_cache[list][H264Context.scan8[4 * i]] = h.ref_cache[list][H264Context.scan8[4 * i] + 1];
                        continue;
                    }
                    int n = ref[list][i];
                    h.ref_cache[list][H264Context.scan8[4 * i] + 9] = n;
                    h.ref_cache[list][H264Context.scan8[4 * i] + 8] = n;
                    h.ref_cache[list][H264Context.scan8[4 * i] + 1] = n;
                    h.ref_cache[list][H264Context.scan8[4 * i]] = n;
                    if ((h.sub_mb_type[i] & 4096 << 0 + 2 * list) != 0) {
                        int sub_mb_type = h.sub_mb_type[i];
                        int block_width = (sub_mb_type & 0x18) != 0 ? 2 : 1;
                        for (int j = 0; j < sub_partition_count[i]; ++j) {
                            int index = 4 * i + block_width * j;
                            int[][] mv_cache_base = h.mv_cache[list];
                            short my_cache_offset = H264Context.scan8[index];
                            int[] mxmy = new int[2];
                            h.pred_motion(index, block_width, list, h.ref_cache[list][H264Context.scan8[index]], mxmy);
                            int mx = mxmy[0];
                            int my = mxmy[1];
                            mx += s.gb.get_se_golomb("mx?");
                            my += s.gb.get_se_golomb("my?");
                            if (0 != (sub_mb_type & 8)) {
                                int n2 = mx;
                                mv_cache_base[my_cache_offset + 9][0] = n2;
                                mv_cache_base[my_cache_offset + 8][0] = n2;
                                mv_cache_base[my_cache_offset + 1][0] = n2;
                                int n3 = my;
                                mv_cache_base[my_cache_offset + 9][1] = n3;
                                mv_cache_base[my_cache_offset + 8][1] = n3;
                                mv_cache_base[my_cache_offset + 1][1] = n3;
                            } else if (0 != (sub_mb_type & 0x10)) {
                                mv_cache_base[my_cache_offset + 1][0] = mx;
                                mv_cache_base[my_cache_offset + 1][1] = my;
                            } else if (0 != (sub_mb_type & 0x20)) {
                                mv_cache_base[my_cache_offset + 8][0] = mx;
                                mv_cache_base[my_cache_offset + 8][1] = my;
                            }
                            mv_cache_base[my_cache_offset + 0][0] = mx;
                            mv_cache_base[my_cache_offset + 0][1] = my;
                        }
                        continue;
                    }
                    h.mv_cache[list][H264Context.scan8[4 * i] + 0][0] = 0;
                    h.mv_cache[list][H264Context.scan8[4 * i] + 1][0] = 0;
                    h.mv_cache[list][H264Context.scan8[4 * i] + 8][0] = 0;
                    h.mv_cache[list][H264Context.scan8[4 * i] + 9][0] = 0;
                    h.mv_cache[list][H264Context.scan8[4 * i] + 0][1] = 0;
                    h.mv_cache[list][H264Context.scan8[4 * i] + 1][1] = 0;
                    h.mv_cache[list][H264Context.scan8[4 * i] + 8][1] = 0;
                    h.mv_cache[list][H264Context.scan8[4 * i] + 9][1] = 0;
                }
                ++list;
            }
        } else if (0 != (mb_type & 0x100)) {
            mb_type = h.ff_h264_pred_direct_motion(mb_type);
            dct8x8_allowed &= h.sps.direct_8x8_inference_flag;
        } else {
            int i;
            int list;
            int mx = 0;
            int my = 0;
            if (0 != (mb_type & 8)) {
                list = 0;
                while ((long)list < h.list_count) {
                    if ((mb_type & 4096 << 0 + 2 * list) != 0) {
                        int val;
                        if (h.ref_count[list] == 1L) {
                            val = 0;
                        } else if (h.ref_count[list] == 2L) {
                            val = (int)(s.gb.get_bits1("ref_count?") ^ 1L);
                        } else {
                            val = s.gb.get_ue_golomb_31("ref_count?");
                            if ((long)val >= h.ref_count[list]) {
                                return -1;
                            }
                        }
                        Rectangle.fill_rectangle_sign(h.ref_cache[list], H264Context.scan8[0], 4, 4, 8, val, 1);
                    }
                    ++list;
                }
                list = 0;
                while ((long)list < h.list_count) {
                    if ((mb_type & 4096 << 0 + 2 * list) != 0) {
                        int[] mxmy = new int[]{mx, my};
                        h.pred_motion(0, 4, list, h.ref_cache[list][H264Context.scan8[0]], mxmy);
                        mx = mxmy[0];
                        my = mxmy[1];
                        Rectangle.fill_rectangle_mv_cache(h.mv_cache[list], H264Context.scan8[0], 4, 4, 8, H264Context.pack16to32(mx += s.gb.get_se_golomb("mx?"), my += s.gb.get_se_golomb("my?")), 4);
                    }
                    ++list;
                }
            } else if (0 != (mb_type & 0x10)) {
                int val;
                list = 0;
                while ((long)list < h.list_count) {
                    for (i = 0; i < 2; ++i) {
                        if ((mb_type & 4096 << i + 2 * list) != 0) {
                            if (h.ref_count[list] == 1L) {
                                val = 0;
                            } else if (h.ref_count[list] == 2L) {
                                val = (int)(s.gb.get_bits1("ref_count?") ^ 1L);
                            } else {
                                val = s.gb.get_ue_golomb_31("ref_count?");
                                if ((long)val >= h.ref_count[list]) {
                                    return -1;
                                }
                            }
                        } else {
                            val = -1;
                        }
                        Rectangle.fill_rectangle_sign(h.ref_cache[list], H264Context.scan8[0] + 16 * i, 4, 2, 8, val, 1);
                    }
                    ++list;
                }
                list = 0;
                while ((long)list < h.list_count) {
                    for (i = 0; i < 2; ++i) {
                        if ((mb_type & 4096 << i + 2 * list) != 0) {
                            int[] mxmy = new int[]{mx, my};
                            h.pred_16x8_motion(8 * i, list, h.ref_cache[list][H264Context.scan8[0] + 16 * i], mxmy);
                            mx = mxmy[0];
                            my = mxmy[1];
                            val = H264Context.pack16to32(mx += s.gb.get_se_golomb("mx?"), my += s.gb.get_se_golomb("my?"));
                        } else {
                            val = 0;
                        }
                        Rectangle.fill_rectangle_mv_cache(h.mv_cache[list], H264Context.scan8[0] + 16 * i, 4, 2, 8, val, 4);
                    }
                    ++list;
                }
            } else {
                int val;
                list = 0;
                while ((long)list < h.list_count) {
                    for (i = 0; i < 2; ++i) {
                        if ((mb_type & 4096 << i + 2 * list) != 0) {
                            if (h.ref_count[list] == 1L) {
                                val = 0;
                            } else if (h.ref_count[list] == 2L) {
                                val = (int)(s.gb.get_bits1("ref-count?") ^ 1L);
                            } else {
                                val = s.gb.get_ue_golomb_31("ref-count?");
                                if ((long)val >= h.ref_count[list]) {
                                    return -1;
                                }
                            }
                        } else {
                            val = -1;
                        }
                        Rectangle.fill_rectangle_sign(h.ref_cache[list], H264Context.scan8[0] + 2 * i, 2, 4, 8, val, 1);
                    }
                    ++list;
                }
                list = 0;
                while ((long)list < h.list_count) {
                    for (i = 0; i < 2; ++i) {
                        if ((mb_type & 4096 << i + 2 * list) != 0) {
                            int[] mxmy = new int[]{mx, my};
                            h.pred_8x16_motion(i * 4, list, h.ref_cache[list][H264Context.scan8[0] + 2 * i], mxmy);
                            mx = mxmy[0];
                            my = mxmy[1];
                            val = H264Context.pack16to32(mx += s.gb.get_se_golomb("mx?"), my += s.gb.get_se_golomb("my?"));
                        } else {
                            val = 0;
                        }
                        Rectangle.fill_rectangle_mv_cache(h.mv_cache[list], H264Context.scan8[0] + 2 * i, 2, 4, 8, val, 4);
                    }
                    ++list;
                }
            }
        }
        if (0 != (mb_type & 0x78)) {
            h.write_back_motion(mb_type);
        }
        if (0 == (mb_type & 2)) {
            cbp = s.gb.get_ue_golomb("cbp");
            if (cbp > 47) {
                return -1;
            }
            cbp = h.sps.chroma_format_idc != 0 ? (0 != (mb_type & 1) ? H264Data.golomb_to_intra4x4_cbp[cbp] : H264Data.golomb_to_inter_cbp[cbp]) : (0 != (mb_type & 1) ? golomb_to_intra4x4_cbp_gray[cbp] : golomb_to_inter_cbp_gray[cbp]);
        }
        if (dct8x8_allowed != 0 && (cbp & 0xF) != 0 && 0 == (mb_type & 7)) {
            mb_type = (int)((long)mb_type | 0x1000000L * s.gb.get_bits1("mb_type"));
        }
        h.cbp = h.cbp_table[mb_xy] = cbp;
        s.current_picture.mb_type_base[s.current_picture.mb_type_offset + mb_xy] = mb_type;
        if (cbp != 0 || 0 != (mb_type & 2)) {
            int i4x4;
            int i8x8;
            int[] scan;
            int[] scan8x8;
            GetBitContext gb;
            GetBitContext getBitContext = gb = (mb_type & 7) != 0 ? h.intra_gb_ptr : h.inter_gb_ptr;
            if (0 != (mb_type & 0x80)) {
                scan8x8 = s.qscale != 0 ? h.field_scan8x8_cavlc : h.field_scan8x8_cavlc_q0;
                scan = s.qscale != 0 ? h.field_scan : h.field_scan_q0;
            } else {
                scan8x8 = s.qscale != 0 ? h.zigzag_scan8x8_cavlc : h.zigzag_scan8x8_cavlc_q0;
                scan = s.qscale != 0 ? h.zigzag_scan : h.zigzag_scan_q0;
            }
            int dquant = s.gb.get_se_golomb("dquant");
            s.qscale += dquant;
            if (s.qscale > 51 || s.qscale < 0) {
                s.qscale = s.qscale < 0 ? (s.qscale += 52) : (s.qscale -= 52);
                if (s.qscale > 51 || s.qscale < 0) {
                    return -1;
                }
            }
            h.chroma_qp[0] = h.pps.chroma_qp_table[0][s.qscale];
            h.chroma_qp[1] = h.pps.chroma_qp_table[1][s.qscale];
            if (0 != (mb_type & 2)) {
                Arrays.fill(h.mb_luma_dc, 0, 16, (short)0);
                if (CAVLCContext.decode_residual(h, h.intra_gb_ptr, h.mb_luma_dc, 0, 24, scan, 0, h.dequant4_coeff[0][s.qscale], 0, 16) < 0) {
                    return -1;
                }
                if ((cbp & 0xF) != 0) {
                    for (i8x8 = 0; i8x8 < 4; ++i8x8) {
                        for (i4x4 = 0; i4x4 < 4; ++i4x4) {
                            int index = i4x4 + 4 * i8x8;
                            if (CAVLCContext.decode_residual(h, h.intra_gb_ptr, h.mb, 16 * index, index, scan, 1, h.dequant4_coeff[0][s.qscale], 0, 15) >= 0) continue;
                            return -1;
                        }
                    }
                } else {
                    Rectangle.fill_rectangle_unsign(h.non_zero_count_cache, H264Context.scan8[0], 4, 4, 8, 0, 1);
                }
            } else {
                for (i8x8 = 0; i8x8 < 4; ++i8x8) {
                    if ((cbp & 1 << i8x8) != 0) {
                        if (0 != (mb_type & 0x1000000)) {
                            short[] buf_base = h.mb;
                            int buf_offset = 64 * i8x8;
                            for (i4x4 = 0; i4x4 < 4; ++i4x4) {
                                if (CAVLCContext.decode_residual(h, gb, buf_base, buf_offset, i4x4 + 4 * i8x8, scan8x8, 16 * i4x4, h.dequant8_coeff[0 != (mb_type & 7) ? 0 : 1][s.qscale], 0, 16) >= 0) continue;
                                return -1;
                            }
                            int[] nnz_base = h.non_zero_count_cache;
                            short nnz_offset = H264Context.scan8[4 * i8x8];
                            int n = nnz_offset + 0;
                            nnz_base[n] = nnz_base[n] + (nnz_base[nnz_offset + 1] + nnz_base[nnz_offset + 8] + nnz_base[nnz_offset + 9]);
                            continue;
                        }
                        for (i4x4 = 0; i4x4 < 4; ++i4x4) {
                            int index = i4x4 + 4 * i8x8;
                            if (CAVLCContext.decode_residual(h, gb, h.mb, 16 * index, index, scan, 0, h.dequant4_coeff[(mb_type & 7) != 0 ? 0 : 3][s.qscale], 0, 16) >= 0) continue;
                            return -1;
                        }
                        continue;
                    }
                    int[] nnz_base = h.non_zero_count_cache;
                    short nnz_offset = H264Context.scan8[4 * i8x8];
                    nnz_base[nnz_offset + 9] = 0;
                    nnz_base[nnz_offset + 8] = 0;
                    nnz_base[nnz_offset + 1] = 0;
                    nnz_base[nnz_offset + 0] = 0;
                }
            }
            if ((cbp & 0x30) != 0) {
                Arrays.fill(h.mb_chroma_dc[0], (short)0);
                Arrays.fill(h.mb_chroma_dc[1], (short)0);
                for (int chroma_idx = 0; chroma_idx < 2; ++chroma_idx) {
                    if (CAVLCContext.decode_residual(h, gb, h.mb_chroma_dc[chroma_idx], 0, 25 + chroma_idx, H264Data.chroma_dc_scan, 0, null, 0, 4) >= 0) continue;
                    return -1;
                }
            }
            if ((cbp & 0x20) != 0) {
                for (int chroma_idx = 0; chroma_idx < 2; ++chroma_idx) {
                    long[] qmul = h.dequant4_coeff[chroma_idx + 1 + ((mb_type & 7) != 0 ? 0 : 3)][h.chroma_qp[chroma_idx]];
                    for (i4x4 = 0; i4x4 < 4; ++i4x4) {
                        int index = 16 + 4 * chroma_idx + i4x4;
                        if (CAVLCContext.decode_residual(h, gb, h.mb, 16 * index, index, scan, 1, qmul, 0, 15) >= 0) continue;
                        return -1;
                    }
                }
            } else {
                int[] nnz = h.non_zero_count_cache;
                nnz[H264Context.scan8[20] + 9] = 0;
                nnz[H264Context.scan8[20] + 8] = 0;
                nnz[H264Context.scan8[20] + 1] = 0;
                nnz[H264Context.scan8[20] + 0] = 0;
                nnz[H264Context.scan8[16] + 9] = 0;
                nnz[H264Context.scan8[16] + 8] = 0;
                nnz[H264Context.scan8[16] + 1] = 0;
                nnz[H264Context.scan8[16] + 0] = 0;
            }
        } else {
            int[] nnz = h.non_zero_count_cache;
            Rectangle.fill_rectangle_unsign(nnz, H264Context.scan8[0], 4, 4, 8, 0, 1);
            nnz[H264Context.scan8[20] + 9] = 0;
            nnz[H264Context.scan8[20] + 8] = 0;
            nnz[H264Context.scan8[20] + 1] = 0;
            nnz[H264Context.scan8[20] + 0] = 0;
            nnz[H264Context.scan8[16] + 9] = 0;
            nnz[H264Context.scan8[16] + 8] = 0;
            nnz[H264Context.scan8[16] + 1] = 0;
            nnz[H264Context.scan8[16] + 0] = 0;
        }
        s.current_picture.qscale_table[mb_xy] = s.qscale;
        h.write_back_non_zero_count();
        if (h.mb_mbaff != 0) {
            h.ref_count[0] = h.ref_count[0] >> 1;
            h.ref_count[1] = h.ref_count[1] >> 1;
        }
        return 0;
    }
}

