/*
 * Decompiled with CFR 0.152.
 */
package com.twilight.h264.decoder;

import com.twilight.h264.decoder.H264DSPContext;
import com.twilight.h264.decoder.MpegEncContext;
import com.twilight.h264.util.Arrays;

public class DSPContext {
    public static final int FF_NO_IDCT_PERM = 1;
    public int[] idct_permutation = new int[64];
    public int idct_permutation_type;
    public static Ih264_qpel_mc_func[][] put_h264_qpel_pixels_tab = new Ih264_qpel_mc_func[4][16];
    public static Ih264_qpel_mc_func[][] avg_h264_qpel_pixels_tab = new Ih264_qpel_mc_func[4][16];
    public Ih264_chroma_mc_func[] put_h264_chroma_pixels_tab = new Ih264_chroma_mc_func[3];
    public Ih264_chroma_mc_func[] avg_h264_chroma_pixels_tab = new Ih264_chroma_mc_func[3];

    public void draw_edges(int[] buf_base, int buf_offset, int wrap, int width, int height, int w) {
        int i;
        int[] last_line_base = buf_base;
        int last_line_offset = buf_offset + (height - 1) * wrap;
        for (i = 0; i < w; ++i) {
            System.arraycopy(buf_base, buf_offset, buf_base, buf_offset - (i + 1) * wrap, width);
            System.arraycopy(last_line_base, last_line_offset, last_line_base, last_line_offset + (i + 1) * wrap, width);
        }
        int[] ptr_base = buf_base;
        int ptr_offset = buf_offset;
        for (i = 0; i < height; ++i) {
            Arrays.fill(ptr_base, ptr_offset - w, ptr_offset - w + w, ptr_base[ptr_offset]);
            Arrays.fill(ptr_base, ptr_offset + width, ptr_offset + width + w, ptr_base[ptr_offset + width - 1]);
            ptr_offset += wrap;
        }
        for (i = 0; i < w; ++i) {
            Arrays.fill(buf_base, buf_offset - (i + 1) * wrap - w, buf_offset - (i + 1) * wrap - w + w, buf_base[buf_offset]);
            Arrays.fill(buf_base, buf_offset - (i + 1) * wrap + width, buf_offset - (i + 1) * wrap + width + w, buf_base[buf_offset + width - 1]);
            Arrays.fill(last_line_base, last_line_offset + (i + 1) * wrap - w, last_line_offset + (i + 1) * wrap - w + w, last_line_base[last_line_offset]);
            Arrays.fill(last_line_base, last_line_offset + (i + 1) * wrap + width, last_line_offset + (i + 1) * wrap + width + w, last_line_base[last_line_offset + width - 1]);
        }
    }

    public void ff_emulated_edge_mc(int[] buf_base, int buf_offset, int[] src_base, int src_offset, int linesize, int block_w, int block_h, int src_x, int src_y, int w, int h) {
        int x;
        int y;
        if (src_y >= h) {
            src_offset += (h - 1 - src_y) * linesize;
            src_y = h - 1;
        } else if (src_y <= -block_h) {
            src_offset += (1 - block_h - src_y) * linesize;
            src_y = 1 - block_h;
        }
        if (src_x >= w) {
            src_offset += w - 1 - src_x;
            src_x = w - 1;
        } else if (src_x <= -block_w) {
            src_offset += 1 - block_w - src_x;
            src_x = 1 - block_w;
        }
        int start_y = Math.max(0, -src_y);
        int start_x = Math.max(0, -src_x);
        int end_y = Math.min(block_h, h - src_y);
        int end_x = Math.min(block_w, w - src_x);
        for (y = start_y; y < end_y; ++y) {
            for (x = start_x; x < end_x; ++x) {
                buf_base[buf_offset + x + y * linesize] = src_base[src_offset + x + y * linesize];
            }
        }
        for (y = 0; y < start_y; ++y) {
            for (x = start_x; x < end_x; ++x) {
                buf_base[buf_offset + x + y * linesize] = buf_base[buf_offset + x + start_y * linesize];
            }
        }
        for (y = end_y; y < block_h; ++y) {
            for (x = start_x; x < end_x; ++x) {
                buf_base[buf_offset + x + y * linesize] = buf_base[buf_offset + x + (end_y - 1) * linesize];
            }
        }
        for (y = 0; y < block_h; ++y) {
            for (x = 0; x < start_x; ++x) {
                buf_base[buf_offset + x + y * linesize] = buf_base[buf_offset + start_x + y * linesize];
            }
            for (x = end_x; x < block_w; ++x) {
                buf_base[buf_offset + x + y * linesize] = buf_base[buf_offset + end_x - 1 + y * linesize];
            }
        }
    }

    public void add_pixels8(int[] pixels, int pixel_offset, short[] block, int block_offset, int line_size) {
        for (int i = 0; i < 8; ++i) {
            int n = pixel_offset + 0;
            pixels[n] = pixels[n] + block[block_offset + 0];
            int n2 = pixel_offset + 1;
            pixels[n2] = pixels[n2] + block[block_offset + 1];
            int n3 = pixel_offset + 2;
            pixels[n3] = pixels[n3] + block[block_offset + 2];
            int n4 = pixel_offset + 3;
            pixels[n4] = pixels[n4] + block[block_offset + 3];
            int n5 = pixel_offset + 4;
            pixels[n5] = pixels[n5] + block[block_offset + 4];
            int n6 = pixel_offset + 5;
            pixels[n6] = pixels[n6] + block[block_offset + 5];
            int n7 = pixel_offset + 6;
            pixels[n7] = pixels[n7] + block[block_offset + 6];
            int n8 = pixel_offset + 7;
            pixels[n8] = pixels[n8] + block[block_offset + 7];
            pixel_offset += line_size;
            block_offset += 8;
        }
    }

    public void add_pixels4(int[] pixels, int pixel_offset, short[] block, int block_offset, int line_size) {
        for (int i = 0; i < 4; ++i) {
            int n = pixel_offset + 0;
            pixels[n] = pixels[n] + block[block_offset + 0];
            int n2 = pixel_offset + 1;
            pixels[n2] = pixels[n2] + block[block_offset + 1];
            int n3 = pixel_offset + 2;
            pixels[n3] = pixels[n3] + block[block_offset + 2];
            int n4 = pixel_offset + 3;
            pixels[n4] = pixels[n4] + block[block_offset + 3];
            pixel_offset += line_size;
            block_offset += 4;
        }
    }

    public void clear_block(short[] block) {
        Arrays.fill(block, 0, 64, (short)0);
    }

    public void clear_blocks(short[][] blocks, int first_block_index) {
        for (int i = 0; i < 6; ++i) {
            Arrays.fill(blocks[first_block_index], 0, 64, (short)0);
        }
    }

    public void clear_blocks(short[] blocks) {
        Arrays.fill(blocks, 0, 384, (short)0);
    }

    private static int OP_AVG(int a, int b) {
        return a + (b + 32 >> 6) + 1 >> 1;
    }

    private static int OP_PUT(int a, int b) {
        return b + 32 >> 6;
    }

    public void put_h264_chroma_mc2_c(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride, int h, int x, int y) {
        int A = (8 - x) * (8 - y);
        int B = x * (8 - y);
        int C = (8 - x) * y;
        int D = x * y;
        if (D != 0) {
            for (int i = 0; i < h; ++i) {
                dst_base[dst_offset + 0] = DSPContext.OP_PUT(dst_base[dst_offset + 0], A * src_base[src_offset + 0] + B * src_base[src_offset + 1] + C * src_base[src_offset + stride + 0] + D * src_base[src_offset + stride + 1]);
                dst_base[dst_offset + 1] = DSPContext.OP_PUT(dst_base[dst_offset + 1], A * src_base[src_offset + 1] + B * src_base[src_offset + 2] + C * src_base[src_offset + stride + 1] + D * src_base[src_offset + stride + 2]);
                dst_offset += stride;
                src_offset += stride;
            }
        } else {
            int E = B + C;
            int step = C != 0 ? stride : 1;
            for (int i = 0; i < h; ++i) {
                dst_base[dst_offset + 0] = DSPContext.OP_PUT(dst_base[dst_offset + 0], A * src_base[src_offset + 0] + E * src_base[src_offset + step + 0]);
                dst_base[dst_offset + 1] = DSPContext.OP_PUT(dst_base[dst_offset + 1], A * src_base[src_offset + 1] + E * src_base[src_offset + step + 1]);
                dst_offset += stride;
                src_offset += stride;
            }
        }
    }

    public void put_h264_chroma_mc4_c(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride, int h, int x, int y) {
        int A = (8 - x) * (8 - y);
        int B = x * (8 - y);
        int C = (8 - x) * y;
        int D = x * y;
        if (D != 0) {
            for (int i = 0; i < h; ++i) {
                dst_base[dst_offset + 0] = DSPContext.OP_PUT(dst_base[dst_offset + 0], A * src_base[src_offset + 0] + B * src_base[src_offset + 1] + C * src_base[src_offset + stride + 0] + D * src_base[src_offset + stride + 1]);
                dst_base[dst_offset + 1] = DSPContext.OP_PUT(dst_base[dst_offset + 1], A * src_base[src_offset + 1] + B * src_base[src_offset + 2] + C * src_base[src_offset + stride + 1] + D * src_base[src_offset + stride + 2]);
                dst_base[dst_offset + 2] = DSPContext.OP_PUT(dst_base[dst_offset + 2], A * src_base[src_offset + 2] + B * src_base[src_offset + 3] + C * src_base[src_offset + stride + 2] + D * src_base[src_offset + stride + 3]);
                dst_base[dst_offset + 3] = DSPContext.OP_PUT(dst_base[dst_offset + 3], A * src_base[src_offset + 3] + B * src_base[src_offset + 4] + C * src_base[src_offset + stride + 3] + D * src_base[src_offset + stride + 4]);
                dst_offset += stride;
                src_offset += stride;
            }
        } else {
            int E = B + C;
            int step = C != 0 ? stride : 1;
            for (int i = 0; i < h; ++i) {
                dst_base[dst_offset + 0] = DSPContext.OP_PUT(dst_base[dst_offset + 0], A * src_base[src_offset + 0] + E * src_base[src_offset + step + 0]);
                dst_base[dst_offset + 1] = DSPContext.OP_PUT(dst_base[dst_offset + 1], A * src_base[src_offset + 1] + E * src_base[src_offset + step + 1]);
                dst_base[dst_offset + 2] = DSPContext.OP_PUT(dst_base[dst_offset + 2], A * src_base[src_offset + 2] + E * src_base[src_offset + step + 2]);
                dst_base[dst_offset + 3] = DSPContext.OP_PUT(dst_base[dst_offset + 3], A * src_base[src_offset + 3] + E * src_base[src_offset + step + 3]);
                dst_offset += stride;
                src_offset += stride;
            }
        }
    }

    public void put_h264_chroma_mc8_c(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride, int h, int x, int y) {
        int A = (8 - x) * (8 - y);
        int B = x * (8 - y);
        int C = (8 - x) * y;
        int D = x * y;
        if (D != 0) {
            for (int i = 0; i < h; ++i) {
                dst_base[dst_offset + 0] = DSPContext.OP_PUT(dst_base[dst_offset + 0], A * src_base[src_offset + 0] + B * src_base[src_offset + 1] + C * src_base[src_offset + stride + 0] + D * src_base[src_offset + stride + 1]);
                dst_base[dst_offset + 1] = DSPContext.OP_PUT(dst_base[dst_offset + 1], A * src_base[src_offset + 1] + B * src_base[src_offset + 2] + C * src_base[src_offset + stride + 1] + D * src_base[src_offset + stride + 2]);
                dst_base[dst_offset + 2] = DSPContext.OP_PUT(dst_base[dst_offset + 2], A * src_base[src_offset + 2] + B * src_base[src_offset + 3] + C * src_base[src_offset + stride + 2] + D * src_base[src_offset + stride + 3]);
                dst_base[dst_offset + 3] = DSPContext.OP_PUT(dst_base[dst_offset + 3], A * src_base[src_offset + 3] + B * src_base[src_offset + 4] + C * src_base[src_offset + stride + 3] + D * src_base[src_offset + stride + 4]);
                dst_base[dst_offset + 4] = DSPContext.OP_PUT(dst_base[dst_offset + 4], A * src_base[src_offset + 4] + B * src_base[src_offset + 5] + C * src_base[src_offset + stride + 4] + D * src_base[src_offset + stride + 5]);
                dst_base[dst_offset + 5] = DSPContext.OP_PUT(dst_base[dst_offset + 5], A * src_base[src_offset + 5] + B * src_base[src_offset + 6] + C * src_base[src_offset + stride + 5] + D * src_base[src_offset + stride + 6]);
                dst_base[dst_offset + 6] = DSPContext.OP_PUT(dst_base[dst_offset + 6], A * src_base[src_offset + 6] + B * src_base[src_offset + 7] + C * src_base[src_offset + stride + 6] + D * src_base[src_offset + stride + 7]);
                dst_base[dst_offset + 7] = DSPContext.OP_PUT(dst_base[dst_offset + 7], A * src_base[src_offset + 7] + B * src_base[src_offset + 8] + C * src_base[src_offset + stride + 7] + D * src_base[src_offset + stride + 8]);
                dst_offset += stride;
                src_offset += stride;
            }
        } else {
            int E = B + C;
            int step = C != 0 ? stride : 1;
            for (int i = 0; i < h; ++i) {
                dst_base[dst_offset + 0] = DSPContext.OP_PUT(dst_base[dst_offset + 0], A * src_base[src_offset + 0] + E * src_base[src_offset + step + 0]);
                dst_base[dst_offset + 1] = DSPContext.OP_PUT(dst_base[dst_offset + 1], A * src_base[src_offset + 1] + E * src_base[src_offset + step + 1]);
                dst_base[dst_offset + 2] = DSPContext.OP_PUT(dst_base[dst_offset + 2], A * src_base[src_offset + 2] + E * src_base[src_offset + step + 2]);
                dst_base[dst_offset + 3] = DSPContext.OP_PUT(dst_base[dst_offset + 3], A * src_base[src_offset + 3] + E * src_base[src_offset + step + 3]);
                dst_base[dst_offset + 4] = DSPContext.OP_PUT(dst_base[dst_offset + 4], A * src_base[src_offset + 4] + E * src_base[src_offset + step + 4]);
                dst_base[dst_offset + 5] = DSPContext.OP_PUT(dst_base[dst_offset + 5], A * src_base[src_offset + 5] + E * src_base[src_offset + step + 5]);
                dst_base[dst_offset + 6] = DSPContext.OP_PUT(dst_base[dst_offset + 6], A * src_base[src_offset + 6] + E * src_base[src_offset + step + 6]);
                dst_base[dst_offset + 7] = DSPContext.OP_PUT(dst_base[dst_offset + 7], A * src_base[src_offset + 7] + E * src_base[src_offset + step + 7]);
                dst_offset += stride;
                src_offset += stride;
            }
        }
    }

    public void avg_h264_chroma_mc2_c(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride, int h, int x, int y) {
        int A = (8 - x) * (8 - y);
        int B = x * (8 - y);
        int C = (8 - x) * y;
        int D = x * y;
        if (D != 0) {
            for (int i = 0; i < h; ++i) {
                dst_base[dst_offset + 0] = DSPContext.OP_AVG(dst_base[dst_offset + 0], A * src_base[src_offset + 0] + B * src_base[src_offset + 1] + C * src_base[src_offset + stride + 0] + D * src_base[src_offset + stride + 1]);
                dst_base[dst_offset + 1] = DSPContext.OP_AVG(dst_base[dst_offset + 1], A * src_base[src_offset + 1] + B * src_base[src_offset + 2] + C * src_base[src_offset + stride + 1] + D * src_base[src_offset + stride + 2]);
                dst_offset += stride;
                src_offset += stride;
            }
        } else {
            int E = B + C;
            int step = C != 0 ? stride : 1;
            for (int i = 0; i < h; ++i) {
                dst_base[dst_offset + 0] = DSPContext.OP_AVG(dst_base[dst_offset + 0], A * src_base[src_offset + 0] + E * src_base[src_offset + step + 0]);
                dst_base[dst_offset + 1] = DSPContext.OP_AVG(dst_base[dst_offset + 1], A * src_base[src_offset + 1] + E * src_base[src_offset + step + 1]);
                dst_offset += stride;
                src_offset += stride;
            }
        }
    }

    public void avg_h264_chroma_mc4_c(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride, int h, int x, int y) {
        int A = (8 - x) * (8 - y);
        int B = x * (8 - y);
        int C = (8 - x) * y;
        int D = x * y;
        if (D != 0) {
            for (int i = 0; i < h; ++i) {
                dst_base[dst_offset + 0] = DSPContext.OP_AVG(dst_base[dst_offset + 0], A * src_base[src_offset + 0] + B * src_base[src_offset + 1] + C * src_base[src_offset + stride + 0] + D * src_base[src_offset + stride + 1]);
                dst_base[dst_offset + 1] = DSPContext.OP_AVG(dst_base[dst_offset + 1], A * src_base[src_offset + 1] + B * src_base[src_offset + 2] + C * src_base[src_offset + stride + 1] + D * src_base[src_offset + stride + 2]);
                dst_base[dst_offset + 2] = DSPContext.OP_AVG(dst_base[dst_offset + 2], A * src_base[src_offset + 2] + B * src_base[src_offset + 3] + C * src_base[src_offset + stride + 2] + D * src_base[src_offset + stride + 3]);
                dst_base[dst_offset + 3] = DSPContext.OP_AVG(dst_base[dst_offset + 3], A * src_base[src_offset + 3] + B * src_base[src_offset + 4] + C * src_base[src_offset + stride + 3] + D * src_base[src_offset + stride + 4]);
                dst_offset += stride;
                src_offset += stride;
            }
        } else {
            int E = B + C;
            int step = C != 0 ? stride : 1;
            for (int i = 0; i < h; ++i) {
                dst_base[dst_offset + 0] = DSPContext.OP_AVG(dst_base[dst_offset + 0], A * src_base[src_offset + 0] + E * src_base[src_offset + step + 0]);
                dst_base[dst_offset + 1] = DSPContext.OP_AVG(dst_base[dst_offset + 1], A * src_base[src_offset + 1] + E * src_base[src_offset + step + 1]);
                dst_base[dst_offset + 2] = DSPContext.OP_AVG(dst_base[dst_offset + 2], A * src_base[src_offset + 2] + E * src_base[src_offset + step + 2]);
                dst_base[dst_offset + 3] = DSPContext.OP_AVG(dst_base[dst_offset + 3], A * src_base[src_offset + 3] + E * src_base[src_offset + step + 3]);
                dst_offset += stride;
                src_offset += stride;
            }
        }
    }

    public void avg_h264_chroma_mc8_c(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride, int h, int x, int y) {
        int A = (8 - x) * (8 - y);
        int B = x * (8 - y);
        int C = (8 - x) * y;
        int D = x * y;
        if (D != 0) {
            for (int i = 0; i < h; ++i) {
                dst_base[dst_offset + 0] = DSPContext.OP_AVG(dst_base[dst_offset + 0], A * src_base[src_offset + 0] + B * src_base[src_offset + 1] + C * src_base[src_offset + stride + 0] + D * src_base[src_offset + stride + 1]);
                dst_base[dst_offset + 1] = DSPContext.OP_AVG(dst_base[dst_offset + 1], A * src_base[src_offset + 1] + B * src_base[src_offset + 2] + C * src_base[src_offset + stride + 1] + D * src_base[src_offset + stride + 2]);
                dst_base[dst_offset + 2] = DSPContext.OP_AVG(dst_base[dst_offset + 2], A * src_base[src_offset + 2] + B * src_base[src_offset + 3] + C * src_base[src_offset + stride + 2] + D * src_base[src_offset + stride + 3]);
                dst_base[dst_offset + 3] = DSPContext.OP_AVG(dst_base[dst_offset + 3], A * src_base[src_offset + 3] + B * src_base[src_offset + 4] + C * src_base[src_offset + stride + 3] + D * src_base[src_offset + stride + 4]);
                dst_base[dst_offset + 4] = DSPContext.OP_AVG(dst_base[dst_offset + 4], A * src_base[src_offset + 4] + B * src_base[src_offset + 5] + C * src_base[src_offset + stride + 4] + D * src_base[src_offset + stride + 5]);
                dst_base[dst_offset + 5] = DSPContext.OP_AVG(dst_base[dst_offset + 5], A * src_base[src_offset + 5] + B * src_base[src_offset + 6] + C * src_base[src_offset + stride + 5] + D * src_base[src_offset + stride + 6]);
                dst_base[dst_offset + 6] = DSPContext.OP_AVG(dst_base[dst_offset + 6], A * src_base[src_offset + 6] + B * src_base[src_offset + 7] + C * src_base[src_offset + stride + 6] + D * src_base[src_offset + stride + 7]);
                dst_base[dst_offset + 7] = DSPContext.OP_AVG(dst_base[dst_offset + 7], A * src_base[src_offset + 7] + B * src_base[src_offset + 8] + C * src_base[src_offset + stride + 7] + D * src_base[src_offset + stride + 8]);
                dst_offset += stride;
                src_offset += stride;
            }
        } else {
            int E = B + C;
            int step = C != 0 ? stride : 1;
            for (int i = 0; i < h; ++i) {
                dst_base[dst_offset + 0] = DSPContext.OP_AVG(dst_base[dst_offset + 0], A * src_base[src_offset + 0] + E * src_base[src_offset + step + 0]);
                dst_base[dst_offset + 1] = DSPContext.OP_AVG(dst_base[dst_offset + 1], A * src_base[src_offset + 1] + E * src_base[src_offset + step + 1]);
                dst_base[dst_offset + 2] = DSPContext.OP_AVG(dst_base[dst_offset + 2], A * src_base[src_offset + 2] + E * src_base[src_offset + step + 2]);
                dst_base[dst_offset + 3] = DSPContext.OP_AVG(dst_base[dst_offset + 3], A * src_base[src_offset + 3] + E * src_base[src_offset + step + 3]);
                dst_base[dst_offset + 4] = DSPContext.OP_AVG(dst_base[dst_offset + 4], A * src_base[src_offset + 4] + E * src_base[src_offset + step + 4]);
                dst_base[dst_offset + 5] = DSPContext.OP_AVG(dst_base[dst_offset + 5], A * src_base[src_offset + 5] + E * src_base[src_offset + step + 5]);
                dst_base[dst_offset + 6] = DSPContext.OP_AVG(dst_base[dst_offset + 6], A * src_base[src_offset + 6] + E * src_base[src_offset + step + 6]);
                dst_base[dst_offset + 7] = DSPContext.OP_AVG(dst_base[dst_offset + 7], A * src_base[src_offset + 7] + E * src_base[src_offset + step + 7]);
                dst_offset += stride;
                src_offset += stride;
            }
        }
    }

    public static void copy_block(int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int dstStride, int srcStride, int h) {
        switch (size) {
            case 2: {
                for (int i = 0; i < h; ++i) {
                    System.arraycopy(src_base, src_offset, dst_base, dst_offset, 2);
                    dst_offset += dstStride;
                    src_offset += srcStride;
                }
                break;
            }
            case 4: {
                for (int i = 0; i < h; ++i) {
                    System.arraycopy(src_base, src_offset, dst_base, dst_offset, 4);
                    dst_offset += dstStride;
                    src_offset += srcStride;
                }
                break;
            }
            case 8: {
                for (int i = 0; i < h; ++i) {
                    System.arraycopy(src_base, src_offset, dst_base, dst_offset, 8);
                    dst_offset += dstStride;
                    src_offset += srcStride;
                }
                break;
            }
            case 16: {
                for (int i = 0; i < h; ++i) {
                    System.arraycopy(src_base, src_offset, dst_base, dst_offset, 16);
                    dst_offset += dstStride;
                    src_offset += srcStride;
                }
                break;
            }
        }
    }

    public static int rnd_avg32(int a, int b) {
        long aa = (long)a & 0xFFFFFFFFL;
        long bb = (long)b & 0xFFFFFFFFL;
        long remainder = (long)(a ^ b) & 0x1010101L;
        long ret = ((aa &= remainder ^ 0xFFFFFFFFFFFFFFFFL) + (bb &= remainder ^ 0xFFFFFFFFFFFFFFFFL) >>> 1) + remainder;
        return (int)(ret & 0xFFFFFFFFL);
    }

    private static int makeU32(int b1, int b2, int b3, int b4) {
        return (b1 &= 0xFF) | (b2 &= 0xFF) << 8 | (b3 &= 0xFF) << 16 | (b4 &= 0xFF) << 24;
    }

    private static int makeU32(int[] b, int b_offset) {
        return DSPContext.makeU32(b[b_offset], b[b_offset + 1], b[b_offset + 2], b[b_offset + 3]);
    }

    private static int makeU16(int b1, int b2) {
        return (b1 &= 0xFF) | (b2 &= 0xFF) << 8;
    }

    private static int makeU16(int[] b, int b_offset) {
        return DSPContext.makeU16(b[b_offset], b[b_offset + 1]);
    }

    private static void storeU32(int[] b, int b_offset, int u32) {
        b[b_offset] = u32 & 0xFF;
        b[b_offset + 1] = u32 >> 8 & 0xFF;
        b[b_offset + 2] = u32 >> 16 & 0xFF;
        b[b_offset + 3] = u32 >> 24 & 0xFF;
    }

    private static void storeU16(int[] b, int b_offset, int u16) {
        b[b_offset] = u16 & 0xFF;
        b[b_offset + 1] = u16 >> 8 & 0xFF;
    }

    public static void pixels_l2(int opcode, int size, int[] dst_base, int dst_offset, int[] src1_base, int src1_offset, int[] src2_base, int src2_offset, int dst_stride, int src_stride1, int src_stride2, int h) {
        if (size == 8) {
            for (int i = 0; i < h; ++i) {
                int a = DSPContext.makeU32(src1_base, src1_offset + i * src_stride1);
                int b = DSPContext.makeU32(src2_base, src2_offset + i * src_stride2);
                int c = DSPContext.makeU32(dst_base, dst_offset + i * dst_stride);
                c = opcode == 0 ? DSPContext.rnd_avg32(a, b) : DSPContext.rnd_avg32(c, DSPContext.rnd_avg32(a, b));
                DSPContext.storeU32(dst_base, dst_offset + i * dst_stride, c);
                a = DSPContext.makeU32(src1_base, 4 + src1_offset + i * src_stride1);
                b = DSPContext.makeU32(src2_base, 4 + src2_offset + i * src_stride2);
                c = DSPContext.makeU32(dst_base, 4 + dst_offset + i * dst_stride);
                c = opcode == 0 ? DSPContext.rnd_avg32(a, b) : DSPContext.rnd_avg32(c, DSPContext.rnd_avg32(a, b));
                DSPContext.storeU32(dst_base, 4 + dst_offset + i * dst_stride, c);
            }
        } else if (size == 4) {
            for (int i = 0; i < h; ++i) {
                int a = DSPContext.makeU32(src1_base, src1_offset + i * src_stride1);
                int b = DSPContext.makeU32(src2_base, src2_offset + i * src_stride2);
                int c = DSPContext.makeU32(dst_base, dst_offset + i * dst_stride);
                c = opcode == 0 ? DSPContext.rnd_avg32(a, b) : DSPContext.rnd_avg32(c, DSPContext.rnd_avg32(a, b));
                DSPContext.storeU32(dst_base, dst_offset + i * dst_stride, c);
            }
        } else if (size == 2) {
            for (int i = 0; i < h; ++i) {
                int a = DSPContext.makeU16(src1_base, src1_offset + i * src_stride1);
                int b = DSPContext.makeU16(src2_base, src2_offset + i * src_stride2);
                int c = DSPContext.makeU16(dst_base, dst_offset + i * dst_stride);
                c = opcode == 0 ? DSPContext.rnd_avg32(a, b) : DSPContext.rnd_avg32(c, DSPContext.rnd_avg32(a, b));
                DSPContext.storeU16(dst_base, dst_offset + i * dst_stride, c);
            }
        } else if (size == 16) {
            DSPContext.pixels_l2(opcode, 8, dst_base, dst_offset, src1_base, src1_offset, src2_base, src2_offset, dst_stride, src_stride1, src_stride2, h);
            DSPContext.pixels_l2(opcode, 8, dst_base, dst_offset + 8, src1_base, src1_offset + 8, src2_base, src2_offset + 8, dst_stride, src_stride1, src_stride2, h);
        }
    }

    public static void pixels_c(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride, int height) {
        switch (size) {
            case 2: {
                if (opcode == 0) {
                    for (int i = 0; i < height; ++i) {
                        System.arraycopy(src_base, src_offset, dst_base, dst_offset, 2);
                        dst_offset += stride;
                        src_offset += stride;
                    }
                } else {
                    for (int i = 0; i < height; ++i) {
                        int a = DSPContext.makeU16(src_base, src_offset);
                        int b = DSPContext.makeU16(dst_base, dst_offset);
                        b = DSPContext.rnd_avg32(b, a);
                        DSPContext.storeU16(dst_base, dst_offset, b);
                        dst_offset += stride;
                        src_offset += stride;
                    }
                }
                break;
            }
            case 4: {
                if (opcode == 0) {
                    for (int i = 0; i < height; ++i) {
                        System.arraycopy(src_base, src_offset, dst_base, dst_offset, 4);
                        dst_offset += stride;
                        src_offset += stride;
                    }
                } else {
                    for (int i = 0; i < height; ++i) {
                        int a = DSPContext.makeU32(src_base, src_offset);
                        int b = DSPContext.makeU32(dst_base, dst_offset);
                        b = DSPContext.rnd_avg32(b, a);
                        DSPContext.storeU32(dst_base, dst_offset, b);
                        dst_offset += stride;
                        src_offset += stride;
                    }
                }
                break;
            }
            case 8: {
                if (opcode == 0) {
                    for (int i = 0; i < height; ++i) {
                        System.arraycopy(src_base, src_offset, dst_base, dst_offset, 8);
                        dst_offset += stride;
                        src_offset += stride;
                    }
                } else {
                    for (int i = 0; i < height; ++i) {
                        int a = DSPContext.makeU32(src_base, src_offset);
                        int b = DSPContext.makeU32(dst_base, dst_offset);
                        b = DSPContext.rnd_avg32(b, a);
                        DSPContext.storeU32(dst_base, dst_offset, b);
                        a = DSPContext.makeU32(src_base, 4 + src_offset);
                        b = DSPContext.makeU32(dst_base, 4 + dst_offset);
                        b = DSPContext.rnd_avg32(b, a);
                        DSPContext.storeU32(dst_base, 4 + dst_offset, b);
                        dst_offset += stride;
                        src_offset += stride;
                    }
                }
                break;
            }
            case 16: {
                DSPContext.pixels_c(opcode, 8, dst_base, dst_offset, src_base, src_offset, stride, height);
                DSPContext.pixels_c(opcode, 8, dst_base, dst_offset + 8, src_base, src_offset + 8, stride, height);
            }
        }
    }

    public static int op_avg(int a, int b, int[] cm_base, int cm_offset) {
        return a + cm_base[cm_offset + (b + 16 >> 5)] + 1 >> 1;
    }

    public static int op_put(int a, int b, int[] cm_base, int cm_offset) {
        return cm_base[cm_offset + (b + 16 >> 5)];
    }

    public static int op_avg2(int a, int b, int[] cm_base, int cm_offset) {
        return a + cm_base[cm_offset + (b + 512 >> 10)] + 1 >> 1;
    }

    public static int op_put2(int a, int b, int[] cm_base, int cm_offset) {
        try {
            return cm_base[cm_offset + (b + 512 >> 10)];
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static void h264_qpel_h_lowpass(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int dstStride, int srcStride) {
        switch (size) {
            case 2: {
                int h = 2;
                int[] cm_base = H264DSPContext.ff_cropTbl;
                int cm_offset = 1024;
                for (int i = 0; i < h; ++i) {
                    if (opcode == 0) {
                        dst_base[dst_offset + 0] = DSPContext.op_put(dst_base[dst_offset + 0], (src_base[src_offset + 0] + src_base[src_offset + 1]) * 20 - (src_base[src_offset + -1] + src_base[src_offset + 2]) * 5 + (src_base[src_offset + -2] + src_base[src_offset + 3]), cm_base, cm_offset);
                        dst_base[dst_offset + 1] = DSPContext.op_put(dst_base[dst_offset + 1], (src_base[src_offset + 1] + src_base[src_offset + 2]) * 20 - (src_base[src_offset + 0] + src_base[src_offset + 3]) * 5 + (src_base[src_offset + -1] + src_base[src_offset + 4]), cm_base, cm_offset);
                        dst_offset += dstStride;
                    } else {
                        dst_base[dst_offset + 0] = DSPContext.op_avg(dst_base[dst_offset + 0], (src_base[src_offset + 0] + src_base[src_offset + 1]) * 20 - (src_base[src_offset + -1] + src_base[src_offset + 2]) * 5 + (src_base[src_offset + -2] + src_base[src_offset + 3]), cm_base, cm_offset);
                        dst_base[dst_offset + 1] = DSPContext.op_avg(dst_base[dst_offset + 1], (src_base[src_offset + 1] + src_base[src_offset + 2]) * 20 - (src_base[src_offset + 0] + src_base[src_offset + 3]) * 5 + (src_base[src_offset + -1] + src_base[src_offset + 4]), cm_base, cm_offset);
                        dst_offset += dstStride;
                    }
                    src_offset += srcStride;
                }
                break;
            }
            case 4: {
                int h = 4;
                int[] cm_base = H264DSPContext.ff_cropTbl;
                int cm_offset = 1024;
                for (int i = 0; i < h; ++i) {
                    if (opcode == 0) {
                        dst_base[dst_offset + 0] = DSPContext.op_put(dst_base[dst_offset + 0], (src_base[src_offset + 0] + src_base[src_offset + 1]) * 20 - (src_base[src_offset + -1] + src_base[src_offset + 2]) * 5 + (src_base[src_offset + -2] + src_base[src_offset + 3]), cm_base, cm_offset);
                        dst_base[dst_offset + 1] = DSPContext.op_put(dst_base[dst_offset + 1], (src_base[src_offset + 1] + src_base[src_offset + 2]) * 20 - (src_base[src_offset + 0] + src_base[src_offset + 3]) * 5 + (src_base[src_offset + -1] + src_base[src_offset + 4]), cm_base, cm_offset);
                        dst_base[dst_offset + 2] = DSPContext.op_put(dst_base[dst_offset + 2], (src_base[src_offset + 2] + src_base[src_offset + 3]) * 20 - (src_base[src_offset + 1] + src_base[src_offset + 4]) * 5 + (src_base[src_offset + 0] + src_base[src_offset + 5]), cm_base, cm_offset);
                        dst_base[dst_offset + 3] = DSPContext.op_put(dst_base[dst_offset + 3], (src_base[src_offset + 3] + src_base[src_offset + 4]) * 20 - (src_base[src_offset + 2] + src_base[src_offset + 5]) * 5 + (src_base[src_offset + 1] + src_base[src_offset + 6]), cm_base, cm_offset);
                    } else {
                        dst_base[dst_offset + 0] = DSPContext.op_avg(dst_base[dst_offset + 0], (src_base[src_offset + 0] + src_base[src_offset + 1]) * 20 - (src_base[src_offset + -1] + src_base[src_offset + 2]) * 5 + (src_base[src_offset + -2] + src_base[src_offset + 3]), cm_base, cm_offset);
                        dst_base[dst_offset + 1] = DSPContext.op_avg(dst_base[dst_offset + 1], (src_base[src_offset + 1] + src_base[src_offset + 2]) * 20 - (src_base[src_offset + 0] + src_base[src_offset + 3]) * 5 + (src_base[src_offset + -1] + src_base[src_offset + 4]), cm_base, cm_offset);
                        dst_base[dst_offset + 2] = DSPContext.op_avg(dst_base[dst_offset + 2], (src_base[src_offset + 2] + src_base[src_offset + 3]) * 20 - (src_base[src_offset + 1] + src_base[src_offset + 4]) * 5 + (src_base[src_offset + 0] + src_base[src_offset + 5]), cm_base, cm_offset);
                        dst_base[dst_offset + 3] = DSPContext.op_avg(dst_base[dst_offset + 3], (src_base[src_offset + 3] + src_base[src_offset + 4]) * 20 - (src_base[src_offset + 2] + src_base[src_offset + 5]) * 5 + (src_base[src_offset + 1] + src_base[src_offset + 6]), cm_base, cm_offset);
                    }
                    dst_offset += dstStride;
                    src_offset += srcStride;
                }
                break;
            }
            case 8: {
                int h = 8;
                int[] cm_base = H264DSPContext.ff_cropTbl;
                int cm_offset = 1024;
                for (int i = 0; i < h; ++i) {
                    if (opcode == 0) {
                        dst_base[dst_offset + 0] = DSPContext.op_put(dst_base[dst_offset + 0], (src_base[src_offset + 0] + src_base[src_offset + 1]) * 20 - (src_base[src_offset + -1] + src_base[src_offset + 2]) * 5 + (src_base[src_offset + -2] + src_base[src_offset + 3]), cm_base, cm_offset);
                        dst_base[dst_offset + 1] = DSPContext.op_put(dst_base[dst_offset + 1], (src_base[src_offset + 1] + src_base[src_offset + 2]) * 20 - (src_base[src_offset + 0] + src_base[src_offset + 3]) * 5 + (src_base[src_offset + -1] + src_base[src_offset + 4]), cm_base, cm_offset);
                        dst_base[dst_offset + 2] = DSPContext.op_put(dst_base[dst_offset + 2], (src_base[src_offset + 2] + src_base[src_offset + 3]) * 20 - (src_base[src_offset + 1] + src_base[src_offset + 4]) * 5 + (src_base[src_offset + 0] + src_base[src_offset + 5]), cm_base, cm_offset);
                        dst_base[dst_offset + 3] = DSPContext.op_put(dst_base[dst_offset + 3], (src_base[src_offset + 3] + src_base[src_offset + 4]) * 20 - (src_base[src_offset + 2] + src_base[src_offset + 5]) * 5 + (src_base[src_offset + 1] + src_base[src_offset + 6]), cm_base, cm_offset);
                        dst_base[dst_offset + 4] = DSPContext.op_put(dst_base[dst_offset + 4], (src_base[src_offset + 4] + src_base[src_offset + 5]) * 20 - (src_base[src_offset + 3] + src_base[src_offset + 6]) * 5 + (src_base[src_offset + 2] + src_base[src_offset + 7]), cm_base, cm_offset);
                        dst_base[dst_offset + 5] = DSPContext.op_put(dst_base[dst_offset + 5], (src_base[src_offset + 5] + src_base[src_offset + 6]) * 20 - (src_base[src_offset + 4] + src_base[src_offset + 7]) * 5 + (src_base[src_offset + 3] + src_base[src_offset + 8]), cm_base, cm_offset);
                        dst_base[dst_offset + 6] = DSPContext.op_put(dst_base[dst_offset + 6], (src_base[src_offset + 6] + src_base[src_offset + 7]) * 20 - (src_base[src_offset + 5] + src_base[src_offset + 8]) * 5 + (src_base[src_offset + 4] + src_base[src_offset + 9]), cm_base, cm_offset);
                        dst_base[dst_offset + 7] = DSPContext.op_put(dst_base[dst_offset + 7], (src_base[src_offset + 7] + src_base[src_offset + 8]) * 20 - (src_base[src_offset + 6] + src_base[src_offset + 9]) * 5 + (src_base[src_offset + 5] + src_base[src_offset + 10]), cm_base, cm_offset);
                    } else {
                        dst_base[dst_offset + 0] = DSPContext.op_avg(dst_base[dst_offset + 0], (src_base[src_offset + 0] + src_base[src_offset + 1]) * 20 - (src_base[src_offset + -1] + src_base[src_offset + 2]) * 5 + (src_base[src_offset + -2] + src_base[src_offset + 3]), cm_base, cm_offset);
                        dst_base[dst_offset + 1] = DSPContext.op_avg(dst_base[dst_offset + 1], (src_base[src_offset + 1] + src_base[src_offset + 2]) * 20 - (src_base[src_offset + 0] + src_base[src_offset + 3]) * 5 + (src_base[src_offset + -1] + src_base[src_offset + 4]), cm_base, cm_offset);
                        dst_base[dst_offset + 2] = DSPContext.op_avg(dst_base[dst_offset + 2], (src_base[src_offset + 2] + src_base[src_offset + 3]) * 20 - (src_base[src_offset + 1] + src_base[src_offset + 4]) * 5 + (src_base[src_offset + 0] + src_base[src_offset + 5]), cm_base, cm_offset);
                        dst_base[dst_offset + 3] = DSPContext.op_avg(dst_base[dst_offset + 3], (src_base[src_offset + 3] + src_base[src_offset + 4]) * 20 - (src_base[src_offset + 2] + src_base[src_offset + 5]) * 5 + (src_base[src_offset + 1] + src_base[src_offset + 6]), cm_base, cm_offset);
                        dst_base[dst_offset + 4] = DSPContext.op_avg(dst_base[dst_offset + 4], (src_base[src_offset + 4] + src_base[src_offset + 5]) * 20 - (src_base[src_offset + 3] + src_base[src_offset + 6]) * 5 + (src_base[src_offset + 2] + src_base[src_offset + 7]), cm_base, cm_offset);
                        dst_base[dst_offset + 5] = DSPContext.op_avg(dst_base[dst_offset + 5], (src_base[src_offset + 5] + src_base[src_offset + 6]) * 20 - (src_base[src_offset + 4] + src_base[src_offset + 7]) * 5 + (src_base[src_offset + 3] + src_base[src_offset + 8]), cm_base, cm_offset);
                        dst_base[dst_offset + 6] = DSPContext.op_avg(dst_base[dst_offset + 6], (src_base[src_offset + 6] + src_base[src_offset + 7]) * 20 - (src_base[src_offset + 5] + src_base[src_offset + 8]) * 5 + (src_base[src_offset + 4] + src_base[src_offset + 9]), cm_base, cm_offset);
                        dst_base[dst_offset + 7] = DSPContext.op_avg(dst_base[dst_offset + 7], (src_base[src_offset + 7] + src_base[src_offset + 8]) * 20 - (src_base[src_offset + 6] + src_base[src_offset + 9]) * 5 + (src_base[src_offset + 5] + src_base[src_offset + 10]), cm_base, cm_offset);
                    }
                    dst_offset += dstStride;
                    src_offset += srcStride;
                }
                break;
            }
            case 16: {
                DSPContext.h264_qpel_h_lowpass(opcode, 8, dst_base, dst_offset, src_base, src_offset, dstStride, srcStride);
                DSPContext.h264_qpel_h_lowpass(opcode, 8, dst_base, dst_offset + 8, src_base, src_offset + 8, dstStride, srcStride);
                DSPContext.h264_qpel_h_lowpass(opcode, 8, dst_base, dst_offset += 8 * dstStride, src_base, src_offset += 8 * srcStride, dstStride, srcStride);
                DSPContext.h264_qpel_h_lowpass(opcode, 8, dst_base, dst_offset + 8, src_base, src_offset + 8, dstStride, srcStride);
            }
        }
    }

    public static void h264_qpel_v_lowpass(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int dstStride, int srcStride) {
        switch (size) {
            case 2: {
                int w = 2;
                int[] cm_base = H264DSPContext.ff_cropTbl;
                int cm_offset = 1024;
                for (int i = 0; i < w; ++i) {
                    int srcB = src_base[src_offset + -2 * srcStride];
                    int srcA = src_base[src_offset + -1 * srcStride];
                    int src0 = src_base[src_offset + 0 * srcStride];
                    int src1 = src_base[src_offset + 1 * srcStride];
                    int src2 = src_base[src_offset + 2 * srcStride];
                    int src3 = src_base[src_offset + 3 * srcStride];
                    int src4 = src_base[src_offset + 4 * srcStride];
                    if (opcode == 0) {
                        dst_base[dst_offset + 0 * dstStride] = DSPContext.op_put(dst_base[dst_offset + 0 * dstStride], (src0 + src1) * 20 - (srcA + src2) * 5 + (srcB + src3), cm_base, cm_offset);
                        dst_base[dst_offset + 1 * dstStride] = DSPContext.op_put(dst_base[dst_offset + 1 * dstStride], (src1 + src2) * 20 - (src0 + src3) * 5 + (srcA + src4), cm_base, cm_offset);
                    } else {
                        dst_base[dst_offset + 0 * dstStride] = DSPContext.op_avg(dst_base[dst_offset + 0 * dstStride], (src0 + src1) * 20 - (srcA + src2) * 5 + (srcB + src3), cm_base, cm_offset);
                        dst_base[dst_offset + 1 * dstStride] = DSPContext.op_avg(dst_base[dst_offset + 1 * dstStride], (src1 + src2) * 20 - (src0 + src3) * 5 + (srcA + src4), cm_base, cm_offset);
                    }
                    ++dst_offset;
                    ++src_offset;
                }
                break;
            }
            case 4: {
                int w = 4;
                int[] cm_base = H264DSPContext.ff_cropTbl;
                int cm_offset = 1024;
                for (int i = 0; i < w; ++i) {
                    int srcB = src_base[src_offset + -2 * srcStride];
                    int srcA = src_base[src_offset + -1 * srcStride];
                    int src0 = src_base[src_offset + 0 * srcStride];
                    int src1 = src_base[src_offset + 1 * srcStride];
                    int src2 = src_base[src_offset + 2 * srcStride];
                    int src3 = src_base[src_offset + 3 * srcStride];
                    int src4 = src_base[src_offset + 4 * srcStride];
                    int src5 = src_base[src_offset + 5 * srcStride];
                    int src6 = src_base[src_offset + 6 * srcStride];
                    if (opcode == 0) {
                        dst_base[dst_offset + 0 * dstStride] = DSPContext.op_put(dst_base[dst_offset + 0 * dstStride], (src0 + src1) * 20 - (srcA + src2) * 5 + (srcB + src3), cm_base, cm_offset);
                        dst_base[dst_offset + 1 * dstStride] = DSPContext.op_put(dst_base[dst_offset + 1 * dstStride], (src1 + src2) * 20 - (src0 + src3) * 5 + (srcA + src4), cm_base, cm_offset);
                        dst_base[dst_offset + 2 * dstStride] = DSPContext.op_put(dst_base[dst_offset + 2 * dstStride], (src2 + src3) * 20 - (src1 + src4) * 5 + (src0 + src5), cm_base, cm_offset);
                        dst_base[dst_offset + 3 * dstStride] = DSPContext.op_put(dst_base[dst_offset + 3 * dstStride], (src3 + src4) * 20 - (src2 + src5) * 5 + (src1 + src6), cm_base, cm_offset);
                    } else {
                        dst_base[dst_offset + 0 * dstStride] = DSPContext.op_avg(dst_base[dst_offset + 0 * dstStride], (src0 + src1) * 20 - (srcA + src2) * 5 + (srcB + src3), cm_base, cm_offset);
                        dst_base[dst_offset + 1 * dstStride] = DSPContext.op_avg(dst_base[dst_offset + 1 * dstStride], (src1 + src2) * 20 - (src0 + src3) * 5 + (srcA + src4), cm_base, cm_offset);
                        dst_base[dst_offset + 2 * dstStride] = DSPContext.op_avg(dst_base[dst_offset + 2 * dstStride], (src2 + src3) * 20 - (src1 + src4) * 5 + (src0 + src5), cm_base, cm_offset);
                        dst_base[dst_offset + 3 * dstStride] = DSPContext.op_avg(dst_base[dst_offset + 3 * dstStride], (src3 + src4) * 20 - (src2 + src5) * 5 + (src1 + src6), cm_base, cm_offset);
                    }
                    ++dst_offset;
                    ++src_offset;
                }
                break;
            }
            case 8: {
                int w = 8;
                int[] cm_base = H264DSPContext.ff_cropTbl;
                int cm_offset = 1024;
                for (int i = 0; i < w; ++i) {
                    int srcB = src_base[src_offset + -2 * srcStride];
                    int srcA = src_base[src_offset + -1 * srcStride];
                    int src0 = src_base[src_offset + 0 * srcStride];
                    int src1 = src_base[src_offset + 1 * srcStride];
                    int src2 = src_base[src_offset + 2 * srcStride];
                    int src3 = src_base[src_offset + 3 * srcStride];
                    int src4 = src_base[src_offset + 4 * srcStride];
                    int src5 = src_base[src_offset + 5 * srcStride];
                    int src6 = src_base[src_offset + 6 * srcStride];
                    int src7 = src_base[src_offset + 7 * srcStride];
                    int src8 = src_base[src_offset + 8 * srcStride];
                    int src9 = src_base[src_offset + 9 * srcStride];
                    int src10 = src_base[src_offset + 10 * srcStride];
                    if (opcode == 0) {
                        dst_base[dst_offset + 0 * dstStride] = DSPContext.op_put(dst_base[dst_offset + 0 * dstStride], (src0 + src1) * 20 - (srcA + src2) * 5 + (srcB + src3), cm_base, cm_offset);
                        dst_base[dst_offset + 1 * dstStride] = DSPContext.op_put(dst_base[dst_offset + 1 * dstStride], (src1 + src2) * 20 - (src0 + src3) * 5 + (srcA + src4), cm_base, cm_offset);
                        dst_base[dst_offset + 2 * dstStride] = DSPContext.op_put(dst_base[dst_offset + 2 * dstStride], (src2 + src3) * 20 - (src1 + src4) * 5 + (src0 + src5), cm_base, cm_offset);
                        dst_base[dst_offset + 3 * dstStride] = DSPContext.op_put(dst_base[dst_offset + 3 * dstStride], (src3 + src4) * 20 - (src2 + src5) * 5 + (src1 + src6), cm_base, cm_offset);
                        dst_base[dst_offset + 4 * dstStride] = DSPContext.op_put(dst_base[dst_offset + 4 * dstStride], (src4 + src5) * 20 - (src3 + src6) * 5 + (src2 + src7), cm_base, cm_offset);
                        dst_base[dst_offset + 5 * dstStride] = DSPContext.op_put(dst_base[dst_offset + 5 * dstStride], (src5 + src6) * 20 - (src4 + src7) * 5 + (src3 + src8), cm_base, cm_offset);
                        dst_base[dst_offset + 6 * dstStride] = DSPContext.op_put(dst_base[dst_offset + 6 * dstStride], (src6 + src7) * 20 - (src5 + src8) * 5 + (src4 + src9), cm_base, cm_offset);
                        dst_base[dst_offset + 7 * dstStride] = DSPContext.op_put(dst_base[dst_offset + 7 * dstStride], (src7 + src8) * 20 - (src6 + src9) * 5 + (src5 + src10), cm_base, cm_offset);
                    } else {
                        dst_base[dst_offset + 0 * dstStride] = DSPContext.op_avg(dst_base[dst_offset + 0 * dstStride], (src0 + src1) * 20 - (srcA + src2) * 5 + (srcB + src3), cm_base, cm_offset);
                        dst_base[dst_offset + 1 * dstStride] = DSPContext.op_avg(dst_base[dst_offset + 1 * dstStride], (src1 + src2) * 20 - (src0 + src3) * 5 + (srcA + src4), cm_base, cm_offset);
                        dst_base[dst_offset + 2 * dstStride] = DSPContext.op_avg(dst_base[dst_offset + 2 * dstStride], (src2 + src3) * 20 - (src1 + src4) * 5 + (src0 + src5), cm_base, cm_offset);
                        dst_base[dst_offset + 3 * dstStride] = DSPContext.op_avg(dst_base[dst_offset + 3 * dstStride], (src3 + src4) * 20 - (src2 + src5) * 5 + (src1 + src6), cm_base, cm_offset);
                        dst_base[dst_offset + 4 * dstStride] = DSPContext.op_avg(dst_base[dst_offset + 4 * dstStride], (src4 + src5) * 20 - (src3 + src6) * 5 + (src2 + src7), cm_base, cm_offset);
                        dst_base[dst_offset + 5 * dstStride] = DSPContext.op_avg(dst_base[dst_offset + 5 * dstStride], (src5 + src6) * 20 - (src4 + src7) * 5 + (src3 + src8), cm_base, cm_offset);
                        dst_base[dst_offset + 6 * dstStride] = DSPContext.op_avg(dst_base[dst_offset + 6 * dstStride], (src6 + src7) * 20 - (src5 + src8) * 5 + (src4 + src9), cm_base, cm_offset);
                        dst_base[dst_offset + 7 * dstStride] = DSPContext.op_avg(dst_base[dst_offset + 7 * dstStride], (src7 + src8) * 20 - (src6 + src9) * 5 + (src5 + src10), cm_base, cm_offset);
                    }
                    ++dst_offset;
                    ++src_offset;
                }
                break;
            }
            case 16: {
                DSPContext.h264_qpel_v_lowpass(opcode, 8, dst_base, dst_offset, src_base, src_offset, dstStride, srcStride);
                DSPContext.h264_qpel_v_lowpass(opcode, 8, dst_base, dst_offset + 8, src_base, src_offset + 8, dstStride, srcStride);
                DSPContext.h264_qpel_v_lowpass(opcode, 8, dst_base, dst_offset += 8 * dstStride, src_base, src_offset += 8 * srcStride, dstStride, srcStride);
                DSPContext.h264_qpel_v_lowpass(opcode, 8, dst_base, dst_offset + 8, src_base, src_offset + 8, dstStride, srcStride);
            }
        }
    }

    public static void h264_qpel_hv_lowpass(int opcode, int size, int[] dst_base, int dst_offset, int[] tmp_base, int tmp_offset, int[] src_base, int src_offset, int dstStride, int tmpStride, int srcStride) {
        switch (size) {
            case 2: {
                int i;
                int h = 2;
                int w = 2;
                int[] cm_base = H264DSPContext.ff_cropTbl;
                int cm_offset = 1024;
                src_offset -= 2 * srcStride;
                for (i = 0; i < h + 5; ++i) {
                    tmp_base[tmp_offset + 0] = (src_base[src_offset + 0] + src_base[src_offset + 1]) * 20 - (src_base[src_offset + -1] + src_base[src_offset + 2]) * 5 + (src_base[src_offset + -2] + src_base[src_offset + 3]);
                    tmp_base[tmp_offset + 1] = (src_base[src_offset + 1] + src_base[src_offset + 2]) * 20 - (src_base[src_offset + 0] + src_base[src_offset + 3]) * 5 + (src_base[src_offset + -1] + src_base[src_offset + 4]);
                    tmp_offset += tmpStride;
                    src_offset += srcStride;
                }
                tmp_offset -= tmpStride * (h + 5 - 2);
                for (i = 0; i < w; ++i) {
                    int tmpB = tmp_base[tmp_offset + -2 * tmpStride];
                    int tmpA = tmp_base[tmp_offset + -1 * tmpStride];
                    int tmp0 = tmp_base[tmp_offset + 0 * tmpStride];
                    int tmp1 = tmp_base[tmp_offset + 1 * tmpStride];
                    int tmp2 = tmp_base[tmp_offset + 2 * tmpStride];
                    int tmp3 = tmp_base[tmp_offset + 3 * tmpStride];
                    int tmp4 = tmp_base[tmp_offset + 4 * tmpStride];
                    if (opcode == 0) {
                        dst_base[dst_offset + 0 * dstStride] = DSPContext.op_put2(dst_base[dst_offset + 0 * dstStride], (tmp0 + tmp1) * 20 - (tmpA + tmp2) * 5 + (tmpB + tmp3), cm_base, cm_offset);
                        dst_base[dst_offset + 1 * dstStride] = DSPContext.op_put2(dst_base[dst_offset + 1 * dstStride], (tmp1 + tmp2) * 20 - (tmp0 + tmp3) * 5 + (tmpA + tmp4), cm_base, cm_offset);
                    } else {
                        dst_base[dst_offset + 0 * dstStride] = DSPContext.op_avg2(dst_base[dst_offset + 0 * dstStride], (tmp0 + tmp1) * 20 - (tmpA + tmp2) * 5 + (tmpB + tmp3), cm_base, cm_offset);
                        dst_base[dst_offset + 1 * dstStride] = DSPContext.op_avg2(dst_base[dst_offset + 1 * dstStride], (tmp1 + tmp2) * 20 - (tmp0 + tmp3) * 5 + (tmpA + tmp4), cm_base, cm_offset);
                    }
                    ++dst_offset;
                    ++tmp_offset;
                }
                break;
            }
            case 4: {
                int i;
                int h = 4;
                int w = 4;
                int[] cm_base = H264DSPContext.ff_cropTbl;
                int cm_offset = 1024;
                src_offset -= 2 * srcStride;
                for (i = 0; i < h + 5; ++i) {
                    tmp_base[tmp_offset + 0] = (src_base[src_offset + 0] + src_base[src_offset + 1]) * 20 - (src_base[src_offset + -1] + src_base[src_offset + 2]) * 5 + (src_base[src_offset + -2] + src_base[src_offset + 3]);
                    tmp_base[tmp_offset + 1] = (src_base[src_offset + 1] + src_base[src_offset + 2]) * 20 - (src_base[src_offset + 0] + src_base[src_offset + 3]) * 5 + (src_base[src_offset + -1] + src_base[src_offset + 4]);
                    tmp_base[tmp_offset + 2] = (src_base[src_offset + 2] + src_base[src_offset + 3]) * 20 - (src_base[src_offset + 1] + src_base[src_offset + 4]) * 5 + (src_base[src_offset + 0] + src_base[src_offset + 5]);
                    tmp_base[tmp_offset + 3] = (src_base[src_offset + 3] + src_base[src_offset + 4]) * 20 - (src_base[src_offset + 2] + src_base[src_offset + 5]) * 5 + (src_base[src_offset + 1] + src_base[src_offset + 6]);
                    tmp_offset += tmpStride;
                    src_offset += srcStride;
                }
                tmp_offset -= tmpStride * (h + 5 - 2);
                for (i = 0; i < w; ++i) {
                    int tmpB = tmp_base[tmp_offset + -2 * tmpStride];
                    int tmpA = tmp_base[tmp_offset + -1 * tmpStride];
                    int tmp0 = tmp_base[tmp_offset + 0 * tmpStride];
                    int tmp1 = tmp_base[tmp_offset + 1 * tmpStride];
                    int tmp2 = tmp_base[tmp_offset + 2 * tmpStride];
                    int tmp3 = tmp_base[tmp_offset + 3 * tmpStride];
                    int tmp4 = tmp_base[tmp_offset + 4 * tmpStride];
                    int tmp5 = tmp_base[tmp_offset + 5 * tmpStride];
                    int tmp6 = tmp_base[tmp_offset + 6 * tmpStride];
                    if (opcode == 0) {
                        dst_base[dst_offset + 0 * dstStride] = DSPContext.op_put2(dst_base[dst_offset + 0 * dstStride], (tmp0 + tmp1) * 20 - (tmpA + tmp2) * 5 + (tmpB + tmp3), cm_base, cm_offset);
                        dst_base[dst_offset + 1 * dstStride] = DSPContext.op_put2(dst_base[dst_offset + 1 * dstStride], (tmp1 + tmp2) * 20 - (tmp0 + tmp3) * 5 + (tmpA + tmp4), cm_base, cm_offset);
                        dst_base[dst_offset + 2 * dstStride] = DSPContext.op_put2(dst_base[dst_offset + 2 * dstStride], (tmp2 + tmp3) * 20 - (tmp1 + tmp4) * 5 + (tmp0 + tmp5), cm_base, cm_offset);
                        dst_base[dst_offset + 3 * dstStride] = DSPContext.op_put2(dst_base[dst_offset + 3 * dstStride], (tmp3 + tmp4) * 20 - (tmp2 + tmp5) * 5 + (tmp1 + tmp6), cm_base, cm_offset);
                    } else {
                        dst_base[dst_offset + 0 * dstStride] = DSPContext.op_avg2(dst_base[dst_offset + 0 * dstStride], (tmp0 + tmp1) * 20 - (tmpA + tmp2) * 5 + (tmpB + tmp3), cm_base, cm_offset);
                        dst_base[dst_offset + 1 * dstStride] = DSPContext.op_avg2(dst_base[dst_offset + 1 * dstStride], (tmp1 + tmp2) * 20 - (tmp0 + tmp3) * 5 + (tmpA + tmp4), cm_base, cm_offset);
                        dst_base[dst_offset + 2 * dstStride] = DSPContext.op_avg2(dst_base[dst_offset + 2 * dstStride], (tmp2 + tmp3) * 20 - (tmp1 + tmp4) * 5 + (tmp0 + tmp5), cm_base, cm_offset);
                        dst_base[dst_offset + 3 * dstStride] = DSPContext.op_avg2(dst_base[dst_offset + 3 * dstStride], (tmp3 + tmp4) * 20 - (tmp2 + tmp5) * 5 + (tmp1 + tmp6), cm_base, cm_offset);
                    }
                    ++dst_offset;
                    ++tmp_offset;
                }
                break;
            }
            case 8: {
                int i;
                int h = 8;
                int w = 8;
                int[] cm_base = H264DSPContext.ff_cropTbl;
                int cm_offset = 1024;
                src_offset -= 2 * srcStride;
                for (i = 0; i < h + 5; ++i) {
                    tmp_base[tmp_offset + 0] = (src_base[src_offset + 0] + src_base[src_offset + 1]) * 20 - (src_base[src_offset + -1] + src_base[src_offset + 2]) * 5 + (src_base[src_offset + -2] + src_base[src_offset + 3]);
                    tmp_base[tmp_offset + 1] = (src_base[src_offset + 1] + src_base[src_offset + 2]) * 20 - (src_base[src_offset + 0] + src_base[src_offset + 3]) * 5 + (src_base[src_offset + -1] + src_base[src_offset + 4]);
                    tmp_base[tmp_offset + 2] = (src_base[src_offset + 2] + src_base[src_offset + 3]) * 20 - (src_base[src_offset + 1] + src_base[src_offset + 4]) * 5 + (src_base[src_offset + 0] + src_base[src_offset + 5]);
                    tmp_base[tmp_offset + 3] = (src_base[src_offset + 3] + src_base[src_offset + 4]) * 20 - (src_base[src_offset + 2] + src_base[src_offset + 5]) * 5 + (src_base[src_offset + 1] + src_base[src_offset + 6]);
                    tmp_base[tmp_offset + 4] = (src_base[src_offset + 4] + src_base[src_offset + 5]) * 20 - (src_base[src_offset + 3] + src_base[src_offset + 6]) * 5 + (src_base[src_offset + 2] + src_base[src_offset + 7]);
                    tmp_base[tmp_offset + 5] = (src_base[src_offset + 5] + src_base[src_offset + 6]) * 20 - (src_base[src_offset + 4] + src_base[src_offset + 7]) * 5 + (src_base[src_offset + 3] + src_base[src_offset + 8]);
                    tmp_base[tmp_offset + 6] = (src_base[src_offset + 6] + src_base[src_offset + 7]) * 20 - (src_base[src_offset + 5] + src_base[src_offset + 8]) * 5 + (src_base[src_offset + 4] + src_base[src_offset + 9]);
                    tmp_base[tmp_offset + 7] = (src_base[src_offset + 7] + src_base[src_offset + 8]) * 20 - (src_base[src_offset + 6] + src_base[src_offset + 9]) * 5 + (src_base[src_offset + 5] + src_base[src_offset + 10]);
                    tmp_offset += tmpStride;
                    src_offset += srcStride;
                }
                tmp_offset -= tmpStride * (h + 5 - 2);
                for (i = 0; i < w; ++i) {
                    int tmpB = tmp_base[tmp_offset + -2 * tmpStride];
                    int tmpA = tmp_base[tmp_offset + -1 * tmpStride];
                    int tmp0 = tmp_base[tmp_offset + 0 * tmpStride];
                    int tmp1 = tmp_base[tmp_offset + 1 * tmpStride];
                    int tmp2 = tmp_base[tmp_offset + 2 * tmpStride];
                    int tmp3 = tmp_base[tmp_offset + 3 * tmpStride];
                    int tmp4 = tmp_base[tmp_offset + 4 * tmpStride];
                    int tmp5 = tmp_base[tmp_offset + 5 * tmpStride];
                    int tmp6 = tmp_base[tmp_offset + 6 * tmpStride];
                    int tmp7 = tmp_base[tmp_offset + 7 * tmpStride];
                    int tmp8 = tmp_base[tmp_offset + 8 * tmpStride];
                    int tmp9 = tmp_base[tmp_offset + 9 * tmpStride];
                    int tmp10 = tmp_base[tmp_offset + 10 * tmpStride];
                    if (opcode == 0) {
                        dst_base[dst_offset + 0 * dstStride] = DSPContext.op_put2(dst_base[dst_offset + 0 * dstStride], (tmp0 + tmp1) * 20 - (tmpA + tmp2) * 5 + (tmpB + tmp3), cm_base, cm_offset);
                        dst_base[dst_offset + 1 * dstStride] = DSPContext.op_put2(dst_base[dst_offset + 1 * dstStride], (tmp1 + tmp2) * 20 - (tmp0 + tmp3) * 5 + (tmpA + tmp4), cm_base, cm_offset);
                        dst_base[dst_offset + 2 * dstStride] = DSPContext.op_put2(dst_base[dst_offset + 2 * dstStride], (tmp2 + tmp3) * 20 - (tmp1 + tmp4) * 5 + (tmp0 + tmp5), cm_base, cm_offset);
                        dst_base[dst_offset + 3 * dstStride] = DSPContext.op_put2(dst_base[dst_offset + 3 * dstStride], (tmp3 + tmp4) * 20 - (tmp2 + tmp5) * 5 + (tmp1 + tmp6), cm_base, cm_offset);
                        dst_base[dst_offset + 4 * dstStride] = DSPContext.op_put2(dst_base[dst_offset + 4 * dstStride], (tmp4 + tmp5) * 20 - (tmp3 + tmp6) * 5 + (tmp2 + tmp7), cm_base, cm_offset);
                        dst_base[dst_offset + 5 * dstStride] = DSPContext.op_put2(dst_base[dst_offset + 5 * dstStride], (tmp5 + tmp6) * 20 - (tmp4 + tmp7) * 5 + (tmp3 + tmp8), cm_base, cm_offset);
                        dst_base[dst_offset + 6 * dstStride] = DSPContext.op_put2(dst_base[dst_offset + 6 * dstStride], (tmp6 + tmp7) * 20 - (tmp5 + tmp8) * 5 + (tmp4 + tmp9), cm_base, cm_offset);
                        dst_base[dst_offset + 7 * dstStride] = DSPContext.op_put2(dst_base[dst_offset + 7 * dstStride], (tmp7 + tmp8) * 20 - (tmp6 + tmp9) * 5 + (tmp5 + tmp10), cm_base, cm_offset);
                    } else {
                        dst_base[dst_offset + 0 * dstStride] = DSPContext.op_avg2(dst_base[dst_offset + 0 * dstStride], (tmp0 + tmp1) * 20 - (tmpA + tmp2) * 5 + (tmpB + tmp3), cm_base, cm_offset);
                        dst_base[dst_offset + 1 * dstStride] = DSPContext.op_avg2(dst_base[dst_offset + 1 * dstStride], (tmp1 + tmp2) * 20 - (tmp0 + tmp3) * 5 + (tmpA + tmp4), cm_base, cm_offset);
                        dst_base[dst_offset + 2 * dstStride] = DSPContext.op_avg2(dst_base[dst_offset + 2 * dstStride], (tmp2 + tmp3) * 20 - (tmp1 + tmp4) * 5 + (tmp0 + tmp5), cm_base, cm_offset);
                        dst_base[dst_offset + 3 * dstStride] = DSPContext.op_avg2(dst_base[dst_offset + 3 * dstStride], (tmp3 + tmp4) * 20 - (tmp2 + tmp5) * 5 + (tmp1 + tmp6), cm_base, cm_offset);
                        dst_base[dst_offset + 4 * dstStride] = DSPContext.op_avg2(dst_base[dst_offset + 4 * dstStride], (tmp4 + tmp5) * 20 - (tmp3 + tmp6) * 5 + (tmp2 + tmp7), cm_base, cm_offset);
                        dst_base[dst_offset + 5 * dstStride] = DSPContext.op_avg2(dst_base[dst_offset + 5 * dstStride], (tmp5 + tmp6) * 20 - (tmp4 + tmp7) * 5 + (tmp3 + tmp8), cm_base, cm_offset);
                        dst_base[dst_offset + 6 * dstStride] = DSPContext.op_avg2(dst_base[dst_offset + 6 * dstStride], (tmp6 + tmp7) * 20 - (tmp5 + tmp8) * 5 + (tmp4 + tmp9), cm_base, cm_offset);
                        dst_base[dst_offset + 7 * dstStride] = DSPContext.op_avg2(dst_base[dst_offset + 7 * dstStride], (tmp7 + tmp8) * 20 - (tmp6 + tmp9) * 5 + (tmp5 + tmp10), cm_base, cm_offset);
                    }
                    ++dst_offset;
                    ++tmp_offset;
                }
                break;
            }
            case 16: {
                DSPContext.h264_qpel_hv_lowpass(opcode, 8, dst_base, dst_offset, tmp_base, tmp_offset, src_base, src_offset, dstStride, tmpStride, srcStride);
                DSPContext.h264_qpel_hv_lowpass(opcode, 8, dst_base, dst_offset + 8, tmp_base, tmp_offset + 8, src_base, src_offset + 8, dstStride, tmpStride, srcStride);
                DSPContext.h264_qpel_hv_lowpass(opcode, 8, dst_base, dst_offset += 8 * dstStride, tmp_base, tmp_offset, src_base, src_offset += 8 * srcStride, dstStride, tmpStride, srcStride);
                DSPContext.h264_qpel_hv_lowpass(opcode, 8, dst_base, dst_offset + 8, tmp_base, tmp_offset + 8, src_base, src_offset + 8, dstStride, tmpStride, srcStride);
            }
        }
    }

    public static void h264_qpel_mc00_c(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
        DSPContext.pixels_c(opcode, size, dst_base, dst_offset, src_base, src_offset, stride, size);
    }

    public static void h264_qpel_mc10_c(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
        int[] half = new int[size * size];
        DSPContext.h264_qpel_h_lowpass(0, size, half, 0, src_base, src_offset, size, stride);
        DSPContext.pixels_l2(opcode, size, dst_base, dst_offset, src_base, src_offset, half, 0, stride, stride, size, size);
    }

    public static void h264_qpel_mc20_c(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
        DSPContext.h264_qpel_h_lowpass(opcode, size, dst_base, dst_offset, src_base, src_offset, stride, stride);
    }

    public static void h264_qpel_mc30_c(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
        int[] half = new int[size * size];
        DSPContext.h264_qpel_h_lowpass(0, size, half, 0, src_base, src_offset, size, stride);
        DSPContext.pixels_l2(opcode, size, dst_base, dst_offset, src_base, src_offset + 1, half, 0, stride, stride, size, size);
    }

    public static void h264_qpel_mc01_c(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
        int[] full = new int[size * (size + 5)];
        int full_mid = size * 2;
        int[] half = new int[size * size];
        DSPContext.copy_block(size, full, 0, src_base, src_offset - stride * 2, size, stride, size + 5);
        DSPContext.h264_qpel_v_lowpass(0, size, half, 0, full, full_mid, size, size);
        DSPContext.pixels_l2(opcode, size, dst_base, dst_offset, full, full_mid, half, 0, stride, size, size, size);
    }

    public static void h264_qpel_mc02_c(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
        int[] full = new int[size * (size + 5)];
        int full_mid = size * 2;
        DSPContext.copy_block(size, full, 0, src_base, src_offset - stride * 2, size, stride, size + 5);
        DSPContext.h264_qpel_v_lowpass(opcode, size, dst_base, dst_offset, full, full_mid, stride, size);
    }

    public static void h264_qpel_mc03_c(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
        int[] full = new int[size * (size + 5)];
        int full_mid = size * 2;
        int[] half = new int[size * size];
        DSPContext.copy_block(size, full, 0, src_base, src_offset - stride * 2, size, stride, size + 5);
        DSPContext.h264_qpel_v_lowpass(0, size, half, 0, full, full_mid, size, size);
        DSPContext.pixels_l2(opcode, size, dst_base, dst_offset, full, full_mid + size, half, 0, stride, size, size, size);
    }

    public static void h264_qpel_mc11_c(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
        int[] full = new int[size * (size + 5)];
        int full_mid = size * 2;
        int[] halfH = new int[size * size];
        int[] halfV = new int[size * size];
        DSPContext.h264_qpel_h_lowpass(0, size, halfH, 0, src_base, src_offset, size, stride);
        DSPContext.copy_block(size, full, 0, src_base, src_offset - stride * 2, size, stride, size + 5);
        DSPContext.h264_qpel_v_lowpass(0, size, halfV, 0, full, full_mid, size, size);
        DSPContext.pixels_l2(opcode, size, dst_base, dst_offset, halfH, 0, halfV, 0, stride, size, size, size);
    }

    public static void h264_qpel_mc31_c(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
        int[] full = new int[size * (size + 5)];
        int full_mid = size * 2;
        int[] halfH = new int[size * size];
        int[] halfV = new int[size * size];
        DSPContext.h264_qpel_h_lowpass(0, size, halfH, 0, src_base, src_offset, size, stride);
        DSPContext.copy_block(size, full, 0, src_base, src_offset - stride * 2 + 1, size, stride, size + 5);
        DSPContext.h264_qpel_v_lowpass(0, size, halfV, 0, full, full_mid, size, size);
        DSPContext.pixels_l2(opcode, size, dst_base, dst_offset, halfH, 0, halfV, 0, stride, size, size, size);
    }

    public static void h264_qpel_mc13_c(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
        int[] full = new int[size * (size + 5)];
        int full_mid = size * 2;
        int[] halfH = new int[size * size];
        int[] halfV = new int[size * size];
        DSPContext.h264_qpel_h_lowpass(0, size, halfH, 0, src_base, src_offset + stride, size, stride);
        DSPContext.copy_block(size, full, 0, src_base, src_offset - stride * 2, size, stride, size + 5);
        DSPContext.h264_qpel_v_lowpass(0, size, halfV, 0, full, full_mid, size, size);
        DSPContext.pixels_l2(opcode, size, dst_base, dst_offset, halfH, 0, halfV, 0, stride, size, size, size);
    }

    public static void h264_qpel_mc33_c(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
        int[] full = new int[size * (size + 5)];
        int full_mid = size * 2;
        int[] halfH = new int[size * size];
        int[] halfV = new int[size * size];
        DSPContext.h264_qpel_h_lowpass(0, size, halfH, 0, src_base, src_offset + stride, size, stride);
        DSPContext.copy_block(size, full, 0, src_base, src_offset - stride * 2 + 1, size, stride, size + 5);
        DSPContext.h264_qpel_v_lowpass(0, size, halfV, 0, full, full_mid, size, size);
        DSPContext.pixels_l2(opcode, size, dst_base, dst_offset, halfH, 0, halfV, 0, stride, size, size, size);
    }

    public static void h264_qpel_mc22_c(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
        int[] tmp = new int[size * (size + 5)];
        DSPContext.h264_qpel_hv_lowpass(opcode, size, dst_base, dst_offset, tmp, 0, src_base, src_offset, stride, size, stride);
    }

    public static void h264_qpel_mc21_c(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
        int[] tmp = new int[size * (size + 5)];
        int[] halfH = new int[size * size];
        int[] halfHV = new int[size * size];
        DSPContext.h264_qpel_h_lowpass(0, size, halfH, 0, src_base, src_offset, size, stride);
        DSPContext.h264_qpel_hv_lowpass(0, size, halfHV, 0, tmp, 0, src_base, src_offset, size, size, stride);
        DSPContext.pixels_l2(opcode, size, dst_base, dst_offset, halfH, 0, halfHV, 0, stride, size, size, size);
    }

    public static void h264_qpel_mc23_c(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
        int[] tmp = new int[size * (size + 5)];
        int[] halfH = new int[size * size];
        int[] halfHV = new int[size * size];
        DSPContext.h264_qpel_h_lowpass(0, size, halfH, 0, src_base, src_offset + stride, size, stride);
        DSPContext.h264_qpel_hv_lowpass(0, size, halfHV, 0, tmp, 0, src_base, src_offset, size, size, stride);
        DSPContext.pixels_l2(opcode, size, dst_base, dst_offset, halfH, 0, halfHV, 0, stride, size, size, size);
    }

    public static void h264_qpel_mc12_c(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
        int i;
        int[] full = new int[size * (size + 5)];
        int full_mid = size * 2;
        int[] tmp = new int[size * (size + 5)];
        int[] halfV = new int[size * size];
        int[] halfHV = new int[size * size];
        DSPContext.copy_block(size, full, 0, src_base, src_offset - stride * 2, size, stride, size + 5);
        DSPContext.h264_qpel_v_lowpass(0, size, halfV, 0, full, full_mid, size, size);
        DSPContext.h264_qpel_hv_lowpass(0, size, halfHV, 0, tmp, 0, src_base, src_offset, size, size, stride);
        for (i = 0; i < halfV.length; ++i) {
        }
        for (i = 0; i < halfHV.length; ++i) {
        }
        DSPContext.pixels_l2(opcode, size, dst_base, dst_offset, halfV, 0, halfHV, 0, stride, size, size, size);
    }

    public static void h264_qpel_mc32_c(int opcode, int size, int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
        int[] full = new int[size * (size + 5)];
        int full_mid = size * 2;
        int[] tmp = new int[size * (size + 5)];
        int[] halfV = new int[size * size];
        int[] halfHV = new int[size * size];
        DSPContext.copy_block(size, full, 0, src_base, src_offset - stride * 2 + 1, size, stride, size + 5);
        DSPContext.h264_qpel_v_lowpass(0, size, halfV, 0, full, full_mid, size, size);
        DSPContext.h264_qpel_hv_lowpass(0, size, halfHV, 0, tmp, 0, src_base, src_offset, size, size, stride);
        DSPContext.pixels_l2(opcode, size, dst_base, dst_offset, halfV, 0, halfHV, 0, stride, size, size, size);
    }

    public void dsputil_init(MpegEncContext s) {
        this.idct_permutation_type = 1;
        DSPContext.put_h264_qpel_pixels_tab[0][0] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.pixels_c(0, 16, dst_base, dst_offset, src_base, src_offset, stride, 16);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[0][1] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc10_c(0, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[0][2] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc20_c(0, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[0][3] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc30_c(0, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[0][4] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc01_c(0, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[0][5] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc11_c(0, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[0][6] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc21_c(0, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[0][7] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc31_c(0, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[0][8] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc02_c(0, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[0][9] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc12_c(0, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[0][10] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc22_c(0, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[0][11] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc32_c(0, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[0][12] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc03_c(0, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[0][13] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc13_c(0, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[0][14] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc23_c(0, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[0][15] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc33_c(0, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[1][0] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.pixels_c(0, 8, dst_base, dst_offset, src_base, src_offset, stride, 8);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[1][1] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc10_c(0, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[1][2] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc20_c(0, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[1][3] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc30_c(0, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[1][4] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc01_c(0, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[1][5] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc11_c(0, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[1][6] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc21_c(0, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[1][7] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc31_c(0, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[1][8] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc02_c(0, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[1][9] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc12_c(0, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[1][10] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc22_c(0, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[1][11] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc32_c(0, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[1][12] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc03_c(0, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[1][13] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc13_c(0, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[1][14] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc23_c(0, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[1][15] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc33_c(0, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[2][0] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc00_c(0, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[2][1] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc10_c(0, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[2][2] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc20_c(0, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[2][3] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc30_c(0, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[2][4] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc01_c(0, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[2][5] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc11_c(0, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[2][6] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc21_c(0, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[2][7] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc31_c(0, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[2][8] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc02_c(0, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[2][9] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc12_c(0, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[2][10] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc22_c(0, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[2][11] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc32_c(0, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[2][12] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc03_c(0, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[2][13] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc13_c(0, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[2][14] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc23_c(0, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[2][15] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc33_c(0, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[3][0] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc00_c(0, 2, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[3][1] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc10_c(0, 2, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[3][2] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc20_c(0, 2, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[3][3] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc30_c(0, 2, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[3][4] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc01_c(0, 2, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[3][5] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc11_c(0, 2, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[3][6] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc21_c(0, 2, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[3][7] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc31_c(0, 2, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[3][8] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc02_c(0, 2, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[3][9] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc12_c(0, 2, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[3][10] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc22_c(0, 2, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[3][11] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc32_c(0, 2, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[3][12] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc03_c(0, 2, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[3][13] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc13_c(0, 2, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[3][14] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc23_c(0, 2, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.put_h264_qpel_pixels_tab[3][15] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc33_c(0, 2, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[0][0] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.pixels_c(1, 16, dst_base, dst_offset, src_base, src_offset, stride, 16);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[0][1] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc10_c(1, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[0][2] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc20_c(1, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[0][3] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc30_c(1, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[0][4] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc01_c(1, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[0][5] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc11_c(1, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[0][6] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc21_c(1, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[0][7] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc31_c(1, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[0][8] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc02_c(1, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[0][9] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc12_c(1, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[0][10] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc22_c(1, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[0][11] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc32_c(1, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[0][12] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc03_c(1, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[0][13] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc13_c(1, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[0][14] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc23_c(1, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[0][15] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc33_c(1, 16, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[1][0] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.pixels_c(1, 8, dst_base, dst_offset, src_base, src_offset, stride, 8);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[1][1] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc10_c(1, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[1][2] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc20_c(1, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[1][3] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc30_c(1, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[1][4] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc01_c(1, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[1][5] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc11_c(1, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[1][6] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc21_c(1, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[1][7] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc31_c(1, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[1][8] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc02_c(1, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[1][9] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc12_c(1, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[1][10] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc22_c(1, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[1][11] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc32_c(1, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[1][12] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc03_c(1, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[1][13] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc13_c(1, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[1][14] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc23_c(1, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[1][15] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc33_c(1, 8, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[2][0] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc00_c(1, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[2][1] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc10_c(1, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[2][2] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc20_c(1, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[2][3] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc30_c(1, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[2][4] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc01_c(1, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[2][5] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc11_c(1, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[2][6] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc21_c(1, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[2][7] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc31_c(1, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[2][8] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc02_c(1, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[2][9] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc12_c(1, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[2][10] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc22_c(1, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[2][11] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc32_c(1, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[2][12] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc03_c(1, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[2][13] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc13_c(1, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[2][14] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc23_c(1, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        DSPContext.avg_h264_qpel_pixels_tab[2][15] = new Ih264_qpel_mc_func(){

            @Override
            public void h264_qpel_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int stride) {
                DSPContext.h264_qpel_mc33_c(1, 4, dst_base, dst_offset, src_base, src_offset, stride);
            }
        };
        this.put_h264_chroma_pixels_tab[0] = new Ih264_chroma_mc_func(){

            @Override
            public void h264_chroma_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int srcStride, int h, int x, int y) {
                DSPContext.this.put_h264_chroma_mc8_c(dst_base, dst_offset, src_base, src_offset, srcStride, h, x, y);
            }
        };
        this.put_h264_chroma_pixels_tab[1] = new Ih264_chroma_mc_func(){

            @Override
            public void h264_chroma_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int srcStride, int h, int x, int y) {
                DSPContext.this.put_h264_chroma_mc4_c(dst_base, dst_offset, src_base, src_offset, srcStride, h, x, y);
            }
        };
        this.put_h264_chroma_pixels_tab[2] = new Ih264_chroma_mc_func(){

            @Override
            public void h264_chroma_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int srcStride, int h, int x, int y) {
                DSPContext.this.put_h264_chroma_mc2_c(dst_base, dst_offset, src_base, src_offset, srcStride, h, x, y);
            }
        };
        this.avg_h264_chroma_pixels_tab[0] = new Ih264_chroma_mc_func(){

            @Override
            public void h264_chroma_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int srcStride, int h, int x, int y) {
                DSPContext.this.avg_h264_chroma_mc8_c(dst_base, dst_offset, src_base, src_offset, srcStride, h, x, y);
            }
        };
        this.avg_h264_chroma_pixels_tab[1] = new Ih264_chroma_mc_func(){

            @Override
            public void h264_chroma_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int srcStride, int h, int x, int y) {
                DSPContext.this.avg_h264_chroma_mc4_c(dst_base, dst_offset, src_base, src_offset, srcStride, h, x, y);
            }
        };
        this.avg_h264_chroma_pixels_tab[2] = new Ih264_chroma_mc_func(){

            @Override
            public void h264_chroma_mc_func(int[] dst_base, int dst_offset, int[] src_base, int src_offset, int srcStride, int h, int x, int y) {
                DSPContext.this.avg_h264_chroma_mc2_c(dst_base, dst_offset, src_base, src_offset, srcStride, h, x, y);
            }
        };
        switch (this.idct_permutation_type) {
            case 1: {
                for (int i = 0; i < 64; ++i) {
                    this.idct_permutation[i] = i;
                }
                break;
            }
        }
    }

    public static interface Ih264_chroma_mc_func {
        public void h264_chroma_mc_func(int[] var1, int var2, int[] var3, int var4, int var5, int var6, int var7, int var8);
    }

    public static interface Ih264_qpel_mc_func {
        public void h264_qpel_mc_func(int[] var1, int var2, int[] var3, int var4, int var5);
    }
}

