/*
 * Decompiled with CFR 0.152.
 */
package com.twilight.h264.decoder;

import com.twilight.h264.decoder.H264DSPContext;

public class H264PredictionContext {
    public static final int CODEC_ID_NONE = 0;
    public static final int CODEC_ID_MPEG1VIDEO = 1;
    public static final int CODEC_ID_MPEG2VIDEO = 2;
    public static final int CODEC_ID_MPEG2VIDEO_XVMC = 3;
    public static final int CODEC_ID_H261 = 4;
    public static final int CODEC_ID_H263 = 5;
    public static final int CODEC_ID_RV10 = 6;
    public static final int CODEC_ID_RV20 = 7;
    public static final int CODEC_ID_MJPEG = 8;
    public static final int CODEC_ID_MJPEGB = 9;
    public static final int CODEC_ID_LJPEG = 10;
    public static final int CODEC_ID_SP5X = 11;
    public static final int CODEC_ID_JPEGLS = 12;
    public static final int CODEC_ID_MPEG4 = 13;
    public static final int CODEC_ID_RAWVIDEO = 14;
    public static final int CODEC_ID_MSMPEG4V1 = 15;
    public static final int CODEC_ID_MSMPEG4V2 = 16;
    public static final int CODEC_ID_MSMPEG4V3 = 17;
    public static final int CODEC_ID_WMV1 = 18;
    public static final int CODEC_ID_WMV2 = 19;
    public static final int CODEC_ID_H263P = 20;
    public static final int CODEC_ID_H263I = 21;
    public static final int CODEC_ID_FLV1 = 22;
    public static final int CODEC_ID_SVQ1 = 23;
    public static final int CODEC_ID_SVQ3 = 24;
    public static final int CODEC_ID_DVVIDEO = 25;
    public static final int CODEC_ID_HUFFYUV = 26;
    public static final int CODEC_ID_CYUV = 27;
    public static final int CODEC_ID_H264 = 28;
    public static final int CODEC_ID_INDEO3 = 29;
    public static final int CODEC_ID_VP3 = 30;
    public static final int CODEC_ID_THEORA = 31;
    public static final int CODEC_ID_ASV1 = 32;
    public static final int CODEC_ID_ASV2 = 33;
    public static final int CODEC_ID_FFV1 = 34;
    public static final int CODEC_ID_4XM = 35;
    public static final int CODEC_ID_VCR1 = 36;
    public static final int CODEC_ID_CLJR = 37;
    public static final int CODEC_ID_MDEC = 38;
    public static final int CODEC_ID_ROQ = 39;
    public static final int CODEC_ID_INTERPLAY_VIDEO = 40;
    public static final int CODEC_ID_XAN_WC3 = 41;
    public static final int CODEC_ID_XAN_WC4 = 42;
    public static final int CODEC_ID_RPZA = 43;
    public static final int CODEC_ID_CINEPAK = 44;
    public static final int CODEC_ID_WS_VQA = 45;
    public static final int CODEC_ID_MSRLE = 46;
    public static final int CODEC_ID_MSVIDEO1 = 47;
    public static final int CODEC_ID_IDCIN = 48;
    public static final int CODEC_ID_8BPS = 49;
    public static final int CODEC_ID_SMC = 50;
    public static final int CODEC_ID_FLIC = 51;
    public static final int CODEC_ID_TRUEMOTION1 = 52;
    public static final int CODEC_ID_VMDVIDEO = 53;
    public static final int CODEC_ID_MSZH = 54;
    public static final int CODEC_ID_ZLIB = 55;
    public static final int CODEC_ID_QTRLE = 56;
    public static final int CODEC_ID_SNOW = 57;
    public static final int CODEC_ID_TSCC = 58;
    public static final int CODEC_ID_ULTI = 59;
    public static final int CODEC_ID_QDRAW = 60;
    public static final int CODEC_ID_VIXL = 61;
    public static final int CODEC_ID_QPEG = 62;
    public static final int CODEC_ID_PNG = 63;
    public static final int CODEC_ID_PPM = 64;
    public static final int CODEC_ID_PBM = 65;
    public static final int CODEC_ID_PGM = 66;
    public static final int CODEC_ID_PGMYUV = 67;
    public static final int CODEC_ID_PAM = 68;
    public static final int CODEC_ID_FFVHUFF = 69;
    public static final int CODEC_ID_RV30 = 70;
    public static final int CODEC_ID_RV40 = 71;
    public static final int CODEC_ID_VC1 = 72;
    public static final int CODEC_ID_WMV3 = 73;
    public static final int CODEC_ID_LOCO = 74;
    public static final int CODEC_ID_WNV1 = 75;
    public static final int CODEC_ID_AASC = 76;
    public static final int CODEC_ID_INDEO2 = 77;
    public static final int CODEC_ID_FRAPS = 78;
    public static final int CODEC_ID_TRUEMOTION2 = 79;
    public static final int CODEC_ID_BMP = 80;
    public static final int CODEC_ID_CSCD = 81;
    public static final int CODEC_ID_MMVIDEO = 82;
    public static final int CODEC_ID_ZMBV = 83;
    public static final int CODEC_ID_AVS = 84;
    public static final int CODEC_ID_SMACKVIDEO = 85;
    public static final int CODEC_ID_NUV = 86;
    public static final int CODEC_ID_KMVC = 87;
    public static final int CODEC_ID_FLASHSV = 88;
    public static final int CODEC_ID_CAVS = 89;
    public static final int CODEC_ID_JPEG2000 = 90;
    public static final int CODEC_ID_VMNC = 91;
    public static final int CODEC_ID_VP5 = 92;
    public static final int CODEC_ID_VP6 = 93;
    public static final int CODEC_ID_VP6F = 94;
    public static final int CODEC_ID_TARGA = 95;
    public static final int CODEC_ID_DSICINVIDEO = 96;
    public static final int CODEC_ID_TIERTEXSEQVIDEO = 97;
    public static final int CODEC_ID_TIFF = 98;
    public static final int CODEC_ID_GIF = 99;
    public static final int CODEC_ID_FFH264 = 100;
    public static final int CODEC_ID_DXA = 101;
    public static final int CODEC_ID_DNXHD = 102;
    public static final int CODEC_ID_THP = 103;
    public static final int CODEC_ID_SGI = 104;
    public static final int CODEC_ID_C93 = 105;
    public static final int CODEC_ID_BETHSOFTVID = 106;
    public static final int CODEC_ID_PTX = 107;
    public static final int CODEC_ID_TXD = 108;
    public static final int CODEC_ID_VP6A = 109;
    public static final int CODEC_ID_AMV = 110;
    public static final int CODEC_ID_VB = 111;
    public static final int CODEC_ID_PCX = 112;
    public static final int CODEC_ID_SUNRAST = 113;
    public static final int CODEC_ID_INDEO4 = 114;
    public static final int CODEC_ID_INDEO5 = 115;
    public static final int CODEC_ID_MIMIC = 116;
    public static final int CODEC_ID_RL2 = 117;
    public static final int CODEC_ID_8SVX_EXP = 118;
    public static final int CODEC_ID_8SVX_FIB = 119;
    public static final int CODEC_ID_ESCAPE124 = 120;
    public static final int CODEC_ID_DIRAC = 121;
    public static final int CODEC_ID_BFI = 122;
    public static final int CODEC_ID_CMV = 123;
    public static final int CODEC_ID_MOTIONPIXELS = 124;
    public static final int CODEC_ID_TGV = 125;
    public static final int CODEC_ID_TGQ = 126;
    public static final int CODEC_ID_TQI = 127;
    public static final int CODEC_ID_AURA = 128;
    public static final int CODEC_ID_AURA2 = 129;
    public static final int CODEC_ID_V210X = 130;
    public static final int CODEC_ID_TMV = 131;
    public static final int CODEC_ID_V210 = 132;
    public static final int CODEC_ID_DPX = 133;
    public static final int CODEC_ID_MAD = 134;
    public static final int CODEC_ID_FRWU = 135;
    public static final int CODEC_ID_FLASHSV2 = 136;
    public static final int CODEC_ID_CDGRAPHICS = 137;
    public static final int CODEC_ID_R210 = 138;
    public static final int CODEC_ID_ANM = 139;
    public static final int CODEC_ID_BINKVIDEO = 140;
    public static final int CODEC_ID_IFF_ILBM = 141;
    public static final int CODEC_ID_IFF_BYTERUN1 = 142;
    public static final int CODEC_ID_KGV1 = 143;
    public static final int CODEC_ID_YOP = 144;
    public static final int CODEC_ID_VP8 = 145;
    public static final int CODEC_ID_PICTOR = 146;
    public static final int CODEC_ID_ANSI = 147;
    public static final int CODEC_ID_A64_MULTI = 148;
    public static final int CODEC_ID_A64_MULTI5 = 149;
    public static final int CODEC_ID_R10K = 150;
    public static final int CODEC_ID_MXPEG = 151;
    public static final int CODEC_ID_LAGARITH = 152;
    public static final int VERT_PRED = 0;
    public static final int HOR_PRED = 1;
    public static final int DC_PRED = 2;
    public static final int DIAG_DOWN_LEFT_PRED = 3;
    public static final int DIAG_DOWN_RIGHT_PRED = 4;
    public static final int VERT_RIGHT_PRED = 5;
    public static final int HOR_DOWN_PRED = 6;
    public static final int VERT_LEFT_PRED = 7;
    public static final int HOR_UP_PRED = 8;
    public static final int LEFT_DC_PRED = 9;
    public static final int TOP_DC_PRED = 10;
    public static final int DC_128_PRED = 11;
    public static final int DIAG_DOWN_LEFT_PRED_RV40_NODOWN = 12;
    public static final int HOR_UP_PRED_RV40_NODOWN = 13;
    public static final int VERT_LEFT_PRED_RV40_NODOWN = 14;
    public static final int TM_VP8_PRED = 9;
    public static final int VERT_VP8_PRED = 10;
    public static final int HOR_VP8_PRED = 11;
    public static final int DC_127_PRED = 12;
    public static final int DC_129_PRED = 13;
    public static final int DC_PRED8x8 = 0;
    public static final int HOR_PRED8x8 = 1;
    public static final int VERT_PRED8x8 = 2;
    public static final int PLANE_PRED8x8 = 3;
    public static final int LEFT_DC_PRED8x8 = 4;
    public static final int TOP_DC_PRED8x8 = 5;
    public static final int DC_128_PRED8x8 = 6;
    public static final int ALZHEIMER_DC_L0T_PRED8x8 = 7;
    public static final int ALZHEIMER_DC_0LT_PRED8x8 = 8;
    public static final int ALZHEIMER_DC_L00_PRED8x8 = 9;
    public static final int ALZHEIMER_DC_0L0_PRED8x8 = 10;
    public static final int DC_127_PRED8x8 = 7;
    public static final int DC_129_PRED8x8 = 8;
    public IPrediction4x4[] pred4x4 = new IPrediction4x4[15];
    public IPrediction8x8L[] pred8x8l = new IPrediction8x8L[12];
    public IPrediction8x8[] pred8x8 = new IPrediction8x8[11];
    public IPrediction16x16[] pred16x16 = new IPrediction16x16[9];
    public IPrediction4x4_add[] pred4x4_add = new IPrediction4x4_add[2];
    public IPrediction8x8L_add[] pred8x8l_add = new IPrediction8x8L_add[2];
    public IPrediction8x8_add[] pred8x8_add = new IPrediction8x8_add[3];
    public IPrediction16x16_add[] pred16x16_add = new IPrediction16x16_add[3];

    public void initializePredictionContext(int codec_id) {
        if (codec_id != 71) {
            if (codec_id == 145) {
                this.pred4x4[0] = new IPrediction4x4(){

                    @Override
                    public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                        H264PredictionContext.pred4x4_vertical_vp8_c(src, src_offset, topright, topright_offset, stride);
                    }
                };
                this.pred4x4[1] = new IPrediction4x4(){

                    @Override
                    public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                        H264PredictionContext.pred4x4_horizontal_vp8_c(src, src_offset, topright, topright_offset, stride);
                    }
                };
            } else {
                this.pred4x4[0] = new IPrediction4x4(){

                    @Override
                    public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                        H264PredictionContext.pred4x4_vertical_c(src, src_offset, topright, topright_offset, stride);
                    }
                };
                this.pred4x4[1] = new IPrediction4x4(){

                    @Override
                    public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                        H264PredictionContext.pred4x4_horizontal_c(src, src_offset, topright, topright_offset, stride);
                    }
                };
            }
            this.pred4x4[2] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_dc_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[3] = codec_id == 24 ? new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_down_left_svq3_c(src, src_offset, topright, topright_offset, stride);
                }
            } : new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_down_left_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[4] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_down_right_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[5] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_vertical_right_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[6] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_horizontal_down_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[7] = codec_id == 145 ? new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_vertical_left_vp8_c(src, src_offset, topright, topright_offset, stride);
                }
            } : new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_vertical_left_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[8] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_horizontal_up_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            if (codec_id != 145) {
                this.pred4x4[9] = new IPrediction4x4(){

                    @Override
                    public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                        H264PredictionContext.pred4x4_left_dc_c(src, src_offset, topright, topright_offset, stride);
                    }
                };
                this.pred4x4[10] = new IPrediction4x4(){

                    @Override
                    public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                        H264PredictionContext.pred4x4_top_dc_c(src, src_offset, topright, topright_offset, stride);
                    }
                };
                this.pred4x4[11] = new IPrediction4x4(){

                    @Override
                    public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                        H264PredictionContext.pred4x4_128_dc_c(src, src_offset, topright, topright_offset, stride);
                    }
                };
            } else {
                this.pred4x4[9] = new IPrediction4x4(){

                    @Override
                    public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                        H264PredictionContext.pred4x4_tm_vp8_c(src, src_offset, topright, topright_offset, stride);
                    }
                };
                this.pred4x4[12] = new IPrediction4x4(){

                    @Override
                    public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                        H264PredictionContext.pred4x4_127_dc_c(src, src_offset, topright, topright_offset, stride);
                    }
                };
                this.pred4x4[13] = new IPrediction4x4(){

                    @Override
                    public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                        H264PredictionContext.pred4x4_129_dc_c(src, src_offset, topright, topright_offset, stride);
                    }
                };
                this.pred4x4[10] = new IPrediction4x4(){

                    @Override
                    public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                        H264PredictionContext.pred4x4_vertical_c(src, src_offset, topright, topright_offset, stride);
                    }
                };
                this.pred4x4[11] = new IPrediction4x4(){

                    @Override
                    public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                        H264PredictionContext.pred4x4_horizontal_c(src, src_offset, topright, topright_offset, stride);
                    }
                };
            }
        } else {
            this.pred4x4[0] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_vertical_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[1] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_horizontal_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[2] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_dc_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[3] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_down_left_rv40_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[4] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_down_right_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[5] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_vertical_right_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[6] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_horizontal_down_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[7] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_vertical_left_rv40_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[8] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_horizontal_up_rv40_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[9] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_left_dc_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[10] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_top_dc_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[11] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_128_dc_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[12] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_down_left_rv40_nodown_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[13] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_horizontal_up_rv40_nodown_c(src, src_offset, topright, topright_offset, stride);
                }
            };
            this.pred4x4[14] = new IPrediction4x4(){

                @Override
                public void pred4x4(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
                    H264PredictionContext.pred4x4_vertical_left_rv40_nodown_c(src, src_offset, topright, topright_offset, stride);
                }
            };
        }
        this.pred8x8l[0] = new IPrediction8x8L(){

            @Override
            public void pred8x8l(int[] src, int src_offset, int topleft, int topright, int stride) {
                H264PredictionContext.pred8x8l_vertical_c(src, src_offset, topleft, topright, stride);
            }
        };
        this.pred8x8l[1] = new IPrediction8x8L(){

            @Override
            public void pred8x8l(int[] src, int src_offset, int topleft, int topright, int stride) {
                H264PredictionContext.pred8x8l_horizontal_c(src, src_offset, topleft, topright, stride);
            }
        };
        this.pred8x8l[2] = new IPrediction8x8L(){

            @Override
            public void pred8x8l(int[] src, int src_offset, int topleft, int topright, int stride) {
                H264PredictionContext.pred8x8l_dc_c(src, src_offset, topleft, topright, stride);
            }
        };
        this.pred8x8l[3] = new IPrediction8x8L(){

            @Override
            public void pred8x8l(int[] src, int src_offset, int topleft, int topright, int stride) {
                H264PredictionContext.pred8x8l_down_left_c(src, src_offset, topleft, topright, stride);
            }
        };
        this.pred8x8l[4] = new IPrediction8x8L(){

            @Override
            public void pred8x8l(int[] src, int src_offset, int topleft, int topright, int stride) {
                H264PredictionContext.pred8x8l_down_right_c(src, src_offset, topleft, topright, stride);
            }
        };
        this.pred8x8l[5] = new IPrediction8x8L(){

            @Override
            public void pred8x8l(int[] src, int src_offset, int topleft, int topright, int stride) {
                H264PredictionContext.pred8x8l_vertical_right_c(src, src_offset, topleft, topright, stride);
            }
        };
        this.pred8x8l[6] = new IPrediction8x8L(){

            @Override
            public void pred8x8l(int[] src, int src_offset, int topleft, int topright, int stride) {
                H264PredictionContext.pred8x8l_horizontal_down_c(src, src_offset, topleft, topright, stride);
            }
        };
        this.pred8x8l[7] = new IPrediction8x8L(){

            @Override
            public void pred8x8l(int[] src, int src_offset, int topleft, int topright, int stride) {
                H264PredictionContext.pred8x8l_vertical_left_c(src, src_offset, topleft, topright, stride);
            }
        };
        this.pred8x8l[8] = new IPrediction8x8L(){

            @Override
            public void pred8x8l(int[] src, int src_offset, int topleft, int topright, int stride) {
                H264PredictionContext.pred8x8l_horizontal_up_c(src, src_offset, topleft, topright, stride);
            }
        };
        this.pred8x8l[9] = new IPrediction8x8L(){

            @Override
            public void pred8x8l(int[] src, int src_offset, int topleft, int topright, int stride) {
                H264PredictionContext.pred8x8l_left_dc_c(src, src_offset, topleft, topright, stride);
            }
        };
        this.pred8x8l[10] = new IPrediction8x8L(){

            @Override
            public void pred8x8l(int[] src, int src_offset, int topleft, int topright, int stride) {
                H264PredictionContext.pred8x8l_top_dc_c(src, src_offset, topleft, topright, stride);
            }
        };
        this.pred8x8l[11] = new IPrediction8x8L(){

            @Override
            public void pred8x8l(int[] src, int src_offset, int topleft, int topright, int stride) {
                H264PredictionContext.pred8x8l_128_dc_c(src, src_offset, topleft, topright, stride);
            }
        };
        this.pred8x8[2] = new IPrediction8x8(){

            @Override
            public void pred8x8(int[] src, int src_offset, int stride) {
                H264PredictionContext.pred8x8_vertical_c(src, src_offset, stride);
            }
        };
        this.pred8x8[1] = new IPrediction8x8(){

            @Override
            public void pred8x8(int[] src, int src_offset, int stride) {
                H264PredictionContext.pred8x8_horizontal_c(src, src_offset, stride);
            }
        };
        this.pred8x8[3] = codec_id != 145 ? new IPrediction8x8(){

            @Override
            public void pred8x8(int[] src, int src_offset, int stride) {
                H264PredictionContext.pred8x8_plane_c(src, src_offset, stride);
            }
        } : new IPrediction8x8(){

            @Override
            public void pred8x8(int[] src, int src_offset, int stride) {
                H264PredictionContext.pred8x8_tm_vp8_c(src, src_offset, stride);
            }
        };
        if (codec_id != 71 && codec_id != 145) {
            this.pred8x8[0] = new IPrediction8x8(){

                @Override
                public void pred8x8(int[] src, int src_offset, int stride) {
                    H264PredictionContext.pred8x8_dc_c(src, src_offset, stride);
                }
            };
            this.pred8x8[4] = new IPrediction8x8(){

                @Override
                public void pred8x8(int[] src, int src_offset, int stride) {
                    H264PredictionContext.pred8x8_left_dc_c(src, src_offset, stride);
                }
            };
            this.pred8x8[5] = new IPrediction8x8(){

                @Override
                public void pred8x8(int[] src, int src_offset, int stride) {
                    H264PredictionContext.pred8x8_top_dc_c(src, src_offset, stride);
                }
            };
            this.pred8x8[7] = new IPrediction8x8(){

                @Override
                public void pred8x8(int[] src, int src_offset, int stride) {
                    H264PredictionContext.pred8x8_mad_cow_dc_l0t(src, src_offset, stride);
                }
            };
            this.pred8x8[8] = new IPrediction8x8(){

                @Override
                public void pred8x8(int[] src, int src_offset, int stride) {
                    H264PredictionContext.pred8x8_mad_cow_dc_0lt(src, src_offset, stride);
                }
            };
            this.pred8x8[9] = new IPrediction8x8(){

                @Override
                public void pred8x8(int[] src, int src_offset, int stride) {
                    H264PredictionContext.pred8x8_mad_cow_dc_l00(src, src_offset, stride);
                }
            };
            this.pred8x8[10] = new IPrediction8x8(){

                @Override
                public void pred8x8(int[] src, int src_offset, int stride) {
                    H264PredictionContext.pred8x8_mad_cow_dc_0l0(src, src_offset, stride);
                }
            };
        } else {
            this.pred8x8[0] = new IPrediction8x8(){

                @Override
                public void pred8x8(int[] src, int src_offset, int stride) {
                    H264PredictionContext.pred8x8_dc_rv40_c(src, src_offset, stride);
                }
            };
            this.pred8x8[4] = new IPrediction8x8(){

                @Override
                public void pred8x8(int[] src, int src_offset, int stride) {
                    H264PredictionContext.pred8x8_left_dc_rv40_c(src, src_offset, stride);
                }
            };
            this.pred8x8[5] = new IPrediction8x8(){

                @Override
                public void pred8x8(int[] src, int src_offset, int stride) {
                    H264PredictionContext.pred8x8_top_dc_rv40_c(src, src_offset, stride);
                }
            };
            if (codec_id == 145) {
                this.pred8x8[7] = new IPrediction8x8(){

                    @Override
                    public void pred8x8(int[] src, int src_offset, int stride) {
                        H264PredictionContext.pred8x8_127_dc_c(src, src_offset, stride);
                    }
                };
                this.pred8x8[8] = new IPrediction8x8(){

                    @Override
                    public void pred8x8(int[] src, int src_offset, int stride) {
                        H264PredictionContext.pred8x8_129_dc_c(src, src_offset, stride);
                    }
                };
            }
        }
        this.pred8x8[6] = new IPrediction8x8(){

            @Override
            public void pred8x8(int[] src, int src_offset, int stride) {
                H264PredictionContext.pred8x8_128_dc_c(src, src_offset, stride);
            }
        };
        this.pred16x16[0] = new IPrediction16x16(){

            @Override
            public void pred16x16(int[] src, int src_offset, int stride) {
                H264PredictionContext.pred16x16_dc_c(src, src_offset, stride);
            }
        };
        this.pred16x16[2] = new IPrediction16x16(){

            @Override
            public void pred16x16(int[] src, int src_offset, int stride) {
                H264PredictionContext.pred16x16_vertical_c(src, src_offset, stride);
            }
        };
        this.pred16x16[1] = new IPrediction16x16(){

            @Override
            public void pred16x16(int[] src, int src_offset, int stride) {
                H264PredictionContext.pred16x16_horizontal_c(src, src_offset, stride);
            }
        };
        switch (codec_id) {
            case 24: {
                this.pred16x16[3] = new IPrediction16x16(){

                    @Override
                    public void pred16x16(int[] src, int src_offset, int stride) {
                        H264PredictionContext.pred16x16_plane_svq3_c(src, src_offset, stride);
                    }
                };
                break;
            }
            case 71: {
                this.pred16x16[3] = new IPrediction16x16(){

                    @Override
                    public void pred16x16(int[] src, int src_offset, int stride) {
                        H264PredictionContext.pred16x16_plane_rv40_c(src, src_offset, stride);
                    }
                };
                break;
            }
            case 145: {
                this.pred16x16[3] = new IPrediction16x16(){

                    @Override
                    public void pred16x16(int[] src, int src_offset, int stride) {
                        H264PredictionContext.pred16x16_tm_vp8_c(src, src_offset, stride);
                    }
                };
                this.pred16x16[7] = new IPrediction16x16(){

                    @Override
                    public void pred16x16(int[] src, int src_offset, int stride) {
                        H264PredictionContext.pred16x16_127_dc_c(src, src_offset, stride);
                    }
                };
                this.pred16x16[8] = new IPrediction16x16(){

                    @Override
                    public void pred16x16(int[] src, int src_offset, int stride) {
                        H264PredictionContext.pred16x16_129_dc_c(src, src_offset, stride);
                    }
                };
                break;
            }
            default: {
                this.pred16x16[3] = new IPrediction16x16(){

                    @Override
                    public void pred16x16(int[] src, int src_offset, int stride) {
                        H264PredictionContext.pred16x16_plane_c(src, src_offset, stride);
                    }
                };
            }
        }
        this.pred16x16[4] = new IPrediction16x16(){

            @Override
            public void pred16x16(int[] src, int src_offset, int stride) {
                H264PredictionContext.pred16x16_left_dc_c(src, src_offset, stride);
            }
        };
        this.pred16x16[5] = new IPrediction16x16(){

            @Override
            public void pred16x16(int[] src, int src_offset, int stride) {
                H264PredictionContext.pred16x16_top_dc_c(src, src_offset, stride);
            }
        };
        this.pred16x16[6] = new IPrediction16x16(){

            @Override
            public void pred16x16(int[] src, int src_offset, int stride) {
                H264PredictionContext.pred16x16_128_dc_c(src, src_offset, stride);
            }
        };
        this.pred4x4_add[0] = new IPrediction4x4_add(){

            @Override
            public void pred4x4_add(int[] pix, int pix_offset, short[] block, int _block_offset, int stride) {
                H264PredictionContext.pred4x4_vertical_add_c(pix, pix_offset, block, _block_offset, stride);
            }
        };
        this.pred4x4_add[1] = new IPrediction4x4_add(){

            @Override
            public void pred4x4_add(int[] pix, int pix_offset, short[] block, int _block_offset, int stride) {
                H264PredictionContext.pred4x4_horizontal_add_c(pix, pix_offset, block, _block_offset, stride);
            }
        };
        this.pred8x8l_add[0] = new IPrediction8x8L_add(){

            @Override
            public void pred8x8l_add(int[] pix, int pix_offset, short[] block, int _block_offset, int stride) {
                H264PredictionContext.pred8x8l_vertical_add_c(pix, pix_offset, block, _block_offset, stride);
            }
        };
        this.pred8x8l_add[1] = new IPrediction8x8L_add(){

            @Override
            public void pred8x8l_add(int[] pix, int pix_offset, short[] block, int _block_offset, int stride) {
                H264PredictionContext.pred8x8l_horizontal_add_c(pix, pix_offset, block, _block_offset, stride);
            }
        };
        this.pred8x8_add[2] = new IPrediction8x8_add(){

            @Override
            public void pred8x8_add(int[] pix, int pix_offset, int[] block_offset, int block_offset_offset, short[] block, int _block_offset, int stride) {
                H264PredictionContext.pred8x8_vertical_add_c(pix, pix_offset, block_offset, block_offset_offset, block, _block_offset, stride);
            }
        };
        this.pred8x8_add[1] = new IPrediction8x8_add(){

            @Override
            public void pred8x8_add(int[] pix, int pix_offset, int[] block_offset, int block_offset_offset, short[] block, int _block_offset, int stride) {
                H264PredictionContext.pred8x8_horizontal_add_c(pix, pix_offset, block_offset, block_offset_offset, block, _block_offset, stride);
            }
        };
        this.pred16x16_add[2] = new IPrediction16x16_add(){

            @Override
            public void pred16x16_add(int[] pix, int pix_offset, int[] block_offset, int block_offset_offset, short[] block, int _block_offset, int stride) {
                H264PredictionContext.pred16x16_vertical_add_c(pix, pix_offset, block_offset, block_offset_offset, block, _block_offset, stride);
            }
        };
        this.pred16x16_add[1] = new IPrediction16x16_add(){

            @Override
            public void pred16x16_add(int[] pix, int pix_offset, int[] block_offset, int block_offset_offset, short[] block, int _block_offset, int stride) {
                H264PredictionContext.pred16x16_horizontal_add_c(pix, pix_offset, block_offset, block_offset_offset, block, _block_offset, stride);
            }
        };
    }

    public static void pred4x4_vertical_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int a0 = src[src_offset - stride + 0];
        int a1 = src[src_offset - stride + 1];
        int a2 = src[src_offset - stride + 2];
        int a3 = src[src_offset - stride + 3];
        src[src_offset + 0 * stride + 0] = a0;
        src[src_offset + 0 * stride + 1] = a1;
        src[src_offset + 0 * stride + 2] = a2;
        src[src_offset + 0 * stride + 3] = a3;
        src[src_offset + 1 * stride + 0] = a0;
        src[src_offset + 1 * stride + 1] = a1;
        src[src_offset + 1 * stride + 2] = a2;
        src[src_offset + 1 * stride + 3] = a3;
        src[src_offset + 2 * stride + 0] = a0;
        src[src_offset + 2 * stride + 1] = a1;
        src[src_offset + 2 * stride + 2] = a2;
        src[src_offset + 2 * stride + 3] = a3;
        src[src_offset + 3 * stride + 0] = a0;
        src[src_offset + 3 * stride + 1] = a1;
        src[src_offset + 3 * stride + 2] = a2;
        src[src_offset + 3 * stride + 3] = a3;
    }

    public static void pred4x4_horizontal_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int a;
        src[src_offset + 0 * stride + 0] = a = src[src_offset - 1 + 0 * stride + 0];
        src[src_offset + 0 * stride + 1] = a;
        src[src_offset + 0 * stride + 2] = a;
        src[src_offset + 0 * stride + 3] = a;
        src[src_offset + 1 * stride + 0] = a = src[src_offset - 1 + 1 * stride + 0];
        src[src_offset + 1 * stride + 1] = a;
        src[src_offset + 1 * stride + 2] = a;
        src[src_offset + 1 * stride + 3] = a;
        src[src_offset + 2 * stride + 0] = a = src[src_offset - 1 + 2 * stride + 0];
        src[src_offset + 2 * stride + 1] = a;
        src[src_offset + 2 * stride + 2] = a;
        src[src_offset + 2 * stride + 3] = a;
        src[src_offset + 3 * stride + 0] = a = src[src_offset - 1 + 3 * stride + 0];
        src[src_offset + 3 * stride + 1] = a;
        src[src_offset + 3 * stride + 2] = a;
        src[src_offset + 3 * stride + 3] = a;
    }

    public static void pred4x4_dc_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int dc;
        src[src_offset + 0 * stride + 0] = dc = src[src_offset - stride] + src[src_offset + 1 - stride] + src[src_offset + 2 - stride] + src[src_offset + 3 - stride] + src[src_offset - 1 + 0 * stride] + src[src_offset - 1 + 1 * stride] + src[src_offset - 1 + 2 * stride] + src[src_offset - 1 + 3 * stride] + 4 >> 3;
        src[src_offset + 1 * stride + 0] = dc;
        src[src_offset + 2 * stride + 0] = dc;
        src[src_offset + 3 * stride + 0] = dc;
        src[src_offset + 0 * stride + 1] = dc;
        src[src_offset + 1 * stride + 1] = dc;
        src[src_offset + 2 * stride + 1] = dc;
        src[src_offset + 3 * stride + 1] = dc;
        src[src_offset + 0 * stride + 2] = dc;
        src[src_offset + 1 * stride + 2] = dc;
        src[src_offset + 2 * stride + 2] = dc;
        src[src_offset + 3 * stride + 2] = dc;
        src[src_offset + 0 * stride + 3] = dc;
        src[src_offset + 1 * stride + 3] = dc;
        src[src_offset + 2 * stride + 3] = dc;
        src[src_offset + 3 * stride + 3] = dc;
    }

    public static void pred4x4_left_dc_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int dc;
        src[src_offset + 0 * stride + 0] = dc = src[src_offset - 1 + 0 * stride] + src[src_offset - 1 + 1 * stride] + src[src_offset - 1 + 2 * stride] + src[src_offset - 1 + 3 * stride] + 2 >> 2;
        src[src_offset + 1 * stride + 0] = dc;
        src[src_offset + 2 * stride + 0] = dc;
        src[src_offset + 3 * stride + 0] = dc;
        src[src_offset + 0 * stride + 1] = dc;
        src[src_offset + 1 * stride + 1] = dc;
        src[src_offset + 2 * stride + 1] = dc;
        src[src_offset + 3 * stride + 1] = dc;
        src[src_offset + 0 * stride + 2] = dc;
        src[src_offset + 1 * stride + 2] = dc;
        src[src_offset + 2 * stride + 2] = dc;
        src[src_offset + 3 * stride + 2] = dc;
        src[src_offset + 0 * stride + 3] = dc;
        src[src_offset + 1 * stride + 3] = dc;
        src[src_offset + 2 * stride + 3] = dc;
        src[src_offset + 3 * stride + 3] = dc;
    }

    public static void pred4x4_top_dc_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int dc;
        src[src_offset + 0 * stride + 0] = dc = src[src_offset - stride] + src[src_offset + 1 - stride] + src[src_offset + 2 - stride] + src[src_offset + 3 - stride] + 2 >> 2;
        src[src_offset + 1 * stride + 0] = dc;
        src[src_offset + 2 * stride + 0] = dc;
        src[src_offset + 3 * stride + 0] = dc;
        src[src_offset + 0 * stride + 1] = dc;
        src[src_offset + 1 * stride + 1] = dc;
        src[src_offset + 2 * stride + 1] = dc;
        src[src_offset + 3 * stride + 1] = dc;
        src[src_offset + 0 * stride + 2] = dc;
        src[src_offset + 1 * stride + 2] = dc;
        src[src_offset + 2 * stride + 2] = dc;
        src[src_offset + 3 * stride + 2] = dc;
        src[src_offset + 0 * stride + 3] = dc;
        src[src_offset + 1 * stride + 3] = dc;
        src[src_offset + 2 * stride + 3] = dc;
        src[src_offset + 3 * stride + 3] = dc;
    }

    public static void pred4x4_128_dc_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int dc;
        src[src_offset + 0 * stride + 0] = dc = 128;
        src[src_offset + 1 * stride + 0] = dc;
        src[src_offset + 2 * stride + 0] = dc;
        src[src_offset + 3 * stride + 0] = dc;
        src[src_offset + 0 * stride + 1] = dc;
        src[src_offset + 1 * stride + 1] = dc;
        src[src_offset + 2 * stride + 1] = dc;
        src[src_offset + 3 * stride + 1] = dc;
        src[src_offset + 0 * stride + 2] = dc;
        src[src_offset + 1 * stride + 2] = dc;
        src[src_offset + 2 * stride + 2] = dc;
        src[src_offset + 3 * stride + 2] = dc;
        src[src_offset + 0 * stride + 3] = dc;
        src[src_offset + 1 * stride + 3] = dc;
        src[src_offset + 2 * stride + 3] = dc;
        src[src_offset + 3 * stride + 3] = dc;
    }

    public static void pred4x4_127_dc_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int dc;
        src[src_offset + 0 * stride + 0] = dc = 127;
        src[src_offset + 1 * stride + 0] = dc;
        src[src_offset + 2 * stride + 0] = dc;
        src[src_offset + 3 * stride + 0] = dc;
        src[src_offset + 0 * stride + 1] = dc;
        src[src_offset + 1 * stride + 1] = dc;
        src[src_offset + 2 * stride + 1] = dc;
        src[src_offset + 3 * stride + 1] = dc;
        src[src_offset + 0 * stride + 2] = dc;
        src[src_offset + 1 * stride + 2] = dc;
        src[src_offset + 2 * stride + 2] = dc;
        src[src_offset + 3 * stride + 2] = dc;
        src[src_offset + 0 * stride + 3] = dc;
        src[src_offset + 1 * stride + 3] = dc;
        src[src_offset + 2 * stride + 3] = dc;
        src[src_offset + 3 * stride + 3] = dc;
    }

    public static void pred4x4_129_dc_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int dc;
        int n = dc = 129;
        src[src_offset + 3 * stride + 3] = n;
        src[src_offset + 2 * stride + 3] = n;
        src[src_offset + 1 * stride + 3] = n;
        src[src_offset + 0 * stride + 3] = n;
        src[src_offset + 3 * stride + 2] = n;
        src[src_offset + 2 * stride + 2] = n;
        src[src_offset + 1 * stride + 2] = n;
        src[src_offset + 0 * stride + 2] = n;
        src[src_offset + 3 * stride + 1] = n;
        src[src_offset + 2 * stride + 1] = n;
        src[src_offset + 1 * stride + 1] = n;
        src[src_offset + 0 * stride + 1] = n;
        src[src_offset + 3 * stride + 0] = n;
        src[src_offset + 2 * stride + 0] = n;
        src[src_offset + 1 * stride + 0] = n;
        src[src_offset + 0 * stride + 0] = n;
    }

    public static void pred4x4_vertical_vp8_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int lt = src[src_offset - 1 - 1 * stride];
        int t0 = src[src_offset + 0 - 1 * stride];
        int t1 = src[src_offset + 1 - 1 * stride];
        int t2 = src[src_offset + 2 - 1 * stride];
        int t3 = src[src_offset + 3 - 1 * stride];
        int t4 = topright[topright_offset + 0];
        src[src_offset + 0 * stride + 0] = lt + 2 * t0 + t1 + 2 >> 2;
        src[src_offset + 0 * stride + 1] = t0 + 2 * t1 + t2 + 2 >> 2;
        src[src_offset + 0 * stride + 2] = t1 + 2 * t2 + t3 + 2 >> 2;
        src[src_offset + 0 * stride + 3] = t2 + 2 * t3 + t4 + 2 >> 2;
        src[src_offset + 1 * stride + 0] = lt + 2 * t0 + t1 + 2 >> 2;
        src[src_offset + 1 * stride + 1] = t0 + 2 * t1 + t2 + 2 >> 2;
        src[src_offset + 1 * stride + 2] = t1 + 2 * t2 + t3 + 2 >> 2;
        src[src_offset + 1 * stride + 3] = t2 + 2 * t3 + t4 + 2 >> 2;
        src[src_offset + 2 * stride + 0] = lt + 2 * t0 + t1 + 2 >> 2;
        src[src_offset + 2 * stride + 1] = t0 + 2 * t1 + t2 + 2 >> 2;
        src[src_offset + 2 * stride + 2] = t1 + 2 * t2 + t3 + 2 >> 2;
        src[src_offset + 2 * stride + 3] = t2 + 2 * t3 + t4 + 2 >> 2;
        src[src_offset + 3 * stride + 0] = lt + 2 * t0 + t1 + 2 >> 2;
        src[src_offset + 3 * stride + 1] = t0 + 2 * t1 + t2 + 2 >> 2;
        src[src_offset + 3 * stride + 2] = t1 + 2 * t2 + t3 + 2 >> 2;
        src[src_offset + 3 * stride + 3] = t2 + 2 * t3 + t4 + 2 >> 2;
    }

    public static void pred4x4_horizontal_vp8_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int lt = src[src_offset - 1 - 1 * stride];
        int l0 = src[src_offset - 1 + 0 * stride];
        int l1 = src[src_offset - 1 + 1 * stride];
        int l2 = src[src_offset - 1 + 2 * stride];
        int l3 = src[src_offset - 1 + 3 * stride];
        int n = lt + 2 * l0 + l1 + 2 >> 2;
        src[src_offset + 0 * stride + 3] = n;
        src[src_offset + 0 * stride + 2] = n;
        src[src_offset + 0 * stride + 1] = n;
        src[src_offset + 0 * stride + 0] = n;
        int n2 = l0 + 2 * l1 + l2 + 2 >> 2;
        src[src_offset + 1 * stride + 3] = n2;
        src[src_offset + 1 * stride + 2] = n2;
        src[src_offset + 1 * stride + 1] = n2;
        src[src_offset + 1 * stride + 0] = n2;
        int n3 = l1 + 2 * l2 + l3 + 2 >> 2;
        src[src_offset + 2 * stride + 3] = n3;
        src[src_offset + 2 * stride + 2] = n3;
        src[src_offset + 2 * stride + 1] = n3;
        src[src_offset + 2 * stride + 0] = n3;
        int n4 = l2 + 2 * l3 + l3 + 2 >> 2;
        src[src_offset + 3 * stride + 3] = n4;
        src[src_offset + 3 * stride + 2] = n4;
        src[src_offset + 3 * stride + 1] = n4;
        src[src_offset + 3 * stride + 0] = n4;
    }

    public static void pred4x4_down_right_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int lt = src[src_offset - 1 - 1 * stride];
        int t0 = src[src_offset + 0 - 1 * stride];
        int t1 = src[src_offset + 1 - 1 * stride];
        int t2 = src[src_offset + 2 - 1 * stride];
        int t3 = src[src_offset + 3 - 1 * stride];
        int l0 = src[src_offset - 1 + 0 * stride];
        int l1 = src[src_offset - 1 + 1 * stride];
        int l2 = src[src_offset - 1 + 2 * stride];
        int l3 = src[src_offset - 1 + 3 * stride];
        src[src_offset + 0 + 3 * stride] = l3 + 2 * l2 + l1 + 2 >> 2;
        int n = l2 + 2 * l1 + l0 + 2 >> 2;
        src[src_offset + 1 + 3 * stride] = n;
        src[src_offset + 0 + 2 * stride] = n;
        int n2 = l1 + 2 * l0 + lt + 2 >> 2;
        src[src_offset + 2 + 3 * stride] = n2;
        src[src_offset + 1 + 2 * stride] = n2;
        src[src_offset + 0 + 1 * stride] = n2;
        int n3 = l0 + 2 * lt + t0 + 2 >> 2;
        src[src_offset + 3 + 3 * stride] = n3;
        src[src_offset + 2 + 2 * stride] = n3;
        src[src_offset + 1 + 1 * stride] = n3;
        src[src_offset + 0 + 0 * stride] = n3;
        int n4 = lt + 2 * t0 + t1 + 2 >> 2;
        src[src_offset + 3 + 2 * stride] = n4;
        src[src_offset + 2 + 1 * stride] = n4;
        src[src_offset + 1 + 0 * stride] = n4;
        int n5 = t0 + 2 * t1 + t2 + 2 >> 2;
        src[src_offset + 3 + 1 * stride] = n5;
        src[src_offset + 2 + 0 * stride] = n5;
        src[src_offset + 3 + 0 * stride] = t1 + 2 * t2 + t3 + 2 >> 2;
    }

    public static void pred4x4_down_left_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int t0 = src[src_offset + 0 - 1 * stride];
        int t1 = src[src_offset + 1 - 1 * stride];
        int t2 = src[src_offset + 2 - 1 * stride];
        int t3 = src[src_offset + 3 - 1 * stride];
        int t4 = topright[topright_offset + 0];
        int t5 = topright[topright_offset + 1];
        int t6 = topright[topright_offset + 2];
        int t7 = topright[topright_offset + 3];
        src[src_offset + 0 + 0 * stride] = t0 + t2 + 2 * t1 + 2 >> 2;
        int n = t1 + t3 + 2 * t2 + 2 >> 2;
        src[src_offset + 0 + 1 * stride] = n;
        src[src_offset + 1 + 0 * stride] = n;
        int n2 = t2 + t4 + 2 * t3 + 2 >> 2;
        src[src_offset + 0 + 2 * stride] = n2;
        src[src_offset + 1 + 1 * stride] = n2;
        src[src_offset + 2 + 0 * stride] = n2;
        int n3 = t3 + t5 + 2 * t4 + 2 >> 2;
        src[src_offset + 0 + 3 * stride] = n3;
        src[src_offset + 1 + 2 * stride] = n3;
        src[src_offset + 2 + 1 * stride] = n3;
        src[src_offset + 3 + 0 * stride] = n3;
        int n4 = t4 + t6 + 2 * t5 + 2 >> 2;
        src[src_offset + 1 + 3 * stride] = n4;
        src[src_offset + 2 + 2 * stride] = n4;
        src[src_offset + 3 + 1 * stride] = n4;
        int n5 = t5 + t7 + 2 * t6 + 2 >> 2;
        src[src_offset + 2 + 3 * stride] = n5;
        src[src_offset + 3 + 2 * stride] = n5;
        src[src_offset + 3 + 3 * stride] = t6 + 3 * t7 + 2 >> 2;
    }

    public static void pred4x4_down_left_svq3_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int t1 = src[src_offset + 1 - 1 * stride];
        int t2 = src[src_offset + 2 - 1 * stride];
        int t3 = src[src_offset + 3 - 1 * stride];
        int l1 = src[src_offset - 1 + 1 * stride];
        int l2 = src[src_offset - 1 + 2 * stride];
        int l3 = src[src_offset - 1 + 3 * stride];
        src[src_offset + 0 + 0 * stride] = l1 + t1 >> 1;
        int n = l2 + t2 >> 1;
        src[src_offset + 0 + 1 * stride] = n;
        src[src_offset + 1 + 0 * stride] = n;
        int n2 = l3 + t3 >> 1;
        src[src_offset + 3 + 3 * stride] = n2;
        src[src_offset + 2 + 3 * stride] = n2;
        src[src_offset + 3 + 2 * stride] = n2;
        src[src_offset + 1 + 3 * stride] = n2;
        src[src_offset + 2 + 2 * stride] = n2;
        src[src_offset + 3 + 1 * stride] = n2;
        src[src_offset + 0 + 3 * stride] = n2;
        src[src_offset + 1 + 2 * stride] = n2;
        src[src_offset + 2 + 1 * stride] = n2;
        src[src_offset + 3 + 0 * stride] = n2;
        src[src_offset + 0 + 2 * stride] = n2;
        src[src_offset + 1 + 1 * stride] = n2;
        src[src_offset + 2 + 0 * stride] = n2;
    }

    public static void pred4x4_down_left_rv40_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int t0 = src[src_offset + 0 - 1 * stride];
        int t1 = src[src_offset + 1 - 1 * stride];
        int t2 = src[src_offset + 2 - 1 * stride];
        int t3 = src[src_offset + 3 - 1 * stride];
        int t4 = topright[topright_offset + 0];
        int t5 = topright[topright_offset + 1];
        int t6 = topright[topright_offset + 2];
        int t7 = topright[topright_offset + 3];
        int l0 = src[src_offset - 1 + 0 * stride];
        int l1 = src[src_offset - 1 + 1 * stride];
        int l2 = src[src_offset - 1 + 2 * stride];
        int l3 = src[src_offset - 1 + 3 * stride];
        int l4 = src[src_offset - 1 + 4 * stride];
        int l5 = src[src_offset - 1 + 5 * stride];
        int l6 = src[src_offset - 1 + 6 * stride];
        int l7 = src[src_offset - 1 + 7 * stride];
        src[src_offset + 0 + 0 * stride] = t0 + t2 + 2 * t1 + 2 + l0 + l2 + 2 * l1 + 2 >> 3;
        int n = t1 + t3 + 2 * t2 + 2 + l1 + l3 + 2 * l2 + 2 >> 3;
        src[src_offset + 0 + 1 * stride] = n;
        src[src_offset + 1 + 0 * stride] = n;
        int n2 = t2 + t4 + 2 * t3 + 2 + l2 + l4 + 2 * l3 + 2 >> 3;
        src[src_offset + 0 + 2 * stride] = n2;
        src[src_offset + 1 + 1 * stride] = n2;
        src[src_offset + 2 + 0 * stride] = n2;
        int n3 = t3 + t5 + 2 * t4 + 2 + l3 + l5 + 2 * l4 + 2 >> 3;
        src[src_offset + 0 + 3 * stride] = n3;
        src[src_offset + 1 + 2 * stride] = n3;
        src[src_offset + 2 + 1 * stride] = n3;
        src[src_offset + 3 + 0 * stride] = n3;
        int n4 = t4 + t6 + 2 * t5 + 2 + l4 + l6 + 2 * l5 + 2 >> 3;
        src[src_offset + 1 + 3 * stride] = n4;
        src[src_offset + 2 + 2 * stride] = n4;
        src[src_offset + 3 + 1 * stride] = n4;
        int n5 = t5 + t7 + 2 * t6 + 2 + l5 + l7 + 2 * l6 + 2 >> 3;
        src[src_offset + 2 + 3 * stride] = n5;
        src[src_offset + 3 + 2 * stride] = n5;
        src[src_offset + 3 + 3 * stride] = t6 + t7 + 1 + l6 + l7 + 1 >> 2;
    }

    public static void pred4x4_down_left_rv40_nodown_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int t0 = src[src_offset + 0 - 1 * stride];
        int t1 = src[src_offset + 1 - 1 * stride];
        int t2 = src[src_offset + 2 - 1 * stride];
        int t3 = src[src_offset + 3 - 1 * stride];
        int t4 = topright[topright_offset + 0];
        int t5 = topright[topright_offset + 1];
        int t6 = topright[topright_offset + 2];
        int t7 = topright[topright_offset + 3];
        int l0 = src[src_offset - 1 + 0 * stride];
        int l1 = src[src_offset - 1 + 1 * stride];
        int l2 = src[src_offset - 1 + 2 * stride];
        int l3 = src[src_offset - 1 + 3 * stride];
        src[src_offset + 0 + 0 * stride] = t0 + t2 + 2 * t1 + 2 + l0 + l2 + 2 * l1 + 2 >> 3;
        int n = t1 + t3 + 2 * t2 + 2 + l1 + l3 + 2 * l2 + 2 >> 3;
        src[src_offset + 0 + 1 * stride] = n;
        src[src_offset + 1 + 0 * stride] = n;
        int n2 = t2 + t4 + 2 * t3 + 2 + l2 + 3 * l3 + 2 >> 3;
        src[src_offset + 0 + 2 * stride] = n2;
        src[src_offset + 1 + 1 * stride] = n2;
        src[src_offset + 2 + 0 * stride] = n2;
        int n3 = t3 + t5 + 2 * t4 + 2 + l3 * 4 + 2 >> 3;
        src[src_offset + 0 + 3 * stride] = n3;
        src[src_offset + 1 + 2 * stride] = n3;
        src[src_offset + 2 + 1 * stride] = n3;
        src[src_offset + 3 + 0 * stride] = n3;
        int n4 = t4 + t6 + 2 * t5 + 2 + l3 * 4 + 2 >> 3;
        src[src_offset + 1 + 3 * stride] = n4;
        src[src_offset + 2 + 2 * stride] = n4;
        src[src_offset + 3 + 1 * stride] = n4;
        int n5 = t5 + t7 + 2 * t6 + 2 + l3 * 4 + 2 >> 3;
        src[src_offset + 2 + 3 * stride] = n5;
        src[src_offset + 3 + 2 * stride] = n5;
        src[src_offset + 3 + 3 * stride] = t6 + t7 + 1 + 2 * l3 + 1 >> 2;
    }

    public static void pred4x4_vertical_right_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int lt = src[src_offset - 1 - 1 * stride];
        int t0 = src[src_offset + 0 - 1 * stride];
        int t1 = src[src_offset + 1 - 1 * stride];
        int t2 = src[src_offset + 2 - 1 * stride];
        int t3 = src[src_offset + 3 - 1 * stride];
        int l0 = src[src_offset - 1 + 0 * stride];
        int l1 = src[src_offset - 1 + 1 * stride];
        int l2 = src[src_offset - 1 + 2 * stride];
        int n = lt + t0 + 1 >> 1;
        src[src_offset + 1 + 2 * stride] = n;
        src[src_offset + 0 + 0 * stride] = n;
        int n2 = t0 + t1 + 1 >> 1;
        src[src_offset + 2 + 2 * stride] = n2;
        src[src_offset + 1 + 0 * stride] = n2;
        int n3 = t1 + t2 + 1 >> 1;
        src[src_offset + 3 + 2 * stride] = n3;
        src[src_offset + 2 + 0 * stride] = n3;
        src[src_offset + 3 + 0 * stride] = t2 + t3 + 1 >> 1;
        int n4 = l0 + 2 * lt + t0 + 2 >> 2;
        src[src_offset + 1 + 3 * stride] = n4;
        src[src_offset + 0 + 1 * stride] = n4;
        int n5 = lt + 2 * t0 + t1 + 2 >> 2;
        src[src_offset + 2 + 3 * stride] = n5;
        src[src_offset + 1 + 1 * stride] = n5;
        int n6 = t0 + 2 * t1 + t2 + 2 >> 2;
        src[src_offset + 3 + 3 * stride] = n6;
        src[src_offset + 2 + 1 * stride] = n6;
        src[src_offset + 3 + 1 * stride] = t1 + 2 * t2 + t3 + 2 >> 2;
        src[src_offset + 0 + 2 * stride] = lt + 2 * l0 + l1 + 2 >> 2;
        src[src_offset + 0 + 3 * stride] = l0 + 2 * l1 + l2 + 2 >> 2;
    }

    public static void pred4x4_vertical_left_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int t0 = src[src_offset + 0 - 1 * stride];
        int t1 = src[src_offset + 1 - 1 * stride];
        int t2 = src[src_offset + 2 - 1 * stride];
        int t3 = src[src_offset + 3 - 1 * stride];
        int t4 = topright[topright_offset + 0];
        int t5 = topright[topright_offset + 1];
        int t6 = topright[topright_offset + 2];
        src[src_offset + 0 + 0 * stride] = t0 + t1 + 1 >> 1;
        int n = t1 + t2 + 1 >> 1;
        src[src_offset + 0 + 2 * stride] = n;
        src[src_offset + 1 + 0 * stride] = n;
        int n2 = t2 + t3 + 1 >> 1;
        src[src_offset + 1 + 2 * stride] = n2;
        src[src_offset + 2 + 0 * stride] = n2;
        int n3 = t3 + t4 + 1 >> 1;
        src[src_offset + 2 + 2 * stride] = n3;
        src[src_offset + 3 + 0 * stride] = n3;
        src[src_offset + 3 + 2 * stride] = t4 + t5 + 1 >> 1;
        src[src_offset + 0 + 1 * stride] = t0 + 2 * t1 + t2 + 2 >> 2;
        int n4 = t1 + 2 * t2 + t3 + 2 >> 2;
        src[src_offset + 0 + 3 * stride] = n4;
        src[src_offset + 1 + 1 * stride] = n4;
        int n5 = t2 + 2 * t3 + t4 + 2 >> 2;
        src[src_offset + 1 + 3 * stride] = n5;
        src[src_offset + 2 + 1 * stride] = n5;
        int n6 = t3 + 2 * t4 + t5 + 2 >> 2;
        src[src_offset + 2 + 3 * stride] = n6;
        src[src_offset + 3 + 1 * stride] = n6;
        src[src_offset + 3 + 3 * stride] = t4 + 2 * t5 + t6 + 2 >> 2;
    }

    public static void pred4x4_vertical_left_rv40(int[] src, int src_offset, int[] topright, int topright_offset, int stride, int l0, int l1, int l2, int l3, int l4) {
        int t0 = src[src_offset + 0 - 1 * stride];
        int t1 = src[src_offset + 1 - 1 * stride];
        int t2 = src[src_offset + 2 - 1 * stride];
        int t3 = src[src_offset + 3 - 1 * stride];
        int t4 = topright[topright_offset + 0];
        int t5 = topright[topright_offset + 1];
        int t6 = topright[topright_offset + 2];
        src[src_offset + 0 + 0 * stride] = 2 * t0 + 2 * t1 + l1 + 2 * l2 + l3 + 4 >> 3;
        int n = t1 + t2 + 1 >> 1;
        src[src_offset + 0 + 2 * stride] = n;
        src[src_offset + 1 + 0 * stride] = n;
        int n2 = t2 + t3 + 1 >> 1;
        src[src_offset + 1 + 2 * stride] = n2;
        src[src_offset + 2 + 0 * stride] = n2;
        int n3 = t3 + t4 + 1 >> 1;
        src[src_offset + 2 + 2 * stride] = n3;
        src[src_offset + 3 + 0 * stride] = n3;
        src[src_offset + 3 + 2 * stride] = t4 + t5 + 1 >> 1;
        src[src_offset + 0 + 1 * stride] = t0 + 2 * t1 + t2 + l2 + 2 * l3 + l4 + 4 >> 3;
        int n4 = t1 + 2 * t2 + t3 + 2 >> 2;
        src[src_offset + 0 + 3 * stride] = n4;
        src[src_offset + 1 + 1 * stride] = n4;
        int n5 = t2 + 2 * t3 + t4 + 2 >> 2;
        src[src_offset + 1 + 3 * stride] = n5;
        src[src_offset + 2 + 1 * stride] = n5;
        int n6 = t3 + 2 * t4 + t5 + 2 >> 2;
        src[src_offset + 2 + 3 * stride] = n6;
        src[src_offset + 3 + 1 * stride] = n6;
        src[src_offset + 3 + 3 * stride] = t4 + 2 * t5 + t6 + 2 >> 2;
    }

    public static void pred4x4_vertical_left_rv40_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int l0 = src[src_offset - 1 + 0 * stride];
        int l1 = src[src_offset - 1 + 1 * stride];
        int l2 = src[src_offset - 1 + 2 * stride];
        int l3 = src[src_offset - 1 + 3 * stride];
        int l4 = src[src_offset - 1 + 4 * stride];
        H264PredictionContext.pred4x4_vertical_left_rv40(src, src_offset, topright, topright_offset, stride, l0, l1, l2, l3, l4);
    }

    public static void pred4x4_vertical_left_rv40_nodown_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int l0 = src[src_offset - 1 + 0 * stride];
        int l1 = src[src_offset - 1 + 1 * stride];
        int l2 = src[src_offset - 1 + 2 * stride];
        int l3 = src[src_offset - 1 + 3 * stride];
        H264PredictionContext.pred4x4_vertical_left_rv40(src, src_offset, topright, topright_offset, stride, l0, l1, l2, l3, l3);
    }

    public static void pred4x4_vertical_left_vp8_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int t0 = src[src_offset + 0 - 1 * stride];
        int t1 = src[src_offset + 1 - 1 * stride];
        int t2 = src[src_offset + 2 - 1 * stride];
        int t3 = src[src_offset + 3 - 1 * stride];
        int t4 = topright[topright_offset + 0];
        int t5 = topright[topright_offset + 1];
        int t6 = topright[topright_offset + 2];
        int t7 = topright[topright_offset + 3];
        src[src_offset + 0 + 0 * stride] = t0 + t1 + 1 >> 1;
        int n = t1 + t2 + 1 >> 1;
        src[src_offset + 0 + 2 * stride] = n;
        src[src_offset + 1 + 0 * stride] = n;
        int n2 = t2 + t3 + 1 >> 1;
        src[src_offset + 1 + 2 * stride] = n2;
        src[src_offset + 2 + 0 * stride] = n2;
        int n3 = t3 + t4 + 1 >> 1;
        src[src_offset + 2 + 2 * stride] = n3;
        src[src_offset + 3 + 0 * stride] = n3;
        src[src_offset + 0 + 1 * stride] = t0 + 2 * t1 + t2 + 2 >> 2;
        int n4 = t1 + 2 * t2 + t3 + 2 >> 2;
        src[src_offset + 0 + 3 * stride] = n4;
        src[src_offset + 1 + 1 * stride] = n4;
        int n5 = t2 + 2 * t3 + t4 + 2 >> 2;
        src[src_offset + 1 + 3 * stride] = n5;
        src[src_offset + 2 + 1 * stride] = n5;
        int n6 = t3 + 2 * t4 + t5 + 2 >> 2;
        src[src_offset + 2 + 3 * stride] = n6;
        src[src_offset + 3 + 1 * stride] = n6;
        src[src_offset + 3 + 2 * stride] = t4 + 2 * t5 + t6 + 2 >> 2;
        src[src_offset + 3 + 3 * stride] = t5 + 2 * t6 + t7 + 2 >> 2;
    }

    public static void pred4x4_horizontal_up_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int l0 = src[src_offset - 1 + 0 * stride];
        int l1 = src[src_offset - 1 + 1 * stride];
        int l2 = src[src_offset - 1 + 2 * stride];
        int l3 = src[src_offset - 1 + 3 * stride];
        src[src_offset + 0 + 0 * stride] = l0 + l1 + 1 >> 1;
        src[src_offset + 1 + 0 * stride] = l0 + 2 * l1 + l2 + 2 >> 2;
        int n = l1 + l2 + 1 >> 1;
        src[src_offset + 0 + 1 * stride] = n;
        src[src_offset + 2 + 0 * stride] = n;
        int n2 = l1 + 2 * l2 + l3 + 2 >> 2;
        src[src_offset + 1 + 1 * stride] = n2;
        src[src_offset + 3 + 0 * stride] = n2;
        int n3 = l2 + l3 + 1 >> 1;
        src[src_offset + 0 + 2 * stride] = n3;
        src[src_offset + 2 + 1 * stride] = n3;
        int n4 = l2 + 2 * l3 + l3 + 2 >> 2;
        src[src_offset + 1 + 2 * stride] = n4;
        src[src_offset + 3 + 1 * stride] = n4;
        int n5 = l3;
        src[src_offset + 3 + 3 * stride] = n5;
        src[src_offset + 2 + 3 * stride] = n5;
        src[src_offset + 2 + 2 * stride] = n5;
        src[src_offset + 0 + 3 * stride] = n5;
        src[src_offset + 1 + 3 * stride] = n5;
        src[src_offset + 3 + 2 * stride] = n5;
    }

    public static void pred4x4_horizontal_up_rv40_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int l0 = src[src_offset - 1 + 0 * stride];
        int l1 = src[src_offset - 1 + 1 * stride];
        int l2 = src[src_offset - 1 + 2 * stride];
        int l3 = src[src_offset - 1 + 3 * stride];
        int l4 = src[src_offset - 1 + 4 * stride];
        int l5 = src[src_offset - 1 + 5 * stride];
        int l6 = src[src_offset - 1 + 6 * stride];
        int t1 = src[src_offset + 1 - 1 * stride];
        int t2 = src[src_offset + 2 - 1 * stride];
        int t3 = src[src_offset + 3 - 1 * stride];
        int t4 = topright[topright_offset + 0];
        int t5 = topright[topright_offset + 1];
        int t6 = topright[topright_offset + 2];
        int t7 = topright[topright_offset + 3];
        src[src_offset + 0 + 0 * stride] = t1 + 2 * t2 + t3 + 2 * l0 + 2 * l1 + 4 >> 3;
        src[src_offset + 1 + 0 * stride] = t2 + 2 * t3 + t4 + l0 + 2 * l1 + l2 + 4 >> 3;
        int n = t3 + 2 * t4 + t5 + 2 * l1 + 2 * l2 + 4 >> 3;
        src[src_offset + 0 + 1 * stride] = n;
        src[src_offset + 2 + 0 * stride] = n;
        int n2 = t4 + 2 * t5 + t6 + l1 + 2 * l2 + l3 + 4 >> 3;
        src[src_offset + 1 + 1 * stride] = n2;
        src[src_offset + 3 + 0 * stride] = n2;
        int n3 = t5 + 2 * t6 + t7 + 2 * l2 + 2 * l3 + 4 >> 3;
        src[src_offset + 0 + 2 * stride] = n3;
        src[src_offset + 2 + 1 * stride] = n3;
        int n4 = t6 + 3 * t7 + l2 + 3 * l3 + 4 >> 3;
        src[src_offset + 1 + 2 * stride] = n4;
        src[src_offset + 3 + 1 * stride] = n4;
        int n5 = l3 + 2 * l4 + l5 + 2 >> 2;
        src[src_offset + 1 + 3 * stride] = n5;
        src[src_offset + 3 + 2 * stride] = n5;
        int n6 = t6 + t7 + l3 + l4 + 2 >> 2;
        src[src_offset + 2 + 2 * stride] = n6;
        src[src_offset + 0 + 3 * stride] = n6;
        src[src_offset + 2 + 3 * stride] = l4 + l5 + 1 >> 1;
        src[src_offset + 3 + 3 * stride] = l4 + 2 * l5 + l6 + 2 >> 2;
    }

    public static void pred4x4_horizontal_up_rv40_nodown_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int l0 = src[src_offset - 1 + 0 * stride];
        int l1 = src[src_offset - 1 + 1 * stride];
        int l2 = src[src_offset - 1 + 2 * stride];
        int l3 = src[src_offset - 1 + 3 * stride];
        int t1 = src[src_offset + 1 - 1 * stride];
        int t2 = src[src_offset + 2 - 1 * stride];
        int t3 = src[src_offset + 3 - 1 * stride];
        int t4 = topright[topright_offset + 0];
        int t5 = topright[topright_offset + 1];
        int t6 = topright[topright_offset + 2];
        int t7 = topright[topright_offset + 3];
        src[src_offset + 0 + 0 * stride] = t1 + 2 * t2 + t3 + 2 * l0 + 2 * l1 + 4 >> 3;
        src[src_offset + 1 + 0 * stride] = t2 + 2 * t3 + t4 + l0 + 2 * l1 + l2 + 4 >> 3;
        int n = t3 + 2 * t4 + t5 + 2 * l1 + 2 * l2 + 4 >> 3;
        src[src_offset + 0 + 1 * stride] = n;
        src[src_offset + 2 + 0 * stride] = n;
        int n2 = t4 + 2 * t5 + t6 + l1 + 2 * l2 + l3 + 4 >> 3;
        src[src_offset + 1 + 1 * stride] = n2;
        src[src_offset + 3 + 0 * stride] = n2;
        int n3 = t5 + 2 * t6 + t7 + 2 * l2 + 2 * l3 + 4 >> 3;
        src[src_offset + 0 + 2 * stride] = n3;
        src[src_offset + 2 + 1 * stride] = n3;
        int n4 = t6 + 3 * t7 + l2 + 3 * l3 + 4 >> 3;
        src[src_offset + 1 + 2 * stride] = n4;
        src[src_offset + 3 + 1 * stride] = n4;
        int n5 = l3;
        src[src_offset + 1 + 3 * stride] = n5;
        src[src_offset + 3 + 2 * stride] = n5;
        int n6 = t6 + t7 + 2 * l3 + 2 >> 2;
        src[src_offset + 2 + 2 * stride] = n6;
        src[src_offset + 0 + 3 * stride] = n6;
        int n7 = l3;
        src[src_offset + 3 + 3 * stride] = n7;
        src[src_offset + 2 + 3 * stride] = n7;
    }

    public static void pred4x4_horizontal_down_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int lt = src[src_offset - 1 - 1 * stride];
        int t0 = src[src_offset + 0 - 1 * stride];
        int t1 = src[src_offset + 1 - 1 * stride];
        int t2 = src[src_offset + 2 - 1 * stride];
        int l0 = src[src_offset - 1 + 0 * stride];
        int l1 = src[src_offset - 1 + 1 * stride];
        int l2 = src[src_offset - 1 + 2 * stride];
        int l3 = src[src_offset - 1 + 3 * stride];
        int n = lt + l0 + 1 >> 1;
        src[src_offset + 2 + 1 * stride] = n;
        src[src_offset + 0 + 0 * stride] = n;
        int n2 = l0 + 2 * lt + t0 + 2 >> 2;
        src[src_offset + 3 + 1 * stride] = n2;
        src[src_offset + 1 + 0 * stride] = n2;
        src[src_offset + 2 + 0 * stride] = lt + 2 * t0 + t1 + 2 >> 2;
        src[src_offset + 3 + 0 * stride] = t0 + 2 * t1 + t2 + 2 >> 2;
        int n3 = l0 + l1 + 1 >> 1;
        src[src_offset + 2 + 2 * stride] = n3;
        src[src_offset + 0 + 1 * stride] = n3;
        int n4 = lt + 2 * l0 + l1 + 2 >> 2;
        src[src_offset + 3 + 2 * stride] = n4;
        src[src_offset + 1 + 1 * stride] = n4;
        int n5 = l1 + l2 + 1 >> 1;
        src[src_offset + 2 + 3 * stride] = n5;
        src[src_offset + 0 + 2 * stride] = n5;
        int n6 = l0 + 2 * l1 + l2 + 2 >> 2;
        src[src_offset + 3 + 3 * stride] = n6;
        src[src_offset + 1 + 2 * stride] = n6;
        src[src_offset + 0 + 3 * stride] = l2 + l3 + 1 >> 1;
        src[src_offset + 1 + 3 * stride] = l1 + 2 * l2 + l3 + 2 >> 2;
    }

    public static void pred4x4_tm_vp8_c(int[] src, int src_offset, int[] topright, int topright_offset, int stride) {
        int cm_offset = 1024 - src[src_offset - 1 - stride];
        int top_offset = src_offset - stride;
        for (int y = 0; y < 4; ++y) {
            int cm_in_offset = cm_offset + src[src_offset - 1];
            src[src_offset + 0] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 0]];
            src[src_offset + 1] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 1]];
            src[src_offset + 2] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 2]];
            src[src_offset + 3] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 3]];
            src_offset += stride;
        }
    }

    public static void pred16x16_vertical_c(int[] src, int src_offset, int stride) {
        int a0 = src[src_offset - stride + 0];
        int a1 = src[src_offset - stride + 1];
        int a2 = src[src_offset - stride + 2];
        int a3 = src[src_offset - stride + 3];
        int b0 = src[src_offset - stride + 4];
        int b1 = src[src_offset - stride + 5];
        int b2 = src[src_offset - stride + 6];
        int b3 = src[src_offset - stride + 7];
        int c0 = src[src_offset - stride + 8];
        int c1 = src[src_offset - stride + 9];
        int c2 = src[src_offset - stride + 10];
        int c3 = src[src_offset - stride + 11];
        int d0 = src[src_offset - stride + 12];
        int d1 = src[src_offset - stride + 13];
        int d2 = src[src_offset - stride + 14];
        int d3 = src[src_offset - stride + 15];
        for (int i = 0; i < 16; ++i) {
            src[src_offset + i * stride + 0] = a0;
            src[src_offset + i * stride + 1] = a1;
            src[src_offset + i * stride + 2] = a2;
            src[src_offset + i * stride + 3] = a3;
            src[src_offset + i * stride + 4] = b0;
            src[src_offset + i * stride + 5] = b1;
            src[src_offset + i * stride + 6] = b2;
            src[src_offset + i * stride + 7] = b3;
            src[src_offset + i * stride + 8] = c0;
            src[src_offset + i * stride + 9] = c1;
            src[src_offset + i * stride + 10] = c2;
            src[src_offset + i * stride + 11] = c3;
            src[src_offset + i * stride + 12] = d0;
            src[src_offset + i * stride + 13] = d1;
            src[src_offset + i * stride + 14] = d2;
            src[src_offset + i * stride + 15] = d3;
        }
    }

    public static void pred16x16_horizontal_c(int[] src, int src_offset, int stride) {
        for (int i = 0; i < 16; ++i) {
            int n = src[src_offset - 1 + i * stride];
            src[src_offset + i * stride + 15] = n;
            src[src_offset + i * stride + 14] = n;
            src[src_offset + i * stride + 13] = n;
            src[src_offset + i * stride + 12] = n;
            src[src_offset + i * stride + 11] = n;
            src[src_offset + i * stride + 10] = n;
            src[src_offset + i * stride + 9] = n;
            src[src_offset + i * stride + 8] = n;
            src[src_offset + i * stride + 7] = n;
            src[src_offset + i * stride + 6] = n;
            src[src_offset + i * stride + 5] = n;
            src[src_offset + i * stride + 4] = n;
            src[src_offset + i * stride + 3] = n;
            src[src_offset + i * stride + 2] = n;
            src[src_offset + i * stride + 1] = n;
            src[src_offset + i * stride + 0] = n;
        }
    }

    public static void pred16x16_dc_c(int[] src, int src_offset, int stride) {
        int i;
        int dc = 0;
        for (i = 0; i < 16; ++i) {
            dc += src[src_offset - 1 + i * stride];
        }
        for (i = 0; i < 16; ++i) {
            dc += src[src_offset + i - stride];
        }
        dc = dc + 16 >> 5;
        for (i = 0; i < 16; ++i) {
            int n = dc;
            src[src_offset + i * stride + 15] = n;
            src[src_offset + i * stride + 14] = n;
            src[src_offset + i * stride + 13] = n;
            src[src_offset + i * stride + 12] = n;
            src[src_offset + i * stride + 11] = n;
            src[src_offset + i * stride + 10] = n;
            src[src_offset + i * stride + 9] = n;
            src[src_offset + i * stride + 8] = n;
            src[src_offset + i * stride + 7] = n;
            src[src_offset + i * stride + 6] = n;
            src[src_offset + i * stride + 5] = n;
            src[src_offset + i * stride + 4] = n;
            src[src_offset + i * stride + 3] = n;
            src[src_offset + i * stride + 2] = n;
            src[src_offset + i * stride + 1] = n;
            src[src_offset + i * stride + 0] = n;
        }
    }

    public static void pred16x16_left_dc_c(int[] src, int src_offset, int stride) {
        int i;
        int dc = 0;
        for (i = 0; i < 16; ++i) {
            dc += src[src_offset - 1 + i * stride];
        }
        dc = dc + 8 >> 4;
        for (i = 0; i < 16; ++i) {
            int n = dc;
            src[src_offset + i * stride + 15] = n;
            src[src_offset + i * stride + 14] = n;
            src[src_offset + i * stride + 13] = n;
            src[src_offset + i * stride + 12] = n;
            src[src_offset + i * stride + 11] = n;
            src[src_offset + i * stride + 10] = n;
            src[src_offset + i * stride + 9] = n;
            src[src_offset + i * stride + 8] = n;
            src[src_offset + i * stride + 7] = n;
            src[src_offset + i * stride + 6] = n;
            src[src_offset + i * stride + 5] = n;
            src[src_offset + i * stride + 4] = n;
            src[src_offset + i * stride + 3] = n;
            src[src_offset + i * stride + 2] = n;
            src[src_offset + i * stride + 1] = n;
            src[src_offset + i * stride + 0] = n;
        }
    }

    public static void pred16x16_top_dc_c(int[] src, int src_offset, int stride) {
        int i;
        int dc = 0;
        for (i = 0; i < 16; ++i) {
            dc += src[src_offset + i - stride];
        }
        dc = dc + 8 >> 4;
        for (i = 0; i < 16; ++i) {
            int n = dc;
            src[src_offset + i * stride + 15] = n;
            src[src_offset + i * stride + 14] = n;
            src[src_offset + i * stride + 13] = n;
            src[src_offset + i * stride + 12] = n;
            src[src_offset + i * stride + 11] = n;
            src[src_offset + i * stride + 10] = n;
            src[src_offset + i * stride + 9] = n;
            src[src_offset + i * stride + 8] = n;
            src[src_offset + i * stride + 7] = n;
            src[src_offset + i * stride + 6] = n;
            src[src_offset + i * stride + 5] = n;
            src[src_offset + i * stride + 4] = n;
            src[src_offset + i * stride + 3] = n;
            src[src_offset + i * stride + 2] = n;
            src[src_offset + i * stride + 1] = n;
            src[src_offset + i * stride + 0] = n;
        }
    }

    public static void pred16x16_128_dc_c(int[] src, int src_offset, int stride) {
        for (int i = 0; i < 16; ++i) {
            src[src_offset + i * stride + 15] = 128;
            src[src_offset + i * stride + 14] = 128;
            src[src_offset + i * stride + 13] = 128;
            src[src_offset + i * stride + 12] = 128;
            src[src_offset + i * stride + 11] = 128;
            src[src_offset + i * stride + 10] = 128;
            src[src_offset + i * stride + 9] = 128;
            src[src_offset + i * stride + 8] = 128;
            src[src_offset + i * stride + 7] = 128;
            src[src_offset + i * stride + 6] = 128;
            src[src_offset + i * stride + 5] = 128;
            src[src_offset + i * stride + 4] = 128;
            src[src_offset + i * stride + 3] = 128;
            src[src_offset + i * stride + 2] = 128;
            src[src_offset + i * stride + 1] = 128;
            src[src_offset + i * stride + 0] = 128;
        }
    }

    public static void pred16x16_127_dc_c(int[] src, int src_offset, int stride) {
        for (int i = 0; i < 16; ++i) {
            src[src_offset + i * stride + 15] = 127;
            src[src_offset + i * stride + 14] = 127;
            src[src_offset + i * stride + 13] = 127;
            src[src_offset + i * stride + 12] = 127;
            src[src_offset + i * stride + 11] = 127;
            src[src_offset + i * stride + 10] = 127;
            src[src_offset + i * stride + 9] = 127;
            src[src_offset + i * stride + 8] = 127;
            src[src_offset + i * stride + 7] = 127;
            src[src_offset + i * stride + 6] = 127;
            src[src_offset + i * stride + 5] = 127;
            src[src_offset + i * stride + 4] = 127;
            src[src_offset + i * stride + 3] = 127;
            src[src_offset + i * stride + 2] = 127;
            src[src_offset + i * stride + 1] = 127;
            src[src_offset + i * stride + 0] = 127;
        }
    }

    public static void pred16x16_129_dc_c(int[] src, int src_offset, int stride) {
        for (int i = 0; i < 16; ++i) {
            src[src_offset + i * stride + 15] = 129;
            src[src_offset + i * stride + 14] = 129;
            src[src_offset + i * stride + 13] = 129;
            src[src_offset + i * stride + 12] = 129;
            src[src_offset + i * stride + 11] = 129;
            src[src_offset + i * stride + 10] = 129;
            src[src_offset + i * stride + 9] = 129;
            src[src_offset + i * stride + 8] = 129;
            src[src_offset + i * stride + 7] = 129;
            src[src_offset + i * stride + 6] = 129;
            src[src_offset + i * stride + 5] = 129;
            src[src_offset + i * stride + 4] = 129;
            src[src_offset + i * stride + 3] = 129;
            src[src_offset + i * stride + 2] = 129;
            src[src_offset + i * stride + 1] = 129;
            src[src_offset + i * stride + 0] = 129;
        }
    }

    public static void pred16x16_plane_compat_c(int[] src, int src_offset, int stride, int svq3, int rv40) {
        int i;
        int cm_offset = 1024;
        int src0_offset = src_offset + 7 - stride;
        int src1_offset = src_offset + 8 * stride - 1;
        int src2_offset = src1_offset - 2 * stride;
        int H = src[src0_offset + 1] - src[src0_offset - 1];
        int V = src[src1_offset + 0] - src[src2_offset + 0];
        for (int k = 2; k <= 8; ++k) {
            H += k * (src[src0_offset + k] - src[src0_offset - k]);
            V += k * (src[(src1_offset += stride) + 0] - src[(src2_offset -= stride) + 0]);
        }
        if (svq3 != 0) {
            H = 5 * (H / 4) / 16;
            V = 5 * (V / 4) / 16;
            i = H;
            H = V;
            V = i;
        } else if (rv40 != 0) {
            H = H + (H >> 2) >> 4;
            V = V + (V >> 2) >> 4;
        } else {
            H = 5 * H + 32 >> 6;
            V = 5 * V + 32 >> 6;
        }
        int a = 16 * (src[src1_offset + 0] + src[src2_offset + 16] + 1) - 7 * (V + H);
        for (int j = 16; j > 0; --j) {
            int b = a;
            a += V;
            for (i = -16; i < 0; i += 4) {
                src[src_offset + 16 + i] = H264DSPContext.ff_cropTbl[cm_offset + (b >> 5)];
                src[src_offset + 17 + i] = H264DSPContext.ff_cropTbl[cm_offset + (b + H >> 5)];
                src[src_offset + 18 + i] = H264DSPContext.ff_cropTbl[cm_offset + (b + 2 * H >> 5)];
                src[src_offset + 19 + i] = H264DSPContext.ff_cropTbl[cm_offset + (b + 3 * H >> 5)];
                b += 4 * H;
            }
            src_offset += stride;
        }
    }

    public static void pred16x16_plane_c(int[] src, int src_offset, int stride) {
        H264PredictionContext.pred16x16_plane_compat_c(src, src_offset, stride, 0, 0);
    }

    public static void pred16x16_plane_svq3_c(int[] src, int src_offset, int stride) {
        H264PredictionContext.pred16x16_plane_compat_c(src, src_offset, stride, 1, 0);
    }

    public static void pred16x16_plane_rv40_c(int[] src, int src_offset, int stride) {
        H264PredictionContext.pred16x16_plane_compat_c(src, src_offset, stride, 0, 1);
    }

    public static void pred16x16_tm_vp8_c(int[] src, int src_offset, int stride) {
        int cm_offset = 1024 - src[src_offset - 1 - stride];
        int top_offset = src_offset - stride;
        for (int y = 0; y < 16; ++y) {
            int cm_in_offset = cm_offset + src[src_offset - 1];
            src[src_offset + 0] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 0]];
            src[src_offset + 1] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 1]];
            src[src_offset + 2] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 2]];
            src[src_offset + 3] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 3]];
            src[src_offset + 4] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 4]];
            src[src_offset + 5] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 5]];
            src[src_offset + 6] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 6]];
            src[src_offset + 7] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 7]];
            src[src_offset + 8] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 8]];
            src[src_offset + 9] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 9]];
            src[src_offset + 10] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 10]];
            src[src_offset + 11] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 11]];
            src[src_offset + 12] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 12]];
            src[src_offset + 13] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 13]];
            src[src_offset + 14] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 14]];
            src[src_offset + 15] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 15]];
            src_offset += stride;
        }
    }

    public static void pred8x8_vertical_c(int[] src, int src_offset, int stride) {
        int a0 = src[src_offset - stride + 0];
        int a1 = src[src_offset - stride + 1];
        int a2 = src[src_offset - stride + 2];
        int a3 = src[src_offset - stride + 3];
        int b0 = src[src_offset - stride + 4];
        int b1 = src[src_offset - stride + 5];
        int b2 = src[src_offset - stride + 6];
        int b3 = src[src_offset - stride + 7];
        for (int i = 0; i < 8; ++i) {
            src[src_offset + i * stride + 0] = a0;
            src[src_offset + i * stride + 1] = a1;
            src[src_offset + i * stride + 2] = a2;
            src[src_offset + i * stride + 3] = a3;
            src[src_offset + i * stride + 4] = b0;
            src[src_offset + i * stride + 5] = b1;
            src[src_offset + i * stride + 6] = b2;
            src[src_offset + i * stride + 7] = b3;
        }
    }

    public static void pred8x8_horizontal_c(int[] src, int src_offset, int stride) {
        for (int i = 0; i < 8; ++i) {
            int n = src[src_offset - 1 + i * stride];
            src[src_offset + i * stride + 7] = n;
            src[src_offset + i * stride + 6] = n;
            src[src_offset + i * stride + 5] = n;
            src[src_offset + i * stride + 4] = n;
            src[src_offset + i * stride + 3] = n;
            src[src_offset + i * stride + 2] = n;
            src[src_offset + i * stride + 1] = n;
            src[src_offset + i * stride + 0] = n;
        }
    }

    public static void pred8x8_128_dc_c(int[] src, int src_offset, int stride) {
        for (int i = 0; i < 8; ++i) {
            src[src_offset + i * stride + 7] = 128;
            src[src_offset + i * stride + 6] = 128;
            src[src_offset + i * stride + 5] = 128;
            src[src_offset + i * stride + 4] = 128;
            src[src_offset + i * stride + 3] = 128;
            src[src_offset + i * stride + 2] = 128;
            src[src_offset + i * stride + 1] = 128;
            src[src_offset + i * stride + 0] = 128;
        }
    }

    public static void pred8x8_127_dc_c(int[] src, int src_offset, int stride) {
        for (int i = 0; i < 8; ++i) {
            src[src_offset + i * stride + 7] = 127;
            src[src_offset + i * stride + 6] = 127;
            src[src_offset + i * stride + 5] = 127;
            src[src_offset + i * stride + 4] = 127;
            src[src_offset + i * stride + 3] = 127;
            src[src_offset + i * stride + 2] = 127;
            src[src_offset + i * stride + 1] = 127;
            src[src_offset + i * stride + 0] = 127;
        }
    }

    public static void pred8x8_129_dc_c(int[] src, int src_offset, int stride) {
        for (int i = 0; i < 8; ++i) {
            src[src_offset + i * stride + 7] = 129;
            src[src_offset + i * stride + 6] = 129;
            src[src_offset + i * stride + 5] = 129;
            src[src_offset + i * stride + 4] = 129;
            src[src_offset + i * stride + 3] = 129;
            src[src_offset + i * stride + 2] = 129;
            src[src_offset + i * stride + 1] = 129;
            src[src_offset + i * stride + 0] = 129;
        }
    }

    public static void pred8x8_left_dc_c(int[] src, int src_offset, int stride) {
        int i;
        int dc2 = 0;
        int dc0 = 0;
        for (i = 0; i < 4; ++i) {
            dc0 += src[src_offset - 1 + i * stride];
            dc2 += src[src_offset - 1 + (i + 4) * stride];
        }
        dc0 = dc0 + 2 >> 2;
        dc2 = dc2 + 2 >> 2;
        for (i = 0; i < 4; ++i) {
            int n = dc0;
            src[src_offset + i * stride + 7] = n;
            src[src_offset + i * stride + 6] = n;
            src[src_offset + i * stride + 5] = n;
            src[src_offset + i * stride + 4] = n;
            src[src_offset + i * stride + 3] = n;
            src[src_offset + i * stride + 2] = n;
            src[src_offset + i * stride + 1] = n;
            src[src_offset + i * stride + 0] = n;
        }
        for (i = 4; i < 8; ++i) {
            int n = dc2;
            src[src_offset + i * stride + 7] = n;
            src[src_offset + i * stride + 6] = n;
            src[src_offset + i * stride + 5] = n;
            src[src_offset + i * stride + 4] = n;
            src[src_offset + i * stride + 3] = n;
            src[src_offset + i * stride + 2] = n;
            src[src_offset + i * stride + 1] = n;
            src[src_offset + i * stride + 0] = n;
        }
    }

    public static void pred8x8_left_dc_rv40_c(int[] src, int src_offset, int stride) {
        int i;
        int dc0 = 0;
        for (i = 0; i < 8; ++i) {
            dc0 += src[src_offset - 1 + i * stride];
        }
        dc0 = dc0 + 4 >> 3;
        for (i = 0; i < 8; ++i) {
            int n = dc0;
            src[src_offset + i * stride + 7] = n;
            src[src_offset + i * stride + 6] = n;
            src[src_offset + i * stride + 5] = n;
            src[src_offset + i * stride + 4] = n;
            src[src_offset + i * stride + 3] = n;
            src[src_offset + i * stride + 2] = n;
            src[src_offset + i * stride + 1] = n;
            src[src_offset + i * stride + 0] = n;
        }
    }

    public static void pred8x8_top_dc_c(int[] src, int src_offset, int stride) {
        int i;
        int dc1 = 0;
        int dc0 = 0;
        for (i = 0; i < 4; ++i) {
            dc0 += src[src_offset + i - stride];
            dc1 += src[src_offset + 4 + i - stride];
        }
        dc0 = dc0 + 2 >> 2;
        dc1 = dc1 + 2 >> 2;
        for (i = 0; i < 4; ++i) {
            int n = dc0;
            src[src_offset + i * stride + 3] = n;
            src[src_offset + i * stride + 2] = n;
            src[src_offset + i * stride + 1] = n;
            src[src_offset + i * stride + 0] = n;
            int n2 = dc1;
            src[src_offset + i * stride + 7] = n2;
            src[src_offset + i * stride + 6] = n2;
            src[src_offset + i * stride + 5] = n2;
            src[src_offset + i * stride + 4] = n2;
        }
        for (i = 4; i < 8; ++i) {
            int n = dc0;
            src[src_offset + i * stride + 3] = n;
            src[src_offset + i * stride + 2] = n;
            src[src_offset + i * stride + 1] = n;
            src[src_offset + i * stride + 0] = n;
            int n3 = dc1;
            src[src_offset + i * stride + 7] = n3;
            src[src_offset + i * stride + 6] = n3;
            src[src_offset + i * stride + 5] = n3;
            src[src_offset + i * stride + 4] = n3;
        }
    }

    public static void pred8x8_top_dc_rv40_c(int[] src, int src_offset, int stride) {
        int i;
        int dc0 = 0;
        for (i = 0; i < 8; ++i) {
            dc0 += src[src_offset + i - stride];
        }
        dc0 = dc0 + 4 >> 3;
        for (i = 0; i < 8; ++i) {
            int n = dc0;
            src[src_offset + i * stride + 7] = n;
            src[src_offset + i * stride + 6] = n;
            src[src_offset + i * stride + 5] = n;
            src[src_offset + i * stride + 4] = n;
            src[src_offset + i * stride + 3] = n;
            src[src_offset + i * stride + 2] = n;
            src[src_offset + i * stride + 1] = n;
            src[src_offset + i * stride + 0] = n;
        }
    }

    public static void pred8x8_dc_c(int[] src, int src_offset, int stride) {
        int i;
        int dc2 = 0;
        int dc1 = 0;
        int dc0 = 0;
        for (i = 0; i < 4; ++i) {
            dc0 += src[src_offset - 1 + i * stride] + src[src_offset + i - stride];
            dc1 += src[src_offset + 4 + i - stride];
            dc2 += src[src_offset - 1 + (i + 4) * stride];
        }
        int dc3 = dc1 + dc2 + 4 >> 3;
        dc0 = dc0 + 4 >> 3;
        dc1 = dc1 + 2 >> 2;
        dc2 = dc2 + 2 >> 2;
        for (i = 0; i < 4; ++i) {
            int n = dc0;
            src[src_offset + i * stride + 3] = n;
            src[src_offset + i * stride + 2] = n;
            src[src_offset + i * stride + 1] = n;
            src[src_offset + i * stride + 0] = n;
            int n2 = dc1;
            src[src_offset + i * stride + 7] = n2;
            src[src_offset + i * stride + 6] = n2;
            src[src_offset + i * stride + 5] = n2;
            src[src_offset + i * stride + 4] = n2;
        }
        for (i = 4; i < 8; ++i) {
            int n = dc2;
            src[src_offset + i * stride + 3] = n;
            src[src_offset + i * stride + 2] = n;
            src[src_offset + i * stride + 1] = n;
            src[src_offset + i * stride + 0] = n;
            int n3 = dc3;
            src[src_offset + i * stride + 7] = n3;
            src[src_offset + i * stride + 6] = n3;
            src[src_offset + i * stride + 5] = n3;
            src[src_offset + i * stride + 4] = n3;
        }
    }

    public static void pred8x8_mad_cow_dc_l0t(int[] src, int src_offset, int stride) {
        H264PredictionContext.pred8x8_top_dc_c(src, src_offset, stride);
        H264PredictionContext.pred4x4_dc_c(src, src_offset, null, 0, stride);
    }

    public static void pred8x8_mad_cow_dc_0lt(int[] src, int src_offset, int stride) {
        H264PredictionContext.pred8x8_dc_c(src, src_offset, stride);
        H264PredictionContext.pred4x4_top_dc_c(src, src_offset, null, 0, stride);
    }

    public static void pred8x8_mad_cow_dc_l00(int[] src, int src_offset, int stride) {
        H264PredictionContext.pred8x8_left_dc_c(src, src_offset, stride);
        H264PredictionContext.pred4x4_128_dc_c(src, src_offset + 4 * stride, null, 0, stride);
        H264PredictionContext.pred4x4_128_dc_c(src, src_offset + 4 * stride + 4, null, 0, stride);
    }

    public static void pred8x8_mad_cow_dc_0l0(int[] src, int src_offset, int stride) {
        H264PredictionContext.pred8x8_left_dc_c(src, src_offset, stride);
        H264PredictionContext.pred4x4_128_dc_c(src, src_offset, null, 0, stride);
        H264PredictionContext.pred4x4_128_dc_c(src, src_offset + 4, null, 0, stride);
    }

    public static void pred8x8_dc_rv40_c(int[] src, int src_offset, int stride) {
        int i;
        int dc0 = 0;
        for (i = 0; i < 4; ++i) {
            dc0 += src[src_offset - 1 + i * stride] + src[src_offset + i - stride];
            dc0 += src[src_offset + 4 + i - stride];
            dc0 += src[src_offset - 1 + (i + 4) * stride];
        }
        dc0 = dc0 + 8 >> 4;
        for (i = 0; i < 4; ++i) {
            int n = dc0;
            src[src_offset + i * stride + 3] = n;
            src[src_offset + i * stride + 2] = n;
            src[src_offset + i * stride + 1] = n;
            src[src_offset + i * stride + 0] = n;
            int n2 = dc0;
            src[src_offset + i * stride + 7] = n2;
            src[src_offset + i * stride + 6] = n2;
            src[src_offset + i * stride + 5] = n2;
            src[src_offset + i * stride + 4] = n2;
        }
        for (i = 4; i < 8; ++i) {
            int n = dc0;
            src[src_offset + i * stride + 3] = n;
            src[src_offset + i * stride + 2] = n;
            src[src_offset + i * stride + 1] = n;
            src[src_offset + i * stride + 0] = n;
            int n3 = dc0;
            src[src_offset + i * stride + 7] = n3;
            src[src_offset + i * stride + 6] = n3;
            src[src_offset + i * stride + 5] = n3;
            src[src_offset + i * stride + 4] = n3;
        }
    }

    public static void pred8x8_plane_c(int[] src, int src_offset, int stride) {
        int cm_offset = 1024;
        int src0_offset = src_offset + 3 - stride;
        int src1_offset = src_offset + 4 * stride - 1;
        int src2_offset = src1_offset - 2 * stride;
        int H = src[src0_offset + 1] - src[src0_offset - 1];
        int V = src[src1_offset + 0] - src[src2_offset + 0];
        for (int k = 2; k <= 4; ++k) {
            H += k * (src[src0_offset + k] - src[src0_offset - k]);
            V += k * (src[(src1_offset += stride) + 0] - src[(src2_offset -= stride) + 0]);
        }
        H = 17 * H + 16 >> 5;
        V = 17 * V + 16 >> 5;
        int a = 16 * (src[src1_offset + 0] + src[src2_offset + 8] + 1) - 3 * (V + H);
        for (int j = 8; j > 0; --j) {
            int b = a;
            a += V;
            src[src_offset + 0] = H264DSPContext.ff_cropTbl[cm_offset + (b >> 5)];
            src[src_offset + 1] = H264DSPContext.ff_cropTbl[cm_offset + (b + H >> 5)];
            src[src_offset + 2] = H264DSPContext.ff_cropTbl[cm_offset + (b + 2 * H >> 5)];
            src[src_offset + 3] = H264DSPContext.ff_cropTbl[cm_offset + (b + 3 * H >> 5)];
            src[src_offset + 4] = H264DSPContext.ff_cropTbl[cm_offset + (b + 4 * H >> 5)];
            src[src_offset + 5] = H264DSPContext.ff_cropTbl[cm_offset + (b + 5 * H >> 5)];
            src[src_offset + 6] = H264DSPContext.ff_cropTbl[cm_offset + (b + 6 * H >> 5)];
            src[src_offset + 7] = H264DSPContext.ff_cropTbl[cm_offset + (b + 7 * H >> 5)];
            src_offset += stride;
        }
    }

    public static void pred8x8_tm_vp8_c(int[] src, int src_offset, int stride) {
        int cm_offset = 1024 - src[src_offset - 1 - stride];
        int top_offset = src_offset - stride;
        for (int y = 0; y < 8; ++y) {
            int cm_in_offset = cm_offset + src[src_offset - 1];
            src[src_offset + 0] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 0]];
            src[src_offset + 1] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 1]];
            src[src_offset + 2] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 2]];
            src[src_offset + 3] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 3]];
            src[src_offset + 4] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 4]];
            src[src_offset + 5] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 5]];
            src[src_offset + 6] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 6]];
            src[src_offset + 7] = H264DSPContext.ff_cropTbl[cm_in_offset + src[top_offset + 7]];
            src_offset += stride;
        }
    }

    public static void pred8x8l_128_dc_c(int[] src, int src_offset, int has_topleft, int has_topright, int stride) {
        for (int y = 0; y < 8; ++y) {
            src[src_offset + 7] = 128;
            src[src_offset + 6] = 128;
            src[src_offset + 5] = 128;
            src[src_offset + 4] = 128;
            src[src_offset + 3] = 128;
            src[src_offset + 2] = 128;
            src[src_offset + 1] = 128;
            src[src_offset + 0] = 128;
            src_offset += stride;
        }
    }

    public static void pred8x8l_left_dc_c(int[] src, int src_offset, int has_topleft, int has_topright, int stride) {
        int l0 = (has_topleft != 0 ? src[src_offset - 1 - 1 * stride] : src[src_offset - 1 + 0 * stride]) + 2 * src[src_offset - 1 + 0 * stride] + src[src_offset - 1 + 1 * stride] + 2 >> 2;
        int l1 = src[src_offset - 1 + 0 * stride] + 2 * src[src_offset - 1 + 1 * stride] + src[src_offset - 1 + 2 * stride] + 2 >> 2;
        int l2 = src[src_offset - 1 + 1 * stride] + 2 * src[src_offset - 1 + 2 * stride] + src[src_offset - 1 + 3 * stride] + 2 >> 2;
        int l3 = src[src_offset - 1 + 2 * stride] + 2 * src[src_offset - 1 + 3 * stride] + src[src_offset - 1 + 4 * stride] + 2 >> 2;
        int l4 = src[src_offset - 1 + 3 * stride] + 2 * src[src_offset - 1 + 4 * stride] + src[src_offset - 1 + 5 * stride] + 2 >> 2;
        int l5 = src[src_offset - 1 + 4 * stride] + 2 * src[src_offset - 1 + 5 * stride] + src[src_offset - 1 + 6 * stride] + 2 >> 2;
        int l6 = src[src_offset - 1 + 5 * stride] + 2 * src[src_offset - 1 + 6 * stride] + src[src_offset - 1 + 7 * stride] + 2 >> 2;
        int l7 = src[src_offset - 1 + 6 * stride] + 3 * src[src_offset - 1 + 7 * stride] + 2 >> 2;
        int dc = l0 + l1 + l2 + l3 + l4 + l5 + l6 + l7 + 4 >> 3;
        for (int y = 0; y < 8; ++y) {
            int n = dc;
            src[src_offset + 7] = n;
            src[src_offset + 6] = n;
            src[src_offset + 5] = n;
            src[src_offset + 4] = n;
            src[src_offset + 3] = n;
            src[src_offset + 2] = n;
            src[src_offset + 1] = n;
            src[src_offset + 0] = n;
            src_offset += stride;
        }
    }

    public static void pred8x8l_top_dc_c(int[] src, int src_offset, int has_topleft, int has_topright, int stride) {
        int t0 = (has_topleft != 0 ? src[src_offset - 1 - 1 * stride] : src[src_offset + 0 - 1 * stride]) + 2 * src[src_offset + 0 - 1 * stride] + src[src_offset + 1 - 1 * stride] + 2 >> 2;
        int t1 = src[src_offset + 0 - 1 * stride] + 2 * src[src_offset + 1 - 1 * stride] + src[src_offset + 2 - 1 * stride] + 2 >> 2;
        int t2 = src[src_offset + 1 - 1 * stride] + 2 * src[src_offset + 2 - 1 * stride] + src[src_offset + 3 - 1 * stride] + 2 >> 2;
        int t3 = src[src_offset + 2 - 1 * stride] + 2 * src[src_offset + 3 - 1 * stride] + src[src_offset + 4 - 1 * stride] + 2 >> 2;
        int t4 = src[src_offset + 3 - 1 * stride] + 2 * src[src_offset + 4 - 1 * stride] + src[src_offset + 5 - 1 * stride] + 2 >> 2;
        int t5 = src[src_offset + 4 - 1 * stride] + 2 * src[src_offset + 5 - 1 * stride] + src[src_offset + 6 - 1 * stride] + 2 >> 2;
        int t6 = src[src_offset + 5 - 1 * stride] + 2 * src[src_offset + 6 - 1 * stride] + src[src_offset + 7 - 1 * stride] + 2 >> 2;
        int t7 = (has_topright != 0 ? src[src_offset + 8 - 1 * stride] : src[src_offset + 7 - 1 * stride]) + 2 * src[src_offset + 7 - 1 * stride] + src[src_offset + 6 - 1 * stride] + 2 >> 2;
        int dc = t0 + t1 + t2 + t3 + t4 + t5 + t6 + t7 + 4 >> 3;
        for (int y = 0; y < 8; ++y) {
            int n = dc;
            src[src_offset + 7] = n;
            src[src_offset + 6] = n;
            src[src_offset + 5] = n;
            src[src_offset + 4] = n;
            src[src_offset + 3] = n;
            src[src_offset + 2] = n;
            src[src_offset + 1] = n;
            src[src_offset + 0] = n;
            src_offset += stride;
        }
    }

    public static void pred8x8l_dc_c(int[] src, int src_offset, int has_topleft, int has_topright, int stride) {
        int l0 = (has_topleft != 0 ? src[src_offset - 1 - 1 * stride] : src[src_offset - 1 + 0 * stride]) + 2 * src[src_offset - 1 + 0 * stride] + src[src_offset - 1 + 1 * stride] + 2 >> 2;
        int l1 = src[src_offset - 1 + 0 * stride] + 2 * src[src_offset - 1 + 1 * stride] + src[src_offset - 1 + 2 * stride] + 2 >> 2;
        int l2 = src[src_offset - 1 + 1 * stride] + 2 * src[src_offset - 1 + 2 * stride] + src[src_offset - 1 + 3 * stride] + 2 >> 2;
        int l3 = src[src_offset - 1 + 2 * stride] + 2 * src[src_offset - 1 + 3 * stride] + src[src_offset - 1 + 4 * stride] + 2 >> 2;
        int l4 = src[src_offset - 1 + 3 * stride] + 2 * src[src_offset - 1 + 4 * stride] + src[src_offset - 1 + 5 * stride] + 2 >> 2;
        int l5 = src[src_offset - 1 + 4 * stride] + 2 * src[src_offset - 1 + 5 * stride] + src[src_offset - 1 + 6 * stride] + 2 >> 2;
        int l6 = src[src_offset - 1 + 5 * stride] + 2 * src[src_offset - 1 + 6 * stride] + src[src_offset - 1 + 7 * stride] + 2 >> 2;
        int l7 = src[src_offset - 1 + 6 * stride] + 3 * src[src_offset - 1 + 7 * stride] + 2 >> 2;
        int t0 = (has_topleft != 0 ? src[src_offset - 1 - 1 * stride] : src[src_offset + 0 - 1 * stride]) + 2 * src[src_offset + 0 - 1 * stride] + src[src_offset + 1 - 1 * stride] + 2 >> 2;
        int t1 = src[src_offset + 0 - 1 * stride] + 2 * src[src_offset + 1 - 1 * stride] + src[src_offset + 2 - 1 * stride] + 2 >> 2;
        int t2 = src[src_offset + 1 - 1 * stride] + 2 * src[src_offset + 2 - 1 * stride] + src[src_offset + 3 - 1 * stride] + 2 >> 2;
        int t3 = src[src_offset + 2 - 1 * stride] + 2 * src[src_offset + 3 - 1 * stride] + src[src_offset + 4 - 1 * stride] + 2 >> 2;
        int t4 = src[src_offset + 3 - 1 * stride] + 2 * src[src_offset + 4 - 1 * stride] + src[src_offset + 5 - 1 * stride] + 2 >> 2;
        int t5 = src[src_offset + 4 - 1 * stride] + 2 * src[src_offset + 5 - 1 * stride] + src[src_offset + 6 - 1 * stride] + 2 >> 2;
        int t6 = src[src_offset + 5 - 1 * stride] + 2 * src[src_offset + 6 - 1 * stride] + src[src_offset + 7 - 1 * stride] + 2 >> 2;
        int t7 = (has_topright != 0 ? src[src_offset + 8 - 1 * stride] : src[src_offset + 7 - 1 * stride]) + 2 * src[src_offset + 7 - 1 * stride] + src[src_offset + 6 - 1 * stride] + 2 >> 2;
        int dc = l0 + l1 + l2 + l3 + l4 + l5 + l6 + l7 + t0 + t1 + t2 + t3 + t4 + t5 + t6 + t7 + 8 >> 4;
        for (int y = 0; y < 8; ++y) {
            int n = dc;
            src[src_offset + 7] = n;
            src[src_offset + 6] = n;
            src[src_offset + 5] = n;
            src[src_offset + 4] = n;
            src[src_offset + 3] = n;
            src[src_offset + 2] = n;
            src[src_offset + 1] = n;
            src[src_offset + 0] = n;
            src_offset += stride;
        }
    }

    public static void pred8x8l_horizontal_c(int[] src, int src_offset, int has_topleft, int has_topright, int stride) {
        int l0 = (has_topleft != 0 ? src[src_offset - 1 - 1 * stride] : src[src_offset - 1 + 0 * stride]) + 2 * src[src_offset - 1 + 0 * stride] + src[src_offset - 1 + 1 * stride] + 2 >> 2;
        int l1 = src[src_offset - 1 + 0 * stride] + 2 * src[src_offset - 1 + 1 * stride] + src[src_offset - 1 + 2 * stride] + 2 >> 2;
        int l2 = src[src_offset - 1 + 1 * stride] + 2 * src[src_offset - 1 + 2 * stride] + src[src_offset - 1 + 3 * stride] + 2 >> 2;
        int l3 = src[src_offset - 1 + 2 * stride] + 2 * src[src_offset - 1 + 3 * stride] + src[src_offset - 1 + 4 * stride] + 2 >> 2;
        int l4 = src[src_offset - 1 + 3 * stride] + 2 * src[src_offset - 1 + 4 * stride] + src[src_offset - 1 + 5 * stride] + 2 >> 2;
        int l5 = src[src_offset - 1 + 4 * stride] + 2 * src[src_offset - 1 + 5 * stride] + src[src_offset - 1 + 6 * stride] + 2 >> 2;
        int l6 = src[src_offset - 1 + 5 * stride] + 2 * src[src_offset - 1 + 6 * stride] + src[src_offset - 1 + 7 * stride] + 2 >> 2;
        int l7 = src[src_offset - 1 + 6 * stride] + 3 * src[src_offset - 1 + 7 * stride] + 2 >> 2;
        int n = l0;
        src[src_offset + 0 * stride + 7] = n;
        src[src_offset + 0 * stride + 6] = n;
        src[src_offset + 0 * stride + 5] = n;
        src[src_offset + 0 * stride + 4] = n;
        src[src_offset + 0 * stride + 3] = n;
        src[src_offset + 0 * stride + 2] = n;
        src[src_offset + 0 * stride + 1] = n;
        src[src_offset + 0 * stride + 0] = n;
        int n2 = l1;
        src[src_offset + 1 * stride + 7] = n2;
        src[src_offset + 1 * stride + 6] = n2;
        src[src_offset + 1 * stride + 5] = n2;
        src[src_offset + 1 * stride + 4] = n2;
        src[src_offset + 1 * stride + 3] = n2;
        src[src_offset + 1 * stride + 2] = n2;
        src[src_offset + 1 * stride + 1] = n2;
        src[src_offset + 1 * stride + 0] = n2;
        int n3 = l2;
        src[src_offset + 2 * stride + 7] = n3;
        src[src_offset + 2 * stride + 6] = n3;
        src[src_offset + 2 * stride + 5] = n3;
        src[src_offset + 2 * stride + 4] = n3;
        src[src_offset + 2 * stride + 3] = n3;
        src[src_offset + 2 * stride + 2] = n3;
        src[src_offset + 2 * stride + 1] = n3;
        src[src_offset + 2 * stride + 0] = n3;
        int n4 = l3;
        src[src_offset + 3 * stride + 7] = n4;
        src[src_offset + 3 * stride + 6] = n4;
        src[src_offset + 3 * stride + 5] = n4;
        src[src_offset + 3 * stride + 4] = n4;
        src[src_offset + 3 * stride + 3] = n4;
        src[src_offset + 3 * stride + 2] = n4;
        src[src_offset + 3 * stride + 1] = n4;
        src[src_offset + 3 * stride + 0] = n4;
        int n5 = l4;
        src[src_offset + 4 * stride + 7] = n5;
        src[src_offset + 4 * stride + 6] = n5;
        src[src_offset + 4 * stride + 5] = n5;
        src[src_offset + 4 * stride + 4] = n5;
        src[src_offset + 4 * stride + 3] = n5;
        src[src_offset + 4 * stride + 2] = n5;
        src[src_offset + 4 * stride + 1] = n5;
        src[src_offset + 4 * stride + 0] = n5;
        int n6 = l5;
        src[src_offset + 5 * stride + 7] = n6;
        src[src_offset + 5 * stride + 6] = n6;
        src[src_offset + 5 * stride + 5] = n6;
        src[src_offset + 5 * stride + 4] = n6;
        src[src_offset + 5 * stride + 3] = n6;
        src[src_offset + 5 * stride + 2] = n6;
        src[src_offset + 5 * stride + 1] = n6;
        src[src_offset + 5 * stride + 0] = n6;
        int n7 = l6;
        src[src_offset + 6 * stride + 7] = n7;
        src[src_offset + 6 * stride + 6] = n7;
        src[src_offset + 6 * stride + 5] = n7;
        src[src_offset + 6 * stride + 4] = n7;
        src[src_offset + 6 * stride + 3] = n7;
        src[src_offset + 6 * stride + 2] = n7;
        src[src_offset + 6 * stride + 1] = n7;
        src[src_offset + 6 * stride + 0] = n7;
        int n8 = l7;
        src[src_offset + 7 * stride + 7] = n8;
        src[src_offset + 7 * stride + 6] = n8;
        src[src_offset + 7 * stride + 5] = n8;
        src[src_offset + 7 * stride + 4] = n8;
        src[src_offset + 7 * stride + 3] = n8;
        src[src_offset + 7 * stride + 2] = n8;
        src[src_offset + 7 * stride + 1] = n8;
        src[src_offset + 7 * stride + 0] = n8;
    }

    public static void pred8x8l_vertical_c(int[] src, int src_offset, int has_topleft, int has_topright, int stride) {
        int t0 = (has_topleft != 0 ? src[src_offset - 1 - 1 * stride] : src[src_offset + 0 - 1 * stride]) + 2 * src[src_offset + 0 - 1 * stride] + src[src_offset + 1 - 1 * stride] + 2 >> 2;
        int t1 = src[src_offset + 0 - 1 * stride] + 2 * src[src_offset + 1 - 1 * stride] + src[src_offset + 2 - 1 * stride] + 2 >> 2;
        int t2 = src[src_offset + 1 - 1 * stride] + 2 * src[src_offset + 2 - 1 * stride] + src[src_offset + 3 - 1 * stride] + 2 >> 2;
        int t3 = src[src_offset + 2 - 1 * stride] + 2 * src[src_offset + 3 - 1 * stride] + src[src_offset + 4 - 1 * stride] + 2 >> 2;
        int t4 = src[src_offset + 3 - 1 * stride] + 2 * src[src_offset + 4 - 1 * stride] + src[src_offset + 5 - 1 * stride] + 2 >> 2;
        int t5 = src[src_offset + 4 - 1 * stride] + 2 * src[src_offset + 5 - 1 * stride] + src[src_offset + 6 - 1 * stride] + 2 >> 2;
        int t6 = src[src_offset + 5 - 1 * stride] + 2 * src[src_offset + 6 - 1 * stride] + src[src_offset + 7 - 1 * stride] + 2 >> 2;
        int t7 = (has_topright != 0 ? src[src_offset + 8 - 1 * stride] : src[src_offset + 7 - 1 * stride]) + 2 * src[src_offset + 7 - 1 * stride] + src[src_offset + 6 - 1 * stride] + 2 >> 2;
        src[src_offset + 0] = t0;
        src[src_offset + 1] = t1;
        src[src_offset + 2] = t2;
        src[src_offset + 3] = t3;
        src[src_offset + 4] = t4;
        src[src_offset + 5] = t5;
        src[src_offset + 6] = t6;
        src[src_offset + 7] = t7;
        for (int y = 1; y < 8; ++y) {
            src[src_offset + y * stride + 0] = src[src_offset + 0];
            src[src_offset + y * stride + 1] = src[src_offset + 1];
            src[src_offset + y * stride + 2] = src[src_offset + 2];
            src[src_offset + y * stride + 3] = src[src_offset + 3];
            src[src_offset + y * stride + 4] = src[src_offset + 4];
            src[src_offset + y * stride + 5] = src[src_offset + 5];
            src[src_offset + y * stride + 6] = src[src_offset + 6];
            src[src_offset + y * stride + 7] = src[src_offset + 7];
        }
    }

    public static void pred8x8l_down_left_c(int[] src, int src_offset, int has_topleft, int has_topright, int stride) {
        int t15;
        int t14;
        int t13;
        int t12;
        int t11;
        int t10;
        int t9;
        int t8;
        int t0 = (has_topleft != 0 ? src[src_offset - 1 - 1 * stride] : src[src_offset + 0 - 1 * stride]) + 2 * src[src_offset + 0 - 1 * stride] + src[src_offset + 1 - 1 * stride] + 2 >> 2;
        int t1 = src[src_offset + 0 - 1 * stride] + 2 * src[src_offset + 1 - 1 * stride] + src[src_offset + 2 - 1 * stride] + 2 >> 2;
        int t2 = src[src_offset + 1 - 1 * stride] + 2 * src[src_offset + 2 - 1 * stride] + src[src_offset + 3 - 1 * stride] + 2 >> 2;
        int t3 = src[src_offset + 2 - 1 * stride] + 2 * src[src_offset + 3 - 1 * stride] + src[src_offset + 4 - 1 * stride] + 2 >> 2;
        int t4 = src[src_offset + 3 - 1 * stride] + 2 * src[src_offset + 4 - 1 * stride] + src[src_offset + 5 - 1 * stride] + 2 >> 2;
        int t5 = src[src_offset + 4 - 1 * stride] + 2 * src[src_offset + 5 - 1 * stride] + src[src_offset + 6 - 1 * stride] + 2 >> 2;
        int t6 = src[src_offset + 5 - 1 * stride] + 2 * src[src_offset + 6 - 1 * stride] + src[src_offset + 7 - 1 * stride] + 2 >> 2;
        int t7 = (has_topright != 0 ? src[src_offset + 8 - 1 * stride] : src[src_offset + 7 - 1 * stride]) + 2 * src[src_offset + 7 - 1 * stride] + src[src_offset + 6 - 1 * stride] + 2 >> 2;
        if (has_topright != 0) {
            t8 = src[src_offset + 7 - 1 * stride] + 2 * src[src_offset + 8 - 1 * stride] + src[src_offset + 9 - 1 * stride] + 2 >> 2;
            t9 = src[src_offset + 8 - 1 * stride] + 2 * src[src_offset + 9 - 1 * stride] + src[src_offset + 10 - 1 * stride] + 2 >> 2;
            t10 = src[src_offset + 9 - 1 * stride] + 2 * src[src_offset + 10 - 1 * stride] + src[src_offset + 11 - 1 * stride] + 2 >> 2;
            t11 = src[src_offset + 10 - 1 * stride] + 2 * src[src_offset + 11 - 1 * stride] + src[src_offset + 12 - 1 * stride] + 2 >> 2;
            t12 = src[src_offset + 11 - 1 * stride] + 2 * src[src_offset + 12 - 1 * stride] + src[src_offset + 13 - 1 * stride] + 2 >> 2;
            t13 = src[src_offset + 12 - 1 * stride] + 2 * src[src_offset + 13 - 1 * stride] + src[src_offset + 14 - 1 * stride] + 2 >> 2;
            t14 = src[src_offset + 13 - 1 * stride] + 2 * src[src_offset + 14 - 1 * stride] + src[src_offset + 15 - 1 * stride] + 2 >> 2;
            t15 = src[src_offset + 14 - 1 * stride] + 3 * src[src_offset + 15 - 1 * stride] + 2 >> 2;
        } else {
            t14 = t15 = src[src_offset + 7 - 1 * stride];
            t13 = t15;
            t12 = t15;
            t11 = t15;
            t10 = t15;
            t9 = t15;
            t8 = t15;
        }
        src[src_offset + 0 + 0 * stride] = t0 + 2 * t1 + t2 + 2 >> 2;
        int n = t1 + 2 * t2 + t3 + 2 >> 2;
        src[src_offset + 1 + 0 * stride] = n;
        src[src_offset + 0 + 1 * stride] = n;
        int n2 = t2 + 2 * t3 + t4 + 2 >> 2;
        src[src_offset + 2 + 0 * stride] = n2;
        src[src_offset + 1 + 1 * stride] = n2;
        src[src_offset + 0 + 2 * stride] = n2;
        int n3 = t3 + 2 * t4 + t5 + 2 >> 2;
        src[src_offset + 3 + 0 * stride] = n3;
        src[src_offset + 2 + 1 * stride] = n3;
        src[src_offset + 1 + 2 * stride] = n3;
        src[src_offset + 0 + 3 * stride] = n3;
        int n4 = t4 + 2 * t5 + t6 + 2 >> 2;
        src[src_offset + 4 + 0 * stride] = n4;
        src[src_offset + 3 + 1 * stride] = n4;
        src[src_offset + 2 + 2 * stride] = n4;
        src[src_offset + 1 + 3 * stride] = n4;
        src[src_offset + 0 + 4 * stride] = n4;
        int n5 = t5 + 2 * t6 + t7 + 2 >> 2;
        src[src_offset + 5 + 0 * stride] = n5;
        src[src_offset + 4 + 1 * stride] = n5;
        src[src_offset + 3 + 2 * stride] = n5;
        src[src_offset + 2 + 3 * stride] = n5;
        src[src_offset + 1 + 4 * stride] = n5;
        src[src_offset + 0 + 5 * stride] = n5;
        int n6 = t6 + 2 * t7 + t8 + 2 >> 2;
        src[src_offset + 6 + 0 * stride] = n6;
        src[src_offset + 5 + 1 * stride] = n6;
        src[src_offset + 4 + 2 * stride] = n6;
        src[src_offset + 3 + 3 * stride] = n6;
        src[src_offset + 2 + 4 * stride] = n6;
        src[src_offset + 1 + 5 * stride] = n6;
        src[src_offset + 0 + 6 * stride] = n6;
        int n7 = t7 + 2 * t8 + t9 + 2 >> 2;
        src[src_offset + 7 + 0 * stride] = n7;
        src[src_offset + 6 + 1 * stride] = n7;
        src[src_offset + 5 + 2 * stride] = n7;
        src[src_offset + 4 + 3 * stride] = n7;
        src[src_offset + 3 + 4 * stride] = n7;
        src[src_offset + 2 + 5 * stride] = n7;
        src[src_offset + 1 + 6 * stride] = n7;
        src[src_offset + 0 + 7 * stride] = n7;
        int n8 = t8 + 2 * t9 + t10 + 2 >> 2;
        src[src_offset + 7 + 1 * stride] = n8;
        src[src_offset + 6 + 2 * stride] = n8;
        src[src_offset + 5 + 3 * stride] = n8;
        src[src_offset + 4 + 4 * stride] = n8;
        src[src_offset + 3 + 5 * stride] = n8;
        src[src_offset + 2 + 6 * stride] = n8;
        src[src_offset + 1 + 7 * stride] = n8;
        int n9 = t9 + 2 * t10 + t11 + 2 >> 2;
        src[src_offset + 7 + 2 * stride] = n9;
        src[src_offset + 6 + 3 * stride] = n9;
        src[src_offset + 5 + 4 * stride] = n9;
        src[src_offset + 4 + 5 * stride] = n9;
        src[src_offset + 3 + 6 * stride] = n9;
        src[src_offset + 2 + 7 * stride] = n9;
        int n10 = t10 + 2 * t11 + t12 + 2 >> 2;
        src[src_offset + 7 + 3 * stride] = n10;
        src[src_offset + 6 + 4 * stride] = n10;
        src[src_offset + 5 + 5 * stride] = n10;
        src[src_offset + 4 + 6 * stride] = n10;
        src[src_offset + 3 + 7 * stride] = n10;
        int n11 = t11 + 2 * t12 + t13 + 2 >> 2;
        src[src_offset + 7 + 4 * stride] = n11;
        src[src_offset + 6 + 5 * stride] = n11;
        src[src_offset + 5 + 6 * stride] = n11;
        src[src_offset + 4 + 7 * stride] = n11;
        int n12 = t12 + 2 * t13 + t14 + 2 >> 2;
        src[src_offset + 7 + 5 * stride] = n12;
        src[src_offset + 6 + 6 * stride] = n12;
        src[src_offset + 5 + 7 * stride] = n12;
        int n13 = t13 + 2 * t14 + t15 + 2 >> 2;
        src[src_offset + 7 + 6 * stride] = n13;
        src[src_offset + 6 + 7 * stride] = n13;
        src[src_offset + 7 + 7 * stride] = t14 + 3 * t15 + 2 >> 2;
    }

    public static void pred8x8l_down_right_c(int[] src, int src_offset, int has_topleft, int has_topright, int stride) {
        int t0 = (has_topleft != 0 ? src[src_offset - 1 - 1 * stride] : src[src_offset + 0 - 1 * stride]) + 2 * src[src_offset + 0 - 1 * stride] + src[src_offset + 1 - 1 * stride] + 2 >> 2;
        int t1 = src[src_offset + 0 - 1 * stride] + 2 * src[src_offset + 1 - 1 * stride] + src[src_offset + 2 - 1 * stride] + 2 >> 2;
        int t2 = src[src_offset + 1 - 1 * stride] + 2 * src[src_offset + 2 - 1 * stride] + src[src_offset + 3 - 1 * stride] + 2 >> 2;
        int t3 = src[src_offset + 2 - 1 * stride] + 2 * src[src_offset + 3 - 1 * stride] + src[src_offset + 4 - 1 * stride] + 2 >> 2;
        int t4 = src[src_offset + 3 - 1 * stride] + 2 * src[src_offset + 4 - 1 * stride] + src[src_offset + 5 - 1 * stride] + 2 >> 2;
        int t5 = src[src_offset + 4 - 1 * stride] + 2 * src[src_offset + 5 - 1 * stride] + src[src_offset + 6 - 1 * stride] + 2 >> 2;
        int t6 = src[src_offset + 5 - 1 * stride] + 2 * src[src_offset + 6 - 1 * stride] + src[src_offset + 7 - 1 * stride] + 2 >> 2;
        int t7 = (has_topright != 0 ? src[src_offset + 8 - 1 * stride] : src[src_offset + 7 - 1 * stride]) + 2 * src[src_offset + 7 - 1 * stride] + src[src_offset + 6 - 1 * stride] + 2 >> 2;
        int l0 = (has_topleft != 0 ? src[src_offset - 1 - 1 * stride] : src[src_offset - 1 + 0 * stride]) + 2 * src[src_offset - 1 + 0 * stride] + src[src_offset - 1 + 1 * stride] + 2 >> 2;
        int l1 = src[src_offset - 1 + 0 * stride] + 2 * src[src_offset - 1 + 1 * stride] + src[src_offset - 1 + 2 * stride] + 2 >> 2;
        int l2 = src[src_offset - 1 + 1 * stride] + 2 * src[src_offset - 1 + 2 * stride] + src[src_offset - 1 + 3 * stride] + 2 >> 2;
        int l3 = src[src_offset - 1 + 2 * stride] + 2 * src[src_offset - 1 + 3 * stride] + src[src_offset - 1 + 4 * stride] + 2 >> 2;
        int l4 = src[src_offset - 1 + 3 * stride] + 2 * src[src_offset - 1 + 4 * stride] + src[src_offset - 1 + 5 * stride] + 2 >> 2;
        int l5 = src[src_offset - 1 + 4 * stride] + 2 * src[src_offset - 1 + 5 * stride] + src[src_offset - 1 + 6 * stride] + 2 >> 2;
        int l6 = src[src_offset - 1 + 5 * stride] + 2 * src[src_offset - 1 + 6 * stride] + src[src_offset - 1 + 7 * stride] + 2 >> 2;
        int l7 = src[src_offset - 1 + 6 * stride] + 3 * src[src_offset - 1 + 7 * stride] + 2 >> 2;
        int lt = src[src_offset - 1 + 0 * stride] + 2 * src[src_offset - 1 - 1 * stride] + src[src_offset + 0 - 1 * stride] + 2 >> 2;
        src[src_offset + 0 + 7 * stride] = l7 + 2 * l6 + l5 + 2 >> 2;
        int n = l6 + 2 * l5 + l4 + 2 >> 2;
        src[src_offset + 1 + 7 * stride] = n;
        src[src_offset + 0 + 6 * stride] = n;
        int n2 = l5 + 2 * l4 + l3 + 2 >> 2;
        src[src_offset + 2 + 7 * stride] = n2;
        src[src_offset + 1 + 6 * stride] = n2;
        src[src_offset + 0 + 5 * stride] = n2;
        int n3 = l4 + 2 * l3 + l2 + 2 >> 2;
        src[src_offset + 3 + 7 * stride] = n3;
        src[src_offset + 2 + 6 * stride] = n3;
        src[src_offset + 1 + 5 * stride] = n3;
        src[src_offset + 0 + 4 * stride] = n3;
        int n4 = l3 + 2 * l2 + l1 + 2 >> 2;
        src[src_offset + 4 + 7 * stride] = n4;
        src[src_offset + 3 + 6 * stride] = n4;
        src[src_offset + 2 + 5 * stride] = n4;
        src[src_offset + 1 + 4 * stride] = n4;
        src[src_offset + 0 + 3 * stride] = n4;
        int n5 = l2 + 2 * l1 + l0 + 2 >> 2;
        src[src_offset + 5 + 7 * stride] = n5;
        src[src_offset + 4 + 6 * stride] = n5;
        src[src_offset + 3 + 5 * stride] = n5;
        src[src_offset + 2 + 4 * stride] = n5;
        src[src_offset + 1 + 3 * stride] = n5;
        src[src_offset + 0 + 2 * stride] = n5;
        int n6 = l1 + 2 * l0 + lt + 2 >> 2;
        src[src_offset + 6 + 7 * stride] = n6;
        src[src_offset + 5 + 6 * stride] = n6;
        src[src_offset + 4 + 5 * stride] = n6;
        src[src_offset + 3 + 4 * stride] = n6;
        src[src_offset + 2 + 3 * stride] = n6;
        src[src_offset + 1 + 2 * stride] = n6;
        src[src_offset + 0 + 1 * stride] = n6;
        int n7 = l0 + 2 * lt + t0 + 2 >> 2;
        src[src_offset + 7 + 7 * stride] = n7;
        src[src_offset + 6 + 6 * stride] = n7;
        src[src_offset + 5 + 5 * stride] = n7;
        src[src_offset + 4 + 4 * stride] = n7;
        src[src_offset + 3 + 3 * stride] = n7;
        src[src_offset + 2 + 2 * stride] = n7;
        src[src_offset + 1 + 1 * stride] = n7;
        src[src_offset + 0 + 0 * stride] = n7;
        int n8 = lt + 2 * t0 + t1 + 2 >> 2;
        src[src_offset + 7 + 6 * stride] = n8;
        src[src_offset + 6 + 5 * stride] = n8;
        src[src_offset + 5 + 4 * stride] = n8;
        src[src_offset + 4 + 3 * stride] = n8;
        src[src_offset + 3 + 2 * stride] = n8;
        src[src_offset + 2 + 1 * stride] = n8;
        src[src_offset + 1 + 0 * stride] = n8;
        int n9 = t0 + 2 * t1 + t2 + 2 >> 2;
        src[src_offset + 7 + 5 * stride] = n9;
        src[src_offset + 6 + 4 * stride] = n9;
        src[src_offset + 5 + 3 * stride] = n9;
        src[src_offset + 4 + 2 * stride] = n9;
        src[src_offset + 3 + 1 * stride] = n9;
        src[src_offset + 2 + 0 * stride] = n9;
        int n10 = t1 + 2 * t2 + t3 + 2 >> 2;
        src[src_offset + 7 + 4 * stride] = n10;
        src[src_offset + 6 + 3 * stride] = n10;
        src[src_offset + 5 + 2 * stride] = n10;
        src[src_offset + 4 + 1 * stride] = n10;
        src[src_offset + 3 + 0 * stride] = n10;
        int n11 = t2 + 2 * t3 + t4 + 2 >> 2;
        src[src_offset + 7 + 3 * stride] = n11;
        src[src_offset + 6 + 2 * stride] = n11;
        src[src_offset + 5 + 1 * stride] = n11;
        src[src_offset + 4 + 0 * stride] = n11;
        int n12 = t3 + 2 * t4 + t5 + 2 >> 2;
        src[src_offset + 7 + 2 * stride] = n12;
        src[src_offset + 6 + 1 * stride] = n12;
        src[src_offset + 5 + 0 * stride] = n12;
        int n13 = t4 + 2 * t5 + t6 + 2 >> 2;
        src[src_offset + 7 + 1 * stride] = n13;
        src[src_offset + 6 + 0 * stride] = n13;
        src[src_offset + 7 + 0 * stride] = t5 + 2 * t6 + t7 + 2 >> 2;
    }

    public static void pred8x8l_vertical_right_c(int[] src, int src_offset, int has_topleft, int has_topright, int stride) {
        int t0 = (has_topleft != 0 ? src[src_offset - 1 - 1 * stride] : src[src_offset + 0 - 1 * stride]) + 2 * src[src_offset + 0 - 1 * stride] + src[src_offset + 1 - 1 * stride] + 2 >> 2;
        int t1 = src[src_offset + 0 - 1 * stride] + 2 * src[src_offset + 1 - 1 * stride] + src[src_offset + 2 - 1 * stride] + 2 >> 2;
        int t2 = src[src_offset + 1 - 1 * stride] + 2 * src[src_offset + 2 - 1 * stride] + src[src_offset + 3 - 1 * stride] + 2 >> 2;
        int t3 = src[src_offset + 2 - 1 * stride] + 2 * src[src_offset + 3 - 1 * stride] + src[src_offset + 4 - 1 * stride] + 2 >> 2;
        int t4 = src[src_offset + 3 - 1 * stride] + 2 * src[src_offset + 4 - 1 * stride] + src[src_offset + 5 - 1 * stride] + 2 >> 2;
        int t5 = src[src_offset + 4 - 1 * stride] + 2 * src[src_offset + 5 - 1 * stride] + src[src_offset + 6 - 1 * stride] + 2 >> 2;
        int t6 = src[src_offset + 5 - 1 * stride] + 2 * src[src_offset + 6 - 1 * stride] + src[src_offset + 7 - 1 * stride] + 2 >> 2;
        int t7 = (has_topright != 0 ? src[src_offset + 8 - 1 * stride] : src[src_offset + 7 - 1 * stride]) + 2 * src[src_offset + 7 - 1 * stride] + src[src_offset + 6 - 1 * stride] + 2 >> 2;
        int l0 = (has_topleft != 0 ? src[src_offset - 1 - 1 * stride] : src[src_offset - 1 + 0 * stride]) + 2 * src[src_offset - 1 + 0 * stride] + src[src_offset - 1 + 1 * stride] + 2 >> 2;
        int l1 = src[src_offset - 1 + 0 * stride] + 2 * src[src_offset - 1 + 1 * stride] + src[src_offset - 1 + 2 * stride] + 2 >> 2;
        int l2 = src[src_offset - 1 + 1 * stride] + 2 * src[src_offset - 1 + 2 * stride] + src[src_offset - 1 + 3 * stride] + 2 >> 2;
        int l3 = src[src_offset - 1 + 2 * stride] + 2 * src[src_offset - 1 + 3 * stride] + src[src_offset - 1 + 4 * stride] + 2 >> 2;
        int l4 = src[src_offset - 1 + 3 * stride] + 2 * src[src_offset - 1 + 4 * stride] + src[src_offset - 1 + 5 * stride] + 2 >> 2;
        int l5 = src[src_offset - 1 + 4 * stride] + 2 * src[src_offset - 1 + 5 * stride] + src[src_offset - 1 + 6 * stride] + 2 >> 2;
        int l6 = src[src_offset - 1 + 5 * stride] + 2 * src[src_offset - 1 + 6 * stride] + src[src_offset - 1 + 7 * stride] + 2 >> 2;
        int lt = src[src_offset - 1 + 0 * stride] + 2 * src[src_offset - 1 - 1 * stride] + src[src_offset + 0 - 1 * stride] + 2 >> 2;
        src[src_offset + 0 + 6 * stride] = l5 + 2 * l4 + l3 + 2 >> 2;
        src[src_offset + 0 + 7 * stride] = l6 + 2 * l5 + l4 + 2 >> 2;
        int n = l3 + 2 * l2 + l1 + 2 >> 2;
        src[src_offset + 1 + 6 * stride] = n;
        src[src_offset + 0 + 4 * stride] = n;
        int n2 = l4 + 2 * l3 + l2 + 2 >> 2;
        src[src_offset + 1 + 7 * stride] = n2;
        src[src_offset + 0 + 5 * stride] = n2;
        int n3 = l1 + 2 * l0 + lt + 2 >> 2;
        src[src_offset + 2 + 6 * stride] = n3;
        src[src_offset + 1 + 4 * stride] = n3;
        src[src_offset + 0 + 2 * stride] = n3;
        int n4 = l2 + 2 * l1 + l0 + 2 >> 2;
        src[src_offset + 2 + 7 * stride] = n4;
        src[src_offset + 1 + 5 * stride] = n4;
        src[src_offset + 0 + 3 * stride] = n4;
        int n5 = l0 + 2 * lt + t0 + 2 >> 2;
        src[src_offset + 3 + 7 * stride] = n5;
        src[src_offset + 2 + 5 * stride] = n5;
        src[src_offset + 1 + 3 * stride] = n5;
        src[src_offset + 0 + 1 * stride] = n5;
        int n6 = lt + t0 + 1 >> 1;
        src[src_offset + 3 + 6 * stride] = n6;
        src[src_offset + 2 + 4 * stride] = n6;
        src[src_offset + 1 + 2 * stride] = n6;
        src[src_offset + 0 + 0 * stride] = n6;
        int n7 = lt + 2 * t0 + t1 + 2 >> 2;
        src[src_offset + 4 + 7 * stride] = n7;
        src[src_offset + 3 + 5 * stride] = n7;
        src[src_offset + 2 + 3 * stride] = n7;
        src[src_offset + 1 + 1 * stride] = n7;
        int n8 = t0 + t1 + 1 >> 1;
        src[src_offset + 4 + 6 * stride] = n8;
        src[src_offset + 3 + 4 * stride] = n8;
        src[src_offset + 2 + 2 * stride] = n8;
        src[src_offset + 1 + 0 * stride] = n8;
        int n9 = t0 + 2 * t1 + t2 + 2 >> 2;
        src[src_offset + 5 + 7 * stride] = n9;
        src[src_offset + 4 + 5 * stride] = n9;
        src[src_offset + 3 + 3 * stride] = n9;
        src[src_offset + 2 + 1 * stride] = n9;
        int n10 = t1 + t2 + 1 >> 1;
        src[src_offset + 5 + 6 * stride] = n10;
        src[src_offset + 4 + 4 * stride] = n10;
        src[src_offset + 3 + 2 * stride] = n10;
        src[src_offset + 2 + 0 * stride] = n10;
        int n11 = t1 + 2 * t2 + t3 + 2 >> 2;
        src[src_offset + 6 + 7 * stride] = n11;
        src[src_offset + 5 + 5 * stride] = n11;
        src[src_offset + 4 + 3 * stride] = n11;
        src[src_offset + 3 + 1 * stride] = n11;
        int n12 = t2 + t3 + 1 >> 1;
        src[src_offset + 6 + 6 * stride] = n12;
        src[src_offset + 5 + 4 * stride] = n12;
        src[src_offset + 4 + 2 * stride] = n12;
        src[src_offset + 3 + 0 * stride] = n12;
        int n13 = t2 + 2 * t3 + t4 + 2 >> 2;
        src[src_offset + 7 + 7 * stride] = n13;
        src[src_offset + 6 + 5 * stride] = n13;
        src[src_offset + 5 + 3 * stride] = n13;
        src[src_offset + 4 + 1 * stride] = n13;
        int n14 = t3 + t4 + 1 >> 1;
        src[src_offset + 7 + 6 * stride] = n14;
        src[src_offset + 6 + 4 * stride] = n14;
        src[src_offset + 5 + 2 * stride] = n14;
        src[src_offset + 4 + 0 * stride] = n14;
        int n15 = t3 + 2 * t4 + t5 + 2 >> 2;
        src[src_offset + 7 + 5 * stride] = n15;
        src[src_offset + 6 + 3 * stride] = n15;
        src[src_offset + 5 + 1 * stride] = n15;
        int n16 = t4 + t5 + 1 >> 1;
        src[src_offset + 7 + 4 * stride] = n16;
        src[src_offset + 6 + 2 * stride] = n16;
        src[src_offset + 5 + 0 * stride] = n16;
        int n17 = t4 + 2 * t5 + t6 + 2 >> 2;
        src[src_offset + 7 + 3 * stride] = n17;
        src[src_offset + 6 + 1 * stride] = n17;
        int n18 = t5 + t6 + 1 >> 1;
        src[src_offset + 7 + 2 * stride] = n18;
        src[src_offset + 6 + 0 * stride] = n18;
        src[src_offset + 7 + 1 * stride] = t5 + 2 * t6 + t7 + 2 >> 2;
        src[src_offset + 7 + 0 * stride] = t6 + t7 + 1 >> 1;
    }

    public static void pred8x8l_horizontal_down_c(int[] src, int src_offset, int has_topleft, int has_topright, int stride) {
        int t0 = (has_topleft != 0 ? src[src_offset - 1 - 1 * stride] : src[src_offset + 0 - 1 * stride]) + 2 * src[src_offset + 0 - 1 * stride] + src[src_offset + 1 - 1 * stride] + 2 >> 2;
        int t1 = src[src_offset + 0 - 1 * stride] + 2 * src[src_offset + 1 - 1 * stride] + src[src_offset + 2 - 1 * stride] + 2 >> 2;
        int t2 = src[src_offset + 1 - 1 * stride] + 2 * src[src_offset + 2 - 1 * stride] + src[src_offset + 3 - 1 * stride] + 2 >> 2;
        int t3 = src[src_offset + 2 - 1 * stride] + 2 * src[src_offset + 3 - 1 * stride] + src[src_offset + 4 - 1 * stride] + 2 >> 2;
        int t4 = src[src_offset + 3 - 1 * stride] + 2 * src[src_offset + 4 - 1 * stride] + src[src_offset + 5 - 1 * stride] + 2 >> 2;
        int t5 = src[src_offset + 4 - 1 * stride] + 2 * src[src_offset + 5 - 1 * stride] + src[src_offset + 6 - 1 * stride] + 2 >> 2;
        int t6 = src[src_offset + 5 - 1 * stride] + 2 * src[src_offset + 6 - 1 * stride] + src[src_offset + 7 - 1 * stride] + 2 >> 2;
        int l0 = (has_topleft != 0 ? src[src_offset - 1 - 1 * stride] : src[src_offset - 1 + 0 * stride]) + 2 * src[src_offset - 1 + 0 * stride] + src[src_offset - 1 + 1 * stride] + 2 >> 2;
        int l1 = src[src_offset - 1 + 0 * stride] + 2 * src[src_offset - 1 + 1 * stride] + src[src_offset - 1 + 2 * stride] + 2 >> 2;
        int l2 = src[src_offset - 1 + 1 * stride] + 2 * src[src_offset - 1 + 2 * stride] + src[src_offset - 1 + 3 * stride] + 2 >> 2;
        int l3 = src[src_offset - 1 + 2 * stride] + 2 * src[src_offset - 1 + 3 * stride] + src[src_offset - 1 + 4 * stride] + 2 >> 2;
        int l4 = src[src_offset - 1 + 3 * stride] + 2 * src[src_offset - 1 + 4 * stride] + src[src_offset - 1 + 5 * stride] + 2 >> 2;
        int l5 = src[src_offset - 1 + 4 * stride] + 2 * src[src_offset - 1 + 5 * stride] + src[src_offset - 1 + 6 * stride] + 2 >> 2;
        int l6 = src[src_offset - 1 + 5 * stride] + 2 * src[src_offset - 1 + 6 * stride] + src[src_offset - 1 + 7 * stride] + 2 >> 2;
        int l7 = src[src_offset - 1 + 6 * stride] + 3 * src[src_offset - 1 + 7 * stride] + 2 >> 2;
        int lt = src[src_offset - 1 + 0 * stride] + 2 * src[src_offset - 1 - 1 * stride] + src[src_offset + 0 - 1 * stride] + 2 >> 2;
        src[src_offset + 0 + 7 * stride] = l6 + l7 + 1 >> 1;
        src[src_offset + 1 + 7 * stride] = l5 + 2 * l6 + l7 + 2 >> 2;
        int n = l5 + l6 + 1 >> 1;
        src[src_offset + 2 + 7 * stride] = n;
        src[src_offset + 0 + 6 * stride] = n;
        int n2 = l4 + 2 * l5 + l6 + 2 >> 2;
        src[src_offset + 3 + 7 * stride] = n2;
        src[src_offset + 1 + 6 * stride] = n2;
        int n3 = l4 + l5 + 1 >> 1;
        src[src_offset + 4 + 7 * stride] = n3;
        src[src_offset + 2 + 6 * stride] = n3;
        src[src_offset + 0 + 5 * stride] = n3;
        int n4 = l3 + 2 * l4 + l5 + 2 >> 2;
        src[src_offset + 5 + 7 * stride] = n4;
        src[src_offset + 3 + 6 * stride] = n4;
        src[src_offset + 1 + 5 * stride] = n4;
        int n5 = l3 + l4 + 1 >> 1;
        src[src_offset + 6 + 7 * stride] = n5;
        src[src_offset + 4 + 6 * stride] = n5;
        src[src_offset + 2 + 5 * stride] = n5;
        src[src_offset + 0 + 4 * stride] = n5;
        int n6 = l2 + 2 * l3 + l4 + 2 >> 2;
        src[src_offset + 7 + 7 * stride] = n6;
        src[src_offset + 5 + 6 * stride] = n6;
        src[src_offset + 3 + 5 * stride] = n6;
        src[src_offset + 1 + 4 * stride] = n6;
        int n7 = l2 + l3 + 1 >> 1;
        src[src_offset + 6 + 6 * stride] = n7;
        src[src_offset + 4 + 5 * stride] = n7;
        src[src_offset + 2 + 4 * stride] = n7;
        src[src_offset + 0 + 3 * stride] = n7;
        int n8 = l1 + 2 * l2 + l3 + 2 >> 2;
        src[src_offset + 7 + 6 * stride] = n8;
        src[src_offset + 5 + 5 * stride] = n8;
        src[src_offset + 3 + 4 * stride] = n8;
        src[src_offset + 1 + 3 * stride] = n8;
        int n9 = l1 + l2 + 1 >> 1;
        src[src_offset + 6 + 5 * stride] = n9;
        src[src_offset + 4 + 4 * stride] = n9;
        src[src_offset + 2 + 3 * stride] = n9;
        src[src_offset + 0 + 2 * stride] = n9;
        int n10 = l0 + 2 * l1 + l2 + 2 >> 2;
        src[src_offset + 7 + 5 * stride] = n10;
        src[src_offset + 5 + 4 * stride] = n10;
        src[src_offset + 3 + 3 * stride] = n10;
        src[src_offset + 1 + 2 * stride] = n10;
        int n11 = l0 + l1 + 1 >> 1;
        src[src_offset + 6 + 4 * stride] = n11;
        src[src_offset + 4 + 3 * stride] = n11;
        src[src_offset + 2 + 2 * stride] = n11;
        src[src_offset + 0 + 1 * stride] = n11;
        int n12 = lt + 2 * l0 + l1 + 2 >> 2;
        src[src_offset + 7 + 4 * stride] = n12;
        src[src_offset + 5 + 3 * stride] = n12;
        src[src_offset + 3 + 2 * stride] = n12;
        src[src_offset + 1 + 1 * stride] = n12;
        int n13 = lt + l0 + 1 >> 1;
        src[src_offset + 6 + 3 * stride] = n13;
        src[src_offset + 4 + 2 * stride] = n13;
        src[src_offset + 2 + 1 * stride] = n13;
        src[src_offset + 0 + 0 * stride] = n13;
        int n14 = l0 + 2 * lt + t0 + 2 >> 2;
        src[src_offset + 7 + 3 * stride] = n14;
        src[src_offset + 5 + 2 * stride] = n14;
        src[src_offset + 3 + 1 * stride] = n14;
        src[src_offset + 1 + 0 * stride] = n14;
        int n15 = t1 + 2 * t0 + lt + 2 >> 2;
        src[src_offset + 6 + 2 * stride] = n15;
        src[src_offset + 4 + 1 * stride] = n15;
        src[src_offset + 2 + 0 * stride] = n15;
        int n16 = t2 + 2 * t1 + t0 + 2 >> 2;
        src[src_offset + 7 + 2 * stride] = n16;
        src[src_offset + 5 + 1 * stride] = n16;
        src[src_offset + 3 + 0 * stride] = n16;
        int n17 = t3 + 2 * t2 + t1 + 2 >> 2;
        src[src_offset + 6 + 1 * stride] = n17;
        src[src_offset + 4 + 0 * stride] = n17;
        int n18 = t4 + 2 * t3 + t2 + 2 >> 2;
        src[src_offset + 7 + 1 * stride] = n18;
        src[src_offset + 5 + 0 * stride] = n18;
        src[src_offset + 6 + 0 * stride] = t5 + 2 * t4 + t3 + 2 >> 2;
        src[src_offset + 7 + 0 * stride] = t6 + 2 * t5 + t4 + 2 >> 2;
    }

    public static void pred8x8l_vertical_left_c(int[] src, int src_offset, int has_topleft, int has_topright, int stride) {
        int t12;
        int t11;
        int t10;
        int t9;
        int t8;
        int t0 = (has_topleft != 0 ? src[src_offset - 1 - 1 * stride] : src[src_offset + 0 - 1 * stride]) + 2 * src[src_offset + 0 - 1 * stride] + src[src_offset + 1 - 1 * stride] + 2 >> 2;
        int t1 = src[src_offset + 0 - 1 * stride] + 2 * src[src_offset + 1 - 1 * stride] + src[src_offset + 2 - 1 * stride] + 2 >> 2;
        int t2 = src[src_offset + 1 - 1 * stride] + 2 * src[src_offset + 2 - 1 * stride] + src[src_offset + 3 - 1 * stride] + 2 >> 2;
        int t3 = src[src_offset + 2 - 1 * stride] + 2 * src[src_offset + 3 - 1 * stride] + src[src_offset + 4 - 1 * stride] + 2 >> 2;
        int t4 = src[src_offset + 3 - 1 * stride] + 2 * src[src_offset + 4 - 1 * stride] + src[src_offset + 5 - 1 * stride] + 2 >> 2;
        int t5 = src[src_offset + 4 - 1 * stride] + 2 * src[src_offset + 5 - 1 * stride] + src[src_offset + 6 - 1 * stride] + 2 >> 2;
        int t6 = src[src_offset + 5 - 1 * stride] + 2 * src[src_offset + 6 - 1 * stride] + src[src_offset + 7 - 1 * stride] + 2 >> 2;
        int t7 = (has_topright != 0 ? src[src_offset + 8 - 1 * stride] : src[src_offset + 7 - 1 * stride]) + 2 * src[src_offset + 7 - 1 * stride] + src[src_offset + 6 - 1 * stride] + 2 >> 2;
        if (has_topright != 0) {
            t8 = src[src_offset + 7 - 1 * stride] + 2 * src[src_offset + 8 - 1 * stride] + src[src_offset + 9 - 1 * stride] + 2 >> 2;
            t9 = src[src_offset + 8 - 1 * stride] + 2 * src[src_offset + 9 - 1 * stride] + src[src_offset + 10 - 1 * stride] + 2 >> 2;
            t10 = src[src_offset + 9 - 1 * stride] + 2 * src[src_offset + 10 - 1 * stride] + src[src_offset + 11 - 1 * stride] + 2 >> 2;
            t11 = src[src_offset + 10 - 1 * stride] + 2 * src[src_offset + 11 - 1 * stride] + src[src_offset + 12 - 1 * stride] + 2 >> 2;
            t12 = src[src_offset + 11 - 1 * stride] + 2 * src[src_offset + 12 - 1 * stride] + src[src_offset + 13 - 1 * stride] + 2 >> 2;
        } else {
            t11 = t12 = src[src_offset + 7 - 1 * stride];
            t10 = t12;
            t9 = t12;
            t8 = t12;
        }
        src[src_offset + 0 + 0 * stride] = t0 + t1 + 1 >> 1;
        src[src_offset + 0 + 1 * stride] = t0 + 2 * t1 + t2 + 2 >> 2;
        int n = t1 + t2 + 1 >> 1;
        src[src_offset + 1 + 0 * stride] = n;
        src[src_offset + 0 + 2 * stride] = n;
        int n2 = t1 + 2 * t2 + t3 + 2 >> 2;
        src[src_offset + 1 + 1 * stride] = n2;
        src[src_offset + 0 + 3 * stride] = n2;
        int n3 = t2 + t3 + 1 >> 1;
        src[src_offset + 2 + 0 * stride] = n3;
        src[src_offset + 1 + 2 * stride] = n3;
        src[src_offset + 0 + 4 * stride] = n3;
        int n4 = t2 + 2 * t3 + t4 + 2 >> 2;
        src[src_offset + 2 + 1 * stride] = n4;
        src[src_offset + 1 + 3 * stride] = n4;
        src[src_offset + 0 + 5 * stride] = n4;
        int n5 = t3 + t4 + 1 >> 1;
        src[src_offset + 3 + 0 * stride] = n5;
        src[src_offset + 2 + 2 * stride] = n5;
        src[src_offset + 1 + 4 * stride] = n5;
        src[src_offset + 0 + 6 * stride] = n5;
        int n6 = t3 + 2 * t4 + t5 + 2 >> 2;
        src[src_offset + 3 + 1 * stride] = n6;
        src[src_offset + 2 + 3 * stride] = n6;
        src[src_offset + 1 + 5 * stride] = n6;
        src[src_offset + 0 + 7 * stride] = n6;
        int n7 = t4 + t5 + 1 >> 1;
        src[src_offset + 4 + 0 * stride] = n7;
        src[src_offset + 3 + 2 * stride] = n7;
        src[src_offset + 2 + 4 * stride] = n7;
        src[src_offset + 1 + 6 * stride] = n7;
        int n8 = t4 + 2 * t5 + t6 + 2 >> 2;
        src[src_offset + 4 + 1 * stride] = n8;
        src[src_offset + 3 + 3 * stride] = n8;
        src[src_offset + 2 + 5 * stride] = n8;
        src[src_offset + 1 + 7 * stride] = n8;
        int n9 = t5 + t6 + 1 >> 1;
        src[src_offset + 5 + 0 * stride] = n9;
        src[src_offset + 4 + 2 * stride] = n9;
        src[src_offset + 3 + 4 * stride] = n9;
        src[src_offset + 2 + 6 * stride] = n9;
        int n10 = t5 + 2 * t6 + t7 + 2 >> 2;
        src[src_offset + 5 + 1 * stride] = n10;
        src[src_offset + 4 + 3 * stride] = n10;
        src[src_offset + 3 + 5 * stride] = n10;
        src[src_offset + 2 + 7 * stride] = n10;
        int n11 = t6 + t7 + 1 >> 1;
        src[src_offset + 6 + 0 * stride] = n11;
        src[src_offset + 5 + 2 * stride] = n11;
        src[src_offset + 4 + 4 * stride] = n11;
        src[src_offset + 3 + 6 * stride] = n11;
        int n12 = t6 + 2 * t7 + t8 + 2 >> 2;
        src[src_offset + 6 + 1 * stride] = n12;
        src[src_offset + 5 + 3 * stride] = n12;
        src[src_offset + 4 + 5 * stride] = n12;
        src[src_offset + 3 + 7 * stride] = n12;
        int n13 = t7 + t8 + 1 >> 1;
        src[src_offset + 7 + 0 * stride] = n13;
        src[src_offset + 6 + 2 * stride] = n13;
        src[src_offset + 5 + 4 * stride] = n13;
        src[src_offset + 4 + 6 * stride] = n13;
        int n14 = t7 + 2 * t8 + t9 + 2 >> 2;
        src[src_offset + 7 + 1 * stride] = n14;
        src[src_offset + 6 + 3 * stride] = n14;
        src[src_offset + 5 + 5 * stride] = n14;
        src[src_offset + 4 + 7 * stride] = n14;
        int n15 = t8 + t9 + 1 >> 1;
        src[src_offset + 7 + 2 * stride] = n15;
        src[src_offset + 6 + 4 * stride] = n15;
        src[src_offset + 5 + 6 * stride] = n15;
        int n16 = t8 + 2 * t9 + t10 + 2 >> 2;
        src[src_offset + 7 + 3 * stride] = n16;
        src[src_offset + 6 + 5 * stride] = n16;
        src[src_offset + 5 + 7 * stride] = n16;
        int n17 = t9 + t10 + 1 >> 1;
        src[src_offset + 7 + 4 * stride] = n17;
        src[src_offset + 6 + 6 * stride] = n17;
        int n18 = t9 + 2 * t10 + t11 + 2 >> 2;
        src[src_offset + 7 + 5 * stride] = n18;
        src[src_offset + 6 + 7 * stride] = n18;
        src[src_offset + 7 + 6 * stride] = t10 + t11 + 1 >> 1;
        src[src_offset + 7 + 7 * stride] = t10 + 2 * t11 + t12 + 2 >> 2;
    }

    public static void pred8x8l_horizontal_up_c(int[] src, int src_offset, int has_topleft, int has_topright, int stride) {
        int l0 = (has_topleft != 0 ? src[src_offset - 1 - 1 * stride] : src[src_offset - 1 + 0 * stride]) + 2 * src[src_offset - 1 + 0 * stride] + src[src_offset - 1 + 1 * stride] + 2 >> 2;
        int l1 = src[src_offset - 1 + 0 * stride] + 2 * src[src_offset - 1 + 1 * stride] + src[src_offset - 1 + 2 * stride] + 2 >> 2;
        int l2 = src[src_offset - 1 + 1 * stride] + 2 * src[src_offset - 1 + 2 * stride] + src[src_offset - 1 + 3 * stride] + 2 >> 2;
        int l3 = src[src_offset - 1 + 2 * stride] + 2 * src[src_offset - 1 + 3 * stride] + src[src_offset - 1 + 4 * stride] + 2 >> 2;
        int l4 = src[src_offset - 1 + 3 * stride] + 2 * src[src_offset - 1 + 4 * stride] + src[src_offset - 1 + 5 * stride] + 2 >> 2;
        int l5 = src[src_offset - 1 + 4 * stride] + 2 * src[src_offset - 1 + 5 * stride] + src[src_offset - 1 + 6 * stride] + 2 >> 2;
        int l6 = src[src_offset - 1 + 5 * stride] + 2 * src[src_offset - 1 + 6 * stride] + src[src_offset - 1 + 7 * stride] + 2 >> 2;
        int l7 = src[src_offset - 1 + 6 * stride] + 3 * src[src_offset - 1 + 7 * stride] + 2 >> 2;
        src[src_offset + 0 + 0 * stride] = l0 + l1 + 1 >> 1;
        src[src_offset + 1 + 0 * stride] = l0 + 2 * l1 + l2 + 2 >> 2;
        int n = l1 + l2 + 1 >> 1;
        src[src_offset + 2 + 0 * stride] = n;
        src[src_offset + 0 + 1 * stride] = n;
        int n2 = l1 + 2 * l2 + l3 + 2 >> 2;
        src[src_offset + 3 + 0 * stride] = n2;
        src[src_offset + 1 + 1 * stride] = n2;
        int n3 = l2 + l3 + 1 >> 1;
        src[src_offset + 4 + 0 * stride] = n3;
        src[src_offset + 2 + 1 * stride] = n3;
        src[src_offset + 0 + 2 * stride] = n3;
        int n4 = l2 + 2 * l3 + l4 + 2 >> 2;
        src[src_offset + 5 + 0 * stride] = n4;
        src[src_offset + 3 + 1 * stride] = n4;
        src[src_offset + 1 + 2 * stride] = n4;
        int n5 = l3 + l4 + 1 >> 1;
        src[src_offset + 6 + 0 * stride] = n5;
        src[src_offset + 4 + 1 * stride] = n5;
        src[src_offset + 2 + 2 * stride] = n5;
        src[src_offset + 0 + 3 * stride] = n5;
        int n6 = l3 + 2 * l4 + l5 + 2 >> 2;
        src[src_offset + 7 + 0 * stride] = n6;
        src[src_offset + 5 + 1 * stride] = n6;
        src[src_offset + 3 + 2 * stride] = n6;
        src[src_offset + 1 + 3 * stride] = n6;
        int n7 = l4 + l5 + 1 >> 1;
        src[src_offset + 6 + 1 * stride] = n7;
        src[src_offset + 4 + 2 * stride] = n7;
        src[src_offset + 2 + 3 * stride] = n7;
        src[src_offset + 0 + 4 * stride] = n7;
        int n8 = l4 + 2 * l5 + l6 + 2 >> 2;
        src[src_offset + 7 + 1 * stride] = n8;
        src[src_offset + 5 + 2 * stride] = n8;
        src[src_offset + 3 + 3 * stride] = n8;
        src[src_offset + 1 + 4 * stride] = n8;
        int n9 = l5 + l6 + 1 >> 1;
        src[src_offset + 6 + 2 * stride] = n9;
        src[src_offset + 4 + 3 * stride] = n9;
        src[src_offset + 2 + 4 * stride] = n9;
        src[src_offset + 0 + 5 * stride] = n9;
        int n10 = l5 + 2 * l6 + l7 + 2 >> 2;
        src[src_offset + 7 + 2 * stride] = n10;
        src[src_offset + 5 + 3 * stride] = n10;
        src[src_offset + 3 + 4 * stride] = n10;
        src[src_offset + 1 + 5 * stride] = n10;
        int n11 = l6 + l7 + 1 >> 1;
        src[src_offset + 6 + 3 * stride] = n11;
        src[src_offset + 4 + 4 * stride] = n11;
        src[src_offset + 2 + 5 * stride] = n11;
        src[src_offset + 0 + 6 * stride] = n11;
        int n12 = l6 + 3 * l7 + 2 >> 2;
        src[src_offset + 7 + 3 * stride] = n12;
        src[src_offset + 5 + 4 * stride] = n12;
        src[src_offset + 3 + 5 * stride] = n12;
        src[src_offset + 1 + 6 * stride] = n12;
        int n13 = l7;
        src[src_offset + 7 + 7 * stride] = n13;
        src[src_offset + 7 + 6 * stride] = n13;
        src[src_offset + 7 + 5 * stride] = n13;
        src[src_offset + 7 + 4 * stride] = n13;
        src[src_offset + 6 + 7 * stride] = n13;
        src[src_offset + 6 + 6 * stride] = n13;
        src[src_offset + 6 + 5 * stride] = n13;
        src[src_offset + 6 + 4 * stride] = n13;
        src[src_offset + 5 + 7 * stride] = n13;
        src[src_offset + 5 + 6 * stride] = n13;
        src[src_offset + 5 + 5 * stride] = n13;
        src[src_offset + 4 + 7 * stride] = n13;
        src[src_offset + 4 + 6 * stride] = n13;
        src[src_offset + 4 + 5 * stride] = n13;
        src[src_offset + 3 + 7 * stride] = n13;
        src[src_offset + 3 + 6 * stride] = n13;
        src[src_offset + 2 + 7 * stride] = n13;
        src[src_offset + 2 + 6 * stride] = n13;
        src[src_offset + 1 + 7 * stride] = n13;
        src[src_offset + 0 + 7 * stride] = n13;
    }

    public static void pred4x4_vertical_add_c(int[] pix, int pix_offset, short[] block, int block_offset, int stride) {
        pix_offset -= stride;
        for (int i = 0; i < 4; ++i) {
            int v = pix[pix_offset + 0];
            pix[pix_offset + 1 * stride] = v += block[block_offset + 0];
            pix[pix_offset + 2 * stride] = v += block[block_offset + 4];
            pix[pix_offset + 3 * stride] = v += block[block_offset + 8];
            pix[pix_offset + 4 * stride] = v + block[block_offset + 12];
            ++pix_offset;
            ++block_offset;
        }
    }

    public static void pred4x4_horizontal_add_c(int[] pix, int pix_offset, short[] block, int block_offset, int stride) {
        for (int i = 0; i < 4; ++i) {
            int v = pix[pix_offset - 1];
            pix[pix_offset + 0] = v += block[block_offset + 0];
            pix[pix_offset + 1] = v += block[block_offset + 1];
            pix[pix_offset + 2] = v += block[block_offset + 2];
            pix[pix_offset + 3] = v + block[block_offset + 3];
            pix_offset += stride;
            block_offset += 4;
        }
    }

    public static void pred8x8l_vertical_add_c(int[] pix, int pix_offset, short[] block, int block_offset, int stride) {
        pix_offset -= stride;
        for (int i = 0; i < 8; ++i) {
            int v = pix[pix_offset + 0];
            pix[pix_offset + 1 * stride] = v += block[block_offset + 0];
            pix[pix_offset + 2 * stride] = v += block[block_offset + 8];
            pix[pix_offset + 3 * stride] = v += block[block_offset + 16];
            pix[pix_offset + 4 * stride] = v += block[block_offset + 24];
            pix[pix_offset + 5 * stride] = v += block[block_offset + 32];
            pix[pix_offset + 6 * stride] = v += block[block_offset + 40];
            pix[pix_offset + 7 * stride] = v += block[block_offset + 48];
            pix[pix_offset + 8 * stride] = v + block[block_offset + 56];
            ++pix_offset;
            ++block_offset;
        }
    }

    public static void pred8x8l_horizontal_add_c(int[] pix, int pix_offset, short[] block, int block_offset, int stride) {
        for (int i = 0; i < 8; ++i) {
            int v = pix[pix_offset - 1];
            pix[pix_offset + 0] = v += block[block_offset + 0];
            pix[pix_offset + 1] = v += block[block_offset + 1];
            pix[pix_offset + 2] = v += block[block_offset + 2];
            pix[pix_offset + 3] = v += block[block_offset + 3];
            pix[pix_offset + 4] = v += block[block_offset + 4];
            pix[pix_offset + 5] = v += block[block_offset + 5];
            pix[pix_offset + 6] = v += block[block_offset + 6];
            pix[pix_offset + 7] = v + block[block_offset + 7];
            pix_offset += stride;
            block_offset += 8;
        }
    }

    public static void pred16x16_vertical_add_c(int[] pix, int pix_offset, int[] block_offset, int block_offset_offset, short[] block, int _block_offset, int stride) {
        for (int i = 0; i < 16; ++i) {
            H264PredictionContext.pred4x4_vertical_add_c(pix, pix_offset + block_offset[block_offset_offset + i], block, _block_offset + i * 16, stride);
        }
    }

    public static void pred16x16_horizontal_add_c(int[] pix, int pix_offset, int[] block_offset, int block_offset_offset, short[] block, int _block_offset, int stride) {
        for (int i = 0; i < 16; ++i) {
            H264PredictionContext.pred4x4_horizontal_add_c(pix, pix_offset + block_offset[block_offset_offset + i], block, _block_offset + i * 16, stride);
        }
    }

    public static void pred8x8_vertical_add_c(int[] pix, int pix_offset, int[] block_offset, int block_offset_offset, short[] block, int _block_offset, int stride) {
        for (int i = 0; i < 4; ++i) {
            H264PredictionContext.pred4x4_vertical_add_c(pix, pix_offset + block_offset[block_offset_offset + i], block, _block_offset + i * 16, stride);
        }
    }

    public static void pred8x8_horizontal_add_c(int[] pix, int pix_offset, int[] block_offset, int block_offset_offset, short[] block, int _block_offset, int stride) {
        for (int i = 0; i < 4; ++i) {
            H264PredictionContext.pred4x4_horizontal_add_c(pix, pix_offset + block_offset[block_offset_offset + i], block, _block_offset + i * 16, stride);
        }
    }

    public static interface IPrediction16x16_add {
        public void pred16x16_add(int[] var1, int var2, int[] var3, int var4, short[] var5, int var6, int var7);
    }

    public static interface IPrediction8x8_add {
        public void pred8x8_add(int[] var1, int var2, int[] var3, int var4, short[] var5, int var6, int var7);
    }

    public static interface IPrediction8x8L_add {
        public void pred8x8l_add(int[] var1, int var2, short[] var3, int var4, int var5);
    }

    public static interface IPrediction4x4_add {
        public void pred4x4_add(int[] var1, int var2, short[] var3, int var4, int var5);
    }

    public static interface IPrediction16x16 {
        public void pred16x16(int[] var1, int var2, int var3);
    }

    public static interface IPrediction8x8 {
        public void pred8x8(int[] var1, int var2, int var3);
    }

    public static interface IPrediction8x8L {
        public void pred8x8l(int[] var1, int var2, int var3, int var4, int var5);
    }

    public static interface IPrediction4x4 {
        public void pred4x4(int[] var1, int var2, int[] var3, int var4, int var5);
    }
}

