/*
 * Decompiled with CFR 0.152.
 */
package com.twilight.h264.player;

import com.twilight.h264.decoder.AVFrame;
import com.twilight.h264.decoder.AVPacket;
import com.twilight.h264.decoder.H264Decoder;
import com.twilight.h264.decoder.MpegEncContext;
import com.twilight.h264.player.FrameUtils;
import com.twilight.h264.player.PlayerFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import javax.swing.JFrame;

public class H264Player
implements Runnable {
    public static final int INBUF_SIZE = 65535;
    private PlayerFrame displayPanel;
    private String fileName;
    private int[] buffer = null;

    public static void main(String[] args) {
        new H264Player(args);
    }

    public H264Player(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java com.twilight.h264.decoder.H264Player <.h264 raw file>\n");
            return;
        }
        JFrame frame = new JFrame("Player");
        this.displayPanel = new PlayerFrame();
        frame.getContentPane().add((Component)this.displayPanel, "Center");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.displayPanel.setVisible(true);
        frame.pack();
        frame.setVisible(true);
        frame.setSize(new Dimension(645, 380));
        this.fileName = args[0];
        new Thread(this).start();
    }

    @Override
    public void run() {
        System.out.println("Playing " + this.fileName);
        this.playFile(this.fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean playFile(String filename) {
        MpegEncContext c = null;
        FileInputStream fin = null;
        int[] got_picture = new int[1];
        File f = new File(filename);
        byte[] inbuf = new byte[65615];
        int[] inbuf_int = new int[65615];
        AVPacket avpkt = new AVPacket();
        avpkt.av_init_packet();
        Arrays.fill(inbuf, 65535, 65615, (byte)0);
        System.out.println("Video decoding\n");
        H264Decoder codec = new H264Decoder();
        if (codec == null) {
            System.out.println("codec not found\n");
            System.exit(1);
        }
        c = MpegEncContext.avcodec_alloc_context();
        AVFrame picture = AVFrame.avcodec_alloc_frame();
        if ((codec.capabilities & 8) != 0) {
            c.flags |= 0x10000;
        }
        if (c.avcodec_open(codec) < 0) {
            System.out.println("could not open codec\n");
            System.exit(1);
        }
        try {
            fin = new FileInputStream(f);
            int frame = 0;
            int[] cacheRead = new int[]{fin.read(), fin.read(), fin.read()};
            while (cacheRead[0] != 0 || cacheRead[1] != 0 || cacheRead[2] != 1) {
                cacheRead[0] = cacheRead[1];
                cacheRead[1] = cacheRead[2];
                cacheRead[2] = fin.read();
            }
            boolean hasMoreNAL = true;
            inbuf_int[2] = 0;
            inbuf_int[1] = 0;
            inbuf_int[0] = 0;
            inbuf_int[3] = 1;
            block14: while (hasMoreNAL) {
                int dataPointer = 4;
                cacheRead[0] = fin.read();
                if (cacheRead[0] == -1) {
                    hasMoreNAL = false;
                }
                cacheRead[1] = fin.read();
                if (cacheRead[1] == -1) {
                    hasMoreNAL = false;
                }
                cacheRead[2] = fin.read();
                if (cacheRead[2] == -1) {
                    hasMoreNAL = false;
                }
                while ((cacheRead[0] != 0 || cacheRead[1] != 0 || cacheRead[2] != 1) && hasMoreNAL) {
                    inbuf_int[dataPointer++] = cacheRead[0];
                    cacheRead[0] = cacheRead[1];
                    cacheRead[1] = cacheRead[2];
                    cacheRead[2] = fin.read();
                    if (cacheRead[2] != -1) continue;
                    hasMoreNAL = false;
                }
                avpkt.size = dataPointer;
                avpkt.data_base = inbuf_int;
                avpkt.data_offset = 0;
                try {
                    while (avpkt.size > 0) {
                        int len = c.avcodec_decode_video2(picture, got_picture, avpkt);
                        if (len < 0) {
                            System.out.println("Error while decoding frame " + frame);
                            continue block14;
                        }
                        if (got_picture[0] != 0) {
                            picture = c.priv_data.displayPicture;
                            int bufferSize = picture.imageWidth * picture.imageHeight;
                            if (this.buffer == null || bufferSize != this.buffer.length) {
                                this.buffer = new int[bufferSize];
                            }
                            FrameUtils.YUV2RGB(picture, this.buffer);
                            this.displayPanel.lastFrame = this.displayPanel.createImage(new MemoryImageSource(picture.imageWidth, picture.imageHeight, this.buffer, 0, picture.imageWidth));
                            this.displayPanel.invalidate();
                            this.displayPanel.updateUI();
                        }
                        avpkt.size -= len;
                        avpkt.data_offset += len;
                    }
                }
                catch (Exception ie) {
                    ie.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fin.close();
            }
            catch (Exception exception) {}
        }
        c.avcodec_close();
        c = null;
        picture = null;
        System.out.println("Stop playing video.");
        return true;
    }
}

