/*
 * Decompiled with CFR 0.152.
 */
package com.twilight.h264.util;

public class Buffer {
    private int cap = 0;
    private int limit = 0;
    private int pos = 0;
    private int mark = -1;

    Buffer(int capacity, int limit_, int position, int mark_) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.cap = capacity;
        this.limit = limit_;
        this.pos = position;
        if (mark_ > 0 && mark_ > this.pos) {
            throw new IllegalArgumentException();
        }
        this.mark = mark_;
    }

    public int capacity() {
        return this.cap;
    }

    public Buffer clear() {
        this.limit = this.cap;
        this.pos = 0;
        this.mark = -1;
        return this;
    }

    public Buffer flip() {
        this.limit = this.pos;
        this.pos = 0;
        this.mark = -1;
        return this;
    }

    public boolean hasRemaining() {
        return this.limit > this.pos;
    }

    public int limit() {
        return this.limit;
    }

    public Buffer limit(int newLimit) {
        if (newLimit < 0 || newLimit > this.cap) {
            throw new IllegalArgumentException();
        }
        if (newLimit <= this.mark) {
            this.mark = -1;
        }
        if (this.pos > newLimit) {
            this.pos = newLimit - 1;
        }
        this.limit = newLimit;
        return this;
    }

    public Buffer mark() {
        this.mark = this.pos;
        return this;
    }

    public int position() {
        return this.pos;
    }

    public Buffer position(int newPosition) {
        if (newPosition < 0 || newPosition > this.limit) {
            throw new IllegalArgumentException();
        }
        if (newPosition <= this.mark) {
            this.mark = -1;
        }
        this.pos = newPosition;
        return this;
    }

    public int remaining() {
        return this.limit - this.pos;
    }

    public Buffer reset() {
        if (this.mark == -1) {
            throw new IllegalArgumentException();
        }
        this.pos = this.mark;
        return this;
    }

    public Buffer rewind() {
        this.pos = 0;
        this.mark = -1;
        return this;
    }
}

