/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex;

import java.io.IOException;
import jpcsp.Emulator;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class GprState
implements IState {
    private static final int STATE_VERSION = 0;
    protected Logger log;
    public static final int NUMBER_REGISTERS = 32;
    public final int _zr = 0;
    public int _at;
    public int _v0;
    public int _v1;
    public int _a0;
    public int _a1;
    public int _a2;
    public int _a3;
    public int _t0;
    public int _t1;
    public int _t2;
    public int _t3;
    public int _t4;
    public int _t5;
    public int _t6;
    public int _t7;
    public int _s0;
    public int _s1;
    public int _s2;
    public int _s3;
    public int _s4;
    public int _s5;
    public int _s6;
    public int _s7;
    public int _t8;
    public int _t9;
    public int _k0;
    public int _k1;
    public int _gp;
    public int _sp;
    public int _fp;
    public int _ra;

    public void setLogger(Logger log) {
        this.log = log;
    }

    public void reset() {
        this._at = 0;
        this._v0 = 0;
        this._v1 = 0;
        this._a0 = 0;
        this._a1 = 0;
        this._a2 = 0;
        this._a3 = 0;
        this._t0 = 0;
        this._t1 = 0;
        this._t2 = 0;
        this._t3 = 0;
        this._t4 = 0;
        this._t5 = 0;
        this._t6 = 0;
        this._t7 = 0;
        this._s0 = 0;
        this._s1 = 0;
        this._s2 = 0;
        this._s3 = 0;
        this._s4 = 0;
        this._s5 = 0;
        this._s6 = 0;
        this._s7 = 0;
        this._t8 = 0;
        this._t9 = 0;
        this._k0 = 0;
        this._k1 = 0;
        this._gp = 0;
        this._sp = 0;
        this._fp = 0;
        this._ra = 0;
    }

    public void resetAll() {
        this._at = 0;
        this._v0 = 0;
        this._v1 = 0;
        this._a0 = 0;
        this._a1 = 0;
        this._a2 = 0;
        this._a3 = 0;
        this._t0 = 0;
        this._t1 = 0;
        this._t2 = 0;
        this._t3 = 0;
        this._t4 = 0;
        this._t5 = 0;
        this._t6 = 0;
        this._t7 = 0;
        this._s0 = 0;
        this._s1 = 0;
        this._s2 = 0;
        this._s3 = 0;
        this._s4 = 0;
        this._s5 = 0;
        this._s6 = 0;
        this._s7 = 0;
        this._t8 = 0;
        this._t9 = 0;
        this._k0 = 0;
        this._k1 = 0;
        this._gp = 0;
        this._sp = 0;
        this._fp = 0;
        this._ra = 0;
    }

    public GprState() {
    }

    public void copy(GprState that) {
        this.log = that.log;
        this._at = that._at;
        this._v0 = that._v0;
        this._v1 = that._v1;
        this._a0 = that._a0;
        this._a1 = that._a1;
        this._a2 = that._a2;
        this._a3 = that._a3;
        this._t0 = that._t0;
        this._t1 = that._t1;
        this._t2 = that._t2;
        this._t3 = that._t3;
        this._t4 = that._t4;
        this._t5 = that._t5;
        this._t6 = that._t6;
        this._t7 = that._t7;
        this._s0 = that._s0;
        this._s1 = that._s1;
        this._s2 = that._s2;
        this._s3 = that._s3;
        this._s4 = that._s4;
        this._s5 = that._s5;
        this._s6 = that._s6;
        this._s7 = that._s7;
        this._t8 = that._t8;
        this._t9 = that._t9;
        this._k0 = that._k0;
        this._k1 = that._k1;
        this._gp = that._gp;
        this._sp = that._sp;
        this._fp = that._fp;
        this._ra = that._ra;
    }

    public GprState(GprState that) {
        this.log = that.log;
        this._at = that._at;
        this._v0 = that._v0;
        this._v1 = that._v1;
        this._a0 = that._a0;
        this._a1 = that._a1;
        this._a2 = that._a2;
        this._a3 = that._a3;
        this._t0 = that._t0;
        this._t1 = that._t1;
        this._t2 = that._t2;
        this._t3 = that._t3;
        this._t4 = that._t4;
        this._t5 = that._t5;
        this._t6 = that._t6;
        this._t7 = that._t7;
        this._s0 = that._s0;
        this._s1 = that._s1;
        this._s2 = that._s2;
        this._s3 = that._s3;
        this._s4 = that._s4;
        this._s5 = that._s5;
        this._s6 = that._s6;
        this._s7 = that._s7;
        this._t8 = that._t8;
        this._t9 = that._t9;
        this._k0 = that._k0;
        this._k1 = that._k1;
        this._gp = that._gp;
        this._sp = that._sp;
        this._fp = that._fp;
        this._ra = that._ra;
    }

    public int getRegister(int reg) {
        switch (reg) {
            case 0: {
                return 0;
            }
            case 1: {
                return this._at;
            }
            case 2: {
                return this._v0;
            }
            case 3: {
                return this._v1;
            }
            case 4: {
                return this._a0;
            }
            case 5: {
                return this._a1;
            }
            case 6: {
                return this._a2;
            }
            case 7: {
                return this._a3;
            }
            case 8: {
                return this._t0;
            }
            case 9: {
                return this._t1;
            }
            case 10: {
                return this._t2;
            }
            case 11: {
                return this._t3;
            }
            case 12: {
                return this._t4;
            }
            case 13: {
                return this._t5;
            }
            case 14: {
                return this._t6;
            }
            case 15: {
                return this._t7;
            }
            case 16: {
                return this._s0;
            }
            case 17: {
                return this._s1;
            }
            case 18: {
                return this._s2;
            }
            case 19: {
                return this._s3;
            }
            case 20: {
                return this._s4;
            }
            case 21: {
                return this._s5;
            }
            case 22: {
                return this._s6;
            }
            case 23: {
                return this._s7;
            }
            case 24: {
                return this._t8;
            }
            case 25: {
                return this._t9;
            }
            case 26: {
                return this._k0;
            }
            case 27: {
                return this._k1;
            }
            case 28: {
                return this._gp;
            }
            case 29: {
                return this._sp;
            }
            case 30: {
                return this._fp;
            }
            case 31: {
                return this._ra;
            }
        }
        Emulator.log.error((Object)String.format("Unknown register %d", reg));
        return 0;
    }

    public void setRegister(int reg, int value) {
        switch (reg) {
            case 0: {
                return;
            }
            case 1: {
                this._at = value;
                return;
            }
            case 2: {
                this._v0 = value;
                return;
            }
            case 3: {
                this._v1 = value;
                return;
            }
            case 4: {
                this._a0 = value;
                return;
            }
            case 5: {
                this._a1 = value;
                return;
            }
            case 6: {
                this._a2 = value;
                return;
            }
            case 7: {
                this._a3 = value;
                return;
            }
            case 8: {
                this._t0 = value;
                return;
            }
            case 9: {
                this._t1 = value;
                return;
            }
            case 10: {
                this._t2 = value;
                return;
            }
            case 11: {
                this._t3 = value;
                return;
            }
            case 12: {
                this._t4 = value;
                return;
            }
            case 13: {
                this._t5 = value;
                return;
            }
            case 14: {
                this._t6 = value;
                return;
            }
            case 15: {
                this._t7 = value;
                return;
            }
            case 16: {
                this._s0 = value;
                return;
            }
            case 17: {
                this._s1 = value;
                return;
            }
            case 18: {
                this._s2 = value;
                return;
            }
            case 19: {
                this._s3 = value;
                return;
            }
            case 20: {
                this._s4 = value;
                return;
            }
            case 21: {
                this._s5 = value;
                return;
            }
            case 22: {
                this._s6 = value;
                return;
            }
            case 23: {
                this._s7 = value;
                return;
            }
            case 24: {
                this._t8 = value;
                return;
            }
            case 25: {
                this._t9 = value;
                return;
            }
            case 26: {
                this._k0 = value;
                return;
            }
            case 27: {
                this._k1 = value;
                return;
            }
            case 28: {
                this._gp = value;
                return;
            }
            case 29: {
                this._sp = value;
                return;
            }
            case 30: {
                this._fp = value;
                return;
            }
            case 31: {
                this._ra = value;
                return;
            }
        }
        Emulator.log.error((Object)String.format("Unknown register %d, value=0x%08X", reg, value));
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        for (int i = 1; i < 32; ++i) {
            this.setRegister(i, stream.readInt());
        }
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        for (int i = 1; i < 32; ++i) {
            stream.writeInt(this.getRegister(i));
        }
    }

    public void doUNK(String reason) {
        Emulator.log.error((Object)("Interpreter : " + reason));
    }

    public static final int extractBits(int x, int pos, int len) {
        return x >>> pos & ~(-1 << len);
    }

    public static final int insertBits(int x, int y, int lsb, int msb) {
        int mask = ~(-1 << msb - lsb + 1) << lsb;
        return x & ~mask | y << lsb & mask;
    }

    public static final int signExtend(int value) {
        return value << 16 >> 16;
    }

    public static final int signExtend8(int value) {
        return value << 24 >> 24;
    }

    public static final int zeroExtend(int value) {
        return value & 0xFFFF;
    }

    public static final int zeroExtend8(int value) {
        return value & 0xFF;
    }

    public static final int signedCompare(int i, int j) {
        return i < j ? 1 : 0;
    }

    public static final int unsignedCompare(long i, long j) {
        return (i & 0xFFFFFFFFL) < (j & 0xFFFFFFFFL) ? 1 : 0;
    }

    public final void doSLL(int rd, int rt, int sa) {
        if (rd != 0) {
            this.setRegister(rd, this.getRegister(rt) << sa);
        }
    }

    public final void doSRL(int rd, int rt, int sa) {
        if (rd != 0) {
            this.setRegister(rd, this.getRegister(rt) >>> sa);
        }
    }

    public final void doSRA(int rd, int rt, int sa) {
        if (rd != 0) {
            this.setRegister(rd, this.getRegister(rt) >> sa);
        }
    }

    public final void doSLLV(int rd, int rt, int rs) {
        if (rd != 0) {
            this.setRegister(rd, this.getRegister(rt) << (this.getRegister(rs) & 0x1F));
        }
    }

    public final void doSRLV(int rd, int rt, int rs) {
        if (rd != 0) {
            this.setRegister(rd, this.getRegister(rt) >>> (this.getRegister(rs) & 0x1F));
        }
    }

    public final void doSRAV(int rd, int rt, int rs) {
        if (rd != 0) {
            this.setRegister(rd, this.getRegister(rt) >> (this.getRegister(rs) & 0x1F));
        }
    }

    public final void doADDU(int rd, int rs, int rt) {
        if (rd != 0) {
            this.setRegister(rd, this.getRegister(rs) + this.getRegister(rt));
        }
    }

    public final void doSUBU(int rd, int rs, int rt) {
        if (rd != 0) {
            this.setRegister(rd, this.getRegister(rs) - this.getRegister(rt));
        }
    }

    public final void doAND(int rd, int rs, int rt) {
        if (rd != 0) {
            this.setRegister(rd, this.getRegister(rs) & this.getRegister(rt));
        }
    }

    public final void doOR(int rd, int rs, int rt) {
        if (rd != 0) {
            this.setRegister(rd, this.getRegister(rs) | this.getRegister(rt));
        }
    }

    public final void doXOR(int rd, int rs, int rt) {
        if (rd != 0) {
            this.setRegister(rd, this.getRegister(rs) ^ this.getRegister(rt));
        }
    }

    public final void doNOR(int rd, int rs, int rt) {
        if (rd != 0) {
            this.setRegister(rd, ~(this.getRegister(rs) | this.getRegister(rt)));
        }
    }

    public final void doSLT(int rd, int rs, int rt) {
        if (rd != 0) {
            this.setRegister(rd, GprState.signedCompare(this.getRegister(rs), this.getRegister(rt)));
        }
    }

    public final void doSLTU(int rd, int rs, int rt) {
        if (rd != 0) {
            this.setRegister(rd, GprState.unsignedCompare(this.getRegister(rs), this.getRegister(rt)));
        }
    }

    public final void doADDIU(int rt, int rs, int simm16) {
        if (rt != 0) {
            this.setRegister(rt, this.getRegister(rs) + simm16);
        }
    }

    public final void doSLTI(int rt, int rs, int simm16) {
        if (rt != 0) {
            this.setRegister(rt, GprState.signedCompare(this.getRegister(rs), simm16));
        }
    }

    public final void doSLTIU(int rt, int rs, int simm16) {
        if (rt != 0) {
            this.setRegister(rt, GprState.unsignedCompare(this.getRegister(rs), simm16));
        }
    }

    public final void doANDI(int rt, int rs, int uimm16) {
        if (rt != 0) {
            this.setRegister(rt, this.getRegister(rs) & uimm16);
        }
    }

    public final void doORI(int rt, int rs, int uimm16) {
        if (rt != 0) {
            this.setRegister(rt, this.getRegister(rs) | uimm16);
        }
    }

    public final void doXORI(int rt, int rs, int uimm16) {
        if (rt != 0) {
            this.setRegister(rt, this.getRegister(rs) ^ uimm16);
        }
    }

    public final void doLUI(int rt, int uimm16) {
        if (rt != 0) {
            this.setRegister(rt, uimm16 << 16);
        }
    }

    public final void doROTR(int rd, int rt, int sa) {
        if (rd != 0) {
            this.setRegister(rd, Integer.rotateRight(this.getRegister(rt), sa));
        }
    }

    public final void doROTRV(int rd, int rt, int rs) {
        if (rd != 0) {
            this.setRegister(rd, Integer.rotateRight(this.getRegister(rt), this.getRegister(rs)));
        }
    }

    public final void doMOVZ(int rd, int rs, int rt) {
        if (rd != 0 && this.getRegister(rt) == 0) {
            this.setRegister(rd, this.getRegister(rs));
        }
    }

    public final void doMOVN(int rd, int rs, int rt) {
        if (rd != 0 && this.getRegister(rt) != 0) {
            this.setRegister(rd, this.getRegister(rs));
        }
    }

    public final void doCLZ(int rd, int rs) {
        if (rd != 0) {
            this.setRegister(rd, Integer.numberOfLeadingZeros(this.getRegister(rs)));
        }
    }

    public final void doCLO(int rd, int rs) {
        if (rd != 0) {
            this.setRegister(rd, Integer.numberOfLeadingZeros(~this.getRegister(rs)));
        }
    }

    public final void doMAX(int rd, int rs, int rt) {
        if (rd != 0) {
            this.setRegister(rd, Math.max(this.getRegister(rs), this.getRegister(rt)));
        }
    }

    public final void doMIN(int rd, int rs, int rt) {
        if (rd != 0) {
            this.setRegister(rd, Math.min(this.getRegister(rs), this.getRegister(rt)));
        }
    }

    public final void doEXT(int rt, int rs, int lsb, int msbd) {
        if (rt != 0) {
            this.setRegister(rt, GprState.extractBits(this.getRegister(rs), lsb, msbd + 1));
        }
    }

    public final void doINS(int rt, int rs, int lsb, int msb) {
        if (rt != 0) {
            this.setRegister(rt, GprState.insertBits(this.getRegister(rt), this.getRegister(rs), lsb, msb));
        }
    }

    public final void doWSBH(int rd, int rt) {
        if (rd != 0) {
            this.setRegister(rd, Integer.rotateRight(Integer.reverseBytes(this.getRegister(rt)), 16));
        }
    }

    public final void doWSBW(int rd, int rt) {
        if (rd != 0) {
            this.setRegister(rd, Integer.reverseBytes(this.getRegister(rt)));
        }
    }

    public final void doSEB(int rd, int rt) {
        if (rd != 0) {
            this.setRegister(rd, (byte)this.getRegister(rt));
        }
    }

    public final void doBITREV(int rd, int rt) {
        if (rd != 0) {
            this.setRegister(rd, Integer.reverse(this.getRegister(rt)));
        }
    }

    public final void doSEH(int rd, int rt) {
        if (rd != 0) {
            this.setRegister(rd, (short)this.getRegister(rt));
        }
    }
}

