/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex;

import jpcsp.Allegrex.Common;
import jpcsp.Emulator;
import jpcsp.Processor;
import org.apache.log4j.Logger;

public class Interpreter {
    private Processor processor;
    private static final int DUMMY_ADDRESS = -1;
    private Logger log;

    public Interpreter(Processor processor) {
        this.processor = processor;
        this.log = processor.getLogger();
    }

    public void run(int address) {
        this.processor.cpu.pc = address;
        this.processor.cpu._ra = -1;
        boolean isTraceEnabled = this.log.isTraceEnabled();
        Processor previousProcessor = Emulator.setProcessor(this.processor);
        while (this.processor.cpu.pc != -1) {
            this.processor.interpret();
            if (!isTraceEnabled) continue;
            Common.Instruction instruction = this.processor.getInstruction();
            if (instruction.hasFlags(8192)) {
                int rt = this.processor.getOpcode() >> 16 & 0x1F;
                this.log.trace((Object)String.format("%s = 0x%08X", Common.gprNames[rt], this.processor.cpu.getRegister(rt)));
            }
            if (instruction.hasFlags(16384)) {
                int rd = this.processor.getOpcode() >> 11 & 0x1F;
                this.log.trace((Object)String.format("%s = 0x%08X", Common.gprNames[rd], this.processor.cpu.getRegister(rd)));
            }
            if (!instruction.hasFlags(4)) continue;
            Common.Instruction delaySlotInstruction = this.processor.getDelaySlotInstruction();
            if (delaySlotInstruction.hasFlags(8192)) {
                int rt = this.processor.getDelaySlotOpcode() >> 16 & 0x1F;
                this.log.trace((Object)String.format("%s = 0x%08X", Common.gprNames[rt], this.processor.cpu.getRegister(rt)));
            }
            if (!delaySlotInstruction.hasFlags(16384)) continue;
            int rd = this.processor.getDelaySlotOpcode() >> 11 & 0x1F;
            this.log.trace((Object)String.format("%s = 0x%08X", Common.gprNames[rd], this.processor.cpu.getRegister(rd)));
        }
        Emulator.setProcessor(previousProcessor);
    }
}

