/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.modules.reboot;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.mediaengine.MEProcessor;
import jpcsp.mediaengine.METhread;
import jpcsp.memory.DebuggerMemory;
import jpcsp.memory.mmio.MMIO;
import jpcsp.memory.mmio.MMIOHandlerInterruptMan;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class RuntimeContextLLE {
    public static Logger log = RuntimeContext.log;
    private static final int STATE_VERSION = 0;
    private static boolean isLLEActive;
    private static Memory mmio;
    public static volatile int pendingInterruptIPbitsMain;
    public static volatile int pendingInterruptIPbitsME;
    private static final List<IAction> exitActions;

    public static boolean isLLEActive() {
        return isLLEActive;
    }

    public static void enableLLE() {
        isLLEActive = true;
    }

    public static void start() {
        isLLEActive = reboot.enableReboot;
        if (!RuntimeContextLLE.isLLEActive()) {
            return;
        }
        RuntimeContextLLE.createMMIO();
    }

    public static void run() {
        if (!RuntimeContextLLE.isLLEActive()) {
            return;
        }
        MEProcessor.getInstance().sync();
    }

    public static void exit() {
        if (!RuntimeContextLLE.isLLEActive()) {
            return;
        }
        for (IAction action : exitActions) {
            action.execute();
        }
    }

    public static void registerExitAction(IAction action) {
        if (!exitActions.contains(action)) {
            exitActions.add(action);
        }
    }

    public static void reset() {
        if (mmio != null) {
            mmio.reset();
            mmio.Initialise();
        }
    }

    public static void createMMIO() {
        if (mmio == null) {
            Memory mem = Emulator.getMemory();
            mmio = mem instanceof DebuggerMemory ? new DebuggerMemory(new MMIO(((DebuggerMemory)mem).getDebuggedMemory())) : new MMIO(mem);
            if (mmio.allocate()) {
                mmio.Initialise();
            } else {
                mmio = null;
            }
            RuntimeContextLLE.markMMIO();
        }
    }

    private static void markMMIO() {
        Compiler compiler = Compiler.getInstance();
        compiler.addMMIORange(-2013265920, 0x800000);
        compiler.addMMIORange(-1077933056, 576);
    }

    public static boolean hasMMIO() {
        return mmio != null;
    }

    public static Memory getMMIO() {
        return mmio;
    }

    public static void triggerInterrupt(Processor processor, int interruptNumber) {
        if (!RuntimeContextLLE.isLLEActive()) {
            Managers.intr.triggerInterrupt(interruptNumber);
            return;
        }
        MMIOHandlerInterruptMan interruptMan = MMIOHandlerInterruptMan.getInstance(processor);
        if (!interruptMan.hasInterruptTriggered(interruptNumber)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("triggerInterrupt 0x%X(%s)", interruptNumber, IntrManager.getInterruptName(interruptNumber)));
            }
            interruptMan.triggerInterrupt(interruptNumber);
        }
    }

    public static void clearInterrupt(Processor processor, int interruptNumber) {
        if (!RuntimeContextLLE.isLLEActive()) {
            return;
        }
        MMIOHandlerInterruptMan interruptMan = MMIOHandlerInterruptMan.getInstance(processor);
        if (interruptMan.hasInterruptTriggered(interruptNumber)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("clearInterrupt 0x%X(%s)", interruptNumber, IntrManager.getInterruptName(interruptNumber)));
            }
            interruptMan.clearInterrupt(interruptNumber);
        }
    }

    public static synchronized void triggerInterruptException(Processor processor, int IPbits) {
        if (!RuntimeContextLLE.isLLEActive()) {
            return;
        }
        if (processor.cp0.isMainCpu()) {
            pendingInterruptIPbitsMain |= IPbits;
            RuntimeContext.onLLEInterrupt();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("triggerInterruptException IPbits=0x%X, pendingInterruptIPbitsMain=0x%X", IPbits, pendingInterruptIPbitsMain));
            }
        } else if (processor.cp0.isMediaEngineCpu()) {
            pendingInterruptIPbitsME |= IPbits;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("triggerInterruptException IPbits=0x%X, pendingInterruptIPbitsME=0x%X", IPbits, pendingInterruptIPbitsME));
            }
        }
    }

    public static int triggerSyscallException(Processor processor, int syscallCode, boolean inDelaySlot) {
        processor.cp0.setSyscallCode(syscallCode << 2);
        int pc = RuntimeContextLLE.triggerException(processor, 8, inDelaySlot);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Calling exception handler for Syscall at 0x%08X, epc=0x%08X", pc, processor.cp0.getEpc()));
        }
        return pc;
    }

    public static int triggerBreakException(Processor processor, boolean inDelaySlot) {
        int pc = RuntimeContextLLE.triggerException(processor, 9, inDelaySlot);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Calling exception handler for Break at 0x%08X, epc=0x%08X", pc, processor.cp0.getEpc()));
        }
        return pc;
    }

    public static boolean isMediaEngineCpu() {
        if (!RuntimeContextLLE.isLLEActive()) {
            return false;
        }
        return METhread.isMediaEngine(Thread.currentThread());
    }

    public static boolean isMainCpu() {
        if (!RuntimeContextLLE.isLLEActive()) {
            return true;
        }
        return !RuntimeContextLLE.isMediaEngineCpu();
    }

    public static Processor getMainProcessor() {
        return Emulator.getProcessor();
    }

    public static MEProcessor getMediaEngineProcessor() {
        return MEProcessor.getInstance();
    }

    public static Processor getProcessor() {
        if (RuntimeContextLLE.isMediaEngineCpu()) {
            return RuntimeContextLLE.getMediaEngineProcessor();
        }
        return RuntimeContextLLE.getMainProcessor();
    }

    public static int triggerException(Processor processor, int exceptionNumber, boolean inDelaySlot) {
        return RuntimeContextLLE.prepareExceptionHandlerCall(processor, exceptionNumber, inDelaySlot);
    }

    public static synchronized void clearInterruptException(Processor processor, int IPbits) {
        if (!RuntimeContextLLE.isLLEActive()) {
            return;
        }
        if (processor.cp0.isMainCpu()) {
            pendingInterruptIPbitsMain &= ~IPbits;
        } else if (processor.cp0.isMediaEngineCpu()) {
            pendingInterruptIPbitsME &= ~IPbits;
        }
    }

    private static boolean isInterruptExceptionAllowed(Processor processor, int IPbits) {
        if (IPbits == 0) {
            log.debug((Object)"IPbits == 0");
            return false;
        }
        if (processor.isInterruptsDisabled()) {
            return false;
        }
        int status = processor.cp0.getStatus();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("cp0 Status=0x%X", status));
        }
        if (Utilities.hasFlag(status, 2)) {
            return false;
        }
        return !Utilities.notHasFlag(status, 1) && (IPbits << 8 & status) != 0;
    }

    private static int prepareExceptionHandlerCall(Processor processor, int exceptionNumber, boolean inDelaySlot) {
        int cause = processor.cp0.getCause();
        cause = cause & 0xFFFFFF00 | exceptionNumber << 2;
        cause = inDelaySlot ? (cause |= Integer.MIN_VALUE) : (cause &= Integer.MAX_VALUE);
        processor.cp0.setCause(cause);
        int epc = processor.cpu.pc;
        if (inDelaySlot) {
            epc -= 4;
        }
        processor.cp0.setEpc(epc);
        int pc = Utilities.hasFlag(processor.cp0.getStatus(), 0x400000) ? -1077935616 : processor.cp0.getEbase();
        int status = processor.cp0.getStatus();
        status = Utilities.setFlag(status, 2);
        processor.cp0.setStatus(status);
        return pc;
    }

    public static synchronized int checkPendingInterruptException(int returnAddress) {
        Processor processor = RuntimeContextLLE.getProcessor();
        int IPbits = 0;
        if (processor.cp0.isMainCpu()) {
            IPbits = pendingInterruptIPbitsMain;
        } else if (processor.cp0.isMediaEngineCpu()) {
            IPbits = pendingInterruptIPbitsME;
        }
        if (RuntimeContextLLE.isInterruptExceptionAllowed(processor, IPbits)) {
            int cause = processor.cp0.getCause();
            cause |= IPbits << 8;
            if (processor.cp0.isMainCpu()) {
                pendingInterruptIPbitsMain = 0;
            } else if (processor.cp0.isMediaEngineCpu()) {
                pendingInterruptIPbitsME = 0;
            }
            processor.cp0.setCause(cause);
            int pc = RuntimeContextLLE.prepareExceptionHandlerCall(processor, 0, false);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Calling exception handler for %s at 0x%08X, epc=0x%08X, cause=0x%X", MMIOHandlerInterruptMan.getInstance(processor).toStringInterruptTriggered(), pc, processor.cp0.getEpc(), processor.cp0.getCause()));
            }
            return pc;
        }
        return returnAddress;
    }

    public static synchronized void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        pendingInterruptIPbitsMain = stream.readInt();
        pendingInterruptIPbitsME = stream.readInt();
    }

    public static synchronized void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(pendingInterruptIPbitsMain);
        stream.writeInt(pendingInterruptIPbitsME);
    }

    static {
        exitActions = new LinkedList<IAction>();
    }
}

