/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Debugger;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Emulator;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.WindowPropSaver;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.mmio.MMIO;
import jpcsp.util.Utilities;

public class MemoryViewer
extends JFrame {
    private static final long serialVersionUID = 1L;
    private int visiblelines = 0;
    private int startaddress;
    private JTextField AddressField;
    private JButton btnDumpRawRam;
    private JButton btnGoToAddress;
    private JButton btnGoToSP;
    private JButton btnGoToVRAM;
    private JPanel jPanel1;
    private JTextArea taMemoryView;

    public MemoryViewer() {
        this.startaddress = Emulator.getProcessor().cpu.pc;
        this.initComponents();
        this.RefreshMemory();
        WindowPropSaver.loadWindowProperties(this);
    }

    public static char converttochar(int character) {
        if (character < 32 || character >= 127 && character <= 160 || character == 173) {
            return '.';
        }
        return (char)(character & 0xFF);
    }

    private static byte safeRead8(Memory mem, int address) {
        byte value = 0;
        if (MemoryViewer.isAddressGood(address)) {
            value = (byte)mem.read8(address);
        }
        return value;
    }

    public static boolean isAddressGood(int address) {
        if (RuntimeContextLLE.hasMMIO()) {
            return MMIO.isAddressGood(address);
        }
        return Memory.isAddressGood(address);
    }

    public static Memory getMemory() {
        if (RuntimeContextLLE.hasMMIO()) {
            return RuntimeContextLLE.getMMIO();
        }
        return Memory.getInstance();
    }

    public static String getMemoryView(int addr) {
        byte[] line = new byte[16];
        Memory mem = MemoryViewer.getMemory();
        for (int i = 0; i < line.length; ++i) {
            line[i] = MemoryViewer.safeRead8(mem, addr + i);
        }
        return String.format("%08X : %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %02X %c %c %c %c %c %c %c %c %c %c %c %c %c %c %c %c", addr, line[0], line[1], line[2], line[3], line[4], line[5], line[6], line[7], line[8], line[9], line[10], line[11], line[12], line[13], line[14], line[15], Character.valueOf(MemoryViewer.converttochar(line[0])), Character.valueOf(MemoryViewer.converttochar(line[1])), Character.valueOf(MemoryViewer.converttochar(line[2])), Character.valueOf(MemoryViewer.converttochar(line[3])), Character.valueOf(MemoryViewer.converttochar(line[4])), Character.valueOf(MemoryViewer.converttochar(line[5])), Character.valueOf(MemoryViewer.converttochar(line[6])), Character.valueOf(MemoryViewer.converttochar(line[7])), Character.valueOf(MemoryViewer.converttochar(line[8])), Character.valueOf(MemoryViewer.converttochar(line[9])), Character.valueOf(MemoryViewer.converttochar(line[10])), Character.valueOf(MemoryViewer.converttochar(line[11])), Character.valueOf(MemoryViewer.converttochar(line[12])), Character.valueOf(MemoryViewer.converttochar(line[13])), Character.valueOf(MemoryViewer.converttochar(line[14])), Character.valueOf(MemoryViewer.converttochar(line[15])));
    }

    public void SafeRefreshMemory() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MemoryViewer.this.RefreshMemory();
            }
        });
    }

    public void RefreshMemory() {
        int addr = this.startaddress;
        this.taMemoryView.setText("");
        this.visiblelines = this.taMemoryView.getHeight() / this.taMemoryView.getFontMetrics(this.taMemoryView.getFont()).getHeight();
        for (int y = 0; y < this.visiblelines; ++y) {
            if (y > 0) {
                this.taMemoryView.append("\n");
            }
            this.taMemoryView.append(MemoryViewer.getMemoryView(addr));
            addr += 16;
        }
    }

    private void initComponents() {
        this.AddressField = new JTextField();
        this.btnGoToAddress = new JButton();
        this.btnGoToSP = new JButton();
        this.btnDumpRawRam = new JButton();
        this.btnGoToVRAM = new JButton();
        this.jPanel1 = new JPanel();
        this.taMemoryView = new JTextArea();
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        this.setTitle(bundle.getString("MemoryViewer.title"));
        this.setMinimumSize(new Dimension(800, 380));
        this.setPreferredSize(new Dimension(800, 380));
        this.AddressField.setFont(new Font("Courier New", 0, 12));
        this.AddressField.setHorizontalAlignment(0);
        this.AddressField.setText("0x00000000");
        this.AddressField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MemoryViewer.this.onKeyPressed(evt);
            }
        });
        this.btnGoToAddress.setText(bundle.getString("MemoryViewer.btnGoToAddress.text"));
        this.btnGoToAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryViewer.this.btnGoToAddressActionPerformed(evt);
            }
        });
        this.btnGoToSP.setText(bundle.getString("MemoryViewer.btnGoToSP.text"));
        this.btnGoToSP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryViewer.this.btnGoToSPActionPerformed(evt);
            }
        });
        this.btnDumpRawRam.setText(bundle.getString("MemoryViewer.btnDumpRawRam.text"));
        this.btnDumpRawRam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryViewer.this.btnDumpRawRamActionPerformed(evt);
            }
        });
        this.btnGoToVRAM.setText(bundle.getString("MemoryViewer.btnGoToVRAM.text"));
        this.btnGoToVRAM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemoryViewer.this.btnGoToVRAMActionPerformed(evt);
            }
        });
        this.jPanel1.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                MemoryViewer.this.jPanel1ComponentResized(evt);
            }
        });
        this.taMemoryView.setEditable(false);
        this.taMemoryView.setFont(new Font("Courier New", 0, 12));
        this.taMemoryView.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.taMemoryView.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                MemoryViewer.this.taMemoryViewMouseWheelMoved(evt);
            }
        });
        this.taMemoryView.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MemoryViewer.this.taMemoryViewKeyPressed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.taMemoryView));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.taMemoryView, -1, 295, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.AddressField, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGoToAddress, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnGoToVRAM, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnGoToSP, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnDumpRawRam, -1, -1, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnDumpRawRam).addComponent(this.AddressField, -2, -1, -2).addComponent(this.btnGoToAddress).addComponent(this.btnGoToSP).addComponent(this.btnGoToVRAM)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void taMemoryViewKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 40) {
            this.startaddress += 16;
            evt.consume();
            this.RefreshMemory();
        } else if (evt.getKeyCode() == 38) {
            this.startaddress -= 16;
            evt.consume();
            this.RefreshMemory();
        } else if (evt.getKeyCode() == 33) {
            this.startaddress -= 16 * this.visiblelines;
            evt.consume();
            this.RefreshMemory();
        } else if (evt.getKeyCode() == 34) {
            this.startaddress += 16 * this.visiblelines;
            evt.consume();
            this.RefreshMemory();
        }
    }

    private void btnGoToAddressActionPerformed(ActionEvent evt) {
        this.GoToAddress();
    }

    private void GoToAddress() {
        int value;
        String gettext = this.AddressField.getText();
        try {
            value = Utilities.parseAddressExpression(gettext);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("MemoryViewer.strInvalidAddress.text"));
            return;
        }
        this.startaddress = value;
        this.AddressField.setText(String.format("0x%08X", value));
        this.RefreshMemory();
    }

    private void taMemoryViewMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() > 0) {
            this.startaddress += 16;
            evt.consume();
            this.RefreshMemory();
        } else {
            this.startaddress -= 16;
            evt.consume();
            this.RefreshMemory();
        }
    }

    private void btnGoToSPActionPerformed(ActionEvent evt) {
        this.startaddress = Emulator.getProcessor().cpu._sp;
        this.RefreshMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void btnDumpRawRamActionPerformed(ActionEvent evt) {
        File f = new File("ramdump.bin");
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(f));
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(0x8000000, MemoryMap.SIZE_RAM, 1);
            for (int i = 0; i < MemoryMap.SIZE_RAM; ++i) {
                out.write(memoryReader.readNext());
            }
        }
        catch (IOException iOException) {
            Utilities.close(out);
            catch (Throwable throwable) {
                Utilities.close(out);
                throw throwable;
            }
        }
        Utilities.close(out);
    }

    private void onKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.GoToAddress();
        }
    }

    private void btnGoToVRAMActionPerformed(ActionEvent evt) {
        this.startaddress = 0x4000000;
        this.RefreshMemory();
    }

    private void jPanel1ComponentResized(ComponentEvent evt) {
        this.taMemoryView.setMinimumSize(this.jPanel1.getMinimumSize());
        this.taMemoryView.setMaximumSize(this.jPanel1.getMaximumSize());
        this.RefreshMemory();
    }

    @Override
    public void dispose() {
        Emulator.getMainGUI().endWindowDialog();
        super.dispose();
    }
}

