/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ResourceBundle;
import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.Profiler;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Clock;
import jpcsp.Debugger.InstructionCounter;
import jpcsp.Debugger.StepLogger;
import jpcsp.GUI.IMainGUI;
import jpcsp.GeneralJpcspException;
import jpcsp.HLE.HLEModuleManager;
import jpcsp.HLE.HLEUidObjectMapping;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.HLE.modules.reboot;
import jpcsp.Loader;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.NIDMapper;
import jpcsp.Processor;
import jpcsp.State;
import jpcsp.VariableSpeedClock;
import jpcsp.graphics.GEProfiler;
import jpcsp.graphics.RE.externalge.ExternalGE;
import jpcsp.graphics.RE.software.BasePrimitiveRenderer;
import jpcsp.graphics.RE.software.BaseRenderer;
import jpcsp.graphics.RE.software.RendererExecutor;
import jpcsp.graphics.VertexCache;
import jpcsp.hardware.Battery;
import jpcsp.hardware.Model;
import jpcsp.hardware.Nand;
import jpcsp.hardware.Wlan;
import jpcsp.memory.MemorySections;
import jpcsp.network.proonline.ProOnlineNetworkAdapter;
import jpcsp.scheduler.Scheduler;
import jpcsp.settings.Settings;
import jpcsp.sound.SoundChannel;
import jpcsp.util.JpcspDialogManager;
import org.apache.log4j.Logger;

public class Emulator
implements Runnable {
    private static Emulator instance;
    private static Processor processor;
    private static Clock clock;
    private static Scheduler scheduler;
    private boolean moduleLoaded;
    private Thread mainThread;
    public static boolean run;
    public static boolean pause;
    private static IMainGUI gui;
    private InstructionCounter instructionCounter;
    public static Logger log;
    private SceModule module;
    private int firmwareVersion = 999;
    private String[] bootModuleBlackList = new String[]{"Prometheus Loader"};
    public static final int EMU_STATUS_OK = 0;
    public static final int EMU_STATUS_UNKNOWN = -1;
    public static final int EMU_STATUS_WDT_IDLE = 1;
    public static final int EMU_STATUS_WDT_HOG = 2;
    public static final int EMU_STATUS_WDT_ANY = 3;
    public static final int EMU_STATUS_MEM_READ = 4;
    public static final int EMU_STATUS_MEM_WRITE = 8;
    public static final int EMU_STATUS_MEM_ANY = 12;
    public static final int EMU_STATUS_BREAKPOINT = 16;
    public static final int EMU_STATUS_UNIMPLEMENTED = 32;
    public static final int EMU_STATUS_PAUSE = 64;
    public static final int EMU_STATUS_JUMPSELF = 128;
    public static final int EMU_STATUS_BREAK = 256;
    public static final int EMU_STATUS_HALT = 512;
    public static final int EMU_STATUS_SHUTDOWN = 1024;
    public static final int EMU_STATUS_SUSPEND = 2048;

    public Emulator(IMainGUI gui) {
        Emulator.gui = gui;
        processor = new Processor();
        clock = new Clock();
        scheduler = Scheduler.getInstance();
        this.moduleLoaded = false;
        this.mainThread = new Thread((Runnable)this, "Emu");
        instance = this;
    }

    public Thread getMainThread() {
        return this.mainThread;
    }

    public static void exit() {
        RendererExecutor.exit();
        VertexCache.getInstance().exit();
        Compiler.exit();
        RuntimeContextLLE.exit();
        RuntimeContext.exit();
        Profiler.exit();
        GEProfiler.exit();
        BaseRenderer.exit();
        BasePrimitiveRenderer.exit();
        ExternalGE.exit();
        SoundChannel.exit();
    }

    private boolean isBootModuleBad(String name) {
        for (String moduleName : this.bootModuleBlackList) {
            if (!name.equals(moduleName)) continue;
            return true;
        }
        return false;
    }

    public SceModule load(String pspfilename, ByteBuffer f) throws IOException, GeneralJpcspException {
        return this.load(pspfilename, f, false, false);
    }

    private TPointer getLoadAddress() {
        Memory mem = Emulator.getMemory();
        SysMemUserForUser.SysMemInfo testInfo = Modules.SysMemUserForUserModule.malloc(2, "test-LoadAddress", 0, 256, 0);
        if (testInfo == null) {
            return new TPointer(mem, 0x8804000);
        }
        int lowestAddress = testInfo.addr;
        Modules.SysMemUserForUserModule.free(testInfo);
        return new TPointer(mem, lowestAddress);
    }

    public SceModule load(String pspfilename, ByteBuffer f, boolean fromSyscall, boolean isSignChecked) throws IOException, GeneralJpcspException {
        this.initNewPsp(fromSyscall);
        HLEModuleManager.getInstance().loadAvailableFlash0Modules(fromSyscall);
        TPointer loadAddress = this.getLoadAddress();
        this.module = Loader.getInstance().LoadModule(pspfilename, f, loadAddress, 2, 2, false, true, fromSyscall, isSignChecked);
        if ((this.module.fileFormat & 1) != 1) {
            throw new GeneralJpcspException("File format not supported!");
        }
        if (this.isBootModuleBad(this.module.modname)) {
            JpcspDialogManager.showError(null, ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("Emulator.strPrometheusLoader.text"));
        }
        this.moduleLoaded = true;
        this.initCpu(fromSyscall);
        if (State.debugger != null) {
            State.debugger.resetDebugger();
        }
        if (this.instructionCounter != null) {
            this.instructionCounter.setModule(this.module);
        }
        return this.module;
    }

    private void initCpu(boolean fromSyscall) {
        String discId;
        String string = discId = this.module.psf != null ? this.module.psf.getString("DISC_ID") : State.discId;
        if ("MSTKUPDATE".equals(discId)) {
            RuntimeContextLLE.createMMIO();
        }
        RuntimeContext.update();
        int entryAddr = this.module.entry_addr;
        if (Memory.isAddressGood(this.module.module_start_func) && this.module.module_start_func != entryAddr) {
            log.warn((Object)String.format("Using the module start function as module entry: 0x%08X instead of 0x%08X", this.module.module_start_func, entryAddr));
            entryAddr = this.module.module_start_func;
        }
        HLEModuleManager.getInstance().startModules(fromSyscall);
        Modules.ThreadManForUserModule.Initialise(this.module, entryAddr, this.module.attribute, this.module.pspfilename, this.module.modid, this.module.gp_value, fromSyscall);
        if (State.memoryViewer != null) {
            State.memoryViewer.RefreshMemory();
        }
    }

    public void initNewPsp(boolean fromSyscall) {
        this.moduleLoaded = false;
        Model.setModel(Settings.getInstance().readInt("emu.model"));
        Nand.init();
        HLEModuleManager.getInstance().stopModules();
        NIDMapper.getInstance().unloadAll();
        RuntimeContext.reset();
        if (!fromSyscall) {
            Profiler.reset();
            GEProfiler.reset();
            Emulator.getClock().reset();
        }
        Emulator.getProcessor().reset();
        Emulator.getScheduler().reset();
        Memory mem = Memory.getInstance();
        if (!fromSyscall) {
            mem.Initialise();
        } else {
            mem.memset(65536, (byte)0, 16384);
            mem.memset(0x8000000, (byte)0, MemoryMap.SIZE_RAM);
        }
        Battery.initialize();
        Wlan.initialize();
        SceUidManager.reset();
        HLEUidObjectMapping.reset();
        ProOnlineNetworkAdapter.init();
        if (State.fileLogger != null) {
            State.fileLogger.resetLogging();
        }
        MemorySections.getInstance().reset();
        HLEModuleManager.getInstance().init();
        Managers.reset();
        Modules.SysMemUserForUserModule.start();
        Modules.SysMemUserForUserModule.setFirmwareVersion(this.firmwareVersion);
        Modules.ThreadManForUserModule.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RuntimeContext.start();
        RuntimeContextLLE.start();
        GEProfiler.initialise();
        clock.resume();
        while (true) {
            if (pause) {
                clock.pause();
                try {
                    Emulator emulator = this;
                    synchronized (emulator) {
                        while (pause) {
                            this.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                clock.resume();
            }
            RuntimeContextLLE.run();
            if (RuntimeContext.isCompilerEnabled()) {
                RuntimeContext.run();
                continue;
            }
            processor.step();
            Modules.sceGe_userModule.step();
            Modules.ThreadManForUserModule.step();
            scheduler.step();
            Modules.sceDisplayModule.step();
            if (State.debugger == null) continue;
            State.debugger.step();
        }
    }

    public synchronized void RunEmu() {
        if (!this.moduleLoaded) {
            log.debug((Object)"Nothing loaded, can't run...");
            gui.RefreshButtons();
            return;
        }
        if (pause) {
            pause = false;
            this.notifyAll();
        } else if (!run) {
            run = true;
            this.mainThread.start();
        }
        Modules.sceDisplayModule.setGeDirty(true);
        gui.RefreshButtons();
        if (State.debugger != null) {
            State.debugger.RefreshButtons();
        }
    }

    private static void PauseEmu(boolean hasStatus, int status) {
        if (run && !pause) {
            pause = true;
            if (hasStatus) {
                StepLogger.setStatus(status);
            }
            gui.RefreshButtons();
            if (State.debugger != null) {
                State.debugger.RefreshButtons();
                State.debugger.SafeRefreshDebugger(true);
            }
            if (State.memoryViewer != null) {
                State.memoryViewer.SafeRefreshMemory();
            }
            if (State.imageViewer != null) {
                State.imageViewer.SafeRefreshImage();
            }
            StepLogger.flush();
        }
    }

    public static synchronized void PauseEmu() {
        Emulator.PauseEmu(false, 0);
    }

    public static synchronized void PauseEmuWithStatus(int status) {
        Emulator.PauseEmu(true, status);
    }

    public static void setFpsTitle(String fps) {
        gui.setMainTitle(fps);
    }

    public static Processor getProcessor() {
        return processor;
    }

    public static Processor setProcessor(Processor processor) {
        Processor previousProcessor = Emulator.processor;
        Emulator.processor = processor;
        return previousProcessor;
    }

    public static Memory getMemory() {
        return Memory.getInstance();
    }

    public static Memory getMemory(int address) {
        Memory mmio;
        if (!Memory.isAddressGood(address) && (mmio = RuntimeContextLLE.getMMIO()) != null) {
            return mmio;
        }
        return Emulator.getMemory();
    }

    public static Clock getClock() {
        return clock;
    }

    private static void setClock(Clock clock) {
        Emulator.clock = clock;
    }

    public static Scheduler getScheduler() {
        return scheduler;
    }

    public static IMainGUI getMainGUI() {
        return gui;
    }

    public static Emulator getInstance() {
        return instance;
    }

    public void setInstructionCounter(InstructionCounter instructionCounter) {
        this.instructionCounter = instructionCounter;
        instructionCounter.setModule(this.module);
    }

    public int getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(int firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
        Modules.SysMemUserForUserModule.setFirmwareVersion(this.firmwareVersion);
        RuntimeContext.setFirmwareVersion(firmwareVersion);
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.setFirmwareVersion(HLEModuleManager.psfFirmwareVersionToInt(firmwareVersion));
    }

    public static void setVariableSpeedClock(int numerator, int denominator) {
        if (Emulator.getClock() instanceof VariableSpeedClock) {
            ((VariableSpeedClock)Emulator.getClock()).setSpeed(numerator, denominator);
        } else if (numerator != 1 || denominator != 1) {
            VariableSpeedClock variableSpeedClock = new VariableSpeedClock(clock, numerator, denominator);
            Emulator.setClock(variableSpeedClock);
        }
    }

    public void setModuleLoaded(boolean moduleLoaded) {
        this.moduleLoaded = moduleLoaded;
    }

    public void onReboot() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Emulator onReboot", new Object[0]));
        }
        this.module = null;
        RuntimeContext.onReboot();
        reboot.resetThreadManInfo(processor);
    }

    static {
        run = false;
        pause = false;
        log = Logger.getLogger((String)"emu");
    }
}

