/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import jpcsp.HLE.Modules;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.HLE.modules.sceAtrac3plus;
import jpcsp.Memory;
import jpcsp.media.codec.CodecFactory;
import jpcsp.media.codec.ICodec;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;

public class UmdBrowserSound {
    private boolean done;
    private boolean threadExit;
    private Memory mem;
    private SysMemUserForUser.SysMemInfo memInfo;
    private int samplesAddr;
    private int inputAddr;
    private int inputLength;
    private int inputPosition;
    private int inputOffset;
    private int inputBytesPerFrame;
    private int channels;
    private ICodec codec;
    private SourceDataLine mLine;

    public UmdBrowserSound(Memory mem, byte[] data) {
        this.initMemory(mem);
        if (this.read(data)) {
            this.startThread();
        } else {
            this.threadExit = true;
        }
    }

    public UmdBrowserSound(Memory mem, IVirtualFile vFile, int codecType, sceAtrac3plus.AtracFileInfo atracFileInfo) {
        this.initMemory(mem);
        byte[] audioData = Utilities.readCompleteFile(vFile);
        int atracBytesPerFrame = ((audioData[2] & 3) << 8 | (audioData[3] & 0xFF) << 3) + 8;
        int headerLength = 8;
        this.inputLength = 0;
        for (int i = 0; i < audioData.length; i += headerLength + atracBytesPerFrame) {
            UmdBrowserSound.write(mem, this.inputAddr + this.inputLength, audioData, i + headerLength, atracBytesPerFrame);
            this.inputLength += atracBytesPerFrame;
        }
        atracFileInfo.atracBytesPerFrame = atracBytesPerFrame;
        if (this.read(codecType, atracFileInfo)) {
            this.startThread();
        } else {
            this.threadExit = true;
        }
    }

    private void initMemory(Memory mem) {
        this.mem = mem;
        this.memInfo = Modules.SysMemUserForUserModule.malloc(1, "UmdBrowserSound", 0, 131072, 0);
        if (this.memInfo != null) {
            this.samplesAddr = this.memInfo.addr;
            this.inputAddr = this.memInfo.addr + 65536;
        } else {
            this.samplesAddr = 0x8800000;
            this.inputAddr = 0x8810000;
        }
    }

    public void stopSound() {
        this.done = true;
        while (!this.threadExit) {
            Utilities.sleep(1, 0);
        }
        if (this.mLine != null) {
            this.mLine.close();
        }
        if (this.memInfo != null) {
            Modules.SysMemUserForUserModule.free(this.memInfo);
            this.memInfo = null;
            this.samplesAddr = 0;
            this.inputAddr = 0;
        }
    }

    private static void write(Memory mem, int addr, byte[] data, int offset, int length) {
        length = Math.min(length, data.length - offset);
        for (int i = 0; i < length; ++i) {
            mem.write8(addr + i, data[offset + i]);
        }
    }

    private void startThread() {
        SoundPlayThread soundPlayThread = new SoundPlayThread();
        soundPlayThread.setDaemon(true);
        soundPlayThread.setName("Umd Browser Sound Play Thread");
        soundPlayThread.start();
    }

    private boolean read(byte[] data) {
        if (data == null || data.length == 0) {
            return false;
        }
        this.inputLength = data.length;
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(this.inputAddr, this.inputLength, 1);
        for (int i = 0; i < data.length; ++i) {
            memoryWriter.writeNext(data[i] & 0xFF);
        }
        memoryWriter.flush();
        sceAtrac3plus.AtracFileInfo atracFileInfo = new sceAtrac3plus.AtracFileInfo();
        int codecType = sceAtrac3plus.analyzeRiffFile(this.mem, this.inputAddr, this.inputLength, atracFileInfo);
        if (codecType < 0) {
            return false;
        }
        boolean result = this.read(codecType, atracFileInfo);
        return result;
    }

    private boolean read(int codecType, sceAtrac3plus.AtracFileInfo atracFileInfo) {
        this.codec = CodecFactory.getCodec(codecType);
        if (this.codec == null) {
            return false;
        }
        int result = this.codec.init(atracFileInfo.atracBytesPerFrame, atracFileInfo.atracChannels, atracFileInfo.atracChannels, atracFileInfo.atracCodingMode);
        if (result < 0) {
            return false;
        }
        AudioFormat audioFormat = new AudioFormat(44100.0f, 16, atracFileInfo.atracChannels, true, false);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            this.mLine = (SourceDataLine)AudioSystem.getLine(info);
            this.mLine.open(audioFormat);
        }
        catch (LineUnavailableException e) {
            return false;
        }
        this.mLine.start();
        this.inputPosition = this.inputOffset = atracFileInfo.inputFileDataOffset;
        this.inputBytesPerFrame = atracFileInfo.atracBytesPerFrame;
        this.channels = atracFileInfo.atracChannels;
        return true;
    }

    private boolean stepSound() {
        int result;
        if (this.inputPosition + this.inputBytesPerFrame >= this.inputLength) {
            this.inputPosition = this.inputOffset;
        }
        if ((result = this.codec.decode(this.mem, this.inputAddr + this.inputPosition, this.inputBytesPerFrame, this.mem, this.samplesAddr)) < 0) {
            return false;
        }
        this.inputPosition += this.inputBytesPerFrame;
        byte[] bytes = new byte[this.codec.getNumberOfSamples() * 2 * this.channels];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)this.mem.read8(this.samplesAddr + i);
        }
        this.mLine.write(bytes, 0, bytes.length);
        return true;
    }

    private class SoundPlayThread
    extends Thread {
        private SoundPlayThread() {
        }

        @Override
        public void run() {
            while (!UmdBrowserSound.this.done) {
                UmdBrowserSound.this.stepSound();
            }
            UmdBrowserSound.this.threadExit = true;
        }
    }
}

