/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import com.twilight.h264.decoder.GetBitContext;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.sceUtility;
import jpcsp.MainGUI;
import jpcsp.Memory;
import jpcsp.State;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.format.RCO;
import jpcsp.format.psmf.PesHeader;
import jpcsp.format.rco.Display;
import jpcsp.format.rco.RCOState;
import jpcsp.format.rco.vsmx.objects.MoviePlayer;
import jpcsp.media.codec.CodecFactory;
import jpcsp.media.codec.ICodec;
import jpcsp.media.codec.IVideoCodec;
import jpcsp.media.codec.h264.H264Utils;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class UmdVideoPlayer
implements KeyListener {
    private static Logger log = Logger.getLogger((String)"videoplayer");
    private static final boolean dumpFrames = false;
    private String fileName;
    private UmdIsoReader iso;
    private UmdIsoFile isoFile;
    private List<MpsStreamInfo> mpsStreams;
    private int currentStreamIndex;
    private JLabel display;
    private Display rcoDisplay;
    private int screenWidth;
    private int screenHeigth;
    private Image image;
    private int resizeScaleFactor;
    private MainGUI gui;
    private IVideoCodec videoCodec;
    private boolean videoCodecInit;
    private int[] videoData = new int[65536];
    private int videoDataOffset;
    private int videoChannel = 0;
    public static int frame;
    private int videoWidth;
    private int videoHeight;
    private int videoAspectRatioNum;
    private int videoAspectRatioDen;
    private int[] luma;
    private int[] cr;
    private int[] cb;
    private int[] abgr;
    private boolean foundFrameStart;
    private int parseState;
    private int[] parseHistory = new int[6];
    private int parseHistoryCount;
    private int parseLastMb;
    private int nalLengthSize = 0;
    private boolean isAvc = false;
    private int lastParsePosition;
    private ICodec audioCodec;
    private boolean audioCodecInitialized;
    private int[] audioData = new int[65536];
    private int audioDataOffset;
    private int audioFrameLength;
    private int audioChannels;
    private final int[] frameHeader = new int[8];
    private int frameHeaderLength;
    private int audioChannel = 0;
    private int samplesAddr = 0x8800000;
    private int audioBufferAddr = 0x8810000;
    private byte[] audioBytes;
    private PesHeader pesHeaderAudio;
    private PesHeader pesHeaderVideo;
    private long currentVideoTimestamp;
    private int currentChapterNumber;
    private long startTime;
    private int fastForwardSpeed;
    private int fastRewindSpeed;
    private static final int[] fastForwardSpeeds;
    private static final int[] fastRewindSpeeds;
    private volatile boolean videoPaused;
    private volatile boolean done;
    private volatile boolean endOfVideo;
    private volatile boolean threadExit;
    private MpsDisplayThread displayThread;
    private SourceDataLine mLine;
    private Memory mem;
    private MoviePlayer moviePlayer;
    private RCOState rcoState;
    private DisplayControllerThread displayControllerThread;

    private static String getTimestampString(long timestamp) {
        int seconds = (int)(timestamp / 90000L);
        int hundredth = (int)(timestamp - (long)seconds * 90000L);
        hundredth = 100 * hundredth / 90000;
        int minutes = seconds / 60;
        seconds -= minutes * 60;
        int hours = minutes / 60;
        return String.format("%02d:%02d:%02d.%02d", hours, minutes -= hours * 60, seconds, hundredth);
    }

    public UmdVideoPlayer(MainGUI gui, UmdIsoReader iso) {
        this.iso = iso;
        this.display = new JLabel();
        this.rcoDisplay = new Display();
        JPanel panel = new JPanel();
        panel.setLayout(new OverlayLayout(panel));
        panel.add(this.rcoDisplay);
        panel.add(this.display);
        gui.remove((Component)Modules.sceDisplayModule.getCanvas());
        gui.getContentPane().add((Component)panel, "Center");
        gui.addKeyListener(this);
        this.setVideoPlayerResizeScaleFactor(gui, 1);
        this.init();
    }

    public void exit() {
        this.stopDisplayThread();
    }

    @Override
    public void keyPressed(KeyEvent event) {
        State.controller.keyPressed(event);
        if (this.moviePlayer != null) {
            int pushButton;
            if ((State.controller.getButtons() & 0x10) != 0) {
                this.moviePlayer.onUp();
            }
            if ((State.controller.getButtons() & 0x40) != 0) {
                this.moviePlayer.onDown();
            }
            if ((State.controller.getButtons() & 0x80) != 0) {
                this.moviePlayer.onLeft();
            }
            if ((State.controller.getButtons() & 0x20) != 0) {
                this.moviePlayer.onRight();
            }
            int n = pushButton = sceUtility.getSystemParamButtonPreference() == 1 ? 16384 : 8192;
            if ((State.controller.getButtons() & pushButton) != 0) {
                this.moviePlayer.onPush();
            }
            if ((State.controller.getButtons() & 0x200) != 0) {
                this.fastForward();
            }
            if ((State.controller.getButtons() & 0x100) != 0) {
                this.rewind();
            }
            if ((State.controller.getButtons() & 0x1000) != 0) {
                this.resumeVideo();
            }
        } else if (event.getKeyCode() == 39) {
            this.stopDisplayThread();
            this.goToNextMpsStream();
        } else if (event.getKeyCode() == 37 && this.currentStreamIndex > 0) {
            this.stopDisplayThread();
            this.goToPreviousMpsStream();
        } else if (event.getKeyCode() == 87 && !this.videoPaused) {
            this.pauseVideo();
        } else if (event.getKeyCode() == 83) {
            this.resumeVideo();
        } else if (event.getKeyCode() == 65) {
            this.rewind();
        } else if (event.getKeyCode() == 68) {
            this.fastForward();
        } else if (event.getKeyCode() == 38) {
            if (this.moviePlayer != null) {
                this.moviePlayer.onUp();
            }
        } else if (event.getKeyCode() == 40 && this.moviePlayer != null) {
            this.moviePlayer.onDown();
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
        State.controller.keyReleased(event);
    }

    @Override
    public void keyTyped(KeyEvent keyCode2) {
    }

    private void init() {
        Emulator.getScheduler().reset();
        Emulator.getClock().resume();
        this.mem = Emulator.getMemory();
        this.displayControllerThread = new DisplayControllerThread();
        this.displayControllerThread.setName("Display Controller Thread");
        this.displayControllerThread.setDaemon(true);
        this.displayControllerThread.start();
        this.done = false;
        this.threadExit = false;
        this.isoFile = null;
        this.mpsStreams = new LinkedList<MpsStreamInfo>();
        this.pauseVideo();
        this.currentStreamIndex = 0;
        this.parsePlaylistFile();
        this.parseRCO();
        if (this.videoPaused) {
            this.goToMpsStream(this.currentStreamIndex);
        }
    }

    public void setVideoPlayerResizeScaleFactor(MainGUI gui, int resizeScaleFactor) {
        this.resizeScaleFactor = resizeScaleFactor;
        this.gui = gui;
        this.resizeVideoPlayer();
    }

    private void resizeVideoPlayer() {
        if (this.videoWidth <= 0 || this.videoHeight <= 0) {
            this.screenWidth = 480 * this.resizeScaleFactor;
            this.screenHeigth = 272 * this.resizeScaleFactor;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("video size %dx%d resizeScaleFactor=%d", this.videoWidth, this.videoHeight, this.resizeScaleFactor));
            }
            this.screenWidth = this.videoWidth * this.videoAspectRatioNum / this.videoAspectRatioDen * this.resizeScaleFactor;
            this.screenHeigth = this.videoHeight * this.resizeScaleFactor;
        }
        this.gui.setDisplayMinimumSize(this.screenWidth, this.screenHeigth);
    }

    private int readByteHexTo10(UmdIsoFile file) throws IOException {
        int hex = file.readByte() & 0xFF;
        return (hex >> 4) * 10 + (hex & 0xF);
    }

    private void parsePlaylistFile() {
        try {
            UmdIsoFile file = this.iso.getFile("UMD_VIDEO/PLAYLIST.UMD");
            int umdvMagic = file.readInt();
            int umdvVersion = file.readInt();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Magic 0x%08X,  version 0x%08X", umdvMagic, umdvVersion));
            }
            int globalDataOffset = Utilities.endianSwap32(file.readInt());
            file.seek(globalDataOffset);
            int playListSize = Utilities.endianSwap32(file.readInt());
            int playListTracksNum = Utilities.endianSwap16(file.readShort());
            file.skipBytes(2);
            if (umdvMagic != 1447316821) {
                log.warn((Object)"Accessing invalid PLAYLIST.UMD file!");
            } else {
                log.info((Object)String.format("Accessing valid PLAYLIST.UMD file: playListSize=%d, playListTracksNum=%d", playListSize, playListTracksNum));
            }
            for (int i = 0; i < playListTracksNum; ++i) {
                MpsStreamMarkerInfo[] streamMarkers;
                file.skipBytes(2);
                file.skipBytes(2);
                file.skipBytes(2);
                file.skipBytes(30);
                file.skipBytes(2);
                int unknown = Utilities.endianSwap16(file.readShort());
                int releaseDateYear = this.readByteHexTo10(file) * 100 + this.readByteHexTo10(file);
                byte releaseDateDay = file.readByte();
                byte releaseDateMonth = file.readByte();
                file.skipBytes(4);
                file.skipBytes(4);
                int nameLength = file.readByte() & 0xFF;
                byte[] nameBuffer = new byte[nameLength];
                file.read(nameBuffer);
                String name = new String(nameBuffer);
                file.skipBytes(732 - nameLength);
                int streamHeight = file.readByte() * 16;
                file.skipBytes(2);
                file.skipBytes(4);
                file.skipBytes(1);
                int streamWidth = file.readByte() * 16;
                file.skipBytes(1);
                byte streamNameCharsNum = file.readByte();
                byte[] stringBuf = new byte[streamNameCharsNum];
                file.read(stringBuf);
                String streamName = new String(stringBuf);
                file.skipBytes(8 - streamNameCharsNum);
                file.skipBytes(2);
                int streamFirstTimestamp = Utilities.endianSwap32(file.readInt());
                file.skipBytes(2);
                int streamLastTimestamp = Utilities.endianSwap32(file.readInt());
                file.skipBytes(2);
                int streamMarkerDataLength = Utilities.endianSwap16(file.readShort());
                if (streamMarkerDataLength > 0) {
                    int streamMarkersNum = Utilities.endianSwap16(file.readShort());
                    streamMarkers = new MpsStreamMarkerInfo[streamMarkersNum];
                    for (int j = 0; j < streamMarkersNum; ++j) {
                        file.skipBytes(1);
                        byte streamMarkerCharsNum = file.readByte();
                        file.skipBytes(4);
                        long streamMarkerTimestamp = (long)Utilities.endianSwap32(file.readInt()) & 0xFFFFFFFFL;
                        file.skipBytes(2);
                        file.skipBytes(4);
                        byte[] markerBuf = new byte[streamMarkerCharsNum];
                        file.read(markerBuf);
                        String markerName = new String(markerBuf);
                        file.skipBytes(24 - streamMarkerCharsNum);
                        streamMarkers[j] = new MpsStreamMarkerInfo(markerName, streamMarkerTimestamp);
                    }
                    file.skip(2L);
                } else {
                    streamMarkers = new MpsStreamMarkerInfo[]{};
                }
                MpsStreamInfo info = new MpsStreamInfo(streamName, streamWidth, streamHeight, streamFirstTimestamp, streamLastTimestamp, streamMarkers, i + 1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Release date %d-%d-%d, name '%s', unknown=0x%04X", releaseDateYear, (int)releaseDateMonth, (int)releaseDateDay, name, unknown));
                    log.debug((Object)String.format("StreamInfo #%d: %s", i, info));
                }
                this.mpsStreams.add(info);
            }
        }
        catch (Exception e) {
            log.error((Object)"parsePlaylistFile", (Throwable)e);
        }
    }

    private void parseRCO() {
        try {
            String[] resources = this.iso.listDirectory("UMD_VIDEO/RESOURCE");
            if (resources == null || resources.length <= 0) {
                return;
            }
            int preferredLanguage = sceUtility.getSystemParamLanguage();
            String languagePrefix = "EN";
            switch (preferredLanguage) {
                case 0: {
                    languagePrefix = "JA";
                    break;
                }
                case 1: {
                    languagePrefix = "EN";
                    break;
                }
                case 2: {
                    languagePrefix = "FR";
                    break;
                }
                case 3: {
                    languagePrefix = "ES";
                    break;
                }
                case 4: {
                    languagePrefix = "DE";
                    break;
                }
                case 5: {
                    languagePrefix = "IT";
                    break;
                }
                case 6: {
                    languagePrefix = "NL";
                    break;
                }
                case 7: {
                    languagePrefix = "PO";
                    break;
                }
                case 8: {
                    languagePrefix = "RU";
                    break;
                }
                case 9: {
                    languagePrefix = "KO";
                    break;
                }
                case 10: {
                    languagePrefix = "CN";
                    break;
                }
                case 11: {
                    languagePrefix = "CN";
                }
            }
            String[] resourceNames = new String[]{"100000", "000000", "110000", "010000"};
            String resourceFileName = null;
            for (String resourceName : resourceNames) {
                String fileName = languagePrefix + resourceName + ".RCO";
                if (!this.iso.hasFile("UMD_VIDEO/RESOURCE/" + fileName)) continue;
                resourceFileName = fileName;
                break;
            }
            if (resourceFileName != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Reading RCO file '%s'", resourceFileName));
                }
                UmdIsoFile file = this.iso.getFile("UMD_VIDEO/RESOURCE/" + resourceFileName);
                byte[] buffer = new byte[(int)file.length()];
                file.read(buffer);
                RCO rco = new RCO(buffer);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("RCO: %s", rco));
                }
                this.rcoState = rco.execute(this, resourceFileName.replace(".RCO", ""));
            }
        }
        catch (FileNotFoundException resources) {
        }
        catch (IOException e) {
            log.error((Object)"parse RCO", (Throwable)e);
        }
    }

    public void changeResource(String resourceName) {
        try {
            UmdIsoFile file = this.iso.getFile(String.format("UMD_VIDEO/RESOURCE/%s.RCO", resourceName));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Reading RCO file '%s.RCO'", resourceName));
            }
            byte[] buffer = new byte[(int)file.length()];
            file.read(buffer);
            RCO rco = new RCO(buffer);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("RCO: %s", rco));
            }
            this.getRCODisplay().changeResource();
            this.rcoState = rco.execute(this.rcoState, this, resourceName);
        }
        catch (FileNotFoundException file) {
        }
        catch (IOException e) {
            log.error((Object)"changeResource", (Throwable)e);
        }
    }

    private int getStreamIndexFromPlayListNumber(int playListNumber) {
        for (int i = 0; i < this.mpsStreams.size(); ++i) {
            MpsStreamInfo info = this.mpsStreams.get(i);
            if (info.getPlayListNumber() != playListNumber) continue;
            return i;
        }
        return playListNumber;
    }

    public void setMoviePlayer(MoviePlayer moviePlayer) {
        this.moviePlayer = moviePlayer;
    }

    public void play(int playListNumber, int chapterNumber, int videoNumber, int audioNumber, int audioFlag, int subtitleNumber, int subtitleFlag) {
        this.done = false;
        int streamIndex = this.getStreamIndexFromPlayListNumber(playListNumber);
        this.goToMpsStream(streamIndex);
    }

    private boolean goToMpsStream(int streamIndex) {
        if (streamIndex < 0 || streamIndex >= this.mpsStreams.size()) {
            return false;
        }
        this.currentStreamIndex = streamIndex;
        MpsStreamInfo info = this.mpsStreams.get(this.currentStreamIndex);
        this.fileName = "UMD_VIDEO/STREAM/" + info.getName() + ".MPS";
        log.info((Object)("Loading stream: " + this.fileName));
        try {
            this.isoFile = this.iso.getFile(this.fileName);
            String cpiFileName = "UMD_VIDEO/CLIPINF/" + info.getName() + ".CLP";
            UmdIsoFile cpiFile = this.iso.getFile(cpiFileName);
            if (cpiFile != null) {
                log.info((Object)("Found CLIPINF data for this stream: " + cpiFileName));
            }
        }
        catch (FileNotFoundException cpiFileName) {
        }
        catch (IOException e) {
            Emulator.log.error((Object)e);
        }
        if (this.isoFile != null) {
            this.startVideo();
            this.initVideo();
        }
        return true;
    }

    private boolean goToNextMpsStream() {
        return this.goToMpsStream(this.currentStreamIndex + 1);
    }

    private boolean goToPreviousMpsStream() {
        return this.goToMpsStream(this.currentStreamIndex - 1);
    }

    public void initVideo() {
        this.done = false;
        this.videoPaused = false;
        if (this.displayThread == null) {
            this.displayThread = new MpsDisplayThread();
            this.displayThread.setDaemon(true);
            this.displayThread.setName("UMD Video Player Thread");
            this.displayThread.start();
        }
    }

    public void pauseVideo() {
        this.videoPaused = true;
    }

    public void resumeVideo() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Resume video", new Object[0]));
        }
        this.videoPaused = false;
        this.fastForwardSpeed = 0;
        this.fastRewindSpeed = 0;
    }

    public void fastForward() {
        if (this.fastRewindSpeed > 0) {
            --this.fastRewindSpeed;
        } else {
            this.fastForwardSpeed = Math.min(fastForwardSpeeds.length - 1, this.fastForwardSpeed + 1);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Fast forward %d, fast rewind %d", this.fastForwardSpeed, this.fastRewindSpeed));
        }
    }

    public void rewind() {
        if (this.fastForwardSpeed > 0) {
            --this.fastForwardSpeed;
        } else {
            this.fastRewindSpeed = Math.min(fastRewindSpeeds.length - 1, this.fastRewindSpeed + 1);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Fast forward %d, fast rewind %d", this.fastForwardSpeed, this.fastRewindSpeed));
        }
    }

    private int read8() {
        try {
            return this.isoFile.read();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    private int read16() {
        return this.read8() << 8 | this.read8();
    }

    private int read32() {
        return this.read8() << 24 | this.read8() << 16 | this.read8() << 8 | this.read8();
    }

    private void skip(int n) {
        if (n > 0) {
            try {
                this.isoFile.skip(n);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private long readPts(int c) {
        return (long)(c & 0xE) << 29 | (long)(this.read16() >> 1 << 15) | (long)(this.read16() >> 1);
    }

    private long readPts() {
        return this.readPts(this.read8());
    }

    private int readPesHeader(int startCode, PesHeader pesHeader) {
        int pesLength = 0;
        int c = this.read8();
        ++pesLength;
        while (c == 255) {
            c = this.read8();
            ++pesLength;
        }
        if ((c & 0xC0) == 64) {
            this.skip(1);
            c = this.read8();
            pesLength += 2;
        }
        pesHeader.setDtsPts(-1L);
        if ((c & 0xE0) == 32) {
            pesHeader.setDtsPts(this.readPts(c));
            pesLength += 4;
            if ((c & 0x10) != 0) {
                pesHeader.setPts(this.readPts());
                pesLength += 5;
            }
        } else if ((c & 0xC0) == 128) {
            int flags = this.read8();
            int headerLength = this.read8();
            pesLength += 2;
            pesLength += headerLength;
            if ((flags & 0x80) != 0) {
                pesHeader.setDtsPts(this.readPts());
                headerLength -= 5;
                if ((flags & 0x40) != 0) {
                    pesHeader.setDts(this.readPts());
                    headerLength -= 5;
                }
            }
            if ((flags & 0x3F) != 0 && headerLength == 0) {
                flags &= 0xC0;
            }
            if ((flags & 1) != 0) {
                int pesExt = this.read8();
                int skip = pesExt >> 4 & 0xB;
                skip += skip & 9;
                if ((pesExt & 0x40) != 0 || skip > --headerLength) {
                    skip = 0;
                    pesExt = 0;
                }
                this.skip(skip);
                headerLength -= skip;
                if ((pesExt & 1) != 0) {
                    int ext2Length = this.read8();
                    --headerLength;
                    if ((ext2Length & 0x7F) != 0) {
                        int idExt = this.read8();
                        --headerLength;
                        if ((idExt & 0x80) == 0) {
                            startCode = (startCode & 0xFF) << 8 | idExt;
                        }
                    }
                }
            }
            this.skip(headerLength);
        }
        if (startCode == 445) {
            int channel = this.read8();
            pesHeader.setChannel(channel);
            ++pesLength;
            if (channel >= 128 && channel <= 207) {
                this.skip(3);
                pesLength += 3;
                if (channel >= 176 && channel <= 191) {
                    this.skip(1);
                    ++pesLength;
                }
            } else {
                this.skip(3);
                pesLength += 3;
            }
        }
        return pesLength;
    }

    private byte[] resize(byte[] array, int size) {
        if (array == null) {
            return new byte[size];
        }
        if (size <= array.length) {
            return array;
        }
        byte[] newArray = new byte[size];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    private int[] resize(int[] array, int size) {
        if (array == null) {
            return new int[size];
        }
        if (size <= array.length) {
            return array;
        }
        int[] newArray = new int[size];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    private void addVideoData(int length, long position) {
        this.videoData = this.resize(this.videoData, this.videoDataOffset + length);
        for (int i = 0; i < length; ++i) {
            this.videoData[this.videoDataOffset++] = this.read8();
        }
    }

    private void addAudioData(int length) {
        this.audioData = this.resize(this.audioData, this.audioDataOffset + length);
        while (length > 0) {
            int currentFrameLength;
            int n = currentFrameLength = this.audioFrameLength == 0 ? 0 : this.audioDataOffset % this.audioFrameLength;
            if (currentFrameLength == 0) {
                while (this.frameHeaderLength < this.frameHeader.length && length > 0) {
                    this.frameHeader[this.frameHeaderLength++] = this.read8();
                    --length;
                }
                if (this.frameHeaderLength < this.frameHeader.length || length == 0) break;
                int frameHeader23 = this.frameHeader[2] << 8 | this.frameHeader[3];
                this.audioFrameLength = ((frameHeader23 & 0x3FF) << 3) + 8;
                if (this.frameHeader[0] != 15 || this.frameHeader[1] != 208) {
                    if (log.isInfoEnabled()) {
                        log.warn((Object)String.format("Audio frame length 0x%X with incorrect header (header: %02X %02X %02X %02X %02X %02X %02X %02X)", this.audioFrameLength, this.frameHeader[0], this.frameHeader[1], this.frameHeader[2], this.frameHeader[3], this.frameHeader[4], this.frameHeader[5], this.frameHeader[6], this.frameHeader[7]));
                    }
                } else if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Audio frame length 0x%X (header: %02X %02X %02X %02X %02X %02X %02X %02X)", this.audioFrameLength, this.frameHeader[0], this.frameHeader[1], this.frameHeader[2], this.frameHeader[3], this.frameHeader[4], this.frameHeader[5], this.frameHeader[6], this.frameHeader[7]));
                }
                this.frameHeaderLength = 0;
            }
            int lengthToNextFrame = this.audioFrameLength - currentFrameLength;
            int readLength = Utilities.min(length, lengthToNextFrame);
            for (int i = 0; i < readLength; ++i) {
                this.audioData[this.audioDataOffset++] = this.read8();
            }
            length -= readLength;
        }
    }

    private long getCurrentFilePosition() {
        try {
            return this.isoFile.getFilePointer();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    private boolean readPsmfPacket(int videoChannel, int audioChannel) {
        int startCode;
        while (!this.done && (startCode = this.read32()) != -1) {
            switch (startCode) {
                case 442: {
                    this.skip(10);
                    break;
                }
                case 443: {
                    this.skip(14);
                    break;
                }
                case 446: 
                case 447: {
                    int codeLength = this.read16();
                    this.skip(codeLength);
                    break;
                }
                case 445: {
                    int codeLength = this.read16();
                    int pesLength = this.readPesHeader(startCode, this.pesHeaderAudio);
                    codeLength -= pesLength;
                    if (this.pesHeaderAudio.getChannel() == audioChannel || audioChannel < 0) {
                        this.addAudioData(codeLength);
                        return true;
                    }
                    this.skip(codeLength);
                    break;
                }
                case 480: 
                case 481: 
                case 482: 
                case 483: 
                case 484: 
                case 485: 
                case 486: 
                case 487: 
                case 488: 
                case 489: 
                case 490: 
                case 491: 
                case 492: 
                case 493: 
                case 494: 
                case 495: {
                    int pesLength;
                    int codeLength = this.read16();
                    if (videoChannel < 0 || startCode - 480 == videoChannel) {
                        pesLength = this.readPesHeader(startCode, this.pesHeaderVideo);
                        this.addVideoData(codeLength -= pesLength, this.getCurrentFilePosition());
                        return true;
                    }
                    this.skip(codeLength);
                }
            }
        }
        return false;
    }

    private void consumeVideoData(int length) {
        if (length >= this.videoDataOffset) {
            this.videoDataOffset = 0;
            this.lastParsePosition = 0;
        } else {
            System.arraycopy(this.videoData, length, this.videoData, 0, this.videoDataOffset - length);
            this.videoDataOffset -= length;
            this.lastParsePosition -= length;
        }
    }

    private void consumeAudioData(int length) {
        if (length >= this.audioDataOffset) {
            this.audioDataOffset = 0;
        } else {
            System.arraycopy(this.audioData, length, this.audioData, 0, this.audioDataOffset - length);
            this.audioDataOffset -= length;
        }
    }

    private int startCodeFindCandidate(int offset, int size) {
        for (int i = 0; i < size; ++i) {
            if (this.videoData[offset + i] != 0) continue;
            return i;
        }
        return size;
    }

    private int findVideoFrameEnd() {
        if (this.parseState > 13) {
            this.parseState = 7;
        }
        if (this.lastParsePosition < 0) {
            this.lastParsePosition = 0;
        }
        int nextAvc = this.isAvc ? 0 : this.videoDataOffset;
        int found = -1;
        for (int i = this.lastParsePosition; i < this.videoDataOffset; ++i) {
            int mb;
            if (i >= nextAvc) {
                int nalSize = 0;
                i = nextAvc;
                for (int j = 0; j < this.nalLengthSize; ++j) {
                    nalSize = nalSize << 8 | this.videoData[i++];
                }
                if (nalSize <= 0 || nalSize > this.videoDataOffset - 1) {
                    return this.videoDataOffset;
                }
                nextAvc = i + this.nalLengthSize;
                this.parseState = 5;
            }
            if (this.parseState == 7) {
                if ((i += this.startCodeFindCandidate(i, nextAvc - i)) >= nextAvc) continue;
                this.parseState = 2;
                continue;
            }
            if (this.parseState <= 2) {
                if (this.videoData[i] == 1) {
                    this.parseState ^= 5;
                    continue;
                }
                if (this.videoData[i] != 0) {
                    this.parseState = 7;
                    continue;
                }
                this.parseState >>= 1;
                continue;
            }
            if (this.parseState <= 5) {
                int naluType = this.videoData[i] & 0x1F;
                if (naluType == 6 || naluType == 7 || naluType == 8 || naluType == 9) {
                    if (this.foundFrameStart) {
                        found = i + 1;
                        break;
                    }
                } else if (naluType == 1 || naluType == 2 || naluType == 5) {
                    this.parseState += 8;
                    continue;
                }
                this.parseState = 7;
                continue;
            }
            this.parseHistory[this.parseHistoryCount++] = this.videoData[i];
            if (this.parseHistoryCount <= 5) continue;
            int lastMb = this.parseLastMb;
            GetBitContext gb = new GetBitContext();
            gb.init_get_bits(this.parseHistory, 0, 8 * this.parseHistoryCount);
            this.parseHistoryCount = 0;
            this.parseLastMb = mb = gb.get_ue_golomb("UmdVideoPlayer.findVideoFrameEnd");
            if (this.foundFrameStart) {
                if (mb <= lastMb) {
                    found = i;
                    break;
                }
            } else {
                this.foundFrameStart = true;
            }
            this.parseState = 7;
        }
        if (found >= 0) {
            this.foundFrameStart = false;
            found -= this.parseState & 5;
            if (this.parseState > 7) {
                found -= 5;
            }
            this.parseState = 7;
            this.lastParsePosition = found;
        } else {
            this.lastParsePosition = this.videoDataOffset;
        }
        return found;
    }

    public boolean startVideo() {
        this.endOfVideo = false;
        this.videoPaused = false;
        this.videoCodec = CodecFactory.getVideoCodec();
        this.videoCodecInit = false;
        this.videoDataOffset = 0;
        this.videoWidth = 0;
        this.videoHeight = 0;
        this.audioCodec = CodecFactory.getCodec(4096);
        this.audioCodecInitialized = false;
        this.audioChannels = 2;
        this.audioDataOffset = 0;
        this.audioFrameLength = 0;
        this.frameHeaderLength = 0;
        this.foundFrameStart = false;
        this.pesHeaderAudio = new PesHeader(this.audioChannel);
        this.pesHeaderVideo = new PesHeader(this.videoChannel);
        this.startTime = System.currentTimeMillis();
        frame = 0;
        this.currentChapterNumber = -1;
        return true;
    }

    private void stopDisplayThread() {
        this.done = true;
        while (this.displayThread != null && !this.threadExit) {
            Utilities.sleep(1, 0);
        }
    }

    private void writeFile(int[] values, int size, String name) {
        try {
            FileOutputStream os = new FileOutputStream(name);
            byte[] bytes = new byte[size];
            for (int i = 0; i < size; ++i) {
                bytes[i] = (byte)values[i];
            }
            ((OutputStream)os).write(bytes);
            ((OutputStream)os).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void stepVideo() {
        int chapterNumber;
        int consumedLength;
        this.image = null;
        int frameSize = -1;
        do {
            if (!this.readPsmfPacket(this.videoChannel, this.audioChannel)) {
                if (this.videoDataOffset <= 0) break;
                frameSize = this.findVideoFrameEnd();
                if (frameSize >= 0) continue;
                frameSize = this.videoDataOffset;
                continue;
            }
            frameSize = this.findVideoFrameEnd();
        } while (frameSize <= 0 && !this.done);
        if (frameSize <= 0) {
            this.endOfVideo = true;
            return;
        }
        if (!this.videoCodecInit) {
            int[] extraData = null;
            int extraDataLength = H264Utils.findExtradata(this.videoData, 0, frameSize);
            if (extraDataLength > 0) {
                extraData = new int[extraDataLength];
                System.arraycopy(this.videoData, 0, extraData, 0, extraDataLength);
            }
            if (this.videoCodec.init(extraData) == 0) {
                this.videoCodecInit = true;
            } else {
                this.endOfVideo = true;
                return;
            }
        }
        if ((consumedLength = this.videoCodec.decode(this.videoData, 0, frameSize)) < 0) {
            this.endOfVideo = true;
            return;
        }
        if (this.videoCodec.hasImage()) {
            int[] aspectRatio = new int[2];
            this.videoCodec.getAspectRatio(aspectRatio);
            this.videoAspectRatioNum = aspectRatio[0];
            this.videoAspectRatioDen = aspectRatio[1];
            ++frame;
        }
        this.consumeVideoData(consumedLength);
        boolean skipFrame = false;
        if (frame % fastForwardSpeeds[this.fastForwardSpeed] != 0) {
            skipFrame = true;
            this.startTime -= 3003L;
        }
        if (this.videoCodec.hasImage() && !skipFrame) {
            int width = this.videoCodec.getImageWidth();
            int height = this.videoCodec.getImageHeight();
            boolean resized = false;
            if (this.videoWidth <= 0) {
                this.videoWidth = width;
                resized = true;
            }
            if (this.videoHeight <= 0) {
                this.videoHeight = height;
                resized = true;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Decoded video frame %dx%d (video %dx%d), pes=%s, SAR %d:%d", width, height, this.videoWidth, this.videoHeight, this.pesHeaderVideo, this.videoAspectRatioNum, this.videoAspectRatioDen));
            }
            if (resized) {
                this.resizeVideoPlayer();
            }
            int size = width * height;
            int size2 = size >> 2;
            this.luma = this.resize(this.luma, size);
            this.cr = this.resize(this.cr, size2);
            this.cb = this.resize(this.cb, size2);
            if (this.videoCodec.getImage(this.luma, this.cb, this.cr) == 0) {
                this.abgr = this.resize(this.abgr, size);
                H264Utils.YUV2ARGB(width, height, this.luma, this.cb, this.cr, this.abgr);
                this.image = this.display.createImage(new MemoryImageSource(this.videoWidth, this.videoHeight, this.abgr, 0, width));
                long now = System.currentTimeMillis();
                long currentDuration = now - this.startTime;
                long videoDuration = (long)frame * 100000L / 3003L;
                if (currentDuration < videoDuration) {
                    Utilities.sleep((int)(videoDuration - currentDuration), 0);
                }
            }
        }
        if (this.videoCodec.hasImage()) {
            this.currentVideoTimestamp = this.pesHeaderVideo.getPts() != -1L ? this.pesHeaderVideo.getPts() : (this.currentVideoTimestamp += 3003L);
            if (log.isTraceEnabled()) {
                MpsStreamInfo streamInfo = this.mpsStreams.get(this.currentStreamIndex);
                log.trace((Object)String.format("Playing stream %d: %s / %s", this.currentStreamIndex, UmdVideoPlayer.getTimestampString(this.currentVideoTimestamp - (long)streamInfo.streamFirstTimestamp), UmdVideoPlayer.getTimestampString(streamInfo.streamLastTimestamp - streamInfo.streamFirstTimestamp)));
            }
        }
        if (this.pesHeaderVideo.getPts() != -1L && (chapterNumber = this.mpsStreams.get(this.currentStreamIndex).getChapterNumber(this.pesHeaderVideo.getPts())) != this.currentChapterNumber) {
            if (this.moviePlayer != null) {
                this.moviePlayer.onChapter(chapterNumber + 1);
            }
            this.currentChapterNumber = chapterNumber;
        }
        if (this.audioFrameLength > 0 && this.audioDataOffset >= this.audioFrameLength) {
            if (!this.audioCodecInitialized) {
                this.audioCodec.init(this.audioFrameLength, this.audioChannels, this.audioChannels, 0);
                AudioFormat audioFormat = new AudioFormat(44100.0f, 16, this.audioChannels, true, false);
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                try {
                    this.mLine = (SourceDataLine)AudioSystem.getLine(info);
                    this.mLine.open(audioFormat);
                }
                catch (LineUnavailableException resized) {
                    // empty catch block
                }
                this.mLine.start();
                this.audioCodecInitialized = true;
            }
            int result = -1;
            if (this.fastForwardSpeed == 0) {
                IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(this.audioBufferAddr, this.audioFrameLength, 1);
                for (int i = 0; i < this.audioFrameLength; ++i) {
                    memoryWriter.writeNext(this.audioData[i]);
                }
                memoryWriter.flush();
                result = this.audioCodec.decode(this.mem, this.audioBufferAddr, this.audioFrameLength, this.mem, this.samplesAddr);
            }
            this.consumeAudioData(this.audioFrameLength);
            if (result > 0) {
                int audioBytesLength = this.audioCodec.getNumberOfSamples() * 2 * this.audioChannels;
                this.audioBytes = this.resize(this.audioBytes, audioBytesLength);
                IMemoryReader memoryReader = MemoryReader.getMemoryReader(this.samplesAddr, audioBytesLength, 1);
                for (int i = 0; i < audioBytesLength; ++i) {
                    this.audioBytes[i] = (byte)memoryReader.readNext();
                }
                this.mLine.write(this.audioBytes, 0, audioBytesLength);
            }
        }
    }

    public void takeScreenshot() {
        int tag = 0;
        String screenshotName = State.title + "-Shot-" + tag + ".png";
        File screenshot = new File(screenshotName);
        File directory = new File(System.getProperty("user.dir"));
        for (File file : directory.listFiles()) {
            if (!file.getName().contains(State.title + "-Shot")) continue;
            screenshotName = State.title + "-Shot-" + ++tag + ".png";
            screenshot = new File(screenshotName);
        }
        try {
            BufferedImage img = (BufferedImage)this.getImage();
            ImageIO.write((RenderedImage)img, "png", screenshot);
            img.flush();
        }
        catch (Exception e) {
            return;
        }
    }

    private Image getImage() {
        return this.image;
    }

    public Display getRCODisplay() {
        return this.rcoDisplay;
    }

    static {
        fastForwardSpeeds = new int[]{1, 50, 100, 200, 400};
        fastRewindSpeeds = new int[]{1, 50, 100, 200, 400};
    }

    private class MpsDisplayThread
    extends Thread {
        private MpsDisplayThread() {
        }

        @Override
        public void run() {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Starting Mps Display thread", new Object[0]));
            }
            UmdVideoPlayer.this.threadExit = false;
            while (!UmdVideoPlayer.this.done) {
                while (!UmdVideoPlayer.this.endOfVideo && !UmdVideoPlayer.this.done) {
                    if (!UmdVideoPlayer.this.videoPaused) {
                        UmdVideoPlayer.this.stepVideo();
                        if (UmdVideoPlayer.this.display == null || UmdVideoPlayer.this.image == null) continue;
                        Image scaledImage = UmdVideoPlayer.this.getImage();
                        if (UmdVideoPlayer.this.videoWidth != UmdVideoPlayer.this.screenWidth || UmdVideoPlayer.this.videoHeight != UmdVideoPlayer.this.screenHeigth) {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)String.format("Scaling video image from %dx%d to %dx%d", UmdVideoPlayer.this.videoWidth, UmdVideoPlayer.this.videoHeight, UmdVideoPlayer.this.screenWidth, UmdVideoPlayer.this.screenHeigth));
                            }
                            scaledImage = scaledImage.getScaledInstance(UmdVideoPlayer.this.screenWidth, UmdVideoPlayer.this.screenHeigth, 4);
                        }
                        UmdVideoPlayer.this.display.setIcon(new ImageIcon(scaledImage));
                        continue;
                    }
                    Utilities.sleep(10, 0);
                }
                if (UmdVideoPlayer.this.done) continue;
                if (UmdVideoPlayer.this.moviePlayer != null) {
                    UmdVideoPlayer.this.done = true;
                    UmdVideoPlayer.this.moviePlayer.onPlayListEnd(((MpsStreamInfo)UmdVideoPlayer.this.mpsStreams.get(UmdVideoPlayer.this.currentStreamIndex)).getPlayListNumber());
                    continue;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Switching to next stream", new Object[0]));
                }
                if (UmdVideoPlayer.this.goToNextMpsStream()) continue;
                UmdVideoPlayer.this.done = true;
            }
            UmdVideoPlayer.this.threadExit = true;
            UmdVideoPlayer.this.displayThread = null;
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Exiting Mps Display thread", new Object[0]));
            }
        }
    }

    private class DisplayControllerThread
    extends Thread {
        private volatile boolean done = false;

        private DisplayControllerThread() {
        }

        @Override
        public void run() {
            while (!this.done) {
                Emulator.getScheduler().step();
                State.controller.hleControllerPoll();
                Utilities.sleep(10, 0);
            }
        }
    }

    protected class MpsStreamMarkerInfo {
        private String streamMarkerName;
        private long streamMarkerTimestamp;

        public MpsStreamMarkerInfo(String name, long timestamp) {
            this.streamMarkerName = name;
            this.streamMarkerTimestamp = timestamp;
        }

        public String getName() {
            return this.streamMarkerName;
        }

        public long getTimestamp() {
            return this.streamMarkerTimestamp;
        }

        public String toString() {
            return String.format("'%s' %s(timeStamp=%d)", this.getName(), UmdVideoPlayer.getTimestampString(this.getTimestamp()), this.getTimestamp());
        }
    }

    protected class MpsStreamInfo {
        private String streamName;
        private int streamWidth;
        private int streamHeigth;
        private int streamFirstTimestamp;
        private int streamLastTimestamp;
        private MpsStreamMarkerInfo[] streamMarkers;
        private int playListNumber;

        public MpsStreamInfo(String name, int width, int heigth, int firstTimestamp, int lastTimestamp, MpsStreamMarkerInfo[] markers, int playListNumber) {
            this.streamName = name;
            this.streamWidth = width;
            this.streamHeigth = heigth;
            this.streamFirstTimestamp = firstTimestamp;
            this.streamLastTimestamp = lastTimestamp;
            this.streamMarkers = markers;
            this.playListNumber = playListNumber;
        }

        public String getName() {
            return this.streamName;
        }

        public int getWidth() {
            return this.streamWidth;
        }

        public int getHeigth() {
            return this.streamHeigth;
        }

        public int getFirstTimestamp() {
            return this.streamFirstTimestamp;
        }

        public int getLastTimestamp() {
            return this.streamLastTimestamp;
        }

        public MpsStreamMarkerInfo[] getMarkers() {
            return this.streamMarkers;
        }

        public int getPlayListNumber() {
            return this.playListNumber;
        }

        public int getChapterNumber(long timestamp) {
            int marker = -1;
            if (this.streamMarkers != null) {
                int i = 0;
                while (i < this.streamMarkers.length && this.streamMarkers[i].getTimestamp() <= timestamp) {
                    marker = i++;
                }
            }
            return marker;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(String.format("name='%s', %dx%d, %s(%d to %d), markers=[", this.getName(), this.getWidth(), this.getHeigth(), UmdVideoPlayer.getTimestampString(this.getLastTimestamp() - this.getFirstTimestamp()), this.getFirstTimestamp(), this.getLastTimestamp()));
            for (int i = 0; i < this.streamMarkers.length; ++i) {
                if (i > 0) {
                    s.append(", ");
                }
                s.append(this.streamMarkers[i]);
            }
            s.append("]");
            return s.toString();
        }
    }
}

