/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEModuleFunction;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.NIDMapper;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

@HLELogging
public class HLEModuleManager {
    private static Logger log = Modules.log;
    private static HLEModuleManager instance;
    private static final int STATE_VERSION = 0;
    public static final int HLESyscallNid = -1;
    public static final int InternalSyscallNid = -1;
    private boolean modulesStarted = false;
    private boolean startFromSyscall;
    private NIDMapper nidMapper;
    private HashMap<String, List<HLEModule>> flash0prxMap;
    private Set<HLEModule> installedModules = new HashSet<HLEModule>();
    private Map<Integer, HLEModuleFunction> syscallToFunction;
    private Map<Integer, HLEModuleFunction> nidToFunction;
    private Map<HLEModule, ModuleInfo> moduleInfos;
    private HLELogging defaultHLEFunctionLogging = HLEModuleManager.class.getAnnotation(HLELogging.class);
    private static final String[] moduleFileNamesToBeLoaded;
    private static final String[] moduleFileNamesVshOnly;
    private static final String[] moduleFileNamesLLE;

    public static HLEModuleManager getInstance() {
        if (instance == null) {
            instance = new HLEModuleManager();
        }
        return instance;
    }

    private HLEModuleManager() {
        this.nidMapper = NIDMapper.getInstance();
        this.syscallToFunction = new HashMap<Integer, HLEModuleFunction>();
        this.nidToFunction = new HashMap<Integer, HLEModuleFunction>();
    }

    public static int psfFirmwareVersionToInt(String firmwareVersion) {
        int version = Emulator.getInstance().getFirmwareVersion();
        if (firmwareVersion != null) {
            while (!Character.isDigit(firmwareVersion.charAt(firmwareVersion.length() - 1))) {
                firmwareVersion = firmwareVersion.substring(0, firmwareVersion.length() - 1);
            }
            version = (int)(Float.parseFloat(firmwareVersion) * 100.0f);
            if (version < 150) {
                version = 150;
            }
        }
        return version;
    }

    public void init() {
        this.installedModules.clear();
        this.installDefaultModules();
        this.initialiseFlash0PRXMap();
    }

    private void installDefaultModules() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Loading default HLE modules", new Object[0]));
        }
        for (ModuleInfo defaultModule : ModuleInfo.values()) {
            if (defaultModule.isLoadedByDefault()) {
                this.installModuleWithAnnotations(defaultModule.getModule());
                continue;
            }
            this.installModuleWithAnnotations(defaultModule.getModule());
            this.uninstallModuleWithAnnotations(defaultModule.getModule());
        }
    }

    private void addToFlash0PRXMap(String prxName, HLEModule module) {
        if (!this.flash0prxMap.containsKey(prxName = prxName.toLowerCase())) {
            this.flash0prxMap.put(prxName, new LinkedList());
        }
        List<HLEModule> modules = this.flash0prxMap.get(prxName);
        modules.add(module);
    }

    private void initialiseFlash0PRXMap() {
        this.flash0prxMap = new HashMap();
        this.moduleInfos = new HashMap<HLEModule, ModuleInfo>();
        for (ModuleInfo moduleInfo : ModuleInfo.values()) {
            HLEModule hleModule = moduleInfo.getModule();
            this.moduleInfos.put(hleModule, moduleInfo);
            if (moduleInfo.isLoadedByDefault()) continue;
            String[] names = moduleInfo.getNames();
            for (int i = 0; names != null && i < names.length; ++i) {
                this.addToFlash0PRXMap(names[i], hleModule);
            }
        }
    }

    public boolean hasFlash0Module(String prxname) {
        if (prxname == null) {
            return false;
        }
        return this.flash0prxMap.containsKey(prxname.toLowerCase());
    }

    public String getModulePrxFileName(String name) {
        List<HLEModule> modules;
        if (name != null && (modules = this.flash0prxMap.get(name.toLowerCase())) != null) {
            for (HLEModule module : modules) {
                ModuleInfo moduleInfo = this.moduleInfos.get(module);
                if (moduleInfo == null) continue;
                return moduleInfo.getPrxFileName();
            }
        }
        return null;
    }

    public int LoadFlash0Module(String name) {
        return this.LoadFlash0Module(name, 0, 0);
    }

    public int LoadFlash0Module(String name, int moduleVersion, int moduleElfVersion) {
        List<HLEModule> modules;
        if (name != null && (modules = this.flash0prxMap.get(name.toLowerCase())) != null) {
            for (HLEModule module : modules) {
                this.installModuleWithAnnotations(module);
                module.setModuleVersion(moduleVersion);
                module.setModuleElfVersion(moduleElfVersion);
            }
        }
        SceModule fakeModule = new SceModule(true);
        fakeModule.modname = name;
        fakeModule.moduleVersion = moduleVersion;
        fakeModule.version = moduleElfVersion;
        fakeModule.write(Memory.getInstance(), fakeModule.address);
        Managers.modules.addModule(fakeModule);
        return fakeModule.modid;
    }

    public void UnloadFlash0Module(SceModule sceModule) {
        List<HLEModule> prx;
        if (sceModule == null) {
            return;
        }
        if (sceModule.modname != null && (prx = this.flash0prxMap.get(sceModule.modname.toLowerCase())) != null) {
            for (HLEModule module : prx) {
                this.uninstallModuleWithAnnotations(module);
            }
        }
        sceModule.free();
        Managers.modules.removeModule(sceModule.modid);
        if (!sceModule.isFlashModule) {
            RuntimeContext.invalidateAll();
        }
    }

    public void addFunction(int nid, HLEModuleFunction func) {
        int syscallCode;
        if (nid == -1) {
            syscallCode = this.nidMapper.getNewSyscallNumber();
        } else {
            if (!this.nidMapper.addHLENid(nid, func.getFunctionName(), func.getModuleName(), func.getFirmwareVersion())) {
                log.error((Object)String.format("Tried to register a second handler for NID 0x%08X called %s", nid, func.getFunctionName()));
            }
            this.nidToFunction.put(nid, func);
            syscallCode = this.nidMapper.getSyscallByNid(nid, func.getModuleName());
        }
        if (syscallCode >= 0) {
            func.setSyscallCode(syscallCode);
            this.syscallToFunction.put(syscallCode, func);
            if (func.requiresJumpCall()) {
                SysMemUserForUser.SysMemInfo sysMemInfo = Modules.SysMemUserForUserModule.malloc(1, String.format("JumpCall-%s", func.getFunctionName()), 0, 8, 0);
                int jumpCallAddress = sysMemInfo.addr;
                int returnInstruction = 65011720;
                int syscallInstruction = 0xC | (syscallCode & 0xFFFFF) << 6;
                Memory mem = Emulator.getMemory(jumpCallAddress);
                mem.write32(jumpCallAddress + 0, returnInstruction);
                mem.write32(jumpCallAddress + 4, syscallInstruction);
                this.nidMapper.setNidAddress(func.getModuleName(), nid, jumpCallAddress);
            }
        }
    }

    public HLEModuleFunction getFunctionFromSyscallCode(int syscallCode) {
        return this.syscallToFunction.get(syscallCode);
    }

    public HLEModuleFunction getFunctionFromAddress(int address) {
        Memory mem;
        int nid = this.nidMapper.getNidByAddress(address);
        if (nid == 0 && Memory.isAddressGood(address) && (mem = Memory.getInstance()).internalRead32(address) >>> 26 == 2 && mem.internalRead32(address + 4) == ThreadManForUser.NOP()) {
            int jumpAddress = (mem.internalRead32(address) & 0x3FFFFFF) << 2;
            nid = this.nidMapper.getNidByAddress(jumpAddress);
        }
        if (nid == 0) {
            return null;
        }
        HLEModuleFunction func = this.nidToFunction.get(nid);
        return func;
    }

    public HLEModuleFunction getFunctionFromNID(int nid) {
        return this.nidToFunction.get(nid);
    }

    public int getNIDFromFunctionName(String functionName) {
        for (HLEModuleFunction function : this.nidToFunction.values()) {
            if (!functionName.equals(function.getFunctionName())) continue;
            return function.getNid();
        }
        return 0;
    }

    public void removeFunction(HLEModuleFunction func) {
        this.nidMapper.unloadNid(func.getNid());
    }

    public void startModules(boolean startFromSyscall) {
        if (this.modulesStarted) {
            return;
        }
        this.startFromSyscall = startFromSyscall;
        for (ModuleInfo defaultModule : ModuleInfo.values()) {
            if (defaultModule.module.isStarted()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Module %s already started", defaultModule.module.getName()));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Starting module %s", defaultModule.module.getName()));
            }
            defaultModule.module.start();
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)String.format("Started module %s", defaultModule.module.getName()));
        }
        this.startFromSyscall = false;
        this.modulesStarted = true;
    }

    public void stopModules() {
        if (!this.modulesStarted) {
            return;
        }
        for (ModuleInfo defaultModule : ModuleInfo.values()) {
            defaultModule.module.stop();
        }
        this.modulesStarted = false;
    }

    public boolean isStartFromSyscall() {
        return this.startFromSyscall;
    }

    private void installFunctionWithAnnotations(HLEFunction hleFunction, Method method, HLEModule hleModule) {
        HLEUnimplemented hleUnimplemented = method.getAnnotation(HLEUnimplemented.class);
        HLELogging hleLogging = method.getAnnotation(HLELogging.class);
        if (hleLogging == null) {
            HLELogging hleModuleLogging;
            hleLogging = hleUnimplemented != null ? HLEUnimplemented.class.getAnnotation(HLELogging.class) : ((hleModuleLogging = method.getDeclaringClass().getAnnotation(HLELogging.class)) != null ? hleModuleLogging : this.defaultHLEFunctionLogging);
        }
        String moduleName = hleFunction.moduleName();
        String functionName = hleFunction.functionName();
        if (moduleName.length() == 0) {
            moduleName = hleModule.getName();
        }
        if (functionName.length() == 0) {
            functionName = method.getName();
        }
        HLEModuleFunction hleModuleFunction = new HLEModuleFunction(moduleName, functionName, hleFunction.nid(), hleModule, method, hleFunction.checkInsideInterrupt(), hleFunction.checkDispatchThreadEnabled(), hleFunction.stackUsage(), hleFunction.version(), hleFunction.jumpCall(), hleFunction.canModifyCode());
        if (hleUnimplemented != null) {
            hleModuleFunction.setUnimplemented(true);
        }
        if (hleLogging != null) {
            hleModuleFunction.setLoggingLevel(hleLogging.level());
        }
        hleModule.installedHLEModuleFunctions.put(functionName, hleModuleFunction);
        this.addFunction(hleFunction.nid(), hleModuleFunction);
    }

    public void installModuleWithAnnotations(HLEModule hleModule) {
        if (this.installedModules.contains(hleModule)) {
            return;
        }
        try {
            for (Method method : hleModule.getClass().getMethods()) {
                HLEFunction[] hleFunctions;
                for (HLEFunction hleFunction : hleFunctions = (HLEFunction[])method.getAnnotationsByType(HLEFunction.class)) {
                    this.installFunctionWithAnnotations(hleFunction, method, hleModule);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"installModuleWithAnnotations", (Throwable)e);
        }
        this.installedModules.add(hleModule);
        hleModule.load();
    }

    public void uninstallModuleWithAnnotations(HLEModule hleModule) {
        try {
            for (HLEModuleFunction hleModuleFunction : hleModule.installedHLEModuleFunctions.values()) {
                this.removeFunction(hleModuleFunction);
            }
        }
        catch (Exception e) {
            log.error((Object)"uninstallModuleWithAnnotations", (Throwable)e);
        }
        this.installedModules.remove(hleModule);
        hleModule.unload();
    }

    private boolean isModuleFileNameVshOnly(String moduleFileName) {
        for (int i = 0; i < moduleFileNamesVshOnly.length; ++i) {
            if (!moduleFileNamesVshOnly[i].equalsIgnoreCase(moduleFileName)) continue;
            return true;
        }
        return false;
    }

    public void loadAvailableFlash0Modules(boolean fromSyscall) {
        boolean runningFromVsh = Emulator.getMainGUI().isRunningFromVsh() && !fromSyscall;
        LinkedList<String> availableModuleFileNames = new LinkedList<String>();
        for (String moduleFileName : moduleFileNamesToBeLoaded) {
            String[] localFileName;
            IVirtualFileSystem vfs;
            if (!runningFromVsh && this.isModuleFileNameVshOnly(moduleFileName) || (vfs = Modules.IoFileMgrForUserModule.getVirtualFileSystem(moduleFileName, (StringBuilder)(localFileName = new StringBuilder()))) == null || vfs.ioGetstat(localFileName.toString(), new SceIoStat()) != 0) continue;
            availableModuleFileNames.add(moduleFileName);
        }
        if (availableModuleFileNames.isEmpty()) {
            return;
        }
        Modules.ModuleMgrForUserModule.start();
        int startPriority = 16;
        for (String moduleFileName : availableModuleFileNames) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Loading and starting the module '%s', it will replace the equivalent HLE functions", moduleFileName));
            }
            boolean requiresLLE = false;
            for (String moduleFileNameLLE : moduleFileNamesLLE) {
                if (!moduleFileName.equals(moduleFileNameLLE)) continue;
                requiresLLE = true;
                break;
            }
            if (requiresLLE && !RuntimeContextLLE.isLLEActive()) {
                RuntimeContextLLE.enableLLE();
                RuntimeContextLLE.start();
            }
            IAction onModuleStartAction = null;
            if ("flash0:/kd/loadcore.prx".equals(moduleFileName)) {
                onModuleStartAction = Modules.LoadCoreForKernelModule.getModuleStartAction();
            }
            Modules.ModuleMgrForUserModule.hleKernelLoadAndStartModule(moduleFileName, startPriority++, onModuleStartAction);
        }
    }

    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        for (ModuleInfo moduleInfo : ModuleInfo.values()) {
            HLEModule hleModule = moduleInfo.getModule();
            hleModule.read(stream);
        }
    }

    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        for (ModuleInfo moduleInfo : ModuleInfo.values()) {
            HLEModule hleModule = moduleInfo.getModule();
            hleModule.write(stream);
        }
    }

    static {
        moduleFileNamesToBeLoaded = new String[]{"flash0:/kd/utility.prx", "flash0:/kd/vshbridge.prx", "flash0:/vsh/module/paf.prx", "flash0:/vsh/module/common_gui.prx", "flash0:/vsh/module/common_util.prx"};
        moduleFileNamesVshOnly = new String[]{"flash0:/kd/vshbridge.prx", "flash0:/vsh/module/paf.prx", "flash0:/vsh/module/common_gui.prx", "flash0:/vsh/module/common_util.prx"};
        moduleFileNamesLLE = new String[]{"flash0:/kd/lowio.prx", "flash0:/kd/audio.prx"};
    }

    private static enum ModuleInfo {
        SysMemUserForUser(Modules.SysMemUserForUserModule),
        IoFileMgrForUser(Modules.IoFileMgrForUserModule),
        IoFileMgrForKernel(Modules.IoFileMgrForKernelModule),
        ThreadManForUser(Modules.ThreadManForUserModule),
        ThreadManForKernel(Modules.ThreadManForKernelModule),
        SysMemForKernel(Modules.SysMemForKernelModule),
        InterruptManager(Modules.InterruptManagerModule),
        LoadExecForUser(Modules.LoadExecForUserModule),
        LoadExecForKernel(Modules.LoadExecForKernelModule),
        StdioForUser(Modules.StdioForUserModule),
        StdioForKernel(Modules.StdioForKernelModule),
        sceUmdUser(Modules.sceUmdUserModule),
        scePower(Modules.scePowerModule),
        sceUtility(Modules.sceUtilityModule),
        UtilsForUser(Modules.UtilsForUserModule),
        sceDisplay(Modules.sceDisplayModule),
        sceGe_user(Modules.sceGe_userModule),
        sceRtc(Modules.sceRtcModule),
        KernelLibrary(Modules.Kernel_LibraryModule),
        ModuleMgrForUser(Modules.ModuleMgrForUserModule),
        LoadCoreForKernel(Modules.LoadCoreForKernelModule),
        sceCtrl(Modules.sceCtrlModule),
        sceAudio(Modules.sceAudioModule),
        sceImpose(Modules.sceImposeModule),
        sceSuspendForUser(Modules.sceSuspendForUserModule),
        sceSuspendForKernel(Modules.sceSuspendForKernelModule),
        sceDmac(Modules.sceDmacModule),
        sceHprm(Modules.sceHprmModule),
        sceAtrac3plus(Modules.sceAtrac3plusModule, new String[]{"libatrac3plus", "PSP_AV_MODULE_ATRAC3PLUS", "PSP_MODULE_AV_ATRAC3PLUS", "sceATRAC3plus_Library"}, "flash0:/kd/libatrac3plus.prx"),
        sceSasCore(Modules.sceSasCoreModule, new String[]{"sc_sascore", "PSP_AV_MODULE_SASCORE", "PSP_MODULE_AV_SASCORE", "sceSAScore"}, "flash0:/kd/sc_sascore.prx"),
        sceMpeg(Modules.sceMpegModule, new String[]{"mpeg", "PSP_AV_MODULE_MPEGBASE", "PSP_MODULE_AV_MPEGBASE", "sceMpeg_library"}, "flash0:/kd/mpeg.prx"),
        sceMpegVsh(Modules.sceMpegModule, new String[]{"mpeg_vsh", "mpeg_vsh370"}, "flash0:/kd/mpeg_vsh.prx"),
        sceMpegbase(Modules.sceMpegbaseModule, new String[]{"PSP_AV_MODULE_AVCODEC", "PSP_MODULE_AV_AVCODEC", "avcodec", "sceMpegbase_Driver"}, "flash0:/kd/avcodec.prx"),
        sceFont(Modules.sceFontModule, new String[]{"libfont", "sceFont_Library"}),
        scePsmfPlayer(Modules.scePsmfPlayerModule, new String[]{"libpsmfplayer", "psmf_jk", "scePsmfP_library"}),
        scePsmf(Modules.scePsmfModule, new String[]{"psmf", "scePsmf_library"}),
        sceMp3(Modules.sceMp3Module, new String[]{"PSP_AV_MODULE_MP3", "PSP_MODULE_AV_MP3", "LIBMP3"}),
        sceDeflt(Modules.sceDefltModule, new String[]{"libdeflt", "sceDEFLATE_Library"}),
        sceWlan(Modules.sceWlanModule),
        sceNet(Modules.sceNetModule, new String[]{"pspnet", "PSP_NET_MODULE_COMMON", "PSP_MODULE_NET_COMMON"}, "flash0:/kd/pspnet.prx"),
        sceNetAdhoc(Modules.sceNetAdhocModule, new String[]{"pspnet_adhoc", "PSP_NET_MODULE_ADHOC", "PSP_MODULE_NET_ADHOC"}, "flash0:/kd/pspnet_adhoc.prx"),
        sceNetAdhocctl(Modules.sceNetAdhocctlModule, new String[]{"pspnet_adhocctl", "PSP_NET_MODULE_ADHOC", "PSP_MODULE_NET_ADHOC"}, "flash0:/kd/pspnet_adhocctl.prx"),
        sceNetAdhocDiscover(Modules.sceNetAdhocDiscoverModule, new String[]{"pspnet_adhoc_discover", "PSP_NET_MODULE_ADHOC", "PSP_MODULE_NET_ADHOC"}, "flash0:/kd/pspnet_adhoc_discover.prx"),
        sceNetAdhocMatching(Modules.sceNetAdhocMatchingModule, new String[]{"pspnet_adhoc_matching", "PSP_NET_MODULE_ADHOC", "PSP_MODULE_NET_ADHOC"}, "flash0:/kd/pspnet_adhoc_matching.prx"),
        sceNetAdhocTransInt(Modules.sceNetAdhocTransIntModule, new String[]{"pspnet_adhoc_transfer_int"}, "flash0:/kd/pspnet_adhoc_transfer_int.prx"),
        sceNetAdhocAuth(Modules.sceNetAdhocAuthModule, new String[]{"pspnet_adhoc_auth", "sceNetAdhocAuth_Service"}, "flash0:/kd/pspnet_adhoc_auth.prx"),
        sceNetAdhocDownload(Modules.sceNetAdhocDownloadModule, new String[]{"pspnet_adhoc_download"}, "flash0:/kd/pspnet_adhoc_download.prx"),
        sceNetIfhandle(Modules.sceNetIfhandleModule, new String[]{"ifhandle", "PSP_NET_MODULE_COMMON", "PSP_MODULE_NET_COMMON", "sceNetIfhandle_Service"}, "flash0:/kd/ifhandle.prx"),
        sceNetApctl(Modules.sceNetApctlModule, new String[]{"pspnet_apctl", "PSP_NET_MODULE_COMMON", "PSP_MODULE_NET_COMMON"}, "flash0:/kd/pspnet_apctl.prx"),
        sceNetInet(Modules.sceNetInetModule, new String[]{"pspnet_inet", "PSP_NET_MODULE_INET", "PSP_MODULE_NET_INET"}, "flash0:/kd/pspnet_inet.prx"),
        sceNetResolver(Modules.sceNetResolverModule, new String[]{"pspnet_resolver", "PSP_NET_MODULE_COMMON", "PSP_MODULE_NET_COMMON"}, "flash0:/kd/pspnet_resolver.prx"),
        sceNetUpnp(Modules.sceNetUpnpModule, new String[]{"pspnet_upnp", "PSP_MODULE_NET_UPNP"}, "flash0:/kd/pspnet_upnp.prx"),
        sceOpenPSID(Modules.sceOpenPSIDModule),
        sceNp(Modules.sceNpModule, new String[]{"np", "PSP_MODULE_NP_COMMON"}, "flash0:/kd/np.prx"),
        sceNpCore(Modules.sceNpCoreModule, new String[]{"np_core"}, "flash0:/kd/np_core.prx"),
        sceNpAuth(Modules.sceNpAuthModule, new String[]{"np_auth", "PSP_MODULE_NP_COMMON"}, "flash0:/kd/np_auth.prx"),
        sceNpService(Modules.sceNpServiceModule, new String[]{"np_service", "PSP_MODULE_NP_SERVICE"}, "flash0:/kd/np_service.prx"),
        sceNpCommerce2(Modules.sceNpCommerce2Module, new String[]{"np_commerce2", "PSP_MODULE_NP_COMMERCE2"}, "flash0:/kd/np_commerce2.prx"),
        sceNpCommerce2Store(Modules.sceNpCommerce2StoreModule, new String[]{"np_commerce2_store"}, "flash0:/kd/np_commerce2_store.prx"),
        sceNpCommerce2RegCam(Modules.sceNpCommerce2RegCamModule, new String[]{"np_commerce2_regcam"}, "flash0:/kd/np_commerce2_regcam.prx"),
        sceNpMatching2(Modules.sceNpMatching2Module, new String[]{"np_matching2", "PSP_MODULE_NP_MATCHING2"}, "flash0:/kd/np_matching2.prx"),
        sceNpInstall(Modules.sceNpInstallModule, new String[]{"np_inst"}, "flash0:/kd/np_inst.prx"),
        sceNpCamp(Modules.sceNpCampModule, new String[]{"np_campaign"}, "flash0:/kd/np_campaign.prx"),
        scePspNpDrm_user(Modules.scePspNpDrm_userModule, new String[]{"PSP_MODULE_NP_DRM", "npdrm"}),
        sceVaudio(Modules.sceVaudioModule, new String[]{"PSP_AV_MODULE_VAUDIO", "PSP_MODULE_AV_VAUDIO"}),
        sceMp4(Modules.sceMp4Module, new String[]{"PSP_MODULE_AV_MP4", "libmp4"}, "flash0:/kd/libmp4.prx"),
        mp4msv(Modules.mp4msvModule, new String[]{"mp4msv"}, "flash0:/kd/mp4msv.prx"),
        sceHttp(Modules.sceHttpModule, new String[]{"libhttp", "libhttp_rfc", "PSP_NET_MODULE_HTTP", "PSP_MODULE_NET_HTTP"}, "flash0:/kd/libhttp.prx"),
        sceHttps(Modules.sceHttpsModule, new String[]{"libhttp", "libhttp_rfc", "PSP_NET_MODULE_HTTP", "PSP_MODULE_NET_HTTP"}, "flash0:/kd/libhttp.prx"),
        sceHttpStorage(Modules.sceHttpStorageModule, new String[]{"http_storage", "PSP_MODULE_NET_HTTPSTORAGE"}, "flash0:/kd/http_storage.prx"),
        sceSsl(Modules.sceSslModule, new String[]{"libssl", "PSP_NET_MODULE_SSL", "PSP_MODULE_NET_SSL"}, "flash0:/kd/libssl.prx"),
        sceP3da(Modules.sceP3daModule),
        sceGameUpdate(Modules.sceGameUpdateModule, new String[]{"libgameupdate"}),
        sceUsbCam(Modules.sceUsbCamModule, new String[]{"PSP_USB_MODULE_CAM", "PSP_MODULE_USB_CAM", "usbcam"}),
        sceJpeg(Modules.sceJpegModule, new String[]{"PSP_AV_MODULE_AVCODEC", "PSP_MODULE_AV_AVCODEC"}, "flash0:/kd/avcodec.prx"),
        sceUsb(Modules.sceUsbModule),
        sceHeap(Modules.sceHeapModule, new String[]{"libheap", "sceHeap_Library"}),
        KDebugForKernel(Modules.KDebugForKernelModule),
        sceCcc(Modules.sceCccModule, new String[]{"libccc", "sceCcc_Library"}),
        scePauth(Modules.scePauthModule),
        sceSfmt19937(Modules.sceSfmt19937Module, new String[]{"libsfmt19937", "sceSfmt19937_Library"}),
        sceMd5(Modules.sceMd5Module, new String[]{"libmd5"}),
        sceParseUri(Modules.sceParseUriModule, new String[]{"libparse_uri", "libhttp_rfc", "PSP_NET_MODULE_HTTP", "PSP_MODULE_NET_HTTP", "PSP_MODULE_NET_PARSEURI"}, "flash0:/kd/libparse_uri.prx"),
        sceUsbAcc(Modules.sceUsbAccModule, new String[]{"PSP_USB_MODULE_ACC", "USBAccBaseDriver"}),
        sceMt19937(Modules.sceMt19937Module, new String[]{"libmt19937"}),
        sceAac(Modules.sceAacModule, new String[]{"libaac", "PSP_AV_MODULE_AAC", "PSP_MODULE_AV_AAC"}),
        sceFpu(Modules.sceFpuModule, new String[]{"libfpu"}),
        sceUsbMic(Modules.sceUsbMicModule, new String[]{"usbmic", "PSP_USB_MODULE_MIC", "PSP_MODULE_USB_MIC", "USBCamMicDriver"}),
        sceAudioRouting(Modules.sceAudioRoutingModule),
        sceUsbGps(Modules.sceUsbGpsModule, new String[]{"PSP_USB_MODULE_GPS", "PSP_MODULE_USB_GPS", "usbgps"}),
        sceAudiocodec(Modules.sceAudiocodecModule, new String[]{"PSP_AV_MODULE_AVCODEC", "PSP_MODULE_AV_AVCODEC", "avcodec", "sceAudiocodec_Driver"}, "flash0:/kd/avcodec.prx"),
        sceVideocodec(Modules.sceVideocodecModule, new String[]{"PSP_AV_MODULE_AVCODEC", "PSP_MODULE_AV_AVCODEC", "avcodec", "sceVideocodec_Driver"}, "flash0:/kd/avcodec.prx"),
        sceAdler(Modules.sceAdlerModule, new String[]{"libadler"}),
        sceSha1(Modules.sceSha1Module, new String[]{"libsha1"}),
        sceSha256(Modules.sceSha256Module, new String[]{"libsha256"}),
        sceMeCore(Modules.sceMeCoreModule),
        sceMeBoot(Modules.sceMeBootModule),
        KUBridge(Modules.KUBridgeModule),
        SysclibForKernel(Modules.SysclibForKernelModule),
        semaphore(Modules.semaphoreModule),
        ModuleMgrForKernel(Modules.ModuleMgrForKernelModule),
        sceReg(Modules.sceRegModule),
        sceDve(Modules.sceDveModule),
        sceSysEventForKernel(Modules.sceSysEventForKernelModule),
        sceChkreg(Modules.sceChkregModule),
        sceMsAudio_Service(Modules.sceMsAudio_ServiceModule),
        sceMePower(Modules.sceMePowerModule),
        sceResmgr(Modules.sceResmgrModule),
        UtilsForKernel(Modules.UtilsForKernelModule),
        sceLibUpdateDL(Modules.sceLibUpdateDLModule, new String[]{"libupdown"}),
        sceParseHttp(Modules.sceParseHttpModule, new String[]{"libparse_http", "PSP_MODULE_NET_PARSEHTTP"}, "flash0:/kd/libparse_http.prx"),
        sceMgr_driver(Modules.sceMgr_driverModule),
        sceChnnlsv(Modules.sceChnnlsvModule, new String[]{"chnnlsv"}),
        sceUsbstor(Modules.sceUsbstorModule),
        sceIdStorage(Modules.sceIdStorageModule),
        sceCertLoader(Modules.sceCertLoaderModule, new String[]{"cert_loader", "PSP_MODULE_NET_SSL"}, "flash0:/kd/cert_loader.prx"),
        sceDNAS(Modules.sceDNASModule, new String[]{"libdnas"}),
        sceDNASCore(Modules.sceDNASCoreModule, new String[]{"libdnas_core"}),
        sceMcctrl(Modules.sceMcctrlModule, new String[]{"mcctrl"}),
        sceNetStun(Modules.sceNetStunModule),
        sceMeMemory(Modules.sceMeMemoryModule),
        sceMeVideo(Modules.sceMeVideoModule),
        sceMeAudio(Modules.sceMeAudioModule),
        InitForKernel(Modules.InitForKernelModule),
        sceMemab(Modules.sceMemabModule, new String[]{"memab", "sceMemab"}),
        DmacManForKernel(Modules.DmacManForKernelModule),
        sceSyscon(Modules.sceSysconModule),
        sceLed(Modules.sceLedModule),
        sceSysreg(Modules.sceSysregModule),
        scePsheet(Modules.scePsheetModule),
        sceUmdMan(Modules.sceUmdManModule),
        sceCodepage(Modules.sceCodepageModule),
        sceMSstor(Modules.sceMSstorModule),
        sceAta(Modules.sceAtaModule),
        sceGpio(Modules.sceGpioModule),
        sceNand(Modules.sceNandModule),
        sceBSMan(Modules.sceBSManModule),
        memlmd(Modules.memlmdModule),
        reboot(Modules.rebootModule),
        sceI2c(Modules.sceI2cModule),
        scePwm(Modules.scePwmModule),
        sceLcdc(Modules.sceLcdcModule),
        sceDmacplus(Modules.sceDmacplusModule),
        sceDdr(Modules.sceDdrModule),
        sceMScm(Modules.sceMScmModule),
        sceG729(Modules.sceG729Module, new String[]{"PSP_MODULE_AV_G729", "g729"}, "flash0:/kd/g729.prx"),
        scePopsMan(Modules.scePopsManModule),
        scePaf(Modules.scePafModule),
        sceClockgen(Modules.sceClockgenModule),
        sceCodec(Modules.sceCodecModule),
        sceMesgd(Modules.sceMesgdModule),
        sceVshBridge(Modules.sceVshBridgeModule),
        SystemCtrlForKernel(Modules.SystemCtrlForKernelModule),
        sceHibari(Modules.sceHibariModule),
        sceSystimer(Modules.sceSystimerModule),
        sceUsbBus(Modules.sceUsbBusModule),
        sceUsbHost(Modules.sceUsbHostModule),
        sceEFlash(Modules.sceEFlashModule);

        private HLEModule module;
        private boolean loadedByDefault;
        private String[] names;
        private String prxFileName;

        private ModuleInfo(HLEModule module) {
            this.module = module;
            this.loadedByDefault = true;
            this.names = null;
        }

        private ModuleInfo(HLEModule module, String[] prxNames) {
            this.module = module;
            this.loadedByDefault = false;
            this.names = prxNames;
        }

        private ModuleInfo(HLEModule module, String[] prxNames, String prxFileName) {
            this.module = module;
            this.loadedByDefault = false;
            this.names = prxNames;
            this.prxFileName = prxFileName;
        }

        public HLEModule getModule() {
            return this.module;
        }

        public String[] getNames() {
            return this.names;
        }

        public boolean isLoadedByDefault() {
            return this.loadedByDefault;
        }

        public String getPrxFileName() {
            return this.prxFileName;
        }
    }
}

