/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS;

import java.io.IOException;
import java.util.Map;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractVirtualFileSystem;
import jpcsp.HLE.VFS.IVirtualCache;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.modules.IoFileMgrForUser;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public abstract class AbstractProxyVirtualFile
implements IVirtualFile,
IVirtualCache,
IState {
    protected static Logger log = AbstractVirtualFileSystem.log;
    protected IVirtualFile vFile;

    protected AbstractProxyVirtualFile() {
    }

    protected AbstractProxyVirtualFile(IVirtualFile vFile) {
        this.vFile = vFile;
    }

    protected void setProxyVirtualFile(IVirtualFile vFile) {
        this.vFile = vFile;
    }

    @Override
    public int ioClose() {
        return this.vFile.ioClose();
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        return this.vFile.ioRead(outputPointer, outputLength);
    }

    protected int ioReadBuf(TPointer outputPointer, int outputLength) {
        if (outputLength <= 0) {
            return 0;
        }
        byte[] outputBuffer = new byte[outputLength];
        int readLength = this.ioRead(outputBuffer, 0, outputLength);
        if (readLength > 0) {
            outputPointer.setArray(outputBuffer, readLength);
        }
        return readLength;
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        return this.vFile.ioRead(outputBuffer, outputOffset, outputLength);
    }

    @Override
    public int ioWrite(TPointer inputPointer, int inputLength) {
        return this.vFile.ioWrite(inputPointer, inputLength);
    }

    @Override
    public int ioWrite(byte[] inputBuffer, int inputOffset, int inputLength) {
        return this.vFile.ioWrite(inputBuffer, inputOffset, inputLength);
    }

    @Override
    public long ioLseek(long offset) {
        return this.vFile.ioLseek(offset);
    }

    @Override
    public int ioIoctl(int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        return this.vFile.ioIoctl(command, inputPointer, inputLength, outputPointer, outputLength);
    }

    @Override
    public long length() {
        return this.vFile.length();
    }

    @Override
    public boolean isSectorBlockMode() {
        return this.vFile.isSectorBlockMode();
    }

    @Override
    public long getPosition() {
        return this.vFile.getPosition();
    }

    @Override
    public IVirtualFile duplicate() {
        return this.vFile.duplicate();
    }

    @Override
    public Map<IoFileMgrForUser.IoOperation, IoFileMgrForUser.IoOperationTiming> getTimings() {
        return this.vFile.getTimings();
    }

    @Override
    public void invalidateCachedData() {
        if (this.vFile instanceof IVirtualCache) {
            ((IVirtualCache)((Object)this.vFile)).invalidateCachedData();
        }
    }

    @Override
    public void closeCachedFiles() {
        if (this.vFile instanceof IVirtualCache) {
            ((IVirtualCache)((Object)this.vFile)).closeCachedFiles();
        }
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        if (this.vFile instanceof IState) {
            ((IState)((Object)this.vFile)).read(stream);
        }
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        if (this.vFile instanceof IState) {
            ((IState)((Object)this.vFile)).write(stream);
        }
    }

    public String toString() {
        return String.format("ProxyVirtualFile %s", this.vFile);
    }
}

