/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.modules.IoFileMgrForUser;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;

public class NullVirtualFile
implements IVirtualFile,
IState {
    private static final int STATE_VERSION = 0;
    private long size;
    private long position;

    public NullVirtualFile(long size) {
        this.size = size;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.size = stream.readLong();
        this.position = stream.readLong();
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeLong(this.size);
        stream.writeLong(this.position);
    }

    @Override
    public int ioClose() {
        return 0;
    }

    private int getMaxOutputLength(int outputLength) {
        if (outputLength <= 0) {
            return 0;
        }
        if (this.position + (long)outputLength > this.size) {
            return (int)(this.size - this.position);
        }
        return outputLength;
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        outputLength = this.getMaxOutputLength(outputLength);
        outputPointer.clear(outputLength);
        this.position += (long)outputLength;
        return outputLength;
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        outputLength = this.getMaxOutputLength(outputLength);
        Arrays.fill(outputBuffer, outputOffset, outputOffset + outputLength, (byte)0);
        this.position += (long)outputLength;
        return outputLength;
    }

    @Override
    public int ioWrite(TPointer inputPointer, int inputLength) {
        return -1;
    }

    @Override
    public int ioWrite(byte[] inputBuffer, int inputOffset, int inputLength) {
        return -1;
    }

    @Override
    public long ioLseek(long offset) {
        if (offset < 0L || offset > this.size) {
            return -1L;
        }
        this.position = offset;
        return offset;
    }

    @Override
    public int ioIoctl(int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        return -1;
    }

    @Override
    public long length() {
        return this.size;
    }

    @Override
    public boolean isSectorBlockMode() {
        return false;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public IVirtualFile duplicate() {
        return null;
    }

    @Override
    public Map<IoFileMgrForUser.IoOperation, IoFileMgrForUser.IoOperationTiming> getTimings() {
        return null;
    }
}

