/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.fat;

import java.util.List;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.VFS.fat.FatFileInfo;
import jpcsp.HLE.VFS.fat.FatUtils;
import jpcsp.HLE.VFS.fat.FatVirtualFile;
import jpcsp.HLE.kernel.types.SceIoDirent;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class FatBuilder {
    private static Logger log = FatVirtualFile.log;
    public static final int bootSectorNumber = 0;
    public static final int numberOfFats = 2;
    public static final int reservedSectors = 32;
    public static final int directoryTableEntrySize = 32;
    private final FatVirtualFile vFile;
    private final IVirtualFileSystem vfs;
    private final int maxNumberClusters;
    private int firstFreeCluster;

    public FatBuilder(FatVirtualFile vFile, IVirtualFileSystem vfs, int maxNumberClusters) {
        this.vFile = vFile;
        this.vfs = vfs;
        this.maxNumberClusters = maxNumberClusters;
    }

    public FatFileInfo scan(String deviceName) {
        this.firstFreeCluster = this.vFile.getFirstFreeCluster();
        FatFileInfo rootDirectory = new FatFileInfo(this.vFile.getDeviceName(), null, null, true, false, null, 0L);
        rootDirectory.setParentDirectory(rootDirectory);
        this.scan(null, rootDirectory);
        this.vFile.setRootDirectory(rootDirectory);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s: Using 0x%X clusters out of 0x%X", deviceName, this.firstFreeCluster, this.maxNumberClusters));
            this.debugScan(rootDirectory);
        }
        if (this.firstFreeCluster > this.maxNumberClusters) {
            log.error((Object)String.format("Too many files in the Fat partition '%s': required clusters=0x%X, max clusters=0x%X", deviceName, this.firstFreeCluster, this.maxNumberClusters));
        }
        return rootDirectory;
    }

    private void debugScan(FatFileInfo fileInfo) {
        log.debug((Object)String.format("scan %s", fileInfo));
        List<FatFileInfo> children = fileInfo.getChildren();
        if (children != null) {
            for (FatFileInfo child : children) {
                this.debugScan(child);
            }
        }
    }

    public void setClusters(FatFileInfo fileInfo, int[] clusters) {
        if (clusters != null) {
            for (int i = 0; i < clusters.length; ++i) {
                this.vFile.setFatFileInfoMap(clusters[i], fileInfo);
            }
        }
        fileInfo.setClusters(clusters);
    }

    private int allocateCluster() {
        return this.firstFreeCluster++;
    }

    private int[] allocateClusters(long size) {
        int i;
        int clusterSize = this.vFile.getClusterSize();
        int numberClusters = (int)((size + (long)clusterSize - 1L) / (long)clusterSize);
        if (numberClusters <= 0) {
            return null;
        }
        int[] clusters = new int[numberClusters];
        for (i = 0; i < numberClusters; ++i) {
            clusters[i] = this.allocateCluster();
        }
        for (i = 0; i < numberClusters - 1; ++i) {
            this.vFile.setFatClusterMap(clusters[i], clusters[i + 1]);
        }
        if (numberClusters > 0) {
            this.vFile.setFatClusterMap(clusters[numberClusters - 1], this.vFile.getFatEOC());
        }
        return clusters;
    }

    private void allocateClusters(FatFileInfo fileInfo) {
        long dataSize = fileInfo.getFileSize();
        if (fileInfo.isDirectory()) {
            int directoryTableEntries = 2;
            List<FatFileInfo> children = fileInfo.getChildren();
            if (children != null) {
                directoryTableEntries += children.size();
            }
            dataSize = 32 * directoryTableEntries;
        }
        int[] clusters = this.allocateClusters(dataSize);
        this.setClusters(fileInfo, clusters);
    }

    private void scan(String dirName, FatFileInfo parent) {
        String[] names = this.vfs.ioDopen(dirName);
        if (names == null || names.length == 0) {
            return;
        }
        SceIoStat stat = new SceIoStat();
        SceIoDirent dir = new SceIoDirent(stat, null);
        for (int i = 0; i < names.length; ++i) {
            if (".".equals(names[i]) || "..".equals(names[i])) continue;
            dir.filename = names[i];
            if (this.vfs.ioDread(dirName, dir) < 0) continue;
            boolean directory = (dir.stat.attr & 0x10) != 0;
            boolean readOnly = (dir.stat.mode & 2) == 0;
            FatFileInfo fileInfo = new FatFileInfo(this.vFile.getDeviceName(), dirName, dir.filename, directory, readOnly, dir.stat.mtime, dir.stat.size);
            parent.addChild(fileInfo);
            if (directory) {
                if (dirName == null) {
                    this.scan(dir.filename, fileInfo);
                } else {
                    this.scan(dirName + "/" + dir.filename, fileInfo);
                }
            }
            this.allocateClusters(fileInfo);
        }
        List<FatFileInfo> children = parent.getChildren();
        if (children != null) {
            for (FatFileInfo child : children) {
                this.computeFileName83(child, children);
            }
        }
    }

    private void computeFileName83(FatFileInfo fileInfo, List<FatFileInfo> siblings) {
        boolean hasCollision;
        int collisionIndex = 0;
        String fileName = fileInfo.getFileName();
        String fileName83 = FatBuilder.convertFileNameTo83(fileName, collisionIndex);
        block0: do {
            hasCollision = false;
            for (FatFileInfo sibling : siblings) {
                String siblingFileName83 = sibling.getFileName83();
                if (siblingFileName83 == null || !fileName83.equals(siblingFileName83)) continue;
                hasCollision = true;
                fileName83 = FatBuilder.convertFileNameTo83(fileName, ++collisionIndex);
                continue block0;
            }
        } while (hasCollision);
        fileInfo.setFileName83(fileName83);
    }

    public static String convertFileName8_3To83(String fileName8_3) {
        String name = fileName8_3;
        String extension = "";
        int dotIndex = name.indexOf(46);
        if (dotIndex >= 0) {
            extension = name.substring(dotIndex + 1);
            name = name.substring(0, dotIndex);
        }
        name = (name + "        ").substring(0, 8);
        extension = (extension + "   ").substring(0, 3);
        return name + extension;
    }

    private static String convertFileNameTo8_3(String fileName, int collisionIndex) {
        String ext;
        String name;
        if (fileName == null) {
            return null;
        }
        fileName = fileName.replace("+", "_");
        int lastDot = (fileName = fileName.toUpperCase()).lastIndexOf(".");
        if (lastDot < 0) {
            name = fileName;
            ext = "";
        } else {
            name = fileName.substring(0, lastDot);
            ext = fileName.substring(lastDot + 1);
        }
        name = name.replace(".", "");
        if (ext.length() > 3) {
            ext = ext.substring(0, 3);
        }
        if (collisionIndex >= 1) {
            if (collisionIndex <= 4) {
                if (name.length() > 6) {
                    name = name.substring(0, 6);
                }
                name = name + "~" + collisionIndex;
            } else {
                if (name.length() > 2) {
                    name = name.substring(0, 2);
                }
                name = name + String.format("%04X", collisionIndex) + "~1";
            }
        } else if (name.length() > 8) {
            name = name.substring(0, 6) + "~1";
        }
        if (ext.length() == 0) {
            return name;
        }
        return name + "." + ext;
    }

    private static String convertFileNameTo83(String fileName, int collisionIndex) {
        String fileName8_3 = FatBuilder.convertFileNameTo8_3(fileName, collisionIndex);
        return FatBuilder.convertFileName8_3To83(fileName8_3);
    }

    private static String convertFileName83To8_3(String fileName83) {
        int endExt;
        int endName;
        for (endName = 8; endName > 0 && fileName83.charAt(endName - 1) == ' '; --endName) {
        }
        String name = fileName83.substring(0, endName);
        for (endExt = 11; endExt > 8 && fileName83.charAt(endExt - 1) == ' '; --endExt) {
        }
        String ext = fileName83.substring(8, endExt);
        if (ext.length() == 0) {
            return name;
        }
        return name + "." + ext;
    }

    private byte[] addLongFileNameDirectoryEntries(byte[] directoryData, String fileName, int fileNameChecksum) {
        byte[] fileNameBytes = fileName.getBytes(pspAbstractMemoryMappedStructure.charset16);
        int numberEntries = Math.max((fileNameBytes.length + 25) / 26, 1);
        byte[] extend = new byte[numberEntries * 26 - fileNameBytes.length];
        if (extend.length >= 2) {
            extend[0] = 0;
            extend[1] = 0;
            for (int i = 2; i < extend.length; ++i) {
                extend[i] = -1;
            }
            fileNameBytes = Utilities.extendArray(fileNameBytes, extend);
        }
        int offset = directoryData.length;
        directoryData = Utilities.extendArray(directoryData, 32 * numberEntries);
        for (int i = numberEntries; i > 0; --i) {
            int sequenceNumber = i;
            if (i == numberEntries) {
                sequenceNumber |= 0x40;
            }
            FatUtils.storeSectorInt8(directoryData, offset + 0, sequenceNumber);
            int fileNameBytesOffset = (i - 1) * 26;
            System.arraycopy(fileNameBytes, fileNameBytesOffset, directoryData, offset + 1, 10);
            FatUtils.storeSectorInt8(directoryData, offset + 11, 15);
            FatUtils.storeSectorInt8(directoryData, offset + 12, 0);
            FatUtils.storeSectorInt8(directoryData, offset + 13, fileNameChecksum);
            System.arraycopy(fileNameBytes, fileNameBytesOffset += 10, directoryData, offset + 14, 12);
            FatUtils.storeSectorInt16(directoryData, offset + 26, 0);
            System.arraycopy(fileNameBytes, fileNameBytesOffset += 12, directoryData, offset + 28, 4);
            offset += 32;
        }
        return directoryData;
    }

    private int getFileNameChecksum(String fileName) {
        int checksum = 0;
        for (int i = 0; i < fileName.length(); ++i) {
            int c = fileName.charAt(i) & 0xFF;
            checksum = ((checksum & 1) << 7) + (checksum >> 1) + c & 0xFF;
        }
        return checksum;
    }

    private boolean isLongFileName(String fileName8_3, String fileName) {
        return !fileName8_3.equalsIgnoreCase(fileName);
    }

    private byte[] addDirectoryEntry(byte[] directoryData, FatFileInfo fileInfo) {
        String fileName = fileInfo.getFileName();
        String fileName83 = fileInfo.getFileName83();
        String fileName8_3 = FatBuilder.convertFileName83To8_3(fileName83);
        if (this.isLongFileName(fileName8_3, fileName)) {
            int checksum = this.getFileNameChecksum(fileName83);
            directoryData = this.addLongFileNameDirectoryEntries(directoryData, fileName, checksum);
        }
        int offset = directoryData.length;
        directoryData = Utilities.extendArray(directoryData, 32);
        FatUtils.storeSectorString(directoryData, offset + 0, fileName83, 11);
        int fileAttributes = 32;
        if (fileInfo.isReadOnly()) {
            fileAttributes |= 1;
        }
        if (fileInfo.isDirectory()) {
            fileAttributes |= 0x10;
        }
        FatUtils.storeSectorInt8(directoryData, offset + 11, fileAttributes);
        FatUtils.storeSectorInt8(directoryData, offset + 12, 0);
        ScePspDateTime lastModified = fileInfo.getLastModified();
        FatUtils.storeSectorInt8(directoryData, offset + 13, 0);
        int createTime = lastModified.hour << 11;
        createTime |= lastModified.minute << 5;
        FatUtils.storeSectorInt16(directoryData, offset + 14, createTime |= lastModified.second >> 1);
        int createDate = lastModified.year - 1980 << 9;
        createDate |= lastModified.month << 5;
        FatUtils.storeSectorInt16(directoryData, offset + 16, createDate |= lastModified.day);
        FatUtils.storeSectorInt16(directoryData, offset + 18, createDate);
        int[] clusters = fileInfo.getClusters();
        if (clusters != null) {
            FatUtils.storeSectorInt16(directoryData, offset + 20, clusters[0] >>> 16);
        } else {
            FatUtils.storeSectorInt16(directoryData, offset + 20, 0);
        }
        FatUtils.storeSectorInt16(directoryData, offset + 22, createTime);
        FatUtils.storeSectorInt16(directoryData, offset + 24, createDate);
        if (clusters != null) {
            FatUtils.storeSectorInt16(directoryData, offset + 26, clusters[0] & 0xFFFF);
        } else {
            FatUtils.storeSectorInt16(directoryData, offset + 26, 0);
        }
        int fileSize = (int)fileInfo.getFileSize();
        if (fileInfo.isDirectory()) {
            fileSize = 0;
        }
        FatUtils.storeSectorInt32(directoryData, offset + 28, fileSize);
        return directoryData;
    }

    private void buildDotDirectoryEntry(byte[] directoryData, int offset, FatFileInfo fileInfo, String dotName, ScePspDateTime alternateLastModified) {
        FatUtils.storeSectorString(directoryData, offset + 0, dotName, 11);
        FatUtils.storeSectorInt8(directoryData, offset + 11, 16);
        FatUtils.storeSectorInt8(directoryData, offset + 12, 0);
        ScePspDateTime lastModified = fileInfo.getLastModified();
        if (lastModified == null) {
            lastModified = alternateLastModified;
        }
        FatUtils.storeSectorInt8(directoryData, offset + 13, 0);
        int createTime = lastModified.hour << 11;
        createTime |= lastModified.minute << 5;
        FatUtils.storeSectorInt16(directoryData, offset + 14, createTime |= lastModified.second >> 1);
        int createDate = lastModified.year - 1980 << 9;
        createDate |= lastModified.month << 5;
        FatUtils.storeSectorInt16(directoryData, offset + 16, createDate |= lastModified.day);
        FatUtils.storeSectorInt16(directoryData, offset + 18, createDate);
        int[] clusters = fileInfo.getClusters();
        if (clusters != null) {
            FatUtils.storeSectorInt16(directoryData, offset + 20, clusters[0] >>> 16);
        } else {
            FatUtils.storeSectorInt16(directoryData, offset + 20, 0);
        }
        FatUtils.storeSectorInt16(directoryData, offset + 22, createTime);
        FatUtils.storeSectorInt16(directoryData, offset + 24, createDate);
        if (clusters != null) {
            FatUtils.storeSectorInt16(directoryData, offset + 26, clusters[0] & 0xFFFF);
        } else {
            FatUtils.storeSectorInt16(directoryData, offset + 26, 0);
        }
        FatUtils.storeSectorInt32(directoryData, offset + 28, 0);
    }

    public byte[] buildDirectoryData(FatFileInfo fileInfo) {
        byte[] directoryData;
        if (fileInfo.isRootDirectory()) {
            directoryData = new byte[]{};
        } else {
            directoryData = new byte[64];
            this.buildDotDirectoryEntry(directoryData, 0, fileInfo, ".", fileInfo.getLastModified());
            this.buildDotDirectoryEntry(directoryData, 32, fileInfo.getParentDirectory(), "..", fileInfo.getLastModified());
        }
        List<FatFileInfo> children = fileInfo.getChildren();
        if (children != null) {
            for (FatFileInfo child : children) {
                directoryData = this.addDirectoryEntry(directoryData, child);
            }
        }
        return directoryData;
    }
}

