/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.fat;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.VFS.fat.FatVirtualFile;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public class FatFileInfo {
    private static final int STATE_VERSION = 0;
    private String deviceName;
    private String dirName;
    private String fileName;
    private String fileName83;
    private boolean directory;
    private boolean readOnly;
    private ScePspDateTime lastModified;
    private long fileSize;
    private int[] clusters;
    private List<FatFileInfo> children;
    private IVirtualFile vFile;
    private boolean vFileOpen;
    private byte[] fileData;
    private FatFileInfo parentDirectory;

    public FatFileInfo() {
    }

    public FatFileInfo(String deviceName, String dirName, String fileName, boolean directory, boolean readOnly, ScePspDateTime lastModified, long fileSize) {
        this.deviceName = deviceName;
        this.dirName = dirName;
        this.fileName = fileName;
        this.directory = directory;
        this.readOnly = readOnly;
        this.lastModified = lastModified;
        this.fileSize = fileSize;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFullFileName() {
        if (this.dirName == null) {
            return this.fileName;
        }
        return this.dirName + '/' + this.fileName;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public ScePspDateTime getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(ScePspDateTime lastModified) {
        this.lastModified = lastModified;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public int[] getClusters() {
        return this.clusters;
    }

    public void setClusters(int[] clusters) {
        this.clusters = clusters;
    }

    public void addChild(FatFileInfo fileInfo) {
        if (this.children == null) {
            this.children = new LinkedList<FatFileInfo>();
        }
        this.children.add(fileInfo);
        fileInfo.setParentDirectory(this);
    }

    public List<FatFileInfo> getChildren() {
        return this.children;
    }

    public IVirtualFile getVirtualFile(IVirtualFileSystem vfs) {
        if (!this.vFileOpen) {
            this.vFile = vfs.ioOpen(this.getFullFileName(), 3, 0);
            this.vFileOpen = true;
        }
        return this.vFile;
    }

    public void closeVirtualFile() {
        if (this.vFileOpen) {
            if (this.vFile != null) {
                this.vFile.ioClose();
                this.vFile = null;
            }
            this.vFileOpen = false;
        }
    }

    public byte[] getFileData() {
        return this.fileData;
    }

    public void setFileData(byte[] fileData) {
        this.fileData = fileData;
    }

    public FatFileInfo getParentDirectory() {
        return this.parentDirectory;
    }

    public void setParentDirectory(FatFileInfo parentDirectory) {
        this.parentDirectory = parentDirectory;
    }

    public boolean isRootDirectory() {
        return this.isDirectory() && this.dirName == null && this.fileName == null;
    }

    public String getFileName83() {
        return this.fileName83;
    }

    public void setFileName83(String fileName83) {
        this.fileName83 = fileName83;
    }

    public FatFileInfo getChildByFileName83(String fileName83) {
        if (this.children != null) {
            for (FatFileInfo child : this.children) {
                String childFileName83 = child.getFileName83();
                if (childFileName83 == null || !fileName83.equals(childFileName83)) continue;
                return child;
            }
        }
        return null;
    }

    public boolean hasCluster(int cluster) {
        if (this.clusters != null) {
            for (int i = 0; i < this.clusters.length; ++i) {
                if (this.clusters[i] != cluster) continue;
                return true;
            }
        }
        return false;
    }

    public void addCluster(int cluster) {
        this.clusters = Utilities.extendArray(this.clusters, 1);
        this.clusters[this.clusters.length - 1] = cluster;
    }

    public int getFirstCluster() {
        if (this.clusters == null || this.clusters.length == 0) {
            return 0;
        }
        return this.clusters[0];
    }

    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.deviceName = stream.readString();
        this.dirName = stream.readString();
        this.fileName = stream.readString();
        this.fileName83 = stream.readString();
        this.directory = stream.readBoolean();
        this.readOnly = stream.readBoolean();
        int time = stream.readInt();
        this.lastModified = time == 0 ? null : ScePspDateTime.fromMSDOSTime(time);
        this.fileSize = stream.readLong();
        this.clusters = stream.readIntsWithLength();
        this.fileData = stream.readBytesWithLength();
        this.closeVirtualFile();
    }

    public void read(StateInputStream stream, FatVirtualFile fatVirtualFile) throws IOException {
        this.parentDirectory = fatVirtualFile.readFatFileInfo(stream);
        this.children = null;
        int countChildren = stream.readInt();
        for (int i = 0; i < countChildren; ++i) {
            FatFileInfo child = fatVirtualFile.readFatFileInfo(stream);
            if (child == null) continue;
            this.addChild(child);
        }
    }

    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeString(this.deviceName);
        stream.writeString(this.dirName);
        stream.writeString(this.fileName);
        stream.writeString(this.fileName83);
        stream.writeBoolean(this.directory);
        stream.writeBoolean(this.readOnly);
        if (this.lastModified == null) {
            stream.writeInt(0);
        } else {
            stream.writeInt(this.lastModified.toMSDOSTime());
        }
        stream.writeLong(this.fileSize);
        stream.writeIntsWithLength(this.clusters);
        stream.writeBytesWithLength(this.fileData);
    }

    public void write(StateOutputStream stream, FatVirtualFile fatVirtualFile) throws IOException {
        fatVirtualFile.writeFatFileInfo(stream, this.parentDirectory);
        if (this.children == null) {
            stream.writeInt(0);
        } else {
            stream.writeInt(this.children.size());
            for (FatFileInfo child : this.children) {
                fatVirtualFile.writeFatFileInfo(stream, child);
            }
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.deviceName != null) {
            s.append(this.deviceName);
        }
        if (this.getFullFileName() == null) {
            s.append("[ROOT]");
        } else {
            s.append("/");
            s.append(this.getFullFileName());
        }
        if (this.fileName83 != null) {
            s.append(String.format("('%s')", this.fileName83));
        }
        if (this.directory) {
            s.append(", directory");
        }
        if (this.readOnly) {
            s.append(", readOnly");
        }
        s.append(String.format(", size=0x%X", this.fileSize));
        if (this.clusters != null) {
            s.append(", clusters=[");
            int length = Math.min(this.clusters.length, 20);
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    s.append(", ");
                }
                s.append(String.format("0x%X", this.clusters[i]));
            }
            if (length < this.clusters.length) {
                s.append(", ...");
            }
            s.append("]");
        }
        return s.toString();
    }
}

