/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.managers.ThreadWaitingList;
import jpcsp.HLE.kernel.managers.ThreadWaitingListFIFO;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructureVariableLength;

public class SceKernelEventFlagInfo
extends pspAbstractMemoryMappedStructureVariableLength {
    public final String name;
    public final int attr;
    public final int initPattern;
    public int currentPattern;
    public final ThreadWaitingList threadWaitingList;
    public final int uid;

    public SceKernelEventFlagInfo(String name, int attr, int initPattern, int currentPattern) {
        this.name = name;
        this.attr = attr;
        this.initPattern = initPattern;
        this.currentPattern = currentPattern;
        this.uid = SceUidManager.getNewUid("ThreadMan-eventflag");
        this.threadWaitingList = new ThreadWaitingListFIFO(4, this.uid);
    }

    @Override
    protected void write() {
        super.write();
        this.writeStringNZ(32, this.name);
        this.write32(this.attr);
        this.write32(this.initPattern);
        this.write32(this.currentPattern);
        this.write32(this.getNumWaitThreads());
    }

    public int getNumWaitThreads() {
        return this.threadWaitingList.getNumWaitingThreads();
    }

    @Override
    public String toString() {
        return String.format("SceKernelEventFlagInfo(uid=0x%X, name='%s', attr=0x%X, initPattern=0x%X, currentPattern=0x%X, numWaitThreads=%d)", this.uid, this.name, this.attr, this.initPattern, this.currentPattern, this.getNumWaitThreads());
    }
}

