/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructureVariableLength;
import jpcsp.util.Utilities;

public class SceKernelLoadExecVSHParam
extends pspAbstractMemoryMappedStructureVariableLength {
    public int args;
    public int argp;
    public TPointer keyAddr;
    public String key;
    public int vshmainArgsSize;
    public int vshmainArgs;
    public TPointer configFileAddr;
    public String configFile;
    public int unknownString;
    public int flags;
    public int extArgs;
    public int extArgp;
    public int opt11;

    @Override
    protected void read() {
        super.read();
        this.args = this.read32();
        this.argp = this.read32();
        this.keyAddr = this.readPointer();
        this.vshmainArgsSize = this.read32();
        this.vshmainArgs = this.read32();
        this.configFileAddr = this.readPointer();
        this.unknownString = this.read32();
        this.flags = this.read32();
        if (this.sizeof() >= 48) {
            this.extArgs = this.read32();
            this.extArgp = this.read32();
            this.opt11 = this.read32();
        }
        this.key = this.keyAddr.getStringZ();
        this.configFile = this.configFileAddr.getStringZ();
    }

    @Override
    protected void write() {
        super.write();
        this.write32(this.args);
        this.write32(this.argp);
        this.writePointer(this.keyAddr);
        this.write32(this.vshmainArgsSize);
        this.write32(this.vshmainArgs);
        this.writePointer(this.configFileAddr);
        this.write32(this.unknownString);
        this.write32(this.flags);
        if (this.sizeof() >= 48) {
            this.write32(this.extArgs);
            this.write32(this.extArgp);
            this.write32(this.opt11);
        }
    }

    @Override
    public String toString() {
        return String.format("args=0x%X, argp=0x%08X, key=%s('%s'), vshmainArgsSize=0x%X, vshmainArgs=0x%08X, configFile=%s('%s'), unknownString=0x%08X, flags=0x%X, extArgs=0x%X, extArgp=0x%08X, opt11=0x%X, vshmainArgs: %s", this.args, this.argp, this.keyAddr, this.key, this.vshmainArgsSize, this.vshmainArgs, this.configFileAddr, this.configFile, this.unknownString, this.flags, this.extArgs, this.extArgp, this.opt11, this.vshmainArgs == 0 ? "" : Utilities.getMemoryDump(this.vshmainArgs, this.vshmainArgsSize));
    }
}

