/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelCallbackInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructureVariableLength;
import jpcsp.HLE.kernel.types.pspBaseCallback;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;

public class SceKernelThreadInfo
extends pspAbstractMemoryMappedStructureVariableLength
implements Comparator<SceKernelThreadInfo> {
    public static final int PSP_MODULE_USER = 0;
    public static final int PSP_MODULE_NO_STOP = 1;
    public static final int PSP_MODULE_SINGLE_LOAD = 2;
    public static final int PSP_MODULE_SINGLE_START = 4;
    public static final int PSP_MODULE_POPS = 512;
    public static final int PSP_MODULE_DEMO = 512;
    public static final int PSP_MODULE_GAMESHARING = 1024;
    public static final int PSP_MODULE_VSH = 2048;
    public static final int PSP_MODULE_KERNEL = 4096;
    public static final int PSP_MODULE_USE_MEMLMD_LIB = 8192;
    public static final int PSP_MODULE_USE_SEMAPHORE_LIB = 16384;
    public static final int PSP_THREAD_ATTR_USER = Integer.MIN_VALUE;
    public static final int PSP_THREAD_ATTR_USBWLAN = -1610612736;
    public static final int PSP_THREAD_ATTR_VSH = -1073741824;
    public static final int PSP_THREAD_ATTR_KERNEL = 4096;
    public static final int PSP_THREAD_ATTR_VFPU = 16384;
    public static final int PSP_THREAD_ATTR_SCRATCH_SRAM = 32768;
    public static final int PSP_THREAD_ATTR_NO_FILLSTACK = 0x100000;
    public static final int PSP_THREAD_ATTR_CLEAR_STACK = 0x200000;
    public static final int PSP_THREAD_ATTR_LOW_MEM_STACK = 0x400000;
    public static final int PSP_THREAD_RUNNING = 1;
    public static final int PSP_THREAD_READY = 2;
    public static final int PSP_THREAD_WAITING = 4;
    public static final int PSP_THREAD_SUSPEND = 8;
    public static final int PSP_THREAD_WAITING_SUSPEND = 12;
    public static final int PSP_THREAD_STOPPED = 16;
    public static final int PSP_THREAD_KILLED = 32;
    public static final int PSP_WAIT_NONE = 0;
    public static final int PSP_WAIT_SLEEP = 1;
    public static final int PSP_WAIT_DELAY = 2;
    public static final int PSP_WAIT_SEMA = 3;
    public static final int PSP_WAIT_EVENTFLAG = 4;
    public static final int PSP_WAIT_MBX = 5;
    public static final int PSP_WAIT_VPL = 6;
    public static final int PSP_WAIT_FPL = 7;
    public static final int PSP_WAIT_MSGPIPE = 8;
    public static final int PSP_WAIT_THREAD_END = 9;
    public static final int PSP_WAIT_EVENTHANDLER = 10;
    public static final int PSP_WAIT_CALLBACK_DELETE = 11;
    public static final int PSP_WAIT_MUTEX = 12;
    public static final int PSP_WAIT_LWMUTEX = 13;
    public static final int JPCSP_FIRST_INTERNAL_WAIT_TYPE = 256;
    public static final int JPCSP_WAIT_IO = 256;
    public static final int JPCSP_WAIT_UMD = 257;
    public static final int JPCSP_WAIT_GE_LIST = 258;
    public static final int JPCSP_WAIT_NET = 259;
    public static final int JPCSP_WAIT_AUDIO = 260;
    public static final int JPCSP_WAIT_DISPLAY_VBLANK = 261;
    public static final int JPCSP_WAIT_CTRL = 262;
    public static final int JPCSP_WAIT_USB = 263;
    public static final int JPCSP_WAIT_VIDEO_DECODER = 264;
    public final String name;
    public int attr;
    public int status;
    public int entry_addr;
    private int stackAddr;
    public int stackSize;
    public int gpReg_addr;
    public final int initPriority;
    public int currentPriority;
    public int waitType;
    public int waitId;
    public int wakeupCount;
    public int exitStatus;
    public TPointer32 exitStatusAddr;
    public long runClocks;
    public int intrPreemptCount;
    public int threadPreemptCount;
    public int releaseCount;
    public int notifyCallback;
    public int errno;
    private SysMemUserForUser.SysMemInfo stackSysMemInfo;
    public final int uid;
    public int moduleid;
    public CpuState cpuContext;
    public boolean doDelete;
    public IAction doDeleteAction;
    public boolean unloadModuleAtDeletion;
    public boolean doCallbacks;
    public final ThreadWaitInfo wait;
    public int displayLastWaitVcount;
    public long javaThreadId = -1L;
    public long javaThreadCpuTimeNanos = -1L;
    public static final int THREAD_CALLBACK_UMD = 0;
    public static final int THREAD_CALLBACK_IO = 1;
    public static final int THREAD_CALLBACK_MEMORYSTICK = 2;
    public static final int THREAD_CALLBACK_MEMORYSTICK_FAT = 3;
    public static final int THREAD_CALLBACK_POWER = 4;
    public static final int THREAD_CALLBACK_EXIT = 5;
    public static final int THREAD_CALLBACK_USB = 6;
    public static final int THREAD_CALLBACK_USER_DEFINED = 7;
    public static final int THREAD_CALLBACK_SIZE = 8;
    private RegisteredCallbacks[] registeredCallbacks;
    public Queue<ThreadManForUser.Callback> pendingCallbacks = new LinkedList<ThreadManForUser.Callback>();
    public Queue<IAction> pendingActions = new LinkedList<IAction>();
    private List<SysMemUserForUser.SysMemInfo> extendedStackSysMemInfos;
    public boolean preserveStack;
    private IAction onThreadStartAction;

    public SceKernelThreadInfo(String name, int entry_addr, int initPriority, int stackSize, int attr, int mpidStack) {
        stackSize = stackSize < 512 ? 512 : stackSize + 255 & 0xFFFFFF00;
        if (mpidStack == 0) {
            mpidStack = 2;
        }
        this.name = name;
        this.entry_addr = entry_addr;
        this.initPriority = initPriority;
        this.stackSize = stackSize;
        this.attr = attr;
        this.uid = SceUidManager.getNewUid("ThreadMan-thread");
        int stackMemoryType = (attr & 0x400000) != 0 ? 0 : 1;
        this.stackSysMemInfo = Modules.SysMemUserForUserModule.malloc(mpidStack, String.format("ThreadMan-Stack-0x%x-%s", this.uid, name), stackMemoryType, stackSize, 0);
        this.stackAddr = this.stackSysMemInfo == null ? 0 : this.stackSysMemInfo.addr;
        this.gpReg_addr = Emulator.getProcessor().cpu._gp;
        this.cpuContext = new CpuState(Emulator.getProcessor().cpu);
        this.wait = new ThreadWaitInfo();
        this.reset();
    }

    public void reset() {
        int i;
        this.status = 16;
        int k0 = this.stackAddr + this.stackSize - 256;
        Memory mem = Memory.getInstance();
        if (this.stackAddr != 0 && this.stackSize > 0 && !this.preserveStack) {
            if ((this.attr & 0x100000) != 0x100000) {
                mem.memset(this.stackAddr, (byte)-1, this.stackSize);
            }
            mem.memset(k0, (byte)0, 256);
            mem.write32(k0 + 192, this.stackAddr);
            mem.write32(k0 + 202, this.uid);
            mem.write32(k0 + 248, -1);
            mem.write32(k0 + 252, -1);
            mem.write32(this.stackAddr, this.uid);
        }
        this.currentPriority = this.initPriority;
        this.waitType = 0;
        this.waitId = 0;
        this.wakeupCount = 0;
        this.exitStatus = -2147352158;
        this.exitStatusAddr = null;
        this.runClocks = 0L;
        this.intrPreemptCount = 0;
        this.threadPreemptCount = 0;
        this.releaseCount = 0;
        this.notifyCallback = 0;
        this.cpuContext.pc = this.entry_addr;
        this.cpuContext.npc = this.entry_addr;
        for (int i2 = 31; i2 > 0; --i2) {
            this.cpuContext.setRegister(i2, -559038737);
        }
        this.cpuContext._k0 = 0;
        this.cpuContext._k1 = 0;
        if (this.isUserMode()) {
            this.cpuContext._k1 |= 0x100000;
        }
        this.cpuContext._k1 |= 0x100000;
        int intNanValue = 2139095041;
        float nanValue = Float.intBitsToFloat(intNanValue);
        for (i = 31; i >= 0; --i) {
            this.cpuContext.fpr[i] = nanValue;
        }
        this.cpuContext.hilo = -2401053088876216593L;
        if ((this.attr & 0x4000) != 0) {
            for (int m = 0; m < 8; ++m) {
                for (int c = 0; c < 4; ++c) {
                    for (int r = 0; r < 4; ++r) {
                        this.cpuContext.setVprInt(m, c, r, intNanValue);
                    }
                }
            }
            for (i = 0; i < this.cpuContext.vcr.cc.length; ++i) {
                this.cpuContext.vcr.cc[i] = true;
            }
            this.cpuContext.vcr.pfxs.reset();
            this.cpuContext.vcr.pfxt.reset();
            this.cpuContext.vcr.pfxd.reset();
        }
        this.cpuContext._sp = this.stackAddr + this.stackSize - 512;
        this.cpuContext._k0 = k0;
        this.cpuContext._ra = 0x8000010;
        this.doDelete = false;
        this.doCallbacks = false;
        this.registeredCallbacks = new RegisteredCallbacks[8];
        for (i = 0; i < this.registeredCallbacks.length; ++i) {
            this.registeredCallbacks[i] = new RegisteredCallbacks(i);
        }
        this.registeredCallbacks[0].setRegisterOnlyLastCallback();
    }

    public void saveContext() {
        this.cpuContext = Emulator.getProcessor().cpu;
    }

    public void restoreContext() {
        this.cpuContext.pc = this.cpuContext.npc;
        Emulator.getProcessor().setCpu(this.cpuContext);
        RuntimeContext.update();
    }

    @Override
    public int compare(SceKernelThreadInfo o1, SceKernelThreadInfo o2) {
        return o1.currentPriority - o2.currentPriority;
    }

    private int getPSPWaitType() {
        if (this.waitType >= 256) {
            return 4;
        }
        return this.waitType;
    }

    @Override
    protected void write() {
        super.write();
        this.writeStringNZ(32, this.name);
        this.write32(this.attr);
        this.write32(this.status);
        this.write32(this.entry_addr);
        this.write32(this.stackAddr);
        this.write32(this.stackSize);
        this.write32(this.gpReg_addr);
        this.write32(this.initPriority);
        this.write32(this.currentPriority);
        this.write32(this.getPSPWaitType());
        this.write32(this.waitId);
        this.write32(this.wakeupCount);
        this.write32(this.exitStatus);
        this.write64(this.runClocks);
        this.write32(this.intrPreemptCount);
        this.write32(this.threadPreemptCount);
        this.write32(this.releaseCount);
    }

    public void writeRunStatus(TPointer pointer) {
        this.start(pointer.getMemory(), pointer.getAddress());
        super.write();
        this.write32(this.status);
        this.write32(this.currentPriority);
        this.write32(this.waitType);
        this.write32(this.waitId);
        this.write32(this.wakeupCount);
        this.write64(this.runClocks);
        this.write32(this.intrPreemptCount);
        this.write32(this.threadPreemptCount);
        this.write32(this.releaseCount);
    }

    public void setSystemStack(int stackAddr, int stackSize) {
        this.freeStack();
        this.stackAddr = stackAddr;
        this.stackSize = stackSize;
    }

    public void freeStack() {
        if (this.stackSysMemInfo != null) {
            Modules.SysMemUserForUserModule.free(this.stackSysMemInfo);
            this.stackSysMemInfo = null;
            this.stackAddr = 0;
        }
        this.freeExtendedStack();
    }

    public void freeExtendedStack(SysMemUserForUser.SysMemInfo extendedStackSysMemInfo) {
        if (this.extendedStackSysMemInfos != null) {
            if (this.extendedStackSysMemInfos.remove(extendedStackSysMemInfo)) {
                Modules.SysMemUserForUserModule.free(extendedStackSysMemInfo);
            }
            if (this.extendedStackSysMemInfos.size() == 0) {
                this.extendedStackSysMemInfos = null;
            }
        }
    }

    public void freeExtendedStack() {
        if (this.extendedStackSysMemInfos != null) {
            for (SysMemUserForUser.SysMemInfo extendedStackSysMemInfo : this.extendedStackSysMemInfos) {
                Modules.SysMemUserForUserModule.free(extendedStackSysMemInfo);
            }
            this.extendedStackSysMemInfos = null;
        }
    }

    public SysMemUserForUser.SysMemInfo extendStack(int size) {
        SysMemUserForUser.SysMemInfo extendedStackSysMemInfo = Modules.SysMemUserForUserModule.malloc(2, String.format("ThreadMan-ExtendedStack-0x%x-%s", this.uid, this.name), 1, size, 0);
        if (this.extendedStackSysMemInfos == null) {
            this.extendedStackSysMemInfos = new LinkedList<SysMemUserForUser.SysMemInfo>();
        }
        this.extendedStackSysMemInfos.add(extendedStackSysMemInfo);
        return extendedStackSysMemInfo;
    }

    public int getStackAddr() {
        if (this.extendedStackSysMemInfos != null) {
            SysMemUserForUser.SysMemInfo extendedStackSysMemInfo = this.extendedStackSysMemInfos.get(this.extendedStackSysMemInfos.size() - 1);
            return extendedStackSysMemInfo.addr;
        }
        return this.stackAddr;
    }

    public static String getStatusName(int status) {
        StringBuilder s = new StringBuilder();
        if ((status & 1) == 1) {
            s.append(" | PSP_THREAD_RUNNING");
        }
        if ((status & 2) == 2) {
            s.append(" | PSP_THREAD_READY");
        }
        if ((status & 4) == 4) {
            s.append(" | PSP_THREAD_WAITING");
        }
        if ((status & 8) == 8) {
            s.append(" | PSP_THREAD_SUSPEND");
        }
        if ((status & 0x10) == 16) {
            s.append(" | PSP_THREAD_STOPPED");
        }
        if ((status & 0x20) == 32) {
            s.append(" | PSP_THREAD_KILLED");
        }
        if (s.length() > 0) {
            s.delete(0, 3);
        } else {
            s.append("UNKNOWN");
        }
        return s.toString();
    }

    public String getStatusName() {
        return SceKernelThreadInfo.getStatusName(this.status);
    }

    public static String getWaitName(int waitType) {
        switch (waitType) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Sleep";
            }
            case 2: {
                return "Delay";
            }
            case 9: {
                return "ThreadEnd";
            }
            case 4: {
                return "EventFlag";
            }
            case 3: {
                return "Semaphore";
            }
            case 12: {
                return "Mutex";
            }
            case 13: {
                return "LwMutex";
            }
            case 5: {
                return "Mbx";
            }
            case 6: {
                return "Vpl";
            }
            case 7: {
                return "Fpl";
            }
            case 8: {
                return "MsgPipe";
            }
            case 10: {
                return "EventHandler";
            }
            case 11: {
                return "CallBackDelete";
            }
            case 256: {
                return "Io";
            }
            case 257: {
                return "Umd";
            }
            case 258: {
                return "Ge List";
            }
            case 259: {
                return "Network";
            }
            case 260: {
                return "Audio";
            }
            case 261: {
                return "Display Vblank";
            }
            case 262: {
                return "Ctrl";
            }
            case 263: {
                return "Usb";
            }
            case 264: {
                return "VideoDecoder";
            }
        }
        return String.format("Unknown waitType=%d", waitType);
    }

    public static String getWaitName(int waitType, int waitId, ThreadWaitInfo wait, int status) {
        StringBuilder s = new StringBuilder();
        switch (waitType) {
            case 0: {
                s.append(String.format("None", new Object[0]));
                break;
            }
            case 1: {
                s.append(String.format("Sleep", new Object[0]));
                break;
            }
            case 2: {
                s.append(String.format("Delay", new Object[0]));
                break;
            }
            case 9: {
                s.append(String.format("ThreadEnd (0x%04X)", wait.ThreadEnd_id));
                break;
            }
            case 4: {
                s.append(String.format("EventFlag (0x%04X)", wait.EventFlag_id));
                break;
            }
            case 3: {
                s.append(String.format("Semaphore (0x%04X)", wait.Semaphore_id));
                break;
            }
            case 12: {
                s.append(String.format("Mutex (0x%04X)", wait.Mutex_id));
                break;
            }
            case 13: {
                s.append(String.format("LwMutex (0x%04X)", wait.LwMutex_id));
                break;
            }
            case 5: {
                s.append(String.format("Mbx (0x%04X)", wait.Mbx_id));
                break;
            }
            case 6: {
                s.append(String.format("Vpl (0x%04X)", wait.Vpl_id));
                break;
            }
            case 7: {
                s.append(String.format("Fpl (0x%04X)", wait.Fpl_id));
                break;
            }
            case 8: {
                s.append(String.format("MsgPipe (0x%04X)", wait.MsgPipe_id));
                break;
            }
            case 10: {
                s.append(String.format("EventHandler", new Object[0]));
                break;
            }
            case 11: {
                s.append(String.format("CallBackDelete", new Object[0]));
                break;
            }
            case 256: {
                s.append(String.format("Io (0x%04X)", wait.Io_id));
                break;
            }
            case 257: {
                s.append(String.format("Umd (0x%02X)", wait.wantedUmdStat));
                break;
            }
            case 258: {
                s.append(String.format("Ge List (%s)", Modules.sceGe_userModule.getGeList(waitId)));
                break;
            }
            case 259: {
                s.append(String.format("Network", new Object[0]));
                break;
            }
            case 260: {
                s.append(String.format("Audio", new Object[0]));
                break;
            }
            case 261: {
                s.append(String.format("Display Vblank (vcount=%d, current=%d)", waitId, Modules.sceDisplayModule.getVcount()));
                break;
            }
            case 262: {
                s.append(String.format("Ctrl", new Object[0]));
                break;
            }
            case 263: {
                s.append(String.format("Usb", new Object[0]));
                break;
            }
            case 264: {
                s.append(String.format("VideoDecoder", new Object[0]));
                break;
            }
            default: {
                s.append(String.format("Unknown waitType=%d", waitType));
            }
        }
        if ((status & 4) != 0) {
            if (wait.forever) {
                s.append(" (forever)");
            } else {
                int restDelay = (int)(wait.microTimeTimeout - Emulator.getClock().microTime());
                if (restDelay < 0) {
                    restDelay = 0;
                }
                s.append(String.format(" (delay %d us, rest %d us)", wait.micros, restDelay));
            }
        }
        return s.toString();
    }

    public String getWaitName() {
        return SceKernelThreadInfo.getWaitName(this.waitType, this.waitId, this.wait, this.status);
    }

    public boolean isSuspended() {
        return (this.status & 8) != 0;
    }

    public boolean isWaiting() {
        return SceKernelThreadInfo.isWaitingStatus(this.status);
    }

    public static boolean isWaitingStatus(int status) {
        return (status & 4) != 0;
    }

    public boolean isWaitingForType(int waitType) {
        if (!this.isWaiting() || this.isSuspended()) {
            return false;
        }
        return this.waitType == waitType;
    }

    public boolean isWaitingFor(int waitType, int waitId) {
        if (!this.isWaitingForType(waitType)) {
            return false;
        }
        return this.waitId == waitId;
    }

    public boolean isRunning() {
        return (this.status & 1) != 0;
    }

    public boolean isReady() {
        return (this.status & 2) != 0;
    }

    public boolean isStopped() {
        return (this.status & 0x10) != 0;
    }

    public static boolean isKernelMode(int attr) {
        return (attr & 0x1000) != 0;
    }

    public static boolean isUserMode(int attr) {
        return (attr & Integer.MIN_VALUE) != 0;
    }

    public boolean isKernelMode() {
        return SceKernelThreadInfo.isKernelMode(this.attr);
    }

    public boolean isUserMode() {
        return SceKernelThreadInfo.isUserMode(this.attr);
    }

    public RegisteredCallbacks getRegisteredCallbacks(int type) {
        return this.registeredCallbacks[type];
    }

    public boolean deleteCallback(SceKernelCallbackInfo callback) {
        boolean deleted = false;
        for (int i = 0; i < this.registeredCallbacks.length; ++i) {
            if (this.registeredCallbacks[i].removeCallback(callback) == null) continue;
            deleted = true;
        }
        return deleted;
    }

    public void setExitStatus(int exitStatus) {
        this.exitStatus = exitStatus;
        if (this.exitStatusAddr != null) {
            this.exitStatusAddr.setValue(exitStatus);
        }
    }

    public boolean isStackAddress(int address) {
        if (this.stackAddr == 0 || this.stackSize <= 0) {
            return false;
        }
        return address >= this.stackAddr && address < this.stackAddr + this.stackSize;
    }

    public void setOnThreadStartAction(IAction onThreadStartAction) {
        this.onThreadStartAction = onThreadStartAction;
    }

    public void onThreadStart() {
        if (this.onThreadStartAction != null) {
            this.onThreadStartAction.execute();
        }
    }

    @Override
    public String toString() {
        return String.format("%s(uid=0x%X, Status=%s, Priority=0x%X, Wait=%s, doCallbacks=%b)", this.name, this.uid, this.getStatusName(), this.currentPriority, this.getWaitName(), this.doCallbacks);
    }

    public static class RegisteredCallbacks {
        private int type;
        private List<pspBaseCallback> callbacks;
        private List<pspBaseCallback> readyCallbacks;
        private int maxNumberOfCallbacks = 32;
        private boolean registerOnlyLastCallback = false;

        public RegisteredCallbacks(int type) {
            this.type = type;
            this.callbacks = new LinkedList<pspBaseCallback>();
            this.readyCallbacks = new LinkedList<pspBaseCallback>();
        }

        public boolean hasCallbacks() {
            return !this.callbacks.isEmpty();
        }

        public pspBaseCallback getCallbackInfoByUid(int cbid) {
            for (pspBaseCallback callback : this.callbacks) {
                if (callback.getUid() != cbid) continue;
                return callback;
            }
            return null;
        }

        public boolean hasCallback(int cbid) {
            return this.getCallbackInfoByUid(cbid) != null;
        }

        public boolean hasCallback(pspBaseCallback callback) {
            return this.callbacks.contains(callback);
        }

        public boolean addCallback(pspBaseCallback callback) {
            if (this.hasCallback(callback)) {
                return true;
            }
            if (this.getNumberOfCallbacks() >= this.maxNumberOfCallbacks) {
                return false;
            }
            if (this.registerOnlyLastCallback) {
                this.callbacks.clear();
            }
            this.callbacks.add(callback);
            return true;
        }

        public void setCallbackReady(pspBaseCallback callback) {
            if (this.hasCallback(callback) && !this.isCallbackReady(callback)) {
                this.readyCallbacks.add(callback);
            }
        }

        public boolean isCallbackReady(pspBaseCallback callback) {
            return this.readyCallbacks.contains(callback);
        }

        public pspBaseCallback removeCallback(pspBaseCallback callback) {
            if (!this.callbacks.remove(callback)) {
                return null;
            }
            this.readyCallbacks.remove(callback);
            return callback;
        }

        public pspBaseCallback getNextReadyCallback() {
            if (this.readyCallbacks.isEmpty()) {
                return null;
            }
            return this.readyCallbacks.remove(0);
        }

        public int getNumberOfCallbacks() {
            return this.callbacks.size();
        }

        public pspBaseCallback getCallbackByIndex(int index) {
            return this.callbacks.get(index);
        }

        public void setRegisterOnlyLastCallback() {
            this.registerOnlyLastCallback = true;
        }

        public String toString() {
            return String.format("RegisteredCallbacks[type %d, count %d, ready %d]", this.type, this.callbacks.size(), this.readyCallbacks.size());
        }
    }
}

