/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.SceKernelLMOption;
import jpcsp.HLE.modules.ModuleMgrForUser;
import jpcsp.hardware.Model;
import org.apache.log4j.Logger;

public class KUBridge
extends HLEModule {
    public static Logger log = Modules.getLogger("KUBridge");

    @HLEFunction(nid=1277553266, version=150)
    public int kuKernelLoadModule(PspString path, int flags, @CanBeNull TPointer optionAddr) {
        SceKernelLMOption lmOption = null;
        if (optionAddr.isNotNull()) {
            lmOption = new SceKernelLMOption();
            lmOption.read(optionAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("kuKernelLoadModule options: %s", lmOption));
            }
        }
        ModuleMgrForUser.LoadModuleContext loadModuleContext = new ModuleMgrForUser.LoadModuleContext();
        loadModuleContext.fileName = path.getString();
        loadModuleContext.flags = flags;
        loadModuleContext.lmOption = lmOption;
        loadModuleContext.needModuleInfo = true;
        loadModuleContext.allocMem = true;
        loadModuleContext.isSignChecked = Modules.ModuleMgrForUserModule.isSignChecked(path.getString());
        return Modules.ModuleMgrForUserModule.hleKernelLoadModule(loadModuleContext);
    }

    @HLEFunction(nid=607328336, version=150)
    public int kuKernelGetModel() {
        int result = Model.getGeneration() - 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("kuKernelGetModel returning %d(%s)", result, Model.getModelName()));
        }
        return result;
    }
}

