/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.types.SceKernelLMOption;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.ModuleMgrForUser;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class ModuleMgrForKernel
extends HLEModule {
    public static Logger log = Modules.getLogger("ModuleMgrForKernel");
    private Set<String> modulesWithMemoryAllocated;

    @Override
    public void start() {
        this.modulesWithMemoryAllocated = new HashSet<String>();
        super.start();
    }

    public boolean isMemoryAllocatedForModule(String moduleName) {
        if (this.modulesWithMemoryAllocated == null) {
            return false;
        }
        return this.modulesWithMemoryAllocated.contains(moduleName);
    }

    @HLEFunction(nid=-1165452281, version=150)
    public int sceKernelLoadModuleBuffer(TPointer buffer, int bufSize, int flags, @CanBeNull TPointer optionAddr) {
        SceKernelLMOption lmOption = null;
        if (optionAddr.isNotNull()) {
            lmOption = new SceKernelLMOption();
            lmOption.read(optionAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceKernelLoadModuleBuffer options: %s", lmOption));
            }
        }
        ModuleMgrForUser.LoadModuleContext loadModuleContext = new ModuleMgrForUser.LoadModuleContext();
        loadModuleContext.fileName = buffer.toString();
        loadModuleContext.flags = flags;
        loadModuleContext.buffer = buffer.getAddress();
        loadModuleContext.bufferSize = bufSize;
        loadModuleContext.lmOption = lmOption;
        loadModuleContext.needModuleInfo = true;
        loadModuleContext.allocMem = true;
        loadModuleContext.isSignChecked = false;
        return Modules.ModuleMgrForUserModule.hleKernelLoadModule(loadModuleContext);
    }

    @HLEFunction(nid=-706893025, version=150)
    public int sceKernelLoadModuleVSH(PspString path, int flags, @CanBeNull TPointer optionAddr) {
        SceKernelLMOption lmOption = null;
        if (optionAddr.isNotNull()) {
            lmOption = new SceKernelLMOption();
            lmOption.read(optionAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceKernelLoadModuleVSH options: %s", lmOption));
            }
        }
        ModuleMgrForUser.LoadModuleContext loadModuleContext = new ModuleMgrForUser.LoadModuleContext();
        loadModuleContext.fileName = path.getString();
        loadModuleContext.flags = flags;
        loadModuleContext.lmOption = lmOption;
        loadModuleContext.needModuleInfo = true;
        loadModuleContext.allocMem = true;
        loadModuleContext.isSignChecked = Modules.ModuleMgrForUserModule.isSignChecked(path.getString());
        return Modules.ModuleMgrForUserModule.hleKernelLoadModule(loadModuleContext);
    }

    @HLEFunction(nid=-663891685, version=150)
    public int sceKernelSearchModuleByName(PspString name) {
        SceModule module = Managers.modules.getModuleByName(name.getString());
        if (module == null) {
            return -2147352274;
        }
        return module.modid;
    }

    @HLEFunction(nid=-722588378, version=150, checkInsideInterrupt=true)
    public int sceKernelLoadModuleToBlock(PspString path, int blockId, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 separatedBlockId, int unknown2, @CanBeNull TPointer optionAddr) {
        IVirtualFile vFile;
        SysMemUserForUser.SysMemInfo sysMemInfo;
        SceKernelLMOption lmOption = null;
        if (optionAddr.isNotNull()) {
            lmOption = new SceKernelLMOption();
            lmOption.read(optionAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceKernelLoadModuleToBlock options: %s", lmOption));
            }
        }
        if ((sysMemInfo = Modules.SysMemUserForUserModule.getSysMemInfo(blockId)) == null) {
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelLoadModuleToBlock sysMemInfo=%s", sysMemInfo));
        }
        this.modulesWithMemoryAllocated.add(path.getString());
        separatedBlockId.setValue(blockId);
        StringBuilder localFileName = new StringBuilder();
        IVirtualFileSystem vfs = Modules.IoFileMgrForUserModule.getVirtualFileSystem(path.getString(), localFileName);
        if (vfs != null && (vFile = vfs.ioOpen(localFileName.toString(), 1, 0)) != null) {
            byte[] bytes = new byte[(int)vFile.length()];
            int length = vFile.ioRead(bytes, 0, bytes.length);
            ByteBuffer moduleBuffer = ByteBuffer.wrap(bytes, 0, length);
            SceModule module = Modules.ModuleMgrForUserModule.getModuleInfo(path.getString(), moduleBuffer, sysMemInfo.partitionid, sysMemInfo.partitionid, Modules.ModuleMgrForUserModule.isSignChecked(path.getString()));
            if (module != null) {
                int size = Modules.ModuleMgrForUserModule.getModuleRequiredMemorySize(module);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceKernelLoadModuleToBlock module requiring 0x%X bytes", size));
                }
                size = Utilities.alignUp(size, 255);
                SysMemUserForUser.SysMemInfo separatedSysMemInfo = Modules.SysMemUserForUserModule.separateMemoryBlock(sysMemInfo, size);
                separatedBlockId.setValue(separatedSysMemInfo.uid);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceKernelLoadModuleToBlock separatedSysMemInfo=%s", separatedSysMemInfo));
                }
            }
        }
        ModuleMgrForUser.LoadModuleContext loadModuleContext = new ModuleMgrForUser.LoadModuleContext();
        loadModuleContext.fileName = path.getString();
        loadModuleContext.lmOption = lmOption;
        loadModuleContext.needModuleInfo = true;
        loadModuleContext.allocMem = false;
        loadModuleContext.baseAddr = sysMemInfo.addr;
        loadModuleContext.basePartition = sysMemInfo.partitionid;
        loadModuleContext.isSignChecked = Modules.ModuleMgrForUserModule.isSignChecked(path.getString());
        return Modules.ModuleMgrForUserModule.hleKernelLoadModule(loadModuleContext);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-863552006, version=150)
    public int sceKernelRebootBeforeForUser(TPointer param) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1687092510, version=150)
    public int sceKernelRebootPhaseForKernel(int unknown1, TPointer param, int unknown2, int unknown3) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1606661082, version=150)
    public int sceKernelRebootBeforeForKernel(TPointer param, int unknown1, int unknown2, int unknown3) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1008882705, version=150)
    public int ModuleMgrForKernel_C3DDABEF() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=485537684, version=150)
    public int sceKernelLoadModuleBufferBootInitBtcnf(int modSize, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.previousParameter, usage=BufferInfo.Usage.in) TPointer modBuf, int flags, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.variableLength, usage=BufferInfo.Usage.in) TPointer option, int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1789039438, version=150)
    public int sceKernelLoadModuleBootInitBtcnf(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=256, usage=BufferInfo.Usage.in) TPointer modBuf, int flags, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.variableLength, usage=BufferInfo.Usage.in) TPointer option) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1312352797, version=150)
    public int sceKernelLoadModuleBufferForRebootKernel(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=256, usage=BufferInfo.Usage.in) TPointer modBuf, int flags, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.variableLength, usage=BufferInfo.Usage.in) TPointer option, int unknown) {
        return 0;
    }

    @HLEFunction(nid=-958526564, version=660)
    public int sceKernelLoadModuleBufferVSH(int bufferSize, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.previousParameter, usage=BufferInfo.Usage.in) TPointer buffer, int flags, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.variableLength, usage=BufferInfo.Usage.in) TPointer optionAddr) {
        SceKernelLMOption lmOption = null;
        if (optionAddr.isNotNull()) {
            lmOption = new SceKernelLMOption();
            lmOption.read(optionAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceKernelLoadModuleBufferVSH options: %s", lmOption));
            }
        }
        ModuleMgrForUser.LoadModuleContext loadModuleContext = new ModuleMgrForUser.LoadModuleContext();
        loadModuleContext.fileName = buffer.toString();
        loadModuleContext.flags = flags;
        loadModuleContext.buffer = buffer.getAddress();
        loadModuleContext.bufferSize = bufferSize;
        loadModuleContext.lmOption = lmOption;
        loadModuleContext.needModuleInfo = true;
        loadModuleContext.allocMem = true;
        loadModuleContext.isSignChecked = false;
        return Modules.ModuleMgrForUserModule.hleKernelLoadModule(loadModuleContext);
    }
}

