/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.HashMap;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEFunctions;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.StringInfo;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.MemoryChunk;
import jpcsp.HLE.kernel.types.MemoryChunkList;
import jpcsp.HLE.kernel.types.SceKernelGameInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceSysmemMemoryBlockInfo;
import jpcsp.HLE.kernel.types.SceSysmemUidCB;
import jpcsp.HLE.kernel.types.SceSysmemUidCBtype;
import jpcsp.HLE.kernel.types.pspSysmemPartitionInfo;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.State;
import jpcsp.hardware.Model;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class SysMemForKernel
extends HLEModule {
    public static Logger log = Modules.getLogger("SysMemForKernel");
    public static final int UID_FUNCTION_INITIALIZE = -753872167;
    public static final int UID_FUNCTION_DELETE = -2029479837;
    public static final int UID_FUNCTION_ALLOC = 233025981;
    public static final int UID_FUNCTION_FREE = -1446103507;
    public static final int UID_FUNCTION_TOTAL_FREE_SIZE = 31143649;
    protected HashMap<Integer, HeapInformation> heaps;
    private String npEnv;
    private int dnas;
    private SysMemUserForUser.SysMemInfo gameInfoMem;
    private SceKernelGameInfo gameInfo;
    private SysMemUserForUser.SysMemInfo dummyControlBlock;
    private int uidHeap;
    private int uidTypeListRoot;
    private int uidTypeListCount;
    private int uidTypeListMetaRoot;
    private int systemStatus;

    @Override
    public void start() {
        this.heaps = new HashMap();
        this.npEnv = "np";
        this.dnas = 0;
        this.gameInfoMem = null;
        this.gameInfo = new SceKernelGameInfo();
        this.gameInfo.flags |= 0x200;
        this.gameInfo.umdCacheOn = 0;
        this.uidHeap = this.sceKernelCreateHeap(1, 8192, 1, "UID Heap");
        this.initUidBasic();
        super.start();
    }

    protected static String getUidFunctionIdName(int id) {
        switch (id) {
            case -753872167: {
                return "initialize";
            }
            case -2029479837: {
                return "delete";
            }
            case 233025981: {
                return "alloc";
            }
            case -1446103507: {
                return "free";
            }
            case 31143649: {
                return "totalFreeSize";
            }
        }
        return String.format("0x%08X", id);
    }

    protected int newUid(int addr) {
        return addr << 5 | (this.uidTypeListCount++ & 0x3F) << 1 | 1;
    }

    public static int getCBFromUid(int uid) {
        return (uid & 0xFFFFFF80) >> 5 | 0x8000000;
    }

    protected void initUidRoot() {
        Memory mem = Memory.getInstance();
        SceSysmemUidCB sceSysmemUidCBRoot = new SceSysmemUidCB();
        int root = this.sceKernelAllocHeapMemory(this.uidHeap, sceSysmemUidCBRoot.sizeof());
        SceSysmemUidCB sceSysmemUidCBMetaRoot = new SceSysmemUidCB();
        int metaRoot = this.sceKernelAllocHeapMemory(this.uidHeap, sceSysmemUidCBMetaRoot.sizeof());
        this.uidTypeListCount = 1;
        this.uidTypeListRoot = root;
        sceSysmemUidCBRoot.meta = metaRoot;
        sceSysmemUidCBRoot.parent0 = root;
        sceSysmemUidCBRoot.nextChild = root;
        sceSysmemUidCBRoot.uid = this.newUid(root);
        sceSysmemUidCBRoot.childSize = 6;
        sceSysmemUidCBRoot.allocAndSetName(mem, this.uidHeap, "Root");
        sceSysmemUidCBRoot.write(mem, root);
        this.uidTypeListMetaRoot = metaRoot;
        sceSysmemUidCBMetaRoot.meta = metaRoot;
        sceSysmemUidCBMetaRoot.parent0 = metaRoot;
        sceSysmemUidCBMetaRoot.nextChild = metaRoot;
        sceSysmemUidCBMetaRoot.uid = this.newUid(metaRoot);
        sceSysmemUidCBMetaRoot.childSize = 6;
        sceSysmemUidCBMetaRoot.allocAndSetName(mem, this.uidHeap, "MetaRoot");
        sceSysmemUidCBMetaRoot.write(mem, metaRoot);
    }

    protected void initUidBasic() {
        this.initUidRoot();
        Memory mem = Memory.getInstance();
        SceSysmemUidCBtype sceSysmemUidCBBasic = new SceSysmemUidCBtype();
        int basic = this.sceKernelAllocHeapMemory(this.uidHeap, sceSysmemUidCBBasic.sizeof());
        SceSysmemUidCBtype sceSysmemUidCBMetaBasic = new SceSysmemUidCBtype();
        int metaBasic = this.sceKernelAllocHeapMemory(this.uidHeap, sceSysmemUidCBMetaBasic.sizeof());
        SceSysmemUidCBtype sceSysmemUidCBMetaRoot = new SceSysmemUidCBtype();
        sceSysmemUidCBMetaRoot.read(mem, this.uidTypeListMetaRoot);
        SceSysmemUidCBtype sceSysmemUidCBRoot = new SceSysmemUidCBtype();
        sceSysmemUidCBRoot.read(mem, this.uidTypeListRoot);
        sceSysmemUidCBBasic.meta = metaBasic;
        sceSysmemUidCBBasic.parent0 = basic;
        sceSysmemUidCBBasic.nextChild = basic;
        sceSysmemUidCBBasic.uid = this.newUid(basic);
        sceSysmemUidCBBasic.childSize = sceSysmemUidCBRoot.childSize + 1;
        sceSysmemUidCBBasic.size = sceSysmemUidCBRoot.childSize;
        sceSysmemUidCBBasic.allocAndSetName(mem, this.uidHeap, "Basic");
        sceSysmemUidCBBasic.next = sceSysmemUidCBRoot.next;
        sceSysmemUidCBBasic.parent1 = this.uidTypeListRoot;
        sceSysmemUidCBBasic.write(mem, basic);
        sceSysmemUidCBRoot.next = basic;
        sceSysmemUidCBRoot.write(mem, this.uidTypeListRoot);
        ++sceSysmemUidCBMetaRoot.next;
        sceSysmemUidCBMetaRoot.write(mem, this.uidTypeListMetaRoot);
        sceSysmemUidCBMetaBasic.meta = this.uidTypeListMetaRoot;
        sceSysmemUidCBMetaBasic.parent0 = metaBasic;
        sceSysmemUidCBMetaBasic.nextChild = metaBasic;
        sceSysmemUidCBMetaBasic.uid = this.newUid(metaBasic);
        sceSysmemUidCBMetaBasic.childSize = 6;
        sceSysmemUidCBMetaBasic.allocAndSetName(mem, this.uidHeap, "MetaRoot");
        sceSysmemUidCBMetaBasic.parent1 = sceSysmemUidCBRoot.meta;
        sceSysmemUidCBMetaBasic.write(mem, metaBasic);
    }

    protected SceSysmemUidCBtype searchUidTypeByName(String name) {
        int cur = this.uidTypeListRoot;
        SceSysmemUidCBtype sceSysmemUidCB = new SceSysmemUidCBtype();
        Memory mem = Memory.getInstance();
        do {
            sceSysmemUidCB.read(mem, cur);
            if (!name.equals(sceSysmemUidCB.name)) continue;
            return sceSysmemUidCB;
        } while ((cur = sceSysmemUidCB.next) != this.uidTypeListRoot);
        return null;
    }

    private int getUIDFunction(SceSysmemUidCBtype type, int funcId) {
        if (type != null && type.funcTable != 0) {
            int id;
            TPointer32 funcTable = new TPointer32(Memory.getInstance(), type.funcTable);
            int offset = 0;
            while ((id = funcTable.getValue(offset)) != 0) {
                if (id == funcId) {
                    return funcTable.getValue(offset + 4);
                }
                offset += 8;
            }
        }
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=471842791, version=150), @HLEFunction(nid=1477742343, version=660)})
    public int sceKernelCreateHeap(int partitionId, int size, int flags, String name) {
        size = Modules.LoadCoreForKernelModule.hleKernelCreateHeapHook(partitionId, size, flags, name);
        HeapInformation info = new HeapInformation(partitionId, size, flags, name);
        if (info.uid >= 0) {
            this.heaps.put(info.uid, info);
        }
        return info.uid;
    }

    @HLEFunctions(value={@HLEFunction(nid=1668060475, version=150), @HLEFunction(nid=601364085, version=660)})
    public int sceKernelAllocHeapMemory(int heapId, int size) {
        HeapInformation info = this.heaps.get(heapId);
        if (info == null) {
            return 0;
        }
        size = Utilities.alignUp(size, 7);
        int addr = info.allocBlock(size);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelAllocHeapMemory(size=0x%X) returning 0x%08X, %s", size, addr, info));
        }
        return addr;
    }

    @HLEFunctions(value={@HLEFunction(nid=2071237520, version=150), @HLEFunction(nid=-2017285243, version=660)})
    public int sceKernelFreeHeapMemory(int heapId, TPointer block) {
        HeapInformation info = this.heaps.get(heapId);
        if (info == null) {
            return -1;
        }
        info.freeBlock(block.getAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelFreeHeapMemory after free: %s", info));
        }
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=-914335883, version=150), @HLEFunction(nid=-580578608, version=660)})
    public int sceKernelDeleteHeap(int heapId) {
        HeapInformation info = this.heaps.remove(heapId);
        if (info == null) {
            return -1;
        }
        info.free();
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=1668520285, version=280), @HLEFunction(nid=130385569, version=660)})
    public int sceKernelGetModel() {
        int result = Model.getGeneration() - 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelGetModel returning %d(%s)", result, Model.getModelName()));
        }
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1805761062, version=150)
    public int SysMemUserForUser_945E45DA(TPointer unknown) {
        unknown.setStringNZ(9, this.npEnv);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2146628442, version=150)
    public int SysMemForKernel_7FF2F35A(TPointer unknown) {
        return this.SysMemUserForUser_945E45DA(unknown);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1606634368, version=660)
    public int SysMemForKernel_A03CB480(TPointer unknown) {
        this.npEnv = unknown.getStringNZ(8);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("SysMemForKernel_A03CB480 setting unknownString='%s'", this.npEnv));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2140046873, version=150)
    public int sceKernelSetParamSfo(PspString discId, int unknown1, int unknown2, PspString unknown3, int unknown4, int unknown5, PspString pspVersion) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1076543561, version=150)
    public int sceKernelGetDNAS() {
        return this.dnas;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1742059655, version=150)
    public int sceKernelSetDNAS(int dnas) {
        this.dnas = dnas;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-282524132, version=150)
    public int sceKernelGetGameInfo() {
        if (this.gameInfoMem == null) {
            this.gameInfoMem = Modules.SysMemUserForUserModule.malloc(1, "SceKernelGameInfo", 0, 220, 0);
        }
        this.gameInfo.gameId = State.discId;
        this.gameInfo.sdkVersion = Modules.SysMemUserForUserModule.hleKernelGetCompiledSdkVersion();
        this.gameInfo.compilerVersion = Modules.SysMemUserForUserModule.hleKernelGetCompilerVersion();
        this.gameInfo.write(Memory.getInstance(), this.gameInfoMem.addr);
        return this.gameInfoMem.addr;
    }

    @HLEUnimplemented
    @HLEFunction(nid=448072052, version=150)
    public int sceKernelJointMemoryBlock(int id1, int id2) {
        return 0;
    }

    @HLEFunction(nid=580981980, version=150)
    public int sceKernelMemset32(TPointer destAddr, int data, int size) {
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(destAddr.getAddress(), size, 4);
        for (int i = 0; i < size; i += 4) {
            memoryWriter.writeNext(data);
        }
        memoryWriter.flush();
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-396312945, version=150)
    public int sceKernelQueryMemoryBlockInfo(int id, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=56, usage=BufferInfo.Usage.out) TPointer infoPtr) {
        SysMemUserForUser.SysMemInfo info = Modules.SysMemUserForUserModule.getSysMemInfo(id);
        if (info == null) {
            return -1;
        }
        SceSysmemMemoryBlockInfo blockInfo = new SceSysmemMemoryBlockInfo();
        blockInfo.read(infoPtr);
        blockInfo.name = info.name;
        blockInfo.attr = 0;
        blockInfo.addr = info.addr;
        blockInfo.memSize = info.size;
        blockInfo.sizeLocked = 0;
        blockInfo.unused = 0;
        blockInfo.write(infoPtr);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-922023534, version=150)
    public int sceKernelGetUIDcontrolBlock(int id, TPointer32 controlBlockAddr) {
        Memory mem = Memory.getInstance();
        if (SceUidManager.isValidUid(id)) {
            if (this.dummyControlBlock == null) {
                this.dummyControlBlock = Modules.SysMemUserForUserModule.malloc(1, "DummyControlBlock", 0, 36, 0);
                if (this.dummyControlBlock == null) {
                    return -1;
                }
            }
            TPointer dummyControlBlockPtr = new TPointer(mem, this.dummyControlBlock.addr);
            dummyControlBlockPtr.clear(36);
            dummyControlBlockPtr.setValue16(22, (short)255);
            controlBlockAddr.setValue(dummyControlBlockPtr.getAddress());
            return 0;
        }
        if ((id & 0x80000001) != 1) {
            return -2147352373;
        }
        int cb = SysMemForKernel.getCBFromUid(id);
        SceSysmemUidCB sceSysmemUidCB = new SceSysmemUidCB();
        sceSysmemUidCB.read(mem, cb);
        if (sceSysmemUidCB.uid != id) {
            return -2147352373;
        }
        controlBlockAddr.setValue(cb);
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=-1391869033, version=150), @HLEFunction(nid=-769467737, version=660)})
    public int sceKernelCreateUIDtypeInherit(String parentName, String name, int size, @CanBeNull TPointer32 funcTable, @CanBeNull TPointer32 metaFuncTable, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 uidTypeOut) {
        SceSysmemUidCBtype parentUidType;
        Memory mem = Memory.getInstance();
        if (funcTable.isNotNull()) {
            int id;
            int offset = 0;
            while ((id = funcTable.getValue(offset)) != 0) {
                int addr = funcTable.getValue(offset + 4);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceKernelCreateUIDtypeInherit - funcTable id=%s, addr=0x%08X", SysMemForKernel.getUidFunctionIdName(id), addr));
                }
                offset += 8;
            }
        }
        if ((parentUidType = this.searchUidTypeByName(parentName)) == null) {
            return -2147352375;
        }
        SceSysmemUidCBtype sceSysmemUidCB = new SceSysmemUidCBtype();
        int uidType = this.sceKernelAllocHeapMemory(this.uidHeap, sceSysmemUidCB.sizeof());
        SceSysmemUidCBtype sceSysmemUidCBMeta = new SceSysmemUidCBtype();
        int metaUidType = this.sceKernelAllocHeapMemory(this.uidHeap, sceSysmemUidCBMeta.sizeof());
        sceSysmemUidCB.allocAndSetName(mem, this.uidHeap, name);
        sceSysmemUidCBMeta.allocAndSetName(mem, this.uidHeap, "Meta" + name);
        if (uidType <= 0 || metaUidType <= 0 || sceSysmemUidCB.nameAddr <= 0 || sceSysmemUidCBMeta.nameAddr <= 0) {
            if (uidType > 0) {
                this.sceKernelFreeHeapMemory(this.uidHeap, new TPointer(mem, uidType));
            }
            if (metaUidType > 0) {
                this.sceKernelFreeHeapMemory(this.uidHeap, new TPointer(mem, metaUidType));
            }
            if (sceSysmemUidCB.nameAddr > 0) {
                this.sceKernelFreeHeapMemory(this.uidHeap, new TPointer(mem, sceSysmemUidCB.nameAddr));
            }
            if (sceSysmemUidCBMeta.nameAddr > 0) {
                this.sceKernelFreeHeapMemory(this.uidHeap, new TPointer(mem, sceSysmemUidCBMeta.nameAddr));
            }
            return -2147352176;
        }
        SceSysmemUidCBtype parentMetaUidType = new SceSysmemUidCBtype();
        parentMetaUidType.read(mem, parentUidType.meta);
        ++parentMetaUidType.next;
        parentMetaUidType.write(mem, parentUidType.meta);
        SceSysmemUidCBtype rootUidType = new SceSysmemUidCBtype();
        rootUidType.read(mem, this.uidTypeListRoot);
        sceSysmemUidCB.parent0 = uidType;
        sceSysmemUidCB.uid = this.newUid(uidType);
        sceSysmemUidCB.nextChild = uidType;
        sceSysmemUidCB.meta = metaUidType;
        sceSysmemUidCB.childSize = parentUidType.childSize + (size + 3 >> 2);
        sceSysmemUidCB.size = parentUidType.childSize;
        sceSysmemUidCB.name = name;
        sceSysmemUidCB.next = rootUidType.next;
        sceSysmemUidCB.parent1 = parentUidType.getBaseAddress();
        sceSysmemUidCB.funcTable = funcTable.getAddress();
        sceSysmemUidCB.write(mem, uidType);
        sceSysmemUidCBMeta.nextChild = metaUidType;
        sceSysmemUidCBMeta.meta = this.uidTypeListMetaRoot;
        sceSysmemUidCBMeta.childSize = 6;
        sceSysmemUidCBMeta.size = 0;
        sceSysmemUidCBMeta.name = "Meta" + name;
        sceSysmemUidCBMeta.funcTable = metaFuncTable.getAddress();
        sceSysmemUidCBMeta.write(mem, metaUidType);
        uidTypeOut.setValue(uidType);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-17004954, version=150), @HLEFunction(nid=54602235, version=660)})
    public int sceKernelCreateUIDtype(String name, int size, @CanBeNull TPointer32 funcTable, @CanBeNull TPointer32 metaFuncTable, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 uidTypeOut) {
        return this.sceKernelCreateUIDtypeInherit("Basic", name, size, funcTable, metaFuncTable, uidTypeOut);
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1985527800, version=150), @HLEFunction(nid=171229304, version=660)})
    public int sceKernelCreateUID(TPointer uidType, String name, int k1, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 outUid) {
        Memory mem = uidType.getMemory();
        SceSysmemUidCBtype sceSysmemUidCBType = new SceSysmemUidCBtype();
        sceSysmemUidCBType.read(uidType);
        int uid = this.sceKernelAllocHeapMemory(this.uidHeap, sceSysmemUidCBType.childSize << 2);
        if (uid <= 0) {
            return -2147352176;
        }
        mem.memset(uid, (byte)0, sceSysmemUidCBType.childSize << 2);
        SceSysmemUidCB sceSysmemUidCB = new SceSysmemUidCB();
        sceSysmemUidCB.allocAndSetName(mem, this.uidHeap, name);
        if (sceSysmemUidCB.nameAddr == 0) {
            this.sceKernelFreeHeapMemory(this.uidHeap, new TPointer(mem, uid));
            return -2147352176;
        }
        sceSysmemUidCB.attr = k1;
        sceSysmemUidCB.uid = this.newUid(uid);
        sceSysmemUidCB.nextChild = sceSysmemUidCBType.nextChild;
        sceSysmemUidCB.parent0 = uidType.getAddress();
        sceSysmemUidCB.size = sceSysmemUidCBType.size;
        sceSysmemUidCB.childSize = sceSysmemUidCBType.childSize;
        sceSysmemUidCB.meta = uidType.getAddress();
        sceSysmemUidCB.write(mem, uid);
        sceSysmemUidCBType.nextChild = uid;
        sceSysmemUidCBType.write(uidType);
        SceSysmemUidCB next = new SceSysmemUidCB();
        next.read(mem, sceSysmemUidCB.nextChild);
        next.parent0 = uid;
        next.write(mem, sceSysmemUidCB.nextChild);
        outUid.setValue(uid);
        int funcAddr = this.getUIDFunction(sceSysmemUidCBType, -753872167);
        if (funcAddr != 0) {
            SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
            Modules.ThreadManForUserModule.executeCallback(thread, funcAddr, null, false, uid, uidType.getAddress(), -753872167);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=775160524, version=150), @HLEFunction(nid=-1486740841, version=660)})
    public int sceKernelRenameUID(int id, String name) {
        if (SceUidManager.isValidUid(id)) {
            log.warn((Object)String.format("sceKernelRenameUID called on id=0x%X, which has not been created by sceKernelCreateUID", id));
            return 0;
        }
        if ((id & 0x80000001) != 1) {
            return -2147352373;
        }
        Memory mem = Memory.getInstance();
        int cb = SysMemForKernel.getCBFromUid(id);
        SceSysmemUidCB sceSysmemUidCB = new SceSysmemUidCB();
        sceSysmemUidCB.read(mem, cb);
        sceSysmemUidCB.freeName(this.uidHeap);
        sceSysmemUidCB.allocAndSetName(mem, this.uidHeap, name);
        sceSysmemUidCB.write(mem, cb);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1893677888, version=150), @HLEFunction(nid=908005256, version=660)})
    public int sceKernelDeleteUID(int id) {
        Memory mem = Memory.getInstance();
        int cb = SysMemForKernel.getCBFromUid(id);
        SceSysmemUidCB sceSysmemUidCB = new SceSysmemUidCB();
        sceSysmemUidCB.read(mem, cb);
        SceSysmemUidCBtype sceSysmemUidCBtype = new SceSysmemUidCBtype();
        sceSysmemUidCBtype.read(mem, sceSysmemUidCB.meta);
        int funcAddr = this.getUIDFunction(sceSysmemUidCBtype, -2029479837);
        if (funcAddr != 0) {
            SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
            Modules.ThreadManForUserModule.executeCallback(thread, funcAddr, null, false, cb, sceSysmemUidCB.meta, -2029479837);
        }
        SceSysmemUidCB parent0 = new SceSysmemUidCB();
        parent0.read(mem, sceSysmemUidCB.parent0);
        parent0.nextChild = sceSysmemUidCB.nextChild;
        parent0.write(mem, sceSysmemUidCB.parent0);
        SceSysmemUidCB nextChild = new SceSysmemUidCB();
        nextChild.read(mem, sceSysmemUidCB.nextChild);
        nextChild.parent0 = sceSysmemUidCB.parent0;
        nextChild.write(mem, sceSysmemUidCB.nextChild);
        sceSysmemUidCB.meta = 0;
        sceSysmemUidCB.uid = 0;
        sceSysmemUidCB.nextChild = cb;
        sceSysmemUidCB.parent0 = cb;
        sceSysmemUidCB.write(mem, cb);
        if (sceSysmemUidCB.nameAddr != 0) {
            this.sceKernelFreeHeapMemory(this.uidHeap, new TPointer(mem, sceSysmemUidCB.nameAddr));
        }
        this.sceKernelFreeHeapMemory(this.uidHeap, new TPointer(mem, cb));
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=1436814124, version=150), @HLEFunction(nid=-990990560, version=660)})
    public int sceKernelQueryMemoryPartitionInfo(int partitionId, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.variableLength, usage=BufferInfo.Usage.out) TPointer infoPtr) {
        pspSysmemPartitionInfo partitionInfo = new pspSysmemPartitionInfo();
        partitionInfo.read(infoPtr);
        switch (partitionId) {
            case 1: {
                partitionInfo.startAddr = -2013265920;
                partitionInfo.memSize = 0x400000;
                partitionInfo.attr = 12;
                break;
            }
            case 2: {
                partitionInfo.startAddr = 0x8800000;
                partitionInfo.memSize = MemoryMap.END_USERSPACE - 0x8800000 + 1;
                partitionInfo.attr = 3;
                break;
            }
            case 5: {
                partitionInfo.startAddr = 0x8400000;
                partitionInfo.memSize = 0x400000;
                partitionInfo.attr = 15;
                break;
            }
            default: {
                log.warn((Object)String.format("Unimplemented sceKernelQueryMemoryPartitionInfo partitionId=0x%X", partitionId));
                return -1;
            }
        }
        partitionInfo.write(infoPtr);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1107281913, version=150), @HLEFunction(nid=1153299250, version=660)})
    public int sceKernelGetUIDcontrolBlockWithType(int id, TPointer32 uidType, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 controlBlockAddr) {
        Memory mem = Memory.getInstance();
        if ((id & 0x80000001) != 1) {
            return -2147352373;
        }
        int cb = SysMemForKernel.getCBFromUid(id);
        SceSysmemUidCB sceSysmemUidCB = new SceSysmemUidCB();
        sceSysmemUidCB.read(mem, cb);
        if (sceSysmemUidCB.uid != id) {
            return -2147352373;
        }
        controlBlockAddr.setValue(cb);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=593241670, version=660)
    public int sceKernelCallUIDObjCommonFunction(TPointer32 uid, TPointer32 uidWithFunc, int funcId) {
        SceSysmemUidCB sceSysmemUidCB = new SceSysmemUidCB();
        sceSysmemUidCB.read(uid);
        SceSysmemUidCBtype sceSysmemUidCBtype = new SceSysmemUidCBtype();
        sceSysmemUidCBtype.read(uidWithFunc);
        SceSysmemUidCBtype sceSysmemUidCBparent1 = new SceSysmemUidCBtype();
        sceSysmemUidCBparent1.read(Memory.getInstance(), sceSysmemUidCBtype.parent1);
        int funcAddr = this.getUIDFunction(sceSysmemUidCBparent1, funcId);
        if (funcAddr != 0) {
            SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
            Modules.ThreadManForUserModule.executeCallback(thread, funcAddr, null, false, uid.getAddress(), sceSysmemUidCBtype.parent1, funcId);
        }
        return sceSysmemUidCB.uid;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=2067690561, version=150), @HLEFunction(nid=510376168, version=660)})
    public void sceKernelMemoryExtendSize() {
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-536510416, version=150), @HLEFunction(nid=2055002044, version=660)})
    public void sceKernelMemoryShrinkSize() {
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-877637055, version=150), @HLEFunction(nid=-241458291, version=660)})
    public int sceKernelSetAllowReplaceUmd(boolean allow) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=335856042, version=660)
    public int sceKernelSetUmdCacheOn(int umdCacheOn) {
        this.gameInfo.umdCacheOn = umdCacheOn;
        this.gameInfo.flags |= 0x200;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1767649748, version=150)
    public int sceKernelSetRebootKernel(TPointer rebootKernelFunction) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=918881193, version=150)
    public int sceKernelGetSystemStatus() {
        return this.systemStatus;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1377486244, version=150)
    public int sceKernelSetSystemStatus(int systemStatus) {
        int oldSystemStatus = this.systemStatus;
        this.systemStatus = systemStatus;
        return oldSystemStatus;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1244813984, version=150)
    public int sceKernelGetInitialRandomValue() {
        return 305419896;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1839082966, version=150)
    public int sceKernelSysMemRealMemorySize() {
        return MemoryMap.SIZE_RAM;
    }

    @HLEFunction(nid=-1683221955, version=150)
    public int sceKernelMemmove(TPointer destAddr, TPointer srcAddr, int size) {
        if (destAddr.getAddress() != srcAddr.getAddress()) {
            destAddr.memmove(srcAddr.getAddress(), size);
        }
        return destAddr.getAddress();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2085281171, version=150)
    public int sceKernelSetDdrMemoryProtection(TPointer addr, int size, int set) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1232271825, version=150)
    public int sceKernelGetAllowReplaceUmd() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1692357393, version=150)
    public int sceKernelMemmoveWithFill(TPointer dstAddr, TPointer srcAddr, int size, int fill) {
        dstAddr.memmove(srcAddr.getAddress(), size);
        return dstAddr.getAddress();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-792639987, version=150)
    public int sceKernelGetId() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-135820493, version=150)
    public int sceKernelSeparateMemoryBlock(int id, boolean cutBefore, int size) {
        return 0;
    }

    @HLEFunction(nid=-84762828, version=150)
    public int sceKernelQueryMemoryInfo(int address, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 partitionIdAddr, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 memoryBlockIdAddr) {
        SysMemUserForUser.SysMemInfo info = Modules.SysMemUserForUserModule.getSysMemInfoByAddress(address);
        if (info == null) {
            return -1;
        }
        partitionIdAddr.setValue(info.partitionid);
        memoryBlockIdAddr.setValue(info.uid);
        return 0;
    }

    @HLEFunction(nid=-77862042, version=150)
    public int sceKernelResizeMemoryBlock(int id, int leftShift, int rightShift) {
        SysMemUserForUser.SysMemInfo info = Modules.SysMemUserForUserModule.getSysMemInfo(id);
        if (info == null) {
            return -1;
        }
        if (!Modules.SysMemUserForUserModule.resizeMemoryBlock(info, leftShift = leftShift / 256 * 256, rightShift = rightShift / 256 * 256)) {
            return -2147352357;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1085752484, version=150)
    public int SysMemForKernel_40B744A4(int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1075804535, version=150)
    public int SysMemForKernel_BFE08689(@CanBeNull @StringInfo(maxLength=64) PspString unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-367219727, version=150)
    public int sceKernelFillFreeBlock(int mpid, int c) {
        return 0;
    }

    protected static class HeapInformation {
        private static final String uidPurpose = "SysMemForKernel-Heap";
        private static final int HEAP_BLOCK_HEADER_SIZE = 8;
        protected final int uid;
        protected final int partitionId;
        protected final int size;
        protected final int flags;
        protected final String name;
        protected SysMemUserForUser.SysMemInfo sysMemInfo;
        protected MemoryChunkList freeMemoryChunks;

        public HeapInformation(int partitionId, int size, int flags, String name) {
            this.partitionId = partitionId;
            this.size = size;
            this.flags = flags;
            this.name = name;
            int type = 0;
            this.sysMemInfo = Modules.SysMemUserForUserModule.malloc(partitionId, name, type, size, 0);
            if (this.sysMemInfo == null) {
                this.uid = -1;
            } else {
                MemoryChunk memoryChunk = new MemoryChunk(this.sysMemInfo.addr, size);
                this.freeMemoryChunks = new MemoryChunkList(memoryChunk);
                this.uid = SceUidManager.getNewUid(uidPurpose);
            }
        }

        public void free() {
            if (this.sysMemInfo != null) {
                Modules.SysMemUserForUserModule.free(this.sysMemInfo);
                this.sysMemInfo = null;
                this.freeMemoryChunks = null;
                SceUidManager.releaseUid(this.uid, uidPurpose);
            }
        }

        public int allocBlock(int blockSize) {
            if (this.freeMemoryChunks == null) {
                return 0;
            }
            MemoryChunk allocatedMemoryChunk = this.freeMemoryChunks.allocLow(blockSize + 8, 0);
            if (allocatedMemoryChunk == null) {
                return 0;
            }
            Memory.getInstance().write32(allocatedMemoryChunk.addr, allocatedMemoryChunk.size - 8);
            return allocatedMemoryChunk.addr + 8;
        }

        public void freeBlock(int addr) {
            int blockSize = Memory.getInstance().read32(addr -= 8);
            MemoryChunk memoryChunk = new MemoryChunk(addr, blockSize + 8);
            this.freeMemoryChunks.add(memoryChunk);
        }

        public String toString() {
            return String.format("uid=0x%X, partitionId=0x%X, size=0x%X, flags=0x%X, name='%s', freeMemoryChunks=%s", this.uid, this.partitionId, this.size, this.flags, this.name, this.freeMemoryChunks);
        }
    }
}

