/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import jpcsp.Allegrex.CpuState;
import jpcsp.Debugger.DumpDebugState;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEFunctions;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.StringInfo;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.MemoryChunk;
import jpcsp.HLE.kernel.types.MemoryChunkList;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class SysMemUserForUser
extends HLEModule {
    public static Logger log = Modules.getLogger("SysMemUserForUser");
    protected static Logger stdout = Logger.getLogger((String)"stdout");
    protected static HashMap<Integer, SysMemInfo> blockList;
    protected static MemoryChunkList[] freeMemoryChunks;
    protected int firmwareVersion = 150;
    public static final int defaultSizeAlignment = 256;
    public static final int PSP_SMEM_Low = 0;
    public static final int PSP_SMEM_High = 1;
    public static final int PSP_SMEM_Addr = 2;
    public static final int PSP_SMEM_LowAligned = 3;
    public static final int PSP_SMEM_HighAligned = 4;
    public static final int KERNEL_PARTITION_ID = 1;
    public static final int USER_PARTITION_ID = 2;
    public static final int VSHELL_PARTITION_ID = 5;
    protected boolean started = false;
    private int compiledSdkVersion;
    private int compilerVersion;

    @Override
    public void load() {
        this.reset();
        super.load();
    }

    @Override
    public void start() {
        if (!this.started) {
            this.reset();
            this.started = true;
        }
        this.compiledSdkVersion = 0;
        this.compilerVersion = 0;
        super.start();
    }

    @Override
    public void stop() {
        this.started = false;
        super.stop();
    }

    private MemoryChunkList createMemoryChunkList(int startAddr, int endAddr) {
        MemoryChunk initialMemory = new MemoryChunk(startAddr &= 0x1FFFFFFF, (endAddr &= 0x1FFFFFFF) - startAddr + 1);
        return new MemoryChunkList(initialMemory);
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean preserveKernelMemory) {
        if (blockList == null || freeMemoryChunks == null) {
            preserveKernelMemory = false;
        }
        if (preserveKernelMemory) {
            LinkedList<SysMemInfo> toBeFreed = new LinkedList<SysMemInfo>();
            for (SysMemInfo sysMemInfo : blockList.values()) {
                if (sysMemInfo.partitionid != 2) continue;
                toBeFreed.add(sysMemInfo);
            }
            for (SysMemInfo sysMemInfo : toBeFreed) {
                sysMemInfo.free();
            }
        } else {
            blockList = new HashMap();
        }
        if (!preserveKernelMemory) {
            freeMemoryChunks = new MemoryChunkList[6];
            SysMemUserForUser.freeMemoryChunks[1] = this.createMemoryChunkList(-2013265920, 0x83FFFFF);
            SysMemUserForUser.freeMemoryChunks[5] = this.createMemoryChunkList(0x8400000, 0x87FFFFF);
        }
        SysMemUserForUser.freeMemoryChunks[2] = this.createMemoryChunkList(0x8800000, MemoryMap.END_USERSPACE);
    }

    public void setMemory64MB(boolean isMemory64MB) {
        if (isMemory64MB) {
            this.setMemorySize(0x4000000);
        } else {
            this.setMemorySize(0x2000000);
        }
    }

    public void setMemorySize(int memorySize) {
        if (MemoryMap.SIZE_RAM != memorySize) {
            int kernelSize = 0x800000;
            int kernelSize32 = kernelSize >> 2;
            int[] savedKernelMemory = new int[kernelSize32];
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(-2013265920, kernelSize, 4);
            for (int i = 0; i < kernelSize32; ++i) {
                savedKernelMemory[i] = memoryReader.readNext();
            }
            int previousMemorySize = MemoryMap.SIZE_RAM;
            MemoryMap.END_USERSPACE = MemoryMap.END_RAM = 0x8000000 + memorySize - 1;
            MemoryMap.SIZE_RAM = MemoryMap.END_RAM - 0x8000000 + 1;
            if (!Memory.getInstance().allocate()) {
                log.error((Object)String.format("Failed to resize the PSP memory from 0x%X to 0x%X", previousMemorySize, memorySize));
                Emulator.PauseEmuWithStatus(12);
            }
            IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(-2013265920, kernelSize, 4);
            for (int i = 0; i < kernelSize32; ++i) {
                memoryWriter.writeNext(savedKernelMemory[i]);
            }
            memoryWriter.flush();
            this.reset(true);
        }
    }

    protected static String getTypeName(int type) {
        String typeName;
        switch (type) {
            case 0: {
                typeName = "PSP_SMEM_Low";
                break;
            }
            case 1: {
                typeName = "PSP_SMEM_High";
                break;
            }
            case 2: {
                typeName = "PSP_SMEM_Addr";
                break;
            }
            case 3: {
                typeName = "PSP_SMEM_LowAligned";
                break;
            }
            case 4: {
                typeName = "PSP_SMEM_HighAligned";
                break;
            }
            default: {
                typeName = "UNHANDLED " + type;
            }
        }
        return typeName;
    }

    private boolean isValidPartitionId(int partitionid) {
        return partitionid >= 0 && partitionid < freeMemoryChunks.length && freeMemoryChunks[partitionid] != null;
    }

    public SysMemInfo malloc(int partitionid, String name, int type, int size, int addr) {
        SysMemInfo sysMemInfo;
        if (freeMemoryChunks == null) {
            return null;
        }
        MemoryChunk allocatedMemoryChunk = null;
        int allocatedSize = 0;
        if (this.isValidPartitionId(partitionid)) {
            MemoryChunkList freeMemoryChunk = freeMemoryChunks[partitionid];
            int alignment = 255;
            allocatedSize = Utilities.alignUp(size, alignment);
            if (type == 3 || type == 4) {
                alignment = addr - 1;
            }
            switch (type) {
                case 0: 
                case 3: {
                    allocatedMemoryChunk = freeMemoryChunk.allocLow(allocatedSize, alignment);
                    break;
                }
                case 1: 
                case 4: {
                    allocatedMemoryChunk = freeMemoryChunk.allocHigh(allocatedSize, alignment);
                    break;
                }
                case 2: {
                    allocatedMemoryChunk = freeMemoryChunk.alloc(addr & 0x1FFFFFFF, allocatedSize);
                    break;
                }
                default: {
                    log.warn((Object)String.format("malloc: unknown type %s", SysMemUserForUser.getTypeName(type)));
                }
            }
        }
        if (allocatedMemoryChunk == null) {
            log.warn((Object)String.format("malloc cannot allocate partition=%d, name='%s', type=%s, size=0x%X, addr=0x%08X, maxFreeMem=0x%X, totalFreeMem=0x%X", partitionid, name, SysMemUserForUser.getTypeName(type), size, addr, this.maxFreeMemSize(partitionid), this.totalFreeMemSize(partitionid)));
            if (log.isTraceEnabled()) {
                log.trace((Object)("Free list: " + this.getDebugFreeMem()));
                log.trace((Object)("Allocated blocks:\n" + this.getDebugAllocatedMem() + "\n"));
            }
            sysMemInfo = null;
        } else {
            sysMemInfo = new SysMemInfo(partitionid, name, type, size, allocatedMemoryChunk.size, allocatedMemoryChunk.addr);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("malloc partition=%d, name='%s', type=%s, size=0x%X, addr=0x%08X: returns 0x%08X", partitionid, name, SysMemUserForUser.getTypeName(type), size, addr, allocatedMemoryChunk.addr));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Free list after malloc:\n" + this.getDebugFreeMem() + "\n"));
                    log.trace((Object)("Allocated blocks after malloc:\n" + this.getDebugAllocatedMem() + "\n"));
                }
            }
        }
        return sysMemInfo;
    }

    public String getDebugFreeMem() {
        StringBuilder s = new StringBuilder();
        s.append(String.format("partition=%d: ", 1));
        s.append(freeMemoryChunks[1].toString());
        s.append("\n");
        s.append(String.format("partition=%d: ", 2));
        s.append(freeMemoryChunks[2].toString());
        return s.toString();
    }

    public String getDebugAllocatedMem() {
        StringBuilder result = new StringBuilder();
        ArrayList<SysMemInfo> sortedBlockList = Collections.list(Collections.enumeration(blockList.values()));
        Collections.sort(sortedBlockList);
        for (SysMemInfo sysMemInfo : sortedBlockList) {
            if (result.length() > 0) {
                result.append("\n");
            }
            result.append(sysMemInfo.toString());
        }
        return result.toString();
    }

    private void free(int partitionId, int addr, int size) {
        MemoryChunk memoryChunk = new MemoryChunk(addr, size);
        freeMemoryChunks[partitionId].add(memoryChunk);
    }

    private int alloc(int partitionId, int addr, int size) {
        MemoryChunk allocatedMemoryChunk = freeMemoryChunks[partitionId].alloc(addr, size);
        if (allocatedMemoryChunk == null) {
            return 0;
        }
        return allocatedMemoryChunk.addr;
    }

    public void free(SysMemInfo info) {
        if (info != null) {
            info.free();
            this.free(info.partitionid, info.addr, info.allocatedSize);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("free %s", info.toString()));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Free list after free: " + this.getDebugFreeMem()));
                    log.trace((Object)("Allocated blocks after free:\n" + this.getDebugAllocatedMem() + "\n"));
                }
            }
        }
    }

    public int maxFreeMemSize(int partitionid) {
        int maxFreeMemSize = 0;
        if (this.isValidPartitionId(partitionid)) {
            MemoryChunk memoryChunk = freeMemoryChunks[partitionid].getLowMemoryChunk();
            while (memoryChunk != null) {
                if (memoryChunk.size > maxFreeMemSize) {
                    maxFreeMemSize = memoryChunk.size;
                }
                memoryChunk = memoryChunk.next;
            }
        }
        return maxFreeMemSize;
    }

    public int totalFreeMemSize(int partitionid) {
        int totalFreeMemSize = 0;
        if (this.isValidPartitionId(partitionid)) {
            MemoryChunk memoryChunk = freeMemoryChunks[partitionid].getLowMemoryChunk();
            while (memoryChunk != null) {
                totalFreeMemSize += memoryChunk.size;
                memoryChunk = memoryChunk.next;
            }
        }
        return totalFreeMemSize;
    }

    public SysMemInfo getSysMemInfo(int uid) {
        return blockList.get(uid);
    }

    public SysMemInfo getSysMemInfoByAddress(int address) {
        for (SysMemInfo info : blockList.values()) {
            if (address < info.addr || address >= info.addr + info.size) continue;
            return info;
        }
        return null;
    }

    public SysMemInfo separateMemoryBlock(SysMemInfo info, int size) {
        int newAddr = info.addr + size;
        int newSize = info.size - size;
        int newAllocatedSize = info.allocatedSize - size;
        SysMemInfo newSysMemInfo = new SysMemInfo(info.partitionid, info.name, info.type, newSize, newAllocatedSize, newAddr);
        info.size -= newSize;
        info.allocatedSize -= newAllocatedSize;
        return newSysMemInfo;
    }

    public boolean resizeMemoryBlock(SysMemInfo info, int leftShift, int rightShift) {
        int extendAddr;
        int sizeToExtend;
        int sizeToFree;
        if (rightShift < 0) {
            sizeToFree = -rightShift;
            this.free(info.partitionid, info.addr + info.allocatedSize - sizeToFree, sizeToFree);
            info.allocatedSize -= sizeToFree;
            info.size -= sizeToFree;
        } else if (rightShift > 0) {
            sizeToExtend = rightShift;
            extendAddr = this.alloc(info.partitionid, info.addr + info.allocatedSize, sizeToExtend);
            if (extendAddr == 0) {
                return false;
            }
            info.allocatedSize += sizeToExtend;
            info.size += sizeToExtend;
        }
        if (leftShift < 0) {
            sizeToFree = -leftShift;
            this.free(info.partitionid, info.addr, sizeToFree);
            info.addr += sizeToFree;
            info.size -= sizeToFree;
            info.allocatedSize -= sizeToFree;
        } else if (leftShift > 0) {
            sizeToExtend = leftShift;
            extendAddr = this.alloc(info.partitionid, info.addr - sizeToExtend, sizeToExtend);
            if (extendAddr == 0) {
                return false;
            }
            info.addr -= sizeToExtend;
            info.allocatedSize += sizeToExtend;
            info.size += sizeToExtend;
        }
        return true;
    }

    public void setFirmwareVersion(int firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public int getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void dumpSysMemInfo() {
        int i;
        int MEMORY_SIZE = 0x1800000;
        int SLOT_COUNT = 64;
        int SLOT_SIZE = 393216;
        boolean[] allocated = new boolean[64];
        boolean[] fragmented = new boolean[64];
        int allocatedSize = 0;
        int fragmentedSize = 0;
        for (SysMemInfo info : blockList.values()) {
            for (i = info.addr; i < info.addr + info.size; i += 393216) {
                if (i < 0x8800000 || i >= 0xA000000) continue;
                allocated[(i - 0x8800000) / 393216] = true;
            }
            allocatedSize += info.size;
        }
        MemoryChunk memoryChunk = freeMemoryChunks[2].getLowMemoryChunk();
        while (memoryChunk != null) {
            for (int i2 = memoryChunk.addr; i2 < memoryChunk.addr + memoryChunk.size; i2 += 393216) {
                if (i2 < 0x8800000 || i2 >= 0xA000000) continue;
                fragmented[(i2 - 0x8800000) / 393216] = true;
            }
            fragmentedSize += memoryChunk.size;
            memoryChunk = memoryChunk.next;
        }
        StringBuilder allocatedDiagram = new StringBuilder();
        allocatedDiagram.append("[");
        for (int i3 = 0; i3 < 64; ++i3) {
            allocatedDiagram.append(allocated[i3] ? "X" : " ");
        }
        allocatedDiagram.append("]");
        StringBuilder fragmentedDiagram = new StringBuilder();
        fragmentedDiagram.append("[");
        for (i = 0; i < 64; ++i) {
            fragmentedDiagram.append(fragmented[i] ? "X" : " ");
        }
        fragmentedDiagram.append("]");
        DumpDebugState.log("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        DumpDebugState.log(String.format("Allocated memory:  %08X %d bytes", allocatedSize, allocatedSize));
        DumpDebugState.log(allocatedDiagram.toString());
        DumpDebugState.log(String.format("Fragmented memory: %08X %d bytes", fragmentedSize, fragmentedSize));
        DumpDebugState.log(fragmentedDiagram.toString());
        DumpDebugState.log("Free list: " + this.getDebugFreeMem());
        DumpDebugState.log("Allocated blocks:\n" + this.getDebugAllocatedMem() + "\n");
    }

    public String hleKernelSprintf(CpuState cpu, String format, Object[] formatParameters) {
        String formattedMsg = format;
        try {
            String javaMsg = format;
            javaMsg = javaMsg.replaceAll("\\%(\\d*)l?l?[uid]", "%$1d");
            javaMsg = javaMsg.replaceAll("\\%(\\d*)l?l?([xX])", "%$1$2");
            javaMsg = javaMsg.replaceAll("\\%p", "%08X");
            int index = -1;
            for (int parameterIndex = 0; parameterIndex < formatParameters.length && (index = javaMsg.indexOf(37, index + 1)) >= 0; ++parameterIndex) {
                String parameterFormat = javaMsg.substring(index);
                if (!parameterFormat.startsWith("%s")) continue;
                int address = (Integer)formatParameters[parameterIndex];
                formatParameters[parameterIndex] = address == 0 ? "(null)" : Utilities.readStringZ(address);
            }
            formattedMsg = String.format(javaMsg, formatParameters);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return formattedMsg;
    }

    public String hleKernelSprintf(CpuState cpu, String format, int firstRegister) {
        int registerParameters = 11 - firstRegister + 1;
        Object[] formatParameters = new Object[registerParameters + 10];
        for (int i = 0; i < registerParameters; ++i) {
            formatParameters[i] = cpu.getRegister(firstRegister + i);
        }
        Memory mem = Memory.getInstance();
        for (int i = registerParameters; i < formatParameters.length; ++i) {
            formatParameters[i] = mem.read32(cpu._sp + (i - registerParameters << 2));
        }
        return this.hleKernelSprintf(cpu, format, formatParameters);
    }

    public int hleKernelPrintf(CpuState cpu, PspString formatString, Logger logger) {
        if (logger.isInfoEnabled()) {
            String formattedMsg = this.hleKernelSprintf(cpu, formatString.getString(), 5);
            logger.info((Object)formattedMsg);
        }
        return 0;
    }

    public int hleKernelGetCompiledSdkVersion() {
        return this.compiledSdkVersion;
    }

    protected void hleSetCompiledSdkVersion(int sdkVersion) {
        this.compiledSdkVersion = sdkVersion;
    }

    public int hleKernelGetCompilerVersion() {
        return this.compilerVersion;
    }

    @HLEFunction(nid=-1567493881, version=150)
    public int sceKernelMaxFreeMemSize() {
        int maxFreeMemSize = this.maxFreeMemSize(2);
        maxFreeMemSize &= 0xFFFFFFF0;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelMaxFreeMemSize returning %d(hex=0x%1$X)", maxFreeMemSize));
        }
        return maxFreeMemSize;
    }

    @HLEFunction(nid=-115739096, version=150)
    public int sceKernelTotalFreeMemSize() {
        int totalFreeMemSize = this.totalFreeMemSize(2);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelTotalFreeMemSize returning %d(hex=0x%1$X)", totalFreeMemSize));
        }
        return totalFreeMemSize;
    }

    @HLEFunctions(value={@HLEFunction(nid=595443023, version=150), @HLEFunction(nid=1901645438, version=660)})
    public int sceKernelAllocPartitionMemory(int partitionid, String name, int type, int size, int addr) {
        addr &= 0x1FFFFFFF;
        if (type < 0 || type > 4) {
            return -2147352360;
        }
        SysMemInfo info = this.malloc(partitionid, name, type, size, addr);
        if (info == null) {
            return -2147352359;
        }
        return info.uid;
    }

    @HLEFunctions(value={@HLEFunction(nid=-1227481854, version=150), @HLEFunction(nid=-1046320017, version=660)})
    public int sceKernelFreePartitionMemory(int uid) {
        SceUidManager.checkUidPurpose(uid, "SysMem", true);
        SysMemInfo info = blockList.remove(uid);
        if (info == null) {
            log.warn((Object)String.format("sceKernelFreePartitionMemory unknown uid=0x%X", uid));
            return -2147352354;
        }
        this.free(info);
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=-1650828383, version=150), @HLEFunction(nid=-248880393, version=660)})
    public int sceKernelGetBlockHeadAddr(int uid) {
        SceUidManager.checkUidPurpose(uid, "SysMem", true);
        SysMemInfo info = blockList.get(uid);
        if (info == null) {
            log.warn((Object)String.format("sceKernelGetBlockHeadAddr unknown uid=0x%X", uid));
            return -2147352354;
        }
        return info.addr;
    }

    @HLEFunction(nid=329624559, version=150)
    public int sceKernelPrintf(CpuState cpu, PspString formatString) {
        return this.hleKernelPrintf(cpu, formatString, stdout);
    }

    @HLEFunctions(value={@HLEFunction(nid=1070181994, version=150), @HLEFunction(nid=-930696855, version=660)})
    public int sceKernelDevkitVersion() {
        int major = this.firmwareVersion / 100;
        int minor = this.firmwareVersion / 10 % 10;
        int revision = this.firmwareVersion % 10;
        int devkitVersion = major << 24 | minor << 16 | revision << 8 | 0x10;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelDevkitVersion returning 0x%08X", devkitVersion));
        }
        return devkitVersion;
    }

    @HLEFunction(nid=-656516066, version=150)
    public int SysMemUserForUser_D8DE5C1E() {
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=-65976973, version=200), @HLEFunction(nid=-1259336523, version=660)})
    public int sceKernelGetCompiledSdkVersion() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelGetCompiledSdkVersion returning 0x%08X", this.compiledSdkVersion));
        }
        return this.compiledSdkVersion;
    }

    @HLEFunctions(value={@HLEFunction(nid=1972488155, version=200), @HLEFunction(nid=874537445, version=370), @HLEFunction(nid=828036000, version=380), @HLEFunction(nid=-338312218, version=395), @HLEFunction(nid=-1847708612, version=500), @HLEFunction(nid=2022963098, version=507), @HLEFunction(nid=895917388, version=600), @HLEFunction(nid=457316284, version=603), @HLEFunction(nid=898408891, version=606)})
    public int sceKernelSetCompiledSdkVersion(int sdkVersion) {
        this.hleSetCompiledSdkVersion(sdkVersion);
        return 0;
    }

    @HLEFunction(nid=-142772277, version=200)
    public int sceKernelSetCompilerVersion(int compilerVersion) {
        this.compilerVersion = compilerVersion;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1501262344, version=200)
    public int SysMemUserForUser_A6848DF8() {
        return 0;
    }

    @HLEFunction(nid=708727424, version=280)
    public int sceKernelQueryMemoryInfo(int address, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 partitionId, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 memoryBlockId) {
        int result = -2147352365;
        for (Integer key : blockList.keySet()) {
            SysMemInfo info = blockList.get(key);
            if (info == null || info.addr > address || address >= info.addr + info.size) continue;
            partitionId.setValue(info.partitionid);
            memoryBlockId.setValue(info.uid);
            result = 0;
            break;
        }
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=972330512, version=280)
    public int sceKernelGetPTRIG() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1647421213, version=280)
    public int sceKernelSetPTRIG() {
        return 0;
    }

    @HLEFunction(nid=1358306698, version=352)
    public int SysMemUserForUser_50F61D8A(int uid) {
        SysMemInfo info = blockList.remove(uid);
        if (info == null) {
            log.warn((Object)("SysMemUserForUser_50F61D8A(uid=0x" + Integer.toHexString(uid) + ") unknown uid"));
            return -2147352373;
        }
        this.free(info);
        return 0;
    }

    @HLEFunction(nid=-1396864822, version=352)
    public int sceKernelTotalMemSize() {
        return MemoryMap.SIZE_RAM;
    }

    @HLEFunction(nid=-612128430, version=352)
    public int SysMemUserForUser_DB83A952(int uid, TPointer32 addr) {
        SysMemInfo info = blockList.get(uid);
        if (info == null) {
            log.warn((Object)String.format("SysMemUserForUser_DB83A952 uid=0x%X, addr=%s: unknown uid", uid, addr));
            return -2147352373;
        }
        addr.setValue(info.addr);
        return 0;
    }

    @HLEFunction(nid=-26181665, version=352)
    public int SysMemUserForUser_FE707FDF(@StringInfo(maxLength=32) PspString name, int type, int size, @CanBeNull TPointer paramsAddr) {
        int length;
        if (paramsAddr.isNotNull() && (length = paramsAddr.getValue32()) != 4) {
            log.warn((Object)String.format("SysMemUserForUser_FE707FDF: unknown parameters with length=%d", length));
        }
        if (type < 0 || type > 1) {
            return -2147352360;
        }
        SysMemInfo info = this.malloc(2, name.getString(), type, size, 0);
        if (info == null) {
            return -2147352359;
        }
        return info.uid;
    }

    public static class SysMemInfo
    implements Comparable<SysMemInfo> {
        public final int uid;
        public final int partitionid;
        public final String name;
        public final int type;
        public int size;
        public int allocatedSize;
        public int addr;

        public SysMemInfo(int partitionid, String name, int type, int size, int allocatedSize, int addr) {
            this.partitionid = partitionid;
            this.name = name;
            this.type = type;
            this.size = size;
            this.allocatedSize = allocatedSize;
            this.addr = addr;
            this.uid = SceUidManager.getNewUid("SysMem");
            blockList.put(this.uid, this);
        }

        public String toString() {
            return String.format("SysMemInfo[addr=0x%08X-0x%08X, uid=0x%X, partition=%d, name='%s', type=%s, size=0x%X (allocated=0x%X)]", this.addr, this.addr + this.allocatedSize, this.uid, this.partitionid, this.name, SysMemUserForUser.getTypeName(this.type), this.size, this.allocatedSize);
        }

        public void free() {
            blockList.remove(this.uid);
        }

        @Override
        public int compareTo(SysMemInfo o) {
            if (this.addr == o.addr) {
                log.warn((Object)("Set invariant broken for SysMemInfo " + this));
                return 0;
            }
            return this.addr < o.addr ? -1 : 1;
        }
    }
}

