/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.pspFileBuffer;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.HLE.modules.sceAudiocodec;
import jpcsp.Memory;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceAac
extends HLEModule {
    public static Logger log = Modules.getLogger("sceAac");
    protected SysMemUserForUser.SysMemInfo resourceMem;
    protected AacInfo[] ids;

    @Override
    public void start() {
        this.ids = null;
        super.start();
    }

    public int checkId(int id) {
        if (this.ids == null || this.ids.length == 0) {
            throw new SceKernelErrorException(-2140596989);
        }
        if (id < 0 || id >= this.ids.length) {
            throw new SceKernelErrorException(-2140598271);
        }
        return id;
    }

    public int checkInitId(int id) {
        if (!this.ids[id = this.checkId(id)].isInit()) {
            throw new SceKernelErrorException(-2140598013);
        }
        return id;
    }

    public int getFreeAacId() {
        int id = -1;
        for (int i = 0; i < this.ids.length; ++i) {
            if (this.ids[i].isInit()) continue;
            id = i;
            break;
        }
        if (id < 0) {
            return -2140597759;
        }
        return id;
    }

    public AacInfo getAacInfo(int id) {
        return this.ids[id];
    }

    public void hleAacInit(int numberIds) {
        this.ids = new AacInfo[numberIds];
        for (int i = 0; i < numberIds; ++i) {
            this.ids[i] = new AacInfo(i);
        }
    }

    @HLEFunction(nid=-523724086, version=395)
    public int sceAacInit(@CanBeNull TPointer parameters, int unknown1, int unknown2, int unknown3) {
        if (parameters.isNull()) {
            return -2140598270;
        }
        long startPos = parameters.getValue64(0);
        long endPos = parameters.getValue64(8);
        int bufferAddr = parameters.getValue32(16);
        int bufferSize = parameters.getValue32(20);
        int outputAddr = parameters.getValue32(24);
        int outputSize = parameters.getValue32(28);
        int freq = parameters.getValue32(32);
        int reserved = parameters.getValue32(36);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAacInit parameters: startPos=0x%X, endPos=0x%X, bufferAddr=0x%08X, bufferSize=0x%X, outputAddr=0x%08X, outputSize=0x%X, freq=%d, reserved=0x%08X", startPos, endPos, bufferAddr, bufferSize, outputAddr, outputSize, freq, reserved));
        }
        if (bufferAddr == 0 || outputAddr == 0) {
            return -2140598270;
        }
        if (startPos < 0L || startPos > endPos) {
            return -2140598269;
        }
        if (bufferSize < 8192 || outputSize < 8192 || reserved != 0) {
            return -2140598269;
        }
        if (freq != 44100 && freq != 32000 && freq != 48000 && freq != 24000) {
            return -2140598269;
        }
        int id = this.getFreeAacId();
        if (id < 0) {
            return id;
        }
        this.ids[id].init(bufferAddr, bufferSize, outputAddr, outputSize, startPos, endPos);
        return id;
    }

    @HLEFunction(nid=867745801, version=395)
    public int sceAacExit(@CheckArgument(value="checkId") int id) {
        this.getAacInfo(id).release();
        return 0;
    }

    @HLEFunction(nid=1560266108, version=395)
    public int sceAacInitResource(int numberIds) {
        int memSize = numberIds * 102400;
        this.resourceMem = Modules.SysMemUserForUserModule.malloc(2, "SceLibAacResource", 0, memSize, 0);
        if (this.resourceMem == null) {
            return -2140596991;
        }
        Memory.getInstance().memset(this.resourceMem.addr, (byte)0, memSize);
        this.hleAacInit(numberIds);
        return 0;
    }

    @HLEFunction(nid=601054382, version=395)
    public int sceAacTermResource() {
        if (this.resourceMem != null) {
            Modules.SysMemUserForUserModule.free(this.resourceMem);
            this.resourceMem = null;
        }
        return 0;
    }

    @HLEFunction(nid=2118975204, version=395)
    public int sceAacDecode(@CheckArgument(value="checkInitId") int id, @CanBeNull TPointer32 bufferAddress) {
        int result = this.getAacInfo(id).decode(bufferAddress);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAacDecode bufferAddress=%s(0x%08X) returning 0x%X", bufferAddress, bufferAddress.getValue(), result));
        }
        if (result >= 0) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(2300, false);
        }
        return result;
    }

    @HLEFunction(nid=1379092441, version=395)
    public int sceAacGetLoopNum(@CheckArgument(value="checkInitId") int id) {
        return this.getAacInfo(id).getLoopNum();
    }

    @HLEFunction(nid=-1143118845, version=395)
    public int sceAacSetLoopNum(@CheckArgument(value="checkInitId") int id, int loopNum) {
        this.getAacInfo(id).setLoopNum(loopNum);
        return 0;
    }

    @HLEFunction(nid=-674949823, version=395)
    public boolean sceAacCheckStreamDataNeeded(@CheckArgument(value="checkInitId") int id) {
        return this.getAacInfo(id).isStreamDataNeeded();
    }

    @HLEFunction(nid=-1402090525, version=395)
    public int sceAacNotifyAddStreamData(@CheckArgument(value="checkInitId") int id, int bytesToAdd) {
        return this.getAacInfo(id).notifyAddStream(bytesToAdd);
    }

    @HLEFunction(nid=34180201, version=395)
    public int sceAacGetInfoToAddStreamData(@CheckArgument(value="checkInitId") int id, @CanBeNull TPointer32 writeAddr, @CanBeNull TPointer32 writableBytesAddr, @CanBeNull TPointer32 readOffsetAddr) {
        AacInfo info = this.getAacInfo(id);
        writeAddr.setValue(info.getInputBuffer().getWriteAddr());
        writableBytesAddr.setValue(info.getWritableBytes());
        readOffsetAddr.setValue(info.getInputBuffer().getFilePosition());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAacGetInfoToAddStreamData returning writeAddr=0x%08X, writableBytes=0x%X, readOffset=0x%X", writeAddr.getValue(), writableBytesAddr.getValue(), readOffsetAddr.getValue()));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1841788298, version=395)
    public int sceAacGetMaxOutputSample(@CheckArgument(value="checkInitId") int id) {
        return 0;
    }

    @HLEFunction(nid=1349252716, version=395)
    public int sceAacGetSumDecodedSample(@CheckArgument(value="checkInitId") int id) {
        int sumDecodedSamples = this.getAacInfo(id).getSumDecodedSamples();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAacGetSumDecodedSample returning 0x%X", sumDecodedSamples));
        }
        return sumDecodedSamples;
    }

    @HLEFunction(nid=-757453894, version=395)
    public int sceAacResetPlayPosition(@CheckArgument(value="checkInitId") int id) {
        return this.getAacInfo(id).resetPlayPosition();
    }

    public static class AacInfo
    extends sceAudiocodec.AudiocodecInfo {
        private static final int reservedBufferSize = 1600;
        private static final int minimumInputBufferSize = 1600;
        private boolean init;
        private pspFileBuffer inputBuffer;
        private int bufferAddr;
        private int outputAddr;
        private int outputSize;
        private int sumDecodedSamples;
        private int halfBufferSize;
        private int outputIndex;
        private int loopNum;
        private int startPos;

        protected AacInfo(int id) {
            super(id);
        }

        public boolean isInit() {
            return this.init;
        }

        public void init(int bufferAddr, int bufferSize, int outputAddr, int outputSize, long startPos, long endPos) {
            this.bufferAddr = bufferAddr;
            this.outputAddr = outputAddr;
            this.outputSize = outputSize;
            this.startPos = (int)startPos;
            this.inputBuffer = new pspFileBuffer(bufferAddr + 1600, bufferSize - 1600, 0, this.startPos);
            this.inputBuffer.setFileMaxSize((int)endPos);
            this.loopNum = -1;
            this.initCodec();
            this.halfBufferSize = bufferSize - 1600 >> 1;
        }

        public void initCodec() {
            this.initCodec(4099);
            this.init = true;
            this.codec.init(0, this.outputChannels, this.outputChannels, 0);
            this.setCodecInitialized();
        }

        @Override
        public void release() {
            super.release();
            this.init = false;
        }

        public int notifyAddStream(int bytesToAdd) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("notifyAddStream: %s", Utilities.getMemoryDump(this.inputBuffer.getWriteAddr(), bytesToAdd)));
            }
            this.inputBuffer.notifyWrite(bytesToAdd);
            return 0;
        }

        public pspFileBuffer getInputBuffer() {
            return this.inputBuffer;
        }

        public boolean isStreamDataNeeded() {
            int writeSize = this.inputBuffer.getWriteSize();
            if (writeSize <= 0) {
                return false;
            }
            if (writeSize >= this.halfBufferSize) {
                return true;
            }
            return writeSize >= this.inputBuffer.getFileWriteSize();
        }

        public int getSumDecodedSamples() {
            return this.sumDecodedSamples;
        }

        public int decode(TPointer32 outputBufferAddress) {
            int result;
            int decodeOutputAddr = this.outputAddr + this.outputIndex;
            if (this.inputBuffer.isFileEnd() && this.inputBuffer.getCurrentSize() <= 0) {
                int outputBytes = this.codec.getNumberOfSamples() * 4;
                Memory mem = Memory.getInstance();
                mem.memset(decodeOutputAddr, (byte)0, outputBytes);
                result = outputBytes;
            } else if (this.inputBuffer.getCurrentSize() <= 0) {
                int outputBytes = this.outputSize >> 1;
                Memory mem = Memory.getInstance();
                mem.memset(decodeOutputAddr, (byte)0, outputBytes);
                result = outputBytes;
            } else {
                int decodeInputAddr = this.inputBuffer.getReadAddr();
                int decodeInputLength = this.inputBuffer.getReadSize();
                if (decodeInputLength < 1600 && decodeInputLength < this.inputBuffer.getCurrentSize()) {
                    Memory mem = Memory.getInstance();
                    mem.memcpy(this.bufferAddr, decodeInputAddr, decodeInputLength);
                    int wrapLength = Math.min(this.inputBuffer.getCurrentSize(), 1600) - decodeInputLength;
                    mem.memcpy(this.bufferAddr + decodeInputLength, this.inputBuffer.getAddr(), wrapLength);
                    decodeInputAddr = this.bufferAddr;
                    decodeInputLength += wrapLength;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Decoding from 0x%08X, length=0x%X to 0x%08X", decodeInputAddr, decodeInputLength, decodeOutputAddr));
                }
                if ((result = this.codec.decode(outputBufferAddress.getMemory(), decodeInputAddr, decodeInputLength, outputBufferAddress.getMemory(), decodeOutputAddr)) < 0) {
                    result = -2140597247;
                } else {
                    int readSize = result;
                    int samples = this.codec.getNumberOfSamples();
                    int outputBytes = samples * 4;
                    this.inputBuffer.notifyRead(readSize);
                    this.sumDecodedSamples += samples;
                    this.outputIndex += outputBytes;
                    if (this.outputIndex + outputBytes > this.outputSize) {
                        this.outputIndex = 0;
                    }
                    result = outputBytes;
                }
                if (this.inputBuffer.getCurrentSize() < 1600 && this.inputBuffer.isFileEnd() && this.loopNum != 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Looping loopNum=%d", this.loopNum));
                    }
                    if (this.loopNum > 0) {
                        --this.loopNum;
                    }
                    this.resetPlayPosition();
                }
            }
            outputBufferAddress.setValue(decodeOutputAddr);
            return result;
        }

        public int getWritableBytes() {
            int writeSize = this.inputBuffer.getWriteSize();
            if (writeSize >= 2 * this.halfBufferSize) {
                return 2 * this.halfBufferSize;
            }
            if (writeSize >= this.halfBufferSize) {
                return this.halfBufferSize;
            }
            if (writeSize >= this.inputBuffer.getFileWriteSize()) {
                return this.halfBufferSize;
            }
            return 0;
        }

        public int getLoopNum() {
            return this.loopNum;
        }

        public void setLoopNum(int loopNum) {
            this.loopNum = loopNum;
        }

        public int resetPlayPosition() {
            this.inputBuffer.reset(0, this.startPos);
            this.sumDecodedSamples = 0;
            return 0;
        }
    }
}

