/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.HashMap;
import java.util.Map;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.Memory;
import jpcsp.media.codec.CodecFactory;
import jpcsp.media.codec.ICodec;
import jpcsp.media.codec.mp3.Mp3Decoder;
import jpcsp.media.codec.mp3.Mp3Header;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceAudiocodec
extends HLEModule {
    public static Logger log = Modules.getLogger("sceAudiocodec");
    public static final int audiocodecBufferSize = 108;
    public static final int PSP_CODEC_AT3PLUS = 4096;
    public static final int PSP_CODEC_AT3 = 4097;
    public static final int PSP_CODEC_MP3 = 4098;
    public static final int PSP_CODEC_AAC = 4099;
    public static final int PSP_CODEC_WMA = 4101;
    public static final int AUDIOCODEC_AT3P_UNKNOWN_52 = 44100;
    public static final int AUDIOCODEC_AT3P_UNKNOWN_60 = 2;
    public static final int AUDIOCODEC_AT3P_UNKNOWN_64 = 744;
    private Map<Integer, AudiocodecInfo> infos;
    private SysMemUserForUser.SysMemInfo edramInfo;

    @Override
    public void start() {
        this.infos = new HashMap<Integer, AudiocodecInfo>();
        this.edramInfo = null;
        super.start();
    }

    private int hleAudiocodecInit(TPointer workArea, int codecType, int outputChannels) {
        AudiocodecInfo info = this.infos.remove(workArea.getAddress());
        if (info != null) {
            info.release();
            info = null;
        }
        switch (codecType) {
            case 4096: 
            case 4097: 
            case 4098: 
            case 4099: {
                break;
            }
            default: {
                log.warn((Object)String.format("sceAudiocodecInit unimplemented codecType=0x%X", codecType));
                return -1;
            }
        }
        info = new AudiocodecInfo(workArea.getAddress());
        info.outputChannels = outputChannels;
        info.initCodec(codecType);
        this.infos.put(workArea.getAddress(), info);
        workArea.setValue32(8, 0);
        return 0;
    }

    public void initCodec(int id, int codecType, int inputBufferSize, int channels, int outputChannels, int codingMode) {
        AudiocodecInfo info = this.infos.remove(id);
        if (info != null) {
            info.release();
        }
        info = new AudiocodecInfo(id);
        info.outputChannels = outputChannels;
        info.initCodec(codecType);
        this.infos.put(id, info);
        ICodec codec = info.getCodec();
        codec.init(inputBufferSize, channels, info.outputChannels, codingMode);
        info.setCodecInitialized();
    }

    public ICodec getCodec(int id) {
        AudiocodecInfo info = this.infos.get(id);
        if (info == null) {
            return null;
        }
        return info.getCodec();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1656784628, version=150)
    public int sceAudiocodecCheckNeedMem(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=108, usage=BufferInfo.Usage.inout) TPointer workArea, int codecType) {
        workArea.setValue32(0, 84936193);
        switch (codecType) {
            case 4097: {
                workArea.setValue32(16, 15840);
                break;
            }
            case 4096: {
                workArea.setValue32(16, 31680);
                workArea.setValue32(52, 44100);
                workArea.setValue32(60, 2);
                workArea.setValue32(64, 744);
                break;
            }
            case 4098: {
                break;
            }
            case 4099: {
                workArea.setValue32(16, 25996);
            }
        }
        return 0;
    }

    @HLEFunction(nid=1530391325, version=150)
    public int sceAudiocodecInit(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=108, usage=BufferInfo.Usage.inout) TPointer workArea, int codecType) {
        return this.hleAudiocodecInit(workArea, codecType, 2);
    }

    public static int getOutputBufferSize(TPointer workArea, int codecType) {
        int outputBufferSize;
        switch (codecType) {
            case 4096: {
                if (workArea.getValue32(56) == 1 && workArea.getValue32(72) != workArea.getValue32(56)) {
                    outputBufferSize = 8192;
                    break;
                }
                outputBufferSize = workArea.getValue32(72) << 12;
                break;
            }
            case 4097: {
                outputBufferSize = 4096;
                break;
            }
            case 4098: {
                if (workArea.getValue32(56) == 1) {
                    outputBufferSize = 4608;
                    break;
                }
                outputBufferSize = 2304;
                break;
            }
            case 4099: {
                if (workArea.getValue8(45) == 0) {
                    outputBufferSize = 4096;
                    break;
                }
                outputBufferSize = 8192;
                break;
            }
            case 4100: {
                outputBufferSize = 4608;
                break;
            }
            default: {
                outputBufferSize = 4096;
            }
        }
        return outputBufferSize;
    }

    @HLEFunction(nid=1889993720, version=150)
    public int sceAudiocodecDecode(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=108, usage=BufferInfo.Usage.inout) TPointer workArea, int codecType) {
        Mp3Header mp3Header;
        int inputBufferSize;
        workArea.setValue32(8, 0);
        AudiocodecInfo info = this.infos.get(workArea.getAddress());
        if (info == null) {
            log.warn((Object)String.format("sceAudiocodecDecode no info available for workArea=%s", workArea));
            return -1;
        }
        int inputBuffer = workArea.getValue32(24);
        int outputBuffer = workArea.getValue32(32);
        int unknown1 = workArea.getValue32(40);
        int codingMode = 0;
        int channels = info.outputChannels;
        block0 : switch (codecType) {
            case 4096: {
                int audioFrameLength;
                inputBufferSize = workArea.getValue32(48) == 0 ? workArea.getValue32(64) + 2 : 4106;
                Memory mem = workArea.getMemory();
                if (mem.read8(inputBuffer) != 15 || mem.read8(inputBuffer + 1) != 208) break;
                int frameHeader23 = mem.read8(inputBuffer + 2) << 8 | mem.read8(inputBuffer + 3);
                inputBufferSize = audioFrameLength = (frameHeader23 & 0x3FF) << 3;
                inputBuffer += 8;
                break;
            }
            case 4097: {
                switch (workArea.getValue32(40)) {
                    case 4: {
                        inputBufferSize = 384;
                        break block0;
                    }
                    case 6: {
                        inputBufferSize = 304;
                        break block0;
                    }
                    case 11: {
                        inputBufferSize = 192;
                        codingMode = 1;
                        break block0;
                    }
                    case 14: {
                        inputBufferSize = 192;
                        break block0;
                    }
                    case 15: {
                        inputBufferSize = 152;
                        channels = 1;
                        break block0;
                    }
                }
                log.warn((Object)String.format("sceAudiocodecDecode Atrac3 unknown value 0x%X at offset 40", workArea.getValue32(40)));
                inputBufferSize = 384;
                break;
            }
            case 4098: {
                inputBufferSize = workArea.getValue32(40);
                break;
            }
            case 4099: {
                if (workArea.getValue8(44) == 0) {
                    inputBufferSize = 1536;
                    break;
                }
                inputBufferSize = 1545;
                break;
            }
            case 4100: {
                inputBufferSize = workArea.getValue32(40);
                break;
            }
            default: {
                return -1;
            }
        }
        int outputBufferSize = sceAudiocodec.getOutputBufferSize(workArea, codecType);
        workArea.setValue32(36, outputBufferSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAudiocodecDecode inputBuffer=0x%08X, outputBuffer=0x%08X, inputBufferSize=0x%X, outputBufferSize=0x%X", inputBuffer, outputBuffer, inputBufferSize, outputBufferSize));
            log.debug((Object)String.format("sceAudiocodecDecode unknown1=0x%08X", unknown1));
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("sceAudiocodecDecode inputBuffer: %s", Utilities.getMemoryDump(inputBuffer, inputBufferSize)));
            }
        }
        ICodec codec = info.getCodec();
        if (!info.isCodecInitialized()) {
            codec.init(inputBufferSize, channels, info.outputChannels, codingMode);
            info.setCodecInitialized();
        }
        if (codec == null) {
            log.warn((Object)String.format("sceAudiocodecDecode no codec available for codecType=0x%X", codecType));
            return -1;
        }
        Memory mem = workArea.getMemory();
        int bytesConsumed = codec.decode(mem, inputBuffer, inputBufferSize, mem, outputBuffer);
        if (log.isDebugEnabled()) {
            if (bytesConsumed < 0) {
                log.debug((Object)String.format("codec.decode returned error 0x%08X, data: %s", bytesConsumed, Utilities.getMemoryDump(inputBuffer, inputBufferSize)));
            } else {
                log.debug((Object)String.format("sceAudiocodecDecode bytesConsumed=0x%X", bytesConsumed));
            }
        }
        if (codec instanceof Mp3Decoder && (mp3Header = ((Mp3Decoder)codec).getMp3Header()) != null) {
            workArea.setValue32(68, mp3Header.bitrateIndex);
            workArea.setValue32(72, mp3Header.rawSampleRateIndex);
            int type = mp3Header.mpeg25 != 0 ? 2 : (mp3Header.lsf != 0 ? 0 : 1);
            workArea.setValue32(56, type);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAudiocodecDecode MP3 bitrateIndex=%d, rawSampleRateIndex=%d, type=%d", mp3Header.bitrateIndex, mp3Header.rawSampleRateIndex, type));
            }
        }
        workArea.setValue32(28, bytesConsumed > 0 ? bytesConsumed : inputBufferSize);
        Modules.ThreadManForUserModule.hleKernelDelayThread(2300, false);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1966468651, version=150)
    public int sceAudiocodecGetInfo(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=108, usage=BufferInfo.Usage.inout) TPointer workArea, int codecType) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1494706703, version=150)
    public int sceAudiocodecAlcExtendParameter(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=108, usage=BufferInfo.Usage.inout) TPointer workArea, int codecType, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 sizeAddr) {
        int outputBufferSize = sceAudiocodec.getOutputBufferSize(workArea, codecType);
        sizeAddr.setValue(outputBufferSize);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=975217152, version=150)
    public int sceAudiocodecGetEDRAM(TPointer workArea, int codecType) {
        int neededMem = workArea.getValue32(16);
        this.edramInfo = Modules.SysMemUserForUserModule.malloc(1, "sceAudiocodec-EDRAM", 3, neededMem, 64);
        if (this.edramInfo == null) {
            return -1;
        }
        workArea.setValue32(12, this.edramInfo.addr);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=694686304, version=150)
    public int sceAudiocodecReleaseEDRAM(TPointer workArea) {
        if (this.edramInfo == null) {
            return -2139160572;
        }
        Modules.SysMemUserForUserModule.free(this.edramInfo);
        this.edramInfo = null;
        AudiocodecInfo info = this.infos.remove(workArea.getAddress());
        if (info != null) {
            info.release();
            info.setCodecInitialized(false);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1825744993, version=150)
    public int sceAudiocodec_6CD2A861() {
        return 0;
    }

    @HLEFunction(nid=1037561370, version=150)
    public int sceAudiocodec_3DD7EE1A(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=108, usage=BufferInfo.Usage.inout) TPointer workArea, int codecType) {
        return this.hleAudiocodecInit(workArea, codecType, 1);
    }

    public static class AudiocodecInfo {
        protected ICodec codec;
        protected boolean codecInitialized;
        protected final int id;
        protected int outputChannels = 2;

        protected AudiocodecInfo(int id) {
            this.id = id;
        }

        public ICodec getCodec() {
            return this.codec;
        }

        public boolean isCodecInitialized() {
            return this.codecInitialized;
        }

        public void setCodecInitialized(boolean codecInitialized) {
            this.codecInitialized = codecInitialized;
        }

        public void setCodecInitialized() {
            this.setCodecInitialized(true);
        }

        public void release() {
            this.setCodecInitialized(false);
        }

        public void initCodec(int codecType) {
            this.codec = CodecFactory.getCodec(codecType);
            this.setCodecInitialized(false);
        }
    }
}

