/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUidClass;
import jpcsp.HLE.HLEUidObjectMapping;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TErrorPointer32;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer16;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceFontInfo;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.pspCharInfo;
import jpcsp.HLE.kernel.types.pspFontStyle;
import jpcsp.HLE.modules.sceDisplay;
import jpcsp.Memory;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.format.BWFont;
import jpcsp.format.PGF;
import jpcsp.graphics.capture.CaptureImage;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.util.Debug;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceFont
extends HLEModule {
    public static Logger log = Modules.getLogger("sceFont");
    private static final boolean dumpUserFont = false;
    public static final int PGF_MAGIC = 1346848304;
    public static final String customFontFile = "debug.jpft";
    public static final int PSP_FONT_PIXELFORMAT_4 = 0;
    public static final int PSP_FONT_PIXELFORMAT_4_REV = 1;
    public static final int PSP_FONT_PIXELFORMAT_8 = 2;
    public static final int PSP_FONT_PIXELFORMAT_24 = 3;
    public static final int PSP_FONT_PIXELFORMAT_32 = 4;
    public static final int PSP_FONT_MODE_FILE = 0;
    public static final int PSP_FONT_MODE_MEMORY = 1;
    private boolean useDebugFont = false;
    private static final boolean dumpFonts = false;
    private List<Font> internalFonts;
    private HashMap<Integer, FontLib> fontLibsMap;
    private HashMap<Integer, Font> fontsMap;
    protected String uidPurpose = "sceFont";
    private String fontDirPath = "flash0:/font";
    private List<FontRegistryEntry> fontRegistry;
    protected static final float pointDPI = 72.0f;

    @Override
    public int getMemoryUsage() {
        return 32000;
    }

    @Override
    public void start() {
        this.setSettingsListener("emu.useDebugFont", new UseDebugFontSettingsListerner());
        this.internalFonts = new LinkedList<Font>();
        this.fontLibsMap = new HashMap();
        this.fontsMap = new HashMap();
        this.loadFontRegistry();
        this.loadDefaultSystemFont();
        super.start();
    }

    protected boolean getUseDebugFont() {
        return this.useDebugFont;
    }

    private void setUseDebugFont(boolean status) {
        this.useDebugFont = status;
    }

    public List<FontRegistryEntry> getFontRegistry() {
        return this.fontRegistry;
    }

    public String getFontDirPath() {
        return this.fontDirPath;
    }

    public void setFontDirPath(String fontDirPath) {
        this.fontDirPath = fontDirPath;
    }

    protected void loadFontRegistry() {
        this.fontRegistry = new LinkedList<FontRegistryEntry>();
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 1, 103, 0, 1, 0, 1, "jpn0.pgf", "FTT-NewRodin Pro DB", 0, 0, 1581700, 1204, 19, 20));
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 1, 1, 0, 2, 0, 1, "ltn0.pgf", "FTT-NewRodin Pro Latin", 0, 0, 69108, 1202, 23, 20));
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 2, 1, 0, 2, 0, 1, "ltn1.pgf", "FTT-Matisse Pro Latin", 0, 0, 65124, 1154, 23, 20));
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 1, 2, 0, 2, 0, 1, "ltn2.pgf", "FTT-NewRodin Pro Latin", 0, 0, 72948, 1202, 25, 20));
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 2, 2, 0, 2, 0, 1, "ltn3.pgf", "FTT-Matisse Pro Latin", 0, 0, 67700, 1154, 25, 20));
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 1, 5, 0, 2, 0, 1, "ltn4.pgf", "FTT-NewRodin Pro Latin", 0, 0, 72828, 1271, 24, 21));
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 2, 5, 0, 2, 0, 1, "ltn5.pgf", "FTT-Matisse Pro Latin", 0, 0, 68220, 1180, 24, 20));
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 1, 6, 0, 2, 0, 1, "ltn6.pgf", "FTT-NewRodin Pro Latin", 0, 0, 77032, 1271, 27, 21));
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 2, 6, 0, 2, 0, 1, "ltn7.pgf", "FTT-Matisse Pro Latin", 0, 0, 71144, 1180, 27, 20));
        this.fontRegistry.add(new FontRegistryEntry(448, 448, 8192, 8192, 0, 0, 1, 1, 0, 2, 0, 1, "ltn8.pgf", "FTT-NewRodin Pro Latin", 0, 0, 41000, 801, 16, 14));
        this.fontRegistry.add(new FontRegistryEntry(448, 448, 8192, 8192, 0, 0, 2, 1, 0, 2, 0, 1, "ltn9.pgf", "FTT-Matisse Pro Latin", 0, 0, 40164, 770, 16, 14));
        this.fontRegistry.add(new FontRegistryEntry(448, 448, 8192, 8192, 0, 0, 1, 2, 0, 2, 0, 1, "ltn10.pgf", "FTT-NewRodin Pro Latin", 0, 0, 42692, 801, 17, 14));
        this.fontRegistry.add(new FontRegistryEntry(448, 448, 8192, 8192, 0, 0, 2, 2, 0, 2, 0, 1, "ltn11.pgf", "FTT-Matisse Pro Latin", 0, 0, 41488, 770, 17, 14));
        this.fontRegistry.add(new FontRegistryEntry(448, 448, 8192, 8192, 0, 0, 1, 5, 0, 2, 0, 1, "ltn12.pgf", "FTT-NewRodin Pro Latin", 0, 0, 43136, 847, 17, 15));
        this.fontRegistry.add(new FontRegistryEntry(448, 448, 8192, 8192, 0, 0, 2, 5, 0, 2, 0, 1, "ltn13.pgf", "FTT-Matisse Pro Latin", 0, 0, 41772, 786, 17, 14));
        this.fontRegistry.add(new FontRegistryEntry(448, 448, 8192, 8192, 0, 0, 1, 6, 0, 2, 0, 1, "ltn14.pgf", "FTT-NewRodin Pro Latin", 0, 0, 45184, 847, 18, 15));
        this.fontRegistry.add(new FontRegistryEntry(448, 448, 8192, 8192, 0, 0, 2, 6, 0, 2, 0, 1, "ltn15.pgf", "FTT-Matisse Pro Latin", 0, 0, 43044, 786, 18, 14));
        this.fontRegistry.add(new FontRegistryEntry(648, 648, 8192, 8192, 0, 0, 1, 1, 0, 3, 0, 3, "kr0.pgf", "AsiaNHH(512Johab)", 0, 0, 394192, 971, 21, 20));
        if (Modules.IoFileMgrForUserModule.statFile(this.fontDirPath + "/gb3s1518.bwfon") != null) {
            this.fontRegistry.add(new FontRegistryEntry(1024, 1152, 0, 0, 0, 0, 0, 1, 0, 4, 0, 0, "gb3s1518.bwfon", "gb3s1518", 0, 0, 1023372, 0, 0, 0));
        }
    }

    protected void loadDefaultSystemFont() {
        try {
            SeekableDataInput fontFile = Modules.IoFileMgrForUserModule.getFile(this.fontDirPath + "/" + customFontFile, 1);
            if (fontFile != null) {
                fontFile.skipBytes(32);
                byte[] c = new byte[(int)fontFile.length() - 32];
                fontFile.readFully(c);
                fontFile.close();
                Debug.Font.setDebugFont(c);
                Debug.Font.setDebugCharSize(8);
                Debug.Font.setDebugCharHeight(8);
                Debug.Font.setDebugCharWidth(8);
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    protected void dumpFont(Font font) {
        int bufferWidth;
        int addr = 0x4000000;
        int fontPixelFormat = 4;
        int bufferStorage = 3;
        int fontBufWidth = bufferWidth = 800;
        int fontBpl = bufferWidth * sceDisplay.getPixelFormatBytes(bufferStorage);
        int fontBufHeight = 0x200000 / fontBpl;
        SceFontInfo fontInfo = font.fontInfo;
        PGF pgf = font.pgf;
        int memoryLength = fontBpl * fontBufHeight * sceDisplay.getPixelFormatBytes(bufferStorage);
        Memory mem = Memory.getInstance();
        mem.memset(addr, (byte)0, memoryLength);
        Buffer memoryBuffer = Memory.getInstance().getBuffer(addr, memoryLength);
        String fileNamePrefix = String.format("Font-%s-", pgf.getFileNamez());
        int maxGlyphWidth = pgf.getMaxSize()[0] >> 6;
        int maxGlyphHeight = pgf.getMaxSize()[1] >> 6;
        int level = 0;
        int x = 0;
        int y = 0;
        int firstCharCode = pgf.getFirstGlyphInCharMap();
        int lastCharCode = pgf.getLastGlyphInCharMap();
        for (int charCode = firstCharCode; charCode <= lastCharCode; ++charCode) {
            if (x == 0) {
                String linePrefix = String.format("0x%04X: ", charCode);
                Debug.printFramebuffer(addr, fontBufWidth, x, y, -1, 0, bufferStorage, linePrefix);
                x += linePrefix.length() * Debug.Font.charWidth;
            }
            fontInfo.printFont(addr, fontBpl, fontBufWidth, fontBufHeight, x, y, 0, 0, 0, 0, fontBufWidth, fontBufHeight, fontPixelFormat, charCode, 32, 0, true);
            if ((x += maxGlyphWidth) + maxGlyphWidth <= fontBufWidth) continue;
            x = 0;
            if ((y += maxGlyphHeight) + maxGlyphHeight <= fontBufHeight) continue;
            CaptureImage image = new CaptureImage(addr, level, memoryBuffer, fontBufWidth, fontBufHeight, bufferWidth, bufferStorage, false, 0, false, true, fileNamePrefix);
            log.info((Object)String.format("Dumping font %s from charCode 0x%04X to file %s", pgf.getFontName(), firstCharCode, image.getFileName()));
            try {
                image.write();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            mem.memset(addr, (byte)0, memoryLength);
            ++level;
            firstCharCode = charCode + 1;
            x = 0;
            y = 0;
        }
        CaptureImage image = new CaptureImage(addr, level, memoryBuffer, fontBufWidth, fontBufHeight, bufferWidth, bufferStorage, false, 0, false, true, fileNamePrefix);
        log.info((Object)String.format("Dumping font %s from charCode 0x%04X to file %s", pgf.getFontName(), firstCharCode, image.getFileName()));
        try {
            image.write();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    protected Font openFontFile(ByteBuffer pgfBuffer, String fileName) {
        Font font = null;
        try {
            PGF pgfFile = fileName != null && fileName.endsWith(".bwfon") ? new BWFont(pgfBuffer, fileName) : new PGF(pgfBuffer);
            if (fileName != null) {
                pgfFile.setFileNamez(fileName);
            }
            SceFontInfo fontInfo = pgfFile.createFontInfo();
            font = new Font(pgfFile, fontInfo, pgfBuffer.capacity());
        }
        catch (Exception e) {
            log.error((Object)"openFontFile", (Throwable)e);
        }
        return font;
    }

    protected Font openFontFile(String fileName) {
        Font font = null;
        try {
            SeekableDataInput fontFile = Modules.IoFileMgrForUserModule.getFile(fileName, 1);
            if (fontFile != null) {
                byte[] pgfBytes = new byte[(int)fontFile.length()];
                fontFile.readFully(pgfBytes);
                fontFile.close();
                ByteBuffer pgfBuffer = ByteBuffer.wrap(pgfBytes);
                font = this.openFontFile(pgfBuffer, new File(fileName).getName());
            }
        }
        catch (IOException e) {
            log.warn((Object)e);
        }
        return font;
    }

    protected Font openFontFile(int addr, int length) {
        ByteBuffer pgfBuffer = ByteBuffer.allocate(length);
        Buffer memBuffer = Memory.getInstance().getBuffer(addr, length);
        Utilities.putBuffer(pgfBuffer, memBuffer, ByteOrder.LITTLE_ENDIAN, length);
        pgfBuffer.rewind();
        Font font = this.openFontFile(pgfBuffer, null);
        return font;
    }

    protected void setFontAttributesFromRegistry(Font font, FontRegistryEntry fontRegistryEntry) {
        pspFontStyle fontStyle = new pspFontStyle();
        fontStyle.fontH = (float)fontRegistryEntry.h_size / 64.0f;
        fontStyle.fontV = (float)fontRegistryEntry.v_size / 64.0f;
        fontStyle.fontHRes = (float)fontRegistryEntry.h_resolution / 64.0f;
        fontStyle.fontVRes = (float)fontRegistryEntry.v_resolution / 64.0f;
        fontStyle.fontWeight = fontRegistryEntry.weight;
        fontStyle.fontFamily = (short)fontRegistryEntry.family_code;
        fontStyle.fontStyle = (short)fontRegistryEntry.style;
        fontStyle.fontStyleSub = (short)fontRegistryEntry.sub_style;
        fontStyle.fontLanguage = (short)fontRegistryEntry.language_code;
        fontStyle.fontRegion = (short)fontRegistryEntry.region_code;
        fontStyle.fontCountry = (short)fontRegistryEntry.country_code;
        fontStyle.fontName = fontRegistryEntry.font_name;
        fontStyle.fontFileName = fontRegistryEntry.file_name;
        fontStyle.fontAttributes = fontRegistryEntry.extra_attributes;
        fontStyle.fontExpire = fontRegistryEntry.expire_date;
        font.fontInfo.setFontStyle(fontStyle);
        font.fontFileSize = fontRegistryEntry.fontFileSize;
        font.maxGlyphBaseYI = fontRegistryEntry.maxGlyphBaseYI;
        font.maxBitmapWidth = fontRegistryEntry.maxBitmapWidth;
        font.maxBitmapHeight = fontRegistryEntry.maxBitmapHeight;
    }

    protected void setFontAttributesFromRegistry(Font font) {
        for (FontRegistryEntry fontRegistryEntry : this.fontRegistry) {
            if (!fontRegistryEntry.file_name.equals(font.pgf.getFileNamez()) || !fontRegistryEntry.font_name.equals(font.pgf.getFontName())) continue;
            this.setFontAttributesFromRegistry(font, fontRegistryEntry);
            break;
        }
    }

    protected void loadAllFonts() {
        this.internalFonts.clear();
        for (FontRegistryEntry fontRegistryEntry : this.fontRegistry) {
            Font font;
            String fontFileName = this.fontDirPath + "/" + fontRegistryEntry.file_name;
            SceIoStat stat = Modules.IoFileMgrForUserModule.statFile(fontFileName);
            if (stat == null || (font = this.openFontFile(fontFileName)) == null) continue;
            this.setFontAttributesFromRegistry(font, fontRegistryEntry);
            this.internalFonts.add(font);
            log.info((Object)String.format("Loading font file '%s'. Font='%s' Type='%s'", fontRegistryEntry.file_name, font.pgf.getFontName(), font.pgf.getFontType()));
        }
    }

    protected static short getFontStyle(String styleString) {
        if ("Regular".equals(styleString)) {
            return 1;
        }
        if ("Italic".equals(styleString)) {
            return 2;
        }
        if ("Bold".equals(styleString)) {
            return 5;
        }
        if ("Bold Italic".equals(styleString)) {
            return 6;
        }
        return 0;
    }

    private boolean isFontMatchingStyle(Font font, pspFontStyle fontStyle, boolean optimum) {
        if (font != null && font.fontInfo != null && font.fontInfo.getFontStyle() != null) {
            return font.fontInfo.getFontStyle().isMatching(fontStyle, optimum);
        }
        return true;
    }

    private Font getOptimiumFont(pspFontStyle fontStyle, Font optimumFont, Font matchingFont) {
        boolean testV;
        boolean testH;
        if (optimumFont == null) {
            return matchingFont;
        }
        pspFontStyle optimiumStyle = optimumFont.fontInfo.getFontStyle();
        pspFontStyle matchingStyle = matchingFont.fontInfo.getFontStyle();
        boolean bl = testH = fontStyle.fontH != 0.0f || fontStyle.fontV == 0.0f;
        if (testH && Math.abs(fontStyle.fontH - optimiumStyle.fontH) > Math.abs(fontStyle.fontH - matchingStyle.fontH)) {
            return matchingFont;
        }
        boolean bl2 = testV = fontStyle.fontV != 0.0f || fontStyle.fontH == 0.0f;
        if (testV && Math.abs(fontStyle.fontV - optimiumStyle.fontV) > Math.abs(fontStyle.fontV - matchingStyle.fontV)) {
            return matchingFont;
        }
        return optimumFont;
    }

    private Font getOptimumFont(pspFontStyle fontStyle) {
        Font optimumFont = null;
        for (int i = 0; i < this.internalFonts.size(); ++i) {
            Font font = this.internalFonts.get(i);
            if (!this.isFontMatchingStyle(font, fontStyle, true)) continue;
            optimumFont = this.getOptimiumFont(fontStyle, optimumFont, font);
        }
        return optimumFont;
    }

    private int getFontIndex(Font font) {
        if (font != null) {
            for (int i = 0; i < this.internalFonts.size(); ++i) {
                if (this.internalFonts.get(i) != font) continue;
                return i;
            }
        }
        return -1;
    }

    protected FontLib getFontLib(int fontLibHandle) {
        FontLib fontLib = this.fontLibsMap.get(fontLibHandle);
        if (fontLib == null) {
            throw new SceKernelErrorException(-2142896125);
        }
        return fontLib;
    }

    protected Font getFont(int fontHandle, boolean allowClosedFont) {
        Font font = this.fontsMap.get(fontHandle);
        if (font == null || font.fontInfo == null) {
            throw new SceKernelErrorException(-2142896125);
        }
        if (!allowClosedFont && font.isClosed()) {
            throw new SceKernelErrorException(-2142896125);
        }
        return font;
    }

    public Font getFont(int index) {
        if (this.internalFonts.size() == 0) {
            this.loadAllFonts();
        }
        return this.internalFonts.get(index);
    }

    @HLEFunction(nid=1743879895, version=150, checkInsideInterrupt=true, stackUsage=1424)
    public int sceFontNewLib(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=44, usage=BufferInfo.Usage.in) TPointer32 paramsPtr, @CanBeNull TErrorPointer32 errorCodePtr) {
        this.loadAllFonts();
        errorCodePtr.setValue(0);
        FontLib fontLib = new FontLib(paramsPtr);
        this.fontLibsMap.put(fontLib.getHandle(), fontLib);
        return fontLib.getHandle();
    }

    @HLEFunction(nid=1476179763, version=150, checkInsideInterrupt=true)
    public int sceFontOpenUserFile(int fontLibHandle, PspString fileName, int mode, @CanBeNull TErrorPointer32 errorCodePtr) {
        FontLib fontLib = this.getFontLib(fontLibHandle);
        errorCodePtr.setValue(0);
        Font font = this.openFontFile(fileName.getString());
        if (font == null) {
            errorCodePtr.setValue(-2142896123);
            return 0;
        }
        return fontLib.openFont(font, mode, true).getHandle();
    }

    @HLEFunction(nid=-1148289050, version=150, checkInsideInterrupt=true, stackUsage=1088)
    public int sceFontOpenUserMemory(int fontLibHandle, TPointer memoryFontPtr, int memoryFontLength, @CanBeNull TErrorPointer32 errorCodePtr) {
        FontLib fontLib = this.getFontLib(fontLibHandle);
        errorCodePtr.setValue(0);
        return fontLib.openFont(this.openFontFile(memoryFontPtr.getAddress(), memoryFontLength), 0, false).getHandle();
    }

    @HLEFunction(nid=229069662, version=150, checkInsideInterrupt=true, stackUsage=0)
    public int sceFontGetFontInfo(int fontHandle, TPointer fontInfoPtr) {
        Font font = this.getFont(fontHandle, true);
        PGF currentPGF = font.pgf;
        int maxGlyphWidthI = currentPGF.getMaxSize()[0];
        int maxGlyphHeightI = currentPGF.getMaxSize()[1];
        int maxGlyphAscenderI = currentPGF.getMaxAscender();
        int maxGlyphDescenderI = currentPGF.getMaxDescender();
        int maxGlyphLeftXI = currentPGF.getMaxLeftXAdjust();
        int maxGlyphBaseYI = font.maxGlyphBaseYI;
        int minGlyphCenterXI = currentPGF.getMinCenterXAdjust();
        int maxGlyphTopYI = currentPGF.getMaxTopYAdjust();
        int maxGlyphAdvanceXI = currentPGF.getMaxAdvance()[0];
        int maxGlyphAdvanceYI = currentPGF.getMaxAdvance()[1];
        int maxBitmapWidth = font.maxBitmapWidth;
        int maxBitmapHeight = font.maxBitmapHeight;
        pspFontStyle fontStyle = font.getFontStyle();
        fontInfoPtr.setValue32(0, maxGlyphWidthI);
        fontInfoPtr.setValue32(4, maxGlyphHeightI);
        fontInfoPtr.setValue32(8, maxGlyphAscenderI);
        fontInfoPtr.setValue32(12, maxGlyphDescenderI);
        fontInfoPtr.setValue32(16, maxGlyphLeftXI);
        fontInfoPtr.setValue32(20, maxGlyphBaseYI);
        fontInfoPtr.setValue32(24, minGlyphCenterXI);
        fontInfoPtr.setValue32(28, maxGlyphTopYI);
        fontInfoPtr.setValue32(32, maxGlyphAdvanceXI);
        fontInfoPtr.setValue32(36, maxGlyphAdvanceYI);
        for (int i = 0; i < 40; i += 4) {
            int intValue = fontInfoPtr.getValue32(i);
            float floatValue = (float)intValue / 64.0f;
            fontInfoPtr.setFloat(i + 40, floatValue);
        }
        fontInfoPtr.setValue16(80, (short)maxBitmapWidth);
        fontInfoPtr.setValue16(82, (short)maxBitmapHeight);
        fontInfoPtr.setValue32(84, currentPGF.getCharPointerLength());
        fontInfoPtr.setValue32(88, 0);
        fontStyle.write(fontInfoPtr, 92);
        fontInfoPtr.setValue8(260, (byte)currentPGF.getBpp());
        fontInfoPtr.setValue8(261, (byte)0);
        fontInfoPtr.setValue8(262, (byte)0);
        fontInfoPtr.setValue8(263, (byte)0);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontGetFontInfo returning maxGlyphWidthI=%d, maxGlyphHeightI=%d, maxGlyphAscenderI=%d, maxGlyphDescenderI=%d, maxGlyphLeftXI=%d, maxGlyphBaseYI=%d, minGlyphCenterXI=%d, maxGlyphTopYI=%d, maxGlyphAdvanceXI=%d, maxGlyphAdvanceYI=%d, maxBitmapWidth=%d, maxBitmapHeight=%d, fontStyle=[%s]%s", maxGlyphWidthI, maxGlyphHeightI, maxGlyphAscenderI, maxGlyphDescenderI, maxGlyphLeftXI, maxGlyphBaseYI, minGlyphCenterXI, maxGlyphTopYI, maxGlyphAdvanceXI, maxGlyphAdvanceYI, maxBitmapWidth, maxBitmapHeight, fontStyle, Utilities.getMemoryDump(fontInfoPtr.getAddress(), 264)));
        }
        return 0;
    }

    @HLEFunction(nid=-590869457, version=150, checkInsideInterrupt=true, stackUsage=256)
    public int sceFontGetCharInfo(int fontHandle, int charCode, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=60, usage=BufferInfo.Usage.out) TPointer charInfoPtr) {
        int result;
        Font font = this.getFont(fontHandle, false);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontGetCharInfo charCode=%04X (%c)", charCode, Character.valueOf((char)(charCode <= 255 ? (int)charCode : 63))));
        }
        charCode &= 0xFFFF;
        pspCharInfo pspCharInfo2 = null;
        if (!this.getUseDebugFont()) {
            pspCharInfo2 = font.fontInfo.getCharInfo(charCode, 0);
        }
        if (pspCharInfo2 == null) {
            pspCharInfo2 = new pspCharInfo();
            pspCharInfo2.bitmapWidth = Debug.Font.charWidth * 2;
            pspCharInfo2.bitmapHeight = Debug.Font.charHeight * 2;
            pspCharInfo2.sfp26Width = pspCharInfo2.bitmapWidth << 6;
            pspCharInfo2.sfp26Height = pspCharInfo2.bitmapHeight << 6;
            pspCharInfo2.sfp26AdvanceH = pspCharInfo2.bitmapWidth << 6;
            pspCharInfo2.sfp26AdvanceV = pspCharInfo2.bitmapHeight << 6;
        }
        if ((result = font.fontLib.triggetGetCharInfo(pspCharInfo2)) == 0) {
            pspCharInfo2.write(charInfoPtr);
        }
        return result;
    }

    @HLEFunction(nid=-1743828843, version=150, checkInsideInterrupt=true)
    public int sceFontGetCharGlyphImage(int fontHandle, int charCode, TPointer glyphImagePtr) {
        charCode &= 0xFFFF;
        Font font = this.getFont(fontHandle, false);
        int pixelFormat = glyphImagePtr.getValue32(0);
        int xPos64 = glyphImagePtr.getValue32(4);
        int yPos64 = glyphImagePtr.getValue32(8);
        short bufWidth = glyphImagePtr.getValue16(12);
        short bufHeight = glyphImagePtr.getValue16(14);
        short bytesPerLine = glyphImagePtr.getValue16(16);
        int buffer = glyphImagePtr.getValue32(20);
        int xPosI = xPos64 >> 6;
        int yPosI = yPos64 >> 6;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontGetCharGlyphImage charCode=%04X (%c), xPos=%d, yPos=%d, buffer=0x%08X, bufWidth=%d, bufHeight=%d, bytesPerLine=%d, pixelFormat=%d", charCode, Character.valueOf((char)(charCode <= 255 ? (int)charCode : 63)), xPosI, yPosI, buffer, (int)bufWidth, (int)bufHeight, (int)bytesPerLine, pixelFormat));
        }
        if (!this.getUseDebugFont()) {
            font.fontInfo.printFont(buffer, bytesPerLine, bufWidth, bufHeight, xPosI, yPosI, xPos64 % 64, yPos64 % 64, 0, 0, bufWidth, bufHeight, pixelFormat, charCode, font.fontLib.getAltCharCode(), 0, false);
        } else {
            yPosI -= font.pgf.getMaxBaseYAdjust() >> 6;
            Debug.printFontbuffer(buffer, bytesPerLine, bufWidth, bufHeight, xPosI, yPosI += font.pgf.getMaxTopYAdjust() >> 6, pixelFormat, charCode, font.fontLib.getAltCharCode());
        }
        return 0;
    }

    @HLEFunction(nid=161411900, version=150, checkInsideInterrupt=false)
    public int sceFontFindOptimumFont(int fontLibHandle, pspFontStyle fontStyle, @CanBeNull TErrorPointer32 errorCodePtr) {
        int index;
        if (fontStyle.isEmpty()) {
            return 0;
        }
        Font optimumFont = this.getOptimumFont(fontStyle);
        if (optimumFont == null && fontStyle.fontStyle != 0) {
            fontStyle.fontStyle = 0;
            fontStyle.fontStyleSub = 0;
            optimumFont = this.getOptimumFont(fontStyle);
        }
        if (optimumFont == null && (fontStyle.fontH != 0.0f || fontStyle.fontV != 0.0f)) {
            fontStyle.fontH = 0.0f;
            fontStyle.fontV = 0.0f;
            optimumFont = this.getOptimumFont(fontStyle);
        }
        if (optimumFont == null && fontStyle.fontCountry != 0) {
            fontStyle.fontCountry = 0;
            optimumFont = this.getOptimumFont(fontStyle);
        }
        if ((index = this.getFontIndex(optimumFont)) < 0) {
            index = 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontFindOptimumFont found font at index %d: %s", index, optimumFont));
        }
        return index;
    }

    @HLEFunction(nid=988449974, version=150, checkInsideInterrupt=true)
    public int sceFontClose(int fontHandle) {
        Font font = this.fontsMap.get(fontHandle);
        if (font != null && font.fontLib != null) {
            font.fontLib.closeFont(font);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontClose font already closed font=%s", font));
        }
        return 0;
    }

    @HLEFunction(nid=1464561596, version=150, checkInsideInterrupt=true)
    public int sceFontDoneLib(int fontLibHandle) {
        FontLib fontLib = this.fontLibsMap.get(fontLibHandle);
        if (fontLib != null) {
            fontLib.triggerCloseCallback();
            fontLib.done();
            this.fontLibsMap.remove(fontLibHandle);
            HLEUidObjectMapping.removeObject(fontLib);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontDoneLib font lib already done 0x%08X", fontLibHandle));
        }
        return 0;
    }

    @HLEFunction(nid=-1472974435, version=150, checkInsideInterrupt=false)
    public int sceFontOpen(int fontLibHandle, int index, int mode, @CanBeNull TErrorPointer32 errorCodePtr) {
        FontLib fontLib = this.getFontLib(fontLibHandle);
        if (index < 0) {
            errorCodePtr.setValue(-2142896125);
            return 0;
        }
        Font font = fontLib.openFont(this.internalFonts.get(index), mode, true);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Opening '%s' - '%s', font=%s", font.pgf.getFontName(), font.pgf.getFontType(), font));
        }
        errorCodePtr.setValue(0);
        return font.getHandle();
    }

    @HLEFunction(nid=-903976635, version=150, checkInsideInterrupt=true, stackUsage=288)
    public int sceFontGetCharGlyphImage_Clip(int fontHandle, int charCode, TPointer glyphImagePtr, int clipXPos, int clipYPos, int clipWidth, int clipHeight) {
        charCode &= 0xFFFF;
        Font font = this.getFont(fontHandle, false);
        int pixelFormat = glyphImagePtr.getValue32(0);
        int xPos64 = glyphImagePtr.getValue32(4);
        int yPos64 = glyphImagePtr.getValue32(8);
        short bufWidth = glyphImagePtr.getValue16(12);
        short bufHeight = glyphImagePtr.getValue16(14);
        short bytesPerLine = glyphImagePtr.getValue16(16);
        int buffer = glyphImagePtr.getValue32(20);
        int xPosI = xPos64 >> 6;
        int yPosI = yPos64 >> 6;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontGetCharGlyphImage_Clip charCode=%04X (%c), xPos=%d(%d), yPos=%d(%d), buffer=0x%08X, bufWidth=%d, bufHeight=%d, bytesPerLine=%d, pixelFormat=%d", charCode, Character.valueOf((char)(charCode <= 255 ? (int)charCode : 63)), xPosI, xPos64, yPosI, yPos64, buffer, (int)bufWidth, (int)bufHeight, (int)bytesPerLine, pixelFormat));
        }
        if (!this.getUseDebugFont()) {
            font.fontInfo.printFont(buffer, bytesPerLine, bufWidth, bufHeight, xPosI, yPosI, xPos64 % 64, yPos64 % 64, clipXPos, clipYPos, clipWidth, clipHeight, pixelFormat, charCode, font.fontLib.getAltCharCode(), 0, false);
        } else {
            yPosI -= font.pgf.getMaxBaseYAdjust() >> 6;
            if ((yPosI += font.pgf.getMaxTopYAdjust() >> 6) < 0) {
                yPosI = 0;
            }
            Debug.printFontbuffer(buffer, bytesPerLine, bufWidth, bufHeight, xPosI, yPosI, pixelFormat, charCode, font.fontLib.getAltCharCode());
        }
        return 0;
    }

    @HLEFunction(nid=670492226, version=150, checkInsideInterrupt=true)
    public int sceFontGetNumFontList(int fontLibHandle, @CanBeNull TErrorPointer32 errorCodePtr) {
        int numFonts = this.internalFonts.size();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontGetNumFontList returning %d", numFonts));
        }
        errorCodePtr.setValue(0);
        return numFonts;
    }

    @HLEFunction(nid=-1133127589, version=150, checkInsideInterrupt=true)
    public int sceFontGetFontList(int fontLibHandle, TPointer fontStylePtr, int numFonts) {
        int fontsNum = Math.min(this.internalFonts.size(), numFonts);
        for (int i = 0; i < fontsNum; ++i) {
            Font font = this.internalFonts.get(i);
            pspFontStyle fontStyle = font.getFontStyle();
            fontStyle.write(fontStylePtr, i * fontStyle.sizeof());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)String.format("sceFontGetFontList returning font #%d at 0x%08X: %s", i, fontStylePtr.getAddress() + i * fontStyle.sizeof(), fontStyle));
        }
        return 0;
    }

    @HLEFunction(nid=-299686895, version=150, checkInsideInterrupt=true)
    public int sceFontSetAltCharacterCode(int fontLibHandle, int charCode) {
        FontLib fontLib = this.getFontLib(fontLibHandle);
        fontLib.setAltCharCode(charCode &= 0xFFFF);
        return 0;
    }

    @HLEFunction(nid=1547586206, version=150, checkInsideInterrupt=true)
    public int sceFontGetCharImageRect(int fontHandle, int charCode, TPointer16 charRectPtr) {
        Font font = this.getFont(fontHandle, false);
        pspCharInfo charInfo = font.fontInfo.getCharInfo(charCode &= 0xFFFF, 0);
        if (charInfo != null) {
            charRectPtr.setValue(0, charInfo.bitmapWidth);
            charRectPtr.setValue(2, charInfo.bitmapHeight);
        } else {
            charRectPtr.setValue(0, 0);
            charRectPtr.setValue(2, 0);
        }
        return 0;
    }

    @HLEFunction(nid=1193710797, version=150)
    public float sceFontPointToPixelH(int fontLibHandle, float fontPointsH, @CanBeNull TErrorPointer32 errorCodePtr) {
        FontLib fontLib = this.getFontLib(fontLibHandle);
        errorCodePtr.setValue(0);
        return fontPointsH * fontLib.fontHRes / 72.0f;
    }

    @HLEFunction(nid=1395864109, version=150, checkInsideInterrupt=true)
    public int sceFontGetFontInfoByIndexNumber(int fontLibHandle, TPointer fontStylePtr, int fontIndex) {
        this.getFontLib(fontLibHandle);
        if (fontIndex < 0 || fontIndex >= this.internalFonts.size()) {
            return -2142896125;
        }
        Font font = this.internalFonts.get(fontIndex);
        pspFontStyle fontStyle = font.getFontStyle();
        fontStyle.write(fontStylePtr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceFontGetFontInfoByIndexNumber returning font #%d at %s: %s", fontIndex, fontStylePtr, fontStyle));
        }
        return 0;
    }

    @HLEFunction(nid=1210659456, version=150, checkInsideInterrupt=true)
    public int sceFontSetResolution(int fontLibHandle, float hRes, float vRes) {
        FontLib fontLib = this.getFontLib(fontLibHandle);
        fontLib.fontHRes = hRes;
        fontLib.fontVRes = vRes;
        return 0;
    }

    @HLEFunction(nid=47708491, version=150, checkInsideInterrupt=true)
    public int sceFontFlush(int fontHandle) {
        Font font = this.getFont(fontHandle, false);
        font.fontLib.flushFont(font);
        return 0;
    }

    @HLEFunction(nid=1746821543, version=150, checkInsideInterrupt=true)
    public int sceFontFindFont(int fontLibHandle, pspFontStyle fontStyle, @CanBeNull TErrorPointer32 errorCodePtr) {
        errorCodePtr.setValue(0);
        int fontsNum = this.internalFonts.size();
        for (int i = 0; i < fontsNum; ++i) {
            if (!this.isFontMatchingStyle(this.internalFonts.get(i), fontStyle, false)) continue;
            return i;
        }
        return -1;
    }

    @HLEFunction(nid=1011580546, version=150)
    public float sceFontPointToPixelV(int fontLibHandle, float fontPointsV, @CanBeNull TErrorPointer32 errorCodePtr) {
        FontLib fontLib = this.getFontLib(fontLibHandle);
        errorCodePtr.setValue(0);
        return fontPointsV * fontLib.fontVRes / 72.0f;
    }

    @HLEFunction(nid=1957828353, version=150)
    public float sceFontPixelToPointH(int fontLibHandle, float fontPixelsH, @CanBeNull TErrorPointer32 errorCodePtr) {
        FontLib fontLib = this.getFontLib(fontLibHandle);
        errorCodePtr.setValue(0);
        return fontPixelsH * 72.0f / fontLib.fontHRes;
    }

    @HLEFunction(nid=-118459090, version=150)
    public float sceFontPixelToPointV(int fontLibHandle, float fontPixelsV, @CanBeNull TErrorPointer32 errorCodePtr) {
        FontLib fontLib = this.getFontLib(fontLibHandle);
        errorCodePtr.setValue(0);
        return fontPixelsV * 72.0f / fontLib.fontVRes;
    }

    @HLEUnimplemented
    @HLEFunction(nid=795293034, version=150)
    public int sceFontCalcMemorySize() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1219519776, version=150)
    public int sceFontGetShadowImageRect(int fontHandle, int charCode, TPointer charInfoPtr) {
        charCode &= 0xFFFF;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1452008726, version=150)
    public int sceFontGetShadowGlyphImage(int fontHandle, int charCode, TPointer glyphImagePtr) {
        charCode &= 0xFFFF;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1573873752, version=150)
    public int sceFontGetShadowGlyphImage_Clip(int fontHandle, int charCode, TPointer glyphImagePtr, int clipXPos, int clipYPos, int clipWidth, int clipHeight) {
        charCode &= 0xFFFF;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1438783563, version=150)
    public int sceFontGetShadowInfo(int fontHandle, int charCode, TPointer charInfoPtr) {
        charCode &= 0xFFFF;
        return 0;
    }

    @HLEUidClass(errorValueOnNotFound=-2142896126)
    protected class FontLib {
        private static final int FONT_IS_CLOSED = 0;
        private static final int FONT_IS_OPEN = 1;
        protected int userDataAddr;
        protected int numFonts;
        protected int cacheDataAddr;
        protected int allocFuncAddr;
        protected int freeFuncAddr;
        protected int openFuncAddr;
        protected int closeFuncAddr;
        protected int readFuncAddr;
        protected int seekFuncAddr;
        protected int errorFuncAddr;
        protected int ioFinishFuncAddr;
        protected int fileFontHandle;
        protected int altCharCode;
        protected float fontHRes = 128.0f;
        protected float fontVRes = 128.0f;
        protected int handle;
        protected int[] fonts;
        protected int[] allocatedSizes = new int[]{76, 304, 2240, 3192};
        protected int[] allocatedAddresses = new int[this.allocatedSizes.length];
        protected int allocatedAddressIndex;
        protected int[] openAllocatedAddresses;
        protected int charInfoBitmapAddress;

        public FontLib(TPointer32 params) {
            this.read(params);
            this.openAllocatedAddresses = new int[this.numFonts];
            this.allocateAddresses();
        }

        private void allocateAddresses() {
            int minimumSize = this.numFonts * 4 + 4;
            if (this.allocatedSizes[0] < minimumSize) {
                this.allocatedSizes[0] = minimumSize;
            }
            this.allocatedAddressIndex = 0;
            this.triggerAllocCallback(this.allocatedSizes[this.allocatedAddressIndex], new AfterCreateAllocCallback());
        }

        public int getNumFonts() {
            return this.numFonts;
        }

        private Font openFont(Font font, int mode, boolean needAllocForFontFile) {
            if (font == null) {
                throw new SceKernelErrorException(-2142896125);
            }
            Memory mem = Memory.getInstance();
            int freeFontIndex = -1;
            for (int i = 0; i < this.numFonts; ++i) {
                if (mem.read32(this.fonts[i]) != 0) continue;
                freeFontIndex = i;
                break;
            }
            if (freeFontIndex < 0) {
                throw new SceKernelErrorException(-2142896119);
            }
            font = new Font(font, this, this.fonts[freeFontIndex], font.fontFileSize);
            mem.write32(this.fonts[freeFontIndex], 1);
            sceFont.this.fontsMap.put(font.getHandle(), font);
            int allocSize = 12;
            if (needAllocForFontFile) {
                if (mode == 0) {
                    allocSize = 145844;
                } else if (mode == 1) {
                    allocSize += font.fontFileSize;
                }
            }
            this.triggerAllocCallback(allocSize, new AfterOpenAllocCallback(freeFontIndex));
            return font;
        }

        private void closeFont(Font font) {
            HLEUidObjectMapping.removeObject(font);
            for (int i = 0; i < this.numFonts; ++i) {
                if (this.fonts[i] != font.getHandle()) continue;
                Memory mem = Memory.getInstance();
                mem.write32(this.fonts[i], 0);
                if (this.openAllocatedAddresses[i] == 0) break;
                this.triggerFreeCallback(this.openAllocatedAddresses[i], null);
                this.openAllocatedAddresses[i] = 0;
                break;
            }
            this.flushFont(font);
            font.close();
        }

        public void flushFont(Font font) {
            if (this.charInfoBitmapAddress != 0) {
                this.triggerFreeCallback(this.charInfoBitmapAddress, null);
                this.charInfoBitmapAddress = 0;
            }
        }

        public void done() {
            Memory mem = Memory.getInstance();
            for (int i = 0; i < this.numFonts; ++i) {
                if (mem.read32(this.fonts[i]) == 1) {
                    this.closeFont((Font)sceFont.this.fontsMap.get(this.fonts[i]));
                }
                sceFont.this.fontsMap.remove(this.fonts[i]);
            }
            this.triggerFreeCallback(this.allocatedAddresses[--this.allocatedAddressIndex], new AfterFreeCallback());
            this.fonts = null;
        }

        public int triggetGetCharInfo(pspCharInfo charInfo) {
            int result = 0;
            if (charInfo.sfp26AdvanceH != 0 || charInfo.sfp26AdvanceV != 0) {
                SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
                if (this.charInfoBitmapAddress != 0) {
                    this.triggerFreeCallback(this.charInfoBitmapAddress, new AfterCharInfoFreeCallback(thread, charInfo));
                } else {
                    this.triggerAllocCallback(charInfo.bitmapWidth * charInfo.bitmapHeight, new AfterCharInfoAllocCallback(thread));
                }
                if (this.charInfoBitmapAddress == 0) {
                    result = -2142896127;
                }
            }
            return result;
        }

        public int getHandle() {
            return this.handle;
        }

        protected void triggerAllocCallback(int size, IAction afterAllocCallback) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("triggerAllocCallback size=0x%X", size));
            }
            Modules.ThreadManForUserModule.executeCallback(null, this.allocFuncAddr, afterAllocCallback, true, this.userDataAddr, size);
        }

        protected void triggerFreeCallback(int addr, IAction afterFreeCallback) {
            if (Memory.isAddressGood(addr)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Calling free callback on 0x%08X", addr));
                }
                Modules.ThreadManForUserModule.executeCallback(null, this.freeFuncAddr, afterFreeCallback, true, this.userDataAddr, addr);
            }
        }

        protected void triggerOpenCallback(int fileNameAddr, int errorCodeAddr) {
            Modules.ThreadManForUserModule.executeCallback(null, this.openFuncAddr, new AfterOpenCallback(), true, this.userDataAddr, fileNameAddr, errorCodeAddr);
        }

        protected void triggerCloseCallback() {
            if (this.fileFontHandle != 0) {
                Modules.ThreadManForUserModule.executeCallback(null, this.closeFuncAddr, null, true, this.userDataAddr, this.fileFontHandle);
            }
        }

        private void read(TPointer32 params) {
            this.userDataAddr = params.getValue(0);
            this.numFonts = params.getValue(4);
            this.cacheDataAddr = params.getValue(8);
            this.allocFuncAddr = params.getValue(12);
            this.freeFuncAddr = params.getValue(16);
            this.openFuncAddr = params.getValue(20);
            this.closeFuncAddr = params.getValue(24);
            this.readFuncAddr = params.getValue(28);
            this.seekFuncAddr = params.getValue(32);
            this.errorFuncAddr = params.getValue(36);
            this.ioFinishFuncAddr = params.getValue(40);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("userDataAddr 0x%08X, numFonts=%d, cacheDataAddr=0x%08X, allocFuncAddr=0x%08X, freeFuncAddr=0x%08X, openFuncAddr=0x%08X, closeFuncAddr=0x%08X, readFuncAddr=0x%08X, seekFuncAddr=0x%08X, errorFuncAddr=0x%08X, ioFinishFuncAddr=0x%08X", this.userDataAddr, this.numFonts, this.cacheDataAddr, this.allocFuncAddr, this.freeFuncAddr, this.openFuncAddr, this.closeFuncAddr, this.readFuncAddr, this.seekFuncAddr, this.errorFuncAddr, this.ioFinishFuncAddr));
            }
        }

        public int getAltCharCode() {
            return this.altCharCode;
        }

        public void setAltCharCode(int altCharCode) {
            this.altCharCode = altCharCode;
        }

        public int getFontHandle(int index) {
            return this.fonts[index];
        }

        public String toString() {
            return String.format("FontLib - Handle: '0x%08X', Fonts: '%d'", this.getHandle(), this.getNumFonts());
        }

        private class AfterCharInfoAllocCallback
        implements IAction {
            private SceKernelThreadInfo thread;

            public AfterCharInfoAllocCallback(SceKernelThreadInfo thread) {
                this.thread = thread;
            }

            @Override
            public void execute() {
                FontLib.this.charInfoBitmapAddress = Emulator.getProcessor().cpu._v0;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("FontLib's allocation callback on getCharInfo returned 0x%08X", FontLib.this.charInfoBitmapAddress));
                }
                if (FontLib.this.charInfoBitmapAddress == 0) {
                    this.thread.cpuContext._v0 = -2142896127;
                }
            }
        }

        private class AfterCharInfoFreeCallback
        implements IAction {
            private SceKernelThreadInfo thread;
            private pspCharInfo charInfo;

            public AfterCharInfoFreeCallback(SceKernelThreadInfo thread, pspCharInfo charInfo) {
                this.thread = thread;
                this.charInfo = charInfo;
            }

            @Override
            public void execute() {
                FontLib.this.charInfoBitmapAddress = 0;
                FontLib.this.triggerAllocCallback(this.charInfo.bitmapWidth * this.charInfo.bitmapHeight, new AfterCharInfoAllocCallback(this.thread));
            }
        }

        private class AfterOpenCallback
        implements IAction {
            private AfterOpenCallback() {
            }

            @Override
            public void execute() {
                FontLib.this.fileFontHandle = Emulator.getProcessor().cpu._v0;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("FontLib's file open callback returned 0x%X", FontLib.this.fileFontHandle));
                }
            }
        }

        private class AfterOpenAllocCallback
        implements IAction {
            private int fontIndex;

            public AfterOpenAllocCallback(int fontIndex) {
                this.fontIndex = fontIndex;
            }

            @Override
            public void execute() {
                int allocatedAddr = Emulator.getProcessor().cpu._v0;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("FontLib's allocation callback on open#%d returned 0x%08X", this.fontIndex, allocatedAddr));
                }
                FontLib.this.openAllocatedAddresses[this.fontIndex] = allocatedAddr;
            }
        }

        private class AfterFreeCallback
        implements IAction {
            private AfterFreeCallback() {
            }

            @Override
            public void execute() {
                if (FontLib.this.allocatedAddressIndex > 0) {
                    FontLib.this.triggerFreeCallback(FontLib.this.allocatedAddresses[--FontLib.this.allocatedAddressIndex], this);
                }
            }
        }

        private class AfterCreateAllocCallback
        implements IAction {
            private AfterCreateAllocCallback() {
            }

            @Override
            public void execute() {
                int allocatedAddr = Emulator.getProcessor().cpu._v0;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("FontLib's allocation callback#%d returned 0x%08X for size 0x%X", FontLib.this.allocatedAddressIndex, allocatedAddr, FontLib.this.allocatedSizes[FontLib.this.allocatedAddressIndex]));
                }
                if (FontLib.this.allocatedAddressIndex == 0) {
                    int addr;
                    FontLib.this.handle = addr = allocatedAddr;
                    addr += 4;
                    FontLib.this.fonts = new int[FontLib.this.numFonts];
                    Memory mem = Memory.getInstance();
                    for (int i = 0; i < FontLib.this.numFonts; ++i) {
                        mem.write32(addr, 0);
                        FontLib.this.fonts[i] = addr;
                        addr += 4;
                    }
                }
                FontLib.this.allocatedAddresses[FontLib.this.allocatedAddressIndex++] = allocatedAddr;
                if (FontLib.this.allocatedAddressIndex < FontLib.this.allocatedSizes.length) {
                    FontLib.this.triggerAllocCallback(FontLib.this.allocatedSizes[FontLib.this.allocatedAddressIndex], this);
                }
            }
        }
    }

    public static class FontRegistryEntry {
        public int h_size;
        public int v_size;
        public int h_resolution;
        public int v_resolution;
        public int extra_attributes;
        public int weight;
        public int family_code;
        public int style;
        public int sub_style;
        public int language_code;
        public int region_code;
        public int country_code;
        public String file_name;
        public String font_name;
        public int expire_date;
        public int shadow_option;
        public int fontFileSize;
        public int maxGlyphBaseYI;
        public int maxBitmapWidth;
        public int maxBitmapHeight;

        public FontRegistryEntry(int h_size, int v_size, int h_resolution, int v_resolution, int extra_attributes, int weight, int family_code, int style, int sub_style, int language_code, int region_code, int country_code, String file_name, String font_name, int expire_date, int shadow_option, int fontFileSize, int maxGlyphBaseYI, int maxBitmapWidth, int maxBitmapHeight) {
            this.h_size = h_size;
            this.v_size = v_size;
            this.h_resolution = h_resolution;
            this.v_resolution = v_resolution;
            this.extra_attributes = extra_attributes;
            this.weight = weight;
            this.family_code = family_code;
            this.style = style;
            this.sub_style = sub_style;
            this.language_code = language_code;
            this.region_code = region_code;
            this.country_code = country_code;
            this.file_name = file_name;
            this.font_name = font_name;
            this.expire_date = expire_date;
            this.shadow_option = shadow_option;
            this.fontFileSize = fontFileSize;
            this.maxGlyphBaseYI = maxGlyphBaseYI;
            this.maxBitmapWidth = maxBitmapWidth;
            this.maxBitmapHeight = maxBitmapHeight;
        }

        public FontRegistryEntry() {
        }
    }

    @HLEUidClass(errorValueOnNotFound=-2142896126)
    public class Font {
        public PGF pgf;
        public SceFontInfo fontInfo;
        public FontLib fontLib;
        private final int handle;
        private int fontFileSize;
        public int maxGlyphBaseYI;
        public int maxBitmapWidth;
        public int maxBitmapHeight;

        public Font(PGF pgf, SceFontInfo fontInfo, int fontFileSize) {
            this.pgf = pgf;
            this.fontInfo = fontInfo;
            this.fontLib = null;
            this.handle = 0;
            this.fontFileSize = fontFileSize;
            if (pgf != null) {
                this.maxGlyphBaseYI = pgf.getMaxBaseYAdjust();
                this.maxBitmapWidth = pgf.getMaxGlyphWidth();
                this.maxBitmapHeight = pgf.getMaxGlyphHeight();
            }
        }

        public Font(Font font, FontLib fontLib, int handle, int fontFileSize) {
            this.pgf = font.pgf;
            this.fontInfo = font.fontInfo;
            this.fontLib = fontLib;
            this.handle = handle;
            this.fontFileSize = fontFileSize;
            this.maxGlyphBaseYI = font.maxGlyphBaseYI;
            this.maxBitmapWidth = font.maxBitmapWidth;
            this.maxBitmapHeight = font.maxBitmapHeight;
        }

        public pspFontStyle getFontStyle() {
            pspFontStyle fontStyle = this.fontInfo.getFontStyle();
            if (fontStyle == null) {
                fontStyle = new pspFontStyle();
                fontStyle.fontH = (float)this.pgf.getHSize() / 64.0f;
                fontStyle.fontV = (float)this.pgf.getVSize() / 64.0f;
                fontStyle.fontHRes = (float)this.pgf.getHResolution() / 64.0f;
                fontStyle.fontVRes = (float)this.pgf.getVResolution() / 64.0f;
                fontStyle.fontStyle = sceFont.getFontStyle(this.pgf.getFontType());
                fontStyle.fontName = this.pgf.getFontName();
                fontStyle.fontFileName = this.pgf.getFileNamez();
            }
            return fontStyle;
        }

        public int getHandle() {
            return this.handle;
        }

        public boolean isClosed() {
            return this.fontLib == null;
        }

        public void close() {
            this.fontLib = null;
        }

        public String toString() {
            if (this.isClosed()) {
                return String.format("Font[handle=0x%X closed]", this.getHandle());
            }
            return String.format("Font[handle=0x%X, '%s' - '%s']", this.getHandle(), this.pgf.getFileNamez(), this.pgf.getFontName());
        }
    }

    private class UseDebugFontSettingsListerner
    extends AbstractBoolSettingsListener {
        private UseDebugFontSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceFont.this.setUseDebugFont(value);
        }
    }
}

