/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEFunctions;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer32;
import jpcsp.hardware.Audio;
import jpcsp.hardware.Battery;
import jpcsp.settings.Settings;
import org.apache.log4j.Logger;

public class sceImpose
extends HLEModule {
    public static Logger log = Modules.getLogger("sceImpose");
    public static final int PSP_LANGUAGE_JAPANESE = 0;
    public static final int PSP_LANGUAGE_ENGLISH = 1;
    public static final int PSP_LANGUAGE_FRENCH = 2;
    public static final int PSP_LANGUAGE_SPANISH = 3;
    public static final int PSP_LANGUAGE_GERMAN = 4;
    public static final int PSP_LANGUAGE_ITALIAN = 5;
    public static final int PSP_LANGUAGE_DUTCH = 6;
    public static final int PSP_LANGUAGE_PORTUGUESE = 7;
    public static final int PSP_LANGUAGE_RUSSIAN = 8;
    public static final int PSP_LANGUAGE_KOREAN = 9;
    public static final int PSP_LANGUAGE_TRADITIONAL_CHINESE = 10;
    public static final int PSP_LANGUAGE_SIMPLIFIED_CHINESE = 11;
    private int languageMode_language;
    public static final int PSP_CONFIRM_BUTTON_CIRCLE = 0;
    public static final int PSP_CONFIRM_BUTTON_CROSS = 1;
    private int languageMode_button;
    public static final int PSP_UMD_POPUP_DISABLE = 0;
    public static final int PSP_UMD_POPUP_ENABLE = 1;
    private int umdPopupStatus;
    private int backlightOffTime;
    public static final int PSP_IMPOSE_MAIN_VOLUME = 1;
    public static final int PSP_IMPOSE_BACKLIGHT_BRIGHTNESS = 2;
    public static final int PSP_IMPOSE_EQUALIZER_MODE = 4;
    public static final int PSP_IMPOSE_MUTE = 8;
    public static final int PSP_IMPOSE_AVLS = 16;
    public static final int PSP_IMPOSE_TIME_FORMAT = 32;
    public static final int PSP_IMPOSE_DATE_FORMAT = 64;
    public static final int PSP_IMPOSE_LANGUAGE = 128;
    public static final int PSP_IMPOSE_00000100 = 256;
    public static final int PSP_IMPOSE_BACKLIGHT_OFF_INTERVAL = 512;
    public static final int PSP_IMPOSE_SOUND_REDUCTION = 1024;
    public static final int PSP_IMPOSE_UMD_POPUP_ENABLED = 1;
    public static final int PSP_IMPOSE_UMD_POPUP_DISABLED = 0;
    public static final int PSP_IMPOSE_20000000 = 0x20000000;
    public static final int PSP_IMPOSE_80000001 = -2147483647;
    public static final int PSP_IMPOSE_80000002 = -2147483646;
    public static final int PSP_IMPOSE_80000003 = -2147483645;
    public static final int PSP_IMPOSE_80000004 = -2147483644;
    public static final int PSP_IMPOSE_80000005 = -2147483643;
    public static final int PSP_IMPOSE_80000006 = -2147483642;
    public static final int PSP_IMPOSE_80000007 = -2147483641;
    public static final int PSP_IMPOSE_80000008 = -2147483640;
    public static final int PSP_IMPOSE_80000009 = -2147483639;
    public static final int PSP_IMPOSE_8000000A = -2147483638;
    public static final int PSP_IMPOSE_8000000B = -2147483637;
    private int imposeChanges = 0;
    private int impose80000004 = 0;
    private int impose80000007 = 0;
    private int imposeAvls = 1;

    @Override
    public void start() {
        this.languageMode_language = Settings.getInstance().readInt("emu.impose.language", 1);
        this.languageMode_button = Settings.getInstance().readInt("emu.impose.button", 1);
        super.start();
    }

    @HLEUnimplemented
    @HLEFunction(nid=941349351, version=150)
    public int sceImposeHomeButton() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1435871002, version=150)
    public int sceImposeSetHomePopup() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=255073252, version=150)
    public int sceImposeGetHomePopup() {
        return 0;
    }

    @HLEFunction(nid=1914215496, version=150)
    public int sceImposeSetUMDPopup(int mode) {
        this.umdPopupStatus = mode;
        return 0;
    }

    @HLEFunction(nid=-527926328, version=150)
    public int sceImposeGetUMDPopup() {
        return this.umdPopupStatus;
    }

    @HLEFunction(nid=917139089, version=150)
    public int sceImposeSetLanguageMode(int lang, int button) {
        if (log.isDebugEnabled()) {
            String langStr;
            switch (lang) {
                case 0: {
                    langStr = "JAP";
                    break;
                }
                case 1: {
                    langStr = "ENG";
                    break;
                }
                case 2: {
                    langStr = "FR";
                    break;
                }
                case 9: {
                    langStr = "KOR";
                    break;
                }
                default: {
                    langStr = "PSP_LANGUAGE_UNKNOWN" + lang;
                }
            }
            log.debug((Object)String.format("sceImposeSetLanguageMode lang=%d(%s), button=%d", lang, langStr, button));
        }
        this.languageMode_language = lang;
        this.languageMode_button = button;
        return 0;
    }

    @HLEFunction(nid=620592079, version=150)
    public int sceImposeGetLanguageMode(TPointer32 langPtr, TPointer32 buttonPtr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceImposeGetLanguageMode langPtr=%s, buttonPtr=%s returning lang=%d, button=%d", langPtr, buttonPtr, this.languageMode_language, this.languageMode_button));
        }
        langPtr.setValue(this.languageMode_language);
        buttonPtr.setValue(this.languageMode_button);
        return 0;
    }

    @HLEFunction(nid=-1936445039, version=150)
    public int sceImposeGetBatteryIconStatus(TPointer32 chargingPtr, TPointer32 iconStatusPtr) {
        int batteryPowerPercent = Battery.getCurrentPowerPercent();
        int iconStatus = Math.min(batteryPowerPercent / 25, 3);
        boolean charging = Battery.isCharging();
        chargingPtr.setValue(charging ? 1 : 0);
        iconStatusPtr.setValue(iconStatus);
        return 0;
    }

    @HLEFunction(nid=-1888602856, version=150)
    public int sceImposeGetBacklightOffTime() {
        return this.backlightOffTime;
    }

    @HLEFunction(nid=-1770033846, version=150)
    public int sceImposeSetBacklightOffTime(int time) {
        this.backlightOffTime = time;
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=1394382712, version=352), @HLEFunction(nid=-600052481, version=660)})
    public int sceImposeGetParam(int param) {
        int value = 0;
        switch (param) {
            case 1: {
                if (Audio.isMuted()) {
                    value = 0;
                    break;
                }
                value = 30;
                break;
            }
            case 1024: {
                value = 0;
                break;
            }
            case 8: {
                value = Audio.isMuted() ? 1 : 0;
                break;
            }
            case 16: {
                value = this.imposeAvls;
                break;
            }
            case 512: {
                value = 0;
                break;
            }
            case 0x20000000: {
                value = 0;
                break;
            }
            case -2147483644: {
                value = this.impose80000004;
                break;
            }
            case -2147483641: {
                value = this.impose80000007;
                break;
            }
            case -2147483647: 
            case -2147483646: 
            case -2147483645: 
            case -2147483643: 
            case -2147483642: 
            case -2147483640: 
            case -2147483639: 
            case -2147483638: 
            case -2147483637: 
            case 2: 
            case 4: 
            case 32: 
            case 64: 
            case 128: 
            case 256: {
                log.warn((Object)String.format("sceImposeGetParam param=0x%X not implemented", param));
                break;
            }
            default: {
                log.warn((Object)String.format("sceImposeGetParam param=0x%X invalid parameter", param));
                return -2147483385;
            }
        }
        return value;
    }

    @HLEFunctions(value={@HLEFunction(nid=-2129676293, version=352), @HLEFunction(nid=1009878377, version=660)})
    public int sceImposeSetParam(int param, int value) {
        switch (param) {
            case 1: {
                if (value >= 0 && value < 31) break;
                return -2147483138;
            }
            case 8: {
                if (value < 0 || value > 1) {
                    return -2147483138;
                }
                Audio.setMuted(value != 0);
                this.imposeChanges |= 9;
                break;
            }
            case 16: {
                if (value < 0 || value > 1) {
                    return -2147483138;
                }
                this.imposeAvls = value;
                this.imposeChanges |= 0x11;
                break;
            }
            case 32: {
                this.imposeChanges |= 0x20;
                break;
            }
            case 64: {
                this.imposeChanges |= 0x40;
                break;
            }
            case 128: {
                if (value < 0 || value >= 12) {
                    return -2147483138;
                }
                this.imposeChanges |= 0x80;
                break;
            }
            case 256: {
                if (value < 0 || value > 1) {
                    return -2147483138;
                }
                this.imposeChanges |= 0x100;
                break;
            }
            case -2147483644: {
                if (value < 0 || value > 1) {
                    return -2147483138;
                }
                this.impose80000004 = value;
                break;
            }
            case -2147483641: {
                this.impose80000007 = value;
                break;
            }
            case -2147483647: 
            case -2147483646: 
            case -2147483645: 
            case -2147483643: 
            case -2147483642: 
            case -2147483640: 
            case -2147483639: 
            case -2147483638: 
            case -2147483637: 
            case 2: 
            case 4: 
            case 512: 
            case 1024: {
                log.warn((Object)String.format("sceImposeSetParam param=0x%X, value=0x%X not implemented", param, value));
                break;
            }
            default: {
                log.warn((Object)String.format("sceImposeSetParam param=0x%X, value=0x%X invalid parameter", param, value));
                return -2147483385;
            }
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=292413142, version=150)
    public int sceImposeSetVideoOutMode(int mode, int width, int height) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1156384396, version=150)
    public int sceImposeSetStatus(int status) {
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=-1273627559, version=150), @HLEFunction(nid=252083734, version=660)})
    public int sceImposeChanges() {
        int result = this.imposeChanges;
        this.imposeChanges = 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceImposeChanges returning 0x%X", result));
        }
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1683612855, version=150)
    public int sceImpose_9BA61B49() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1125002668, version=660), @HLEFunction(nid=-1648566076, version=150)})
    public int sceImpose_9DBCE0C4(int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1153475092, version=150)
    public int sceImpose_BB3F5DEC(int unknown1, int unknown2, int unknown3) {
        return 0;
    }
}

