/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceMp4AvcCscStruct;
import jpcsp.HLE.kernel.types.SceMpegAu;
import jpcsp.HLE.kernel.types.SceMpegRingbuffer;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.Memory;
import jpcsp.media.codec.util.BitReader;
import jpcsp.media.codec.util.IBitReader;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceMpeg
extends HLEModule {
    public static Logger log = Modules.getLogger("sceMpeg");
    public static final int PSMF_MAGIC = 1179472720;
    public static final int PSMF_VERSION_0012 = 842084400;
    public static final int PSMF_VERSION_0013 = 0x33313030;
    public static final int PSMF_VERSION_0014 = 875638832;
    public static final int PSMF_VERSION_0015 = 892416048;
    public static final int MPEG_VERSION_0012 = 0;
    public static final int MPEG_VERSION_0013 = 1;
    public static final int MPEG_VERSION_0014 = 2;
    public static final int MPEG_VERSION_0015 = 3;
    public static final int PSMF_MAGIC_OFFSET = 0;
    public static final int PSMF_STREAM_VERSION_OFFSET = 4;
    public static final int PSMF_STREAM_OFFSET_OFFSET = 8;
    public static final int PSMF_STREAM_SIZE_OFFSET = 12;
    public static final int PSMF_FIRST_TIMESTAMP_OFFSET = 84;
    public static final int PSMF_LAST_TIMESTAMP_OFFSET = 90;
    public static final int PSMF_NUMBER_STREAMS_OFFSET = 128;
    public static final int PSMF_FRAME_WIDTH_OFFSET = 142;
    public static final int PSMF_FRAME_HEIGHT_OFFSET = 143;
    public static final int MPEG_AVC_ES_SIZE = 2048;
    public static final int MPEG_MEMSIZE = 65536;
    public static final int MPEG_MEMSIZE_260 = 46043;
    public static final long UNKNOWN_TIMESTAMP = -1L;
    public static final int mpegTimestampPerSecond = 90000;
    public static final int PSMF_AVC_STREAM = 0;
    public static final int PSMF_ATRAC_STREAM = 1;
    public static final int PSMF_PCM_STREAM = 2;
    public static final int PSMF_DATA_STREAM = 3;
    public static final int PSMF_AUDIO_STREAM = 15;
    public static final int PSMF_VIDEO_STREAM_ID = 224;
    public static final int PSMF_AUDIO_STREAM_ID = 189;
    private static final int MAX_STREAMS = 112;
    private static final int YCBCR_DATA_OFFSET = 128;
    private static final int MPEG_ATRAC_ES_SIZE = 2112;
    private static final int MPEG_ATRAC_ES_OUTPUT_SIZE = 8192;
    private static final int MPEG_PCM_ES_SIZE = 320;
    private static final int MPEG_PCM_ES_OUTPUT_SIZE = 320;
    private static final int MPEG_DATA_ES_SIZE = 655360;
    private static final int MPEG_DATA_ES_OUTPUT_SIZE = 655360;
    private boolean hleInitialized = false;
    private TPointer initVideocodecBuffer;
    private TPointer initVideocodecBuffer2;
    private TPointer initAudiocodecBuffer;
    private TPointer emptyBuffer;
    private TPointer sceMpegAvcResource;
    private TPointer sceMpegAvcCscBuffer1;
    private TPointer32 sceMpegAvcCscBuffer2;
    private TPointer sceMpegAvcDecodeYCbCrBuffer1;
    private TPointer sceMpegAvcDecodeYCbCrBuffer2;
    private TPointer sceMpegAvcConvertToYuv420Buffer;
    private int globalFlags;
    private static final StreamTypeDescriptor[] streamTypeDescriptors = new StreamTypeDescriptor[19];
    private static final StreamChannelDescriptor[] streamChannelDescriptors = new StreamChannelDescriptor[6];
    private static final int[] streamDataOffsets = new int[]{0, 4, 4, 2, 0, 2, 0};
    private static final int[] esSizemaxLengths = new int[]{99328, 2048, 320, 655360, 0, 102656, 2048};
    private static final int[] sceMpegAvcCscOffsets = new int[]{0, 0, 0, 0};
    public static final int avcCscDelay = 3000;

    @Override
    public int getMemoryUsage() {
        if (Modules.ModuleMgrForKernelModule.isMemoryAllocatedForModule("flash0:/kd/mpeg.prx")) {
            return 0;
        }
        return 49152;
    }

    public static boolean isMpeg260() {
        return Emulator.getInstance().getFirmwareVersion() <= 260;
    }

    private void initHLE() {
        if (this.hleInitialized) {
            return;
        }
        int moduleMemory = this.getModuleMemory();
        Memory mem = this.getMemory();
        this.initVideocodecBuffer = new TPointer(mem, moduleMemory);
        this.initVideocodecBuffer2 = new TPointer(mem, moduleMemory += 96);
        this.initAudiocodecBuffer = new TPointer(mem, moduleMemory += 40);
        this.emptyBuffer = new TPointer(mem, moduleMemory += 108);
        this.sceMpegAvcResource = new TPointer(mem, moduleMemory += 128);
        this.sceMpegAvcCscBuffer1 = new TPointer(mem, moduleMemory += 8);
        this.sceMpegAvcCscBuffer2 = new TPointer32(mem, moduleMemory += 48);
        this.sceMpegAvcDecodeYCbCrBuffer1 = new TPointer(mem, moduleMemory += 16);
        this.sceMpegAvcDecodeYCbCrBuffer2 = new TPointer(mem, moduleMemory += 48);
        this.sceMpegAvcConvertToYuv420Buffer = new TPointer(mem, moduleMemory += 56);
        moduleMemory += 24;
        this.hleInitialized = true;
    }

    private long readTimestamp(IBitReader reader) {
        long a = reader.read(3);
        reader.skip(1);
        long b = reader.read(15);
        reader.skip(1);
        long c = reader.read(15);
        reader.skip(1);
        return a << 30 | b << 15 | c;
    }

    private int readStreamPacketInfo(SceMpegStreamPacketInfo packetInfo, IBitReader reader) {
        int length;
        packetInfo.packetLength = length = reader.read(16);
        packetInfo.pesScramblingControl = -1;
        packetInfo.pts = -1L;
        packetInfo.dts = -1L;
        packetInfo.packetDataAddr = reader.getReadAddr();
        packetInfo.packetDataLength = length;
        packetInfo.packetHeaderAddr = reader.getReadAddr() - 6;
        switch (packetInfo.startCode) {
            case -1090519040: {
                packetInfo.startCode |= reader.read(24);
                length -= 3;
                break;
            }
            case -1140850688: 
            case -1107296256: 
            case -268435456: 
            case -251658240: 
            case -234881024: 
            case -134217728: 
            case -16777216: {
                break;
            }
            default: {
                reader.skip(2);
                packetInfo.pesScramblingControl = reader.read(2);
                reader.skip(4);
                int ptsDtsFlags = reader.read(2);
                boolean escrFlag = reader.readBool();
                boolean esRateFlag = reader.readBool();
                boolean dsmTrickModeFlag = reader.readBool();
                boolean additionalCopyInfoFlag = reader.readBool();
                boolean crcFlag = reader.readBool();
                boolean extensionFlag = reader.readBool();
                int headerLength = reader.read(8);
                length -= 3 + headerLength;
                if ((ptsDtsFlags & 2) != 0) {
                    reader.skip(4);
                    packetInfo.pts = this.readTimestamp(reader);
                    headerLength -= 5;
                    if (ptsDtsFlags == 3) {
                        reader.skip(4);
                        packetInfo.dts = this.readTimestamp(reader);
                        headerLength -= 5;
                    }
                }
                if (escrFlag) {
                    reader.skip(48);
                    headerLength -= 6;
                }
                if (esRateFlag) {
                    reader.skip(24);
                    headerLength -= 3;
                }
                if (dsmTrickModeFlag) {
                    reader.skip(8);
                    --headerLength;
                }
                if (additionalCopyInfoFlag) {
                    reader.skip(8);
                    --headerLength;
                }
                if (crcFlag) {
                    reader.skip(16);
                    headerLength -= 2;
                }
                if (extensionFlag) {
                    boolean privateDataFlag = reader.readBool();
                    boolean packHeaderFieldFlag = reader.readBool();
                    boolean programPacketSequenceCounterFlag = reader.readBool();
                    boolean pStdBufferFlag = reader.readBool();
                    reader.skip(3);
                    boolean extensionFlag2 = reader.readBool();
                    --headerLength;
                    if (privateDataFlag) {
                        reader.skip(48);
                        reader.skip(48);
                        reader.skip(32);
                        headerLength -= 16;
                    }
                    if (packHeaderFieldFlag) {
                        return -2141093881;
                    }
                    if (programPacketSequenceCounterFlag) {
                        reader.skip(16);
                        headerLength -= 2;
                    }
                    if (pStdBufferFlag) {
                        reader.skip(16);
                        headerLength -= 2;
                    }
                    if (extensionFlag2) {
                        reader.skip(1);
                        int extensionFieldLength = reader.read(7);
                        --headerLength;
                        reader.skip(8 * extensionFieldLength);
                        headerLength -= extensionFieldLength;
                    }
                }
                if (headerLength > 0) {
                    reader.skip(8 * headerLength);
                }
                packetInfo.packetDataAddr = reader.getReadAddr();
                packetInfo.packetDataLength = length;
                if (packetInfo.startCode != -1124073472) break;
                packetInfo.startCode |= reader.read(24);
                reader.skip(24);
                length -= 6;
            }
        }
        if (length > 0) {
            reader.skip(length * 8);
        }
        return 1;
    }

    protected void hleMpegRingbufferPostPut(TPointer ringbufferAddr, AfterRingbufferPutCallback afterRingbufferPutCallback, int packetsAdded, int gp) {
        this.getProcessor().cpu._gp = gp;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleMpegRingbufferPostPut callback returned 0x%X", packetsAdded));
        }
        if (packetsAdded < 0) {
            if (!afterRingbufferPutCallback.hasProcessedPackets()) {
                afterRingbufferPutCallback.setReturnValue(packetsAdded);
                return;
            }
            packetsAdded = 0;
        }
        SceMpegRingbuffer sceMpegRingbuffer = new SceMpegRingbuffer();
        sceMpegRingbuffer.read(ringbufferAddr);
        sceMpegRingbuffer.packetsWritten += packetsAdded;
        if (sceMpegRingbuffer.packetsWritten >= sceMpegRingbuffer.packets) {
            sceMpegRingbuffer.packetsWritten -= sceMpegRingbuffer.packets;
        }
        sceMpegRingbuffer.packetsInRingbuffer += packetsAdded;
        sceMpegRingbuffer.write(ringbufferAddr);
        afterRingbufferPutCallback.addProcessedPackets(packetsAdded);
        if (packetsAdded > 0 && afterRingbufferPutCallback.hasRemainingPackets()) {
            int callbackNumPackets = afterRingbufferPutCallback.getRemainingPackets();
            if (sceMpegRingbuffer.packets < sceMpegRingbuffer.packetsWritten + callbackNumPackets) {
                callbackNumPackets = sceMpegRingbuffer.packets - sceMpegRingbuffer.packetsWritten;
            }
            int callbackDataAddress = sceMpegRingbuffer.data + sceMpegRingbuffer.packetsWritten * sceMpegRingbuffer.packetSize;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleMpegRingbufferPostPut calling callback 0x%08X with dataAddress=0x%08X, numPackets=0x%X", sceMpegRingbuffer.callbackAddr, callbackDataAddress, callbackNumPackets));
            }
            this.getProcessor().cpu._gp = sceMpegRingbuffer.gp;
            Modules.ThreadManForUserModule.executeCallback(null, sceMpegRingbuffer.callbackAddr, afterRingbufferPutCallback, false, callbackDataAddress, callbackNumPackets, sceMpegRingbuffer.callbackArgs);
        } else {
            int result;
            int processedPackets = afterRingbufferPutCallback.getProcessedPackets();
            processedPackets = Math.min(processedPackets, sceMpegRingbuffer.packetsInRingbuffer);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleMpegRingbufferPostPut returning processedPackets=0x%X", processedPackets));
            }
            if ((result = this.scanStreamPackets(ringbufferAddr.getMemory(), sceMpegRingbuffer, processedPackets)) < 0) {
                afterRingbufferPutCallback.setReturnValue(result);
            }
            sceMpegRingbuffer.packetsInRingbuffer -= processedPackets;
            sceMpegRingbuffer.packetsRead += processedPackets;
            if (sceMpegRingbuffer.packetsRead >= sceMpegRingbuffer.packets) {
                sceMpegRingbuffer.packetsRead -= sceMpegRingbuffer.packets;
            }
            sceMpegRingbuffer.write(ringbufferAddr);
            afterRingbufferPutCallback.setReturnValue(processedPackets);
        }
    }

    private int scanStreamPackets(Memory mem, SceMpegRingbuffer sceMpegRingbuffer, int numberOfPackets) {
        TPointer data = sceMpegRingbuffer.mpeg.getPointer();
        int readAddr = sceMpegRingbuffer.data + sceMpegRingbuffer.packetsRead * sceMpegRingbuffer.packetSize;
        RingbufferBitReader reader = new RingbufferBitReader(mem, readAddr, sceMpegRingbuffer.data, sceMpegRingbuffer.dataUpperBound, numberOfPackets * sceMpegRingbuffer.packetSize);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("scanStreamPackets packets %d to %d", sceMpegRingbuffer.packetsRead, (sceMpegRingbuffer.packetsRead + numberOfPackets) % sceMpegRingbuffer.packets));
        }
        SceMpegStreamPacketInfo packetInfo = new SceMpegStreamPacketInfo();
        int packetIndex = 0;
        while (reader.getBitsLeft() >= 32) {
            int startBit = reader.read(24);
            packetInfo.startCode = reader.read(8) << 24;
            if (startBit != 1) {
                return -2141093881;
            }
            if (packetInfo.startCode == -1174405120) {
                block12: {
                    reader.skip(2);
                    long systemClockReference = this.readTimestamp(reader);
                    int scrExtension = reader.read(9);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("StartCode 0x%08X: System Clock Reference (SCR)=0x%X, SCR extension=0x%X", packetInfo.startCode, systemClockReference, scrExtension));
                    }
                    reader.skip(30);
                    int unknownLength = reader.read(3);
                    reader.skip(unknownLength * 8);
                    int systemHeaderStartCode = reader.read(32);
                    if (systemHeaderStartCode == 443) {
                        reader.skip(16);
                        reader.skip(24);
                        reader.skip(24);
                        while (true) {
                            boolean unknownFlag;
                            if (!(unknownFlag = reader.readBool())) {
                                reader.skip(-1);
                                break block12;
                            }
                            reader.skip(23);
                        }
                    }
                    reader.skip(-32);
                }
                packetIndex = 0;
                continue;
            }
            if (packetInfo.startCode == -1191182336) break;
            int result = this.readStreamPacketInfo(packetInfo, reader);
            if (result < 0) {
                return result;
            }
            DataStream dataStream = this.getDataStream(data, packetInfo.startCode);
            if (dataStream != null && dataStream.isRegisteredStream()) {
                if (packetIndex >= 2) {
                    return -2141093881;
                }
                int packetByteIndex = packetInfo.packetHeaderAddr - sceMpegRingbuffer.data;
                int packetNumber = packetByteIndex / sceMpegRingbuffer.packetSize;
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Found data for stream 0x%08X/%s in ringbuffer packet #%d offset 0x%X", packetInfo.startCode, dataStream, packetNumber, packetByteIndex % sceMpegRingbuffer.packetSize));
                }
                TPointer ringbufferPacketInfo = new TPointer(sceMpegRingbuffer.mpeg.getMemory(), sceMpegRingbuffer.dataUpperBound + packetNumber * 104 + packetIndex * 52);
                dataStream.enqueDataPacket(ringbufferPacketInfo);
                packetInfo.write(ringbufferPacketInfo, 8);
                this.verifyDataStream(dataStream, "scanStreamPackets: ");
            }
            ++packetIndex;
        }
        return 0;
    }

    private int copyYCbCr(TPointer data, TPointer destinationAddr, TPointer sourceAddr, int imageIndex) {
        int height;
        int width;
        int mode;
        int result = 0;
        TPointer videocodecBuffer2 = data.getPointer(1732);
        TPointer mpegAvcYuvStruct = data.getPointer(1736);
        if (imageIndex == -1 && (mode = sourceAddr.getValue32(16)) == 2) {
            imageIndex = sourceAddr.getValue32(48);
        }
        mode = destinationAddr.getValue32(16);
        if (imageIndex == -1) {
            if (mode == 2) {
                return -2141126146;
            }
            mpegAvcYuvStruct = new TPointer(sourceAddr, 16);
            width = sourceAddr.getValue32(4) << 4;
            height = sourceAddr.getValue32(0) << 4;
        } else {
            mpegAvcYuvStruct.add(44 * imageIndex);
            width = videocodecBuffer2.getValue32(8);
            height = videocodecBuffer2.getValue32(12);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("copyYCbCr width=%d, height=%d, mode=0x%X, destinationAddr=%s, imageIndex=%d", width, height, mode, destinationAddr, imageIndex));
        }
        if (mode == 3) {
            int size1 = width * height;
            int size2 = size1 >>> 2;
            int returnValue = width << 16 | height;
            if ((width & 0x70) == 112) {
                size1 += height << 4;
                size2 += height << 2;
                returnValue = width + 16 << 16 | height;
            }
            this.sceMpegAvcDecodeYCbCrBuffer2.setValue32(0, width);
            this.sceMpegAvcDecodeYCbCrBuffer2.setValue32(4, height);
            this.sceMpegAvcDecodeYCbCrBuffer2.setValue32(8, destinationAddr.getValue32(12));
            this.sceMpegAvcDecodeYCbCrBuffer2.setValue32(12, mpegAvcYuvStruct.getValue32(0));
            this.sceMpegAvcDecodeYCbCrBuffer2.setValue32(16, mpegAvcYuvStruct.getValue32(4));
            this.sceMpegAvcDecodeYCbCrBuffer2.setValue32(20, mpegAvcYuvStruct.getValue32(8));
            this.sceMpegAvcDecodeYCbCrBuffer2.setValue32(24, mpegAvcYuvStruct.getValue32(12));
            this.sceMpegAvcDecodeYCbCrBuffer2.setValue32(28, mpegAvcYuvStruct.getValue32(16));
            this.sceMpegAvcDecodeYCbCrBuffer2.setValue32(32, mpegAvcYuvStruct.getValue32(20));
            this.sceMpegAvcDecodeYCbCrBuffer2.setValue32(36, mpegAvcYuvStruct.getValue32(24));
            this.sceMpegAvcDecodeYCbCrBuffer2.setValue32(40, mpegAvcYuvStruct.getValue32(28));
            this.sceMpegAvcDecodeYCbCrBuffer2.setValue32(44, destinationAddr.getValue32(20));
            this.sceMpegAvcDecodeYCbCrBuffer2.setValue32(48, destinationAddr.getValue32(20) + size1);
            this.sceMpegAvcDecodeYCbCrBuffer2.setValue32(52, destinationAddr.getValue32(20) + size1 + size2);
            result = Modules.sceVideocodecModule.sceVideocodec_D95C24D5(this.sceMpegAvcDecodeYCbCrBuffer2);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("copyYCbCr: sceVideocodec_D95C24D5 returned 0x%X", result));
            }
            if (result == 0) {
                result = returnValue;
            }
        } else {
            destinationAddr.setValue32(0, height >>> 4);
            destinationAddr.setValue32(4, width >>> 4);
            destinationAddr.setValue32(8, 0);
            destinationAddr.setValue32(12, 0);
            if (mode == 2) {
                destinationAddr.setValue32(48, imageIndex);
            } else {
                SceMp4AvcCscStruct mp4AvcCscStruct = new SceMp4AvcCscStruct();
                mp4AvcCscStruct.height = height;
                mp4AvcCscStruct.width = width;
                mp4AvcCscStruct.mode0 = 0;
                mp4AvcCscStruct.mode1 = 0;
                mp4AvcCscStruct.buffer0 = mpegAvcYuvStruct.getValue32(0) + sceMpegAvcCscOffsets[0];
                mp4AvcCscStruct.buffer1 = mpegAvcYuvStruct.getValue32(4) + sceMpegAvcCscOffsets[1];
                mp4AvcCscStruct.buffer2 = mpegAvcYuvStruct.getValue32(8) + sceMpegAvcCscOffsets[0];
                mp4AvcCscStruct.buffer3 = mpegAvcYuvStruct.getValue32(12) + sceMpegAvcCscOffsets[1];
                mp4AvcCscStruct.buffer4 = mpegAvcYuvStruct.getValue32(16) + sceMpegAvcCscOffsets[2];
                mp4AvcCscStruct.buffer5 = mpegAvcYuvStruct.getValue32(20) + sceMpegAvcCscOffsets[3];
                mp4AvcCscStruct.buffer6 = mpegAvcYuvStruct.getValue32(24) + sceMpegAvcCscOffsets[2];
                mp4AvcCscStruct.buffer7 = mpegAvcYuvStruct.getValue32(28) + sceMpegAvcCscOffsets[3];
                mp4AvcCscStruct.bufferMemory = this.sceMpegAvcDecodeYCbCrBuffer1.getMemory();
                mp4AvcCscStruct.write(this.sceMpegAvcDecodeYCbCrBuffer1);
                result = Modules.sceMpegbaseModule.sceMpegBaseYCrCbCopy(destinationAddr, this.sceMpegAvcDecodeYCbCrBuffer1, 3);
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("copyYCbCr: sceMpegBaseYCrCbCopy returned 0x%X", result));
                }
            }
        }
        return result;
    }

    private int completeAvcDecodeYCbCr(TPointer data, TPointer32 bufferAddr, TPointer32 gotFrameAddr) {
        int result = 0;
        TPointer videocodecBuffer2 = data.getPointer(1732);
        int numberOfDecodedImages = videocodecBuffer2.getValue32(32);
        gotFrameAddr.setValue(numberOfDecodedImages);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("completeAvcDecodeYCbCr bufferAddr=%s, numberOfDecodedImages=%d", bufferAddr, numberOfDecodedImages));
        }
        for (int i = 0; i < numberOfDecodedImages; ++i) {
            TPointer buffer = bufferAddr.getPointer(i * 4);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("completeAvcDecodeYCbCr i=%d: buffer=%s", i, buffer));
            }
            if (buffer.isNull()) {
                result = -2141126146;
                break;
            }
            result = this.copyYCbCr(data, buffer, null, i);
            if (result != 0) break;
        }
        return result;
    }

    private void afterVideocodecDecodeYCbCr(SceKernelThreadInfo thread, TPointer data, TPointer auAddr, TPointer32 bufferAddr, TPointer32 gotFrameAddr) {
        SceMpegAu au = new SceMpegAu();
        au.read(auAddr);
        au.esSize = 0;
        au.write(auAddr);
        int result = thread.cpuContext._v0;
        if (result != 0) {
            return;
        }
        result = this.completeAvcDecodeYCbCr(data, bufferAddr, gotFrameAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMpegAvcDecodeYCbCr numberOfDecodedImages=%d returning 0x%X", gotFrameAddr.getValue(), result));
        }
        thread.cpuContext._v0 = result;
    }

    private void afterVideocodecDecode(SceKernelThreadInfo thread, TPointer data, TPointer auAddr, int frameWidth, TPointer32 bufferAddr, TPointer32 gotFrameAddr) {
        SceMpegAu au = new SceMpegAu();
        au.read(auAddr);
        au.esSize = 0;
        au.write(auAddr);
        int result = thread.cpuContext._v0;
        if (result != 0) {
            return;
        }
        TPointer videocodecBuffer2 = data.getPointer(1732);
        TPointer mpegAvcYuvStruct = data.getPointer(1736);
        int numberOfDecodedImages = videocodecBuffer2.getValue32(32);
        gotFrameAddr.setValue(numberOfDecodedImages);
        int mode = data.getValue32(1708);
        if (mode < 3 || mode > 6) {
            for (int i = 0; i < numberOfDecodedImages; ++i) {
                SceMp4AvcCscStruct mp4AvcCscStruct = new SceMp4AvcCscStruct();
                mp4AvcCscStruct.height = videocodecBuffer2.getValue32(12) >> 4;
                mp4AvcCscStruct.width = videocodecBuffer2.getValue32(8) >> 4;
                mp4AvcCscStruct.mode0 = 0;
                mp4AvcCscStruct.mode1 = 0;
                mp4AvcCscStruct.buffer0 = mpegAvcYuvStruct.getValue32(0);
                mp4AvcCscStruct.buffer1 = mpegAvcYuvStruct.getValue32(4);
                mp4AvcCscStruct.buffer2 = mpegAvcYuvStruct.getValue32(8);
                mp4AvcCscStruct.buffer3 = mpegAvcYuvStruct.getValue32(12);
                mp4AvcCscStruct.buffer4 = mpegAvcYuvStruct.getValue32(16);
                mp4AvcCscStruct.buffer5 = mpegAvcYuvStruct.getValue32(20);
                mp4AvcCscStruct.buffer6 = mpegAvcYuvStruct.getValue32(24);
                mp4AvcCscStruct.buffer7 = mpegAvcYuvStruct.getValue32(28);
                mp4AvcCscStruct.bufferMemory = data.getMemory();
                TPointer buffer = bufferAddr.getPointer(i * 4);
                result = Modules.sceMpegbaseModule.hleMpegBaseCscAvc(buffer, TPointer.NULL, frameWidth, Modules.sceMpegbaseModule.getPixelMode(), mp4AvcCscStruct);
                if (result != 0) break;
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("sceMpegAvcDecode numberOfDecodedImages=%d, buffer=%s", numberOfDecodedImages, buffer));
                }
                mpegAvcYuvStruct.add(44);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMpegAvcDecode numberOfDecodedImages=%d returning 0x%08X", numberOfDecodedImages, result));
        }
        thread.cpuContext._v0 = result;
    }

    private static int getSizeFromPackets(int packets) {
        int size = packets * 104 + packets * 2048;
        return size;
    }

    private static int getPacketsFromSize(int size) {
        int packets = size / 2152;
        return packets;
    }

    private void checkLibmpeg(TPointer data) {
        if (!"LIBMPEG".equals(data.getStringNZ(8))) {
            throw new SceKernelErrorException(-2141126146);
        }
    }

    public TPointer32 checkMpeg(TPointer32 mpeg) {
        TPointer data = mpeg.getPointer();
        this.checkLibmpeg(data);
        return mpeg;
    }

    public TPointer checkRingbuffer(TPointer ringbuffer) {
        TPointer mpeg = ringbuffer.getPointer(40);
        TPointer data = mpeg.getPointer();
        this.checkLibmpeg(data);
        return ringbuffer;
    }

    private DataStream getDataStream(TPointer data, TPointer streamAddr) {
        return this.getDataStream(data, streamAddr.getValue32(0));
    }

    private DataStream getDataStream(TPointer data, int streamChannelCode) {
        for (StreamChannelDescriptor descriptor : streamChannelDescriptors) {
            if (!descriptor.isMatching(streamChannelCode)) continue;
            return descriptor.getDataStream(data, streamChannelCode);
        }
        return null;
    }

    private TPointer getStreamAddress(TPointer data, int streamChannelCode) {
        for (StreamChannelDescriptor descriptor : streamChannelDescriptors) {
            if (!descriptor.isMatching(streamChannelCode)) continue;
            return descriptor.getStreamAddr(data, streamChannelCode);
        }
        return null;
    }

    private void verifyDataStream(DataStream dataStream, String message) {
        int count = dataStream.getStreamPacketsCount();
        if (dataStream.isEmptyQueue()) {
            if (count != 0) {
                log.error((Object)String.format("%sEmpty data stream %s with count=%d", message, dataStream, count));
            }
            return;
        }
        if (count == 0) {
            log.error((Object)String.format("%sNon-empty data stream %s with count=%d", message, dataStream, count));
            return;
        }
        TPointer queue = dataStream.getStreamPacketsQueueHead();
        for (int i = 1; i < count; ++i) {
            int addr = queue.getValue32(0);
            if (addr == -1) {
                log.error((Object)String.format("%sFound end of queue in %s at %d/%d", message, dataStream, i, count));
                return;
            }
            queue = queue.getPointer(0);
        }
        if (queue.getValue32(0) != -1) {
            log.error((Object)String.format("%sNot end of queue in %s with count=%d", message, dataStream, count));
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("verifyDataStream %s, count=%d: successful", dataStream, count));
        }
    }

    private int getFirstStreamPacket(DataStream dataStream, SceMpegStreamPacketInfo streamPacketInfo) {
        return this.getStreamPacket(dataStream, 0, streamPacketInfo);
    }

    private int getStreamPacket(DataStream dataStream, int index, SceMpegStreamPacketInfo streamPacketInfo) {
        this.verifyDataStream(dataStream, "getStreamPacket: ");
        if (dataStream.isEmptyQueue()) {
            return -2141126146;
        }
        int count = dataStream.getStreamPacketsCount();
        if (count <= index) {
            return -2141093887;
        }
        TPointer queue = dataStream.getStreamPacketsQueueHead();
        for (int i = 0; i < index; ++i) {
            queue = queue.getPointer(0);
        }
        streamPacketInfo.read(queue, 8);
        return 0;
    }

    private int dequeueStreamPackets(DataStream dataStream, int count) {
        this.verifyDataStream(dataStream, "dequeueStreamPackets: ");
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("dequeueStreamPackets dataStream=%s, count=%d", dataStream, count));
        }
        if (count <= 0) {
            return 0;
        }
        if (dataStream.isEmptyQueue()) {
            return -2141126146;
        }
        int currentCount = dataStream.getStreamPacketsCount();
        int newCount = currentCount - count;
        TPointer queue = dataStream.getStreamPacketsQueueHead();
        for (count = Math.min(count, currentCount); count > 0; --count) {
            TPointer next = queue.getPointer(0);
            queue.setValue32(0, -1);
            queue.setValue32(4, -1);
            queue = next;
        }
        if (newCount <= 0) {
            dataStream.clear();
        } else {
            dataStream.setStreamPacketsQueueHead(queue, newCount);
        }
        return 0;
    }

    private int getEsBufferAddress(TPointer data, int esBuffer) {
        if (esBuffer <= 0) {
            return esBuffer;
        }
        int numberEsBuffers = data.getValue32(1712);
        if (esBuffer > numberEsBuffers) {
            return esBuffer;
        }
        int esBufferState = data.getValue8(1716 + esBuffer - 1) & 0xFF;
        if (esBufferState != 1) {
            return esBuffer;
        }
        return data.getValue32(1720 + (esBuffer - 1) * 4);
    }

    private TPointer getEsBufferPointer(TPointer data, int esBuffer) {
        int esBufferAddr = this.getEsBufferAddress(data, esBuffer);
        if (esBufferAddr == 0) {
            return TPointer.NULL;
        }
        return new TPointer(data.getMemory(), esBufferAddr | 0x8000000);
    }

    private int copyStreamData(TPointer data, TPointer streamAddr, TPointer auAddr, int mode) {
        DataStream dataStream = this.getDataStream(data, streamAddr);
        if (dataStream == null || dataStream.isEmptyQueue()) {
            return -2141126146;
        }
        SceMpegAu au = new SceMpegAu();
        au.read(auAddr);
        SceMpegStreamPacketInfo streamPacketInfo = new SceMpegStreamPacketInfo();
        TPointer esBufferAddr = this.getEsBufferPointer(data, au.esBuffer);
        int requiredLength = streamAddr.getValue32(36);
        int totalLength = 0;
        int count = dataStream.getStreamPacketsCount();
        TPointer dataPacketsQueue = dataStream.getStreamPacketsQueueHead();
        int processedCount = 0;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("copyStreamData streamAddr=%s, dataStream=%s, requiredLength=0x%X, packets count=%d", streamAddr, dataStream, requiredLength, count));
        }
        TPointer pesPacketCopyListStart = new TPointer(data, 44);
        TPointer pesPacketCopyList = new TPointer(pesPacketCopyListStart);
        for (int i = 0; i < count && requiredLength > 0; ++i) {
            streamPacketInfo.read(dataPacketsQueue, 8);
            int sourceOffset = streamAddr.getValue32(20) + streamAddr.getValue16(28);
            int sourceAddr = streamPacketInfo.packetDataAddr + sourceOffset;
            int length = streamPacketInfo.packetDataLength - sourceOffset;
            if ((requiredLength -= length) <= 0) {
                if (requiredLength < 0) {
                    streamAddr.setValue16(28, (short)(streamAddr.getValue16(28) + (length += requiredLength)));
                } else {
                    streamAddr.setValue16(28, (short)0);
                    ++processedCount;
                }
                if (processedCount > 0 || streamAddr.getValue32(32) > 0 || streamAddr.getValue32(52) == 1) {
                    streamAddr.setValue32(52, 0);
                    streamAddr.setValue32(24, streamAddr.getValue32(24) | 1);
                }
            } else {
                ++processedCount;
            }
            pesPacketCopyList.setValue32(0, sourceAddr);
            pesPacketCopyList.setValue32(4, esBufferAddr.getAddress() + au.esSize + totalLength);
            pesPacketCopyList.setValue32(8, pesPacketCopyList.getAddress() + 16);
            pesPacketCopyList.setValue32(12, length);
            pesPacketCopyList.add(16);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("copyStreamData memcpy(0x%08X, 0x%08X, 0x%X)", esBufferAddr.getAddress() + au.esSize + totalLength, sourceAddr, length));
            }
            totalLength += length;
            if (requiredLength <= 0) {
                int rest;
                int alignment = streamAddr.getValue32(40);
                if (alignment != 0 && (rest = totalLength % alignment) > 0) {
                    pesPacketCopyList.setPointer(0, this.emptyBuffer);
                    pesPacketCopyList.setValue32(4, esBufferAddr.getAddress() + au.esSize + totalLength);
                    pesPacketCopyList.setValue32(8, pesPacketCopyList.getAddress() + 16);
                    pesPacketCopyList.setValue32(12, alignment - rest);
                    pesPacketCopyList.add(16);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("copyStreamData clear(0x%08X, 0x%X)", esBufferAddr.getAddress() + au.esSize + totalLength, alignment - rest));
                    }
                }
                streamAddr.setValue32(44, 0);
                break;
            }
            streamAddr.setValue16(28, (short)0);
            dataPacketsQueue = dataPacketsQueue.getPointer(0);
        }
        if (pesPacketCopyList.getAddress() != pesPacketCopyListStart.getAddress()) {
            pesPacketCopyList.setValue32(-8, 0);
        }
        if (requiredLength > 0) {
            streamAddr.setValue32(44, streamAddr.getValue32(44) + totalLength);
            streamAddr.setValue32(32, streamAddr.getValue32(32) + processedCount);
            streamAddr.setValue32(36, requiredLength);
        } else {
            streamAddr.setValue32(32, 0);
        }
        int result = 0;
        int flags = streamAddr.getValue32(48);
        if (au.esSize + totalLength <= esSizemaxLengths[mode] && (flags & 5) == 0 && ((flags & 2) == 0 || flags < 0)) {
            result = Modules.sceMpegbaseModule.sceMpegBasePESpacketCopy(pesPacketCopyListStart);
        }
        au.esSize += totalLength;
        au.write(auAddr);
        this.dequeueStreamPackets(dataStream, processedCount);
        return result;
    }

    private static int getYCbCrSize1(int width, int height) {
        int incr = (width & 0x1F) != 0 ? 32 : 0;
        return ((width & 0xFFFFFFE0) + incr >> 1) * (height >> 1);
    }

    private static int getYCbCrSize2(int width, int height) {
        return ((width & 0xFFFFFFE0) >> 1) * (height >> 1);
    }

    public static int getMpegVersion(int mpegRawVersion) {
        switch (mpegRawVersion) {
            case 842084400: {
                return 0;
            }
            case 0x33313030: {
                return 1;
            }
            case 875638832: {
                return 2;
            }
            case 892416048: {
                return 3;
            }
        }
        return -1;
    }

    private boolean isOutsideRingbufferDataBuffer(SceMpegRingbuffer sceMpegRingbuffer, int addr) {
        if (addr < sceMpegRingbuffer.data) {
            return true;
        }
        return addr > sceMpegRingbuffer.data + sceMpegRingbuffer.packets * sceMpegRingbuffer.packetSize;
    }

    private int compareAddresses(SceMpegRingbuffer sceMpegRingbuffer, int addr1, int addr2) {
        if (this.isOutsideRingbufferDataBuffer(sceMpegRingbuffer, addr1)) {
            return -2141093881;
        }
        if (this.isOutsideRingbufferDataBuffer(sceMpegRingbuffer, addr2)) {
            return -2141093881;
        }
        int writeAddr = sceMpegRingbuffer.data + sceMpegRingbuffer.packetsWritten * sceMpegRingbuffer.packetSize;
        int readAddr = sceMpegRingbuffer.data + sceMpegRingbuffer.packetsRead * sceMpegRingbuffer.packetSize;
        if (writeAddr < readAddr || readAddr >= addr1 && readAddr >= addr2 || addr1 >= writeAddr && addr2 >= writeAddr) {
            if (addr1 < addr2) {
                return 1;
            }
            if (addr1 > addr2) {
                return 3;
            }
            return 2;
        }
        return addr1 < addr2 ? 3 : 1;
    }

    private int getDecodeDetail(TPointer data, int imageIndex, TPointer detailPointer) {
        TPointer videocodecBuffer = data.getPointer(1728);
        detailPointer.setValue32(0, videocodecBuffer.getValue32(8));
        TPointer videocodecBuffer2 = videocodecBuffer.getPointer(16);
        int numberOfDecodedImages = videocodecBuffer2.getValue32(32);
        if (numberOfDecodedImages > 0 && numberOfDecodedImages > imageIndex) {
            TPointer mpegAvcYuvStruct = videocodecBuffer.getPointer(44);
            mpegAvcYuvStruct.add(imageIndex * 44);
            detailPointer.setValue32(4, mpegAvcYuvStruct.getValue32(32));
            detailPointer.setValue32(8, videocodecBuffer2.getValue32(8));
            detailPointer.setValue32(12, videocodecBuffer2.getValue32(12));
            detailPointer.setValue32(16, videocodecBuffer2.getValue32(16));
            detailPointer.setValue32(20, videocodecBuffer2.getValue32(20));
            detailPointer.setValue32(24, videocodecBuffer2.getValue32(24));
            detailPointer.setValue32(28, videocodecBuffer2.getValue32(28));
            detailPointer.setValue32(32, numberOfDecodedImages);
            if (this.getModuleElfVersion() == 0 || this.getModuleElfVersion() > 264) {
                detailPointer.setValue32(36, videocodecBuffer2.getValue32(36));
                detailPointer.setValue32(40, videocodecBuffer.getValue32(48));
                detailPointer.setValue32(44, mpegAvcYuvStruct.getValue32(36));
                detailPointer.setValue32(48, mpegAvcYuvStruct.getValue32(40));
            }
        }
        return 0;
    }

    @HLEFunction(nid=1747607963, version=150, stackUsage=72)
    public int sceMpegInit() {
        this.initHLE();
        this.initVideocodecBuffer.clear(96);
        this.initVideocodecBuffer2.clear(40);
        this.initVideocodecBuffer.setPointer(16, this.initVideocodecBuffer2);
        int result = Modules.sceVideocodecModule.sceVideocodecOpen(this.initVideocodecBuffer, 0);
        if (result != 0) {
            return result;
        }
        result = Modules.sceVideocodecModule.sceVideocodecGetEDRAM(this.initVideocodecBuffer, 0);
        if (result != 0) {
            return result;
        }
        this.initAudiocodecBuffer.clear(108);
        result = Modules.sceAudiocodecModule.sceAudiocodecCheckNeedMem(this.initAudiocodecBuffer, 4096);
        if (result != 0) {
            return result;
        }
        result = Modules.sceAudiocodecModule.sceAudiocodecGetEDRAM(this.initAudiocodecBuffer, 4096);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    @HLEFunction(nid=570392804, version=150, checkInsideInterrupt=true, stackUsage=24)
    public int sceMpegQueryStreamOffset(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.in) TPointer bufferAddr, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 offsetAddr) {
        TPointer data = mpeg.getPointer();
        if (bufferAddr.getUnalignedValue32(0) != 1179472720) {
            offsetAddr.setValue(0);
            return -2141126146;
        }
        int version = sceMpeg.getMpegVersion(bufferAddr.getUnalignedValue32(4));
        data.setValue32(12, version);
        if (version < 0) {
            offsetAddr.setValue(0);
            return -2141126654;
        }
        int streamOffset = Utilities.endianSwap32(bufferAddr.getUnalignedValue32(8));
        offsetAddr.setValue(streamOffset);
        if ((streamOffset & 0x7FF) != 0 || streamOffset == 0) {
            offsetAddr.setValue(0);
            return -2141126146;
        }
        return 0;
    }

    @HLEFunction(nid=1629396497, version=150, checkInsideInterrupt=true, stackUsage=8)
    public int sceMpegQueryStreamSize(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.in) TPointer bufferAddr, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 sizeAddr) {
        int streamSize = Utilities.endianSwap32(bufferAddr.getUnalignedValue32(12));
        sizeAddr.setValue(streamSize);
        if ((streamSize & 0x7FF) != 0) {
            sizeAddr.setValue(0);
            return -2141126146;
        }
        return 0;
    }

    @HLEFunction(nid=-2025446186, version=150, checkInsideInterrupt=true, stackUsage=24)
    public int sceMpegFinish() {
        if (this.initAudiocodecBuffer.getValue32(12) != 0) {
            Modules.sceAudiocodecModule.sceAudiocodecReleaseEDRAM(this.initAudiocodecBuffer);
        }
        Modules.sceVideocodecModule.sceVideocodecReleaseEDRAM(this.initVideocodecBuffer);
        return 0;
    }

    @HLEFunction(nid=-1053629905, version=150, checkInsideInterrupt=true)
    public int sceMpegQueryMemSize(int mode) {
        if (sceMpeg.isMpeg260()) {
            return 46043;
        }
        return 65536;
    }

    @HLEFunction(nid=-658116319, version=150, checkInsideInterrupt=true, stackUsage=168)
    public int sceMpegCreate(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 mpeg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.out) TPointer data, int size, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=48, usage=BufferInfo.Usage.inout) @CanBeNull TPointer ringbufferAddr, int frameWidth, int mode, int ddrtop) {
        int result;
        this.initHLE();
        data.clear(size);
        TPointer dataAligned = new TPointer(data.getMemory(), Utilities.alignUp(data.getAddress(), 63));
        dataAligned.setStringNZ(0, 8, "LIBMPEG");
        dataAligned.setStringNZ(8, 4, "001");
        dataAligned.setValue32(12, -1);
        if (mode == 1) {
            dataAligned.setValue32(16, 0);
            dataAligned.setValue32(20, 0);
        } else {
            SceMpegRingbuffer sceMpegRingbuffer = new SceMpegRingbuffer();
            sceMpegRingbuffer.read(ringbufferAddr);
            dataAligned.setPointer(16, ringbufferAddr);
            dataAligned.setValue32(20, sceMpegRingbuffer.dataUpperBound);
            sceMpegRingbuffer.mpeg = mpeg;
            sceMpegRingbuffer.write(ringbufferAddr);
        }
        int pesPacketCopyListSize = 99;
        dataAligned.setValue32(40, 99);
        int offset = 44;
        int i = 0;
        while (i < 99) {
            dataAligned.setValue32(offset + 0, 0);
            dataAligned.setValue32(offset + 4, 0);
            dataAligned.setValue32(offset + 8, dataAligned.getAddress() + offset + 16);
            dataAligned.setValue32(offset + 12, 0);
            ++i;
            offset += 16;
        }
        dataAligned.setValue32(offset - 16 + 8, 0);
        TPointer dataStreamsAddr = new TPointer(dataAligned, 1856);
        dataAligned.setPointer(24, dataStreamsAddr);
        DataStream dataStream = new DataStream(dataStreamsAddr);
        for (int i2 = 0; i2 < 112; ++i2) {
            dataStream.init();
            dataStream.nextDataStream();
        }
        TPointer streamsAddr2 = new TPointer(dataStreamsAddr, 1856);
        dataAligned.setPointer(28, streamsAddr2);
        dataAligned.setPointer(32, new TPointer(streamsAddr2, 7680));
        dataAligned.setValue32(36, 0);
        dataAligned.setValue32(1708, mode);
        int numberEsBuffers = 2;
        dataAligned.setValue32(1712, 2);
        for (int i3 = 0; i3 < 2; ++i3) {
            dataAligned.setValue8(1716 + i3, (byte)0);
        }
        dataAligned.setValue32(1720, 303104);
        dataAligned.setValue32(1724, 402432);
        TPointer videocodecBuffer = new TPointer(dataAligned, 45824);
        TPointer audiocodecBuffer = new TPointer(dataAligned, 46336);
        if (sceMpeg.isMpeg260()) {
            int reducedSize260 = 2344;
            videocodecBuffer.sub(2344);
            audiocodecBuffer.sub(2344);
        }
        dataAligned.setPointer(1728, videocodecBuffer);
        TPointer videocodecBuffer2 = new TPointer(videocodecBuffer, 128);
        dataAligned.setPointer(1732, videocodecBuffer2);
        videocodecBuffer2.clear(40);
        videocodecBuffer.setPointer(16, videocodecBuffer2);
        TPointer mpegAvcYuvStruct = new TPointer(videocodecBuffer2, 64);
        dataAligned.setPointer(1736, mpegAvcYuvStruct);
        mpegAvcYuvStruct.clear(176);
        videocodecBuffer.setPointer(44, mpegAvcYuvStruct);
        TPointer videocodecBuffer3 = new TPointer(mpegAvcYuvStruct, 192);
        dataAligned.setPointer(1740, videocodecBuffer3);
        videocodecBuffer3.clear(100);
        videocodecBuffer.setPointer(48, videocodecBuffer3);
        videocodecBuffer.setValue32(60, 4);
        if (mode >= 3 && mode <= 6) {
            TPointer unknown1744 = new TPointer(videocodecBuffer3, 128);
            dataAligned.setPointer(1744, unknown1744);
            TPointer decodeSEI = new TPointer(unknown1744, 1344);
            dataAligned.setPointer(1776, decodeSEI);
            TPointer unknown1780 = new TPointer(decodeSEI, 192);
            dataAligned.setPointer(1780, unknown1780);
            TPointer unknown1748 = new TPointer(unknown1780, 64);
            dataAligned.setPointer(1748, unknown1748);
            TPointer unknown = new TPointer(unknown1748, 20);
            unknown.setValue32(0, 5);
            unknown.setValue32(4, 0);
            unknown.setValue32(8, 0);
            unknown.setValue32(12, 0);
            unknown.setValue32(16, 0);
            unknown.setPointer(16, new TPointer(unknown1748, 700));
            unknown.setValue32(20, 144);
        }
        if ((result = Modules.sceVideocodecModule.sceVideocodecOpen(videocodecBuffer, 0)) != 0) {
            return result;
        }
        result = Modules.sceVideocodecModule.sceVideocodecInit(videocodecBuffer, 0);
        if (result != 0) {
            return result;
        }
        result = Modules.sceVideocodecModule.sceVideocodecGetVersion(videocodecBuffer, 0);
        if (result != 0) {
            return result;
        }
        videocodecBuffer.setValue32(64, 480);
        videocodecBuffer.setValue32(68, 272);
        videocodecBuffer.setValue32(72, 2);
        videocodecBuffer.setValue32(76, 0);
        result = Modules.sceVideocodecModule.sceVideocodecSetMemory(videocodecBuffer, 0);
        if (result != 0) {
            return result;
        }
        result = Modules.sceMpegbaseModule.sceMpegBaseCscInit(frameWidth);
        if (result != 0) {
            return result;
        }
        if (mode == 1) {
            dataAligned.setValue32(1780, 0);
            dataAligned.setValue32(1784, 0);
            dataAligned.setValue32(1788, 0);
        } else {
            this.initAudiocodecBuffer.setValue16(40, (short)(mode == 3 ? 23644 : 23592));
            this.initAudiocodecBuffer.setValue32(44, 0);
            result = Modules.sceAudiocodecModule.sceAudiocodecCheckNeedMem(this.initAudiocodecBuffer, 4096);
            if (result != 0) {
                return result;
            }
            dataAligned.setValue32(1780, this.initAudiocodecBuffer.getValue32(12));
            dataAligned.setValue32(1784, this.initAudiocodecBuffer.getValue32(16));
            dataAligned.setPointer(1788, audiocodecBuffer);
        }
        mpeg.setValue(dataAligned.getAddress());
        return 0;
    }

    @HLEFunction(nid=1617577545, version=150, checkInsideInterrupt=true, stackUsage=40)
    public int sceMpegDelete(@CheckArgument(value="checkMpeg") TPointer32 mpeg) {
        TPointer data = mpeg.getPointer();
        TPointer videocodecBuffer = data.getPointer(1728);
        Modules.sceVideocodecModule.sceVideocodecDelete(videocodecBuffer, 0);
        DataStream dataStream = DataStream.getFromData(data);
        for (int i = 0; i < 112; ++i) {
            dataStream.init();
            dataStream.nextDataStream();
        }
        return 0;
    }

    @HLEFunction(nid=1112936227, version=150, checkInsideInterrupt=true, stackUsage=72)
    public int sceMpegRegistStream(@CheckArgument(value="checkMpeg") TPointer32 mpeg, int streamType, int streamChannelNum) {
        int streamChannelCode;
        if (streamType < 0 || streamType >= streamTypeDescriptors.length) {
            return -2141126146;
        }
        TPointer data = mpeg.getPointer();
        TPointer streamAddr = this.getStreamAddress(data, streamChannelCode = streamTypeDescriptors[streamType].getChannelCode(streamChannelNum));
        if (streamAddr == null) {
            return 0;
        }
        if (streamType >= 7) {
            return -2141126146;
        }
        streamAddr.setValue32(0, streamChannelCode);
        streamAddr.setValue32(4, streamTypeDescriptors[streamType].getMask());
        streamAddr.setValue32(12, streamType == 0 ? data.getValue32(32) + streamChannelNum * 2048 : 0);
        streamAddr.setValue32(16, Short.MAX_VALUE);
        streamAddr.setValue32(20, streamDataOffsets[streamType]);
        streamAddr.setValue32(24, 1);
        streamAddr.setValue32(32, 0);
        streamAddr.setValue32(40, 0);
        streamAddr.setValue32(44, 0);
        streamAddr.setValue32(48, 0);
        streamAddr.setValue32(52, 0);
        streamAddr.setValue32(56, 0);
        streamAddr.setValue32(64, 0);
        DataStream dataStream = this.getDataStream(data, streamChannelCode);
        if (dataStream == null) {
            return -2141126146;
        }
        if (dataStream.isRegisteredStream()) {
            return -2141093883;
        }
        dataStream.registerStream(streamAddr);
        if (streamType != 0) {
            streamAddr.setValue32(8, -1);
        } else {
            int dataStream6ChannelCode = streamTypeDescriptors[6].getChannelCode(streamChannelNum);
            DataStream dataStream6 = this.getDataStream(data, dataStream6ChannelCode);
            if (dataStream6 == null) {
                return -2141126146;
            }
            if (dataStream6.isRegisteredStream()) {
                return -2141093883;
            }
            dataStream6.registerStream(streamAddr);
            streamAddr.setPointer(8, dataStream6.getDataStreamAddr());
        }
        return streamAddr.getAddress();
    }

    @HLEFunction(nid=1494895266, version=150, checkInsideInterrupt=true, stackUsage=24)
    public int sceMpegUnRegistStream(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=68, usage=BufferInfo.Usage.inout) TPointer streamAddr) {
        TPointer data = mpeg.getPointer();
        DataStream dataStream = this.getDataStream(data, streamAddr);
        if (dataStream == null) {
            return -2141126146;
        }
        if (dataStream.isRegisteredStream()) {
            dataStream.unregisterStream();
            if (streamAddr.getValue32(8) != -1) {
                DataStream dataStream6 = new DataStream(streamAddr.getPointer(8));
                dataStream6.unregisterStream();
            }
        }
        return 0;
    }

    @HLEFunction(nid=-1484730498, version=150, checkInsideInterrupt=true, stackUsage=24)
    public int sceMpegMallocAvcEsBuf(@CheckArgument(value="checkMpeg") TPointer32 mpeg) {
        TPointer data = mpeg.getPointer();
        int result = 0;
        int numberEsBuffers = data.getValue32(1712);
        for (int i = 0; i < numberEsBuffers; ++i) {
            int esBufferState = data.getValue8(1716 + i) & 0xFF;
            if (esBufferState != 0) continue;
            result = i + 1;
            data.setValue8(1716 + i, (byte)1);
            break;
        }
        return result;
    }

    @HLEFunction(nid=-826773327, version=150, checkInsideInterrupt=true, stackUsage=40)
    public int sceMpegFreeAvcEsBuf(@CheckArgument(value="checkMpeg") TPointer32 mpeg, int esBuffer) {
        TPointer data = mpeg.getPointer();
        int numberEsBuffers = data.getValue32(1712);
        if (esBuffer <= 0 || esBuffer > numberEsBuffers) {
            return -2141126146;
        }
        if (esBuffer > numberEsBuffers) {
            return esBuffer;
        }
        data.setValue8(1716 + esBuffer - 1, (byte)0);
        return 0;
    }

    @HLEFunction(nid=-119753095, version=150, checkInsideInterrupt=true, stackUsage=24)
    public int sceMpegQueryAtracEsSize(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 esSizeAddr, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 outSizeAddr) {
        esSizeAddr.setValue(2112);
        outSizeAddr.setValue(8192);
        return 0;
    }

    @HLEFunction(nid=-1070795083, version=150, checkInsideInterrupt=true)
    public int sceMpegQueryPcmEsSize(@CheckArgument(value="checkMpeg") TPointer32 mpeg, TPointer32 esSizeAddr, TPointer32 outSizeAddr) {
        esSizeAddr.setValue(320);
        outSizeAddr.setValue(320);
        return 0;
    }

    @HLEFunction(nid=377159070, version=150, checkInsideInterrupt=true, stackUsage=24)
    public int sceMpegInitAu(@CheckArgument(value="checkMpeg") TPointer32 mpeg, int esBuffer, TPointer auAddr) {
        int esSize = 0;
        auAddr.setValue32(16, esBuffer);
        auAddr.setValue32(20, esSize);
        return 0;
    }

    @HLEFunction(nid=591759022, version=150, checkInsideInterrupt=true)
    public int sceMpegChangeGetAvcAuMode(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=68, usage=BufferInfo.Usage.in) TPointer streamAddr, int mode) {
        TPointer data = mpeg.getPointer();
        DataStream dataStream = this.getDataStream(data, streamAddr);
        if (dataStream == null) {
            return -2141126146;
        }
        if (!dataStream.isRegisteredStream()) {
            return -2141126146;
        }
        if (mode == 0) {
            streamAddr.setValue32(48, streamAddr.getValue32(48) & 0xFFFFFFFD);
        } else if (mode == 2) {
            streamAddr.setValue32(48, streamAddr.getValue32(48) | 2);
        } else {
            return -2141126146;
        }
        return 0;
    }

    @HLEFunction(nid=-1647331350, version=150, checkInsideInterrupt=true)
    public int sceMpegChangeGetAuMode(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=68, usage=BufferInfo.Usage.in) TPointer streamAddr, int mode) {
        TPointer data = mpeg.getPointer();
        DataStream dataStream = this.getDataStream(data, streamAddr);
        if (dataStream == null) {
            return -2141126146;
        }
        if (mode == 0) {
            streamAddr.setValue32(48, streamAddr.getValue32(48) & 0xFFFFFFFE);
        } else if (mode == 1) {
            streamAddr.setValue32(48, streamAddr.getValue32(48) | 1);
        } else {
            return -2141126146;
        }
        return 0;
    }

    @HLEFunction(nid=-31168728, version=150, checkInsideInterrupt=true)
    public int sceMpegGetAvcAu(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=68, usage=BufferInfo.Usage.in) TPointer streamAddr, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=24, usage=BufferInfo.Usage.out) TPointer auAddr, @BufferInfo(usage=BufferInfo.Usage.out) @CanBeNull TPointer32 attrAddr) {
        int result;
        if (streamAddr.getValue32(8) == -1) {
            return -2141126146;
        }
        TPointer data = mpeg.getPointer();
        DataStream dataStream = this.getDataStream(data, streamAddr);
        if (dataStream == null) {
            return -2141093887;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMpegGetAvcAu dataStream=%s", dataStream));
        }
        SceMpegStreamPacketInfo packetInfo = new SceMpegStreamPacketInfo();
        while (true) {
            int value;
            if ((result = this.getFirstStreamPacket(dataStream, packetInfo)) < 0) {
                result = -2141093887;
                break;
            }
            TPointer dataAddr = streamAddr.getPointer(12);
            if (streamAddr.getValue32(44) == 0) {
                SceMpegAu au = new SceMpegAu();
                au.read(auAddr);
                au.esSize = 0;
                if (streamAddr.getValue32(16) == Short.MAX_VALUE) {
                    SceMpegStreamPacketInfo stream6PacketInfo;
                    au.pts = packetInfo.pts;
                    au.dts = packetInfo.dts;
                    DataStream dataStream6 = new DataStream(streamAddr.getPointer(8));
                    result = this.getFirstStreamPacket(dataStream6, stream6PacketInfo = new SceMpegStreamPacketInfo());
                    if (result < 0) {
                        result = -2141093887;
                        break;
                    }
                    SceMpegRingbuffer sceMpegRingbuffer = new SceMpegRingbuffer();
                    sceMpegRingbuffer.read(data.getPointer(16));
                    if (this.compareAddresses(sceMpegRingbuffer, packetInfo.packetDataAddr, stream6PacketInfo.packetDataAddr) == 1) {
                        result = this.sceMpegNextAvcRpAu(mpeg, streamAddr);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("sceMpegGetAvcAu skipped next frame, returning 0x%X", result));
                        }
                        if (result == 0) continue;
                        if (result != -2141093884) break;
                        result = -2141093887;
                        break;
                    }
                    this.dequeueStreamPackets(dataStream6, 1);
                    dataAddr.memcpy(stream6PacketInfo.packetDataAddr, stream6PacketInfo.packetDataLength);
                    streamAddr.setValue32(16, 0);
                    streamAddr.setValue16(28, (short)0);
                } else {
                    au.pts = -1L;
                    au.dts = -1L;
                }
                au.write(auAddr);
                int value2 = Utilities.endianSwap32(dataAddr.getUnalignedValue32(18 + 4 * streamAddr.getValue32(16)));
                streamAddr.setValue32(36, value2 & 0x1FFFFF);
            }
            boolean setBit = ((value = Utilities.endianSwap32(dataAddr.getUnalignedValue32(18 + 4 * streamAddr.getValue32(16)))) & 0x800000) == 0 ? false : (data.getValue32(12) == 0 ? (dataAddr.getValue8(17) & 0xFF) - 1 != streamAddr.getValue32(16) : true);
            if (setBit) {
                streamAddr.setValue32(48, streamAddr.getValue32(48) | Integer.MIN_VALUE);
            } else {
                streamAddr.setValue32(48, streamAddr.getValue32(48) & Integer.MAX_VALUE);
            }
            if (attrAddr.isNotNull()) {
                int attrValue = streamAddr.getValue32(48) >>> 31;
                attrAddr.setValue(attrValue |= (dataAddr.getValue8(18 + 4 * streamAddr.getValue32(16)) & 0xF) << 1);
            }
            if ((result = this.copyStreamData(data, streamAddr, auAddr, 0)) == 0) {
                if (streamAddr.getValue32(16) < (dataAddr.getValue8(17) & 0xFF) - 1) {
                    streamAddr.setValue32(16, streamAddr.getValue32(16) + 1);
                } else {
                    streamAddr.setValue32(16, Short.MAX_VALUE);
                }
            }
            if (result != 0 || (streamAddr.getValue32(48) & 4) == 0) break;
            streamAddr.setValue32(48, streamAddr.getValue32(48) & 0xFFFFFFFB);
        }
        return result;
    }

    @HLEFunction(nid=-1944190339, version=150, checkInsideInterrupt=true)
    public int sceMpegGetPcmAu(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=68, usage=BufferInfo.Usage.in) TPointer streamAddr, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=24, usage=BufferInfo.Usage.out) TPointer auAddr, @BufferInfo(usage=BufferInfo.Usage.out) @CanBeNull TPointer32 attrAddr) {
        int result;
        TPointer data = mpeg.getPointer();
        DataStream dataStream = this.getDataStream(data, streamAddr);
        if (dataStream == null) {
            return -2141126146;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMpegGetPcmAu dataStream=%s", dataStream));
        }
        SceMpegStreamPacketInfo packetInfo = new SceMpegStreamPacketInfo();
        SceMpegAu au = new SceMpegAu();
        au.read(auAddr);
        while (true) {
            result = this.getFirstStreamPacket(dataStream, packetInfo);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("sceMpegGetPcmAu stream packet 0x%X: %s", result, packetInfo));
            }
            if (result < 0) {
                result = -2141093887;
                break;
            }
            if (streamAddr.getValue32(44) == 0) {
                int value;
                TPointer dataAddr;
                au.esSize = 0;
                while (true) {
                    if ((result = this.getFirstStreamPacket(dataStream, packetInfo)) < 0) {
                        au.write(auAddr);
                        return -2141093887;
                    }
                    dataAddr = new TPointer(data.getMemory(), packetInfo.packetDataAddr);
                    if ((streamAddr.getValue32(24) & 1) == 0) {
                        au.pts = -1L;
                        au.dts = -1L;
                        break;
                    }
                    value = Utilities.endianSwap16(dataAddr.getUnalignedValue16(2));
                    streamAddr.setValue16(28, (short)value);
                    if (value != -1) {
                        au.pts = packetInfo.pts;
                        au.dts = packetInfo.dts;
                        streamAddr.setValue32(24, 0);
                        break;
                    }
                    this.dequeueStreamPackets(dataStream, 1);
                }
                au.write(auAddr);
                value = dataAddr.getValue8(1) & 0xFF;
                streamAddr.setValue32(64, value);
                streamAddr.setValue32(36, (value & 0xF) * 160);
            }
            if (attrAddr.isNotNull()) {
                attrAddr.setValue(streamAddr.getValue32(64));
            }
            if ((result = this.copyStreamData(data, streamAddr, auAddr, 2)) != 0 || (streamAddr.getValue32(48) & 4) == 0) break;
            streamAddr.setValue32(48, streamAddr.getValue32(48) & 0xFFFFFFFB);
        }
        return result;
    }

    @HLEFunction(nid=-506559577, version=150, checkInsideInterrupt=true)
    public int sceMpegGetAtracAu(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=68, usage=BufferInfo.Usage.in) TPointer streamAddr, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=24, usage=BufferInfo.Usage.out) TPointer auAddr, @BufferInfo(usage=BufferInfo.Usage.out) @CanBeNull TPointer32 attrAddr) {
        int result;
        TPointer data = mpeg.getPointer();
        DataStream dataStream = this.getDataStream(data, streamAddr);
        if (dataStream == null) {
            return -2141126146;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMpegGetAtracAu dataStream=%s", dataStream));
        }
        SceMpegStreamPacketInfo packetInfo = new SceMpegStreamPacketInfo();
        SceMpegAu au = new SceMpegAu();
        au.read(auAddr);
        while (true) {
            result = this.getFirstStreamPacket(dataStream, packetInfo);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("sceMpegGetAtracAu stream packet 0x%X: %s", result, packetInfo));
            }
            if (result < 0) {
                result = -2141093887;
                break;
            }
            if (streamAddr.getValue32(44) == 0) {
                au.esSize = 0;
            }
            if (streamAddr.getValue32(44) == 0 || streamAddr.getValue32(56) != 0) {
                while (true) {
                    if ((result = this.getFirstStreamPacket(dataStream, packetInfo)) < 0) {
                        au.write(auAddr);
                        return -2141093887;
                    }
                    if ((streamAddr.getValue32(24) & 1) == 0) {
                        au.pts = -1L;
                        au.dts = -1L;
                        break;
                    }
                    TPointer dataAddr = new TPointer(data.getMemory(), packetInfo.packetDataAddr);
                    short value = (short)Utilities.endianSwap16(dataAddr.getUnalignedValue16(2));
                    streamAddr.setValue16(28, value);
                    if (value != -1) {
                        au.pts = packetInfo.pts;
                        au.dts = packetInfo.dts;
                        streamAddr.setValue32(24, 0);
                        break;
                    }
                    this.dequeueStreamPackets(dataStream, 1);
                }
                au.write(auAddr);
                if (streamAddr.getValue32(56) == 0) {
                    streamAddr.setValue32(56, 4);
                }
                int sourceOffset = streamAddr.getValue16(28) + 4;
                int length = packetInfo.packetDataLength - sourceOffset;
                TPointer destinationAddr = new TPointer(streamAddr, 60 + (4 - streamAddr.getValue32(56)));
                int packetIndex = 1;
                while (true) {
                    if (length >= streamAddr.getValue32(56)) {
                        length = streamAddr.getValue32(56);
                        destinationAddr.memcpy(packetInfo.packetDataAddr + sourceOffset, length);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("sceMpegGetAtracAu memcpy(%s, 0x%08X, 0x%X)", destinationAddr, packetInfo.packetDataAddr + sourceOffset, length));
                        }
                        streamAddr.setValue32(56, 0);
                        int audioFrameLength = ((Utilities.endianSwap16(streamAddr.getUnalignedValue16(62)) & 0x3FF) << 3) + 8;
                        streamAddr.setValue32(36, audioFrameLength - streamAddr.getValue32(44) + 8);
                        break;
                    }
                    destinationAddr.memcpy(packetInfo.packetDataAddr + sourceOffset, length);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("sceMpegGetAtracAu memcpy(%s, 0x%08X, 0x%X)", destinationAddr, packetInfo.packetDataAddr + sourceOffset, length));
                    }
                    destinationAddr.add(length);
                    streamAddr.setValue32(56, streamAddr.getValue32(56) - length);
                    result = this.getStreamPacket(dataStream, packetIndex, packetInfo);
                    if (result < 0) {
                        streamAddr.setValue32(36, 4);
                        streamAddr.setValue32(52, 1);
                        break;
                    }
                    sourceOffset = 4;
                    length = packetInfo.packetDataLength - 4;
                    ++packetIndex;
                }
            }
            result = this.copyStreamData(data, streamAddr, auAddr, 1);
            if (attrAddr.isNotNull() && result == 0) {
                attrAddr.setValue(au.esBuffer + 8);
            }
            if (result != 0 || (streamAddr.getValue32(48) & 4) == 0) break;
            streamAddr.setValue32(48, streamAddr.getValue32(48) & 0xFFFFFFFB);
        }
        return result;
    }

    @HLEFunction(nid=1343161385, version=150, checkInsideInterrupt=true)
    public int sceMpegFlushStream(@CheckArgument(value="checkMpeg") TPointer32 mpeg, TPointer streamAddr) {
        TPointer data = mpeg.getPointer();
        DataStream dataStream = this.getDataStream(data, streamAddr);
        if (dataStream == null) {
            return -2141126146;
        }
        int channelCode = streamAddr.getValue32(0);
        int streamType = -1;
        for (int i = 0; i < streamTypeDescriptors.length; ++i) {
            if (!streamTypeDescriptors[i].isMatching(channelCode)) continue;
            streamType = i;
            break;
        }
        if (streamType < 0 || streamType >= streamDataOffsets.length) {
            return -2141126146;
        }
        if (dataStream.isRegisteredStream()) {
            dataStream.clear();
            if (streamAddr.getValue32(8) != -1) {
                DataStream dataStream6 = new DataStream(streamAddr.getPointer(8));
                dataStream6.clear();
            }
        }
        streamAddr.setValue32(16, Short.MAX_VALUE);
        streamAddr.setValue32(20, streamDataOffsets[streamType]);
        streamAddr.setValue32(24, 1);
        streamAddr.setValue32(32, 0);
        streamAddr.setValue32(40, 0);
        streamAddr.setValue32(44, 0);
        streamAddr.setValue32(48, streamAddr.getValue32(48) & 0xFFFFFFFB);
        streamAddr.setValue32(52, 0);
        streamAddr.setValue32(56, 0);
        streamAddr.setValue32(64, 0);
        return 0;
    }

    @HLEFunction(nid=1887139369, version=150, checkInsideInterrupt=true)
    public int sceMpegFlushAllStream(@CheckArgument(value="checkMpeg") TPointer32 mpeg) {
        TPointer data = mpeg.getPointer();
        DataStream dataStream = DataStream.getFromData(data);
        for (int i = 0; i < 112; ++i) {
            int result;
            if (dataStream.isRegisteredStream() && (result = this.sceMpegFlushStream(mpeg, dataStream.getRegisteredStream())) != 0) {
                return result;
            }
            dataStream.nextDataStream();
        }
        return 0;
    }

    @HLEFunction(nid=238825117, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcDecode(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=24, usage=BufferInfo.Usage.inout) TPointer auAddr, int frameWidth, @CanBeNull TPointer32 bufferAddr, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 gotFrameAddr) {
        TPointer data = mpeg.getPointer();
        SceMpegAu au = new SceMpegAu();
        au.read(auAddr);
        TPointer videocodecBuffer = data.getPointer(1728);
        videocodecBuffer.setValue32(36, this.getEsBufferAddress(data, au.esBuffer) & 0xFFFFFFF);
        videocodecBuffer.setValue32(40, au.esSize);
        AfterVideocodecDecodeAction afterVideocodecAction = new AfterVideocodecDecodeAction(data, auAddr, frameWidth, bufferAddr, gotFrameAddr);
        return Modules.sceVideocodecModule.hleVideocodecDecode(videocodecBuffer, 0, afterVideocodecAction);
    }

    @HLEFunction(nid=258742487, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcDecodeDetail(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=52, usage=BufferInfo.Usage.out) TPointer detailPointer) {
        TPointer data = mpeg.getPointer();
        return this.getDecodeDetail(data, 0, detailPointer);
    }

    @HLEFunction(nid=-1591971802, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcDecodeMode(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=8, usage=BufferInfo.Usage.in) TPointer32 modeAddr) {
        int pixelMode;
        TPointer data = mpeg.getPointer();
        int mode = modeAddr.getValue(0);
        if (mode != -1) {
            if (mode < 0 || mode > 2) {
                return -2141126146;
            }
            TPointer videocodecBuffer = data.getPointer(1728);
            videocodecBuffer.setValue32(52, mode);
        }
        if ((pixelMode = modeAddr.getValue(4)) != -1) {
            int internalPixelMode;
            switch (pixelMode) {
                case 0: {
                    internalPixelMode = 1;
                    break;
                }
                case 1: {
                    internalPixelMode = 2;
                    break;
                }
                case 2: {
                    internalPixelMode = 3;
                    break;
                }
                case 3: {
                    internalPixelMode = 0;
                    break;
                }
                default: {
                    return -2141126146;
                }
            }
            Modules.sceMpegbaseModule.sceMpegbase_0530BE4E(internalPixelMode);
        }
        return 0;
    }

    @HLEFunction(nid=1947192529, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcDecodeStop(@CheckArgument(value="checkMpeg") TPointer32 mpeg, int frameWidth, @BufferInfo(usage=BufferInfo.Usage.in) @CanBeNull TPointer32 bufferAddr, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 gotFrameAddr) {
        TPointer data = mpeg.getPointer();
        int result = this.sceMpegAvcDecodeFlush(mpeg);
        if (result != 0) {
            return result;
        }
        TPointer videocodecBuffer2 = data.getPointer(1732);
        TPointer mpegAvcYuvStruct = data.getPointer(1736);
        int numberOfDecodedImages = videocodecBuffer2.getValue32(32);
        gotFrameAddr.setValue(numberOfDecodedImages);
        int mode = data.getValue32(1708);
        if (mode < 3 || mode > 6) {
            for (int i = 0; i < numberOfDecodedImages; ++i) {
                SceMp4AvcCscStruct mp4AvcCscStruct = new SceMp4AvcCscStruct();
                mp4AvcCscStruct.height = videocodecBuffer2.getValue32(12) >> 4;
                mp4AvcCscStruct.width = videocodecBuffer2.getValue32(8) >> 4;
                mp4AvcCscStruct.mode0 = 0;
                mp4AvcCscStruct.mode1 = 0;
                mp4AvcCscStruct.buffer0 = mpegAvcYuvStruct.getValue32(0);
                mp4AvcCscStruct.buffer1 = mpegAvcYuvStruct.getValue32(4);
                mp4AvcCscStruct.buffer2 = mpegAvcYuvStruct.getValue32(8);
                mp4AvcCscStruct.buffer3 = mpegAvcYuvStruct.getValue32(12);
                mp4AvcCscStruct.buffer4 = mpegAvcYuvStruct.getValue32(16);
                mp4AvcCscStruct.buffer5 = mpegAvcYuvStruct.getValue32(20);
                mp4AvcCscStruct.buffer6 = mpegAvcYuvStruct.getValue32(24);
                mp4AvcCscStruct.buffer7 = mpegAvcYuvStruct.getValue32(28);
                mp4AvcCscStruct.bufferMemory = data.getMemory();
                TPointer buffer = bufferAddr.getPointer(i * 4);
                if (buffer.isNull()) {
                    return -2141126146;
                }
                result = Modules.sceMpegbaseModule.hleMpegBaseCscAvc(buffer, TPointer.NULL, frameWidth, Modules.sceMpegbaseModule.getPixelMode(), mp4AvcCscStruct);
                if (result != 0) break;
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("sceMpegAvcDecode numberOfDecodedImages=%d, buffer=%s", numberOfDecodedImages, buffer));
                }
                mpegAvcYuvStruct.add(44);
            }
        }
        return result;
    }

    @HLEFunction(nid=1165085796, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcDecodeFlush(@CheckArgument(value="checkMpeg") TPointer32 mpeg) {
        TPointer data = mpeg.getPointer();
        TPointer videocodecBuffer = data.getPointer(1728);
        return Modules.sceVideocodecModule.sceVideocodecStop(videocodecBuffer, 0);
    }

    @HLEFunction(nid=555353468, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcQueryYCbCrSize(@CheckArgument(value="checkMpeg") TPointer32 mpeg, int mode, int width, int height, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 resultAddr) {
        int size;
        resultAddr.setValue(0);
        switch (mode) {
            case 1: {
                if ((width & 0xF) != 0 || (height & 0xF) != 0 || width > 480 || width <= 16 || height > 272 || height <= 0) {
                    return -2141126146;
                }
                size = 128 + (sceMpeg.getYCbCrSize1(width, height) + sceMpeg.getYCbCrSize2(width, height)) * 3;
                break;
            }
            case 2: {
                size = 128;
                break;
            }
            case 3: {
                size = width * height * 3 >> 1;
                break;
            }
            default: {
                return -2141126146;
            }
        }
        resultAddr.setValue(size);
        return 0;
    }

    @HLEFunction(nid=1729600283, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcInitYCbCr(@CheckArgument(value="checkMpeg") TPointer32 mpeg, int mode, int width, int height, TPointer yCbCrBuffer) {
        switch (mode) {
            case 1: {
                TPointer ptr = new TPointer(yCbCrBuffer);
                int size1 = sceMpeg.getYCbCrSize1(width, height);
                int size2 = sceMpeg.getYCbCrSize2(width, height);
                ptr.clear(128);
                ptr.add(128);
                yCbCrBuffer.setPointer(16, ptr);
                ptr.add(size1);
                yCbCrBuffer.setPointer(24, ptr);
                ptr.add(size1);
                yCbCrBuffer.setPointer(32, ptr);
                ptr.add(size1 >>= 1);
                yCbCrBuffer.setPointer(40, ptr);
                ptr.add(size1);
                yCbCrBuffer.setPointer(20, ptr);
                ptr.add(size2);
                yCbCrBuffer.setPointer(28, ptr);
                ptr.add(size2);
                yCbCrBuffer.setPointer(36, ptr);
                ptr.add(size2 >>= 1);
                yCbCrBuffer.setPointer(44, ptr);
                break;
            }
            case 2: {
                yCbCrBuffer.clear(128);
                yCbCrBuffer.setValue32(16, mode);
                yCbCrBuffer.setValue32(20, mode);
                yCbCrBuffer.setValue32(24, mode);
                yCbCrBuffer.setValue32(28, mode);
                yCbCrBuffer.setValue32(32, mode);
                yCbCrBuffer.setValue32(36, mode);
                yCbCrBuffer.setValue32(40, mode);
                yCbCrBuffer.setValue32(44, mode);
                break;
            }
            case 3: {
                int length = width * height;
                yCbCrBuffer.memset((byte)16, length);
                yCbCrBuffer.add(length);
                int length4 = length >> 2;
                yCbCrBuffer.memset((byte)-128, length4);
                yCbCrBuffer.add(length4);
                yCbCrBuffer.memset((byte)-128, length4);
                break;
            }
            default: {
                return -2141126146;
            }
        }
        return 0;
    }

    @HLEFunction(nid=-253030107, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcDecodeYCbCr(@CheckArgument(value="checkMpeg") TPointer32 mpeg, TPointer auAddr, TPointer32 bufferAddr, TPointer32 gotFrameAddr) {
        TPointer data = mpeg.getPointer();
        SceMpegAu au = new SceMpegAu();
        au.read(auAddr);
        TPointer videocodecBuffer = data.getPointer(1728);
        videocodecBuffer.setValue32(36, this.getEsBufferAddress(data, au.esBuffer) & 0xFFFFFFF);
        videocodecBuffer.setValue32(40, au.esSize);
        AfterVideocodecDecodeYCbCrAction afterVideocodecAction = new AfterVideocodecDecodeYCbCrAction(data, auAddr, bufferAddr, gotFrameAddr);
        return Modules.sceVideocodecModule.hleVideocodecDecode(videocodecBuffer, 0, afterVideocodecAction);
    }

    @HLEFunction(nid=-225244004, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcDecodeStopYCbCr(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @CanBeNull TPointer32 bufferAddr, TPointer32 gotFrameAddr) {
        TPointer data = mpeg.getPointer();
        int result = this.sceMpegAvcDecodeFlush(mpeg);
        if (result != 0) {
            return result;
        }
        return this.completeAvcDecodeYCbCr(data, bufferAddr, gotFrameAddr);
    }

    @HLEFunction(nid=834470514, version=150, checkInsideInterrupt=true)
    public int sceMpegAvcCsc(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=52, usage=BufferInfo.Usage.in) TPointer sourceAddr, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.in) TPointer32 rangeAddr, int frameWidth, TPointer destAddr) {
        TPointer data = mpeg.getPointer();
        SceMp4AvcCscStruct sceMp4AvcCscStruct = new SceMp4AvcCscStruct();
        sceMp4AvcCscStruct.bufferMemory = this.sceMpegAvcCscBuffer1.getMemory();
        sceMp4AvcCscStruct.height = sourceAddr.getValue32(0);
        sceMp4AvcCscStruct.width = sourceAddr.getValue32(4);
        sceMp4AvcCscStruct.mode0 = sourceAddr.getValue32(8);
        sceMp4AvcCscStruct.mode1 = sourceAddr.getValue32(12);
        if (sourceAddr.getValue32(16) == 2) {
            TPointer mpegAvcYuvStruct = data.getPointer(1736);
            int index = sourceAddr.getValue32(48);
            mpegAvcYuvStruct.add(index * 44);
            sceMp4AvcCscStruct.buffer0 = mpegAvcYuvStruct.getValue32(0) + sceMpegAvcCscOffsets[0];
            sceMp4AvcCscStruct.buffer1 = mpegAvcYuvStruct.getValue32(4) + sceMpegAvcCscOffsets[1];
            sceMp4AvcCscStruct.buffer2 = mpegAvcYuvStruct.getValue32(8) + sceMpegAvcCscOffsets[0];
            sceMp4AvcCscStruct.buffer3 = mpegAvcYuvStruct.getValue32(12) + sceMpegAvcCscOffsets[1];
            sceMp4AvcCscStruct.buffer4 = mpegAvcYuvStruct.getValue32(16) + sceMpegAvcCscOffsets[2];
            sceMp4AvcCscStruct.buffer5 = mpegAvcYuvStruct.getValue32(20) + sceMpegAvcCscOffsets[3];
            sceMp4AvcCscStruct.buffer6 = mpegAvcYuvStruct.getValue32(24) + sceMpegAvcCscOffsets[2];
            sceMp4AvcCscStruct.buffer7 = mpegAvcYuvStruct.getValue32(28) + sceMpegAvcCscOffsets[3];
        } else {
            sceMp4AvcCscStruct.buffer0 = sourceAddr.getValue32(16) + sceMpegAvcCscOffsets[0];
            sceMp4AvcCscStruct.buffer1 = sourceAddr.getValue32(20) + sceMpegAvcCscOffsets[1];
            sceMp4AvcCscStruct.buffer2 = sourceAddr.getValue32(24) + sceMpegAvcCscOffsets[0];
            sceMp4AvcCscStruct.buffer3 = sourceAddr.getValue32(28) + sceMpegAvcCscOffsets[1];
            sceMp4AvcCscStruct.buffer4 = sourceAddr.getValue32(32) + sceMpegAvcCscOffsets[2];
            sceMp4AvcCscStruct.buffer5 = sourceAddr.getValue32(36) + sceMpegAvcCscOffsets[3];
            sceMp4AvcCscStruct.buffer6 = sourceAddr.getValue32(40) + sceMpegAvcCscOffsets[2];
            sceMp4AvcCscStruct.buffer7 = sourceAddr.getValue32(44) + sceMpegAvcCscOffsets[3];
        }
        sceMp4AvcCscStruct.write(this.sceMpegAvcCscBuffer1);
        int rangeX = rangeAddr.getValue(0);
        int rangeY = rangeAddr.getValue(4);
        int rangeWidth = rangeAddr.getValue(8);
        int rangeHeight = rangeAddr.getValue(12);
        if (((rangeX | rangeY | rangeWidth | rangeHeight) & 0xF) != 0) {
            return -2141126146;
        }
        TPointer32 sceMpegBaseCscAvcRangeAddr = this.sceMpegAvcCscBuffer2;
        sceMpegBaseCscAvcRangeAddr.setValue(0, rangeX >>> 4);
        sceMpegBaseCscAvcRangeAddr.setValue(4, rangeY >>> 4);
        sceMpegBaseCscAvcRangeAddr.setValue(8, rangeWidth >>> 4);
        sceMpegBaseCscAvcRangeAddr.setValue(12, rangeHeight >>> 4);
        int result = Modules.sceMpegbaseModule.sceMpegBaseCscAvcRange(destAddr, TPointer.NULL, sceMpegBaseCscAvcRangeAddr, frameWidth, this.sceMpegAvcCscBuffer1);
        Modules.ThreadManForUserModule.hleKernelDelayThread(3000, false);
        return result;
    }

    @HLEFunction(nid=-2146679585, version=150, checkInsideInterrupt=true)
    public int sceMpegAtracDecode(@CheckArgument(value="checkMpeg") TPointer32 mpeg, TPointer auAddr, TPointer bufferAddr, int init) {
        TPointer data = mpeg.getPointer();
        if (data.getValue32(1708) == 1) {
            return -2141126146;
        }
        SceMpegAu au = new SceMpegAu();
        au.read(auAddr);
        TPointer audiocodecBuffer = data.getPointer(1788);
        if (init == 1) {
            audiocodecBuffer.setValue32(12, data.getValue32(1780));
            audiocodecBuffer.setValue32(20, 1);
            audiocodecBuffer.memcpy(40, au.esBuffer + 2, 2);
            audiocodecBuffer.memcpy(44, au.esBuffer + 4, 4);
            audiocodecBuffer.setValue32(48, 1);
            int result = Modules.sceAudiocodecModule.sceAudiocodecCheckNeedMem(audiocodecBuffer, 4096);
            if (result != 0) {
                return result;
            }
            if (data.getValue32(1784) < audiocodecBuffer.getValue32(16)) {
                return -2139160321;
            }
            result = Modules.sceAudiocodecModule.sceAudiocodecInit(audiocodecBuffer, 4096);
            if (result != 0) {
                return result;
            }
        }
        audiocodecBuffer.setValue32(24, au.esBuffer);
        audiocodecBuffer.setPointer(32, bufferAddr);
        return Modules.sceAudiocodecModule.sceAudiocodecDecode(audiocodecBuffer, 4096);
    }

    @HLEFunction(nid=-677208250, version=150, checkInsideInterrupt=true, stackUsage=8)
    public int sceMpegRingbufferQueryMemSize(int packets) {
        return sceMpeg.getSizeFromPackets(packets);
    }

    @HLEFunction(nid=925458136, version=150, checkInsideInterrupt=true, stackUsage=56)
    public int sceMpegRingbufferConstruct(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=48, usage=BufferInfo.Usage.out) TPointer ringbufferAddr, int packets, @CanBeNull TPointer data, int size, @CanBeNull TPointer callbackAddr, int callbackArgs) {
        if (size < sceMpeg.getSizeFromPackets(packets)) {
            log.warn((Object)String.format("sceMpegRingbufferConstruct insufficient space: size=%d, packets=%d", size, packets));
            return -2141126622;
        }
        SceMpegRingbuffer ringbuffer = new SceMpegRingbuffer();
        ringbuffer.packets = packets;
        ringbuffer.packetSize = 2048;
        ringbuffer.data = data.getAddress();
        ringbuffer.callbackAddr = callbackAddr.getAddress();
        ringbuffer.callbackArgs = callbackArgs;
        ringbuffer.dataUpperBound = ringbuffer.data + ringbuffer.packets * ringbuffer.packetSize;
        ringbuffer.gp = RuntimeContext.processor.cpu._gp;
        ringbuffer.write(ringbufferAddr);
        return 0;
    }

    @HLEFunction(nid=322993939, version=150, checkInsideInterrupt=true, stackUsage=8)
    public int sceMpegRingbufferDestruct(TPointer ringbufferAddr) {
        return 0;
    }

    @HLEFunction(nid=-1304386146, version=150, checkInsideInterrupt=true)
    public int sceMpegRingbufferPut(@CheckArgument(value="checkRingbuffer") TPointer ringbufferAddr, int numPackets, int available) {
        if ((numPackets = Math.min(numPackets, available)) <= 0) {
            return 0;
        }
        SceMpegRingbuffer sceMpegRingbuffer = new SceMpegRingbuffer();
        sceMpegRingbuffer.read(ringbufferAddr);
        int callbackNumPackets = numPackets;
        if (sceMpegRingbuffer.packets < sceMpegRingbuffer.packetsWritten + numPackets) {
            callbackNumPackets = sceMpegRingbuffer.packets - sceMpegRingbuffer.packetsWritten;
        }
        int callbackDataAddress = sceMpegRingbuffer.data + sceMpegRingbuffer.packetsWritten * sceMpegRingbuffer.packetSize;
        AfterRingbufferPutCallback afterRingbufferPutCallback = new AfterRingbufferPutCallback(ringbufferAddr, numPackets - callbackNumPackets, this.getProcessor().cpu._gp);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMpegRingbufferPut calling callback 0x%08X with dataAddress=0x%08X, numPackets=0x%X", sceMpegRingbuffer.callbackAddr, callbackDataAddress, callbackNumPackets));
        }
        this.getProcessor().cpu._gp = sceMpegRingbuffer.gp;
        Modules.ThreadManForUserModule.executeCallback(null, sceMpegRingbuffer.callbackAddr, afterRingbufferPutCallback, false, callbackDataAddress, callbackNumPackets, sceMpegRingbuffer.callbackArgs);
        return afterRingbufferPutCallback.getReturnValue();
    }

    @HLEFunction(nid=-1242112889, version=150, checkInsideInterrupt=true)
    public int sceMpegRingbufferAvailableSize(@CheckArgument(value="checkRingbuffer") TPointer ringbufferAddr) {
        SceMpegRingbuffer sceMpegRingbuffer = new SceMpegRingbuffer();
        sceMpegRingbuffer.read(ringbufferAddr);
        if (sceMpegRingbuffer.packets == sceMpegRingbuffer.packetsInRingbuffer) {
            return 0;
        }
        int minPacketIndex = sceMpegRingbuffer.packetsRead;
        TPointer data = sceMpegRingbuffer.mpeg.getPointer();
        DataStream dataStream = DataStream.getFromData(data);
        for (int i = 0; i < 112; ++i) {
            if (dataStream.isRegisteredStream() && !dataStream.isEmptyQueue()) {
                int size = dataStream.getStreamPacketsQueueHead().getValue32(36) - sceMpegRingbuffer.data;
                int packetIndex = size / sceMpegRingbuffer.packetSize;
                if (packetIndex == sceMpegRingbuffer.packetsWritten && size > 0) {
                    minPacketIndex = -1;
                    break;
                }
                if (sceMpegRingbuffer.packetsWritten < sceMpegRingbuffer.packetsRead) {
                    if (packetIndex < minPacketIndex) {
                        minPacketIndex = packetIndex;
                    }
                } else if (sceMpegRingbuffer.packetsWritten < packetIndex) {
                    if (sceMpegRingbuffer.packetsRead >= minPacketIndex || packetIndex < minPacketIndex) {
                        minPacketIndex = packetIndex;
                    }
                } else if (sceMpegRingbuffer.packetsRead >= minPacketIndex && packetIndex < sceMpegRingbuffer.packetsRead && packetIndex < minPacketIndex) {
                    minPacketIndex = packetIndex;
                }
            }
            dataStream.nextDataStream();
        }
        if (minPacketIndex == -1) {
            return 0;
        }
        int limit = sceMpegRingbuffer.packetsWritten < sceMpegRingbuffer.packetsRead || sceMpegRingbuffer.packetsRead >= minPacketIndex ? 0 : sceMpegRingbuffer.packets;
        return sceMpegRingbuffer.packets - sceMpegRingbuffer.packetsInRingbuffer - sceMpegRingbuffer.packetsRead + minPacketIndex - limit;
    }

    @HLEFunction(nid=1010280358, version=150, checkInsideInterrupt=true)
    public int sceMpegNextAvcRpAu(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=68, usage=BufferInfo.Usage.in) TPointer streamAddr) {
        int dataStream6DataAddr;
        TPointer data = mpeg.getPointer();
        DataStream dataStream = this.getDataStream(data, streamAddr);
        if (dataStream == null) {
            return -2141126146;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMpegNextAvcRpAu dataStream=%s", dataStream));
        }
        SceMpegStreamPacketInfo packetInfo = new SceMpegStreamPacketInfo();
        int result = this.getFirstStreamPacket(new DataStream(streamAddr.getPointer(8)), packetInfo);
        if (result != 0) {
            result = -2141093884;
            dataStream6DataAddr = 0;
        } else {
            dataStream6DataAddr = packetInfo.packetDataAddr;
        }
        int count = dataStream.getStreamPacketsCount();
        if (count > 0) {
            SceMpegRingbuffer sceMpegRingbuffer = new SceMpegRingbuffer();
            sceMpegRingbuffer.read(data.getPointer(16));
            int processed = 0;
            int i = 0;
            while (i < count) {
                this.getFirstStreamPacket(dataStream, packetInfo);
                if (dataStream6DataAddr != 0 && this.compareAddresses(sceMpegRingbuffer, dataStream6DataAddr, packetInfo.packetDataAddr) == 1) break;
                this.dequeueStreamPackets(dataStream, 1);
                ++i;
                ++processed;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("sceMpegNextAvcRpAu removed %d packets from data stream %s", processed, dataStream));
            }
        }
        streamAddr.setValue32(16, Short.MAX_VALUE);
        streamAddr.setValue32(44, 0);
        streamAddr.setValue32(48, streamAddr.getValue32(48) & 0xFFFFFFFB);
        return result;
    }

    @HLEFunction(nid=26701908, version=150)
    public int sceMpegGetUserdataAu(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=68, usage=BufferInfo.Usage.in) TPointer streamAddr, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=24, usage=BufferInfo.Usage.out) TPointer auAddr, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=8, usage=BufferInfo.Usage.out) @CanBeNull TPointer headerAddr) {
        int result;
        TPointer data = mpeg.getPointer();
        DataStream dataStream = this.getDataStream(data, streamAddr);
        if (dataStream == null) {
            return -2141126146;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMpegGetUserdataAu dataStream=%s", dataStream));
        }
        SceMpegStreamPacketInfo packetInfo = new SceMpegStreamPacketInfo();
        SceMpegAu au = new SceMpegAu();
        au.read(auAddr);
        while (true) {
            result = this.getFirstStreamPacket(dataStream, packetInfo);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("sceMpegGetUserdataAu stream packet 0x%X: %s", result, packetInfo));
            }
            if (result < 0) {
                result = -2141093887;
                break;
            }
            if (streamAddr.getValue32(56) != 0 || streamAddr.getValue32(44) == 0 && streamAddr.getValue32(52) != 1) {
                int startHeaderOffset;
                if (streamAddr.getValue32(44) == 0) {
                    au.esSize = 0;
                    while (true) {
                        if ((result = this.getFirstStreamPacket(dataStream, packetInfo)) < 0) {
                            au.write(auAddr);
                            return -2141093887;
                        }
                        if (packetInfo.dts != -1L || packetInfo.pts != -1L) {
                            if ((streamAddr.getValue32(24) & 1) == 0) break;
                            au.pts = packetInfo.pts;
                            au.dts = packetInfo.dts;
                            streamAddr.setValue32(24, 0);
                            streamAddr.setValue16(28, (short)0);
                            break;
                        }
                        this.dequeueStreamPackets(dataStream, 1);
                    }
                    au.write(auAddr);
                }
                if ((result = this.getFirstStreamPacket(dataStream, packetInfo)) < 0) {
                    return -2141093887;
                }
                if (streamAddr.getValue32(56) == 0) {
                    streamAddr.setValue32(56, 8);
                }
                int sourceOffset = streamAddr.getValue16(28) + 2;
                int length = packetInfo.packetDataLength - sourceOffset;
                byte[] header = new byte[8];
                int headerOffset = startHeaderOffset = 8 - streamAddr.getValue32(56);
                TPointer sourceAddr = new TPointer(data.getMemory(), packetInfo.packetDataAddr);
                while (true) {
                    if (length >= streamAddr.getValue32(56)) {
                        length = streamAddr.getValue32(56);
                        sourceAddr.getArray8(sourceOffset, header, headerOffset, length);
                        streamAddr.setValue16(28, (short)(streamAddr.getValue16(28) + streamAddr.getValue16(56)));
                        streamAddr.setValue32(44, streamAddr.getValue32(44) + length);
                        streamAddr.setValue32(56, 0);
                        break;
                    }
                    sourceAddr.getArray8(sourceOffset, header, headerOffset, length);
                    headerOffset += length;
                    streamAddr.setValue32(56, streamAddr.getValue32(56) - length);
                    result = this.getStreamPacket(dataStream, 1, packetInfo);
                    if (result < 0) {
                        streamAddr.setValue32(52, 1);
                        break;
                    }
                    streamAddr.setValue32(44, streamAddr.getValue32(44) + length);
                    length = packetInfo.packetDataLength - 2;
                    this.dequeueStreamPackets(dataStream, 1);
                }
                int n = 8 - streamAddr.getValue32(56);
                if (startHeaderOffset < 4) {
                    TPointer destinationAddr = new TPointer(streamAddr, 60 + startHeaderOffset);
                    length = n < 5 ? n - startHeaderOffset : 4 - startHeaderOffset;
                    destinationAddr.setArray(0, header, startHeaderOffset, length);
                }
                if (n >= 5 && headerAddr.isNotNull()) {
                    int offset = Math.max(startHeaderOffset, 4);
                    length = n - offset;
                    headerAddr.setArray(offset, header, offset, length);
                }
                if (streamAddr.getValue32(56) == 0) {
                    streamAddr.setValue32(36, Utilities.endianSwap32(streamAddr.getValue32(60)) - 4);
                    if (headerAddr.isNotNull()) {
                        headerAddr.memcpy(0, streamAddr.getAddress() + 60, 4);
                        headerAddr.setArray(4, header, 4, 4);
                    }
                }
            }
            if ((result = this.copyStreamData(data, streamAddr, auAddr, 3)) != 0 || (streamAddr.getValue32(48) & 4) == 0) break;
            streamAddr.setValue32(48, streamAddr.getValue32(48) & 0xFFFFFFFB);
        }
        return result;
    }

    @HLEFunction(nid=-1000564276, version=150)
    public int sceMpegQueryUserdataEsSize(@CheckArgument(value="checkMpeg") TPointer32 mpeg, TPointer32 esSizeAddr, TPointer32 outSizeAddr) {
        esSizeAddr.setValue(655360);
        outSizeAddr.setValue(655360);
        return 0;
    }

    @HLEFunction(nid=89698421, version=150)
    public int sceMpegAvcCopyYCbCr(@CheckArgument(value="checkMpeg") TPointer32 mpeg, TPointer destinationAddr, TPointer sourceAddr) {
        TPointer data = mpeg.getPointer();
        int mode = destinationAddr.getValue32(16);
        if (mode == 2) {
            return -2141126146;
        }
        return this.copyYCbCr(data, destinationAddr, sourceAddr, -1);
    }

    @HLEUnimplemented
    @HLEFunction(nid=301554929, version=150)
    public int sceMpegGetAvcNalAu(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=32, usage=BufferInfo.Usage.in) TPointer mp4AvcNalStructAddr, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=24, usage=BufferInfo.Usage.out) TPointer auAddr) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1843409713, version=150)
    public int sceMpegGetAvcEsAu() {
        return 0;
    }

    @HLEFunction(nid=1865499664, version=150)
    public int sceMpegAvcDecodeGetDecodeSEI(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 decodeSEIAddr) {
        TPointer data = mpeg.getPointer();
        TPointer decodeSEI = data.getPointer(1776);
        decodeSEIAddr.setPointer(decodeSEI);
        TPointer videocodecBuffer = data.getPointer(1728);
        videocodecBuffer.setPointer(80, decodeSEI);
        return Modules.sceVideocodecModule.sceVideocodecGetSEI(videocodecBuffer, 0);
    }

    @HLEFunction(nid=-1425107626, version=150)
    public int sceMpegAvcDecodeDetailIndex(@CheckArgument(value="checkMpeg") TPointer32 mpeg, int imageIndex, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=52, usage=BufferInfo.Usage.out) TPointer detailPointer) {
        TPointer data = mpeg.getPointer();
        return this.getDecodeDetail(data, imageIndex, detailPointer);
    }

    @HLEFunction(nid=-818591838, version=150)
    public int sceMpegAvcDecodeDetail2(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 detailAddr) {
        TPointer data = mpeg.getPointer();
        int mode = data.getValue32(1708);
        if (mode >= 4 && mode <= 6) {
            detailAddr.setPointer(new TPointer(data.getPointer(1748), 44));
        } else {
            TPointer videocodecBuffer = data.getPointer(1728);
            detailAddr.setPointer(videocodecBuffer);
        }
        return 0;
    }

    @HLEFunction(nid=-169350607, version=150)
    public int sceMpegAvcConvertToYuv420(@CheckArgument(value="checkMpeg") TPointer32 mpeg, TPointer yuv420Buffer, TPointer sourceAddr, int unknown) {
        TPointer data = mpeg.getPointer();
        int mode = 3;
        this.sceMpegAvcConvertToYuv420Buffer.setValue32(12, unknown);
        this.sceMpegAvcConvertToYuv420Buffer.setValue32(16, 3);
        this.sceMpegAvcConvertToYuv420Buffer.setPointer(20, yuv420Buffer);
        return this.copyYCbCr(data, this.sceMpegAvcConvertToYuv420Buffer, sourceAddr, -1);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-775009968, version=150)
    public int sceMpegAvcCscMode(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(usage=BufferInfo.Usage.in) TPointer32 modeAddr) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-608827816, version=150)
    public int sceMpegFlushAu() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-380094218, version=150)
    public int sceMpegAvcCscInfo() {
        return 0;
    }

    @HLEFunction(nid=298497113, version=150)
    public int sceMpeg_11CAB459(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 unknown1, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 unknown2) {
        unknown1.setValue(102656);
        unknown2.setValue(172800);
        return 0;
    }

    @HLEFunction(nid=-1300819544, version=150)
    public int sceMpeg_B27711A8(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=68, usage=BufferInfo.Usage.in) TPointer streamAddr, int packetIndex, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=2056, usage=BufferInfo.Usage.out) TPointer resultBuffer) {
        TPointer dataAddr;
        TPointer data = mpeg.getPointer();
        DataStream dataStream = this.getDataStream(data, streamAddr);
        if (dataStream == null) {
            return -2141126146;
        }
        if (streamAddr.getValue32(8) == -1) {
            return -2141126146;
        }
        if (packetIndex == 0 && streamAddr.getValue32(16) != Short.MAX_VALUE) {
            resultBuffer.setValue32(0, streamAddr.getValue32(16));
            resultBuffer.setValue32(4, streamAddr.getValue32(44));
            dataAddr = streamAddr.getPointer(12);
            resultBuffer.memcpy(8, dataAddr, 2048);
        } else {
            SceMpegStreamPacketInfo packetInfo = new SceMpegStreamPacketInfo();
            int result = this.getStreamPacket(dataStream, packetIndex, packetInfo);
            if (result != 0) {
                return -2141093884;
            }
            if (packetInfo.packetDataLength > 2048) {
                return -2141093881;
            }
            resultBuffer.setValue32(0, 0);
            resultBuffer.setValue32(4, 0);
            resultBuffer.memcpy(8, packetInfo.packetDataAddr, packetInfo.packetDataLength);
        }
        if (data.getValue32(12) == 0) {
            dataAddr = new TPointer(resultBuffer, 8);
            TPointer ptr = new TPointer(dataAddr, 15 + dataAddr.getUnsignedValue8(17) * 4);
            ptr.setUnsignedValue8(ptr.getUnsignedValue8() & 0x7F);
        }
        return 0;
    }

    @HLEFunction(nid=-723685771, version=150)
    public int sceMpeg_D4DD6E75(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=68, usage=BufferInfo.Usage.inout) TPointer streamAddr, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=24, usage=BufferInfo.Usage.out) TPointer auAddr, @BufferInfo(usage=BufferInfo.Usage.out) @CanBeNull TPointer32 unknownAddr) {
        int result;
        TPointer data = mpeg.getPointer();
        DataStream dataStream = this.getDataStream(data, streamAddr);
        if (dataStream == null) {
            return -2141126146;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMpeg_D4DD6E75 dataStream=%s", dataStream));
        }
        SceMpegStreamPacketInfo packetInfo = new SceMpegStreamPacketInfo();
        SceMpegAu au = new SceMpegAu();
        au.read(auAddr);
        while (true) {
            result = this.getFirstStreamPacket(dataStream, packetInfo);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("sceMpeg_D4DD6E75 stream packet 0x%X: %s", result, packetInfo));
            }
            if (result < 0) {
                result = -2141093887;
                break;
            }
            if (streamAddr.getValue32(56) != 0 || streamAddr.getValue32(44) == 0) {
                if (streamAddr.getValue32(44) == 0) {
                    au.esSize = 0;
                    while (true) {
                        if ((result = this.getFirstStreamPacket(dataStream, packetInfo)) < 0) {
                            au.write(auAddr);
                            return -2141093887;
                        }
                        if (packetInfo.dts != -1L || packetInfo.pts != -1L) break;
                        this.dequeueStreamPackets(dataStream, 1);
                    }
                    au.write(auAddr);
                }
                if ((result = this.getFirstStreamPacket(dataStream, packetInfo)) < 0) {
                    return -2141093887;
                }
                if ((streamAddr.getValue32(24) & 1) != 0) {
                    au.pts = packetInfo.pts;
                    au.dts = packetInfo.dts;
                    au.write(auAddr);
                    streamAddr.setValue32(24, 0);
                    streamAddr.setValue16(28, (short)0);
                }
                if (streamAddr.getValue32(56) == 0) {
                    streamAddr.setValue32(56, 4);
                }
                int sourceOffset = streamAddr.getValue16(28) + 2;
                int length = packetInfo.packetDataLength - sourceOffset;
                TPointer destinationAddr = new TPointer(streamAddr, 60 + (4 - streamAddr.getValue32(56)));
                int packetIndex = 1;
                while (true) {
                    if (length >= streamAddr.getValue32(56)) {
                        length = streamAddr.getValue32(56);
                        destinationAddr.memcpy(packetInfo.packetDataAddr + sourceOffset, length);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("sceMpeg_D4DD6E75 memcpy(%s, 0x%08X, 0x%X)", destinationAddr, packetInfo.packetDataAddr + sourceOffset, length));
                        }
                        streamAddr.setValue32(56, 0);
                        int frameLength = Utilities.endianSwap32(streamAddr.getUnalignedValue32(60));
                        streamAddr.setValue32(36, frameLength - streamAddr.getValue32(44) + 4);
                        break;
                    }
                    destinationAddr.memcpy(packetInfo.packetDataAddr + sourceOffset, length);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("sceMpeg_D4DD6E75 memcpy(%s, 0x%08X, 0x%X)", destinationAddr, packetInfo.packetDataAddr + sourceOffset, length));
                    }
                    destinationAddr.add(length);
                    streamAddr.decrValue32(56, length);
                    result = this.getStreamPacket(dataStream, packetIndex, packetInfo);
                    if (result < 0) {
                        streamAddr.setValue32(36, 4);
                        streamAddr.setValue32(52, 1);
                        break;
                    }
                    sourceOffset = 2;
                    length = packetInfo.packetDataLength - 2;
                    ++packetIndex;
                }
            }
            if ((result = this.copyStreamData(data, streamAddr, auAddr, 5)) == 0 && unknownAddr.isNotNull()) {
                unknownAddr.setValue(this.sceMpeg_C345DED2(new TPointer(auAddr.getMemory(), au.esBuffer), 4));
            }
            if (result != 0 || (streamAddr.getValue32(48) & 4) == 0) break;
            streamAddr.setValue32(48, streamAddr.getValue32(48) & 0xFFFFFFFB);
        }
        return result;
    }

    @HLEFunction(nid=-1018831150, version=150)
    public int sceMpeg_C345DED2(TPointer esBuffer, int mode) {
        int value = 0;
        switch (mode) {
            case 1: {
                value = esBuffer.getAddress() + 14;
                break;
            }
            case 2: {
                if ((esBuffer.getUnsignedValue8(13) & 2) == 0) break;
                value = esBuffer.getAddress() + 18;
                break;
            }
            case 3: {
                if ((esBuffer.getUnsignedValue8(13) & 1) == 0) break;
                value = this.sceMpeg_C345DED2(esBuffer, 8000);
                break;
            }
            case 4: {
                value = this.sceMpeg_C345DED2(esBuffer, 8000);
                if ((esBuffer.getUnsignedValue8(13) & 1) == 0) break;
                value += 64;
                break;
            }
            case 5: {
                if ((esBuffer.getUnsignedValue8(13) & 2) == 0) break;
                TPointer ptr = new TPointer(esBuffer.getMemory(), this.sceMpeg_C345DED2(esBuffer, 8000));
                value = esBuffer.getAddress() - Utilities.endianSwap16(ptr.getUnalignedValue16(-2) & 0xFFFF);
                break;
            }
            case 8000: {
                value = this.sceMpeg_C345DED2(esBuffer, 2);
                if (value == 0) {
                    value = this.sceMpeg_C345DED2(esBuffer, 1);
                }
                value += 6;
            }
        }
        return value;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1735483886, version=150)
    public int sceMpeg_988E9E12() {
        return 0;
    }

    @HLEFunction(nid=1989929910, version=250)
    public int sceMpegRingbufferQueryPackNum(int memorySize) {
        return sceMpeg.getPacketsFromSize(memorySize);
    }

    @HLEFunction(nid=1673089898, version=600)
    public int sceMpegAvcResourceGetAvcDecTopAddr() {
        if ((this.globalFlags & 4) == 0) {
            return 0;
        }
        int addr = this.sceMpegAvcResource.getValue32(4) & 0xFFC00000;
        return addr;
    }

    @HLEFunction(nid=-2124373250, version=600)
    public int sceMpegAvcResourceFinish() {
        if ((this.globalFlags & 4) == 0) {
            return -2141093879;
        }
        int fplUid = this.sceMpegAvcResource.getValue32(0);
        Modules.ThreadManForUserModule.sceKernelFreeFpl(fplUid, this.sceMpegAvcResource.getPointer(4));
        int result = Modules.ThreadManForUserModule.sceKernelDeleteFpl(fplUid);
        this.sceMpegAvcResource.setValue32(0, 0);
        this.sceMpegAvcResource.setValue32(4, 0);
        this.globalFlags &= 0xFFFFFFFB;
        return result;
    }

    @HLEFunction(nid=-1356416255, version=600)
    public int sceMpegAvcResourceGetAvcEsBuf() {
        if ((this.globalFlags & 4) == 0) {
            return 0;
        }
        return this.sceMpegAvcResource.getValue32(4);
    }

    @HLEFunction(nid=-54676051, version=600)
    public int sceMpegAvcResourceInit(int unknown) {
        if (unknown != 1) {
            return -2141126146;
        }
        if ((this.globalFlags & 4) != 0) {
            return -2141093883;
        }
        int result = Modules.ThreadManForUserModule.sceKernelCreateFpl(new PspString("SceMpegAvcResource"), 2, 0, 131072, 1, TPointer.NULL);
        if (result < 0) {
            return result;
        }
        int fplUid = result;
        TPointer32 dataAddr = new TPointer32(this.sceMpegAvcResource.getMemory(), this.sceMpegAvcResource.getAddress() + 4);
        if ((result = Modules.ThreadManForUserModule.sceKernelAllocateFpl(fplUid, dataAddr, TPointer32.NULL)) < 0) {
            Modules.ThreadManForUserModule.sceKernelDeleteFpl(fplUid);
            return result;
        }
        this.sceMpegAvcResource.setValue32(0, fplUid);
        this.globalFlags |= 4;
        return 0;
    }

    @HLEFunction(nid=-1024447267, version=150)
    public int sceMpeg_C2F02CDD(@CheckArgument(value="checkMpeg") TPointer32 mpeg, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4, usage=BufferInfo.Usage.in) TPointer videoStreamAddr, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=4, usage=BufferInfo.Usage.in) TPointer audioStreamAddr, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 videoAudioDiffAddr) {
        TPointer data = mpeg.getPointer();
        DataStream videoDataStream = this.getDataStream(data, videoStreamAddr);
        if (videoDataStream == null) {
            return -2141126146;
        }
        DataStream audioDataStream = this.getDataStream(data, audioStreamAddr);
        if (audioDataStream == null) {
            return -2141126146;
        }
        if (videoDataStream.isEmptyQueue() || audioDataStream.isEmptyQueue()) {
            return -2141093887;
        }
        SceMpegRingbuffer sceMpegRingbuffer = new SceMpegRingbuffer();
        sceMpegRingbuffer.read(data.getPointer(16));
        int videoSize = videoDataStream.getStreamPacketsQueueHead().getValue32(36) - sceMpegRingbuffer.data;
        int videoPacketIndex = videoSize / sceMpegRingbuffer.packetSize;
        int audioSize = audioDataStream.getStreamPacketsQueueHead().getValue32(36) - sceMpegRingbuffer.data;
        int audioPacketIndex = audioSize / sceMpegRingbuffer.packetSize;
        int videoAudioDiff = videoPacketIndex == audioPacketIndex ? 0 : (sceMpegRingbuffer.packetsWritten < sceMpegRingbuffer.packetsRead ? videoPacketIndex - audioPacketIndex : (videoPacketIndex < sceMpegRingbuffer.packetsRead && audioPacketIndex < sceMpegRingbuffer.packetsRead ? videoPacketIndex - audioPacketIndex : (videoPacketIndex < sceMpegRingbuffer.packetsWritten || audioPacketIndex < sceMpegRingbuffer.packetsWritten ? (videoPacketIndex < audioPacketIndex ? sceMpegRingbuffer.packets - (audioPacketIndex - videoPacketIndex) : videoPacketIndex - audioPacketIndex - sceMpegRingbuffer.packets) : videoPacketIndex - audioPacketIndex)));
        videoAudioDiffAddr.setValue(videoAudioDiff);
        return 0;
    }

    static {
        sceMpeg.streamTypeDescriptors[0] = new StreamTypeDescriptor(-536870912, -16777216, -536870912);
        sceMpeg.streamTypeDescriptors[1] = new StreamTypeDescriptor(-1124073472, -65536, -1048576);
        sceMpeg.streamTypeDescriptors[2] = new StreamTypeDescriptor(-1123024896, -65536, -1048576);
        sceMpeg.streamTypeDescriptors[3] = new StreamTypeDescriptor(-1121976320, -65536, -1048576);
        sceMpeg.streamTypeDescriptors[4] = new StreamTypeDescriptor(-1073741824, -16777216, -1073741824);
        sceMpeg.streamTypeDescriptors[5] = new StreamTypeDescriptor(-1115684864, -65536, -2097152);
        sceMpeg.streamTypeDescriptors[6] = new StreamTypeDescriptor(-1090396160, -256, -8192);
        sceMpeg.streamTypeDescriptors[7] = new StreamTypeDescriptor(-1120927744, -65536, -1048576);
        sceMpeg.streamTypeDescriptors[8] = new StreamTypeDescriptor(-1119879168, -65536, -1048576);
        sceMpeg.streamTypeDescriptors[9] = new StreamTypeDescriptor(-536870912, -16777216, -536870912);
        sceMpeg.streamTypeDescriptors[10] = new StreamTypeDescriptor(-1107312640, -1, -256);
        sceMpeg.streamTypeDescriptors[11] = new StreamTypeDescriptor(-1107320832, -1, -256);
        sceMpeg.streamTypeDescriptors[12] = new StreamTypeDescriptor(-1107320576, -1, -256);
        sceMpeg.streamTypeDescriptors[13] = new StreamTypeDescriptor(-1107324928, -1, -256);
        sceMpeg.streamTypeDescriptors[14] = new StreamTypeDescriptor(-1073741824, -16777216, -1073741824);
        sceMpeg.streamTypeDescriptors[15] = new StreamTypeDescriptor(-1115684864, -65536, -2097152);
        sceMpeg.streamTypeDescriptors[16] = new StreamTypeDescriptor(-1113587712, -65536, -524288);
        sceMpeg.streamTypeDescriptors[17] = new StreamTypeDescriptor(-1115160576, -65536, -524288);
        sceMpeg.streamTypeDescriptors[18] = new StreamTypeDescriptor(-1114636288, -65536, -524288);
        sceMpeg.streamChannelDescriptors[0] = new StreamChannelDescriptor(-1090396160, -8192, 8, 31, 0);
        sceMpeg.streamChannelDescriptors[1] = new StreamChannelDescriptor(-536870912, -536870912, 24, 31, 16);
        sceMpeg.streamChannelDescriptors[2] = new StreamChannelDescriptor(-1124073472, -1048576, 16, 15, 32);
        sceMpeg.streamChannelDescriptors[3] = new StreamChannelDescriptor(-1123024896, -1048576, 16, 15, 48);
        sceMpeg.streamChannelDescriptors[4] = new StreamChannelDescriptor(-1115684864, -2097152, 16, 31, 64);
        sceMpeg.streamChannelDescriptors[5] = new StreamChannelDescriptor(-1121976320, -1048576, 16, 15, 96);
    }

    private class AfterRingbufferPutCallback
    implements IAction {
        private TPointer ringbufferAddr;
        private int remainingPackets;
        private int gp;
        private int processedPackets;
        private int returnValue;

        public AfterRingbufferPutCallback(TPointer ringbufferAddr, int remainingPackets, int gp) {
            this.ringbufferAddr = ringbufferAddr;
            this.remainingPackets = remainingPackets;
            this.gp = gp;
        }

        @Override
        public void execute() {
            sceMpeg.this.hleMpegRingbufferPostPut(this.ringbufferAddr, this, ((sceMpeg)sceMpeg.this).getProcessor().cpu._v0, this.gp);
        }

        public int getRemainingPackets() {
            return this.remainingPackets;
        }

        public boolean hasRemainingPackets() {
            return this.remainingPackets > 0;
        }

        public void addProcessedPackets(int packets) {
            this.processedPackets += packets;
            this.remainingPackets -= packets;
        }

        public boolean hasProcessedPackets() {
            return this.processedPackets > 0;
        }

        public int getProcessedPackets() {
            return this.processedPackets;
        }

        public int getReturnValue() {
            return this.returnValue;
        }

        public void setReturnValue(int returnValue) {
            this.returnValue = returnValue;
        }
    }

    private static class RingbufferBitReader
    extends BitReader {
        private final int addrMax;
        private final int addrMin;

        public RingbufferBitReader(Memory mem, int addr, int addrMin, int addrMax, int size) {
            super(mem, addr, size);
            this.addrMin = addrMin;
            this.addrMax = addrMax;
        }

        @Override
        protected int nextAddr() {
            int addr = super.nextAddr();
            if (addr >= this.addrMax) {
                addr = this.addrMin;
            }
            return addr;
        }

        @Override
        protected int previousAddr() {
            int addr = super.previousAddr();
            if (addr < this.addrMin) {
                addr = this.addrMax - 1;
            }
            return addr;
        }
    }

    private class AfterVideocodecDecodeYCbCrAction
    implements IAction {
        private SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
        private TPointer data;
        private TPointer auAddr;
        private TPointer32 bufferAddr;
        private TPointer32 gotFrameAddr;

        public AfterVideocodecDecodeYCbCrAction(TPointer data, TPointer auAddr, TPointer32 bufferAddr, TPointer32 gotFrameAddr) {
            this.data = data;
            this.auAddr = auAddr;
            this.bufferAddr = bufferAddr;
            this.gotFrameAddr = gotFrameAddr;
        }

        @Override
        public void execute() {
            sceMpeg.this.afterVideocodecDecodeYCbCr(this.thread, this.data, this.auAddr, this.bufferAddr, this.gotFrameAddr);
        }
    }

    private class AfterVideocodecDecodeAction
    implements IAction {
        private SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
        private TPointer data;
        private TPointer auAddr;
        private int frameWidth;
        private TPointer32 bufferAddr;
        private TPointer32 gotFrameAddr;

        public AfterVideocodecDecodeAction(TPointer data, TPointer auAddr, int frameWidth, TPointer32 bufferAddr, TPointer32 gotFrameAddr) {
            this.data = data;
            this.auAddr = auAddr;
            this.frameWidth = frameWidth;
            this.bufferAddr = bufferAddr;
            this.gotFrameAddr = gotFrameAddr;
        }

        @Override
        public void execute() {
            sceMpeg.this.afterVideocodecDecode(this.thread, this.data, this.auAddr, this.frameWidth, this.bufferAddr, this.gotFrameAddr);
        }
    }

    private static class SceMpegStreamPacketInfo
    extends pspAbstractMemoryMappedStructure {
        public int startCode;
        public int packetLength;
        public int pesScramblingControl;
        public long pts;
        public long dts;
        public int packetDataAddr;
        public int packetDataLength;
        public int packetHeaderAddr;
        public int unused;

        private SceMpegStreamPacketInfo() {
        }

        @Override
        protected void read() {
            this.startCode = this.read32();
            this.packetLength = this.read32();
            this.pesScramblingControl = this.read32();
            this.pts = this.longSwap64(this.read64());
            this.dts = this.longSwap64(this.read64());
            this.packetDataAddr = this.read32();
            this.packetDataLength = this.read32();
            this.packetHeaderAddr = this.read32();
            this.unused = this.read32();
        }

        @Override
        protected void write() {
            this.write32(this.startCode);
            this.write32(this.packetLength);
            this.write32(this.pesScramblingControl);
            this.write64(this.longSwap64(this.pts));
            this.write64(this.longSwap64(this.dts));
            this.write32(this.packetDataAddr);
            this.write32(this.packetDataLength);
            this.write32(this.packetHeaderAddr);
            this.write32(this.unused);
        }

        @Override
        public int sizeof() {
            return 44;
        }

        @Override
        public String toString() {
            return String.format("startCode=0x%08X, packetLength=0x%X, pesScramblingCode=0x%X, pts=%d, dts=%d, packetDataAddr=0x%08X, packetDataLength=0x%X, packetHeaderAddr=0x%08X", this.startCode, this.packetLength, this.pesScramblingControl, this.pts, this.dts, this.packetDataAddr, this.packetDataLength, this.packetHeaderAddr);
        }
    }

    private static class DataStream {
        private static final int INVALID_PTR_ADDR = -1;
        private TPointer dataStreamAddr;

        public DataStream(TPointer dataStreamAddr) {
            this.dataStreamAddr = dataStreamAddr;
        }

        public static DataStream getFromData(TPointer data) {
            return new DataStream(data.getPointer(24));
        }

        public TPointer getDataStreamAddr() {
            return this.dataStreamAddr;
        }

        public TPointer getStreamPacketsQueueHead() {
            return this.dataStreamAddr.getPointer(4);
        }

        public void setStreamPacketsQueueHead(TPointer head, int count) {
            this.dataStreamAddr.setPointer(4, head);
            this.setStreamPacketsCount(count);
        }

        public int getStreamPacketsCount() {
            return this.dataStreamAddr.getValue32(12);
        }

        public void setStreamPacketsCount(int count) {
            this.dataStreamAddr.setValue32(12, count);
        }

        public void registerStream(TPointer streamAddr) {
            this.clear();
            this.dataStreamAddr.setPointer(8, streamAddr);
        }

        public void init() {
            this.clear();
            this.dataStreamAddr.setValue32(8, -1);
        }

        public void unregisterStream() {
            this.init();
        }

        public TPointer getRegisteredStream() {
            return this.dataStreamAddr.getPointer(8);
        }

        public boolean isRegisteredStream() {
            return this.dataStreamAddr.getValue32(8) != -1;
        }

        public boolean isEmptyQueue() {
            return this.dataStreamAddr.getValue32(4) == -1;
        }

        public void clear() {
            this.dataStreamAddr.setValue32(0, -1);
            this.dataStreamAddr.setValue32(4, -1);
            this.setStreamPacketsCount(0);
        }

        public void enqueDataPacket(TPointer dataPacketAddr) {
            dataPacketAddr.setValue32(0, -1);
            dataPacketAddr.setValue32(4, this.dataStreamAddr.getValue32(0));
            if (this.dataStreamAddr.getValue32(0) != -1) {
                this.dataStreamAddr.getPointer(0).setPointer(0, dataPacketAddr);
            }
            this.dataStreamAddr.setPointer(0, dataPacketAddr);
            if (this.dataStreamAddr.getValue32(4) == -1) {
                this.dataStreamAddr.setValue32(4, this.dataStreamAddr.getValue32(0));
            }
            this.setStreamPacketsCount(this.getStreamPacketsCount() + 1);
        }

        public void nextDataStream() {
            this.dataStreamAddr.add(16);
        }

        public String toString() {
            return this.dataStreamAddr.toString();
        }
    }

    private static class StreamChannelDescriptor {
        private final int code;
        private final int mask;
        private final int channelShift;
        private final int channelMask;
        private final int streamBase;
        private final int streamDataBase;

        public StreamChannelDescriptor(int code, int mask, int channelShift, int channelMask, int streamIndex) {
            this.code = code;
            this.mask = mask;
            this.channelShift = channelShift;
            this.channelMask = channelMask;
            this.streamBase = streamIndex * 68;
            this.streamDataBase = streamIndex * 16;
        }

        public boolean isMatching(int streamChannelCode) {
            return (streamChannelCode & this.mask) == this.code;
        }

        private TPointer getAddr(TPointer ptr, int streamChannelCode, int size, int base) {
            int channel = streamChannelCode >> this.channelShift & this.channelMask;
            ptr.add(channel * size + base);
            return ptr;
        }

        public TPointer getStreamAddr(TPointer data, int streamChannelCode) {
            return this.getAddr(data.getPointer(28), streamChannelCode, 68, this.streamBase);
        }

        public DataStream getDataStream(TPointer data, int streamChannelCode) {
            return new DataStream(this.getAddr(data.getPointer(24), streamChannelCode, 16, this.streamDataBase));
        }
    }

    private static class StreamTypeDescriptor {
        private final int code;
        private final int mask;
        private final int codeMask;
        private final int shift;

        public StreamTypeDescriptor(int code, int mask, int codeMask) {
            this.code = code;
            this.mask = mask;
            this.codeMask = codeMask;
            switch (mask) {
                case -16777216: {
                    this.shift = 24;
                    break;
                }
                case -65536: {
                    this.shift = 16;
                    break;
                }
                case -256: {
                    this.shift = 8;
                    break;
                }
                case -1: {
                    this.shift = 0;
                    break;
                }
                default: {
                    this.shift = 0;
                }
            }
        }

        public int getMask() {
            return this.mask;
        }

        public int getChannelCode(int channelNumber) {
            return this.code | channelNumber << this.shift;
        }

        public boolean isMatching(int channelCode) {
            return (channelCode & this.codeMask) == this.code;
        }
    }
}

