/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer8;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.VFS.compress.CompressPrxVirtualFileSystem;
import jpcsp.HLE.VFS.fat.Fat12VirtualFile;
import jpcsp.HLE.VFS.fat.FatVirtualFile;
import jpcsp.HLE.VFS.fat.FatVirtualFileSystem;
import jpcsp.HLE.VFS.local.LocalVirtualFile;
import jpcsp.HLE.VFS.local.LocalVirtualFileSystem;
import jpcsp.HLE.VFS.nand.NandVirtualFile;
import jpcsp.HLE.VFS.patch.PatchFileVirtualFileSystem;
import jpcsp.HLE.VFS.synchronize.ISynchronize;
import jpcsp.HLE.VFS.synchronize.SynchronizeMemoryToVirtualFile;
import jpcsp.HLE.VFS.synchronize.SynchronizeVirtualFileSystems;
import jpcsp.HLE.kernel.types.SceNandSpare;
import jpcsp.HLE.modules.sceIdStorage;
import jpcsp.filesystems.SeekableRandomFile;
import jpcsp.hardware.Nand;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IntArrayMemory;
import jpcsp.memory.MemoryReader;
import jpcsp.settings.Settings;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceNand
extends HLEModule {
    public static Logger log = Modules.getLogger("sceNand");
    private static final int STATE_VERSION = 0;
    private static final boolean emulateNand = true;
    private static final boolean storeNandInMemory = true;
    public static final int iplTablePpnStart = 128;
    public static final int iplTablePpnEnd = 383;
    public static final int iplPpnStart = 512;
    public static final int iplPpnEnd = 799;
    public static final int idStoragePpnStart = 1536;
    public static final int idStoragePpnEnd = 2047;
    public static final int iplId = 1841711672;
    private static final int idStorageId = -65279;
    private byte[] dumpBlocks;
    private byte[] dumpSpares;
    private int[] dumpResults;
    private int[] ppnToLbn;
    private boolean writeProtected;
    private int scramble;
    private FatVirtualFile vFileFlash0;
    private FatVirtualFile vFileFlash1;
    private FatVirtualFile vFileFlash2;
    private FatVirtualFile vFileFlash3;
    public static final int flash0LbnStart = 2;
    public static int flash1LbnStart;
    public static int flash2LbnStart;
    public static int flash3LbnStart;
    public static int flash4LbnStart;
    public static int flash5LbnStart;
    private IVirtualFile vFileIpl;
    private IntArrayMemory nandMemory;
    private TPointer nandMemoryPointer;
    private IntArrayMemory nandSpareMemory;
    private TPointer nandSpareMemoryPointer;
    private boolean initNandInProgress;
    private final Object writeLock = new Object();
    private ISynchronize syncFlash0;
    private ISynchronize syncFlash1;
    private ISynchronize syncFlash2;
    private ISynchronize syncFlash3;
    private ISynchronize syncIpl;

    @Override
    public void start() {
        int ppn;
        this.reset();
        if (log.isDebugEnabled()) {
            for (ppn = 0; ppn < this.ppnToLbn.length; ++ppn) {
                if (this.ppnToLbn[ppn] != 65535) continue;
                int startFreePpn = ppn;
                int endFreePpn = ppn;
                while (ppn < this.ppnToLbn.length) {
                    if (this.ppnToLbn[ppn] != 65535) {
                        endFreePpn = --ppn;
                        break;
                    }
                    ++ppn;
                }
                log.debug((Object)String.format("Free blocks ppn=0x%X-0x%X", startFreePpn, endFreePpn));
            }
        }
        if (log.isTraceEnabled()) {
            for (ppn = 0; ppn < this.ppnToLbn.length; ++ppn) {
                log.trace((Object)String.format("ppn=0x%04X -> lbn=0x%04X", ppn, this.ppnToLbn[ppn]));
            }
        }
        super.start();
    }

    private void initNandInMemory() {
        if (this.nandMemory != null || this.initNandInProgress) {
            return;
        }
        this.initNandInProgress = true;
        IntArrayMemory nandMemory = new IntArrayMemory(new int[Nand.getTotalSize() >> 2]);
        IntArrayMemory nandSpareMemory = new IntArrayMemory(new int[Nand.getTotalPages() << 2]);
        for (int ppn = 0; ppn < this.ppnToLbn.length; ppn += 32) {
            this.hleNandReadPages(ppn, nandMemory.getPointer(ppn * 512), nandSpareMemory.getPointer(ppn * 16), 32, true, true, true);
        }
        if (this.vFileFlash0 != null) {
            this.vFileFlash0.ioClose();
            this.vFileFlash0 = null;
        }
        if (this.vFileFlash1 != null) {
            this.vFileFlash1.ioClose();
            this.vFileFlash1 = null;
        }
        if (this.vFileFlash2 != null) {
            this.vFileFlash2.ioClose();
            this.vFileFlash2 = null;
        }
        if (this.vFileFlash3 != null) {
            this.vFileFlash3.ioClose();
            this.vFileFlash3 = null;
        }
        this.nandMemory = nandMemory;
        this.nandMemoryPointer = nandMemory.getPointer();
        this.nandSpareMemory = nandSpareMemory;
        this.nandSpareMemoryPointer = nandSpareMemory.getPointer();
        FatVirtualFileSystem inputFlash0 = new FatVirtualFileSystem("flash0", new NandVirtualFile(3, flash1LbnStart));
        LocalVirtualFileSystem outputFlash0 = new LocalVirtualFileSystem(Settings.getInstance().getDirectoryMapping("flash0"), false);
        this.syncFlash0 = new SynchronizeVirtualFileSystems("flash0", inputFlash0, outputFlash0, this.writeLock);
        FatVirtualFileSystem inputFlash1 = new FatVirtualFileSystem("flash1", new NandVirtualFile(flash1LbnStart + 1, flash2LbnStart));
        LocalVirtualFileSystem outputFlash1 = new LocalVirtualFileSystem(Settings.getInstance().getDirectoryMapping("flash1"), false);
        this.syncFlash1 = new SynchronizeVirtualFileSystems("flash1", inputFlash1, outputFlash1, this.writeLock);
        FatVirtualFileSystem inputFlash2 = new FatVirtualFileSystem("flash2", new NandVirtualFile(flash2LbnStart + 1, flash3LbnStart));
        LocalVirtualFileSystem outputFlash2 = new LocalVirtualFileSystem(Settings.getInstance().getDirectoryMapping("flash2"), false);
        this.syncFlash2 = new SynchronizeVirtualFileSystems("flash2", inputFlash2, outputFlash2, this.writeLock);
        if (!sceNand.isSmallNand()) {
            FatVirtualFileSystem inputFlash3 = new FatVirtualFileSystem("flash3", new NandVirtualFile(flash3LbnStart + 1, flash4LbnStart));
            LocalVirtualFileSystem outputFlash3 = new LocalVirtualFileSystem(Settings.getInstance().getDirectoryMapping("flash3"), false);
            this.syncFlash3 = new SynchronizeVirtualFileSystems("flash3", inputFlash3, outputFlash3, this.writeLock);
        }
        try {
            TPointer inputIpl = nandMemory.getPointer(65536);
            int inputIplSize = 344064;
            LocalVirtualFile outputIpl = new LocalVirtualFile(new SeekableRandomFile("nand.ipl.bin", "rw"));
            this.syncIpl = new SynchronizeMemoryToVirtualFile("ipl", inputIpl, inputIplSize, outputIpl, this.writeLock);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"initNandInMemory", (Throwable)e);
        }
        this.initNandInProgress = false;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        boolean nandMemoryPresent;
        boolean vFileFlash3Present;
        boolean vFileFlash2Present;
        boolean vFileFlash1Present;
        int i;
        stream.readVersion(0);
        this.writeProtected = stream.readBoolean();
        this.scramble = stream.readInt();
        int stateNumberPages = stream.readInt();
        int numberPages = Math.min(stateNumberPages, this.ppnToLbn.length);
        for (i = 0; i < numberPages; ++i) {
            this.ppnToLbn[i] = stream.readUnsignedShort();
        }
        if (stateNumberPages > numberPages) {
            stream.skipBytes(2 * (stateNumberPages - numberPages));
        } else {
            for (i = numberPages; i < this.ppnToLbn.length; ++i) {
                this.ppnToLbn[i] = 0;
            }
        }
        boolean vFileFlash0Present = stream.readBoolean();
        if (vFileFlash0Present) {
            this.openFileFlash0();
            this.vFileFlash0.read(stream);
        }
        if (vFileFlash1Present = stream.readBoolean()) {
            this.openFileFlash1();
            this.vFileFlash1.read(stream);
        }
        if (vFileFlash2Present = stream.readBoolean()) {
            this.openFileFlash2();
            this.vFileFlash2.read(stream);
        }
        if (vFileFlash3Present = stream.readBoolean()) {
            this.openFileFlash3();
            this.vFileFlash3.read(stream);
        }
        if (nandMemoryPresent = stream.readBoolean()) {
            if (this.nandMemory == null) {
                this.nandMemory = new IntArrayMemory(new int[Nand.getTotalSize() >> 2]);
                this.nandMemoryPointer = this.nandMemory.getPointer();
            }
            this.nandMemory.read(stream);
            if (this.nandSpareMemory == null) {
                this.nandSpareMemory = new IntArrayMemory(new int[Nand.getTotalPages() << 2]);
                this.nandSpareMemoryPointer = this.nandSpareMemory.getPointer();
            }
            this.nandSpareMemory.read(stream);
            if (this.syncFlash0 == null) {
                FatVirtualFileSystem inputFlash0 = new FatVirtualFileSystem("flash0", new NandVirtualFile(3, flash1LbnStart));
                LocalVirtualFileSystem outputFlash0 = new LocalVirtualFileSystem(Settings.getInstance().getDirectoryMapping("flash0"), false);
                this.syncFlash0 = new SynchronizeVirtualFileSystems("flash0", inputFlash0, outputFlash0, this.writeLock);
            }
            this.syncFlash0.read(stream);
            if (this.syncFlash1 == null) {
                FatVirtualFileSystem inputFlash1 = new FatVirtualFileSystem("flash1", new NandVirtualFile(flash1LbnStart + 1, flash2LbnStart));
                LocalVirtualFileSystem outputFlash1 = new LocalVirtualFileSystem(Settings.getInstance().getDirectoryMapping("flash1"), false);
                this.syncFlash1 = new SynchronizeVirtualFileSystems("flash1", inputFlash1, outputFlash1, this.writeLock);
            }
            this.syncFlash1.read(stream);
            if (this.syncFlash2 == null) {
                FatVirtualFileSystem inputFlash2 = new FatVirtualFileSystem("flash2", new NandVirtualFile(flash2LbnStart + 1, flash3LbnStart));
                LocalVirtualFileSystem outputFlash2 = new LocalVirtualFileSystem(Settings.getInstance().getDirectoryMapping("flash2"), false);
                this.syncFlash2 = new SynchronizeVirtualFileSystems("flash2", inputFlash2, outputFlash2, this.writeLock);
            }
            this.syncFlash2.read(stream);
            boolean flash3Present = stream.readBoolean();
            if (flash3Present) {
                if (this.syncFlash3 == null) {
                    FatVirtualFileSystem inputFlash3 = new FatVirtualFileSystem("flash3", new NandVirtualFile(flash3LbnStart + 1, flash4LbnStart));
                    LocalVirtualFileSystem outputFlash3 = new LocalVirtualFileSystem(Settings.getInstance().getDirectoryMapping("flash3"), false);
                    this.syncFlash3 = new SynchronizeVirtualFileSystems("flash3", inputFlash3, outputFlash3, this.writeLock);
                }
                this.syncFlash3.read(stream);
            }
            if (this.syncIpl == null) {
                try {
                    TPointer inputIpl = this.nandMemory.getPointer(65536);
                    int inputIplSize = 344064;
                    LocalVirtualFile outputIpl = new LocalVirtualFile(new SeekableRandomFile("nand.ipl.bin", "rw"));
                    this.syncIpl = new SynchronizeMemoryToVirtualFile("ipl", inputIpl, inputIplSize, outputIpl, this.writeLock);
                }
                catch (FileNotFoundException e) {
                    log.error((Object)"initNandInMemory", (Throwable)e);
                }
            }
            this.syncIpl.read(stream);
        }
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeBoolean(this.writeProtected);
        stream.writeInt(this.scramble);
        stream.writeInt(this.ppnToLbn.length);
        for (int i = 0; i < this.ppnToLbn.length; ++i) {
            stream.writeShort(this.ppnToLbn[i]);
        }
        if (this.vFileFlash0 != null) {
            stream.writeBoolean(true);
            this.vFileFlash0.write(stream);
        } else {
            stream.writeBoolean(false);
        }
        if (this.vFileFlash1 != null) {
            stream.writeBoolean(true);
            this.vFileFlash1.write(stream);
        } else {
            stream.writeBoolean(false);
        }
        if (this.vFileFlash2 != null) {
            stream.writeBoolean(true);
            this.vFileFlash2.write(stream);
        } else {
            stream.writeBoolean(false);
        }
        if (this.vFileFlash3 != null) {
            stream.writeBoolean(true);
            this.vFileFlash3.write(stream);
        } else {
            stream.writeBoolean(false);
        }
        if (this.nandMemory != null) {
            this.synchronizeAll();
            stream.writeBoolean(true);
            this.nandMemory.write(stream);
            this.nandSpareMemory.write(stream);
            this.syncFlash0.write(stream);
            this.syncFlash1.write(stream);
            this.syncFlash2.write(stream);
            if (this.syncFlash3 != null) {
                stream.writeBoolean(true);
                this.syncFlash3.write(stream);
            } else {
                stream.writeBoolean(false);
            }
            this.syncIpl.write(stream);
        } else {
            stream.writeBoolean(false);
        }
        super.write(stream);
    }

    private void synchronizeAll() {
        if (this.syncFlash0 != null) {
            this.syncFlash0.synchronize();
        }
        if (this.syncFlash1 != null) {
            this.syncFlash1.synchronize();
        }
        if (this.syncFlash2 != null) {
            this.syncFlash2.synchronize();
        }
        if (this.syncFlash3 != null) {
            this.syncFlash3.synchronize();
        }
        if (this.syncIpl != null) {
            this.syncIpl.synchronize();
        }
    }

    public void reset() {
        this.synchronizeAll();
        if (this.vFileFlash0 != null) {
            this.vFileFlash0.ioClose();
            this.vFileFlash0 = null;
        }
        if (this.vFileFlash1 != null) {
            this.vFileFlash1.ioClose();
            this.vFileFlash1 = null;
        }
        if (this.vFileFlash2 != null) {
            this.vFileFlash2.ioClose();
            this.vFileFlash2 = null;
        }
        if (this.vFileFlash3 != null) {
            this.vFileFlash3.ioClose();
            this.vFileFlash3 = null;
        }
        this.syncFlash0 = null;
        this.syncFlash1 = null;
        this.syncFlash2 = null;
        this.syncFlash3 = null;
        this.syncIpl = null;
        this.nandMemory = null;
        this.nandMemoryPointer = null;
        this.nandSpareMemory = null;
        this.nandSpareMemoryPointer = null;
        this.initNandInProgress = false;
        this.writeProtected = true;
        this.scramble = 0;
        Nand.init();
        this.ppnToLbn = new int[Nand.getTotalPages()];
        flash1LbnStart = 2 + sceNand.getTotalSectorsFlash0() / 32 + 1;
        flash2LbnStart = flash1LbnStart + sceNand.getTotalSectorsFlash1() / 32 + 1;
        flash3LbnStart = flash2LbnStart + sceNand.getTotalSectorsFlash2() / 32 + 1;
        flash4LbnStart = flash3LbnStart + sceNand.getTotalSectorsFlash3() / 32 + 1;
        flash5LbnStart = flash4LbnStart + sceNand.getTotalSectorsFlash4() / 32 + 1;
        this.dumpBlocks = sceNand.readBytes("nand.block");
        this.dumpSpares = sceNand.readBytes("nand.spare");
        this.dumpResults = sceNand.readInts("nand.result");
        int startPpnToLbn = 2048;
        int numberUsedBlocks = 480;
        int numberBlocks = sceNand.isSmallNand() ? 496 : 504;
        int numberFreePages = (numberBlocks - 480) * 32;
        Arrays.fill(this.ppnToLbn, 0, 2048, 0);
        int ppn = 2048;
        int lbn = 0;
        while (ppn < this.ppnToLbn.length) {
            Arrays.fill(this.ppnToLbn, ppn, ppn + 32, lbn);
            ppn += 32;
            if (++lbn % 480 != 0) continue;
            Arrays.fill(this.ppnToLbn, ppn, ppn + numberFreePages, 65535);
            ppn += numberFreePages;
        }
    }

    private static byte[] readBytes(String fileName) {
        byte[] bytes = null;
        try {
            File file = new File(fileName);
            FileInputStream is = new FileInputStream(file);
            bytes = new byte[(int)file.length()];
            ((InputStream)is).read(bytes);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bytes;
    }

    private static int[] readInts(String fileName) {
        byte[] bytes = sceNand.readBytes(fileName);
        if (bytes == null) {
            return null;
        }
        int[] ints = new int[bytes.length / 4];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().get(ints);
        return ints;
    }

    public static void scramblePage(int scramble, int ppn, int[] source, int[] destination) {
        int scrmb = Integer.rotateRight(scramble, 21);
        int key = Integer.rotateRight(ppn, 17) ^ scrmb * 7;
        int scrambleOffset = ((ppn ^ scrmb) & 0x1F) << 4 >> 2;
        int pageSize4 = 128;
        int i = 0;
        while (i < 128) {
            int value0 = source[i++];
            int value1 = source[i++];
            int value2 = source[i++];
            int value3 = source[i++];
            if (scrambleOffset >= 128) {
                scrambleOffset -= 128;
            }
            destination[scrambleOffset++] = value0 + key;
            destination[scrambleOffset++] = value1 + (key += value0);
            destination[scrambleOffset++] = value2 + (key ^= value1);
            destination[scrambleOffset++] = value3 + (key -= value2);
            key += value3;
            key += scrmb;
            key = Integer.reverse(key);
        }
    }

    public static void descramblePage(int scramble, int ppn, int[] source, int[] destination) {
        int scrmb = Integer.rotateRight(scramble, 21);
        int key = Integer.rotateRight(ppn, 17) ^ scrmb * 7;
        int scrambleOffset = ((ppn ^ scrmb) & 0x1F) << 4 >> 2;
        int pageSize4 = 128;
        int i = 0;
        while (i < 128) {
            int value0 = source[scrambleOffset++];
            int value1 = source[scrambleOffset++];
            int value2 = source[scrambleOffset++];
            int value3 = source[scrambleOffset++];
            if (scrambleOffset >= 128) {
                scrambleOffset -= 128;
            }
            value0 -= key;
            destination[i++] = value0;
            destination[i++] = value1 -= (key += value0);
            destination[i++] = value2 -= (key ^= value1);
            value3 -= (key -= value2);
            key += value3;
            destination[i++] = value3;
            key += scrmb;
            key = Integer.reverse(key);
        }
    }

    protected void descramblePage(int ppn, TPointer user, byte[] blocks, int offset) {
        int scrmb = Integer.rotateRight(this.scramble, 21);
        int key = Integer.rotateRight(ppn, 17) ^ scrmb * 7;
        int scrambleOffset = ((ppn ^ scrmb) & 0x1F) << 4;
        for (int i = 0; i < 512; i += 16) {
            int value0 = Utilities.readUnaligned32(blocks, offset + scrambleOffset);
            int value1 = Utilities.readUnaligned32(blocks, offset + scrambleOffset + 4);
            int value2 = Utilities.readUnaligned32(blocks, offset + scrambleOffset + 8);
            int value3 = Utilities.readUnaligned32(blocks, offset + scrambleOffset + 12);
            if ((scrambleOffset += 16) >= 512) {
                scrambleOffset -= 512;
            }
            value0 -= key;
            user.setValue32(i, value0);
            user.setValue32(i + 4, value1 -= (key += value0));
            user.setValue32(i + 8, value2 -= (key ^= value1));
            value3 -= (key -= value2);
            key += value3;
            user.setValue32(i + 12, value3);
            key += scrmb;
            key = Integer.reverse(key);
        }
    }

    protected void descramble(int ppn, TPointer user, int len, byte[] blocks, int offset) {
        for (int i = 0; i < len; ++i) {
            this.descramblePage(ppn, user, blocks, offset);
            ++ppn;
            offset += 512;
            user.add(512);
        }
    }

    private void readMasterBootRecord0(TPointer buffer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("readMasterBootRecord0", new Object[0]));
        }
        int partitionEntry = 446;
        buffer.setValue8(partitionEntry + 0, (byte)0);
        buffer.setValue8(partitionEntry + 1, (byte)0);
        buffer.setValue8(partitionEntry + 2, (byte)1);
        buffer.setValue8(partitionEntry + 3, (byte)1);
        buffer.setValue8(partitionEntry + 4, (byte)(sceNand.isSmallNand() ? 5 : 15));
        buffer.setValue8(partitionEntry + 5, (byte)1);
        buffer.setValue8(partitionEntry + 6, (byte)-32);
        buffer.setValue8(partitionEntry + 7, (byte)(sceNand.isSmallNand() ? 190 : 255));
        buffer.setUnalignedValue32(partitionEntry + 8, 64);
        buffer.setUnalignedValue32(partitionEntry + 12, sceNand.isSmallNand() ? 61312 : 122752);
        buffer.setValue8(510, (byte)85);
        buffer.setValue8(511, (byte)-86);
    }

    private void readMasterBootRecordFlash0(TPointer buffer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("readMasterBootRecordFlash0", new Object[0]));
        }
        int partitionEntry = 446;
        buffer.setValue8(partitionEntry + 0, (byte)0);
        buffer.setValue8(partitionEntry + 1, (byte)1);
        buffer.setValue8(partitionEntry + 2, (byte)1);
        buffer.setValue8(partitionEntry + 3, (byte)1);
        buffer.setValue8(partitionEntry + 4, (byte)(sceNand.isSmallNand() ? 1 : 14));
        buffer.setValue8(partitionEntry + 5, (byte)1);
        buffer.setValue8(partitionEntry + 6, (byte)-32);
        buffer.setValue8(partitionEntry + 7, (byte)(sceNand.isSmallNand() ? 0 : 255));
        buffer.setUnalignedValue32(partitionEntry + 8, 32);
        buffer.setUnalignedValue32(partitionEntry + 12, (flash1LbnStart - 2 - 1) * 32);
        buffer.setValue8((partitionEntry += 16) + 0, (byte)0);
        buffer.setValue8(partitionEntry + 1, (byte)0);
        buffer.setValue8(partitionEntry + 2, (byte)-63);
        buffer.setValue8(partitionEntry + 3, (byte)(sceNand.isSmallNand() ? 1 : 255));
        buffer.setValue8(partitionEntry + 4, (byte)(sceNand.isSmallNand() ? 5 : 15));
        buffer.setValue8(partitionEntry + 5, (byte)1);
        buffer.setValue8(partitionEntry + 6, (byte)-32);
        buffer.setValue8(partitionEntry + 7, (byte)(sceNand.isSmallNand() ? 128 : 255));
        buffer.setUnalignedValue32(partitionEntry + 8, (flash1LbnStart - 2) * 32);
        buffer.setUnalignedValue32(partitionEntry + 12, (flash2LbnStart - flash1LbnStart) * 32);
        buffer.setValue8(510, (byte)85);
        buffer.setValue8(511, (byte)-86);
    }

    private void readMasterBootRecordFlash1(TPointer buffer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("readMasterBootRecordFlash1", new Object[0]));
        }
        int partitionEntry = 446;
        buffer.setValue8(partitionEntry + 0, (byte)0);
        buffer.setValue8(partitionEntry + 1, (byte)1);
        buffer.setValue8(partitionEntry + 2, (byte)-63);
        buffer.setValue8(partitionEntry + 3, (byte)(sceNand.isSmallNand() ? 1 : 255));
        buffer.setValue8(partitionEntry + 4, (byte)(sceNand.isSmallNand() ? 1 : 14));
        buffer.setValue8(partitionEntry + 5, (byte)1);
        buffer.setValue8(partitionEntry + 6, (byte)-32);
        buffer.setValue8(partitionEntry + 7, (byte)(sceNand.isSmallNand() ? 128 : 255));
        buffer.setUnalignedValue32(partitionEntry + 8, 32);
        buffer.setUnalignedValue32(partitionEntry + 12, (flash2LbnStart - flash1LbnStart - 1) * 32);
        buffer.setValue8((partitionEntry += 16) + 0, (byte)0);
        buffer.setValue8(partitionEntry + 1, (byte)0);
        buffer.setValue8(partitionEntry + 2, (byte)-63);
        buffer.setValue8(partitionEntry + 3, (byte)(sceNand.isSmallNand() ? 129 : 255));
        buffer.setValue8(partitionEntry + 4, (byte)(sceNand.isSmallNand() ? 5 : 15));
        buffer.setValue8(partitionEntry + 5, (byte)1);
        buffer.setValue8(partitionEntry + 6, (byte)-32);
        buffer.setValue8(partitionEntry + 7, (byte)(sceNand.isSmallNand() ? 160 : 255));
        buffer.setUnalignedValue32(partitionEntry + 8, (flash2LbnStart - 2) * 32);
        buffer.setUnalignedValue32(partitionEntry + 12, sceNand.isSmallNand() ? 2048 : 8192);
        buffer.setValue8(510, (byte)85);
        buffer.setValue8(511, (byte)-86);
    }

    private void readMasterBootRecordFlash2(TPointer buffer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("readMasterBootRecordFlash2", new Object[0]));
        }
        int partitionEntry = 446;
        buffer.setValue8(partitionEntry + 0, (byte)0);
        buffer.setValue8(partitionEntry + 1, (byte)1);
        buffer.setValue8(partitionEntry + 2, (byte)-63);
        buffer.setValue8(partitionEntry + 3, (byte)(sceNand.isSmallNand() ? 129 : 255));
        buffer.setValue8(partitionEntry + 4, (byte)(sceNand.isSmallNand() ? 1 : 14));
        buffer.setValue8(partitionEntry + 5, (byte)1);
        buffer.setValue8(partitionEntry + 6, (byte)-32);
        buffer.setValue8(partitionEntry + 7, (byte)(sceNand.isSmallNand() ? 160 : 255));
        buffer.setUnalignedValue32(partitionEntry + 8, 32);
        buffer.setUnalignedValue32(partitionEntry + 12, (flash3LbnStart - flash2LbnStart - 1) * 32);
        buffer.setValue8((partitionEntry += 16) + 0, (byte)0);
        buffer.setValue8(partitionEntry + 1, (byte)0);
        buffer.setValue8(partitionEntry + 2, (byte)-63);
        buffer.setValue8(partitionEntry + 3, (byte)(sceNand.isSmallNand() ? 161 : 255));
        buffer.setValue8(partitionEntry + 4, (byte)(sceNand.isSmallNand() ? 5 : 15));
        buffer.setValue8(partitionEntry + 5, (byte)1);
        buffer.setValue8(partitionEntry + 6, (byte)-32);
        buffer.setValue8(partitionEntry + 7, (byte)(sceNand.isSmallNand() ? 190 : 255));
        buffer.setUnalignedValue32(partitionEntry + 8, (flash3LbnStart - 2) * 32);
        buffer.setUnalignedValue32(partitionEntry + 12, sceNand.isSmallNand() ? 1920 : 18688);
        buffer.setValue8(510, (byte)85);
        buffer.setValue8(511, (byte)-86);
    }

    private void readMasterBootRecordFlash3(TPointer buffer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("readMasterBootRecordFlash3", new Object[0]));
        }
        int partitionEntry = 446;
        buffer.setValue8(partitionEntry + 0, (byte)0);
        buffer.setValue8(partitionEntry + 1, (byte)1);
        buffer.setValue8(partitionEntry + 2, (byte)-63);
        buffer.setValue8(partitionEntry + 3, (byte)(sceNand.isSmallNand() ? 161 : 255));
        buffer.setValue8(partitionEntry + 4, (byte)(sceNand.isSmallNand() ? 1 : 14));
        buffer.setValue8(partitionEntry + 5, (byte)1);
        buffer.setValue8(partitionEntry + 6, (byte)-32);
        buffer.setValue8(partitionEntry + 7, (byte)(sceNand.isSmallNand() ? 190 : 255));
        buffer.setUnalignedValue32(partitionEntry + 8, 32);
        buffer.setUnalignedValue32(partitionEntry + 12, (flash4LbnStart - flash3LbnStart - 1) * 32);
        if (!sceNand.isSmallNand()) {
            buffer.setValue8((partitionEntry += 16) + 0, (byte)0);
            buffer.setValue8(partitionEntry + 1, (byte)0);
            buffer.setValue8(partitionEntry + 2, (byte)-63);
            buffer.setValue8(partitionEntry + 3, (byte)-1);
            buffer.setValue8(partitionEntry + 4, (byte)15);
            buffer.setValue8(partitionEntry + 5, (byte)1);
            buffer.setValue8(partitionEntry + 6, (byte)-32);
            buffer.setValue8(partitionEntry + 7, (byte)-1);
            buffer.setUnalignedValue32(partitionEntry + 8, (flash4LbnStart - 2) * 32);
            buffer.setUnalignedValue32(partitionEntry + 12, 1664);
        }
        buffer.setValue8(510, (byte)85);
        buffer.setValue8(511, (byte)-86);
    }

    private void readMasterBootRecordFlash4(TPointer buffer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("readMasterBootRecordFlash4", new Object[0]));
        }
        int partitionEntry = 446;
        buffer.setValue8(partitionEntry + 0, (byte)0);
        buffer.setValue8(partitionEntry + 1, (byte)1);
        buffer.setValue8(partitionEntry + 2, (byte)-63);
        buffer.setValue8(partitionEntry + 3, (byte)-1);
        buffer.setValue8(partitionEntry + 4, (byte)14);
        buffer.setValue8(partitionEntry + 5, (byte)1);
        buffer.setValue8(partitionEntry + 6, (byte)-32);
        buffer.setValue8(partitionEntry + 7, (byte)-1);
        buffer.setUnalignedValue32(partitionEntry + 8, 32);
        buffer.setUnalignedValue32(partitionEntry + 12, (flash5LbnStart - flash4LbnStart - 1) * 32);
        buffer.setValue8(510, (byte)85);
        buffer.setValue8(511, (byte)-86);
    }

    private void readFile(TPointer buffer, IVirtualFile vFile, int ppn, int lbnStart) {
        int lbn = this.ppnToLbn[ppn];
        int sectorNumber = (lbn - lbnStart) * 32 + ppn % 32;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("readFile ppn=0x%X, lbnStart=0x%X, lbn=0x%X, sectorNumber=0x%X, vFile=%s", ppn, lbnStart, lbn, sectorNumber, vFile));
        }
        this.readFile(buffer, vFile, sectorNumber);
    }

    private void readFile(TPointer buffer, IVirtualFile vFile, int sectorNumber) {
        vFile.ioLseek(sectorNumber * 512);
        vFile.ioRead(buffer, 512);
    }

    private int getIdStorageKey(int page) {
        if (page < 0 || page >= sceIdStorage.idStorageKeys.length) {
            return -1;
        }
        return sceIdStorage.idStorageKeys[page];
    }

    private void readIdStoragePage(TPointer buffer, int page) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("readIdStoragePage page=0x%X", page));
        }
        switch (page) {
            case 0: {
                buffer.memset((byte)-1, 512);
                for (int i = 0; i < sceIdStorage.idStorageKeys.length; ++i) {
                    buffer.setValue16(i << 1, (short)sceIdStorage.idStorageKeys[i]);
                }
                break;
            }
            case 1: {
                buffer.memset((byte)-1, 512);
                break;
            }
            default: {
                int key = this.getIdStorageKey(page);
                if (key < 0) break;
                Modules.sceIdStorageModule.hleIdStorageReadLeaf(key, buffer);
            }
        }
    }

    private int computeEcc(SceNandSpare spare) {
        int s3 = spare.blockFmt;
        int v0 = spare.blockStat;
        int t4 = spare.lbn >> 8;
        int t2 = spare.lbn & 0xFF;
        int s0 = spare.id & 0xFF;
        int t7 = s3 ^ v0;
        int s1 = spare.id >> 8 & 0xFF;
        int t9 = t4 ^ t7;
        int s5 = spare.id >> 16 & 0xFF;
        int t6 = t2 ^ t9;
        int v1 = s0 ^ t6;
        t9 = spare.id >> 24 & 0xFF;
        int a3 = s0 ^ s1;
        int t5 = s1 ^ v1;
        int s2 = t4 ^ t2;
        int t0 = s5 ^ t5;
        int t3 = s5 ^ a3;
        t5 = s5 ^ s2;
        int s4 = t9 ^ t0;
        a3 = t9 ^ t3;
        int a0 = s4 & 0xFF;
        s2 = v0 ^ t2;
        s4 = t6 & 0xFF;
        t3 = s0 ^ t7;
        t6 = a3 & 0xFF;
        t7 = t9 ^ t5;
        v0 = 27030;
        t0 = t7 & 0xFF;
        a3 = s4 >> 4;
        t7 = s3 ^ t4;
        t5 = s4 & 0xF;
        s3 = s1 ^ s2;
        s4 = t6 & 0xF;
        s2 = s1 ^ t3;
        t4 = t6 >> 4;
        s1 = a0 & 0xCC;
        t6 = v0 >> t4;
        v1 = v0 >> s4;
        t3 = s2 & 0xFF;
        t4 = a0 >> 4;
        int t1 = v0 >> t5;
        s2 = s1 >> 4;
        t5 = v0 >> a3;
        s1 = s0 ^ t7;
        a3 = a0 & 0xF;
        s0 = t9 ^ s3;
        t7 = a0 & 0xC;
        s3 = t0 >> 4;
        s4 = t0 & 0xF;
        t2 = s0 & 0xFF;
        s2 = v0 >> s2;
        s0 = v0 >> t7;
        t0 = v0 >> s4;
        t7 = v0 >> a3;
        s4 = v0 >> s3;
        a3 = v0 >> t4;
        t1 ^= t5;
        t4 = s5 ^ s1;
        t5 = v1 ^ t6;
        s5 = t3 >> 4;
        s3 = a0 & 0xAA;
        t6 = a0 & 3;
        s1 = a0 >> 4 & 3;
        t3 &= 0xF;
        s1 = v0 >> s1;
        s5 = v0 >> s5;
        s0 ^= s2;
        t0 ^= s4;
        t4 &= 0xFF;
        t6 = v0 >> t6;
        s2 = t7 & 1;
        s4 = t2 >> 4;
        t3 = v0 >> t3;
        v1 = t5 & 1;
        s3 >>= 4;
        t5 = a0 & 0xA;
        a3 &= 1;
        t1 &= 1;
        t2 &= 0xF;
        t6 ^= s1;
        t3 ^= s5;
        s3 = v0 >> s3;
        s5 = v0 >> t5;
        t7 = s2 << 2;
        s4 = v0 >> s4;
        a3 <<= 8;
        s2 = t4 >> 4;
        t2 = v0 >> t2;
        t1 <<= 5;
        s1 = a0 & 0x55;
        s0 &= 1;
        t0 &= 1;
        v1 <<= 11;
        t4 &= 0xF;
        t5 = s5 ^ s3;
        t2 ^= s4;
        s5 = a3 | t7;
        s4 = t6 & 1;
        s2 = v0 >> s2;
        t7 = t3 & 1;
        v1 |= t1;
        s1 >>= 4;
        t1 = v0 >> t4;
        s3 = s5 | (s0 <<= 7);
        s5 = t1 ^ s2;
        s0 = s4 << 1;
        s2 = v0 >> (a0 &= 5);
        t1 = v1 | (t0 <<= 10);
        v0 >>= s1;
        t0 = t5 & 1;
        s1 = t7 << 4;
        s4 = t2 & 1;
        t7 = s2 ^ v0;
        t6 = s5 & 1;
        s2 = s3 | s0;
        s0 = t1 | s1;
        s3 = t0 << 6;
        s1 = s4 << 9;
        v0 = s0 | s1;
        t3 = s2 | s3;
        t2 = t7 & 1;
        t1 = t6 << 3;
        a0 = v0 | t1;
        t0 = t3 | t2;
        v0 = t0 | a0;
        return v0;
    }

    private void openFileIpl() {
        if (this.vFileIpl != null) {
            return;
        }
        try {
            this.vFileIpl = new LocalVirtualFile(new SeekableRandomFile("nand.ipl.bin", "rw"));
            if (this.vFileIpl.length() == 0L) {
                byte[] buffer = new byte[16384];
                int iplPpn = 512;
                int offset = 0;
                while (iplPpn < 799) {
                    Utilities.writeUnaligned16(buffer, offset, iplPpn / 32);
                    iplPpn += 32;
                    offset += 2;
                }
                this.vFileIpl.ioLseek(0L);
                for (int n = 128; n <= 383; n += 32) {
                    this.vFileIpl.ioWrite(buffer, 0, buffer.length);
                }
                this.vFileIpl.ioLseek(0L);
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)"openFileIpl", (Throwable)e);
        }
    }

    public static boolean isSmallNand() {
        return Nand.getTotalSizeMb() <= 32;
    }

    private static int getTotalSectorsFlash0() {
        return sceNand.isSmallNand() ? 49120 : 83936;
    }

    private static int getTotalSectorsFlash1() {
        return sceNand.isSmallNand() ? 8160 : 10208;
    }

    private static int getTotalSectorsFlash2() {
        return sceNand.isSmallNand() ? 2016 : 8160;
    }

    private static int getTotalSectorsFlash3() {
        return sceNand.isSmallNand() ? 1888 : 18656;
    }

    private static int getTotalSectorsFlash4() {
        return sceNand.isSmallNand() ? 0 : 1632;
    }

    private void openFileFlash0() {
        if (this.vFileFlash0 != null) {
            return;
        }
        IVirtualFileSystem vfs = new LocalVirtualFileSystem(Settings.getInstance().getDirectoryMapping("flash0"), false);
        if (!RuntimeContextLLE.isLLEActive()) {
            vfs = new PatchFileVirtualFileSystem(vfs);
            vfs = new CompressPrxVirtualFileSystem(vfs);
        }
        this.vFileFlash0 = new Fat12VirtualFile("flash0:", vfs, sceNand.getTotalSectorsFlash0());
        this.vFileFlash0.scan();
    }

    private void openFileFlash1() {
        if (this.vFileFlash1 != null) {
            return;
        }
        LocalVirtualFileSystem vfs = new LocalVirtualFileSystem(Settings.getInstance().getDirectoryMapping("flash1"), false);
        this.vFileFlash1 = new Fat12VirtualFile("flash1:", vfs, sceNand.getTotalSectorsFlash1());
        this.vFileFlash1.scan();
    }

    private void openFileFlash2() {
        if (this.vFileFlash2 != null) {
            return;
        }
        LocalVirtualFileSystem vfs = new LocalVirtualFileSystem(Settings.getInstance().getDirectoryMapping("flash2"), false);
        this.vFileFlash2 = new Fat12VirtualFile("flash2:", vfs, sceNand.getTotalSectorsFlash2());
        this.vFileFlash2.scan();
    }

    private void openFileFlash3() {
        if (this.vFileFlash3 != null) {
            return;
        }
        LocalVirtualFileSystem vfs = new LocalVirtualFileSystem(Settings.getInstance().getDirectoryMapping("flash3"), false);
        this.vFileFlash3 = new Fat12VirtualFile("flash3:", vfs, sceNand.getTotalSectorsFlash3());
        this.vFileFlash3.scan();
    }

    private boolean isEmptyPage(TPointer user, int emptyValue) {
        IMemoryReader pageReader = MemoryReader.getMemoryReader(user, 512, 4);
        for (int i = 0; i < 512; i += 4) {
            int value = pageReader.readNext();
            if (value == emptyValue) continue;
            return false;
        }
        return true;
    }

    public int hleNandReadPages(int ppn, TPointer user, TPointer spare, int len, boolean raw, boolean spareUserEcc, boolean isLLE) {
        int i;
        boolean[] emptyPages = new boolean[len];
        this.initNandInMemory();
        if (user.isNotNull()) {
            if (this.dumpBlocks != null) {
                // empty if block
            }
            if (this.nandMemory != null) {
                user.memcpy(this.nandMemory.getPointer(ppn * 512), len * 512);
            } else {
                for (i = 0; i < len; ++i) {
                    user.clear(512);
                    int n = ppn + i;
                    if (n >= 128 && n <= 799) {
                        this.openFileIpl();
                        this.readFile(user, this.vFileIpl, ppn + i - 128);
                        emptyPages[i] = this.isEmptyPage(user, -1);
                    } else if (n >= 1536 && n <= 2047) {
                        this.readIdStoragePage(user, ppn + i - 1536);
                    } else if (this.ppnToLbn[n] == 0) {
                        this.readMasterBootRecord0(user);
                    } else if (this.ppnToLbn[n] == 2) {
                        this.readMasterBootRecordFlash0(user);
                    } else if (this.ppnToLbn[n] > 2 && this.ppnToLbn[n] < flash1LbnStart) {
                        this.openFileFlash0();
                        this.readFile(user, this.vFileFlash0, n, 3);
                    } else if (this.ppnToLbn[n] == flash1LbnStart) {
                        this.readMasterBootRecordFlash1(user);
                    } else if (this.ppnToLbn[n] > flash1LbnStart && this.ppnToLbn[n] < flash2LbnStart) {
                        this.openFileFlash1();
                        this.readFile(user, this.vFileFlash1, n, flash1LbnStart + 1);
                    } else if (this.ppnToLbn[n] == flash2LbnStart) {
                        this.readMasterBootRecordFlash2(user);
                    } else if (this.ppnToLbn[n] > flash2LbnStart && this.ppnToLbn[n] < flash3LbnStart) {
                        this.openFileFlash2();
                        this.readFile(user, this.vFileFlash2, n, flash2LbnStart + 1);
                    } else if (this.ppnToLbn[n] == flash3LbnStart) {
                        this.readMasterBootRecordFlash3(user);
                    } else if (!sceNand.isSmallNand() && this.ppnToLbn[n] > flash3LbnStart && this.ppnToLbn[n] < flash4LbnStart) {
                        this.openFileFlash3();
                        this.readFile(user, this.vFileFlash3, n, flash3LbnStart + 1);
                    } else if (!sceNand.isSmallNand() && this.ppnToLbn[n] == flash4LbnStart) {
                        this.readMasterBootRecordFlash4(user);
                    }
                    user.add(512);
                }
            }
        }
        if (spare.isNotNull()) {
            if (this.dumpSpares != null) {
                // empty if block
            }
            if (this.nandSpareMemory != null) {
                if (spareUserEcc) {
                    spare.memcpy(this.nandSpareMemory.getPointer(ppn << 4), len << 4);
                } else {
                    for (i = 0; i < len; ++i) {
                        spare.memcpy(i * 12, this.nandSpareMemory.getPointer((ppn + i << 4) + 4), 12);
                    }
                }
            } else {
                SceNandSpare sceNandSpare = new SceNandSpare();
                for (int i2 = 0; i2 < len; ++i2) {
                    int n = ppn + i2;
                    sceNandSpare.blockFmt = n < 2048 ? 255 : 0;
                    sceNandSpare.blockStat = 255;
                    sceNandSpare.lbn = this.ppnToLbn[n];
                    if (n >= 128 && n <= 383 || n >= 512 && n <= 799) {
                        if (emptyPages[i2]) {
                            sceNandSpare.id = -1;
                            sceNandSpare.lbn = 65535;
                        } else {
                            sceNandSpare.id = 1841711672;
                        }
                    } else if (n >= 1536 && n <= 2047) {
                        sceNandSpare.id = -65279;
                        sceNandSpare.lbn = 29441;
                    } else if (n > 128 && n <= 159) {
                        sceNandSpare.id = -1;
                        sceNandSpare.lbn = 65535;
                    }
                    sceNandSpare.reserved2[0] = 255;
                    sceNandSpare.reserved2[1] = 255;
                    sceNandSpare.spareEcc = this.computeEcc(sceNandSpare) | 0xF000;
                    if (!isLLE && sceNandSpare.lbn == 65535) {
                        sceNandSpare.userEcc[0] = 255;
                        sceNandSpare.userEcc[1] = 255;
                        sceNandSpare.userEcc[2] = 255;
                        sceNandSpare.reserved1 = 255;
                        sceNandSpare.blockFmt = 255;
                        sceNandSpare.blockStat = 255;
                        sceNandSpare.id = -1;
                        sceNandSpare.spareEcc = 65535;
                        sceNandSpare.reserved2[0] = 255;
                        sceNandSpare.reserved2[1] = 255;
                    }
                    if (spareUserEcc) {
                        sceNandSpare.write(spare, i2 * sceNandSpare.sizeof());
                        continue;
                    }
                    sceNandSpare.writeNoUserEcc(spare, i2 * sceNandSpare.sizeofNoEcc());
                }
            }
        }
        int result = 0;
        if (this.dumpResults != null) {
            // empty if block
        }
        return result;
    }

    private void writeFile(TPointer buffer, IVirtualFile vFile, int ppn, int lbnStart) {
        int lbn = this.ppnToLbn[ppn];
        int sectorNumber = (lbn - lbnStart) * 32 + ppn % 32;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("writeFile ppn=0x%X, lbnStart=0x%X, lbn=0x%X, sectorNumber=0x%X", ppn, lbnStart, lbn, sectorNumber));
        }
        this.writeFile(buffer, vFile, sectorNumber);
    }

    private void writeFile(TPointer buffer, IVirtualFile vFile, int sectorNumber) {
        vFile.ioLseek(sectorNumber * 512);
        vFile.ioWrite(buffer, 512);
    }

    public int hleNandWriteSparePages(int ppn, TPointer spare, int len, boolean raw, boolean spareUserEcc, boolean isLLE) {
        int result;
        block14: {
            result = 0;
            this.initNandInMemory();
            if (!spare.isNotNull()) break block14;
            if (this.nandSpareMemory != null) {
                this.nandSpareMemoryPointer.memcpy(ppn << 4, spare, len << 4);
                SceNandSpare sceNandSpare = new SceNandSpare();
                for (int i = 0; i < len; ++i) {
                    if (spareUserEcc) {
                        sceNandSpare.read(spare, i * sceNandSpare.sizeof());
                    } else {
                        sceNandSpare.readNoUserEcc(spare, i * sceNandSpare.sizeofNoEcc());
                    }
                    int n = ppn + i;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("hleNandWriteSparePages ppn=0x%X: changed lbn=0x%X to lbn=0x%X", n, this.ppnToLbn[n], sceNandSpare.lbn));
                    }
                    this.ppnToLbn[n] = sceNandSpare.lbn;
                }
            } else {
                SceNandSpare sceNandSpare = new SceNandSpare();
                for (int i = 0; i < len; ++i) {
                    int offset;
                    if (spareUserEcc) {
                        sceNandSpare.read(spare, i * sceNandSpare.sizeof());
                    } else {
                        sceNandSpare.readNoUserEcc(spare, i * sceNandSpare.sizeofNoEcc());
                    }
                    int n = ppn + i;
                    if (n >= 128 && n <= 383) {
                        if (sceNandSpare.lbn == 65535) continue;
                        this.ppnToLbn[n] = sceNandSpare.lbn;
                        continue;
                    }
                    if (n >= 512 && n <= 799) {
                        if (sceNandSpare.lbn == 65535) continue;
                        this.ppnToLbn[n] = sceNandSpare.lbn;
                        continue;
                    }
                    if (sceNandSpare.lbn == 65535 || this.ppnToLbn[n] == sceNandSpare.lbn) continue;
                    for (int j = offset = n % 32; j < this.ppnToLbn.length; j += 32) {
                        if (this.ppnToLbn[j] != sceNandSpare.lbn) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("hleNandWriteSparePages moving lbn=0x%04X from ppn=0x%X to ppn=0x%X", sceNandSpare.lbn, j, ppn + i));
                        }
                        this.ppnToLbn[j] = 65535;
                        break;
                    }
                    if (this.ppnToLbn[n] != 65535) {
                        log.error((Object)String.format("hleNandWriteSparePages moving lbn=0x%04X to ppn=0x%X not being free (currently used for lbn=0x%04X)", sceNandSpare.lbn, n, this.ppnToLbn[n]));
                    }
                    this.ppnToLbn[n] = sceNandSpare.lbn;
                }
            }
        }
        return result;
    }

    private void notifyWrite(int ppn, int len) {
        for (int i = 0; i < len; ++i) {
            int n = ppn + i;
            if (n >= 128 && n <= 799) {
                this.syncIpl.notifyWrite();
                continue;
            }
            if (this.ppnToLbn[n] > 2 && this.ppnToLbn[n] < flash1LbnStart) {
                this.syncFlash0.notifyWrite();
                continue;
            }
            if (this.ppnToLbn[n] > flash1LbnStart && this.ppnToLbn[n] < flash2LbnStart) {
                this.syncFlash1.notifyWrite();
                continue;
            }
            if (this.ppnToLbn[n] > flash2LbnStart && this.ppnToLbn[n] < flash3LbnStart) {
                this.syncFlash2.notifyWrite();
                continue;
            }
            if (this.ppnToLbn[n] <= flash3LbnStart || this.ppnToLbn[n] >= flash4LbnStart || this.syncFlash3 == null) continue;
            this.syncFlash3.notifyWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hleNandWriteUserPages(int ppn, TPointer user, int len, boolean raw, boolean isLLE) {
        int result = 0;
        Object object = this.writeLock;
        synchronized (object) {
            this.initNandInMemory();
            if (user.isNotNull()) {
                if (this.nandMemory != null) {
                    this.nandMemoryPointer.memcpy(ppn * 512, user, len * 512);
                    this.notifyWrite(ppn, len);
                } else {
                    for (int i = 0; i < len; ++i) {
                        int n = ppn + i;
                        if (n < 128 || n > 383) {
                            if (n >= 512 && n <= 799) {
                                this.openFileIpl();
                                this.writeFile(user, this.vFileIpl, n - 512);
                            } else if (this.ppnToLbn[n] > 2 && this.ppnToLbn[n] < flash1LbnStart) {
                                this.openFileFlash0();
                                this.writeFile(user, this.vFileFlash0, n, 3);
                            } else if (this.ppnToLbn[n] > flash1LbnStart && this.ppnToLbn[n] < flash2LbnStart) {
                                this.openFileFlash1();
                                this.writeFile(user, this.vFileFlash1, n, flash1LbnStart + 1);
                            } else if (this.ppnToLbn[n] > flash2LbnStart && this.ppnToLbn[n] < flash3LbnStart) {
                                this.openFileFlash2();
                                this.writeFile(user, this.vFileFlash2, n, flash2LbnStart + 1);
                            } else if (!sceNand.isSmallNand() && this.ppnToLbn[n] > flash3LbnStart && this.ppnToLbn[n] < flash4LbnStart) {
                                this.openFileFlash3();
                                this.writeFile(user, this.vFileFlash3, n, flash3LbnStart + 1);
                            } else {
                                log.error((Object)String.format("hleNandWriteUserPages unimplemented write on ppn=0x%X, lbn=0x%X", n, this.ppnToLbn[n]));
                            }
                        }
                        user.add(512);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int hleNandWritePages(int ppn, TPointer user, TPointer spare, int len, boolean raw, boolean spareUserEcc, boolean isLLE) {
        Object object = this.writeLock;
        synchronized (object) {
            int result = this.hleNandWriteSparePages(ppn, spare, len, raw, spareUserEcc, isLLE);
            if (result != 0) {
                return result;
            }
            return this.hleNandWriteUserPages(ppn, user, len, raw, isLLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hleNandEraseBlock(int ppn, boolean isLLE) {
        Object object = this.writeLock;
        synchronized (object) {
            if (isLLE) {
                int lbn = 65535;
                for (int i = 0; i < 32; ++i) {
                    int n = ppn + i;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("hleNandEraseBlock ppn=0x%X: changed lbn=0x%X to lbn=0x%X", n, this.ppnToLbn[n], lbn));
                    }
                    this.ppnToLbn[n] = lbn;
                }
            }
        }
        return 0;
    }

    public int getLbnFromPpn(int ppn) {
        return this.ppnToLbn[ppn];
    }

    public int getPpnFromLbn(int lbn) {
        for (int ppn = 0; ppn < this.ppnToLbn.length; ++ppn) {
            if (this.ppnToLbn[ppn] != lbn) continue;
            return ppn;
        }
        return -1;
    }

    @HLEFunction(nid=-1334033964, version=150, jumpCall=true)
    public int sceNandGetPagesPerBlock() {
        return 32;
    }

    @HLEFunction(nid=-828881946, version=150)
    public int sceNandGetPageSize() {
        return 512;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1371260729, version=150, jumpCall=true)
    public int sceNandLock(int mode) {
        this.sceNandSetWriteProtect(mode == 0);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1107273762, version=150, jumpCall=true)
    public int sceNandUnlock() {
        this.sceNandSetWriteProtect(true);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=32543235, version=150, jumpCall=true)
    public int sceNandIsBadBlock(int ppn) {
        if (ppn % 32 != 0) {
            return -1;
        }
        int result = 0;
        if (this.dumpSpares != null) {
            int blockStat = this.dumpSpares[ppn * 16 + 5] & 0xFF;
            result = blockStat == 255 ? 0 : 1;
        }
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=200183606, version=150)
    public int sceNandSetScramble(int scramble) {
        this.scramble = scramble;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2064753290, version=150, jumpCall=true)
    public boolean sceNandSetWriteProtect(boolean protect) {
        boolean result = this.writeProtected;
        this.writeProtected = protect;
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1993206166, version=150, jumpCall=true)
    public int sceNandWritePagesRawExtra(int ppn, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=512, usage=BufferInfo.Usage.in) TPointer user, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.in) TPointer spare, int len) {
        return this.hleNandWritePages(ppn, user, spare, len, true, false, false);
    }

    @HLEUnimplemented
    @HLEFunction(nid=1367524244, version=150, jumpCall=true)
    public int sceNandReadExtraOnly(int ppn, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.out) TPointer spare, int len) {
        this.hleNandReadPages(ppn, TPointer.NULL, spare, len, true, true, false);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1984050680, version=150, jumpCall=true)
    public int sceNandReadPages(int ppn, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=512, usage=BufferInfo.Usage.out) TPointer user, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=12, usage=BufferInfo.Usage.out) TPointer spare, int len) {
        return this.hleNandReadPages(ppn, user, spare, len, false, false, false);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-530913139, version=150, jumpCall=true)
    public int sceNandReadPagesRawExtra(int ppn, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=512, usage=BufferInfo.Usage.out) TPointer user, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=12, usage=BufferInfo.Usage.out) TPointer spare, int len) {
        return this.hleNandReadPages(ppn, user, spare, len, true, false, false);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1020354479, version=150, jumpCall=true)
    public int sceNandReadBlockWithRetry(int ppn, TPointer user, TPointer spare) {
        return this.hleNandReadPages(ppn, user, spare, 32, false, false, false);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1297079835, version=150, jumpCall=true)
    public int sceNandWriteBlockWithVerify(int ppn, TPointer user, TPointer spare) {
        return this.hleNandWritePages(ppn, user, spare, 32, false, false, false);
    }

    @HLEFunction(nid=-1053335006, version=150, jumpCall=true)
    public int sceNandGetTotalBlocks() {
        return Nand.getTotalBlocks();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-468053538, version=150, jumpCall=true)
    public int sceNandReadStatus() {
        int result = 0;
        if (!this.writeProtected) {
            result |= 0x80;
        }
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-351666142, version=150, jumpCall=true)
    public int sceNandEraseBlock(int ppn) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2063054714, version=150)
    public int sceNandReset(@CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer8 statusAddr) {
        statusAddr.setValue(0);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public boolean sceNandIsReady() {
        return true;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public int sceNandInit2() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public int sceNandTransferDataToNandBuf() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public int sceNandIntrHandler() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1, version=150)
    public int sceNandTransferDataFromNandBuf() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-52464112, version=150)
    public int sceNandReadId(@CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.out) TPointer8 id, int len) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1986483951, version=150)
    public int sceNandReadAccess(int ppn, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=512, usage=BufferInfo.Usage.out) TPointer user, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=12, usage=BufferInfo.Usage.out) TPointer spare, int len, int mode) {
        return this.hleNandReadPages(ppn, user, spare, len, false, false, false);
    }

    @HLEUnimplemented
    @HLEFunction(nid=182224518, version=150)
    public int sceNandWriteAccess(int ppn, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=512, usage=BufferInfo.Usage.in) TPointer user, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=12, usage=BufferInfo.Usage.in) TPointer spare, int len, int mode) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1963938913, version=150, jumpCall=true)
    public int sceNandWritePages(int ppn, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=512, usage=BufferInfo.Usage.in) TPointer user, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=12, usage=BufferInfo.Usage.in) TPointer spare, int len) {
        return this.hleNandWritePages(ppn, user, spare, len, false, false, false);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-998719010, version=150)
    public int sceNandReadPagesRawAll(int ppn, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=512, usage=BufferInfo.Usage.out) TPointer user, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=12, usage=BufferInfo.Usage.out) TPointer spare, int len) {
        return this.hleNandReadPages(ppn, user, spare, len, true, false, false);
    }

    @HLEUnimplemented
    @HLEFunction(nid=1522542421, version=150)
    public int sceNandVerifyBlockWithRetry(int ppn, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=512, usage=BufferInfo.Usage.out) TPointer user, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=12, usage=BufferInfo.Usage.out) TPointer spare) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1993100576, version=150)
    public int sceNandEraseBlockWithRetry(int ppn) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1029856970, version=150, jumpCall=true)
    public int sceNandDoMarkAsBadBlock(int ppn) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=804653083, version=150)
    public int sceNandDetectChipMakersBBM(int ppn) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1159897786, version=150)
    public int sceNandWritePagesRawAll(int ppn, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=512, usage=BufferInfo.Usage.in) TPointer user, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=12, usage=BufferInfo.Usage.in) TPointer spare, int len) {
        return this.hleNandWritePages(ppn, user, spare, len, true, false, false);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-661142717, version=150)
    public int sceNandDetectChip() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1064746017, version=150)
    public int sceNandDumpWearBBMSize() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-341776698, version=150)
    public int sceNandCountChipMakersBBM() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=645189630, version=150)
    public int sceNandEraseAllBlock() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1691696077, version=150, jumpCall=true)
    public int sceNandTestBlock() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1902957234, version=150)
    public int sceNandWriteBlock() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-279580269, version=150)
    public int sceNandCalcEcc(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=8, usage=BufferInfo.Usage.in) TPointer buffer) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=414680673, version=150)
    public int sceNandVerifyEcc() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1999855758, version=150)
    public int sceNandCorrectEcc(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=8, usage=BufferInfo.Usage.inout) TPointer buffer, int ecc) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1214917907, version=150, jumpCall=true)
    public int sceNandCollectEcc(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=8, usage=BufferInfo.Usage.inout) TPointer buffer, int ecc) {
        return this.sceNandCorrectEcc(buffer, ecc);
    }
}

