/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import jpcsp.Allegrex.CpuState;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.StringInfo;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceNetIfMessage;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.Memory;
import jpcsp.hardware.Wlan;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.network.INetworkAdapter;
import jpcsp.network.NetworkAdapterFactory;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceNet
extends HLEModule {
    public static Logger log = Modules.getLogger("sceNet");
    private INetworkAdapter networkAdapter;
    protected int netMemSize;
    private static final int[] look_ctype_table = new int[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 8, 8, 8, 8, 8, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 24, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 16, 16, 16, 16, 16, 16, 16, 65, 65, 65, 65, 65, 65, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 16, 16, 16, 16, 16, 16, 66, 66, 66, 66, 66, 66, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 16, 16, 16, 16, 32};
    protected Map<Integer, Integer> allocatedThreadStructures;
    protected final Random random = new Random();
    protected int readCallback;
    protected int unknownCallback1;
    protected int adhocSocketAlertCallback;
    protected int getReadContextCallback;
    protected TPointer32 readContextAddr;
    protected TPointer readMessage;
    protected Map<Integer, Integer> blockedThreads;

    @Override
    public void start() {
        this.networkAdapter = NetworkAdapterFactory.createNetworkAdapter();
        this.networkAdapter.start();
        this.allocatedThreadStructures = new HashMap<Integer, Integer>();
        this.readCallback = 0;
        this.unknownCallback1 = 0;
        this.adhocSocketAlertCallback = 0;
        this.getReadContextCallback = 0;
        this.blockedThreads = new HashMap<Integer, Integer>();
        super.start();
    }

    @Override
    public void stop() {
        this.networkAdapter.stop();
        this.networkAdapter = null;
        super.stop();
    }

    public INetworkAdapter getNetworkAdapter() {
        return this.networkAdapter;
    }

    public static String convertMacAddressToString(byte[] macAddress) {
        return String.format("%02x:%02x:%02x:%02x:%02x:%02x", macAddress[0], macAddress[1], macAddress[2], macAddress[3], macAddress[4], macAddress[5]);
    }

    protected static int parseHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        log.error((Object)String.format("Cannot parse hex digit '%c'", Character.valueOf(c)));
        return 0;
    }

    public static byte[] convertStringToMacAddress(String str) {
        byte[] macAddress = new byte[6];
        int n = 0;
        for (int i = 0; i < macAddress.length; ++i) {
            int n1 = sceNet.parseHexDigit(str.charAt(n++));
            int n2 = sceNet.parseHexDigit(str.charAt(n++));
            ++n;
            macAddress[i] = (byte)((n1 << 4) + n2);
        }
        return macAddress;
    }

    protected int networkSwap32(int value) {
        return Utilities.endianSwap32(value);
    }

    protected int networkSwap16(int value) {
        return Utilities.endianSwap16(value);
    }

    protected void sendDummyMessage(SceKernelThreadInfo thread) {
        int mem;
        if (this.readContextAddr == null && (mem = Modules.sceNetIfhandleModule.hleNetMallocInternal(4)) > 0) {
            this.readContextAddr = new TPointer32(Memory.getInstance(), mem);
        }
        if (this.readContextAddr != null) {
            Modules.ThreadManForUserModule.executeCallback(thread, this.getReadContextCallback, new AfterReadContextCallback(), true, 0, 0, this.readContextAddr.getAddress());
        }
    }

    protected void hleAfterReadContextCallback() {
        int size;
        int mem;
        if (this.readMessage == null && (mem = Modules.sceNetIfhandleModule.hleNetMallocInternal(size = 256)) > 0) {
            this.readMessage = new TPointer(Memory.getInstance(), mem);
            this.readMessage.clear(size);
            RuntimeContext.debugMemory(mem, size);
        }
        if (this.readMessage != null) {
            SceNetIfMessage message = new SceNetIfMessage();
            TPointer data = new TPointer(Memory.getInstance(), this.readMessage.getAddress() + message.sizeof());
            TPointer header = new TPointer(data.getMemory(), data.getAddress());
            TPointer content = new TPointer(data.getMemory(), data.getAddress() + 60);
            int contentLength = 8;
            header.setArray(0, Wlan.getMacAddress());
            header.setArray(6, new byte[]{17, 34, 51, 68, 85, 102});
            header.setValue8(48, (byte)1);
            header.setValue8(49, (byte)0);
            header.setValue16(50, (short)Utilities.endianSwap16(20));
            header.setValue16(52, (short)Utilities.endianSwap16(556));
            header.setValue16(54, (short)Utilities.endianSwap16(556));
            header.setValue8(58, (byte)0);
            header.setValue8(59, (byte)0);
            content.setValue8(0, (byte)1);
            content.setValue8(1, (byte)1);
            content.setValue16(2, (short)Utilities.endianSwap16(4));
            content.setValue8(4, (byte)0);
            content.setValue8(5, (byte)0);
            content.setValue8(6, (byte)0);
            content.setValue8(7, (byte)0);
            message.dataAddr = data.getAddress();
            message.dataLength = 68;
            message.unknown24 = 68;
            message.write(this.readMessage);
            TPointer readContext = new TPointer(Memory.getInstance(), this.readContextAddr.getValue());
            readContext.setValue32(0, this.readMessage.getAddress());
            readContext.setValue32(8, readContext.getValue32(8) + 1);
        }
        SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
        Modules.ThreadManForUserModule.executeCallback(thread, this.readCallback, null, true);
    }

    @HLELogging(level="info")
    @HLEFunction(nid=967784870, version=150, checkInsideInterrupt=true)
    public int sceNetInit(int poolSize, int calloutThreadPri, int calloutThreadStack, int netinitThreadPri, int netinitThreadStack) {
        this.netMemSize = poolSize;
        return 0;
    }

    @HLEFunction(nid=672737449, version=150, checkInsideInterrupt=true)
    public int sceNetTerm() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1348760880, version=150, checkInsideInterrupt=true)
    public int sceNetFreeThreadinfo(int threadID) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1385675578, version=150, checkInsideInterrupt=true)
    public int sceNetThreadAbort(int threadID) {
        return 0;
    }

    @HLEFunction(nid=-1992947376, version=150, checkInsideInterrupt=true)
    public void sceNetEtherNtostr(@CanBeNull pspNetMacAddress macAddress, @CanBeNull TPointer strAddr) {
        if (macAddress.isNotNull() && strAddr.isNotNull()) {
            Utilities.writeStringZ(Memory.getInstance(), strAddr.getAddress(), sceNet.convertMacAddressToString(macAddress.macAddress));
        }
    }

    @HLEFunction(nid=-763797047, version=150, checkInsideInterrupt=true)
    public void sceNetEtherStrton(@StringInfo(maxLength=17) @CanBeNull PspString str, @CanBeNull TPointer etherAddr) {
        if (str.isNotNull() && etherAddr.isNotNull()) {
            pspNetMacAddress macAddress = new pspNetMacAddress();
            macAddress.setMacAddress(sceNet.convertStringToMacAddress(str.getString()));
            macAddress.write(etherAddr);
        }
    }

    @HLEFunction(nid=-176136450, version=150, checkInsideInterrupt=true)
    public int sceNetHtonl(int host32) {
        return this.networkSwap32(host32);
    }

    @HLEFunction(nid=968998658, version=150, checkInsideInterrupt=true)
    public int sceNetHtons(int host16) {
        return this.networkSwap16(host16);
    }

    @HLEFunction(nid=-1815826562, version=150, checkInsideInterrupt=true)
    public int sceNetNtohl(int net32) {
        return this.networkSwap32(net32);
    }

    @HLEFunction(nid=1289761287, version=150, checkInsideInterrupt=true)
    public int sceNetNtohs(int net16) {
        return this.networkSwap16(net16);
    }

    @HLEFunction(nid=200319918, version=150, checkInsideInterrupt=true)
    public int sceNetGetLocalEtherAddr(TPointer etherAddr) {
        pspNetMacAddress macAddress = new pspNetMacAddress();
        macAddress.setMacAddress(Wlan.getMacAddress());
        macAddress.write(etherAddr);
        return 0;
    }

    @HLEFunction(nid=-868663736, version=150, checkInsideInterrupt=true)
    public int sceNetGetMallocStat(TPointer32 statAddr) {
        int freeSize = this.netMemSize / 2;
        statAddr.setValue(0, this.netMemSize);
        statAddr.setValue(4, this.netMemSize - freeSize);
        statAddr.setValue(8, freeSize);
        return 0;
    }

    @HLEFunction(nid=-663606909, version=150)
    public int sceNetStrlen(@CanBeNull TPointer srcAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetStrlen '%s'", srcAddr.getStringZ()));
        }
        return Modules.SysclibForKernelModule.strlen(srcAddr);
    }

    @HLEFunction(nid=-2134249430, version=150)
    public int sceNetStrcpy(@CanBeNull TPointer destAddr, @CanBeNull TPointer srcAddr) {
        return Modules.SysclibForKernelModule.strcpy(destAddr, srcAddr);
    }

    @HLEFunction(nid=-1594791235, version=150)
    public int sceNetStrcmp(@CanBeNull TPointer src1Addr, @CanBeNull TPointer src2Addr) {
        return Modules.SysclibForKernelModule.strcmp(src1Addr, src2Addr);
    }

    @HLEFunction(nid=-1797477904, version=150)
    public int sceNetStrncmp(@CanBeNull TPointer src1Addr, @CanBeNull TPointer src2Addr, int size) {
        return Modules.SysclibForKernelModule.strncmp(src1Addr, src2Addr, size);
    }

    @HLEFunction(nid=-1244776310, version=150)
    public int sceNetStrncpy(@CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextNextParameter, usage=BufferInfo.Usage.out) TPointer destAddr, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer srcAddr, int size) {
        return Modules.SysclibForKernelModule.strncpy(destAddr, srcAddr, size);
    }

    @HLEFunction(nid=-1128393521, version=150)
    public int sceNetStrchr(@CanBeNull TPointer srcAddr, int c1) {
        if (srcAddr.isNull()) {
            return 0;
        }
        c1 &= 0xFF;
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(srcAddr.getAddress(), 1);
        int i = 0;
        while (true) {
            int c2;
            if (c1 == (c2 = memoryReader.readNext())) {
                return srcAddr.getAddress() + i;
            }
            if (c2 == 0) break;
            ++i;
        }
        return 0;
    }

    @HLEFunction(nid=1963946077, version=150)
    public int sceNetLook_ctype_table(int c) {
        int ctype = look_ctype_table[c & 0xFF];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetLook_ctype_table c='%c' = 0x%02X", Character.valueOf((char)c), ctype));
        }
        return ctype;
    }

    @HLEFunction(nid=1460008697, version=150)
    public int sceNetStrcat(@CanBeNull TPointer destAddr, @CanBeNull TPointer srcAddr) {
        return Modules.SysclibForKernelModule.strcat(destAddr, srcAddr);
    }

    @HLEFunction(nid=-1661220893, version=150)
    public int sceNetStrcasecmp(@CanBeNull PspString src1Addr, @CanBeNull PspString src2Addr) {
        if (src1Addr.isNull() || src2Addr.isNull()) {
            if (src1Addr.getAddress() == src2Addr.getAddress()) {
                return 0;
            }
            if (src1Addr.isNotNull()) {
                return 1;
            }
            return -1;
        }
        return src1Addr.getString().compareToIgnoreCase(src2Addr.getString());
    }

    @HLEFunction(nid=-1762681439, version=150)
    public int sceNetTolower(int c) {
        int ctype = look_ctype_table[c & 0xFF];
        if ((ctype & 1) != 0) {
            c += 32;
        }
        return c;
    }

    @HLEFunction(nid=-1052994809, version=150)
    public int sceNetToupper(int c) {
        int ctype = look_ctype_table[c & 0xFF];
        if ((ctype & 2) != 0) {
            c -= 32;
        }
        return c;
    }

    @HLEFunction(nid=-814719418, version=150)
    public int sceNetSprintf(CpuState cpu, TPointer buffer, String format) {
        return Modules.SysclibForKernelModule.sprintf(cpu, buffer, format);
    }

    @HLEFunction(nid=-1190634858, version=150)
    public int sceNetStrncasecmp(@CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextNextParameter, usage=BufferInfo.Usage.in) TPointer src1Addr, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer src2Addr, int size) {
        if (src1Addr.isNull() || src2Addr.isNull()) {
            if (src1Addr.getAddress() == src2Addr.getAddress()) {
                return 0;
            }
            if (src1Addr.isNotNull()) {
                return 1;
            }
            return -1;
        }
        String s1 = src1Addr.getStringNZ(size);
        String s2 = src2Addr.getStringNZ(size);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetStrncasecmp s1='%s', s2='%s'", s1, s2));
        }
        return s1.compareToIgnoreCase(s2);
    }

    @HLEFunction(nid=531824093, version=150)
    public long sceNetAtoi(@CanBeNull PspString string) {
        return Integer.parseInt(string.getString());
    }

    @HLEUnimplemented
    @HLEFunction(nid=712224220, version=150)
    public long sceNetStrtoul(@CanBeNull PspString string, @CanBeNull TPointer32 endString, int base) {
        return Modules.SysclibForKernelModule.strtoul(string, endString, base);
    }

    @HLEFunction(nid=-525853572, version=150)
    public int sceNetMemcmp(@CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextNextParameter, usage=BufferInfo.Usage.in) TPointer src1Addr, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer src2Addr, int size) {
        return Modules.SysclibForKernelModule.memcmp(src1Addr, src2Addr, size);
    }

    @HLEFunction(nid=-192322618, version=150)
    public int sceNetStrrchr(@CanBeNull TPointer srcAddr, int c1) {
        if (srcAddr.isNull()) {
            return 0;
        }
        c1 &= 0xFF;
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(srcAddr.getAddress(), 1);
        int lastOccurence = -1;
        int i = 0;
        while (true) {
            int c2;
            if (c1 == (c2 = memoryReader.readNext())) {
                lastOccurence = i;
            } else if (c2 == 0) break;
            ++i;
        }
        if (lastOccurence < 0) {
            return 0;
        }
        return srcAddr.getAddress() + lastOccurence;
    }

    @HLEUnimplemented
    @HLEFunction(nid=944700948, version=150)
    public int sceNet_lib_384EFE14(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer in1Addr, int in1Size, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer in2Addr, int in2Size, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=20, usage=BufferInfo.Usage.out) TPointer outAddr) {
        MessageDigest md;
        if (in2Size > 64) {
            log.warn((Object)String.format("sceNet_lib_384EFE14 not implemented for size=0x%X", in2Size));
        }
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"sceNet_lib_384EFE14", (Throwable)e);
            return -1;
        }
        byte[] in1 = in1Addr.getArray8(in1Size);
        byte[] in2 = in2Addr.getArray8(in2Size);
        byte[] tmp1 = new byte[64];
        byte[] tmp2 = new byte[64];
        System.arraycopy(in2, 0, tmp1, 0, Math.min(in2Size, tmp1.length));
        System.arraycopy(in2, 0, tmp2, 0, Math.min(in2Size, tmp2.length));
        for (int i = 0; i < tmp1.length; ++i) {
            tmp1[i] = (byte)(tmp1[i] ^ 0x36);
            tmp2[i] = (byte)(tmp2[i] ^ 0x5C);
        }
        md.update(tmp1);
        md.update(in1);
        byte[] tmp3 = md.digest();
        md.reset();
        md.update(tmp2);
        md.update(tmp3);
        byte[] result = md.digest();
        outAddr.setArray(result, 20);
        return 0;
    }

    @HLEFunction(nid=1196677240, version=150)
    public int sceNetMemmove(@CanBeNull TPointer dstAddr, TPointer srcAddr, int size) {
        return Modules.SysclibForKernelModule.memmove(dstAddr, srcAddr, size);
    }

    @HLEFunction(nid=-2037926485, version=150)
    public int sceNetVsprintf(CpuState cpu, TPointer buffer, String format, TPointer32 parameters) {
        Object[] formatParameters = new Object[10];
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(parameters.getAddress(), 4 * formatParameters.length, 4);
        for (int i = 0; i < formatParameters.length; ++i) {
            formatParameters[i] = memoryReader.readNext();
        }
        String formattedString = Modules.SysMemUserForUserModule.hleKernelSprintf(cpu, format, formatParameters);
        Utilities.writeStringZ(buffer.getMemory(), buffer.getAddress(), formattedString);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetVsprintf returning '%s'", formattedString));
        }
        return formattedString.length();
    }

    @HLEFunction(nid=408455229, version=150)
    public int sceNetRand() {
        return this.random.nextInt();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1455778839, version=150)
    public int _sce_pspnet_callout_stop(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=36, usage=BufferInfo.Usage.inout) TPointer unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1464459174, version=150)
    public int sceNet_lib_A8B6205A(TPointer unknown1, int unknown2, TPointer unknown3, int unknown4) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1800122586, version=150)
    public int _sce_pspnet_spllock() {
        return 1;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1364930355, version=150)
    public int _sce_pspnet_splunlock(int resultFromLock) {
        if (resultFromLock <= 0) {
            return resultFromLock;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=771772466, version=150)
    public int sceNet_lib_2E005032(int unknownCallback) {
        this.adhocSocketAlertCallback = unknownCallback;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1281062017, version=150)
    public int sceNet_lib_B3A48B7F(int readCallback, int unknownCallback1) {
        this.readCallback = readCallback;
        this.unknownCallback1 = unknownCallback1;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=529838041, version=150)
    public int sceNet_lib_1F94AFD9(int unknownCallback) {
        this.getReadContextCallback = unknownCallback;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1377225717, version=150)
    public int sceNetConfigUpInterface(PspString interfaceName) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-767414707, version=150)
    public int sceNetConfigDownInterface(PspString interfaceName) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1417815643, version=150)
    public int sceNetConfigSetIfEventFlag(PspString interfaceName, int eventFlagUid, int bitsToSet) {
        if (eventFlagUid == 0) {
            return 0;
        }
        return Modules.ThreadManForUserModule.sceKernelSetEventFlag(eventFlagUid, bitsToSet);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-637340797, version=150)
    public int sceNet_lib_DA02F383(PspString interfaceName, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 unknown) {
        unknown.setValue(0);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-709472713, version=150)
    public int sceNet_lib_D5B64E37(PspString interfaceName, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer ssid, int ssidLength, int adhocChannel) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=97854948, version=150)
    public int sceNet_lib_05D525E4() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=173705041, version=150)
    public int sceNet_lib_0A5A8751() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=634140474, version=150)
    public int _sce_pspnet_callout_init() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=867315901, version=150)
    public int sceNet_lib_33B230BD() {
        this.adhocSocketAlertCallback = 0;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1797869284, version=150)
    public int sceNet_lib_6B294EE4(int unknown1, int unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1970308528, version=150)
    public int sceNet_lib_757085B0(TPointer unknown1, int unkown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1970601377, version=150)
    public int _sce_pspnet_wakeup(TPointer32 receivedMessage) {
        if (this.blockedThreads.containsKey(receivedMessage.getAddress())) {
            int threadUid = this.blockedThreads.get(receivedMessage.getAddress());
            Modules.ThreadManForUserModule.hleUnblockThread(threadUid);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1801510981, version=150)
    public int sceNet_lib_949F1FBB() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-901974549, version=150)
    public int _sce_pspnet_thread_enter(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 errorAddr) {
        int currentThreadId = Modules.ThreadManForUserModule.getCurrentThreadID();
        if (!this.allocatedThreadStructures.containsKey(currentThreadId)) {
            int size = 92;
            int allocateMem = Modules.sceNetIfhandleModule.hleNetMallocInternal(size);
            if (allocateMem < 0) {
                errorAddr.setValue(allocateMem);
                return 0;
            }
            RuntimeContext.debugMemory(allocateMem, size);
            Memory.getInstance().memset(allocateMem, (byte)0, size);
            this.allocatedThreadStructures.put(currentThreadId, allocateMem);
        }
        errorAddr.setValue(0);
        return this.allocatedThreadStructures.get(currentThreadId);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-704502365, version=150)
    public int sceNet_lib_D60225A3(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=6, usage=BufferInfo.Usage.in) TPointer macAddr) {
        pspNetMacAddress macAddress = new pspNetMacAddress();
        macAddress.read(macAddr);
        return 287454020;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-153417205, version=150)
    public int sceNet_lib_F6DB0A0B(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 receivedMessage, int timeout) {
        SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
        thread.wait.Semaphore_id = -1;
        Modules.ThreadManForUserModule.hleBlockCurrentThread(3);
        this.blockedThreads.put(receivedMessage.getAddress(), thread.uid);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=51792658, version=150)
    public int sceNet_lib_03164B12() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=224608083, version=150)
    public int sceNet_lib_0D633F53() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=949430443, version=150)
    public int sceNet_lib_389728AB() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2074340753, version=150)
    public int sceNet_lib_7BA3ED91() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1520660145, version=150)
    public int sceNet_lib_A55C914F() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1348398280, version=150)
    public int sceNet_lib_AFA11338() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1307605768, version=150)
    public int sceNet_lib_B20F84F8() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-776065815, version=150)
    public int sceNetConfigGetIfEvent(PspString interfaceName, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 eventAddr, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 unknown) {
        return -2143223420;
    }

    @HLEFunction(nid=791695988, version=150)
    public int sceNetBcopy(@CanBeNull TPointer srcAddr, TPointer dstAddr, int size) {
        return this.sceNetMemmove(dstAddr, srcAddr, size);
    }

    private class AfterReadContextCallback
    implements IAction {
        private AfterReadContextCallback() {
        }

        @Override
        public void execute() {
            sceNet.this.hleAfterReadContextCallback();
        }
    }
}

