/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.HLE.modules.sceNetAdhocctl;
import jpcsp.HLE.modules.sceUtility;
import jpcsp.Processor;
import jpcsp.hardware.Wlan;
import jpcsp.settings.Settings;
import org.apache.log4j.Logger;

public class sceNetApctl
extends HLEModule {
    public static Logger log = Modules.getLogger("sceNetApctl");
    public static final int PSP_NET_APCTL_STATE_DISCONNECTED = 0;
    public static final int PSP_NET_APCTL_STATE_SCANNING = 1;
    public static final int PSP_NET_APCTL_STATE_JOINING = 2;
    public static final int PSP_NET_APCTL_STATE_GETTING_IP = 3;
    public static final int PSP_NET_APCTL_STATE_GOT_IP = 4;
    public static final int PSP_NET_APCTL_STATE_EAP_AUTH = 5;
    public static final int PSP_NET_APCTL_STATE_KEY_EXCHANGE = 6;
    public static final int PSP_NET_APCTL_EVENT_CONNECT_REQUEST = 0;
    public static final int PSP_NET_APCTL_EVENT_SCAN_REQUEST = 1;
    public static final int PSP_NET_APCTL_EVENT_SCAN_COMPLETE = 2;
    public static final int PSP_NET_APCTL_EVENT_ESTABLISHED = 3;
    public static final int PSP_NET_APCTL_EVENT_GET_IP = 4;
    public static final int PSP_NET_APCTL_EVENT_DISCONNECT_REQUEST = 5;
    public static final int PSP_NET_APCTL_EVENT_ERROR = 6;
    public static final int PSP_NET_APCTL_EVENT_INFO = 7;
    public static final int PSP_NET_APCTL_EVENT_EAP_AUTH = 8;
    public static final int PSP_NET_APCTL_EVENT_KEY_EXCHANGE = 9;
    public static final int PSP_NET_APCTL_EVENT_RECONNECT = 10;
    public static final int PSP_NET_APCTL_INFO_PROFILE_NAME = 0;
    public static final int PSP_NET_APCTL_INFO_BSSID = 1;
    public static final int PSP_NET_APCTL_INFO_SSID = 2;
    public static final int PSP_NET_APCTL_INFO_SSID_LENGTH = 3;
    public static final int PSP_NET_APCTL_INFO_SECURITY_TYPE = 4;
    public static final int PSP_NET_APCTL_INFO_STRENGTH = 5;
    public static final int PSP_NET_APCTL_INFO_CHANNEL = 6;
    public static final int PSP_NET_APCTL_INFO_POWER_SAVE = 7;
    public static final int PSP_NET_APCTL_INFO_IP = 8;
    public static final int PSP_NET_APCTL_INFO_SUBNETMASK = 9;
    public static final int PSP_NET_APCTL_INFO_GATEWAY = 10;
    public static final int PSP_NET_APCTL_INFO_PRIMDNS = 11;
    public static final int PSP_NET_APCTL_INFO_SECDNS = 12;
    public static final int PSP_NET_APCTL_INFO_USE_PROXY = 13;
    public static final int PSP_NET_APCTL_INFO_PROXY_URL = 14;
    public static final int PSP_NET_APCTL_INFO_PROXY_PORT = 15;
    public static final int PSP_NET_APCTL_INFO_8021_EAP_TYPE = 16;
    public static final int PSP_NET_APCTL_INFO_START_BROWSER = 17;
    public static final int PSP_NET_APCTL_INFO_WIFISP = 18;
    public static final int PSP_NET_APCTL_INFO_UNKNOWN19 = 19;
    private static final String[] apctlInfoNames = new String[]{"PROFILE_NAME", "BSSID", "SSID", "SSID_LENGTH", "SECURITY_TYPE", "STRENGTH", "CHANNEL", "POWER_SAVE", "IP", "SUBNETMASK", "GATEWAY", "PRIMDNS", "SECDNS", "USE_PROXY", "PROXY_URL", "PROXY_PORT", "8021_EAP_TYPE", "START_BROWSER", "WIFISP"};
    public static final int PSP_NET_APCTL_INFO_SECURITY_TYPE_NONE = 0;
    public static final int PSP_NET_APCTL_INFO_SECURITY_TYPE_WEP = 1;
    public static final int PSP_NET_APCTL_INFO_SECURITY_TYPE_WPA_TKIP = 2;
    public static final int PSP_NET_APCTL_INFO_SECURITY_TYPE_UNSUPPORTED = 3;
    public static final int PSP_NET_APCTL_INFO_SECURITY_TYPE_WPA_AES = 4;
    public static final int PSP_NET_APCTL_DESC_IBSS = 0;
    public static final int PSP_NET_APCTL_DESC_SSID_NAME = 1;
    public static final int PSP_NET_APCTL_DESC_SSID_NAME_LENGTH = 2;
    public static final int PSP_NET_APCTL_DESC_SIGNAL_STRENGTH = 4;
    public static final int PSP_NET_APCTL_DESC_SECURITY = 5;
    public static final int SSID_NAME_LENGTH = 32;
    private static final String dummyPrimaryDNS = "1.2.3.4";
    private static final String dummySecondaryDNS = "1.2.3.5";
    private static final String dummySubnetMask = "255.255.255.0";
    private static final int dummySubnetMaskInt = -256;
    protected static final String uidPurpose = "sceNetApctl";
    protected static final String uidHandlerPurpose = "sceNetApctlHandler";
    protected int state = 0;
    protected int connectionIndex = 0;
    private static String localHostIP;
    private HashMap<Integer, ApctlHandler> apctlHandlers = new HashMap();
    protected static final int stateTransitionDelay = 100000;
    protected SceKernelThreadInfo sceNetApctlThread;
    protected boolean sceNetApctlThreadTerminate;
    private boolean doScan;
    private volatile long scanStartMillis;
    private static final int SCAN_DURATION_MILLIS = 700;

    @Override
    public void stop() {
        this.sceNetApctlThread = null;
        this.sceNetApctlThreadTerminate = false;
        this.doScan = false;
        this.apctlHandlers.clear();
        super.stop();
    }

    protected void notifyHandler(int oldState, int newState, int event, int error) {
        for (ApctlHandler handler : this.apctlHandlers.values()) {
            handler.triggerHandler(oldState, newState, event, error);
        }
    }

    protected void changeState(int newState) {
        int event;
        int oldState = this.state;
        int error = 0;
        if (newState == oldState) {
            return;
        }
        switch (newState) {
            case 2: {
                event = 0;
                break;
            }
            case 3: {
                event = 3;
                break;
            }
            case 4: {
                event = 4;
                break;
            }
            case 0: {
                if (oldState == 1) {
                    event = 2;
                    break;
                }
                event = 5;
                break;
            }
            case 1: {
                event = 1;
                break;
            }
            default: {
                event = 0;
            }
        }
        this.state = newState;
        this.notifyHandler(oldState, newState, event, error);
        if (newState == 2) {
            this.triggerNetApctlThread();
        }
    }

    protected static String getApctlInfoName(int code) {
        if (code < 0 || code >= apctlInfoNames.length) {
            return String.format("Unknown Info %d", code);
        }
        return apctlInfoNames[code];
    }

    public static String getSSID() {
        String ssid = null;
        try {
            ssid = NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getDisplayName();
        }
        catch (SocketException e) {
            log.error((Object)e);
        }
        catch (UnknownHostException e) {
            log.error((Object)e);
        }
        return ssid;
    }

    public static String getPrimaryDNS() {
        int lastDot;
        String ip = sceNetApctl.getLocalHostIP();
        if (ip != null && (lastDot = ip.lastIndexOf(".")) >= 0) {
            String primaryDNS = ip.substring(0, lastDot) + ".1";
            return primaryDNS;
        }
        return dummyPrimaryDNS;
    }

    public static String getSecondaryDNS() {
        return dummySecondaryDNS;
    }

    public static String getGateway() {
        String gateway = sceNetApctl.getLocalHostIP();
        int lastDot = gateway.lastIndexOf(46);
        if (lastDot >= 0) {
            gateway = gateway.substring(0, lastDot + 1) + "1";
        }
        return gateway;
    }

    public static String getSubnetMask() {
        return dummySubnetMask;
    }

    public static int getSubnetMaskInt() {
        return -256;
    }

    public static String getLocalHostIP() {
        if (localHostIP == null) {
            localHostIP = "192.168.1.1";
            try {
                localHostIP = InetAddress.getLocalHost().getHostAddress();
                InetAddress localHostAddress = InetAddress.getLocalHost();
                InetAddress[] allLocalIPs = InetAddress.getAllByName(localHostAddress.getHostName());
                for (int i = 0; allLocalIPs != null && i < allLocalIPs.length; ++i) {
                    byte[] bytes;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("IP address of local host: %s", allLocalIPs[i].getHostAddress()));
                    }
                    if ((bytes = allLocalIPs[i].getAddress()) == null || bytes.length != 4 || bytes[3] == 1) continue;
                    localHostIP = allLocalIPs[i].getHostAddress();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Using IP address of local host: %s, Subnet Mask %s", localHostIP, sceNetApctl.getSubnetMask()));
                }
            }
            catch (UnknownHostException e) {
                log.error((Object)e);
            }
        }
        return localHostIP;
    }

    public void hleNetApctlConnect(int index) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleNetApctlConnect index=%d", index));
        }
        this.connectionIndex = index;
        this.changeState(2);
    }

    public int hleNetApctlGetState() {
        return this.state;
    }

    protected void triggerNetApctlThread() {
        if (this.sceNetApctlThread != null) {
            Modules.ThreadManForUserModule.hleKernelWakeupThread(this.sceNetApctlThread);
        }
    }

    public void hleNetApctlThread(Processor processor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleNetApctlThread state=%d", this.state));
        }
        if (this.sceNetApctlThreadTerminate) {
            processor.cpu._v0 = 0;
            Modules.ThreadManForUserModule.hleKernelExitDeleteThread();
            this.sceNetApctlThread = null;
        } else {
            boolean stateTransitionCompleted = true;
            switch (this.state) {
                case 2: {
                    this.changeState(3);
                    stateTransitionCompleted = false;
                    break;
                }
                case 3: {
                    this.changeState(4);
                    break;
                }
                case 0: {
                    if (!this.doScan) break;
                    this.scanStartMillis = Emulator.getClock().milliTime();
                    this.changeState(1);
                    this.doScan = false;
                    stateTransitionCompleted = false;
                    break;
                }
                case 1: {
                    long now = Emulator.getClock().milliTime();
                    if (now - this.scanStartMillis > 700L) {
                        this.changeState(0);
                        break;
                    }
                    stateTransitionCompleted = false;
                }
            }
            if (stateTransitionCompleted) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleNetApctlThread sleeping with state=%d", this.state));
                }
                Modules.ThreadManForUserModule.hleKernelSleepThread(false);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleNetApctlThread waiting for %d us with state=%d", 100000, this.state));
                }
                Modules.ThreadManForUserModule.hleKernelDelayThread(100000, false);
            }
        }
    }

    @HLEFunction(nid=-486989925, version=150)
    public int sceNetApctlInit(int stackSize, int initPriority) {
        if (this.sceNetApctlThread == null) {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            this.sceNetApctlThread = threadMan.hleKernelCreateThread("SceNetApctl", 0x8000040, initPriority, stackSize, threadMan.getCurrentThread().attr, 0, 2);
            this.sceNetApctlThreadTerminate = false;
            threadMan.hleKernelStartThread(this.sceNetApctlThread, 0, TPointer.NULL, this.sceNetApctlThread.gpReg_addr);
        }
        return 0;
    }

    @HLEFunction(nid=-1276260116, version=150)
    public int sceNetApctlTerm() {
        this.changeState(0);
        this.sceNetApctlThreadTerminate = true;
        this.triggerNetApctlThread();
        return 0;
    }

    @HLEFunction(nid=737140515, version=150)
    public int sceNetApctlGetInfo(int code, TPointer pInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetApctlGetInfo code=0x%X(%s)", code, sceNetApctl.getApctlInfoName(code)));
        }
        switch (code) {
            case 0: {
                String name = sceUtility.getNetParamName(this.connectionIndex);
                pInfo.setStringNZ(128, name);
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("sceNetApctlGetInfo returning Profile name '%s'", name));
                break;
            }
            case 8: {
                String ip = sceNetApctl.getLocalHostIP();
                pInfo.setStringNZ(16, ip);
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("sceNetApctlGetInfo returning IP address '%s'", ip));
                break;
            }
            case 2: {
                String ssid = sceNetApctl.getSSID();
                if (ssid == null) {
                    return -1;
                }
                pInfo.setStringNZ(32, ssid);
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("sceNetApctlGetInfo returning SSID '%s'", ssid));
                break;
            }
            case 3: {
                String ssid = sceNetApctl.getSSID();
                if (ssid == null) {
                    return -1;
                }
                pInfo.setValue32(Math.min(ssid.length(), 32));
                break;
            }
            case 11: {
                pInfo.setStringNZ(16, sceNetApctl.getPrimaryDNS());
                break;
            }
            case 12: {
                pInfo.setStringNZ(16, sceNetApctl.getSecondaryDNS());
                break;
            }
            case 10: {
                pInfo.setStringNZ(16, sceNetApctl.getGateway());
                break;
            }
            case 9: {
                pInfo.setStringNZ(16, sceNetApctl.getSubnetMask());
                break;
            }
            case 6: {
                int channel = Settings.getInstance().readInt("emu.sysparam.adhocchannel", 0);
                pInfo.setValue8((byte)channel);
                break;
            }
            case 5: {
                pInfo.setValue8((byte)Wlan.getSignalStrenth());
                break;
            }
            case 13: {
                pInfo.setValue32(false);
                break;
            }
            case 17: {
                pInfo.setValue32(false);
                break;
            }
            case 19: {
                pInfo.setValue32(1);
                break;
            }
            default: {
                log.warn((Object)String.format("sceNetApctlGetInfo unimplemented code=0x%X(%s)", code, sceNetApctl.getApctlInfoName(code)));
                return -1;
            }
        }
        return 0;
    }

    @HLEFunction(nid=-1967465135, version=150)
    public int sceNetApctlAddHandler(TPointer handler, int handlerArg) {
        int uid = SceUidManager.getNewUid(uidPurpose);
        ApctlHandler apctlHandler = new ApctlHandler(uid, handler.getAddress(), handlerArg);
        this.apctlHandlers.put(uid, apctlHandler);
        return uid;
    }

    @HLEFunction(nid=1499699483, version=150)
    public int sceNetApctlDelHandler(int handlerId) {
        if (!this.apctlHandlers.containsKey(handlerId)) {
            log.warn((Object)String.format("sceNetApctlDelHandler unknown handlerId=0x%X", handlerId));
            return -1;
        }
        SceUidManager.releaseUid(handlerId, uidPurpose);
        this.apctlHandlers.remove(handlerId);
        return 0;
    }

    @HLEFunction(nid=-809936954, version=150)
    public int sceNetApctlConnect(int connIndex) {
        this.hleNetApctlConnect(connIndex);
        return 0;
    }

    @HLEFunction(nid=620663201, version=150)
    public int sceNetApctlDisconnect() {
        this.changeState(0);
        return 0;
    }

    @HLEFunction(nid=1575667739, version=150)
    public int sceNetApctlGetState(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 stateAddr) {
        stateAddr.setValue(this.state);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=691389531, version=150)
    public int sceNetApctlGetBSSDescEntry2() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1545109997, version=150)
    public int sceNetApctlScanSSID2() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-228962298, version=150)
    public int sceNetApctlGetBSSDescIDList2() {
        return 0;
    }

    @HLEFunction(nid=-374151706, version=150)
    public int sceNetApctlScanUser() {
        this.doScan = true;
        this.triggerNetApctlThread();
        return 0;
    }

    @HLEFunction(nid=1809697676, version=150)
    public int sceNetApctlGetBSSDescIDListUser(TPointer32 sizeAddr, @CanBeNull TPointer buf) {
        int userInfoSize = 8;
        int entries = 1;
        int size = sizeAddr.getValue();
        sizeAddr.setValue(entries * 8);
        if (buf.isNotNull()) {
            int offset = 0;
            for (int i = 0; i < entries && offset + 8 <= size; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetApctlGetBSSDescIDListUser returning %d at 0x%08X", i, buf.getAddress() + offset));
                }
                buf.setValue32(offset += 4, i);
                offset += 4;
            }
            sceNetAdhocctl.fillNextPointersInLinkedList(buf, offset, 8);
        }
        return 0;
    }

    @HLEFunction(nid=74934676, version=150)
    public int sceNetApctlGetBSSDescEntryUser(int entryId, int infoId, TPointer result) {
        switch (infoId) {
            case 0: {
                String ibss = Modules.sceNetAdhocctlModule.hleNetAdhocctlGetIBSS();
                result.setStringNZ(6, ibss);
                break;
            }
            case 1: {
                String ssid = sceNetApctl.getSSID();
                result.setStringNZ(32, ssid);
                break;
            }
            case 2: {
                int length = Math.min(sceNetApctl.getSSID().length(), 32);
                result.setValue32(length);
                break;
            }
            case 4: {
                result.setValue8((byte)Wlan.getSignalStrenth());
                break;
            }
            case 5: {
                result.setValue32(4);
                break;
            }
            default: {
                log.warn((Object)String.format("sceNetApctlGetBSSDescEntryUser unknown id %d", infoId));
                return -1;
            }
        }
        return 0;
    }

    @HLEFunction(nid=2096806288, version=150)
    public int sceNetApctlAddInternalHandler(TPointer handler, int handlerArg) {
        return this.sceNetApctlAddHandler(handler, handlerArg);
    }

    @HLEFunction(nid=-518279253, version=150)
    public int sceNetApctlDelInternalHandler(int handlerId) {
        return this.sceNetApctlDelHandler(handlerId);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1480887329, version=150)
    public int sceNetApctl_A7BB73DF(TPointer handler, int handlerArg) {
        return this.sceNetApctlAddHandler(handler, handlerArg);
    }

    @HLEUnimplemented
    @HLEFunction(nid=1868376449, version=150)
    public int sceNetApctl_6F5D2981(int handlerId) {
        return this.sceNetApctlDelHandler(handlerId);
    }

    @HLEUnimplemented
    @HLEFunction(nid=1769234186, version=150)
    public int sceNetApctl_lib2_69745F0A(int handlerId) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1276736287, version=150)
    public int sceNetApctl_lib2_4C19731F(int code, TPointer pInfo) {
        return this.sceNetApctlGetInfo(code, pInfo);
    }

    @HLEFunction(nid=-1278252983, version=150)
    public int sceNetApctlScan() {
        return this.sceNetApctlScanUser();
    }

    @HLEFunction(nid=209713756, version=150)
    public int sceNetApctlGetBSSDescIDList(TPointer32 sizeAddr, @CanBeNull TPointer buf) {
        return this.sceNetApctlGetBSSDescIDListUser(sizeAddr, buf);
    }

    @HLEFunction(nid=-1765887439, version=150)
    public int sceNetApctlGetBSSDescEntry(int entryId, int infoId, TPointer result) {
        return this.sceNetApctlGetBSSDescEntryUser(entryId, infoId, result);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1039526836, version=150)
    public int sceNetApctl_lib2_C20A144C(int connIndex, pspNetMacAddress ps3MacAddress) {
        return this.sceNetApctlConnect(connIndex);
    }

    protected class ApctlHandler {
        private int id;
        private int addr;
        private int pArg;

        private ApctlHandler(int id, int addr, int pArg) {
            this.id = id;
            this.addr = addr;
            this.pArg = pArg;
        }

        protected void triggerHandler(int oldState, int newState, int event, int error) {
            SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
            if (thread != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Triggering hanlder 0x%08X, oldState=%d, newState=%d, event=%d, error=0x%08X", this.addr, oldState, newState, event, error));
                }
                Modules.ThreadManForUserModule.executeCallback(thread, this.addr, null, true, oldState, newState, event, error, this.pArg);
            }
        }

        public String toString() {
            return String.format("ApctlHandler[id=%d, addr=0x%08X, pArg=0x%08X]", this.id, this.addr, this.pArg);
        }
    }
}

