/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.SceKernelCallbackInfo;
import jpcsp.HLE.kernel.types.SceNpAuthRequestParameter;
import jpcsp.HLE.kernel.types.SceNpTicket;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceNpAuth
extends HLEModule {
    public static Logger log = Modules.getLogger("sceNpAuth");
    public static boolean useDummyTicket = false;
    public static final int STATUS_ACCOUNT_SUSPENDED = 128;
    public static final int STATUS_ACCOUNT_CHAT_RESTRICTED = 256;
    public static final int STATUS_ACCOUNT_PARENTAL_CONTROL_ENABLED = 512;
    private boolean initialized;
    private int npMemSize;
    private int npMaxMemSize;
    private int npFreeMemSize;
    private SceKernelCallbackInfo npAuthCreateTicketCallback;
    private String serviceId;
    private byte[] ticketBytes = new byte[10000];
    private int ticketBytesLength;

    @Override
    public void start() {
        this.initialized = false;
        super.start();
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new SceKernelErrorException(-2141912318);
        }
    }

    public static void addTicketParam(SceNpTicket ticket, int type, String value, int length) {
        byte[] stringBytes = value.getBytes(Charset.forName("ASCII"));
        byte[] bytes = new byte[length];
        System.arraycopy(stringBytes, 0, bytes, 0, Math.min(length, stringBytes.length));
        ticket.parameters.add(new SceNpTicket.TicketParam(type, bytes));
    }

    public static void addTicketParam(SceNpTicket ticket, String value, int length) {
        sceNpAuth.addTicketParam(ticket, 8, value, length);
    }

    public static void addTicketParam(SceNpTicket ticket, int value) {
        byte[] bytes = new byte[4];
        Utilities.writeUnaligned32(bytes, 0, Utilities.endianSwap32(value));
        ticket.parameters.add(new SceNpTicket.TicketParam(1, bytes));
    }

    public static void addTicketDateParam(SceNpTicket ticket, long time) {
        byte[] bytes = new byte[8];
        Utilities.writeUnaligned32(bytes, 0, Utilities.endianSwap32((int)(time >> 32)));
        Utilities.writeUnaligned32(bytes, 4, Utilities.endianSwap32((int)time));
        ticket.parameters.add(new SceNpTicket.TicketParam(7, bytes));
    }

    public static void addTicketLongParam(SceNpTicket ticket, long value) {
        byte[] bytes = new byte[8];
        Utilities.writeUnaligned32(bytes, 0, Utilities.endianSwap32((int)(value >> 32)));
        Utilities.writeUnaligned32(bytes, 4, Utilities.endianSwap32((int)value));
        ticket.parameters.add(new SceNpTicket.TicketParam(2, bytes));
    }

    public static void addTicketParam(SceNpTicket ticket) {
        ticket.parameters.add(new SceNpTicket.TicketParam(0, new byte[0]));
    }

    private static String encodeURLParam(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    private static void addURLParam(StringBuilder params, String name, String value) {
        if (params.length() > 0) {
            params.append("&");
        }
        params.append(name);
        params.append("=");
        params.append(sceNpAuth.encodeURLParam(value));
    }

    private static void addURLParam(StringBuilder params, String name, int addr, int length) {
        StringBuilder value = new StringBuilder();
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(addr, length, 1);
        for (int i = 0; i < length; ++i) {
            int c = memoryReader.readNext();
            value.append((char)c);
        }
        sceNpAuth.addURLParam(params, name, value.toString());
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1579251976, version=150, checkInsideInterrupt=true)
    public int sceNpAuthInit(int poolSize, int stackSize, int threadPriority) {
        this.npMemSize = poolSize;
        this.npMaxMemSize = poolSize / 2;
        this.npFreeMemSize = poolSize - 16;
        this.initialized = true;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1321334375, version=150, checkInsideInterrupt=true)
    public int sceNpAuthTerm() {
        this.initialized = false;
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-195880228, version=150, checkInsideInterrupt=true)
    public int sceNpAuthGetMemoryStat(TPointer32 memStatAddr) {
        this.checkInitialized();
        memStatAddr.setValue(0, this.npMemSize);
        memStatAddr.setValue(4, this.npMaxMemSize);
        memStatAddr.setValue(8, this.npFreeMemSize);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HLEUnimplemented
    @HLEFunction(nid=-846813610, version=150)
    public int sceNpAuthCreateStartRequest(TPointer paramAddr) {
        String password;
        String loginId;
        SceNpAuthRequestParameter param = new SceNpAuthRequestParameter();
        param.read(paramAddr);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("sceNpAuthCreateStartRequest param: %s", param));
        }
        this.serviceId = param.serviceId;
        if (!useDummyTicket && (loginId = JOptionPane.showInputDialog("Enter your PSN Sign-In ID (Email Address)")) != null && (password = JOptionPane.showInputDialog("Enter your PSN Password")) != null) {
            StringBuilder params = new StringBuilder();
            sceNpAuth.addURLParam(params, "serviceid", this.serviceId);
            sceNpAuth.addURLParam(params, "loginid", loginId);
            sceNpAuth.addURLParam(params, "password", password);
            if (param.cookie != 0) {
                sceNpAuth.addURLParam(params, "cookie", param.cookie, param.cookieSize);
            }
            if (param.entitlementIdAddr != 0) {
                sceNpAuth.addURLParam(params, "entitlementid", param.entitlementId);
                sceNpAuth.addURLParam(params, "consumedcount", Integer.toString(param.consumedCount));
            }
            HttpURLConnection connection = null;
            this.ticketBytesLength = 0;
            try {
                connection = (HttpURLConnection)new URL("https://auth.np.ac.playstation.net/nav/auth").openConnection();
                connection.setRequestProperty("X-I-5-Version", "2.1");
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("X-Platform-Version", "PSP 06.60");
                connection.setRequestProperty("Content-Length", Integer.toString(params.length()));
                connection.setRequestProperty("User-Agent", "Lediatio Lunto Ritna");
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                OutputStream os = connection.getOutputStream();
                os.write(params.toString().getBytes());
                os.close();
                connection.connect();
                int responseCode = connection.getResponseCode();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Response code: %d", responseCode));
                    for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
                        log.debug((Object)String.format("%s: %s", entry.getKey(), entry.getValue()));
                    }
                }
                if (responseCode == 200) {
                    int length;
                    InputStream in = connection.getInputStream();
                    while ((length = in.read(this.ticketBytes, this.ticketBytesLength, this.ticketBytes.length - this.ticketBytesLength)) >= 0) {
                        this.ticketBytesLength += length;
                    }
                    in.close();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Received ticket: %s", Utilities.getMemoryDump(this.ticketBytes, 0, this.ticketBytesLength)));
                    }
                }
            }
            catch (MalformedURLException e) {
                log.error((Object)e);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        if (param.ticketCallback != 0) {
            int ticketLength = this.ticketBytesLength > 0 ? this.ticketBytesLength : 248;
            this.npAuthCreateTicketCallback = Modules.ThreadManForUserModule.hleKernelCreateCallback("sceNpAuthCreateStartRequest", param.ticketCallback, param.callbackArgument);
            if (Modules.ThreadManForUserModule.hleKernelRegisterCallback(7, this.npAuthCreateTicketCallback.getUid())) {
                Modules.ThreadManForUserModule.hleKernelNotifyCallback(7, this.npAuthCreateTicketCallback.getUid(), ticketLength);
            }
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1058807664, version=150)
    public int sceNpAuthGetTicket(int id, TPointer buffer, int length) {
        int result;
        if (useDummyTicket) {
            SceNpTicket ticket = new SceNpTicket();
            ticket.version = 289;
            ticket.size = 240;
            sceNpAuth.addTicketParam(ticket, "XXXXXXXXXXXXXXXXXXXX", 20);
            sceNpAuth.addTicketParam(ticket, 0);
            long now = System.currentTimeMillis();
            sceNpAuth.addTicketDateParam(ticket, now);
            sceNpAuth.addTicketDateParam(ticket, now + 600000L);
            sceNpAuth.addTicketLongParam(ticket, 0L);
            sceNpAuth.addTicketParam(ticket, 4, "DummyOnlineID", 32);
            sceNpAuth.addTicketParam(ticket, "gb", 4);
            sceNpAuth.addTicketParam(ticket, 4, "XX", 4);
            sceNpAuth.addTicketParam(ticket, this.serviceId, 24);
            int status = 0;
            if (Modules.sceNpModule.parentalControl == 1) {
                status |= 0x200;
            }
            sceNpAuth.addTicketParam(ticket, status |= (Modules.sceNpModule.getUserAge() & 0x7F) << 24);
            sceNpAuth.addTicketParam(ticket);
            sceNpAuth.addTicketParam(ticket);
            ticket.unknownBytes = new byte[72];
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNpAuthGetTicket returning dummy ticket: %s", ticket));
            }
            ticket.write(buffer);
            result = ticket.sizeof();
        } else if (this.ticketBytesLength > 0) {
            result = Math.min(this.ticketBytesLength, length);
            IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(buffer.getAddress(), result, 1);
            for (int i = 0; i < result; ++i) {
                memoryWriter.writeNext(this.ticketBytes[i] & 0xFF);
            }
            memoryWriter.flush();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNpAuthGetTicket returning real ticket: %s", Utilities.getMemoryDump(buffer.getAddress(), result)));
            }
        } else {
            buffer.clear(length);
            result = length;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNpAuthGetTicket returning empty ticket", new Object[0]));
            }
        }
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1761669252, version=150)
    public int sceNpAuthGetEntitlementById(TPointer ticketBuffer, int ticketLength, int unknown1, int unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1924858983, version=150)
    public int sceNpAuthDestroyRequest(int id) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-644590115, version=150)
    public int sceNpAuthAbortRequest(int id) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1513928058, version=150)
    public int sceNpAuthGetTicketParam(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer ticketBuffer, int ticketLength, int paramNumber, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=256, usage=BufferInfo.Usage.out) TPointer buffer) {
        buffer.clear(256);
        if (paramNumber < 0 || paramNumber >= 12) {
            return -2141911805;
        }
        if (ticketBuffer.getValue32() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNpAuthGetTicketParam returning empty param from empty ticket", new Object[0]));
            }
        } else {
            SceNpTicket ticket = new SceNpTicket();
            ticket.read(ticketBuffer);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNpAuthGetTicketParam ticket: %s", ticket));
            }
            SceNpTicket.TicketParam ticketParam = ticket.parameters.get(paramNumber);
            ticketParam.writeForPSP(buffer);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1979386595, version=150)
    public int sceNpAuthGetEntitlementIdList() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1639651507, version=150)
    public int sceNpAuth_61BB18B3() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1223361571, version=150)
    public int sceNpAuth_B714FBDD() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-830098504, version=150)
    public int sceNpAuth_CE85B3B8() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-623488380, version=150)
    public int sceNpAuth_DAD65284() {
        return 0;
    }
}

