/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEFunctions;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.hardware.Battery;
import jpcsp.hardware.Model;
import org.apache.log4j.Logger;

public class scePower
extends HLEModule {
    public static Logger log = Modules.getLogger("scePower");
    public static final int PSP_POWER_CB_POWER_SWITCH = Integer.MIN_VALUE;
    public static final int PSP_POWER_CB_HOLD_SWITCH = 0x40000000;
    public static final int PSP_POWER_CB_STANDBY = 524288;
    public static final int PSP_POWER_CB_RESUME_COMPLETE = 262144;
    public static final int PSP_POWER_CB_RESUMING = 131072;
    public static final int PSP_POWER_CB_SUSPENDING = 65536;
    public static final int PSP_POWER_CB_AC_POWER = 4096;
    public static final int PSP_POWER_CB_BATTERY_LOW = 256;
    public static final int PSP_POWER_CB_BATTERY_EXIST = 128;
    public static final int PSP_POWER_CB_BATTPOWER = 127;
    public static final int PSP_POWER_CB_SLOT_AUTO = -1;
    protected int[] powerCBSlots = new int[16];
    protected int pllClock = 222;
    protected int cpuClock = 222;
    protected int busClock = 111;
    protected static final int backlightMaximum = 4;
    protected int tachyonVoltage1;
    protected int tachyonVoltage2;

    @HLEUnimplemented
    @HLEFunction(nid=726793775, version=150)
    public int scePower_2B51FE2F() {
        return 0;
    }

    @HLEFunction(nid=1143733164, version=150)
    public int scePowerGetBacklightMaximum() {
        return 4;
    }

    @HLELogging(level="trace")
    @HLEFunction(nid=-271333021, version=150)
    public int scePowerTick(int flag) {
        return Modules.sceSuspendForUserModule.hleKernelPowerTick(flag);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-306102299, version=150)
    public int scePowerGetIdleTimer() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2133898161, version=150)
    public int scePowerIdleTimerEnable() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1758664383, version=150)
    public int scePowerIdleTimerDisable() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=670247212, version=150)
    public int scePowerBatteryUpdateInfo() {
        return 0;
    }

    @HLEFunction(nid=-387653116, version=150)
    public int scePowerGetForceSuspendCapacity() {
        int forceSuspendCapacity = Battery.getForceSuspendPercent() * Battery.getFullCapacity() / 100;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerGetForceSuspendCapacity returning %d mAh", forceSuspendCapacity));
        }
        return forceSuspendCapacity;
    }

    @HLEFunction(nid=-1181149108, version=150)
    public int scePowerGetLowBatteryCapacity() {
        int lowBatteryCapacity = Battery.getLowPercent() * Battery.getFullCapacity() / 100;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerGetLowBatteryCapacity returning %d mAh", lowBatteryCapacity));
        }
        return lowBatteryCapacity;
    }

    @HLEFunction(nid=-2025582754, version=150)
    public boolean scePowerIsPowerOnline() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerIsPowerOnline returning %b", Battery.isPluggedIn()));
        }
        return Battery.isPluggedIn();
    }

    @HLEFunction(nid=184356235, version=150)
    public boolean scePowerIsBatteryExist() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerIsBatteryExist returning %b", Battery.isPresent()));
        }
        return Battery.isPresent();
    }

    @HLEFunction(nid=508101633, version=150)
    public boolean scePowerIsBatteryCharging() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerIsBatteryCharging returning %b", Battery.isCharging()));
        }
        return Battery.isCharging();
    }

    @HLEFunction(nid=-1270666296, version=150)
    public int scePowerGetBatteryChargingStatus() {
        int status = 0;
        if (Battery.isPresent()) {
            status |= 0x80;
        }
        if (Battery.isPluggedIn()) {
            status |= 0x1000;
        }
        if (Battery.isCharging()) {
            status |= 0x7F;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerGetBatteryChargingStatus returning 0x%X", status));
        }
        return status;
    }

    @HLEFunction(nid=-754493146, version=150)
    public boolean scePowerIsLowBattery() {
        boolean isLow;
        boolean bl = isLow = Battery.getCurrentPowerPercent() <= Battery.getLowPercent();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerIsLowBattery returning %b", isLow));
        }
        return isLow;
    }

    @HLEFunction(nid=2023860118, version=150)
    public boolean scePowerIsSuspendRequired() {
        boolean isSuspendRequired;
        boolean bl = isSuspendRequired = Battery.getCurrentPowerPercent() <= Battery.getForceSuspendPercent();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerIsSuspendRequired returning %b", isSuspendRequired));
        }
        return isSuspendRequired;
    }

    @HLEFunction(nid=-1795840705, version=150)
    public int scePowerGetBatteryRemainCapacity() {
        int batteryRemainCapacity = Battery.getCurrentPowerPercent() * Battery.getFullCapacity() / 100;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerGetBatteryRemainCapacity returning %d mAh", batteryRemainCapacity));
        }
        return batteryRemainCapacity;
    }

    @HLEFunction(nid=-48717569, version=150)
    public int scePowerGetBatteryFullCapacity() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerGetBatteryFullCapacity returning %d mAh", Battery.getFullCapacity()));
        }
        return Battery.getFullCapacity();
    }

    @HLEFunction(nid=545640797, version=150)
    public int scePowerGetBatteryLifePercent() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerGetBatteryLifePercent returning %d %%", Battery.getCurrentPowerPercent()));
        }
        return Battery.getCurrentPowerPercent();
    }

    @HLEFunction(nid=-1896136798, version=150)
    public int scePowerGetBatteryLifeTime() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerGetBatteryLifeTime returning %d", Battery.getLifeTime()));
        }
        return Battery.getLifeTime();
    }

    @HLEFunction(nid=685842467, version=150)
    public int scePowerGetBatteryTemp() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerGetBatteryTemp returning %d C", Battery.getTemperature()));
        }
        return Battery.getTemperature();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2044010074, version=150)
    public int scePowerGetBatteryElec() {
        return 0;
    }

    @HLEFunction(nid=1211951211, version=150)
    public int scePowerGetBatteryVolt() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerGetBatteryVolt %d", Battery.getVoltage()));
        }
        return Battery.getVoltage();
    }

    @HLEUnimplemented
    @HLEFunction(nid=591620682, version=150)
    public int scePower_23436A4A() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=215096095, version=150)
    public int scePowerSetPowerSwMode() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=375185541, version=150)
    public int scePowerGetPowerSwMode() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=599990270, version=150)
    public int scePowerVolatileMemLock() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-90724967, version=150)
    public int scePowerVolatileMemTryLock() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1276258303, version=150)
    public int scePowerVolatileMemUnlock() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-691005713, version=150)
    public int scePowerLock() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-901958463, version=150)
    public int scePowerUnlock() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-614282801, version=150)
    public int scePowerCancelRequest() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2141456093, version=150)
    public int scePowerIsRequest() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=729578740, version=150)
    public int scePowerRequestStandby() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1405957684, version=150)
    public int scePowerRequestSuspend() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=678795595, version=150)
    public int scePower_2875994B() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=961654611, version=150)
    public int scePowerWaitRequestCompletion() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=7663515, version=150)
    public int scePowerGetResumeCount() {
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunctions(value={@HLEFunction(nid=79132270, version=150), @HLEFunction(nid=1986844759, version=660)})
    public int scePowerRegisterCallback(int slot, int uid) {
        ThreadManForUser threadMan;
        int result;
        boolean notifyCallback = false;
        if (slot == -1) {
            result = -2147483614;
            for (int i = 0; i < this.powerCBSlots.length; ++i) {
                if (this.powerCBSlots[i] != 0) continue;
                this.powerCBSlots[i] = uid;
                result = i;
                notifyCallback = true;
                break;
            }
        } else if (slot >= 0 && slot < this.powerCBSlots.length) {
            if (this.powerCBSlots[slot] == 0) {
                this.powerCBSlots[slot] = uid;
                result = 0;
                notifyCallback = true;
            } else {
                result = -2147483616;
            }
        } else {
            result = -1;
        }
        if (notifyCallback && (threadMan = Modules.ThreadManForUserModule).hleKernelRegisterCallback(4, uid)) {
            threadMan.hleKernelNotifyCallback(4, uid, 4096);
        }
        return result;
    }

    @HLELogging(level="info")
    @HLEFunctions(value={@HLEFunction(nid=-542590216, version=150), @HLEFunction(nid=828083382, version=660)})
    public int scePowerUnregisterCallback(int slot) {
        if (slot < 0 || slot >= this.powerCBSlots.length) {
            return -1;
        }
        if (this.powerCBSlots[slot] != 0) {
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            threadMan.hleKernelUnRegisterCallback(4, this.powerCBSlots[slot]);
            this.powerCBSlots[slot] = 0;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-610457379, version=150)
    public int scePowerUnregisterCallback() {
        return 0;
    }

    @HLEFunction(nid=-2076197053, version=150, checkInsideInterrupt=true)
    public int scePowerSetCpuClockFrequency(int freq) {
        this.cpuClock = freq;
        return 0;
    }

    @HLEFunction(nid=-1193823237, version=150, checkInsideInterrupt=true)
    public int scePowerSetBusClockFrequency(int freq) {
        this.busClock = freq;
        return 0;
    }

    @HLEFunction(nid=-18859473, version=150)
    public int scePowerGetCpuClockFrequency() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerGetCpuClockFrequency returning 0x%X", this.cpuClock));
        }
        return this.cpuClock;
    }

    @HLEFunction(nid=1200613109, version=150)
    public int scePowerGetBusClockFrequency() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerGetBusClockFrequency returning 0x%X", this.busClock));
        }
        return this.busClock;
    }

    @HLEFunction(nid=-38420503, version=150)
    public int scePowerGetCpuClockFrequencyInt() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerGetCpuClockFrequencyInt returning 0x%X", this.cpuClock));
        }
        return this.cpuClock;
    }

    @HLEFunction(nid=-1117251223, version=150)
    public int scePowerGetBusClockFrequencyInt() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerGetBusClockFrequencyInt returning 0x%X", this.busClock));
        }
        return this.busClock;
    }

    @HLEFunction(nid=888783971, version=150)
    public int scePowerGetPllClockFrequencyInt() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerGetPllClockFrequencyInt returning 0x%X", this.pllClock));
        }
        return this.pllClock;
    }

    @HLEFunction(nid=-1314575229, version=150)
    public float scePowerGetCpuClockFrequencyFloat() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerGetCpuClockFrequencyFloat returning %f", Float.valueOf(this.cpuClock)));
        }
        return this.cpuClock;
    }

    @HLEFunction(nid=-1683115029, version=150)
    public float scePowerGetBusClockFrequencyFloat() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerGetBusClockFrequencyFloat returning %f", Float.valueOf(this.busClock)));
        }
        return this.busClock;
    }

    @HLEFunction(nid=-365417945, version=150)
    public float scePowerGetPllClockFrequencyFloat() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePowerGetPllClockFrequencyFloat returning %f", Float.valueOf(this.pllClock)));
        }
        return this.pllClock;
    }

    @HLEFunction(nid=1937016562, version=150)
    public int scePowerSetClockFrequency(int pllClock, int cpuClock, int busClock) {
        if (cpuClock == 0 || cpuClock > 333) {
            log.warn((Object)String.format("scePowerSetClockFrequency invalid frequency pllClock %d cpuClock %d busClock %d", pllClock, cpuClock, busClock));
            return -2147483138;
        }
        log.info((Object)String.format("scePowerSetClockFrequency pllClock %d cpuClock %d busClock %d", pllClock, cpuClock, busClock));
        this.cpuClock = cpuClock;
        this.busClock = busClock;
        if (this.pllClock != pllClock) {
            this.pllClock = pllClock;
            Modules.ThreadManForUserModule.hleKernelDelayThread(150000, false);
        }
        return 0;
    }

    @HLEFunction(nid=-338593834, version=150)
    public int scePower_EBD177D6(int pllClock, int cpuClock, int busClock) {
        if (cpuClock == 0 || cpuClock > 333) {
            log.warn((Object)String.format("scePower_EBD177D6 invalid frequency pllClock %d cpuClock %d busClock %d", pllClock, cpuClock, busClock));
            return -2147483138;
        }
        log.info((Object)String.format("scePower_EBD177D6 pllClock %d cpuClock %d busClock %d", pllClock, cpuClock, busClock));
        this.cpuClock = cpuClock;
        this.busClock = busClock;
        if (this.pllClock != pllClock) {
            this.pllClock = pllClock;
            Modules.ThreadManForUserModule.hleKernelDelayThread(150000, false);
        }
        return 0;
    }

    @HLEFunction(nid=1184467373, version=630)
    public int scePower_469989AD(int pllClock, int cpuClock, int busClock) {
        if (cpuClock == 0 || cpuClock > 333) {
            log.warn((Object)String.format("scePower_469989AD invalid frequency pllClock %d cpuClock %d busClock %d", pllClock, cpuClock, busClock));
            return -2147483138;
        }
        log.info((Object)String.format("scePower_469989AD pllClock %d cpuClock %d busClock %d", pllClock, cpuClock, busClock));
        this.cpuClock = cpuClock;
        this.busClock = busClock;
        if (this.pllClock != pllClock) {
            this.pllClock = pllClock;
            Modules.ThreadManForUserModule.hleKernelDelayThread(150000, false);
        }
        return 0;
    }

    @HLEFunction(nid=-1470594864, version=630)
    public boolean scePower_A85880D0() {
        boolean result;
        int model = Model.getModel();
        boolean bl = result = model != 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePower_A85880D0 returning %b", result));
        }
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1168741168, version=660)
    public int scePowerSetWakeupCondition(int condition) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=842302538, version=150)
    public int scePower_driver_3234844A() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1599080146, version=660)
    public int scePower_driver_5F5006D2() {
        return this.scePower_driver_3234844A();
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1439881097, version=150), @HLEFunction(nid=-1160084686, version=660)})
    public int scePowerGetTachyonVoltage(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 unknown1, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 unknown2) {
        unknown1.setValue(this.tachyonVoltage1);
        unknown2.setValue(this.tachyonVoltage2);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-584584935, version=150), @HLEFunction(nid=318255149, version=660)})
    public int scePowerSetTachyonVoltage(int unknown1, int unknown2) {
        if (unknown1 != -1) {
            this.tachyonVoltage1 = unknown1 & 0xFFFF;
        }
        if (unknown2 != -1) {
            this.tachyonVoltage2 = unknown2 & 0xFFFF;
        }
        return 0;
    }

    @HLEFunction(nid=71489618, version=150)
    public int scePowerRequestColdReset(int unknown) {
        Modules.sceDisplayModule.clear();
        Emulator.getMainGUI().doReboot();
        return 0;
    }
}

