/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.modules.sceMpeg;
import jpcsp.Memory;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class scePsmf
extends HLEModule {
    public static Logger log = Modules.getLogger("scePsmf");
    public static final int PSMF_AVC_STREAM = 0;
    public static final int PSMF_ATRAC_STREAM = 1;
    public static final int PSMF_PCM_STREAM = 2;
    public static final int PSMF_DATA_STREAM = 3;
    public static final int PSMF_AUDIO_STREAM = 15;
    public static final int PSMF_VIDEO_STREAM_ID = 224;
    public static final int PSMF_AUDIO_STREAM_ID = 189;
    public static final int MPEG_HEADER_BUFFER_MINIMUM_SIZE = 2048;
    public static final int PSMF_MAGIC_OFFSET = 0;
    public static final int PSMF_STREAM_VERSION_OFFSET = 4;
    public static final int PSMF_STREAM_OFFSET_OFFSET = 8;
    public static final int PSMF_STREAM_SIZE_OFFSET = 12;
    public static final int PSMF_FIRST_TIMESTAMP_OFFSET = 84;
    public static final int PSMF_LAST_TIMESTAMP_OFFSET = 90;
    public static final int PSMF_NUMBER_STREAMS_OFFSET = 128;
    public static final int PSMF_FRAME_WIDTH_OFFSET = 142;
    public static final int PSMF_FRAME_HEIGHT_OFFSET = 143;
    private HashMap<Integer, PSMFHeader> psmfHeaderMap;

    @Override
    public void start() {
        this.psmfHeaderMap = new HashMap();
        super.start();
    }

    public static int read8(Memory mem, int bufferAddr, byte[] buffer, int offset) {
        if (buffer != null) {
            return Utilities.read8(buffer, offset);
        }
        return mem.read8(bufferAddr + offset);
    }

    public static int readUnaligned32(Memory mem, int bufferAddr, byte[] buffer, int offset) {
        if (buffer != null) {
            return Utilities.readUnaligned32(buffer, offset);
        }
        return Utilities.readUnaligned32(mem, bufferAddr + offset);
    }

    public static int read32(Memory mem, int bufferAddr, byte[] buffer, int offset) {
        if (buffer != null) {
            return Utilities.readUnaligned32(buffer, offset);
        }
        return mem.read32(bufferAddr + offset);
    }

    public static int read16(Memory mem, int bufferAddr, byte[] buffer, int offset) {
        if (buffer != null) {
            return Utilities.readUnaligned16(buffer, offset);
        }
        return mem.read16(bufferAddr + offset);
    }

    public static Date convertTimestampToDate(long timestamp) {
        long millis = timestamp / 90L;
        return new Date(millis);
    }

    public static int getPsmfNumStreams(Memory mem, int addr, byte[] mpegHeader) {
        return Utilities.endianSwap16(scePsmf.read16(mem, addr, mpegHeader, 128));
    }

    public static LinkedList<PSMFStream> readPsmfStreams(Memory mem, int addr, byte[] mpegHeader, PSMFHeader psmfHeader) {
        int numStreams = scePsmf.getPsmfNumStreams(mem, addr, mpegHeader);
        LinkedList<PSMFStream> streams = new LinkedList<PSMFStream>();
        int numberOfStreams = 0;
        for (int i = 0; i < numStreams; ++i) {
            PSMFStream stream = null;
            int currentStreamOffset = 130 + i * 16;
            int streamID = scePsmf.read8(mem, addr, mpegHeader, currentStreamOffset);
            int subStreamID = scePsmf.read8(mem, addr, mpegHeader, currentStreamOffset + 1);
            if ((streamID & 0xF0) == 224) {
                stream = new PSMFStream(numberOfStreams);
                stream.readMPEGVideoStreamParams(mem, addr, mpegHeader, currentStreamOffset, psmfHeader);
            } else if (streamID == 189 && subStreamID < 32) {
                stream = new PSMFStream(numberOfStreams);
                stream.readPrivateAudioStreamParams(mem, addr, mpegHeader, currentStreamOffset, psmfHeader);
            } else {
                stream = new PSMFStream(numberOfStreams);
                stream.readUserDataStreamParams(mem, addr, mpegHeader, currentStreamOffset, psmfHeader);
            }
            if (stream == null) continue;
            streams.add(stream);
            ++numberOfStreams;
        }
        return streams;
    }

    public TPointer32 checkPsmf(TPointer32 psmf) {
        int headerAddress = psmf.getValue(24);
        if (!this.psmfHeaderMap.containsKey(headerAddress)) {
            throw new SceKernelErrorException(-2141106139);
        }
        return psmf;
    }

    public TPointer32 checkPsmfWithEPMap(TPointer32 psmf) {
        PSMFHeader header = this.getPsmfHeader(psmf = this.checkPsmf(psmf));
        if (!header.hasEPMap()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("checkPsmfWithEPMap returning 0x%08X(ERROR_PSMF_NOT_FOUND)", -2141106139));
            }
            throw new SceKernelErrorException(-2141106139);
        }
        return psmf;
    }

    private PSMFHeader getPsmfHeader(TPointer32 psmf) {
        int headerAddress = psmf.getValue(24);
        return this.psmfHeaderMap.get(headerAddress);
    }

    @HLELogging(level="info")
    @HLEFunction(nid=-1037270233, version=150, checkInsideInterrupt=true, stackUsage=80)
    public int scePsmfSetPsmf(TPointer32 psmf, TPointer bufferAddr) {
        PSMFHeader header = new PSMFHeader(bufferAddr.getAddress(), null);
        this.psmfHeaderMap.put(bufferAddr.getAddress(), header);
        psmf.setValue(0, header.getVersion());
        psmf.setValue(4, header.getHeaderSize());
        psmf.setValue(8, header.getStreamSize());
        psmf.setValue(12, 0);
        psmf.setValue(16, 0);
        psmf.setValue(20, header.getCurrentStreamNumber());
        psmf.setValue(24, bufferAddr.getAddress());
        return 0;
    }

    @HLEFunction(nid=-941933989, version=150, checkInsideInterrupt=true, stackUsage=80)
    public int scePsmfGetCurrentStreamType(@CheckArgument(value="checkPsmf") TPointer32 psmf, TPointer32 typeAddr, TPointer32 channelAddr) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        typeAddr.setValue(header.getCurrentStreamType());
        channelAddr.setValue(header.getCurrentStreamChannel());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePsmfGetCurrentStreamType returning type=%d, channel=%d", typeAddr.getValue(), channelAddr.getValue()));
        }
        return 0;
    }

    @HLEFunction(nid=673449320, version=150, checkInsideInterrupt=true, stackUsage=0)
    public int scePsmfGetCurrentStreamNumber(@CheckArgument(value="checkPsmf") TPointer32 psmf) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        return header.getCurrentStreamNumber();
    }

    @HLEFunction(nid=510496787, version=150, checkInsideInterrupt=true, stackUsage=32)
    public int scePsmfSpecifyStreamWithStreamType(@CheckArgument(value="checkPsmf") TPointer32 psmf, int type, int ch) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (!header.setStreamWithType(type, ch)) {
            header.setStreamNum(-1);
        }
        return 0;
    }

    @HLEFunction(nid=1271512544, version=150, checkInsideInterrupt=true, stackUsage=64)
    public int scePsmfSpecifyStream(@CheckArgument(value="checkPsmf") TPointer32 psmf, int streamNum) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        header.setStreamNum(streamNum);
        return 0;
    }

    @HLEFunction(nid=1993584314, version=150, checkInsideInterrupt=true, stackUsage=16)
    public int scePsmfGetPresentationStartTime(@CheckArgument(value="checkPsmf") TPointer32 psmf, TPointer32 startTimeAddr) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        int startTime = header.getPresentationStartTime();
        startTimeAddr.setValue(startTime);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePsmfGetPresentationStartTime startTime=%d", startTime));
        }
        return 0;
    }

    @HLEFunction(nid=-1114971944, version=150, checkInsideInterrupt=true, stackUsage=16)
    public int scePsmfGetPresentationEndTime(@CheckArgument(value="checkPsmf") TPointer32 psmf, TPointer32 endTimeAddr) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        int endTime = header.getPresentationEndTime();
        endTimeAddr.setValue(endTime);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePsmfGetPresentationEndTime endTime=%d", endTime));
        }
        return 0;
    }

    @HLEFunction(nid=-353531443, version=150, checkInsideInterrupt=true, stackUsage=16)
    public int scePsmfGetNumberOfStreams(@CheckArgument(value="checkPsmf") TPointer32 psmf) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        return header.getNumberOfStreams();
    }

    @HLEFunction(nid=1955710008, version=150, checkInsideInterrupt=true, stackUsage=16)
    public int scePsmfGetNumberOfEPentries(@CheckArgument(value="checkPsmf") TPointer32 psmf) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        return header.getEPMapEntriesNum();
    }

    @HLEFunction(nid=195368165, version=150, checkInsideInterrupt=true, stackUsage=32)
    public int scePsmfGetVideoInfo(@CheckArgument(value="checkPsmf") TPointer32 psmf, TPointer32 videoInfoAddr) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (!header.isValidCurrentStreamNumber()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("scePsmfGetVideoInfo returning 0x%08X(ERROR_PSMF_INVALID_ID)", -2141105920));
            }
            return -2141105920;
        }
        videoInfoAddr.setValue(0, header.getVideoWidth());
        videoInfoAddr.setValue(4, header.getVideoHeight());
        return 0;
    }

    @HLEFunction(nid=-1472237293, version=150, checkInsideInterrupt=true, stackUsage=32)
    public int scePsmfGetAudioInfo(@CheckArgument(value="checkPsmf") TPointer32 psmf, TPointer32 audioInfoAddr) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (!header.isValidCurrentStreamNumber()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("scePsmfGetAudioInfo returning 0x%08X(ERROR_PSMF_INVALID_ID)", -2141105920));
            }
            return -2141105920;
        }
        audioInfoAddr.setValue(0, header.getAudioChannelConfig());
        audioInfoAddr.setValue(4, header.getAudioSampleFrequency());
        return 0;
    }

    @HLEFunction(nid=-1759888752, version=150, checkInsideInterrupt=true, stackUsage=16)
    public int scePsmfCheckEPmap(@CheckArgument(value="checkPsmfWithEPMap") TPointer32 psmf) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (!header.hasEPMap()) {
            return -2141106139;
        }
        return 0;
    }

    @HLEFunction(nid=1315064372, version=150, checkInsideInterrupt=true, stackUsage=16)
    public int scePsmfGetEPWithId(@CheckArgument(value="checkPsmfWithEPMap") TPointer32 psmf, int id, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.out) TPointer32 outAddr) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (!header.hasEPMap()) {
            return -2141106139;
        }
        PSMFEntry entry = header.getEPMapEntry(id);
        if (entry == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("scePsmfGetEPWithId returning 0x%08X(ERROR_PSMF_INVALID_ID)", -2141105920));
            }
            return -2141105920;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePsmfGetEPWithId returning %s", entry));
        }
        outAddr.setValue(0, entry.getEntryPTS());
        outAddr.setValue(4, entry.getEntryOffset());
        outAddr.setValue(8, entry.getEntryIndex());
        outAddr.setValue(12, entry.getEntryPicOffset());
        return 0;
    }

    @HLEFunction(nid=2081323715, version=150, checkInsideInterrupt=true, stackUsage=16)
    public int scePsmfGetEPWithTimestamp(@CheckArgument(value="checkPsmfWithEPMap") TPointer32 psmf, int ts, TPointer32 entryAddr) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (ts < header.getPresentationStartTime()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("scePsmfGetEPWithTimestamp returning 0x%08X(ERROR_PSMF_INVALID_TIMESTAMP)", -2141104896));
            }
            return -2141104896;
        }
        PSMFEntry entry = header.getEPMapEntryWithTimestamp(ts);
        if (entry == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("scePsmfGetEPWithTimestamp returning -1", new Object[0]));
            }
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePsmfGetEPWithTimestamp returning %s", entry));
        }
        entryAddr.setValue(0, entry.getEntryPTS());
        entryAddr.setValue(4, entry.getEntryOffset());
        entryAddr.setValue(8, entry.getEntryIndex());
        entryAddr.setValue(12, entry.getEntryPicOffset());
        return 0;
    }

    @HLEFunction(nid=1598387477, version=150, checkInsideInterrupt=true, stackUsage=32)
    public int scePsmfGetEPidWithTimestamp(@CheckArgument(value="checkPsmfWithEPMap") TPointer32 psmf, int ts) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (!header.hasEPMap()) {
            return -2141106139;
        }
        if (ts < header.getPresentationStartTime()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("scePsmfGetEPidWithTimestamp returning 0x%08X(ERROR_PSMF_INVALID_TIMESTAMP)", -2141104896));
            }
            return -2141104896;
        }
        PSMFEntry entry = header.getEPMapEntryWithTimestamp(ts);
        if (entry == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("scePsmfGetEPidWithTimestamp returning -1", new Object[0]));
            }
            return -1;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePsmfGetEPidWithTimestamp returning id 0x%X", entry.getId()));
        }
        return entry.getId();
    }

    @HLEFunction(nid=1534131393, version=150, checkInsideInterrupt=true, stackUsage=32)
    public int scePsmfQueryStreamOffset(TPointer bufferAddr, TPointer32 offsetAddr) {
        PSMFHeader header = new PSMFHeader(bufferAddr.getAddress(), null);
        offsetAddr.setValue(header.mpegOffset);
        return 0;
    }

    @HLEFunction(nid=-1789670255, version=150, checkInsideInterrupt=true, stackUsage=0)
    public int scePsmfQueryStreamSize(TPointer bufferAddr, TPointer32 sizeAddr) {
        PSMFHeader header = new PSMFHeader(bufferAddr.getAddress(), null);
        sizeAddr.setValue(header.mpegStreamSize);
        return 0;
    }

    @HLEFunction(nid=1758733096, version=150, checkInsideInterrupt=true, stackUsage=160)
    public int scePsmfGetNumberOfSpecificStreams(@CheckArgument(value="checkPsmf") TPointer32 psmf, int streamType) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        int streamNum = header.getSpecificStreamNum(streamType);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePsmfGetNumberOfSpecificStreams returning %d", streamNum));
        }
        return streamNum;
    }

    @HLEFunction(nid=202509853, version=150, checkInsideInterrupt=true)
    public int scePsmfSpecifyStreamWithStreamTypeNumber(@CheckArgument(value="checkPsmf") TPointer32 psmf, int type, int typeNum) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        if (!header.setStreamWithTypeNum(type, typeNum)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("scePsmfSpecifyStreamWithStreamTypeNumber returning 0x%08X(ERROR_PSMF_INVALID_ID)", -2141105920));
            }
            return -2141105920;
        }
        return 0;
    }

    @HLEFunction(nid=645096555, version=150, checkInsideInterrupt=true, stackUsage=256)
    public int scePsmfVerifyPsmf(TPointer bufferAddr) {
        int magic;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("scePsmfVerifyPsmf %s", Utilities.getMemoryDump(bufferAddr.getAddress(), 2048)));
        }
        if ((magic = bufferAddr.getValue32(0)) != 1179472720) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("scePsmfVerifyPsmf returning 0x%08X(ERROR_PSMF_INVALID_PSMF)", -2141104895));
            }
            return -2141104895;
        }
        int rawVersion = bufferAddr.getValue32(4);
        int version = sceMpeg.getMpegVersion(rawVersion);
        if (version < 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("scePsmfVerifyPsmf returning 0x%08X(ERROR_PSMF_INVALID_PSMF)", -2141104895));
            }
            return -2141104895;
        }
        return 0;
    }

    @HLEFunction(nid=-1215383063, version=150, checkInsideInterrupt=true, stackUsage=0)
    public int scePsmfGetHeaderSize(@CheckArgument(value="checkPsmf") TPointer32 psmf, TPointer32 sizeAddr) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        sizeAddr.setValue(header.getHeaderSize());
        return 0;
    }

    @HLEFunction(nid=-1511260543, version=150, checkInsideInterrupt=true, stackUsage=0)
    public int scePsmfGetStreamSize(@CheckArgument(value="checkPsmf") TPointer32 psmf, TPointer32 sizeAddr) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        sizeAddr.setValue(header.getStreamSize());
        return 0;
    }

    @HLEFunction(nid=-517457771, version=150, checkInsideInterrupt=true, stackUsage=0)
    public int scePsmfGetPsmfVersion(@CheckArgument(value="checkPsmf") TPointer32 psmf) {
        PSMFHeader header = this.getPsmfHeader(psmf);
        int headerVersion = header.getVersion();
        int version = 0;
        int i = 0;
        while (i < 4) {
            int digit = headerVersion & 0xF;
            version = version * 10 + digit;
            ++i;
            headerVersion >>= 8;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("scePsmfGetPsmfVersion returning version=%d (headerVersion=0x%04X)", version, headerVersion));
        }
        return version;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-562501124, version=150)
    public int scePsmf_DE78E9FC(@CheckArgument(value="checkPsmf") TPointer32 psmf, int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1135377851, version=150)
    public int scePsmf_43AC7DBB(@CheckArgument(value="checkPsmf") TPointer32 psmf, int unknown, int markNumber, TPointer markInfoAddr) {
        int markType = 0;
        int markTimestamp = 0;
        int markEntryEsStream = 0;
        int markData = 0;
        String markName = "Test";
        markInfoAddr.setValue32(0, markType);
        markInfoAddr.setValue32(4, markTimestamp);
        markInfoAddr.setValue32(8, markEntryEsStream);
        markInfoAddr.setValue32(12, markData);
        markInfoAddr.setValue32(16, markName.length());
        markInfoAddr.setStringNZ(20, markName.length(), markName);
        return 0;
    }

    public static class PSMFHeader {
        private static final int size = 2048;
        public int mpegMagic;
        public int mpegRawVersion;
        public int mpegVersion;
        public int mpegOffset;
        public int mpegStreamSize;
        public long mpegFirstTimestamp;
        public long mpegLastTimestamp;
        public Date mpegFirstDate;
        public Date mpegLastDate;
        private int streamNum;
        private int audioSampleFrequency;
        private int audioChannelConfig;
        private int avcDetailFrameWidth;
        private int avcDetailFrameHeight;
        public List<PSMFStream> psmfStreams;
        private PSMFStream currentStream = null;
        private PSMFStream currentVideoStream = null;

        public PSMFHeader() {
        }

        public PSMFHeader(int bufferAddr, byte[] mpegHeader) {
            Memory mem = Memory.getInstance();
            int streamDataTotalSize = Utilities.endianSwap32(scePsmf.readUnaligned32(mem, bufferAddr, mpegHeader, 80));
            int unk = Utilities.endianSwap32(scePsmf.readUnaligned32(mem, bufferAddr, mpegHeader, 96));
            int streamDataNextBlockSize = Utilities.endianSwap32(scePsmf.readUnaligned32(mem, bufferAddr, mpegHeader, 106));
            int streamDataNextInnerBlockSize = Utilities.endianSwap32(scePsmf.readUnaligned32(mem, bufferAddr, mpegHeader, 124));
            this.streamNum = Utilities.endianSwap16(scePsmf.read16(mem, bufferAddr, mpegHeader, 128));
            this.mpegMagic = scePsmf.read32(mem, bufferAddr, mpegHeader, 0);
            this.mpegRawVersion = scePsmf.read32(mem, bufferAddr, mpegHeader, 4);
            this.mpegVersion = sceMpeg.getMpegVersion(this.mpegRawVersion);
            this.mpegOffset = Utilities.endianSwap32(scePsmf.read32(mem, bufferAddr, mpegHeader, 8));
            this.mpegStreamSize = Utilities.endianSwap32(scePsmf.read32(mem, bufferAddr, mpegHeader, 12));
            this.mpegFirstTimestamp = this.readTimestamp(mem, bufferAddr, mpegHeader, 84);
            this.mpegLastTimestamp = this.readTimestamp(mem, bufferAddr, mpegHeader, 90);
            this.avcDetailFrameWidth = scePsmf.read8(mem, bufferAddr, mpegHeader, 142) << 4;
            this.avcDetailFrameHeight = scePsmf.read8(mem, bufferAddr, mpegHeader, 143) << 4;
            this.mpegFirstDate = scePsmf.convertTimestampToDate(this.mpegFirstTimestamp);
            this.mpegLastDate = scePsmf.convertTimestampToDate(this.mpegLastTimestamp);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("PSMFHeader: version=0x%04X, firstTimestamp=%d, lastTimestamp=%d, streamDataTotalSize=%d, unk=0x%08X, streamDataNextBlockSize=%d, streamDataNextInnerBlockSize=%d, streamNum=%d", this.getVersion(), this.mpegFirstTimestamp, this.mpegLastTimestamp, streamDataTotalSize, unk, streamDataNextBlockSize, streamDataNextInnerBlockSize, this.streamNum));
            }
            if (this.isValid()) {
                this.psmfStreams = scePsmf.readPsmfStreams(mem, bufferAddr, mpegHeader, this);
                if (this.psmfStreams.size() > 0) {
                    this.setStreamNum(0);
                }
                for (PSMFStream stream : this.psmfStreams) {
                    stream.EPMap = new LinkedList();
                    int EPMapOffset = stream.EPMapOffset;
                    for (int i = 0; i < stream.EPMapNumEntries; ++i) {
                        int index = scePsmf.read8(mem, bufferAddr, mpegHeader, EPMapOffset + i * 10);
                        int picOffset = scePsmf.read8(mem, bufferAddr, mpegHeader, EPMapOffset + 1 + i * 10);
                        int pts = Utilities.endianSwap32(scePsmf.readUnaligned32(mem, bufferAddr, mpegHeader, EPMapOffset + 2 + i * 10));
                        int offset = Utilities.endianSwap32(scePsmf.readUnaligned32(mem, bufferAddr, mpegHeader, EPMapOffset + 6 + i * 10));
                        PSMFEntry psmfEntry = new PSMFEntry(i, index, picOffset, pts, offset);
                        stream.EPMap.add(psmfEntry);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)String.format("EPMap stream %d, entry#%d: %s", stream.getStreamChannel(), i, psmfEntry));
                    }
                }
            }
        }

        private long readTimestamp(Memory mem, int bufferAddr, byte[] mpegHeader, int offset) {
            long timestamp = (long)Utilities.endianSwap32(scePsmf.readUnaligned32(mem, bufferAddr, mpegHeader, offset + 2)) & 0xFFFFFFFFL;
            timestamp |= (long)scePsmf.read8(mem, bufferAddr, mpegHeader, offset + 1) << 32;
            return timestamp |= (long)scePsmf.read8(mem, bufferAddr, mpegHeader, offset + 0) << 40;
        }

        public boolean isValid() {
            return this.mpegFirstTimestamp == 90000L && this.mpegFirstTimestamp < this.mpegLastTimestamp && this.mpegLastTimestamp > 0L;
        }

        public boolean isInvalid() {
            return !this.isValid();
        }

        public int getVersion() {
            return this.mpegRawVersion;
        }

        public int getHeaderSize() {
            return 2048;
        }

        public int getStreamOffset() {
            return this.mpegOffset;
        }

        public int getStreamSize() {
            return this.mpegStreamSize;
        }

        public int getPresentationStartTime() {
            return (int)this.mpegFirstTimestamp;
        }

        public int getPresentationEndTime() {
            return (int)this.mpegLastTimestamp;
        }

        public int getVideoWidth() {
            return this.avcDetailFrameWidth;
        }

        public int getVideoHeight() {
            return this.avcDetailFrameHeight;
        }

        public int getAudioSampleFrequency() {
            return this.audioSampleFrequency;
        }

        public int getAudioChannelConfig() {
            return this.audioChannelConfig;
        }

        public int getEPMapEntriesNum() {
            if (this.currentVideoStream == null) {
                return 0;
            }
            return this.currentVideoStream.EPMapNumEntries;
        }

        public boolean hasEPMap() {
            return this.getEPMapEntriesNum() > 0;
        }

        public PSMFEntry getEPMapEntry(int id) {
            if (!this.hasEPMap()) {
                return null;
            }
            if (id < 0 || id >= this.currentVideoStream.EPMap.size()) {
                return null;
            }
            return (PSMFEntry)this.currentVideoStream.EPMap.get(id);
        }

        public PSMFEntry getEPMapEntryWithTimestamp(int ts) {
            if (!this.hasEPMap()) {
                return null;
            }
            PSMFEntry foundEntry = null;
            for (PSMFEntry entry : this.currentVideoStream.EPMap) {
                if (foundEntry == null || entry.getEntryPTS() <= ts) {
                    foundEntry = entry;
                    continue;
                }
                if (entry.getEntryPTS() <= ts) continue;
                break;
            }
            return foundEntry;
        }

        public PSMFEntry getEPMapEntryWithOffset(int offset) {
            if (!this.hasEPMap()) {
                return null;
            }
            PSMFEntry foundEntry = null;
            for (PSMFEntry entry : this.currentVideoStream.EPMap) {
                if (foundEntry == null || entry.getEntryOffset() <= offset) {
                    foundEntry = entry;
                    continue;
                }
                if (entry.getEntryOffset() <= offset) continue;
                break;
            }
            return foundEntry;
        }

        public int getNumberOfStreams() {
            return this.streamNum;
        }

        public int getCurrentStreamNumber() {
            if (!this.isValidCurrentStreamNumber()) {
                return -1;
            }
            return this.currentStream.getStreamNumber();
        }

        public boolean isValidCurrentStreamNumber() {
            return this.currentStream != null;
        }

        public int getCurrentStreamType() {
            if (!this.isValidCurrentStreamNumber()) {
                return -1;
            }
            return this.currentStream.getStreamType();
        }

        public int getCurrentStreamChannel() {
            if (!this.isValidCurrentStreamNumber()) {
                return -1;
            }
            return this.currentStream.getStreamChannel();
        }

        public int getSpecificStreamNum(int type) {
            int num = 0;
            if (this.psmfStreams != null) {
                for (PSMFStream stream : this.psmfStreams) {
                    if (!stream.isStreamOfType(type)) continue;
                    ++num;
                }
            }
            return num;
        }

        public void setStreamNum(int id) {
            if (id < 0 || id >= this.psmfStreams.size()) {
                this.currentStream = null;
            } else {
                this.currentStream = this.psmfStreams.get(id);
                int type = this.getCurrentStreamType();
                switch (type) {
                    case 0: {
                        this.currentVideoStream = this.currentStream;
                        break;
                    }
                }
            }
        }

        private int getStreamNumber(int type, int typeNum, int channel) {
            if (this.psmfStreams != null) {
                for (PSMFStream stream : this.psmfStreams) {
                    if (!stream.isStreamOfType(type)) continue;
                    if (typeNum <= 0 && (channel < 0 || stream.getStreamChannel() == channel)) {
                        return stream.getStreamNumber();
                    }
                    --typeNum;
                }
            }
            return -1;
        }

        public boolean setStreamWithType(int type, int channel) {
            int streamNumber = this.getStreamNumber(type, 0, channel);
            if (streamNumber < 0) {
                return false;
            }
            this.setStreamNum(streamNumber);
            return true;
        }

        public boolean setStreamWithTypeNum(int type, int typeNum) {
            int streamNumber = this.getStreamNumber(type, typeNum, -1);
            if (streamNumber < 0) {
                return false;
            }
            this.setStreamNum(streamNumber);
            return true;
        }
    }

    protected static class PSMFEntry {
        private int EPIndex;
        private int EPPicOffset;
        private int EPPts;
        private int EPOffset;
        private int id;

        public PSMFEntry(int id, int index, int picOffset, int pts, int offset) {
            this.id = id;
            this.EPIndex = index;
            this.EPPicOffset = picOffset;
            this.EPPts = pts;
            this.EPOffset = offset;
        }

        public int getEntryIndex() {
            return this.EPIndex;
        }

        public int getEntryPicOffset() {
            return this.EPPicOffset;
        }

        public int getEntryPTS() {
            return this.EPPts;
        }

        public int getEntryOffset() {
            return this.EPOffset * 2048;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return String.format("id=%d, index=0x%X, picOffset=0x%X, PTS=0x%X, offset=0x%X", this.getId(), this.getEntryIndex(), this.getEntryPicOffset(), this.getEntryPTS(), this.getEntryOffset());
        }
    }

    public static class PSMFStream {
        private int streamType = -1;
        private int streamChannel = -1;
        private int streamNumber;
        private int EPMapNumEntries;
        private int EPMapOffset;
        private List<PSMFEntry> EPMap;
        private int frameWidth;
        private int frameHeight;

        public PSMFStream(int streamNumber) {
            this.streamNumber = streamNumber;
        }

        public int getStreamType() {
            return this.streamType;
        }

        public int getStreamChannel() {
            return this.streamChannel;
        }

        public int getStreamNumber() {
            return this.streamNumber;
        }

        public boolean isStreamOfType(int type) {
            if (this.streamType == type) {
                return true;
            }
            if (type == 15) {
                return this.streamType == 1 || this.streamType == 2;
            }
            return false;
        }

        public void readMPEGVideoStreamParams(Memory mem, int addr, byte[] mpegHeader, int offset, PSMFHeader psmfHeader) {
            int streamID = scePsmf.read8(mem, addr, mpegHeader, offset);
            int privateStreamID = scePsmf.read8(mem, addr, mpegHeader, offset + 1);
            int unk1 = scePsmf.read8(mem, addr, mpegHeader, offset + 2);
            int unk2 = scePsmf.read8(mem, addr, mpegHeader, offset + 3);
            this.EPMapOffset = Utilities.endianSwap32(scePsmf.readUnaligned32(mem, addr, mpegHeader, offset + 4));
            this.EPMapNumEntries = Utilities.endianSwap32(scePsmf.readUnaligned32(mem, addr, mpegHeader, offset + 8));
            this.frameWidth = scePsmf.read8(mem, addr, mpegHeader, offset + 12) * 16;
            this.frameHeight = scePsmf.read8(mem, addr, mpegHeader, offset + 13) * 16;
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Found PSMF MPEG video stream data: streamID=0x%X, privateStreamID=0x%X, unk1=0x%X, unk2=0x%X, EPMapOffset=0x%x, EPMapNumEntries=%d, frameWidth=%d, frameHeight=%d", streamID, privateStreamID, unk1, unk2, this.EPMapOffset, this.EPMapNumEntries, this.frameWidth, this.frameHeight));
            }
            this.streamType = 0;
            this.streamChannel = streamID & 0xF;
        }

        public void readPrivateAudioStreamParams(Memory mem, int addr, byte[] mpegHeader, int offset, PSMFHeader psmfHeader) {
            int streamID = scePsmf.read8(mem, addr, mpegHeader, offset);
            int privateStreamID = scePsmf.read8(mem, addr, mpegHeader, offset + 1);
            int unk1 = scePsmf.read8(mem, addr, mpegHeader, offset + 2);
            int unk2 = scePsmf.read8(mem, addr, mpegHeader, offset + 3);
            int audioChannelConfig = scePsmf.read8(mem, addr, mpegHeader, offset + 14);
            int audioSampleFrequency = scePsmf.read8(mem, addr, mpegHeader, offset + 15);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Found PSMF MPEG audio stream data: streamID=0x%X, privateStreamID=0x%X, unk1=0x%X, unk2=0x%X, audioChannelConfig=%d, audioSampleFrequency=%d", streamID, privateStreamID, unk1, unk2, audioChannelConfig, audioSampleFrequency));
            }
            if (psmfHeader != null) {
                psmfHeader.audioChannelConfig = audioChannelConfig;
                psmfHeader.audioSampleFrequency = audioSampleFrequency;
            }
            this.streamType = (privateStreamID & 0xF0) == 0 ? 1 : 2;
            this.streamChannel = privateStreamID & 0xF;
        }

        public void readUserDataStreamParams(Memory mem, int addr, byte[] mpegHeader, int offset, PSMFHeader psmfHeader) {
            log.warn((Object)String.format("Unknown User Data stream format", new Object[0]));
            this.streamType = 3;
        }
    }
}

