/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.crypto.CryptoEngine;
import jpcsp.hardware.Model;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceResmgr
extends HLEModule {
    public static Logger log = Modules.getLogger("sceResmgr");
    public static final String dummyIndexDatContent = "release:6.59:\nbuild:5454,0,3,1,0:builder@vsh-build6\nsystem:57716@release_660,0x06060010:\nvsh:p6616@release_660,v58533@release_660,20110727:\ntarget:1:WorldWide\n";

    @Override
    public void start() {
        sceResmgr.createDummyIndexDat();
        super.start();
    }

    private static void createDummyIndexDat() {
        int tag;
        String indexDatFileName = String.format("flash0:/vsh/etc/index_%02dg.dat", Model.getGeneration());
        byte[] content = Utilities.readCompleteFile(indexDatFileName);
        if (content != null && content.length > 0) {
            return;
        }
        byte[] buffer = new byte[496];
        Utilities.write8(buffer, 124, 0);
        Utilities.writeUnaligned32(buffer, 176, 159);
        Utilities.writeUnaligned32(buffer, 180, 128);
        switch (Model.getGeneration()) {
            case 1: {
                tag = 187404528;
                break;
            }
            case 2: {
                tag = 187404784;
                break;
            }
            default: {
                tag = 187405040;
            }
        }
        Utilities.writeUnaligned32(buffer, 208, tag);
        Utilities.writeStringNZ(buffer, 336, buffer.length - 336, dummyIndexDatContent);
        Utilities.writeCompleteFile(indexDatFileName, buffer, true);
    }

    @HLEFunction(nid=-1648277359, version=150)
    public int sceResmgr_9DC14891(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.inout) TPointer buffer, int bufferSize, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 resultLengthAddr) {
        int resultLength;
        if ("release:".equals(buffer.getStringNZ(0, 8))) {
            resultLength = bufferSize;
        } else {
            byte[] buf = buffer.getArray8(bufferSize);
            int result = new CryptoEngine().getPRXEngine().DecryptPRX(buf, bufferSize, 9, null, null);
            if (result < 0) {
                log.error((Object)String.format("sceResmgr_9DC14891 returning error 0x%08X", result));
                return result;
            }
            resultLength = result;
            buffer.setArray(buf, resultLength);
        }
        resultLengthAddr.setValue(resultLength);
        return 0;
    }
}

