/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.Arrays;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEFunctions;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.modules.sceRtc;
import jpcsp.hardware.Battery;
import jpcsp.hardware.LED;
import jpcsp.hardware.MemoryStick;
import jpcsp.hardware.Model;
import jpcsp.hardware.UMDDrive;
import jpcsp.hardware.Wlan;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceSyscon
extends HLEModule {
    public static Logger log = Modules.getLogger("sceSyscon");
    public static final int PSP_SYSCON_CMD_NOP = 0;
    public static final int PSP_SYSCON_CMD_GET_BARYON = 1;
    public static final int PSP_SYSCON_CMD_GET_DIGITAL_KEY = 2;
    public static final int PSP_SYSCON_CMD_GET_ANALOG = 3;
    public static final int PSP_SYSCON_CMD_GET_DIGITAL_KEY_ANALOG = 6;
    public static final int PSP_SYSCON_CMD_GET_KERNEL_DIGITAL_KEY = 7;
    public static final int PSP_SYSCON_CMD_GET_KERNEL_DIGITAL_KEY_ANALOG = 8;
    public static final int PSP_SYSCON_CMD_READ_CLOCK = 9;
    public static final int PSP_SYSCON_CMD_READ_ALARM = 10;
    public static final int PSP_SYSCON_CMD_GET_POWER_SUPPLY_STATUS = 11;
    public static final int PSP_SYSCON_CMD_GET_TACHYON_WDT_STATUS = 12;
    public static final int PSP_SYSCON_CMD_GET_BATT_VOLT = 13;
    public static final int PSP_SYSCON_CMD_GET_WAKE_UP_FACTOR = 14;
    public static final int PSP_SYSCON_CMD_GET_WAKE_UP_REQ = 15;
    public static final int PSP_SYSCON_CMD_GET_STATUS2 = 16;
    public static final int PSP_SYSCON_CMD_GET_TIMESTAMP = 17;
    public static final int PSP_SYSCON_CMD_GET_VIDEO_CABLE = 18;
    public static final int PSP_SYSCON_CMD_WRITE_CLOCK = 32;
    public static final int PSP_SYSCON_CMD_SET_USB_STATUS = 33;
    public static final int PSP_SYSCON_CMD_WRITE_ALARM = 34;
    public static final int PSP_SYSCON_CMD_WRITE_SCRATCHPAD = 35;
    public static final int PSP_SYSCON_CMD_READ_SCRATCHPAD = 36;
    public static final int PSP_SYSCON_CMD_SEND_SETPARAM = 37;
    public static final int PSP_SYSCON_CMD_RECEIVE_SETPARAM = 38;
    public static final int PSP_SYSCON_CMD_CTRL_BT_POWER_UNK1 = 41;
    public static final int PSP_SYSCON_CMD_CTRL_BT_POWER_UNK2 = 42;
    public static final int PSP_SYSCON_CMD_UNKNOWN_30 = 48;
    public static final int PSP_SYSCON_CMD_CTRL_TACHYON_WDT = 49;
    public static final int PSP_SYSCON_CMD_RESET_DEVICE = 50;
    public static final int PSP_SYSCON_CMD_CTRL_ANALOG_XY_POLLING = 51;
    public static final int PSP_SYSCON_CMD_CTRL_HR_POWER = 52;
    public static final int PSP_SYSCON_CMD_SHUTDOWN_PSP = 53;
    public static final int PSP_SYSCON_CMD_SUSPEND_PSP = 54;
    public static final int PSP_SYSCON_CMD_GET_BATT_VOLT_AD = 55;
    public static final int PSP_SYSCON_CMD_GET_POMMEL_VERSION = 64;
    public static final int PSP_SYSCON_CMD_GET_POLESTAR_VERSION = 65;
    public static final int PSP_SYSCON_CMD_CTRL_VOLTAGE = 66;
    public static final int PSP_SYSCON_CMD_CTRL_POWER = 69;
    public static final int PSP_SYSCON_CMD_GET_POWER_STATUS = 70;
    public static final int PSP_SYSCON_CMD_CTRL_LED = 71;
    public static final int PSP_SYSCON_CMD_WRITE_POMMEL_REG = 72;
    public static final int PSP_SYSCON_CMD_READ_POMMEL_REG = 73;
    public static final int PSP_SYSCON_CMD_CTRL_HDD_POWER = 74;
    public static final int PSP_SYSCON_CMD_CTRL_LEPTON_POWER = 75;
    public static final int PSP_SYSCON_CMD_CTRL_MS_POWER = 76;
    public static final int PSP_SYSCON_CMD_CTRL_WLAN_POWER = 77;
    public static final int PSP_SYSCON_CMD_WRITE_POLESTAR_REG = 78;
    public static final int PSP_SYSCON_CMD_READ_POLESTAR_REG = 79;
    public static final int PSP_SYSCON_CMD_CTRL_DVE_POWER = 82;
    public static final int PSP_SYSCON_CMD_CTRL_BT_POWER = 83;
    public static final int PSP_SYSCON_CMD_CTRL_USB_POWER = 85;
    public static final int PSP_SYSCON_CMD_CTRL_CHARGE = 86;
    public static final int PSP_SYSCON_CMD_BATTERY_NOP = 96;
    public static final int PSP_SYSCON_CMD_BATTERY_GET_STATUS_CAP = 97;
    public static final int PSP_SYSCON_CMD_BATTERY_GET_TEMP = 98;
    public static final int PSP_SYSCON_CMD_BATTERY_GET_VOLT = 99;
    public static final int PSP_SYSCON_CMD_BATTERY_GET_ELEC = 100;
    public static final int PSP_SYSCON_CMD_BATTERY_GET_RCAP = 101;
    public static final int PSP_SYSCON_CMD_BATTERY_GET_CAP = 102;
    public static final int PSP_SYSCON_CMD_BATTERY_GET_FULL_CAP = 103;
    public static final int PSP_SYSCON_CMD_BATTERY_GET_IFC = 104;
    public static final int PSP_SYSCON_CMD_BATTERY_GET_LIMIT_TIME = 105;
    public static final int PSP_SYSCON_CMD_BATTERY_GET_STATUS = 106;
    public static final int PSP_SYSCON_CMD_BATTERY_GET_CYCLE = 107;
    public static final int PSP_SYSCON_CMD_BATTERY_GET_SERIAL = 108;
    public static final int PSP_SYSCON_CMD_BATTERY_GET_INFO = 109;
    public static final int PSP_SYSCON_CMD_BATTERY_GET_TEMP_AD = 110;
    public static final int PSP_SYSCON_CMD_BATTERY_GET_VOLT_AD = 111;
    public static final int PSP_SYSCON_CMD_BATTERY_GET_ELEC_AD = 112;
    public static final int PSP_SYSCON_CMD_BATTERY_GET_TOTAL_ELEC = 113;
    public static final int PSP_SYSCON_CMD_BATTERY_GET_CHARGE_TIME = 114;
    public static final int PSP_SYSCON_CMD_BATTERY_WRITE_EEPROM = 115;
    public static final int PSP_SYSCON_CMD_BATTERY_READ_EEPROM = 116;
    private static String[] cmdNames;
    public static final int PSP_SYSCON_LED_MS = 0;
    public static final int PSP_SYSCON_LED_WLAN = 1;
    public static final int PSP_SYSCON_LED_POWER = 2;
    public static final int PSP_SYSCON_LED_BT = 3;
    public static final int PSP_SYSCON_DEVICE_PSP = 1;
    public static final int PSP_SYSCON_DEVICE_UMD = 2;
    public static final int PSP_SYSCON_DEVICE_WLAN = 4;
    public static final int PSP_SYSCON_DEVICE_BT = 32;
    public static final int PSP_SYSCON_DEVICE_RESET_MODE_2 = 64;
    public static final int PSP_SYSCON_DEVICE_RESET_MODE_1 = 128;
    private final int[] scratchPad = new int[32];
    private int alarm;

    @Override
    public void start() {
        Arrays.fill(this.scratchPad, 0);
        int scratchPad8 = 0;
        int i = 0;
        while (i < 4) {
            this.scratchPad[i + 8] = scratchPad8 & 0xFF;
            ++i;
            scratchPad8 >>= 8;
        }
        int scratchPad12 = 0;
        int i2 = 0;
        while (i2 < 4) {
            this.scratchPad[i2 + 12] = scratchPad12 & 0xFF;
            ++i2;
            scratchPad12 >>= 8;
        }
        long scratchPad16 = sceRtc.hleGetCurrentTick() >> 19;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Initializing scratchPad16=0x%X", scratchPad16));
        }
        int i3 = 0;
        while (i3 < 5) {
            this.scratchPad[i3 + 16] = (int)scratchPad16 & 0xFF;
            ++i3;
            scratchPad16 >>= 8;
        }
        long scratchPad24 = 0L;
        int i4 = 0;
        while (i4 < 5) {
            this.scratchPad[i4 + 24] = (int)scratchPad24 & 0xFF;
            ++i4;
            scratchPad24 >>= 8;
        }
        this.alarm = 0;
        super.start();
    }

    public static String getSysconCmdName(int cmd) {
        if (cmdNames == null) {
            cmdNames = new String[256];
            sceSyscon.cmdNames[0] = "NOP";
            sceSyscon.cmdNames[1] = "GET_BARYON";
            sceSyscon.cmdNames[2] = "GET_DIGITAL_KEY";
            sceSyscon.cmdNames[3] = "GET_ANALOG";
            sceSyscon.cmdNames[6] = "GET_DIGITAL_KEY_ANALOG";
            sceSyscon.cmdNames[7] = "GET_KERNEL_DIGITAL_KEY";
            sceSyscon.cmdNames[8] = "GET_KERNEL_DIGITAL_KEY_ANALOG";
            sceSyscon.cmdNames[9] = "READ_CLOCK";
            sceSyscon.cmdNames[10] = "READ_ALARM";
            sceSyscon.cmdNames[11] = "GET_POWER_SUPPLY_STATUS";
            sceSyscon.cmdNames[12] = "GET_TACHYON_WDT_STATUS";
            sceSyscon.cmdNames[13] = "GET_BATT_VOLT";
            sceSyscon.cmdNames[14] = "GET_WAKE_UP_FACTOR";
            sceSyscon.cmdNames[15] = "GET_WAKE_UP_REQ";
            sceSyscon.cmdNames[16] = "GET_STATUS2";
            sceSyscon.cmdNames[17] = "GET_TIMESTAMP";
            sceSyscon.cmdNames[18] = "GET_VIDEO_CABLE";
            sceSyscon.cmdNames[32] = "WRITE_CLOCK";
            sceSyscon.cmdNames[33] = "SET_USB_STATUS";
            sceSyscon.cmdNames[34] = "WRITE_ALARM";
            sceSyscon.cmdNames[35] = "WRITE_SCRATCHPAD";
            sceSyscon.cmdNames[36] = "READ_SCRATCHPAD";
            sceSyscon.cmdNames[37] = "SEND_SETPARAM";
            sceSyscon.cmdNames[38] = "RECEIVE_SETPARAM";
            sceSyscon.cmdNames[41] = "CTRL_BT_POWER_UNK1";
            sceSyscon.cmdNames[42] = "CTRL_BT_POWER_UNK2";
            sceSyscon.cmdNames[48] = "UNKNOWN_30";
            sceSyscon.cmdNames[49] = "CTRL_TACHYON_WDT";
            sceSyscon.cmdNames[50] = "RESET_DEVICE";
            sceSyscon.cmdNames[51] = "CTRL_ANALOG_XY_POLLING";
            sceSyscon.cmdNames[52] = "CTRL_HR_POWER";
            sceSyscon.cmdNames[53] = "SHUTDOWN_PSP";
            sceSyscon.cmdNames[54] = "SUSPEND_PSP";
            sceSyscon.cmdNames[55] = "GET_BATT_VOLT_AD";
            sceSyscon.cmdNames[64] = "GET_POMMEL_VERSION";
            sceSyscon.cmdNames[65] = "GET_POLESTAR_VERSION";
            sceSyscon.cmdNames[66] = "CTRL_VOLTAGE";
            sceSyscon.cmdNames[69] = "CTRL_POWER";
            sceSyscon.cmdNames[70] = "GET_POWER_STATUS";
            sceSyscon.cmdNames[71] = "CTRL_LED";
            sceSyscon.cmdNames[72] = "WRITE_POMMEL_REG";
            sceSyscon.cmdNames[73] = "READ_POMMEL_REG";
            sceSyscon.cmdNames[74] = "CTRL_HDD_POWER";
            sceSyscon.cmdNames[75] = "CTRL_LEPTON_POWER";
            sceSyscon.cmdNames[76] = "CTRL_MS_POWER";
            sceSyscon.cmdNames[77] = "CTRL_WLAN_POWER";
            sceSyscon.cmdNames[78] = "WRITE_POLESTAR_REG";
            sceSyscon.cmdNames[79] = "READ_POLESTAR_REG";
            sceSyscon.cmdNames[82] = "CTRL_DVE_POWER";
            sceSyscon.cmdNames[83] = "CTRL_BT_POWER";
            sceSyscon.cmdNames[85] = "CTRL_USB_POWER";
            sceSyscon.cmdNames[86] = "CTRL_CHARGE";
            sceSyscon.cmdNames[96] = "BATTERY_NOP";
            sceSyscon.cmdNames[97] = "BATTERY_GET_STATUS_CAP";
            sceSyscon.cmdNames[98] = "BATTERY_GET_TEMP";
            sceSyscon.cmdNames[99] = "BATTERY_GET_VOLT";
            sceSyscon.cmdNames[100] = "BATTERY_GET_ELEC";
            sceSyscon.cmdNames[101] = "BATTERY_GET_RCAP";
            sceSyscon.cmdNames[102] = "BATTERY_GET_CAP";
            sceSyscon.cmdNames[103] = "BATTERY_GET_FULL_CAP";
            sceSyscon.cmdNames[104] = "BATTERY_GET_IFC";
            sceSyscon.cmdNames[105] = "BATTERY_GET_LIMIT_TIME";
            sceSyscon.cmdNames[106] = "BATTERY_GET_STATUS";
            sceSyscon.cmdNames[107] = "BATTERY_GET_CYCLE";
            sceSyscon.cmdNames[108] = "BATTERY_GET_SERIAL";
            sceSyscon.cmdNames[109] = "BATTERY_GET_INFO";
            sceSyscon.cmdNames[110] = "BATTERY_GET_TEMP_AD";
            sceSyscon.cmdNames[111] = "BATTERY_GET_VOLT_AD";
            sceSyscon.cmdNames[112] = "BATTERY_GET_ELEC_AD";
            sceSyscon.cmdNames[113] = "BATTERY_GET_TOTAL_ELEC";
            sceSyscon.cmdNames[114] = "BATTERY_GET_CHARGE_TIME";
            sceSyscon.cmdNames[115] = "BATTERY_WRITE_EEPROM";
            sceSyscon.cmdNames[116] = "BATTERY_READ_EEPROM";
            for (int i = 0; i < cmdNames.length; ++i) {
                if (cmdNames[i] != null) continue;
                sceSyscon.cmdNames[i] = String.format("UNKNOWN_CMD_0x%02X", i);
            }
        }
        return cmdNames[cmd];
    }

    public int getPowerSupplyStatus() {
        int powerSupplyStatus = 192;
        if (Battery.isPresent()) {
            powerSupplyStatus |= 2;
        }
        return powerSupplyStatus;
    }

    private int getBatteryStatusCap() {
        return (Battery.getCurrentPowerPercent() + 1) * 65536 / 16 + 2048;
    }

    public int getBatteryStatusCap1() {
        return this.getBatteryStatusCap() & 0xFFFF;
    }

    public int getBatteryStatusCap2() {
        return this.getBatteryStatusCap() >> 16 & 0xFFFF;
    }

    public int getBatteryCycle() {
        return 0;
    }

    public int getBatteryLimitTime() {
        return 0;
    }

    public int getBatteryElec() {
        return 0;
    }

    public int getPowerStatus() {
        return 0;
    }

    public int[] getTimeStamp() {
        return new int[12];
    }

    public void readScratchpad(int src, int[] values, int size) {
        System.arraycopy(this.scratchPad, src, values, 0, size);
    }

    public void writeScratchpad(int dst, int[] src, int size) {
    }

    public int readClock() {
        return 0;
    }

    public void writeClock(int clock) {
    }

    public int readAlarm() {
        return this.alarm;
    }

    public void writeAlarm(int alarm) {
        this.alarm = alarm;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1346661349, version=150)
    public int sceSysconSetWlanSwitchCallback(TPointer callback, int argp) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=369460351, version=150)
    public boolean sceSysconIsLowBattery() {
        return Battery.getCurrentPowerPercent() <= Battery.getLowPercent();
    }

    @HLEFunction(nid=760283492, version=150)
    public int sceSysconGetWlanSwitch() {
        return Wlan.getSwitchState();
    }

    @HLEFunction(nid=189915981, version=150)
    public int sceSysconSetWlanSwitch(int switchState) {
        int oldSwitchState = Wlan.getSwitchState();
        Wlan.setSwitchState(switchState);
        return oldSwitchState;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1212449651, version=150)
    public int sceSysconCtrlWlanPower(boolean power) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1914081663, version=150)
    public int sceSysconGetWlanPowerStatus() {
        return 1;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1448152161, version=150), @HLEFunction(nid=-1651988258, version=660)})
    public int sceSysconGetWakeUpReq(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 req) {
        return 0;
    }

    @HLEFunction(nid=-44279605, version=150)
    public int _sceSysconGetBaryonVersion() {
        return Model.getBaryonVersion();
    }

    @HLEFunction(nid=2126883159, version=150)
    public int sceSysconGetBaryonVersion(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 baryonVersionAddr) {
        baryonVersionAddr.setValue(Model.getBaryonVersion());
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1933805177, version=150)
    public int sceSysconResetDevice(int device, int reset) {
        return 0;
    }

    @HLEFunction(nid=1987186747, version=150)
    public boolean sceSysconGetMsPowerCtrl() {
        return MemoryStick.hasMsPower();
    }

    @HLEUnimplemented
    @HLEFunction(nid=277392296, version=150)
    public int sceSysconCtrlMsPower(boolean power) {
        MemoryStick.setMsPower(power);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1467766641, version=660)
    public boolean sceSysconGetLeptonPowerCtrl() {
        return UMDDrive.hasUmdPower();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1975182859, version=660)
    public int sceSysconCtrlLeptonPower(boolean power) {
        UMDDrive.setUmdPower(power);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1536871575, version=150)
    public int sceSysconCmdExec(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=96, usage=BufferInfo.Usage.inout) TPointer packet, int flags) {
        byte cmd = packet.getValue8(12);
        byte len = packet.getValue8(13);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceSysconCmdExec cmd=0x%02X, len=0x%02X, txData: %s", cmd, (int)len, Utilities.getMemoryDump(packet.getAddress() + 14, len - 2)));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=985911972, version=150)
    public int sceSysconCmdExecAsync(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=96, usage=BufferInfo.Usage.inout) TPointer packet, int flags, TPointer callback, int argp) {
        byte cmd = packet.getValue8(12);
        byte len = packet.getValue8(13);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceSysconCmdExecAsync cmd=0x%02X, len=0x%02X, txData: %s", cmd, (int)len, Utilities.getMemoryDump(packet.getAddress() + 14, len - 2)));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2076991150, version=150)
    public int sceSysconGetTimeStamp(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=12, usage=BufferInfo.Usage.out) TPointer timeStampAddr) {
        int[] timeStamp = this.getTimeStamp();
        for (int i = 0; i < timeStamp.length; ++i) {
            timeStampAddr.setValue8(i, (byte)timeStamp[i]);
        }
        return 0;
    }

    @HLEFunction(nid=-404195519, version=150)
    public int sceSysconGetPommelVersion(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 pommelAddr) {
        pommelAddr.setValue(Model.getPommelVersion());
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=674643095, version=150)
    public int sceSysconGetPowerStatus(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 statusAddr) {
        statusAddr.setValue(this.getPowerStatus());
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-349733752, version=150)
    public int sceSysconReadScratchPad(int src, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.out) TPointer dst, int size) {
        int[] values = new int[size];
        this.readScratchpad(src, values, size);
        for (int i = 0; i < this.scratchPad.length; ++i) {
            dst.setValue8(i, (byte)values[i]);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1709924502, version=150)
    public int sceSysconWriteScratchPad(int dst, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.out) TPointer src, int size) {
        int[] values = new int[size];
        for (int i = 0; i < size; ++i) {
            values[i] = src.getValue8(i);
        }
        this.writeScratchpad(dst, values, size);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=415219301, version=150)
    public int sceSysconCtrlLED(int led, boolean state) {
        switch (led) {
            case 0: {
                LED.setLedMemoryStickOn(state);
                break;
            }
            case 1: {
                LED.setLedWlanOn(state);
                break;
            }
            case 2: {
                LED.setLedPowerOn(state);
                break;
            }
            case 3: {
                LED.setLedBluetoothOn(state);
                break;
            }
            default: {
                return -2147483390;
            }
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=136531565, version=150)
    public int sceSysconReceiveSetParam(int id, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=8, usage=BufferInfo.Usage.out) TPointer param) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1725160766, version=150)
    public int sceSysconSendSetParam(int id, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=8, usage=BufferInfo.Usage.in) TPointer param) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1145280004, version=150), @HLEFunction(nid=-1150132024, version=660)})
    public int sceSysconCtrlHRPower(boolean power) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-63826918, version=150), @HLEFunction(nid=572787521, version=660)})
    public int sceSysconGetPowerSupplyStatus(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 statusAddr) {
        statusAddr.setValue(this.getPowerSupplyStatus());
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1783886840, version=150), @HLEFunction(nid=-2047478271, version=660)})
    public int sceSysconBatteryGetStatusCap(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 unknown1, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 unknown2) {
        unknown1.setValue(this.getBatteryStatusCap1());
        unknown2.setValue(this.getBatteryStatusCap2());
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1897094525, version=150), @HLEFunction(nid=1283922922, version=660)})
    public int sceSysconBatteryGetFullCap(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 capAddr) {
        capAddr.setValue(Battery.getFullCapacity());
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1257218735, version=150), @HLEFunction(nid=1756305905, version=660)})
    public int sceSysconBatteryGetCycle(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 cycleAddr) {
        cycleAddr.setValue(this.getBatteryCycle());
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=676324198, version=150), @HLEFunction(nid=1297750459, version=660)})
    public int sceSysconBatteryGetLimitTime(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 timeAddr) {
        timeAddr.setValue(this.getBatteryLimitTime());
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1891700321, version=150), @HLEFunction(nid=-829725133, version=660)})
    public int sceSysconBatteryGetTemp(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 tempAddr) {
        tempAddr.setValue(Battery.getTemperature());
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=926861619, version=150), @HLEFunction(nid=1211140272, version=660)})
    public int sceSysconBatteryGetElec(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 elecAddr) {
        elecAddr.setValue(this.getBatteryElec());
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1948337378, version=150), @HLEFunction(nid=-1478806341, version=660)})
    public int sceSysconBatteryGetVolt(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 voltAddr) {
        voltAddr.setValue(Battery.getVoltage());
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-992580579, version=150), @HLEFunction(nid=-197739758, version=660)})
    public int sceSysconReadClock(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 clockAddr) {
        clockAddr.setValue(this.readClock());
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=2055233252, version=150), @HLEFunction(nid=-223449762, version=660)})
    public int sceSysconReadAlarm(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 alarmAddr) {
        alarmAddr.setValue(this.readAlarm());
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1821448002, version=150), @HLEFunction(nid=-2140072587, version=660)})
    public int sceSysconWriteAlarm(int alarm) {
        this.writeAlarm(alarm);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-424194887, version=150)
    public int sceSysconNop() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1386914587, version=150), @HLEFunction(nid=1503574176, version=660)})
    public int sceSysconSetLowBatteryCallback(TPointer callback, int callbackArgument) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1556061929, version=150)
    public boolean sceSysconIsAcSupplied() {
        return true;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-448731854, version=150), @HLEFunction(nid=1702743799, version=660)})
    public int sceSysconSetAcSupplyCallback(TPointer callback, int callbackArgument) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1104675226, version=150), @HLEFunction(nid=-304895093, version=660)})
    public int sceSysconCtrlPower(int unknown1, int unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=23560081, version=150), @HLEFunction(nid=-138620250, version=660)})
    public int sceSysconCtrlVoltage(int unknown1, int unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-522322408, version=150), @HLEFunction(nid=762259240, version=660)})
    public int sceSysconGetHPConnect() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=786965650, version=150)
    public int sceSysconCtrlTachyonWDT(int wdt) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-143279052, version=150), @HLEFunction(nid=-214033644, version=660)})
    public int sceSysconGetWakeUpFactor(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 factor) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1913192216, version=661)
    public int sceSysconCtrlBtPower(boolean power) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1985443307, version=661)
    public int sceSyscon_driver_765775EB(boolean power) {
        return 0;
    }
}

