/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEFunctions;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.kernel.types.pspUmdInfo;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.NIDMapper;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.scheduler.Scheduler;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceUmdUser
extends HLEModule {
    public static Logger log = Modules.getLogger("sceUmdUser");
    private boolean umdAllowReplace;
    protected static final int PSP_UMD_INIT = 0;
    protected static final int PSP_UMD_NOT_PRESENT = 1;
    protected static final int PSP_UMD_PRESENT = 2;
    protected static final int PSP_UMD_CHANGED = 4;
    protected static final int PSP_UMD_NOT_READY = 8;
    protected static final int PSP_UMD_READY = 16;
    protected static final int PSP_UMD_READABLE = 32;
    protected UmdIsoReader iso;
    protected boolean umdActivated;
    protected boolean umdDeactivateCalled;
    protected List<SceKernelThreadInfo> waitingThreads;
    protected int umdErrorStat;
    protected UmdWaitStateChecker umdWaitStateChecker;

    @Override
    public void start() {
        this.setUmdActivated();
        this.umdDeactivateCalled = false;
        this.waitingThreads = new LinkedList<SceKernelThreadInfo>();
        this.umdErrorStat = 0;
        this.umdWaitStateChecker = new UmdWaitStateChecker();
        this.setUmdAllowReplace(false);
        super.start();
    }

    public void setIsoReader(UmdIsoReader iso) {
        this.iso = iso;
        this.setUmdActivated();
    }

    public UmdIsoReader getIsoReader() {
        return this.iso;
    }

    public void setUmdErrorStat(int stat) {
        this.umdErrorStat = stat;
    }

    public int getUmdErrorStat() {
        return this.umdErrorStat;
    }

    private void setUmdActivated() {
        this.umdActivated = this.iso != null;
        Modules.IoFileMgrForUserModule.registerUmdIso();
    }

    public boolean isUmdActivated() {
        return this.umdActivated;
    }

    public int getUmdStat() {
        int stat;
        if (this.iso != null) {
            stat = 18;
            if (this.umdActivated) {
                stat |= 0x20;
            }
        } else {
            stat = 1;
            if (this.umdDeactivateCalled) {
                stat |= 8;
            }
        }
        return stat;
    }

    public int checkWantedStat(int wantedStat) {
        if ((wantedStat & 0x3B) == 0) {
            throw new SceKernelErrorException(-2147418090);
        }
        return wantedStat;
    }

    protected boolean checkDriveStat(int wantedStat) {
        int currentStat = this.getUmdStat();
        return (currentStat & wantedStat) != 0;
    }

    protected void removeWaitingThread(SceKernelThreadInfo thread) {
        ListIterator<SceKernelThreadInfo> lit = this.waitingThreads.listIterator();
        while (lit.hasNext()) {
            SceKernelThreadInfo waitingThread = lit.next();
            if (waitingThread.uid != thread.uid) continue;
            lit.remove();
            break;
        }
    }

    public void onThreadWaitTimeout(SceKernelThreadInfo thread) {
        log.info((Object)"UMD stat timedout");
        this.removeWaitingThread(thread);
        thread.cpuContext._v0 = -2147352152;
    }

    public void onThreadWaitReleased(SceKernelThreadInfo thread) {
        log.info((Object)"UMD stat released");
        this.removeWaitingThread(thread);
        thread.cpuContext._v0 = -2147352150;
    }

    public void onThreadDeleted(SceKernelThreadInfo thread) {
        if (thread.waitType == 257) {
            this.removeWaitingThread(thread);
        }
    }

    protected void checkWaitingThreads() {
        ListIterator<SceKernelThreadInfo> lit = this.waitingThreads.listIterator();
        while (lit.hasNext()) {
            SceKernelThreadInfo waitingThread = lit.next();
            if (waitingThread.status != 4) continue;
            int wantedUmdStat = waitingThread.wait.wantedUmdStat;
            if (waitingThread.waitType != 257 || !this.checkDriveStat(wantedUmdStat)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("sceUmdUser - checkWaitingThreads waking " + Integer.toHexString(waitingThread.uid) + " thread:'" + waitingThread.name + "'"));
            }
            lit.remove();
            waitingThread.cpuContext._v0 = 0;
            Modules.ThreadManForUserModule.hleChangeThreadState(waitingThread, 2);
        }
    }

    protected int hleUmdWaitDriveStat(int wantedStat, boolean doCallbacks, boolean doTimeout, int timeout) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        if (!this.checkDriveStat(wantedStat)) {
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            currentThread.wait.wantedUmdStat = wantedStat;
            this.waitingThreads.add(currentThread);
            threadMan.hleKernelThreadEnterWaitState(currentThread, 257, -1, this.umdWaitStateChecker, timeout, !doTimeout, doCallbacks);
        }
        threadMan.hleRescheduleCurrentThread(doCallbacks);
        return 0;
    }

    protected int getNotificationArg() {
        return this.getNotificationArg(this.iso != null);
    }

    protected int getNotificationArg(boolean umdPresent) {
        int notifyArg;
        if (umdPresent) {
            notifyArg = 34;
            if (Modules.SysMemUserForUserModule.hleKernelGetCompiledSdkVersion() != 0) {
                notifyArg |= 0x10;
            }
        } else {
            notifyArg = 9;
        }
        return notifyArg;
    }

    public boolean isUmdAllowReplace() {
        return this.umdAllowReplace;
    }

    private void setUmdAllowReplace(boolean umdAllowReplace) {
        this.umdAllowReplace = umdAllowReplace;
        Emulator.getMainGUI().onUmdChange();
    }

    public void hleUmdSwitch(UmdIsoReader newIso) {
        Scheduler scheduler = Scheduler.getInstance();
        long delayedUmdSwitchSchedule = Scheduler.getNow();
        if (this.iso != null) {
            scheduler.addAction(new DelayedUmdRemoved());
            delayedUmdSwitchSchedule += 100000L;
        }
        scheduler.addAction(delayedUmdSwitchSchedule, new DelayedUmdSwitch(newIso));
    }

    protected void hleDelayedUmdRemoved() {
        int notifyArg = this.getNotificationArg(false);
        Modules.ThreadManForUserModule.hleKernelNotifyCallback(0, notifyArg);
    }

    protected void hleDelayedUmdSwitch(UmdIsoReader iso) {
        Modules.IoFileMgrForUserModule.setIsoReader(iso);
        this.setIsoReader(iso);
        int notifyArg = this.getNotificationArg() | 4;
        Modules.ThreadManForUserModule.hleKernelNotifyCallback(0, notifyArg);
    }

    @HLEFunction(nid=1189852969, version=150)
    public boolean sceUmdCheckMedium() {
        return this.iso != null;
    }

    @HLEFunction(nid=-971489977, version=150, checkInsideInterrupt=true)
    public int sceUmdActivate(int mode, PspString drive) {
        this.umdActivated = true;
        Modules.IoFileMgrForUserModule.registerUmdIso();
        int notifyArg = this.getNotificationArg();
        Modules.ThreadManForUserModule.hleKernelNotifyCallback(0, notifyArg);
        this.checkWaitingThreads();
        int sceIoAssign = NIDMapper.getInstance().getAddressByName("sceIoAssign");
        if (sceIoAssign != 0) {
            SysMemUserForUser.SysMemInfo memInfo = Modules.SysMemUserForUserModule.malloc(1, "sceUmdActivate", 0, 32, 0);
            int argAddr = memInfo.addr;
            int umdAddr = memInfo.addr + 4;
            int isofsAddr = memInfo.addr + 10;
            Memory mem = Memory.getInstance();
            Utilities.writeStringZ(mem, umdAddr, "umd0:");
            Utilities.writeStringZ(mem, isofsAddr, "isofs0:");
            mem.write32(argAddr, 1);
            SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
            Modules.ThreadManForUserModule.executeCallback(thread, sceIoAssign, null, false, drive.getAddress(), umdAddr, isofsAddr, 1, argAddr, 4);
        }
        return 0;
    }

    @HLEFunction(nid=-399031622, version=150, checkInsideInterrupt=true)
    public int sceUmdDeactivate(int mode, PspString drive) {
        boolean triggerCallback = this.umdActivated;
        this.umdActivated = false;
        Modules.IoFileMgrForUserModule.registerUmdIso();
        this.umdDeactivateCalled = true;
        if (triggerCallback) {
            int notifyArg = this.iso != null ? 18 : 9;
            Modules.ThreadManForUserModule.hleKernelNotifyCallback(0, notifyArg);
        }
        this.checkWaitingThreads();
        return 0;
    }

    @HLEFunction(nid=-1896837170, version=150, checkInsideInterrupt=true)
    public int sceUmdWaitDriveStat(@CheckArgument(value="checkWantedStat") int wantedStat) {
        return this.hleUmdWaitDriveStat(wantedStat, false, false, 0);
    }

    @HLEFunction(nid=1444948339, version=150, checkInsideInterrupt=true)
    public int sceUmdWaitDriveStatWithTimer(@CheckArgument(value="checkWantedStat") int wantedStat, int timeout) {
        return this.hleUmdWaitDriveStat(wantedStat, false, true, timeout);
    }

    @HLEFunction(nid=1251892777, version=150, checkInsideInterrupt=true)
    public int sceUmdWaitDriveStatCB(@CheckArgument(value="checkWantedStat") int wantedStat, int timeout) {
        return this.hleUmdWaitDriveStat(wantedStat, true, true, timeout);
    }

    @HLEFunction(nid=1794749706, version=150)
    public int sceUmdCancelWaitDriveStat() {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        ListIterator<SceKernelThreadInfo> lit = this.waitingThreads.listIterator();
        while (lit.hasNext()) {
            SceKernelThreadInfo waitingThread = lit.next();
            if (!waitingThread.isWaiting() || waitingThread.waitType != 257) {
                log.warn((Object)String.format("sceUmdCancelWaitDriveStat thread %s not waiting on umd", waitingThread));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceUmdCancelWaitDriveStat waking thread %s", waitingThread));
            }
            lit.remove();
            waitingThread.cpuContext._v0 = -2147352151;
            threadMan.hleChangeThreadState(waitingThread, 2);
        }
        return 0;
    }

    @HLEFunction(nid=1800017004, version=150)
    public int sceUmdGetDriveStat() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceUmdGetDriveStat returning 0x%X", this.getUmdStat()));
        }
        return this.getUmdStat();
    }

    @HLEFunction(nid=543329903, version=150)
    public int sceUmdGetErrorStat() {
        return this.getUmdErrorStat();
    }

    @HLEFunction(nid=873166470, version=150, checkInsideInterrupt=true)
    public int sceUmdGetDiscInfo(TPointer pspUmdInfoAddr) {
        pspUmdInfo umdInfo = new pspUmdInfo();
        umdInfo.read(pspUmdInfoAddr);
        if (umdInfo.sizeof() != 8) {
            return -2147418090;
        }
        umdInfo.type = 16;
        umdInfo.write(pspUmdInfoAddr);
        return 0;
    }

    @HLEFunction(nid=-1360576435, version=150, checkInsideInterrupt=true)
    public int sceUmdRegisterUMDCallBack(int uid) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        if (!threadMan.hleKernelRegisterCallback(0, uid)) {
            return -1;
        }
        return 0;
    }

    @HLEFunction(nid=-1121198585, version=150)
    public int sceUmdUnRegisterUMDCallBack(int uid) {
        if (!Modules.ThreadManForUserModule.hleKernelUnRegisterCallback(0, uid)) {
            return -1;
        }
        return 0;
    }

    @HLEFunction(nid=-2024588992, version=200)
    public int sceUmdReplaceProhibit() {
        if ((this.getUmdStat() & 0x10) != 16 || (this.getUmdStat() & 0x20) != 32) {
            return -2145320959;
        }
        this.setUmdAllowReplace(false);
        return 0;
    }

    @HLEFunction(nid=-873861078, version=200)
    public int sceUmdReplacePermit() {
        this.setUmdAllowReplace(true);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=348570716, version=660)
    public int sceUmdUnuseUMDInMsUsbWlan() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1325139400, version=660)
    public int sceUmdUseUMDInMsUsbWlan() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2123471509, version=660)
    public void sceUmdSetSuspendResumeMode(int mode) {
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1986307007, version=660)
    public int sceUmdGetSuspendResumeMode() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-732094490, version=150), @HLEFunction(nid=-1212199887, version=660)})
    public int sceUmdGetDriveStatus() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=587622115, version=150), @HLEFunction(nid=-1742572802, version=660)})
    public int sceUmdSetDriveStatus(int state) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1370235859, version=150), @HLEFunction(nid=1860130801, version=660)})
    public int sceUmdClearDriveStatus(int state) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=67793040, version=660)
    public int sceUmd_040A7090(int errorCode) {
        return errorCode;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=2018570327, version=150), @HLEFunction(nid=1223657100, version=660)})
    public int sceUmdRegisterGetUMDInfoCallBack(TPointer callback, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.variableLength, usage=BufferInfo.Usage.out) TPointer discInfoAddr) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1666284730, version=150)
    public int sceUmd_63517CBA(TPointer callback, int callbackArg) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=141417485, version=150), @HLEFunction(nid=-1693492786, version=660)})
    public int sceUmdRegisterActivateCallBack(TPointer callback, int callbackArg) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=763449485, version=150), @HLEFunction(nid=-775418287, version=660)})
    public int sceUmdRegisterDeactivateCallBack(TPointer callback, int callbackArg) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1211280371, version=150), @HLEFunction(nid=927515867, version=660)})
    public int sceUmdRegisterReplaceCallBack(TPointer callback) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1993561849, version=660)
    public int sceUmd_76D356F9(TPointer callback) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-346683010, version=150), @HLEFunction(nid=-1521415715, version=660)})
    public int sceUmdGetDetectUMDCallBackId() {
        return 0;
    }

    private static class DelayedUmdRemoved
    implements IAction {
        private DelayedUmdRemoved() {
        }

        @Override
        public void execute() {
            Modules.sceUmdUserModule.hleDelayedUmdSwitch(null);
        }
    }

    private static class DelayedUmdSwitch
    implements IAction {
        private UmdIsoReader iso;

        public DelayedUmdSwitch(UmdIsoReader iso) {
            this.iso = iso;
        }

        @Override
        public void execute() {
            Modules.sceUmdUserModule.hleDelayedUmdSwitch(this.iso);
        }
    }

    protected class UmdWaitStateChecker
    implements IWaitStateChecker {
        protected UmdWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            if (sceUmdUser.this.checkDriveStat(wait.wantedUmdStat)) {
                sceUmdUser.this.waitingThreads.remove(thread);
                thread.cpuContext._v0 = 0;
                return false;
            }
            return true;
        }
    }
}

