/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer16;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SystemTimeManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceNetIfHandle;
import jpcsp.HLE.kernel.types.SceNetIfMessage;
import jpcsp.HLE.kernel.types.SceNetWlanMessage;
import jpcsp.HLE.kernel.types.SceNetWlanScanInfo;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.sceNetAdhoc;
import jpcsp.HLE.modules.sceNetInet;
import jpcsp.Memory;
import jpcsp.NIDMapper;
import jpcsp.hardware.Wlan;
import jpcsp.network.accesspoint.AccessPoint;
import jpcsp.network.accesspoint.IAccessPointCallback;
import jpcsp.network.protocols.EtherFrame;
import jpcsp.scheduler.Scheduler;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceWlan
extends HLEModule
implements IAccessPointCallback {
    public static Logger log = Modules.getLogger("sceWlan");
    public static final int IOCTL_CMD_UNKNOWN_0x2 = 2;
    public static final int IOCTL_CMD_START_SCANNING = 52;
    public static final int IOCTL_CMD_CREATE = 53;
    public static final int IOCTL_CMD_CONNECT = 54;
    public static final int IOCTL_CMD_GET_INFO = 55;
    public static final int IOCTL_CMD_DISCONNECT = 56;
    public static final int IOCTL_CMD_UNKNOWN_0x42 = 66;
    public static final int IOCTL_CMD_ENTER_GAME_MODE = 68;
    public static final int IOCTL_CMD_SET_WEP_KEY = 71;
    public static final int WLAN_MODE_INFRASTRUCTURE = 1;
    public static final int WLAN_MODE_ADHOC = 2;
    private static int wlanSocketPort = 30010;
    private static final int wlanThreadPollingDelayUs = 12000;
    private static final int wlanScanActionDelayUs = 50000;
    private static final int wlanConnectActionDelayUs = 50000;
    private static final int wlanCreateActionDelayUs = 50000;
    private static final int wlanDisconnectActionDelayUs = 50000;
    public static final byte WLAN_CMD_DATA = 0;
    public static final byte WLAN_CMD_SCAN_REQUEST = 1;
    public static final byte WLAN_CMD_SCAN_RESPONSE = 2;
    private static final byte[] dummyOtherMacAddress = new byte[]{16, 34, 51, 68, 85, 102};
    private static final int[] channels = new int[]{1, 6, 11};
    private int joinedChannel;
    private int dummyMessageStep;
    private TPointer dummyMessageHandleAddr;
    private DatagramSocket wlanSocket;
    private TPointer wlanHandleAddr;
    private int wlanThreadUid;
    private int unknownValue1;
    private int unknownValue2;
    private int unknownValue3;
    private boolean isGameMode;
    private List<pspNetMacAddress> activeMacAddresses;
    private List<GameModeState> gameModeStates;
    private int gameModeDataLength;
    private String[] channelSSIDs;
    private int[] channelModes;
    private int wlanDropRate;
    private int wlanDropDuration;
    private AccessPoint accessPoint;

    @Override
    public void start() {
        this.wlanThreadUid = Integer.MIN_VALUE;
        this.dummyMessageStep = -1;
        this.activeMacAddresses = new LinkedList<pspNetMacAddress>();
        this.gameModeStates = new LinkedList<GameModeState>();
        this.gameModeDataLength = 256;
        int maxChannel = -1;
        for (int i = 0; i < channels.length; ++i) {
            maxChannel = Math.max(maxChannel, channels[i]);
        }
        this.channelSSIDs = new String[maxChannel + 1];
        this.channelModes = new int[maxChannel + 1];
        this.joinedChannel = -1;
        super.start();
    }

    public void hleWlanThread() {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("hleWlanThread isGameMode=%b", this.isGameMode));
        }
        if (this.wlanThreadMustExit()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Exiting hleWlanThread %s", Modules.ThreadManForUserModule.getCurrentThread()));
            }
            Modules.ThreadManForUserModule.hleKernelExitDeleteThread(0);
            return;
        }
        if (this.isGameMode) {
            this.hleWlanSendGameMode();
        }
        while (!this.wlanThreadMustExit() && this.hleWlanReceive()) {
        }
        if (this.dummyMessageStep > 0) {
            sceWlan.sendDummyMessage(this.dummyMessageStep, this.dummyMessageHandleAddr);
            this.dummyMessageStep = 0;
        }
        Modules.ThreadManForUserModule.hleKernelDelayThread(12000, true);
    }

    private boolean wlanThreadMustExit() {
        return this.wlanThreadUid != Modules.ThreadManForUserModule.getCurrentThreadID();
    }

    private void hleWlanScanAction(TPointer handleAddr, TPointer inputAddr, TPointer outputAddr, WlanScanAction action, int callCount) {
        byte[] scanRequestPacket = new byte[7];
        scanRequestPacket[0] = 1;
        System.arraycopy(Wlan.getMacAddress(), 0, scanRequestPacket, 1, 6);
        this.sendPacket(scanRequestPacket, scanRequestPacket.length);
        while (this.hleWlanReceive()) {
        }
        if (callCount < 20) {
            Emulator.getScheduler().addAction(Scheduler.getNow() + 50000L, action);
        } else {
            byte channel;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("End of scan action:", new Object[0]));
                for (int ch : channels) {
                    log.debug((Object)String.format("Scan result channel#%d, ssid='%s', mode=%d", ch, this.channelSSIDs[ch], this.channelModes[ch]));
                }
            }
            TPointer addr = new TPointer(outputAddr);
            for (int i = 0; i < 14 && (channel = inputAddr.getValue8(10 + i)) != 0; ++i) {
                String ssid;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Scan on channel %d", channel));
                }
                if (!this.isValidChannel(channel) || (ssid = this.channelSSIDs[channel]) == null || ssid.length() <= 0) continue;
                SceNetWlanScanInfo scanInfo = new SceNetWlanScanInfo();
                scanInfo.bssid = "Jpcsp";
                scanInfo.channel = channel;
                scanInfo.ssid = ssid;
                scanInfo.mode = this.channelModes[channel];
                scanInfo.beaconInterval = 1000;
                scanInfo.write(addr.getMemory(), addr.getAddress() + 4);
                addr.setValue32(0, addr.getAddress() + 4 + scanInfo.sizeof());
                addr.add(4 + scanInfo.sizeof());
            }
            if (addr.getAddress() > outputAddr.getAddress()) {
                addr.setValue32(-96, 0);
            }
            SceNetIfHandle handle = new SceNetIfHandle();
            handle.read(handleAddr);
            Modules.ThreadManForUserModule.sceKernelSignalSema(handle.handleInternal.ioctlSemaId, 1);
        }
    }

    private void hleWlanConnectAction(TPointer handleAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanConnectAction handleAddr=%s", handleAddr));
        }
        SceNetIfHandle handle = new SceNetIfHandle();
        handle.read(handleAddr);
        Modules.ThreadManForUserModule.sceKernelSignalSema(handle.handleInternal.ioctlSemaId, 1);
    }

    private void hleWlanCreateAction(TPointer handleAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanCreateAction handleAddr=%s", handleAddr));
        }
        SceNetIfHandle handle = new SceNetIfHandle();
        handle.read(handleAddr);
        Modules.ThreadManForUserModule.sceKernelSignalSema(handle.handleInternal.ioctlSemaId, 1);
    }

    private void hleWlanDisconnectAction(TPointer handleAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanDisconnectAction handleAddr=%s", handleAddr));
        }
        SceNetIfHandle handle = new SceNetIfHandle();
        handle.read(handleAddr);
        Modules.ThreadManForUserModule.sceKernelSignalSema(handle.handleInternal.ioctlSemaId, 1);
    }

    private boolean hleWlanReceive() {
        if (this.isGameMode) {
            return this.hleWlanReceiveGameMode();
        }
        return this.hleWlanReceiveMessage();
    }

    private boolean createWlanSocket() {
        if (this.wlanSocket == null) {
            boolean retry;
            do {
                retry = false;
                try {
                    this.wlanSocket = new DatagramSocket(wlanSocketPort);
                    this.wlanSocket.setBroadcast(true);
                    this.wlanSocket.setSoTimeout(1);
                }
                catch (BindException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("createWlanSocket port %d already in use (%s) - retrying with port %d", wlanSocketPort, e, wlanSocketPort + 1));
                    }
                    ++wlanSocketPort;
                    retry = true;
                }
                catch (SocketException e) {
                    log.error((Object)"createWlanSocket", (Throwable)e);
                }
            } while (retry);
        }
        return this.wlanSocket != null;
    }

    public static int getSocketPort() {
        return wlanSocketPort;
    }

    @Override
    public void sendPacketFromAccessPoint(byte[] buffer, int bufferLength, EtherFrame etherFrame) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sendAccessPointPacket %s", Utilities.getMemoryDump(buffer, 0, bufferLength)));
        }
        try {
            InetSocketAddress[] broadcastAddress = sceNetInet.getBroadcastInetSocketAddress(sceWlan.getSocketPort());
            if (broadcastAddress != null) {
                for (int i = 0; i < broadcastAddress.length; ++i) {
                    DatagramPacket packet = new DatagramPacket(buffer, bufferLength, broadcastAddress[i]);
                    this.wlanSocket.send(packet);
                }
            }
        }
        catch (UnknownHostException e) {
            log.error((Object)"sendAccessPointPacket", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"sendAccessPointPacket", (Throwable)e);
        }
    }

    private int getBroadcastPort(int channel) {
        if (channel >= 0 && this.channelModes[channel] == 1) {
            return this.accessPoint.getPort();
        }
        return wlanSocketPort ^ 1;
    }

    protected void sendPacket(byte[] buffer, int bufferLength) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sendPacket %s", Utilities.getMemoryDump(buffer, 0, bufferLength)));
        }
        try {
            InetSocketAddress[] broadcastAddress = sceNetInet.getBroadcastInetSocketAddress(this.getBroadcastPort(this.joinedChannel));
            if (broadcastAddress != null) {
                for (int i = 0; i < broadcastAddress.length; ++i) {
                    DatagramPacket packet = new DatagramPacket(buffer, bufferLength, broadcastAddress[i]);
                    this.wlanSocket.send(packet);
                }
            }
        }
        catch (UnknownHostException e) {
            log.error((Object)"sendPacket", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"sendPacket", (Throwable)e);
        }
    }

    protected void sendDataPacket(byte[] buffer, int bufferLength) {
        byte[] packetBuffer = new byte[bufferLength + 1 + 32];
        int offset = 0;
        packetBuffer[offset] = 0;
        ++offset;
        if (this.joinedChannel >= 0) {
            Utilities.writeStringNZ(packetBuffer, offset, 32, this.channelSSIDs[this.joinedChannel]);
        }
        System.arraycopy(buffer, 0, packetBuffer, offset += 32, bufferLength);
        this.sendPacket(packetBuffer, offset += bufferLength);
    }

    private GameModeState getGameModeStat(byte[] macAddress) {
        GameModeState myGameModeState = null;
        for (GameModeState gameModeState : this.gameModeStates) {
            if (!gameModeState.macAddress.equals(macAddress)) continue;
            myGameModeState = gameModeState;
            break;
        }
        return myGameModeState;
    }

    private GameModeState getMyGameModeState() {
        return this.getGameModeStat(Wlan.getMacAddress());
    }

    private void addActiveMacAddress(pspNetMacAddress macAddress) {
        if (!sceNetAdhoc.isAnyMacAddress(macAddress.macAddress) && !this.activeMacAddresses.contains(macAddress)) {
            this.activeMacAddresses.add(macAddress);
            this.gameModeStates.add(new GameModeState(macAddress));
        }
    }

    private boolean isValidChannel(int channel) {
        for (int i = 0; i < channels.length; ++i) {
            if (channels[i] != channel) continue;
            return true;
        }
        return false;
    }

    private void setChannelSSID(int channel, String ssid, int mode) {
        if (ssid != null && ssid.length() > 0 && this.isValidChannel(channel)) {
            this.channelSSIDs[channel] = ssid;
            this.channelModes[channel] = mode;
        }
    }

    private void joinChannelSSID(int channel, String ssid, int mode) {
        this.setChannelSSID(channel, ssid, mode);
        this.joinedChannel = channel;
    }

    private void processCmd(byte cmd, byte[] buffer, int offset, int length) {
        byte[] packetMacAddress = new byte[6];
        System.arraycopy(buffer, offset, packetMacAddress, 0, 6);
        offset += 6;
        length -= 6;
        byte[] myMacAddress = Wlan.getMacAddress();
        boolean macAddressEqual = true;
        for (int i = 0; i < 6; ++i) {
            if (packetMacAddress[i] == myMacAddress[i]) continue;
            macAddressEqual = false;
            break;
        }
        if (macAddressEqual) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Ignoring packet coming from myself", new Object[0]));
            }
            return;
        }
        if (cmd == 1) {
            byte[] scanResponse = new byte[7 + 34 * channels.length];
            int responseOffset = 0;
            scanResponse[responseOffset] = 2;
            System.arraycopy(Wlan.getMacAddress(), 0, scanResponse, ++responseOffset, 6);
            responseOffset += 6;
            for (int channel : channels) {
                scanResponse[responseOffset] = (byte)channel;
                scanResponse[++responseOffset] = (byte)this.channelModes[channel];
                Utilities.writeStringNZ(scanResponse, ++responseOffset, 32, this.channelSSIDs[channel]);
                responseOffset += 32;
            }
            this.sendPacket(scanResponse, responseOffset);
        } else if (cmd == 2) {
            while (length >= 34) {
                String ssid;
                byte channel = buffer[offset];
                --length;
                byte mode = buffer[++offset];
                --length;
                if ((ssid = Utilities.readStringNZ(buffer, ++offset, 32)) != null && ssid.length() > 0 && channel != this.joinedChannel) {
                    this.setChannelSSID(channel, ssid, mode);
                }
                offset += 32;
                length -= 32;
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)String.format("processCmd unknown cmd=0x%X, buffer=%s", cmd, Utilities.getMemoryDump(buffer, offset, length)));
        }
    }

    private boolean hleWlanReceiveMessage() {
        boolean packetReceived = false;
        if (!this.createWlanSocket()) {
            return packetReceived;
        }
        byte[] bytes = new byte[10000];
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
        try {
            this.wlanSocket.receive(packet);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleWlanReceiveMessage message: %s", Utilities.getMemoryDump(packet.getData(), packet.getOffset(), packet.getLength())));
            }
            packetReceived = true;
            byte[] dataBytes = packet.getData();
            int dataOffset = packet.getOffset();
            int dataLength = packet.getLength();
            byte cmd = dataBytes[dataOffset];
            ++dataOffset;
            --dataLength;
            if (cmd != 0) {
                this.processCmd(cmd, dataBytes, dataOffset, dataLength);
                return packetReceived;
            }
            String ssid = Utilities.readStringNZ(dataBytes, dataOffset, 32);
            dataOffset += 32;
            dataLength -= 32;
            if (this.joinedChannel >= 0 && !ssid.equals(this.channelSSIDs[this.joinedChannel])) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleWlanReceiveMessage message SSID('%s') not matching the joined SSID('%s')", ssid, this.channelSSIDs[this.joinedChannel]));
                }
                return packetReceived;
            }
            SceNetIfMessage message = new SceNetIfMessage();
            int size = message.sizeof() + dataLength;
            int allocatedAddr = Modules.sceNetIfhandleModule.hleNetMallocInternal(size);
            if (allocatedAddr > 0) {
                Memory mem = Memory.getInstance();
                mem.memset(allocatedAddr, (byte)0, size);
                RuntimeContext.debugMemory(allocatedAddr, size);
                TPointer messageAddr = new TPointer(mem, allocatedAddr);
                TPointer data = new TPointer(mem, messageAddr.getAddress() + message.sizeof());
                Utilities.writeBytes(data.getAddress(), dataLength, dataBytes, dataOffset);
                message.dataAddr = data.getAddress();
                message.dataLength = dataLength;
                message.unknown16 = 1;
                message.unknown18 = 2;
                message.unknown24 = dataLength;
                message.write(messageAddr);
                SceNetWlanMessage wlanMessage = new SceNetWlanMessage();
                wlanMessage.read(data);
                this.addActiveMacAddress(wlanMessage.srcMacAddress);
                this.addActiveMacAddress(wlanMessage.dstMacAddress);
                if (dataLength > 0) {
                    int sceNetIfEnqueue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Notifying received message: %s", message));
                        log.debug((Object)String.format("Message WLAN: %s", wlanMessage));
                        log.debug((Object)String.format("Message data: %s", Utilities.getMemoryDump(data.getAddress(), dataLength)));
                    }
                    if ((sceNetIfEnqueue = NIDMapper.getInstance().getAddressByName("sceNetIfEnqueue")) != 0) {
                        SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
                        Modules.ThreadManForUserModule.executeCallback(thread, sceNetIfEnqueue, null, true, this.wlanHandleAddr.getAddress(), messageAddr.getAddress());
                    }
                }
            }
        }
        catch (SocketTimeoutException dataBytes) {
        }
        catch (IOException e) {
            log.error((Object)"hleWlanReceiveMessage", (Throwable)e);
        }
        return packetReceived;
    }

    private void hleWlanSendGameMode() {
        GameModeState myGameModeState = this.getMyGameModeState();
        if (myGameModeState == null) {
            return;
        }
        byte[] buffer = new byte[myGameModeState.dataLength + myGameModeState.macAddress.sizeof()];
        int offset = 0;
        System.arraycopy(myGameModeState.macAddress.macAddress, 0, buffer, offset, myGameModeState.macAddress.sizeof());
        System.arraycopy(myGameModeState.data, 0, buffer, offset += myGameModeState.macAddress.sizeof(), myGameModeState.dataLength);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanSendGameMode sending packet: %s", Utilities.getMemoryDump(buffer, 0, buffer.length)));
        }
        this.sendDataPacket(buffer, buffer.length);
        myGameModeState.updated = false;
    }

    private boolean hleWlanReceiveGameMode() {
        boolean packetReceived = false;
        if (!this.createWlanSocket()) {
            return packetReceived;
        }
        pspNetMacAddress macAddress = new pspNetMacAddress();
        byte[] bytes = new byte[this.gameModeDataLength + macAddress.sizeof() + 1 + 8];
        DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
        try {
            this.wlanSocket.receive(packet);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleWlanReceiveGameMode message: %s", Utilities.getMemoryDump(packet.getData(), packet.getOffset(), packet.getLength())));
            }
            packetReceived = true;
            byte[] dataBytes = packet.getData();
            int dataOffset = packet.getOffset();
            int dataLength = packet.getLength();
            byte cmd = dataBytes[dataOffset];
            ++dataOffset;
            --dataLength;
            if (cmd != 0) {
                this.processCmd(cmd, dataBytes, dataOffset, dataLength);
                return packetReceived;
            }
            String ssid = Utilities.readStringNZ(dataBytes, dataOffset, 32);
            dataOffset += 32;
            dataLength -= 32;
            if (this.joinedChannel >= 0 && !ssid.equals(this.channelSSIDs[this.joinedChannel])) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleWlanReceiveGameMode message SSID('%s') not matching the joined SSID('%s')", ssid, this.channelSSIDs[this.joinedChannel]));
                }
                return packetReceived;
            }
            macAddress.setMacAddress(dataBytes, dataOffset);
            dataOffset += macAddress.sizeof();
            dataLength -= macAddress.sizeof();
            GameModeState gameModeState = this.getGameModeStat(macAddress.macAddress);
            if (gameModeState != null) {
                int length = Math.min(dataLength, gameModeState.dataLength);
                System.arraycopy(dataBytes, dataOffset, gameModeState.data, 0, length);
                gameModeState.doUpdate();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleWlanReceiveGameMode updated GameModeState %s", gameModeState));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleWlanReceiveGameMode could not find GameModeState for MAC address %s", macAddress));
            }
        }
        catch (SocketTimeoutException dataBytes) {
        }
        catch (IOException e) {
            log.error((Object)"hleWlanReceiveMessage", (Throwable)e);
        }
        return packetReceived;
    }

    protected void hleWlanSendMessage(TPointer handleAddr, SceNetIfMessage message) {
        Memory mem = handleAddr.getMemory();
        SceNetWlanMessage wlanMessage = new SceNetWlanMessage();
        wlanMessage.read(mem, message.dataAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanSendMessage message: %s: %s", message, Utilities.getMemoryDump(message.getBaseAddress(), message.sizeof())));
            log.debug((Object)String.format("hleWlanSendMessage WLAN message : %s", wlanMessage));
            log.debug((Object)String.format("hleWlanSendMessage message data: %s", Utilities.getMemoryDump(message.dataAddr + wlanMessage.sizeof(), message.dataLength - wlanMessage.sizeof())));
        }
        if (!this.createWlanSocket()) {
            return;
        }
        byte[] messageBytes = null;
        while (true) {
            if (message.dataLength > 0) {
                int messageBytesOffset = messageBytes == null ? 0 : messageBytes.length;
                messageBytes = Utilities.extendArray(messageBytes, message.dataLength);
                Utilities.readBytes(message.dataAddr, message.dataLength, messageBytes, messageBytesOffset);
            }
            if (message.nextDataAddr == 0) break;
            message.read(mem, message.nextDataAddr);
        }
        if (messageBytes != null) {
            this.sendDataPacket(messageBytes, messageBytes.length);
        }
    }

    public int hleWlanSendCallback(TPointer handleAddr) {
        SceNetIfHandle handle = new SceNetIfHandle();
        handle.read(handleAddr);
        Memory mem = handleAddr.getMemory();
        TPointer firstMessageAddr = new TPointer(mem, handle.addrFirstMessageToBeSent);
        SceNetIfMessage message = new SceNetIfMessage();
        message.read(firstMessageAddr);
        RuntimeContext.debugMemory(firstMessageAddr.getAddress(), message.sizeof());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanSendCallback handleAddr=%s: %s", handleAddr, handle));
        }
        this.hleWlanSendMessage(handleAddr, message);
        handle.addrFirstMessageToBeSent = message.nextMessageAddr;
        --handle.numberOfMessagesToBeSent;
        if (handle.addrFirstMessageToBeSent == 0) {
            handle.addrLastMessageToBeSent = 0;
        }
        handle.write(handleAddr);
        int sceNetMFreem = NIDMapper.getInstance().getAddressByName("sceNetMFreem");
        if (sceNetMFreem != 0) {
            Modules.ThreadManForUserModule.executeCallback(null, sceNetMFreem, null, true, firstMessageAddr.getAddress());
        } else {
            Modules.sceNetIfhandleModule.sceNetMFreem(firstMessageAddr);
        }
        return 0;
    }

    public int hleWlanUpCallback(TPointer handleAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanUpCallback handleAddr: %s", Utilities.getMemoryDump(handleAddr.getAddress(), 44)));
            int handleInternalAddr = handleAddr.getValue32();
            if (handleInternalAddr != 0) {
                log.debug((Object)String.format("hleWlanUpCallback handleInternalAddr: %s", Utilities.getMemoryDump(handleInternalAddr, 320)));
            }
        }
        SceNetIfHandle handle = new SceNetIfHandle();
        handle.read(handleAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanUpCallback handleAddr=%s: %s", handleAddr, handle));
        }
        this.wlanHandleAddr = handleAddr;
        this.addActiveMacAddress(new pspNetMacAddress(Wlan.getMacAddress()));
        SceKernelThreadInfo thread = Modules.ThreadManForUserModule.hleKernelCreateThread("SceWlanHal", 0x80000D0, 39, 2048, 0, 0, 1);
        if (thread != null) {
            this.wlanThreadUid = thread.uid;
            Modules.ThreadManForUserModule.hleKernelStartThread(thread, 0, TPointer.NULL, 0);
        }
        Modules.ThreadManForUserModule.sceKernelSignalSema(handle.handleInternal.ioctlSemaId, 1);
        return 0;
    }

    public int hleWlanDownCallback(TPointer handleAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanDownCallback handleAddr: %s", Utilities.getMemoryDump(handleAddr.getAddress(), 44)));
            int handleInternalAddr = handleAddr.getValue32();
            if (handleInternalAddr != 0) {
                log.debug((Object)String.format("hleWlanDownCallback handleInternalAddr: %s", Utilities.getMemoryDump(handleInternalAddr, 320)));
            }
        }
        SceNetIfHandle handle = new SceNetIfHandle();
        handle.read(handleAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleWlanDownCallback handleAddr=%s: %s", handleAddr, handle));
        }
        this.wlanThreadUid = Integer.MIN_VALUE;
        Modules.ThreadManForUserModule.sceKernelSignalSema(handle.handleInternal.ioctlSemaId, 1);
        return 0;
    }

    public int hleWlanIoctlCallback(TPointer handleAddr, int cmd, TPointer unknown, TPointer32 buffersAddr) {
        SceNetIfHandle handle = new SceNetIfHandle();
        handle.read(handleAddr);
        Memory mem = Memory.getInstance();
        int inputAddr = buffersAddr.getValue(0);
        int outputAddr = buffersAddr.getValue(4);
        if (log.isDebugEnabled()) {
            int inputLength = 128;
            int outputLength = 128;
            switch (cmd) {
                case 52: {
                    inputLength = 76;
                    outputLength = 1536;
                    break;
                }
                case 53: {
                    inputLength = 112;
                    break;
                }
                case 54: {
                    inputLength = 112;
                    break;
                }
                case 55: {
                    inputLength = 96;
                    break;
                }
                case 68: {
                    inputLength = 80;
                    outputLength = 6;
                    break;
                }
                case 71: {
                    inputLength = 160;
                    break;
                }
                case 66: {
                    break;
                }
            }
            log.debug((Object)String.format("hleWlanIoctlCallback cmd=0x%X, handleAddr=%s: %s", cmd, handleAddr, handle));
            if (inputAddr != 0 && Memory.isAddressGood(inputAddr) && inputLength > 0) {
                log.debug((Object)String.format("hleWlanIoctlCallback inputAddr: %s", Utilities.getMemoryDump(inputAddr, inputLength)));
                RuntimeContext.debugMemory(inputAddr, inputLength);
            }
            if (outputAddr != 0 && Memory.isAddressGood(outputAddr) && outputLength > 0) {
                log.debug((Object)String.format("hleWlanIoctlCallback outputAddr: %s", Utilities.getMemoryDump(outputAddr, outputLength)));
                RuntimeContext.debugMemory(outputAddr, outputLength);
            }
            RuntimeContext.debugMemory(unknown.getAddress(), 32);
        }
        boolean signalSema = true;
        int errorCode = 0;
        switch (cmd) {
            case 52: {
                int mode = mem.read32(inputAddr + 0);
                int channel = mem.read8(inputAddr + 10);
                if (channel == this.joinedChannel && mem.read8(inputAddr + 11) == 0) {
                    SceNetWlanScanInfo scanInfo = new SceNetWlanScanInfo();
                    scanInfo.bssid = "Jpcsp";
                    scanInfo.channel = channel;
                    scanInfo.ssid = this.channelSSIDs[channel];
                    scanInfo.mode = this.channelModes[channel];
                    scanInfo.beaconInterval = 1000;
                    scanInfo.write(handleAddr.getMemory(), outputAddr + 4);
                    mem.write32(outputAddr, 0);
                    break;
                }
                if (channel != this.joinedChannel) {
                    int ssidLength = mem.read8(inputAddr + 24);
                    String ssid = Utilities.readStringNZ(mem, inputAddr + 28, ssidLength);
                    this.setChannelSSID(channel, ssid, mode);
                }
                if (!this.createWlanSocket()) break;
                signalSema = false;
                Emulator.getScheduler().addAction(Scheduler.getNow(), new WlanScanAction(handleAddr, inputAddr, outputAddr));
                break;
            }
            case 53: {
                int channel = mem.read8(inputAddr + 6);
                int ssidLength = mem.read8(inputAddr + 7);
                String ssid = Utilities.readStringNZ(mem, inputAddr + 8, ssidLength);
                int mode = mem.read32(inputAddr + 40);
                int unknown44 = mem.read32(inputAddr + 44);
                int unknown62 = mem.read16(inputAddr + 62);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleWlanIoctlCallback cmd=0x%X, channel=%d, ssid='%s', mode=0x%X, unknown44=0x%X, unknown62=0x%X", cmd, channel, ssid, mode, unknown44, unknown62));
                }
                this.joinChannelSSID(channel, ssid, mode);
                signalSema = false;
                Emulator.getScheduler().addAction(Scheduler.getNow() + 50000L, new WlanCreateAction(handleAddr));
                break;
            }
            case 54: {
                SceNetWlanScanInfo scanInfo = new SceNetWlanScanInfo();
                scanInfo.read(mem, inputAddr);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleWlanIoctlCallback cmd=0x%X, channel=%d, ssid='%s', mode=0x%X", cmd, scanInfo.channel, scanInfo.ssid, scanInfo.mode));
                }
                this.joinChannelSSID(scanInfo.channel, scanInfo.ssid, scanInfo.mode);
                signalSema = false;
                Emulator.getScheduler().addAction(Scheduler.getNow() + 50000L, new WlanConnectAction(handleAddr));
                break;
            }
            case 55: {
                mem.memset(inputAddr, (byte)0, 40);
                if (this.joinedChannel < 0) break;
                String bssid = "Jpcsp";
                Utilities.writeStringNZ(mem, inputAddr + 0, 6, bssid);
                mem.write8(inputAddr + 6, (byte)this.joinedChannel);
                mem.write8(inputAddr + 7, (byte)this.channelSSIDs[this.joinedChannel].length());
                Utilities.writeStringNZ(mem, inputAddr + 8, 32, this.channelSSIDs[this.joinedChannel]);
                break;
            }
            case 56: {
                this.isGameMode = false;
                this.joinedChannel = -1;
                signalSema = false;
                Emulator.getScheduler().addAction(Scheduler.getNow() + 50000L, new WlanDisconnectAction(handleAddr));
                break;
            }
            case 68: {
                pspNetMacAddress multicastMacAddress = new pspNetMacAddress();
                multicastMacAddress.read(mem, inputAddr + 6);
                int ssidLength = mem.read8(inputAddr + 12);
                String ssid = Utilities.readStringNZ(mem, inputAddr + 14, ssidLength);
                pspNetMacAddress macAddress = new pspNetMacAddress();
                macAddress.read(mem, outputAddr + 0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleWlanIoctlCallback cmd=0x%X, ssid='%s', multicastMacAddress=%s, macAddress=%s", cmd, ssid, multicastMacAddress, macAddress));
                }
                this.isGameMode = true;
                break;
            }
            case 71: {
                int unknown1 = mem.read32(inputAddr + 0);
                int unknown2 = mem.read32(inputAddr + 4);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("hleWlanIoctlCallback unknown1=0x%X, unknown2=0x%X", unknown1, unknown2));
                }
                int wepKeyAddr = inputAddr + 12;
                for (int i = 0; i < 4; ++i) {
                    int mode = mem.read32(wepKeyAddr + 0);
                    String wepKey = Utilities.readStringNZ(wepKeyAddr + 4, 13);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("hleWlanIoctlCallback cmd=0x%X, wekKey#%d: mode=0x%X, wepKey='%s'", cmd, i, mode, wepKey));
                    }
                    wepKeyAddr += 20;
                }
                break;
            }
            default: {
                log.warn((Object)String.format("hleWlanIoctlCallback unknown cmd=0x%X", cmd));
            }
        }
        handle.handleInternal.errorCode = errorCode;
        handle.write(handleAddr);
        if (signalSema) {
            Modules.ThreadManForUserModule.sceKernelSignalSema(handle.handleInternal.ioctlSemaId, 1);
        }
        return 0;
    }

    private static void sendDummyMessage(int step, TPointer handleAddr) {
        int dataLength;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sendDummyMessage step=%d", step));
        }
        Memory mem = Memory.getInstance();
        SceNetIfMessage message = new SceNetIfMessage();
        SceNetWlanMessage wlanMessage = new SceNetWlanMessage();
        int size = message.sizeof() + wlanMessage.sizeof() + 288 + 18;
        int allocatedAddr = Modules.sceNetIfhandleModule.hleNetMallocInternal(size);
        if (allocatedAddr <= 0) {
            return;
        }
        RuntimeContext.debugMemory(allocatedAddr, size);
        mem.memset(allocatedAddr, (byte)0, size);
        TPointer messageAddr = new TPointer(mem, allocatedAddr);
        TPointer data = new TPointer(mem, messageAddr.getAddress() + message.sizeof());
        TPointer header = new TPointer(mem, data.getAddress());
        TPointer content = new TPointer(mem, header.getAddress() + wlanMessage.sizeof());
        switch (step) {
            case 1: {
                int controlType = 2;
                int contentLength = SceNetWlanMessage.contentLengthFromMessageType[controlType];
                dataLength = wlanMessage.sizeof() + contentLength;
                wlanMessage.dstMacAddress = new pspNetMacAddress(Wlan.getMacAddress());
                wlanMessage.srcMacAddress = new pspNetMacAddress(dummyOtherMacAddress);
                wlanMessage.protocolType = 35016;
                wlanMessage.protocolSubType = 1;
                wlanMessage.unknown16 = 1;
                wlanMessage.controlType = controlType;
                wlanMessage.contentLength = SceNetWlanMessage.contentLengthFromMessageType[controlType];
                content.clear(contentLength);
                break;
            }
            case 2: {
                int controlType = 0;
                int contentLength = 76;
                dataLength = wlanMessage.sizeof() + contentLength;
                wlanMessage.dstMacAddress = new pspNetMacAddress(new byte[]{-1, -1, -1, -1, -1, -1});
                wlanMessage.srcMacAddress = new pspNetMacAddress(dummyOtherMacAddress);
                wlanMessage.protocolType = 35016;
                wlanMessage.protocolSubType = 2;
                wlanMessage.unknown16 = 0;
                wlanMessage.controlType = controlType;
                wlanMessage.contentLength = contentLength;
                content.clear(contentLength);
                content.setStringNZ(52, 5, "Jpcsp");
                break;
            }
            case 3: {
                int controlType = 2;
                int contentLength = SceNetWlanMessage.contentLengthFromMessageType[controlType];
                dataLength = wlanMessage.sizeof() + contentLength + 18;
                wlanMessage.dstMacAddress = new pspNetMacAddress(new byte[]{-1, -1, -1, -1, -1, -1});
                wlanMessage.srcMacAddress = new pspNetMacAddress(dummyOtherMacAddress);
                wlanMessage.protocolType = 35016;
                wlanMessage.protocolSubType = 1;
                wlanMessage.unknown16 = 1;
                wlanMessage.controlType = controlType;
                wlanMessage.contentLength = SceNetWlanMessage.contentLengthFromMessageType[controlType];
                content.setStringNZ(0, 128, "JpcspOther");
                content.setValue8(128, (byte)1);
                content.setValue8(129, (byte)4);
                content.setUnalignedValue32(130, Modules.SysMemUserForUserModule.sceKernelDevkitVersion());
                content.setValue8(134, (byte)2);
                content.setValue8(135, (byte)4);
                content.setUnalignedValue32(136, Modules.SysMemUserForUserModule.sceKernelGetCompiledSdkVersion());
                content.setValue8(140, (byte)3);
                content.setValue8(141, (byte)4);
                content.setUnalignedValue32(142, Modules.SysMemForKernelModule.sceKernelGetModel());
                break;
            }
            case 4: {
                int controlType = 3;
                int contentLength = SceNetWlanMessage.contentLengthFromMessageType[controlType];
                dataLength = wlanMessage.sizeof() + contentLength + 18;
                wlanMessage.dstMacAddress = new pspNetMacAddress(Wlan.getMacAddress());
                wlanMessage.srcMacAddress = new pspNetMacAddress(dummyOtherMacAddress);
                wlanMessage.protocolType = 35016;
                wlanMessage.protocolSubType = 1;
                wlanMessage.unknown16 = 1;
                wlanMessage.controlType = controlType;
                wlanMessage.contentLength = SceNetWlanMessage.contentLengthFromMessageType[controlType];
                content.clear(contentLength);
                content.setStringNZ(160, 128, "JpcspOther");
                content.setValue8(288, (byte)1);
                content.setValue8(289, (byte)4);
                content.setUnalignedValue32(130, Modules.SysMemUserForUserModule.sceKernelDevkitVersion());
                content.setValue8(294, (byte)2);
                content.setValue8(295, (byte)4);
                content.setUnalignedValue32(136, Modules.SysMemUserForUserModule.sceKernelGetCompiledSdkVersion());
                content.setValue8(300, (byte)3);
                content.setValue8(301, (byte)4);
                content.setUnalignedValue32(302, Modules.SysMemForKernelModule.sceKernelGetModel());
                break;
            }
            case 5: {
                int controlType = 4;
                int contentLength = SceNetWlanMessage.contentLengthFromMessageType[controlType];
                dataLength = wlanMessage.sizeof() + contentLength;
                wlanMessage.dstMacAddress = new pspNetMacAddress(Wlan.getMacAddress());
                wlanMessage.srcMacAddress = new pspNetMacAddress(dummyOtherMacAddress);
                wlanMessage.protocolType = 35016;
                wlanMessage.protocolSubType = 1;
                wlanMessage.unknown16 = 1;
                wlanMessage.controlType = controlType;
                wlanMessage.contentLength = SceNetWlanMessage.contentLengthFromMessageType[controlType];
                content.clear(contentLength);
                break;
            }
            case 6: {
                int controlType = 5;
                int contentLength = SceNetWlanMessage.contentLengthFromMessageType[controlType];
                dataLength = wlanMessage.sizeof() + contentLength;
                wlanMessage.dstMacAddress = new pspNetMacAddress(Wlan.getMacAddress());
                wlanMessage.srcMacAddress = new pspNetMacAddress(dummyOtherMacAddress);
                wlanMessage.protocolType = 35016;
                wlanMessage.protocolSubType = 1;
                wlanMessage.unknown16 = 1;
                wlanMessage.controlType = controlType;
                wlanMessage.contentLength = SceNetWlanMessage.contentLengthFromMessageType[controlType];
                content.clear(contentLength);
                break;
            }
            case 7: {
                int controlType = 6;
                int contentLength = SceNetWlanMessage.contentLengthFromMessageType[controlType];
                dataLength = wlanMessage.sizeof() + contentLength;
                wlanMessage.dstMacAddress = new pspNetMacAddress(Wlan.getMacAddress());
                wlanMessage.srcMacAddress = new pspNetMacAddress(dummyOtherMacAddress);
                wlanMessage.protocolType = 35016;
                wlanMessage.protocolSubType = 1;
                wlanMessage.unknown16 = 1;
                wlanMessage.controlType = controlType;
                wlanMessage.contentLength = SceNetWlanMessage.contentLengthFromMessageType[controlType];
                content.clear(contentLength);
                break;
            }
            case 8: {
                int controlType = 8;
                int contentLength = SceNetWlanMessage.contentLengthFromMessageType[controlType];
                dataLength = wlanMessage.sizeof() + contentLength;
                wlanMessage.dstMacAddress = new pspNetMacAddress(Wlan.getMacAddress());
                wlanMessage.srcMacAddress = new pspNetMacAddress(dummyOtherMacAddress);
                wlanMessage.protocolType = 35016;
                wlanMessage.protocolSubType = 1;
                wlanMessage.unknown16 = 1;
                wlanMessage.controlType = controlType;
                wlanMessage.contentLength = SceNetWlanMessage.contentLengthFromMessageType[controlType];
                content.clear(contentLength);
                break;
            }
            default: {
                dataLength = 0;
            }
        }
        wlanMessage.write(header);
        message.dataAddr = data.getAddress();
        message.dataLength = dataLength;
        message.unknown18 = 0;
        message.unknown24 = dataLength;
        message.write(messageAddr);
        if (dataLength > 0) {
            int sceNetIfEnqueue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Sending dummy message: %s", message));
                log.debug((Object)String.format("Dummy message data: %s", Utilities.getMemoryDump(data.getAddress(), dataLength)));
            }
            if ((sceNetIfEnqueue = NIDMapper.getInstance().getAddressByName("sceNetIfEnqueue")) != 0) {
                SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
                Modules.ThreadManForUserModule.executeCallback(thread, sceNetIfEnqueue, null, true, handleAddr.getAddress(), messageAddr.getAddress());
            }
        }
    }

    private void sendDummyMessage(TPointer handleAddr, SceNetIfMessage sentMessage, SceNetWlanMessage sentWlanMessage) {
        int step = 0;
        step = this.dummyMessageStep < 0 && !sentWlanMessage.dstMacAddress.equals(dummyOtherMacAddress) ? 3 : (sentWlanMessage.controlType == 3 ? 5 : (sentWlanMessage.controlType == 4 ? 5 : (sentWlanMessage.controlType == 5 ? 7 : (sentWlanMessage.controlType == 7 ? 8 : 0))));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Adding action step=%d for sending dummy message", step));
        }
        this.dummyMessageStep = step;
        this.dummyMessageHandleAddr = handleAddr;
    }

    private void afterNetCreateIfhandleEtherAction(SceKernelThreadInfo thread, TPointer handleAddr) {
        int tempMem = Modules.sceNetIfhandleModule.hleNetMallocInternal(32);
        if (tempMem <= 0) {
            return;
        }
        int macAddressAddr = tempMem;
        int interfaceNameAddr = tempMem + 8;
        pspNetMacAddress macAddress = new pspNetMacAddress(Wlan.getMacAddress());
        macAddress.write(handleAddr.getMemory(), macAddressAddr);
        Utilities.writeStringZ(handleAddr.getMemory(), interfaceNameAddr, "wlan");
        int sceNetAttachIfhandleEther = NIDMapper.getInstance().getAddressByName("sceNetAttachIfhandleEther");
        if (sceNetAttachIfhandleEther == 0) {
            return;
        }
        Modules.ThreadManForUserModule.executeCallback(thread, sceNetAttachIfhandleEther, null, true, handleAddr.getAddress(), macAddressAddr, interfaceNameAddr);
    }

    private int createWlanInterface() {
        SceNetIfHandle handle = new SceNetIfHandle();
        handle.callbackArg4 = 0x11040404;
        handle.upCallbackAddr = 0x80000A0;
        handle.downCallbackAddr = 0x80000B0;
        handle.sendCallbackAddr = 0x8000090;
        handle.ioctlCallbackAddr = 0x80000C0;
        int handleMem = Modules.sceNetIfhandleModule.hleNetMallocInternal(handle.sizeof());
        TPointer handleAddr = new TPointer(Memory.getInstance(), handleMem);
        handle.write(handleAddr);
        RuntimeContext.debugMemory(handleAddr.getAddress(), handle.sizeof());
        int sceNetCreateIfhandleEther = NIDMapper.getInstance().getAddressByName("sceNetCreateIfhandleEther");
        if (sceNetCreateIfhandleEther == 0) {
            int result = Modules.sceNetIfhandleModule.hleNetCreateIfhandleEther(handleAddr);
            if (result < 0) {
                return result;
            }
            result = Modules.sceNetIfhandleModule.hleNetAttachIfhandleEther(handleAddr, new pspNetMacAddress(Wlan.getMacAddress()), "wlan");
            if (result < 0) {
                return result;
            }
        } else {
            SceKernelThreadInfo thread = Modules.ThreadManForUserModule.getCurrentThread();
            Modules.ThreadManForUserModule.executeCallback(thread, sceNetCreateIfhandleEther, (IAction)new AfterNetCreateIfhandleEtherAction(thread, handleAddr), false, handleAddr.getAddress());
        }
        this.accessPoint = new AccessPoint(this);
        return 0;
    }

    @HLEFunction(nid=207757441, version=150, checkInsideInterrupt=true)
    public int sceWlanGetEtherAddr(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=6, usage=BufferInfo.Usage.out) TPointer etherAddr) {
        pspNetMacAddress macAddress = new pspNetMacAddress();
        macAddress.setMacAddress(Wlan.getMacAddress());
        macAddress.write(etherAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceWlanGetEtherAddr returning %s", macAddress));
        }
        return 0;
    }

    @HLEFunction(nid=-680118631, version=150)
    public int sceWlanGetSwitchState() {
        return Wlan.getSwitchState();
    }

    @HLEFunction(nid=-1824257263, version=150)
    public int sceWlanDevIsPowerOn() {
        return Wlan.getSwitchState();
    }

    @HLEUnimplemented
    @HLEFunction(nid=1210887834, version=150)
    public int sceWlanDevAttach() {
        int result = this.createWlanInterface();
        if (result < 0) {
            log.error((Object)String.format("Cannot create the WLAN Interface: 0x%08X", result));
            return result;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-911684937, version=150)
    public int sceWlanDevDetach() {
        if (this.accessPoint != null) {
            this.accessPoint.exit();
            this.accessPoint = null;
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1923132133, version=150)
    public int sceWlanDrv_lib_8D5F551B(int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1956348218, version=150)
    public int sceWlanSetHostDiscover(int unknown1, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=40, usage=BufferInfo.Usage.in) TPointer unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-24507578, version=150)
    public int sceWlanSetWakeUp(int unknown1, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=40, usage=BufferInfo.Usage.in) TPointer unknown2) {
        return 0;
    }

    @HLEFunction(nid=1585221012, version=150)
    public boolean sceWlanDevIsGameMode() {
        return this.isGameMode;
    }

    @HLEFunction(nid=1590953114, version=150)
    public int sceWlanGPPrevEstablishActive(pspNetMacAddress macAddress) {
        int index = 0;
        for (pspNetMacAddress activeMacAddress : this.activeMacAddresses) {
            if (activeMacAddress.equals(macAddress.macAddress)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @HLEFunction(nid=-1538846662, version=150)
    public int sceWlanGPRecv(int id, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.out) TPointer buffer, int bufferLength, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.variableLength, usage=BufferInfo.Usage.out) TPointer updateInfoAddr) {
        if (!this.isGameMode) {
            return -2143220460;
        }
        if (id < 0 || id >= this.gameModeStates.size()) {
            return -2143220461;
        }
        if (bufferLength < 0 || bufferLength > this.gameModeDataLength) {
            return -2143220461;
        }
        GameModeState gameModeState = this.gameModeStates.get(id);
        int size = Math.min(gameModeState.dataLength, bufferLength);
        Utilities.writeBytes(buffer.getAddress(), size, gameModeState.data, 0);
        if (updateInfoAddr.isNotNull()) {
            sceNetAdhoc.GameModeUpdateInfo updateInfo = new sceNetAdhoc.GameModeUpdateInfo();
            updateInfo.read(updateInfoAddr);
            updateInfo.updated = gameModeState.updated ? 1 : 0;
            updateInfo.timeStamp = gameModeState.timeStamp;
            updateInfo.write(updateInfoAddr);
        }
        return 0;
    }

    @HLEFunction(nid=-1260926092, version=150)
    public int sceWlanGPSend(int unknown, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer buffer, int bufferLength) {
        if (!this.isGameMode) {
            return -2143220460;
        }
        if (bufferLength < 0 || bufferLength > this.gameModeDataLength) {
            return -2143220461;
        }
        GameModeState myGameModeState = this.getMyGameModeState();
        if (myGameModeState == null) {
            log.error((Object)String.format("sceWlanGPSend not found my GameModeState!", new Object[0]));
            return -1;
        }
        Utilities.readBytes(buffer.getAddress(), bufferLength, myGameModeState.data, 0);
        myGameModeState.doUpdate();
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=756002382, version=150)
    public int sceWlanDrv_lib_2D0FAE4E(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=6, usage=BufferInfo.Usage.in) TPointer16 unknown) {
        this.unknownValue1 = unknown.getValue(0);
        this.unknownValue2 = unknown.getValue(2);
        this.unknownValue3 = unknown.getValue(4);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1458857930, version=150)
    public int sceWlanDrv_lib_56F467CA(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=6, usage=BufferInfo.Usage.out) TPointer16 unknown) {
        unknown.setValue(0, this.unknownValue1);
        unknown.setValue(2, this.unknownValue2);
        unknown.setValue(4, this.unknownValue3);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1537875941, version=150)
    public int sceWlanDrv_lib_5BAA1FE5(int unknown1, int unknown2) {
        return 0;
    }

    @HLEFunction(nid=622455463, version=150)
    public boolean sceWlanIsPacketToBeDropped() {
        return false;
    }

    @HLEFunction(nid=845115762, version=150)
    public int sceWlanSetDropRate(int dropRate, int dropDuration) {
        this.wlanDropRate = dropRate;
        this.wlanDropDuration = dropDuration;
        return 0;
    }

    @HLEFunction(nid=-1230409715, version=150)
    public int sceWlanGetDropRate(@CanBeNull TPointer32 dropRateAddr, @CanBeNull TPointer32 dropDurationAddr) {
        dropRateAddr.setValue(this.wlanDropRate);
        dropDurationAddr.setValue(this.wlanDropDuration);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1864019185, version=150)
    public void sceWlanDrv_driver_90E5530F(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer wlanDriver1, int wlanDriver1Size, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer wlanDriver2, int wlanDriver2Size) {
    }

    private class AfterNetCreateIfhandleEtherAction
    implements IAction {
        private SceKernelThreadInfo thread;
        private TPointer handleAddr;

        public AfterNetCreateIfhandleEtherAction(SceKernelThreadInfo thread, TPointer handleAddr) {
            this.thread = thread;
            this.handleAddr = handleAddr;
        }

        @Override
        public void execute() {
            sceWlan.this.afterNetCreateIfhandleEtherAction(this.thread, this.handleAddr);
        }
    }

    private class WlanDisconnectAction
    implements IAction {
        private TPointer handleAddr;

        public WlanDisconnectAction(TPointer handleAddr) {
            this.handleAddr = handleAddr;
        }

        @Override
        public void execute() {
            sceWlan.this.hleWlanDisconnectAction(this.handleAddr);
        }
    }

    private class WlanCreateAction
    implements IAction {
        private TPointer handleAddr;

        public WlanCreateAction(TPointer handleAddr) {
            this.handleAddr = handleAddr;
        }

        @Override
        public void execute() {
            sceWlan.this.hleWlanCreateAction(this.handleAddr);
        }
    }

    private class WlanConnectAction
    implements IAction {
        private TPointer handleAddr;

        public WlanConnectAction(TPointer handleAddr) {
            this.handleAddr = handleAddr;
        }

        @Override
        public void execute() {
            sceWlan.this.hleWlanConnectAction(this.handleAddr);
        }
    }

    private class WlanScanAction
    implements IAction {
        private TPointer handleAddr;
        private TPointer inputAddr;
        private TPointer outputAddr;
        private int callCount;

        public WlanScanAction(TPointer handleAddr, int inputAddr, int outputAddr) {
            this.handleAddr = handleAddr;
            this.inputAddr = new TPointer(handleAddr.getMemory(), inputAddr);
            this.outputAddr = new TPointer(handleAddr.getMemory(), outputAddr);
        }

        @Override
        public void execute() {
            sceWlan.this.hleWlanScanAction(this.handleAddr, this.inputAddr, this.outputAddr, this, this.callCount);
            ++this.callCount;
        }
    }

    private static class GameModeState {
        public long timeStamp;
        public boolean updated;
        public pspNetMacAddress macAddress;
        public byte[] data;
        public int dataLength;

        public GameModeState(pspNetMacAddress macAddress) {
            this.macAddress = macAddress;
            this.dataLength = Modules.sceWlanModule.gameModeDataLength;
            this.data = new byte[this.dataLength];
        }

        public void doUpdate() {
            this.updated = true;
            this.timeStamp = SystemTimeManager.getSystemTime();
        }

        public String toString() {
            return String.format("macAddress=%s, updated=%b, timeStamp=%d, dataLength=0x%X, data=%s", this.macAddress, this.updated, this.timeStamp, this.dataLength, Utilities.getMemoryDump(this.data, 0, this.dataLength));
        }
    }
}

