/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.crypto.CryptoEngine;
import jpcsp.crypto.PreDecrypt;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class semaphore
extends HLEModule {
    public static Logger log = Modules.getLogger("semaphore");
    private static int dumpIndex = 0;

    public int hleUtilsBufferCopyWithRange(byte[] out, int outOffset, int outSize, byte[] in, int inOffset, int inSize, int cmd) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("hleUtilsBufferCopyWithRange cmd=0x%X, input(size=0x%X): %s", cmd, inSize, Utilities.getMemoryDump(in, inOffset, inSize)));
        }
        int correctOutSize = outSize;
        if (cmd == 7) {
            correctOutSize = Utilities.readUnaligned32(in, inOffset + 16);
        }
        int result = 0;
        if (PreDecrypt.preDecrypt(out, outOffset, correctOutSize, in, inOffset, inSize, cmd)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleUtilsBufferCopyWithRange using pre-decrypted data", new Object[0]));
            }
        } else {
            ByteBuffer outBuffer = null;
            if (out != null) {
                outBuffer = ByteBuffer.wrap(out).order(ByteOrder.LITTLE_ENDIAN);
                outBuffer.position(outOffset);
            }
            ByteBuffer inBuffer = null;
            if (in != null) {
                inBuffer = ByteBuffer.wrap(in).order(ByteOrder.LITTLE_ENDIAN);
                inBuffer.position(inOffset);
            }
            int inSizeAligned = Utilities.alignUp(inSize, 15);
            CryptoEngine crypto = new CryptoEngine();
            result = crypto.getKIRKEngine().hleUtilsBufferCopyWithRange(outBuffer, outSize, inBuffer, inSizeAligned, inSize, cmd);
            if (result != 0) {
                String dumpFileName = String.format("dump.hleUtilsBufferCopyWithRange.%d", dumpIndex++);
                log.error((Object)String.format("hleUtilsBufferCopyWithRange returned error result=0x%X for command=0x%X, outputSize=0x%X, inputSize=0x%X, input dumped into file '%s'", result, cmd, correctOutSize, inSize, dumpFileName));
                try {
                    FileOutputStream dump = new FileOutputStream(dumpFileName);
                    ((OutputStream)dump).write(in, inOffset, inSize);
                    ((OutputStream)dump).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("hleUtilsBufferCopyWithRange result=0x%X, output(size=0x%X): %s", result, outSize, Utilities.getMemoryDump(out, outOffset, outSize)));
        }
        return result;
    }

    public int hleUtilsBufferCopyWithRange(TPointer outAddr, int outSize, TPointer inAddr, int inSize, int cmd) {
        int originalInSize = inSize;
        inSize = Utilities.alignUp(inSize, 15);
        byte[] inBytes = new byte[inSize + 144];
        IMemoryReader memoryReaderIn = MemoryReader.getMemoryReader(inAddr, inSize, 1);
        for (int i = 0; i < inSize; ++i) {
            inBytes[i] = (byte)memoryReaderIn.readNext();
        }
        byte[] outBytes = new byte[Utilities.alignUp(outSize, 15)];
        if (outBytes.length > 0) {
            IMemoryReader memoryReaderOut = MemoryReader.getMemoryReader(outAddr, outBytes.length, 1);
            for (int i = 0; i < outBytes.length; ++i) {
                outBytes[i] = (byte)memoryReaderOut.readNext();
            }
        }
        int result = this.hleUtilsBufferCopyWithRange(outBytes, 0, outSize, inBytes, 0, originalInSize, cmd);
        if (outSize > 0) {
            IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(outAddr, outSize, 1);
            for (int i = 0; i < outSize; ++i) {
                memoryWriter.writeNext(outBytes[i] & 0xFF);
            }
            memoryWriter.flush();
        }
        return result;
    }

    @HLEFunction(nid=1280539762, version=150)
    public int sceUtilsBufferCopyWithRange(@CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.out, maxDumpLength=256) TPointer outAddr, int outSize, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in, maxDumpLength=256) TPointer inAddr, int inSize, int cmd) {
        this.hleUtilsBufferCopyWithRange(outAddr, outSize, inAddr, inSize, cmd);
        return 0;
    }

    @HLEFunction(nid=2011787385, version=150)
    public int sceUtilsBufferCopyByPollingWithRange(TPointer outAddr, int outSize, TPointer inAddr, int inSize, int cmd) {
        return this.sceUtilsBufferCopyWithRange(outAddr, outSize, inAddr, inSize, cmd);
    }

    @HLEUnimplemented
    @HLEFunction(nid=15646826, version=150)
    public int sceUtilsBufferCopy(TPointer outAddr, TPointer inAddr, int cmd) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1897169934, version=150)
    public int sceUtilsBufferCopyByPolling(TPointer outAddr, TPointer inAddr, int cmd) {
        return 0;
    }
}

