/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import java.awt.AWTEvent;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import jpcsp.Emulator;
import jpcsp.MainGUI;
import jpcsp.settings.Settings;

public class WindowPropSaver
implements AWTEventListener {
    @Override
    public void eventDispatched(AWTEvent awte) {
        Window window = (Window)((WindowEvent)awte).getComponent();
        switch (awte.getID()) {
            case 206: {
                WindowPropSaver.onSavePosition(window);
                break;
            }
            case 200: {
                WindowPropSaver.onLoadPosition(window);
            }
        }
    }

    public static void loadWindowProperties(Window window) {
        WindowPropSaver.onLoadPosition(window);
    }

    public static void saveWindowProperties(MainGUI mainGUI) {
        WindowPropSaver.onSavePosition(mainGUI);
    }

    private static void onLoadPosition(Window window) {
        if (!WindowPropSaver.isWindowFrameOrDialog(window)) {
            return;
        }
        String identifierForConfig = window.getClass().getSimpleName();
        if (identifierForConfig.equals("JDialog")) {
            return;
        }
        if (identifierForConfig.equals("MainGUI") && Emulator.getMainGUI().isFullScreen()) {
            return;
        }
        if (Settings.getInstance().readBool("gui.saveWindowPos") && Settings.getInstance().readWindowPos(identifierForConfig) != null) {
            Emulator.log.debug((Object)("loading window position of '" + identifierForConfig + "'"));
            if (!identifierForConfig.equals("LogWindow") || !Settings.getInstance().readBool("gui.snapLogwindow")) {
                window.setLocation(Settings.getInstance().readWindowPos(identifierForConfig));
            }
            if (WindowPropSaver.isWindowResizeable(window) && Settings.getInstance().readWindowSize(identifierForConfig) != null) {
                window.setSize(Settings.getInstance().readWindowSize(identifierForConfig));
            }
        } else {
            window.setLocationRelativeTo(null);
        }
    }

    private static void onSavePosition(Window window) {
        if (!WindowPropSaver.isWindowFrameOrDialog(window)) {
            return;
        }
        if (Settings.getInstance().readBool("gui.saveWindowPos")) {
            String identifierForConfig = window.getClass().getSimpleName();
            if (identifierForConfig.equals("JDialog")) {
                return;
            }
            if (identifierForConfig.equals("MainGUI") && Emulator.getMainGUI().isFullScreen()) {
                return;
            }
            Emulator.log.debug((Object)("saving window position of '" + identifierForConfig + "'"));
            Settings.getInstance().writeWindowPos(identifierForConfig, window.getLocation());
            if (WindowPropSaver.isWindowResizeable(window)) {
                Settings.getInstance().writeWindowSize(identifierForConfig, window.getSize());
            }
        }
    }

    private static boolean isWindowResizeable(Window window) {
        return window instanceof Frame && ((Frame)window).isResizable() || window instanceof Dialog && ((Dialog)window).isResizable();
    }

    private static boolean isWindowFrameOrDialog(Window window) {
        return window instanceof Frame || window instanceof Dialog;
    }
}

