/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.crypto;

import java.nio.ByteBuffer;
import jpcsp.crypto.KIRK;
import jpcsp.crypto.KeyVault;

public class AMCTRL {
    private static KIRK kirk;
    private static final byte[] amseed;

    public AMCTRL() {
        kirk = new KIRK(amseed, 20, -559038242, 305419896);
    }

    private static boolean isNullKey(byte[] key) {
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                if (key[i] == 0) continue;
                return false;
            }
        }
        return true;
    }

    private byte[] xorHash(byte[] dest, int dest_offset, int[] src, int src_offset, int size) {
        for (int i = 0; i < size; ++i) {
            dest[dest_offset + i] = (byte)(dest[dest_offset + i] ^ src[src_offset + i]);
        }
        return dest;
    }

    private byte[] xorKey(byte[] dest, int dest_offset, byte[] src, int src_offset, int size) {
        for (int i = 0; i < size; ++i) {
            dest[dest_offset + i] = (byte)(dest[dest_offset + i] ^ src[src_offset + i]);
        }
        return dest;
    }

    private int getModeSeed(int mode) {
        int seed;
        switch (mode) {
            case 2: {
                seed = 58;
                break;
            }
            default: {
                seed = 56;
            }
        }
        return seed;
    }

    private void ScrambleBB(byte[] buf, int size, int seed, int cbc, int kirk_code) {
        buf[0] = 0;
        buf[1] = 0;
        buf[2] = 0;
        buf[3] = (byte)cbc;
        buf[4] = 0;
        buf[5] = 0;
        buf[6] = 0;
        buf[7] = 0;
        buf[8] = 0;
        buf[9] = 0;
        buf[10] = 0;
        buf[11] = 0;
        buf[12] = 0;
        buf[13] = 0;
        buf[14] = 0;
        buf[15] = (byte)seed;
        buf[16] = (byte)(size >> 24 & 0xFF);
        buf[17] = (byte)(size >> 16 & 0xFF);
        buf[18] = (byte)(size >> 8 & 0xFF);
        buf[19] = (byte)(size & 0xFF);
        ByteBuffer bBuf = ByteBuffer.wrap(buf);
        kirk.hleUtilsBufferCopyWithRange(bBuf, size, bBuf, size, kirk_code);
    }

    private void cipherMember(BBCipher_Ctx ctx, byte[] data, int data_offset, int length) {
        byte[] dataBuf = new byte[length + 20];
        byte[] keyBuf1 = new byte[16];
        byte[] keyBuf2 = new byte[16];
        byte[] hashBuf = new byte[16];
        System.arraycopy(ctx.buf, 0, dataBuf, 20, 16);
        if (ctx.mode == 2) {
            dataBuf = this.xorHash(dataBuf, 20, KeyVault.amHashKey5, 0, 16);
            this.ScrambleBB(dataBuf, 16, 256, 5, 8);
            dataBuf = this.xorHash(dataBuf, 0, KeyVault.amHashKey4, 0, 16);
        } else {
            dataBuf = this.xorHash(dataBuf, 20, KeyVault.amHashKey5, 0, 16);
            this.ScrambleBB(dataBuf, 16, 57, 5, 7);
            dataBuf = this.xorHash(dataBuf, 0, KeyVault.amHashKey4, 0, 16);
        }
        System.arraycopy(dataBuf, 0, keyBuf2, 0, 16);
        if (ctx.seed != 1) {
            System.arraycopy(keyBuf2, 0, keyBuf1, 0, 12);
            keyBuf1[12] = (byte)(ctx.seed - 1 & 0xFF);
            keyBuf1[13] = (byte)(ctx.seed - 1 >> 8 & 0xFF);
            keyBuf1[14] = (byte)(ctx.seed - 1 >> 16 & 0xFF);
            keyBuf1[15] = (byte)(ctx.seed - 1 >> 24 & 0xFF);
        }
        for (int i = 20; i < length + 20; i += 16) {
            System.arraycopy(keyBuf2, 0, dataBuf, i, 12);
            dataBuf[i + 12] = (byte)(ctx.seed & 0xFF);
            dataBuf[i + 13] = (byte)(ctx.seed >> 8 & 0xFF);
            dataBuf[i + 14] = (byte)(ctx.seed >> 16 & 0xFF);
            dataBuf[i + 15] = (byte)(ctx.seed >> 24 & 0xFF);
            ctx.seed++;
        }
        System.arraycopy(dataBuf, length + 4, hashBuf, 0, 16);
        this.ScrambleBB(dataBuf, length, 99, 5, 7);
        dataBuf = this.xorKey(dataBuf, 0, keyBuf1, 0, 16);
        System.arraycopy(hashBuf, 0, keyBuf1, 0, 16);
        this.xorKey(data, data_offset, dataBuf, 0, length);
    }

    public int hleDrmBBMacInit(BBMac_Ctx ctx, int encMode) {
        int i;
        ctx.mode = encMode;
        ctx.padSize = 0;
        for (i = 0; i < 16; ++i) {
            ((BBMac_Ctx)ctx).pad[i] = 0;
        }
        for (i = 0; i < 16; ++i) {
            ((BBMac_Ctx)ctx).key[i] = 0;
        }
        return 0;
    }

    public int hleDrmBBMacUpdate(BBMac_Ctx ctx, byte[] data, int length) {
        if (ctx.padSize > 16 || length < 0) {
            return -1;
        }
        if (ctx.padSize + length <= 16) {
            System.arraycopy(data, 0, ctx.pad, ctx.padSize, length);
            BBMac_Ctx bBMac_Ctx = ctx;
            bBMac_Ctx.padSize = bBMac_Ctx.padSize + length;
            return 0;
        }
        int seed = this.getModeSeed(ctx.mode);
        byte[] scrambleBuf = new byte[2068];
        System.arraycopy(ctx.pad, 0, scrambleBuf, 20, ctx.padSize);
        int kLen = ctx.padSize + length & 0xF;
        if (kLen == 0) {
            kLen = 16;
        }
        int nLen = ctx.padSize;
        ctx.padSize = kLen;
        int remaining = length - kLen;
        System.arraycopy(data, remaining, ctx.pad, 0, kLen);
        int blockSize = 2048;
        for (int i = 0; i < remaining; ++i) {
            if (nLen == blockSize) {
                scrambleBuf = this.xorKey(scrambleBuf, 20, ctx.key, 0, 16);
                this.ScrambleBB(scrambleBuf, blockSize, seed, 4, 4);
                System.arraycopy(scrambleBuf, blockSize + 4, ctx.key, 0, 16);
                nLen = 0;
            }
            scrambleBuf[20 + nLen] = data[i];
            ++nLen;
        }
        if (nLen > 0) {
            scrambleBuf = this.xorKey(scrambleBuf, 20, ctx.key, 0, 16);
            this.ScrambleBB(scrambleBuf, nLen, seed, 4, 4);
            System.arraycopy(scrambleBuf, nLen + 4, ctx.key, 0, 16);
        }
        return 0;
    }

    public int hleDrmBBMacFinal(BBMac_Ctx ctx, byte[] hash, byte[] key) {
        int i;
        if (ctx.padSize > 16) {
            return -1;
        }
        int seed = this.getModeSeed(ctx.mode);
        byte[] scrambleBuf = new byte[2068];
        byte[] keyBuf = new byte[16];
        byte[] resultBuf = new byte[16];
        this.ScrambleBB(scrambleBuf, 16, seed, 4, 4);
        System.arraycopy(scrambleBuf, 20, keyBuf, 0, 16);
        int b = (keyBuf[0] & 0xFFFFFF80) != 0 ? -121 : 0;
        for (int i2 = 0; i2 < 15; ++i2) {
            int b1 = (keyBuf[i2] & 0xFF) << 1;
            int b2 = (keyBuf[i2 + 1] & 0xFF) >> 7;
            keyBuf[i2] = (byte)(b1 | b2);
        }
        byte t = (byte)((keyBuf[15] & 0xFF) << 1);
        keyBuf[15] = (byte)(t ^ b);
        if (ctx.padSize < 16) {
            int bb = keyBuf[0] < 0 ? -121 : 0;
            for (int i3 = 0; i3 < 15; ++i3) {
                int bb1 = (keyBuf[i3] & 0xFF) << 1;
                int bb2 = (keyBuf[i3 + 1] & 0xFF) >> 7;
                keyBuf[i3] = (byte)(bb1 | bb2);
            }
            byte tt = (byte)((keyBuf[15] & 0xFF) << 1);
            keyBuf[15] = (byte)(tt ^ bb);
            ((BBMac_Ctx)ctx).pad[((BBMac_Ctx)ctx).padSize] = -128;
            if (ctx.padSize + 1 < 16) {
                for (int i4 = 0; i4 < 16 - ctx.padSize - 1; ++i4) {
                    ((BBMac_Ctx)ctx).pad[((BBMac_Ctx)ctx).padSize + 1 + i4] = 0;
                }
            }
        }
        BBMac_Ctx.access$502(ctx, this.xorKey(ctx.pad, 0, keyBuf, 0, 16));
        System.arraycopy(ctx.pad, 0, scrambleBuf, 20, 16);
        System.arraycopy(ctx.key, 0, resultBuf, 0, 16);
        scrambleBuf = this.xorKey(scrambleBuf, 20, resultBuf, 0, 16);
        this.ScrambleBB(scrambleBuf, 16, seed, 4, 4);
        System.arraycopy(scrambleBuf, 20, resultBuf, 0, 16);
        resultBuf = this.xorHash(resultBuf, 0, KeyVault.amHashKey3, 0, 16);
        if (ctx.mode == 2) {
            System.arraycopy(resultBuf, 0, scrambleBuf, 20, 16);
            this.ScrambleBB(scrambleBuf, 16, 256, 4, 5);
            this.ScrambleBB(scrambleBuf, 16, seed, 4, 4);
            System.arraycopy(scrambleBuf, 20, resultBuf, 0, 16);
        }
        if (key != null) {
            resultBuf = this.xorKey(resultBuf, 0, key, 0, 16);
            System.arraycopy(resultBuf, 0, scrambleBuf, 20, 16);
            this.ScrambleBB(scrambleBuf, 16, seed, 4, 4);
            System.arraycopy(scrambleBuf, 20, resultBuf, 0, 16);
        }
        System.arraycopy(resultBuf, 0, hash, 0, 16);
        ctx.mode = 0;
        ctx.padSize = 0;
        for (i = 0; i < 16; ++i) {
            ((BBMac_Ctx)ctx).pad[i] = 0;
        }
        for (i = 0; i < 16; ++i) {
            ((BBMac_Ctx)ctx).key[i] = 0;
        }
        return 0;
    }

    public int hleDrmBBMacFinal2(BBMac_Ctx ctx, byte[] hash, byte[] key) {
        byte[] resBuf = new byte[16];
        byte[] hashBuf = new byte[16];
        int mode = ctx.mode;
        this.hleDrmBBMacFinal(ctx, resBuf, key);
        hashBuf = (mode & 3) == 3 ? this.DecryptBBMacKey(hash, 99) : hash;
        for (int i = 0; i < 16; ++i) {
            if (hashBuf[i] == resBuf[i]) continue;
            return -1;
        }
        return 0;
    }

    public int hleDrmBBCipherInit(BBCipher_Ctx ctx, int encMode, int genMode, byte[] data, byte[] key) {
        return this.hleDrmBBCipherInit(ctx, encMode, genMode, data, key, 0);
    }

    public int hleDrmBBCipherInit(BBCipher_Ctx ctx, int encMode, int genMode, byte[] data, byte[] key, int seed) {
        if (key.length < 16) {
            return -1;
        }
        ctx.mode = encMode;
        ctx.seed = seed + 1;
        if (genMode == 1) {
            byte[] header = new byte[36];
            byte[] rseed = new byte[20];
            ByteBuffer bSeed = ByteBuffer.wrap(rseed);
            kirk.hleUtilsBufferCopyWithRange(bSeed, 20, null, 0, 14);
            System.arraycopy(bSeed.array(), 0, header, 0, 20);
            System.arraycopy(bSeed.array(), 0, header, 20, 16);
            header[32] = 0;
            header[33] = 0;
            header[34] = 0;
            header[35] = 0;
            if (ctx.mode == 2) {
                header = this.xorHash(header, 20, KeyVault.amHashKey4, 0, 16);
                this.ScrambleBB(header, 16, 256, 4, 5);
                header = this.xorHash(header, 20, KeyVault.amHashKey5, 0, 16);
                System.arraycopy(header, 20, ctx.buf, 0, 16);
                System.arraycopy(header, 20, data, 0, 16);
                if (!AMCTRL.isNullKey(key)) {
                    BBCipher_Ctx.access$002(ctx, this.xorKey(ctx.buf, 0, key, 0, 16));
                }
            } else {
                header = this.xorHash(header, 20, KeyVault.amHashKey4, 0, 16);
                this.ScrambleBB(header, 16, 57, 4, 4);
                header = this.xorHash(header, 20, KeyVault.amHashKey5, 0, 16);
                System.arraycopy(header, 20, ctx.buf, 0, 16);
                System.arraycopy(header, 20, data, 0, 16);
                if (!AMCTRL.isNullKey(key)) {
                    BBCipher_Ctx.access$002(ctx, this.xorKey(ctx.buf, 0, key, 0, 16));
                }
            }
        } else if (genMode == 2) {
            System.arraycopy(data, 0, ctx.buf, 0, 16);
            if (!AMCTRL.isNullKey(key)) {
                BBCipher_Ctx.access$002(ctx, this.xorKey(ctx.buf, 0, key, 0, 16));
            }
        } else {
            return -1;
        }
        return 0;
    }

    public int hleDrmBBCipherUpdate(BBCipher_Ctx ctx, byte[] data, int length) {
        if (length == 0) {
            return 0;
        }
        if ((length & 0xF) != 0) {
            return -1;
        }
        int index = 0;
        if (length >= 2048) {
            index = 0;
            while (length >= 2048) {
                this.cipherMember(ctx, data, index, 2048);
                length -= 2048;
                index += 2048;
            }
        }
        if (length >= 16) {
            this.cipherMember(ctx, data, index, length);
        }
        return 0;
    }

    public int hleDrmBBCipherFinal(BBCipher_Ctx ctx) {
        ctx.mode = 0;
        ctx.seed = 0;
        for (int i = 0; i < 16; ++i) {
            ((BBCipher_Ctx)ctx).buf[i] = 0;
        }
        return 0;
    }

    public byte[] DecryptBBMacKey(byte[] key, int seed) {
        byte[] scrambleBuf = new byte[36];
        byte[] decKey = new byte[16];
        System.arraycopy(key, 0, scrambleBuf, 20, 16);
        this.ScrambleBB(scrambleBuf, 16, seed, 5, 7);
        System.arraycopy(scrambleBuf, 0, decKey, 0, 16);
        return decKey;
    }

    public byte[] GetKeyFromBBMac(BBMac_Ctx ctx, byte[] bbmac) {
        byte[] key = new byte[16];
        byte[] decKey = new byte[16];
        byte[] macKey = new byte[16];
        byte[] finalKey = new byte[16];
        int mode = ctx.mode;
        this.hleDrmBBMacFinal(ctx, macKey, null);
        if ((mode & 3) == 3) {
            decKey = this.DecryptBBMacKey(bbmac, 99);
        } else {
            System.arraycopy(bbmac, 0, decKey, 0, 16);
        }
        int seed = this.getModeSeed(mode);
        finalKey = this.DecryptBBMacKey(decKey, seed);
        key = this.xorKey(macKey, 0, finalKey, 0, 16);
        return key;
    }

    static {
        amseed = new byte[]{65, 77, 67, 84, 82, 76, 83, 69, 69, 68, 74, 80, 67, 83, 80, 48, 48, 48, 48, 48};
    }

    public static class BBMac_Ctx {
        private int mode = 0;
        private byte[] key = new byte[16];
        private byte[] pad = new byte[16];
        private int padSize = 0;

        static /* synthetic */ byte[] access$502(BBMac_Ctx x0, byte[] x1) {
            x0.pad = x1;
            return x1;
        }
    }

    public static class BBCipher_Ctx {
        private int mode = 0;
        private int seed = 0;
        private byte[] buf = new byte[16];

        static /* synthetic */ byte[] access$002(BBCipher_Ctx x0, byte[] x1) {
            x0.buf = x1;
            return x1;
        }
    }
}

