/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.crypto;

import jpcsp.crypto.AMCTRL;
import jpcsp.crypto.KeyVault;

public class PGD {
    private static AMCTRL amctrl;
    private AMCTRL.BBCipher_Ctx pgdCipherContext;
    private AMCTRL.BBMac_Ctx pgdMacContext;

    public PGD() {
        amctrl = new AMCTRL();
    }

    public byte[] DecryptPGD(byte[] inbuf, int size, byte[] key, int seed) {
        int sdEncMode = 1;
        int sdGenMode = 2;
        this.pgdMacContext = new AMCTRL.BBMac_Ctx();
        this.pgdCipherContext = new AMCTRL.BBCipher_Ctx();
        int alignedSize = size + 15 >> 4 << 4;
        byte[] outbuf = new byte[alignedSize - 16];
        byte[] dataBuf = new byte[alignedSize];
        System.arraycopy(inbuf, 0, dataBuf, 0, size);
        amctrl.hleDrmBBMacInit(this.pgdMacContext, sdEncMode);
        amctrl.hleDrmBBCipherInit(this.pgdCipherContext, sdEncMode, sdGenMode, dataBuf, key, seed);
        amctrl.hleDrmBBMacUpdate(this.pgdMacContext, dataBuf, 16);
        System.arraycopy(dataBuf, 16, outbuf, 0, alignedSize - 16);
        amctrl.hleDrmBBMacUpdate(this.pgdMacContext, outbuf, alignedSize - 16);
        amctrl.hleDrmBBCipherUpdate(this.pgdCipherContext, outbuf, alignedSize - 16);
        return outbuf;
    }

    public byte[] UpdatePGDCipher(byte[] inbuf, int size) {
        int alignedSize = size + 15 >> 4 << 4;
        byte[] outbuf = new byte[alignedSize - 16];
        byte[] dataBuf = new byte[alignedSize];
        System.arraycopy(inbuf, 0, dataBuf, 0, size);
        System.arraycopy(dataBuf, 16, outbuf, 0, alignedSize - 16);
        amctrl.hleDrmBBCipherUpdate(this.pgdCipherContext, outbuf, alignedSize - 16);
        return outbuf;
    }

    public void FinishPGDCipher() {
        amctrl.hleDrmBBCipherFinal(this.pgdCipherContext);
    }

    public byte[] GetEDATPGDKey(byte[] inbuf, int size) {
        int i;
        int macEncMode;
        int pgdFlag = 2;
        this.pgdMacContext = new AMCTRL.BBMac_Ctx();
        int alignedSize = size + 15 >> 4 << 4;
        byte[] dataBuf = new byte[alignedSize];
        System.arraycopy(inbuf, 0, dataBuf, 0, size);
        byte keyIndex = dataBuf[4];
        byte drmType = dataBuf[8];
        if ((drmType & 1) == 1) {
            macEncMode = 1;
            pgdFlag |= 4;
            if (keyIndex > 1) {
                macEncMode = 3;
                pgdFlag |= 8;
            }
        } else {
            macEncMode = 2;
        }
        byte[] dnasKey = new byte[16];
        if ((pgdFlag & 2) == 2) {
            for (i = 0; i < KeyVault.drmDNASKey1.length; ++i) {
                dnasKey[i] = (byte)(KeyVault.drmDNASKey1[i] & 0xFF);
            }
        } else if ((pgdFlag & 1) == 1) {
            for (i = 0; i < KeyVault.drmDNASKey2.length; ++i) {
                dnasKey[i] = (byte)(KeyVault.drmDNASKey2[i] & 0xFF);
            }
        } else {
            return null;
        }
        byte[] macKey80 = new byte[16];
        System.arraycopy(dataBuf, 128, macKey80, 0, 16);
        byte[] macKey70 = new byte[16];
        System.arraycopy(dataBuf, 112, macKey70, 0, 16);
        amctrl.hleDrmBBMacInit(this.pgdMacContext, macEncMode);
        amctrl.hleDrmBBMacUpdate(this.pgdMacContext, dataBuf, 128);
        amctrl.hleDrmBBMacFinal2(this.pgdMacContext, macKey80, dnasKey);
        amctrl.hleDrmBBMacInit(this.pgdMacContext, macEncMode);
        amctrl.hleDrmBBMacUpdate(this.pgdMacContext, dataBuf, 112);
        return amctrl.GetKeyFromBBMac(this.pgdMacContext, macKey70);
    }

    public boolean CheckEDATRenameKey(byte[] fileName, byte[] hash, byte[] data) {
        this.pgdMacContext = new AMCTRL.BBMac_Ctx();
        amctrl.hleDrmBBMacInit(this.pgdMacContext, 3);
        amctrl.hleDrmBBMacUpdate(this.pgdMacContext, data, 48);
        amctrl.hleDrmBBMacUpdate(this.pgdMacContext, fileName, fileName.length);
        byte[] renameKey = new byte[16];
        for (int i = 0; i < 16; ++i) {
            renameKey[i] = (byte)(KeyVault.drmRenameKey[i] & 0xFF);
        }
        return amctrl.hleDrmBBMacFinal2(this.pgdMacContext, hash, renameKey) == 0;
    }
}

