/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;

public class DeferredStub {
    protected SceModule sourceModule;
    private String moduleName;
    private int importAddress;
    private int nid;
    private boolean savedImport;
    private int savedImport1;
    private int savedImport2;

    public DeferredStub(SceModule sourceModule, String moduleName, int importAddress, int nid) {
        this.sourceModule = sourceModule;
        this.moduleName = moduleName;
        this.importAddress = importAddress & 0x1FFFFFFF;
        this.nid = nid;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public int getImportAddress() {
        return this.importAddress;
    }

    public int getNid() {
        return this.nid;
    }

    protected void invalidate(int address, int size) {
        RuntimeContext.invalidateRange(address, size);
    }

    public void resolve(Memory mem, int address) {
        if (!this.savedImport) {
            this.savedImport1 = mem.read32(this.importAddress);
            this.savedImport2 = mem.read32(this.importAddress + 4);
            this.savedImport = true;
        }
        mem.write32(this.importAddress, ThreadManForUser.J(address));
        mem.write32(this.importAddress + 4, 0);
        this.invalidate(this.importAddress, 8);
    }

    public void unresolve(Memory mem) {
        if (this.savedImport) {
            mem.write32(this.importAddress, this.savedImport1);
            mem.write32(this.importAddress + 4, this.savedImport2);
        } else {
            mem.write32(this.importAddress + 4, ThreadManForUser.SYSCALL(1048575));
        }
        this.invalidate(this.importAddress, 8);
        if (this.sourceModule != null) {
            this.sourceModule.unresolvedImports.add(this);
        }
    }

    public String toString() {
        return String.format("0x%08X [0x%08X] Module '%s'", this.getImportAddress(), this.getNid(), this.getModuleName());
    }
}

