/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import jpcsp.crypto.CryptoEngine;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;

public class PSP {
    public static final int PSP_HEADER_SIZE = 336;
    public static final int PSP_MAGIC = 1347637374;
    public static final int SCE_KERNEL_MAX_MODULE_SEGMENT = 4;
    public static final int AES_KEY_SIZE = 16;
    public static final int CMAC_KEY_SIZE = 16;
    public static final int CMAC_HEADER_HASH_SIZE = 16;
    public static final int CMAC_DATA_HASH_SIZE = 16;
    public static final int CHECK_SIZE = 88;
    public static final int SHA1_HASH_SIZE = 20;
    public static final int KEY_DATA_SIZE = 16;
    private int magic;
    private int mod_attr;
    private int comp_mod_attr;
    private int mod_ver_lo;
    private int mod_ver_hi;
    private String modname;
    private int mod_version;
    private int nsegments;
    private int elf_size;
    private int psp_size;
    private int boot_entry;
    private int modinfo_offset;
    private int bss_size;
    private int[] seg_align = new int[4];
    private int[] seg_address = new int[4];
    private int[] seg_size = new int[4];
    private int[] reserved = new int[5];
    private int devkit_version;
    private int dec_mode;
    private int pad;
    private int overlap_size;
    private int[] aes_key = new int[16];
    private int[] cmac_key = new int[16];
    private int[] cmac_header_hash = new int[16];
    private int comp_size;
    private int comp_offset;
    private int unk1;
    private int unk2;
    private int[] cmac_data_hash = new int[16];
    private int tag;
    private int[] sig_check = new int[88];
    private int[] sha1_hash = new int[20];
    private int[] key_data = new int[16];

    public PSP(ByteBuffer f) throws IOException {
        this.read(f);
    }

    private void read(ByteBuffer f) throws IOException {
        int i;
        if (f.capacity() == 0) {
            return;
        }
        this.magic = Utilities.readWord(f);
        this.mod_attr = Utilities.readUHalf(f);
        this.comp_mod_attr = Utilities.readUHalf(f);
        this.mod_ver_lo = Utilities.readUByte(f);
        this.mod_ver_hi = Utilities.readUByte(f);
        this.modname = Utilities.readStringNZ(f, 28);
        this.mod_version = Utilities.readUByte(f);
        this.nsegments = Utilities.readUByte(f);
        this.elf_size = Utilities.readWord(f);
        this.psp_size = Utilities.readWord(f);
        this.boot_entry = Utilities.readWord(f);
        this.modinfo_offset = Utilities.readWord(f);
        this.bss_size = Utilities.readWord(f);
        this.seg_align[0] = Utilities.readUHalf(f);
        this.seg_align[1] = Utilities.readUHalf(f);
        this.seg_align[2] = Utilities.readUHalf(f);
        this.seg_align[3] = Utilities.readUHalf(f);
        this.seg_address[0] = Utilities.readWord(f);
        this.seg_address[1] = Utilities.readWord(f);
        this.seg_address[2] = Utilities.readWord(f);
        this.seg_address[3] = Utilities.readWord(f);
        this.seg_size[0] = Utilities.readWord(f);
        this.seg_size[1] = Utilities.readWord(f);
        this.seg_size[2] = Utilities.readWord(f);
        this.seg_size[3] = Utilities.readWord(f);
        this.reserved[0] = Utilities.readWord(f);
        this.reserved[1] = Utilities.readWord(f);
        this.reserved[2] = Utilities.readWord(f);
        this.reserved[3] = Utilities.readWord(f);
        this.reserved[4] = Utilities.readWord(f);
        this.devkit_version = Utilities.readWord(f);
        this.dec_mode = Utilities.readUByte(f);
        this.pad = Utilities.readUByte(f);
        this.overlap_size = Utilities.readUHalf(f);
        for (i = 0; i < 16; ++i) {
            this.aes_key[i] = Utilities.readUByte(f);
        }
        for (i = 0; i < 16; ++i) {
            this.cmac_key[i] = Utilities.readUByte(f);
        }
        for (i = 0; i < 16; ++i) {
            this.cmac_header_hash[i] = Utilities.readUByte(f);
        }
        this.comp_size = Utilities.readWord(f);
        this.comp_offset = Utilities.readWord(f);
        this.unk1 = Utilities.readWord(f);
        this.unk2 = Utilities.readWord(f);
        for (i = 0; i < 16; ++i) {
            this.cmac_data_hash[i] = Utilities.readUByte(f);
        }
        this.tag = Utilities.readWord(f);
        for (i = 0; i < 88; ++i) {
            this.sig_check[i] = Utilities.readUByte(f);
        }
        for (i = 0; i < 20; ++i) {
            this.sha1_hash[i] = Utilities.readUByte(f);
        }
        for (i = 0; i < 16; ++i) {
            this.key_data[i] = Utilities.readUByte(f);
        }
    }

    public ByteBuffer decrypt(ByteBuffer f, boolean isSignChecked) {
        byte[] inBuf;
        if (f.capacity() == 0) {
            return null;
        }
        CryptoEngine crypto = new CryptoEngine();
        if (f.hasArray() && f.position() <= 336) {
            inBuf = f.array();
        } else {
            int currentPosition = f.position();
            f.position(currentPosition - 336);
            int size = Math.min(Math.max(this.psp_size, this.elf_size), f.remaining());
            inBuf = new byte[size];
            f.get(inBuf);
            f.position(currentPosition);
        }
        int inSize = inBuf.length;
        byte[] elfBuffer = crypto.getPRXEngine().DecryptAndUncompressPRX(inBuf, inSize, isSignChecked);
        if (elfBuffer == null) {
            return null;
        }
        if (CryptoEngine.getExtractEbootStatus()) {
            try {
                String ebootPath = Settings.getInstance().getDiscTmpDirectory();
                new File(ebootPath).mkdirs();
                RandomAccessFile raf = new RandomAccessFile(ebootPath + "EBOOT.BIN", "rw");
                raf.write(elfBuffer);
                raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ByteBuffer.wrap(elfBuffer);
    }

    public boolean isValid() {
        return this.magic == 1347637374;
    }

    public String getModname() {
        return this.modname;
    }

    public int getDevkitVersion() {
        return this.devkit_version;
    }
}

