/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.psmf;

import jpcsp.Emulator;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractProxyVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;
import org.apache.log4j.Logger;

public class PsmfAudioOMAVirtualFile
extends AbstractProxyVirtualFile {
    private static Logger log = Emulator.log;
    private int remainingFrameLength;
    private final byte[] header = new byte[8];

    public PsmfAudioOMAVirtualFile(IVirtualFile vFile) {
        super(vFile);
    }

    private boolean readHeader() {
        int length = this.vFile.ioRead(this.header, 0, this.header.length);
        if (length < this.header.length) {
            return false;
        }
        if (this.header[0] != 15 || this.header[1] != -48) {
            log.warn((Object)String.format("Invalid header 0x%02X 0x%02X", this.header[0] & 0xFF, this.header[1] & 0xFF));
            return false;
        }
        this.remainingFrameLength = ((this.header[2] & 3) << 8 | (this.header[3] & 0xFF) << 3) + 8;
        return true;
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        return super.ioRead(outputPointer, outputLength);
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        int readLength = 0;
        boolean error = false;
        while (outputLength > 0) {
            if (this.remainingFrameLength == 0 && !this.readHeader()) {
                error = true;
                break;
            }
            int length = this.vFile.ioRead(outputBuffer, outputOffset, Math.min(outputLength, this.remainingFrameLength));
            if (length < 0) {
                error = true;
                break;
            }
            readLength += length;
            outputOffset += length;
            outputLength -= length;
            this.remainingFrameLength -= length;
        }
        if (error && readLength == 0) {
            return -1;
        }
        return readLength;
    }
}

