/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.vsmx.interpreter;

import java.util.Arrays;
import java.util.Stack;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXUndefined;

public class VSMXCallState {
    private VSMXBaseObject thisObject;
    private VSMXBaseObject[] localVariables;
    private Stack<VSMXBaseObject> stack;
    private int returnPc;
    private boolean returnThis;
    private boolean exitAfterCall;

    public VSMXCallState(VSMXBaseObject thisObject, int numberOfLocalVariables, int returnPc, boolean returnThis, boolean exitAfterCall) {
        this.thisObject = thisObject;
        this.localVariables = new VSMXBaseObject[numberOfLocalVariables];
        Arrays.fill(this.localVariables, VSMXUndefined.singleton);
        this.stack = new Stack();
        this.returnPc = returnPc;
        this.returnThis = returnThis;
        this.exitAfterCall = exitAfterCall;
    }

    public int getReturnPc() {
        return this.returnPc;
    }

    public VSMXBaseObject getThisObject() {
        return this.thisObject;
    }

    public VSMXBaseObject getLocalVar(int i) {
        if (i <= 0 || i > this.localVariables.length) {
            return VSMXUndefined.singleton;
        }
        return this.localVariables[i - 1];
    }

    public void setLocalVar(int i, VSMXBaseObject value) {
        if (i > 0 && i <= this.localVariables.length) {
            this.localVariables[i - 1] = value;
        }
    }

    public Stack<VSMXBaseObject> getStack() {
        return this.stack;
    }

    public boolean getReturnThis() {
        return this.returnThis;
    }

    public boolean getExitAfterCall() {
        return this.exitAfterCall;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(String.format("CallState[returnPc=%d, this=%s", this.returnPc, this.thisObject));
        for (int i = 1; i <= this.localVariables.length; ++i) {
            s.append(String.format(", var%d=%s", i, this.getLocalVar(i)));
        }
        s.append("]");
        return s.toString();
    }
}

