/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.vsmx.interpreter;

import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXInterpreter;
import jpcsp.format.rco.vsmx.interpreter.VSMXNumber;

public class VSMXString
extends VSMXBaseObject {
    private String value;

    public VSMXString(VSMXInterpreter interpreter, String value) {
        super(interpreter);
        this.value = value;
    }

    @Override
    public float getFloatValue() {
        return Float.valueOf(this.value).floatValue();
    }

    @Override
    public void setFloatValue(float value) {
        this.value = Float.toString(value);
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public VSMXBaseObject getPropertyValue(String name) {
        if ("length".equals(name)) {
            return new VSMXNumber(this.interpreter, this.value.length());
        }
        return super.getPropertyValue(name);
    }

    @Override
    public boolean equals(VSMXBaseObject value) {
        return this.getStringValue().equals(value.getStringValue());
    }

    @Override
    public boolean identity(VSMXBaseObject value) {
        if (value instanceof VSMXString) {
            return this.getStringValue().equals(value.getStringValue());
        }
        return super.identity(value);
    }

    @Override
    public String typeOf() {
        return "string";
    }

    @Override
    public String getClassName() {
        return "String";
    }

    public VSMXBaseObject toUpperCase(VSMXBaseObject object) {
        return new VSMXString(this.getInterpreter(), this.getStringValue().toUpperCase());
    }

    public VSMXBaseObject toLowerCase(VSMXBaseObject object) {
        return new VSMXString(this.getInterpreter(), this.getStringValue().toLowerCase());
    }

    public VSMXBaseObject substring(VSMXBaseObject object, VSMXBaseObject start) {
        String s = this.getStringValue();
        int beginIndex = start.getIntValue();
        beginIndex = Math.max(beginIndex, 0);
        beginIndex = Math.min(beginIndex, s.length());
        return new VSMXString(this.getInterpreter(), s.substring(beginIndex));
    }

    public VSMXBaseObject substring(VSMXBaseObject object, VSMXBaseObject start, VSMXBaseObject end) {
        String s = this.getStringValue();
        int beginIndex = start.getIntValue();
        beginIndex = Math.max(beginIndex, 0);
        beginIndex = Math.min(beginIndex, s.length());
        int endIndex = end.getIntValue();
        endIndex = Math.max(endIndex, 0);
        if (beginIndex > (endIndex = Math.min(endIndex, s.length()))) {
            int tmp = beginIndex;
            beginIndex = endIndex;
            endIndex = tmp;
        }
        return new VSMXString(this.getInterpreter(), s.substring(beginIndex, endIndex));
    }

    public VSMXBaseObject lastIndexOf(VSMXBaseObject object, VSMXBaseObject substring) {
        return this.lastIndexOf(object, substring, new VSMXNumber(this.interpreter, object.getStringValue().length()));
    }

    public VSMXBaseObject lastIndexOf(VSMXBaseObject object, VSMXBaseObject substring, VSMXBaseObject startIndex) {
        int startIndexInt = startIndex.getIntValue();
        String substringString = substring.getStringValue();
        String s = this.getStringValue();
        if (startIndexInt < 0) {
            startIndexInt = 0;
        } else if (startIndexInt > s.length()) {
            startIndexInt = s.length();
        }
        int lastIndexOfInt = s.lastIndexOf(substringString, startIndexInt);
        return new VSMXNumber(this.interpreter, lastIndexOfInt);
    }

    public VSMXBaseObject charAt(VSMXBaseObject object, VSMXBaseObject index) {
        String s = this.getStringValue();
        int i = index.getIntValue();
        if (i < 0 || i >= s.length()) {
            return new VSMXString(this.interpreter, "");
        }
        char c = s.charAt(i);
        return new VSMXString(this.interpreter, "" + c);
    }

    @Override
    public String toString() {
        return String.format("\"%s\"", this.value);
    }
}

