/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.ShaderContext;
import jpcsp.graphics.Uniforms;
import jpcsp.graphics.VideoEngine;
import jpcsp.settings.Settings;

public class ShaderContextUBO
extends ShaderContext {
    private ShaderUniformInfo lightType;
    private ShaderUniformInfo lightKind;
    private ShaderUniformInfo lightEnabled;
    private ShaderUniformInfo vertexColor;
    private ShaderUniformInfo colorMask;
    private ShaderUniformInfo notColorMask;
    private ShaderUniformInfo matFlags;
    private ShaderUniformInfo ctestRef;
    private ShaderUniformInfo ctestMsk;
    private ShaderUniformInfo texShade;
    private ShaderUniformInfo texEnvMode;
    private ShaderUniformInfo ctestFunc;
    private ShaderUniformInfo texMapMode;
    private ShaderUniformInfo texMapProj;
    private ShaderUniformInfo vinfoColor;
    private ShaderUniformInfo vinfoPosition;
    private ShaderUniformInfo vinfoTexture;
    private ShaderUniformInfo vinfoNormal;
    private ShaderUniformInfo positionScale;
    private ShaderUniformInfo normalScale;
    private ShaderUniformInfo textureScale;
    private ShaderUniformInfo weightScale;
    private ShaderUniformInfo colorDoubling;
    private ShaderUniformInfo texEnable;
    private ShaderUniformInfo lightingEnable;
    private ShaderUniformInfo vinfoTransform2D;
    private ShaderUniformInfo ctestEnable;
    private ShaderUniformInfo lightMode;
    private ShaderUniformInfo clutShift;
    private ShaderUniformInfo clutMask;
    private ShaderUniformInfo clutOffset;
    private ShaderUniformInfo mipmapShareClut;
    private ShaderUniformInfo texPixelFormat;
    private ShaderUniformInfo stencilTestEnable;
    private ShaderUniformInfo stencilFunc;
    private ShaderUniformInfo stencilRef;
    private ShaderUniformInfo stencilMask;
    private ShaderUniformInfo stencilOpFail;
    private ShaderUniformInfo stencilOpZFail;
    private ShaderUniformInfo stencilOpZPass;
    private ShaderUniformInfo depthTestEnable;
    private ShaderUniformInfo depthFunc;
    private ShaderUniformInfo depthMask;
    private ShaderUniformInfo alphaTestEnable;
    private ShaderUniformInfo alphaTestFunc;
    private ShaderUniformInfo alphaTestRef;
    private ShaderUniformInfo alphaTestMask;
    private ShaderUniformInfo blendTestEnable;
    private ShaderUniformInfo blendEquation;
    private ShaderUniformInfo blendSrc;
    private ShaderUniformInfo blendDst;
    private ShaderUniformInfo blendSFix;
    private ShaderUniformInfo blendDFix;
    private ShaderUniformInfo colorMaskEnable;
    private ShaderUniformInfo wrapModeS;
    private ShaderUniformInfo wrapModeT;
    private ShaderUniformInfo copyRedToAlpha;
    private ShaderUniformInfo fogEnable;
    private ShaderUniformInfo fogColor;
    private ShaderUniformInfo fogEnd;
    private ShaderUniformInfo fogScale;
    private ShaderUniformInfo clipPlaneEnable;
    private ShaderUniformInfo viewportPos;
    private ShaderUniformInfo viewportScale;
    private ShaderUniformInfo numberBones;
    private ShaderUniformInfo boneMatrix;
    private ShaderUniformInfo endOfUBO;
    private int bufferSize;
    protected static final int bindingPoint = 1;
    protected static final String uniformBlockName = "psp";
    protected static final String uniformMemoryLayout = "std140";
    protected int buffer;
    protected ByteBuffer data;
    private int startUpdate;
    private int endUpdate;
    private String shaderUniformText;
    private ArrayList<ShaderUniformInfo> shaderUniformInfos = new ArrayList();

    public static boolean useUBO(IRenderingEngine re) {
        return !Settings.getInstance().readBool("emu.disableubo") && re.isExtensionAvailable("GL_ARB_uniform_buffer_object");
    }

    public ShaderContextUBO(IRenderingEngine re) {
        this.lightType = this.addShaderUniform(Uniforms.lightType, "ivec4");
        this.lightKind = this.addShaderUniform(Uniforms.lightKind, "ivec4");
        this.lightEnabled = this.addShaderUniform(Uniforms.lightEnabled, "ivec4");
        this.vertexColor = this.addShaderUniform(Uniforms.vertexColor, "vec4");
        this.colorMask = this.addShaderUniform(Uniforms.colorMask, "ivec4");
        this.notColorMask = this.addShaderUniform(Uniforms.notColorMask, "ivec4");
        this.blendSFix = this.addShaderUniform(Uniforms.blendSFix, "vec3");
        this.blendDFix = this.addShaderUniform(Uniforms.blendDFix, "vec3");
        this.matFlags = this.addShaderUniform(Uniforms.matFlags, "ivec3");
        this.ctestRef = this.addShaderUniform(Uniforms.ctestRef, "ivec3");
        this.ctestMsk = this.addShaderUniform(Uniforms.ctestMsk, "ivec3");
        this.texShade = this.addShaderUniform(Uniforms.texShade, "ivec2");
        this.texEnvMode = this.addShaderUniform(Uniforms.texEnvMode, "ivec2");
        this.ctestFunc = this.addShaderUniform(Uniforms.ctestFunc, "int");
        this.texMapMode = this.addShaderUniform(Uniforms.texMapMode, "int");
        this.texMapProj = this.addShaderUniform(Uniforms.texMapProj, "int");
        this.vinfoColor = this.addShaderUniform(Uniforms.vinfoColor, "int");
        this.vinfoPosition = this.addShaderUniform(Uniforms.vinfoPosition, "int");
        this.vinfoTexture = this.addShaderUniform(Uniforms.vinfoTexture, "int");
        this.vinfoNormal = this.addShaderUniform(Uniforms.vinfoNormal, "int");
        this.positionScale = this.addShaderUniform(Uniforms.positionScale, "float");
        this.normalScale = this.addShaderUniform(Uniforms.normalScale, "float");
        this.textureScale = this.addShaderUniform(Uniforms.textureScale, "float");
        this.weightScale = this.addShaderUniform(Uniforms.weightScale, "float");
        this.colorDoubling = this.addShaderUniform(Uniforms.colorDoubling, "float");
        this.texEnable = this.addShaderUniform(Uniforms.texEnable, "bool");
        this.lightingEnable = this.addShaderUniform(Uniforms.lightingEnable, "bool");
        this.vinfoTransform2D = this.addShaderUniform(Uniforms.vinfoTransform2D, "bool");
        this.ctestEnable = this.addShaderUniform(Uniforms.ctestEnable, "bool");
        this.lightMode = this.addShaderUniform(Uniforms.lightMode, "bool");
        this.clutShift = this.addShaderUniform(Uniforms.clutShift, "int");
        this.clutMask = this.addShaderUniform(Uniforms.clutMask, "int");
        this.clutOffset = this.addShaderUniform(Uniforms.clutOffset, "int");
        this.mipmapShareClut = this.addShaderUniform(Uniforms.mipmapShareClut, "bool");
        this.texPixelFormat = this.addShaderUniform(Uniforms.texPixelFormat, "int");
        this.stencilTestEnable = this.addShaderUniform(Uniforms.stencilTestEnable, "bool");
        this.stencilFunc = this.addShaderUniform(Uniforms.stencilFunc, "int");
        this.stencilRef = this.addShaderUniform(Uniforms.stencilRef, "int");
        this.stencilMask = this.addShaderUniform(Uniforms.stencilMask, "int");
        this.stencilOpFail = this.addShaderUniform(Uniforms.stencilOpFail, "int");
        this.stencilOpZFail = this.addShaderUniform(Uniforms.stencilOpZFail, "int");
        this.stencilOpZPass = this.addShaderUniform(Uniforms.stencilOpZPass, "int");
        this.depthTestEnable = this.addShaderUniform(Uniforms.depthTestEnable, "bool");
        this.depthFunc = this.addShaderUniform(Uniforms.depthFunc, "int");
        this.depthMask = this.addShaderUniform(Uniforms.depthMask, "int");
        this.alphaTestEnable = this.addShaderUniform(Uniforms.alphaTestEnable, "bool");
        this.alphaTestFunc = this.addShaderUniform(Uniforms.alphaTestFunc, "int");
        this.alphaTestRef = this.addShaderUniform(Uniforms.alphaTestRef, "int");
        this.alphaTestMask = this.addShaderUniform(Uniforms.alphaTestMask, "int");
        this.blendTestEnable = this.addShaderUniform(Uniforms.blendTestEnable, "bool");
        this.blendEquation = this.addShaderUniform(Uniforms.blendEquation, "int");
        this.blendSrc = this.addShaderUniform(Uniforms.blendSrc, "int");
        this.blendDst = this.addShaderUniform(Uniforms.blendDst, "int");
        this.colorMaskEnable = this.addShaderUniform(Uniforms.colorMaskEnable, "bool");
        this.wrapModeS = this.addShaderUniform(Uniforms.wrapModeS, "int");
        this.wrapModeT = this.addShaderUniform(Uniforms.wrapModeT, "int");
        this.copyRedToAlpha = this.addShaderUniform(Uniforms.copyRedToAlpha, "bool");
        this.fogEnable = this.addShaderUniform(Uniforms.fogEnable, "bool");
        this.fogColor = this.addShaderUniform(Uniforms.fogColor, "vec3");
        this.fogEnd = this.addShaderUniform(Uniforms.fogEnd, "float");
        this.fogScale = this.addShaderUniform(Uniforms.fogScale, "float");
        this.clipPlaneEnable = this.addShaderUniform(Uniforms.clipPlaneEnable, "bool");
        this.viewportPos = this.addShaderUniform(Uniforms.viewportPos, "vec3");
        this.viewportScale = this.addShaderUniform(Uniforms.viewportScale, "vec3");
        this.numberBones = this.addShaderUniform(Uniforms.numberBones, "int");
        this.boneMatrix = this.addShaderUniform(Uniforms.boneMatrix, "mat4", 8);
        this.endOfUBO = this.addShaderUniform(Uniforms.endOfUBO, "int");
        StringBuilder s = new StringBuilder();
        s.append(String.format("layout(%s) uniform %s\n", uniformMemoryLayout, uniformBlockName));
        s.append(String.format("{\n", new Object[0]));
        for (ShaderUniformInfo shaderUniformInfo : this.shaderUniformInfos) {
            s.append(String.format("   %s %s;\n", shaderUniformInfo.getType(), shaderUniformInfo.getStructureName()));
        }
        s.append(String.format("};\n", new Object[0]));
        this.shaderUniformText = s.toString();
    }

    protected ShaderUniformInfo addShaderUniform(Uniforms uniform, String type) {
        ShaderUniformInfo shaderUniformInfo = new ShaderUniformInfo(uniform, type);
        this.shaderUniformInfos.add(shaderUniformInfo);
        return shaderUniformInfo;
    }

    protected ShaderUniformInfo addShaderUniform(Uniforms uniform, String type, int matrixSize) {
        ShaderUniformInfo shaderUniformInfo = new ShaderUniformInfo(uniform, type, matrixSize);
        this.shaderUniformInfos.add(shaderUniformInfo);
        return shaderUniformInfo;
    }

    public String getShaderUniformText() {
        return this.shaderUniformText;
    }

    @Override
    public void initShaderProgram(IRenderingEngine re, int shaderProgram) {
        int blockIndex = re.getUniformBlockIndex(shaderProgram, uniformBlockName);
        if (blockIndex >= 0) {
            re.setUniformBlockBinding(shaderProgram, blockIndex, 1);
        }
        if (this.data == null) {
            int previousOffset = -1;
            for (ShaderUniformInfo shaderUniformInfo : this.shaderUniformInfos) {
                int index = re.getUniformIndex(shaderProgram, shaderUniformInfo.getName());
                int offset = re.getActiveUniformOffset(shaderProgram, index);
                if (offset == 1) {
                    offset = 0;
                }
                shaderUniformInfo.setOffset(offset);
                if (offset < 0 || offset == previousOffset) {
                    shaderUniformInfo.setUnused();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Uniform %s", shaderUniformInfo));
                }
                previousOffset = offset;
            }
            int lastOffset = this.endOfUBO.getOffset() <= 0 || !this.endOfUBO.isUsed() ? this.boneMatrix.getOffset() + this.boneMatrix.getMatrixSize() * 4 * 4 * VideoEngine.SIZEOF_FLOAT : this.endOfUBO.getOffset();
            this.bufferSize = lastOffset + 4;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("UBO Structure size: %d (including endOfUBO)", this.bufferSize));
            }
            this.buffer = re.genBuffer();
            re.bindBuffer(1, this.buffer);
            this.data = ByteBuffer.allocateDirect(this.bufferSize).order(ByteOrder.nativeOrder());
            for (int i = 0; i < this.bufferSize; ++i) {
                this.data.put(i, (byte)0);
            }
            re.setBufferData(1, this.bufferSize, this.data, 6);
            re.bindBufferBase(1, 1, this.buffer);
            this.startUpdate = 0;
            this.endUpdate = this.bufferSize;
        }
        super.initShaderProgram(re, shaderProgram);
    }

    @Override
    public void setUniforms(IRenderingEngine re, int shaderProgram) {
        if (this.startUpdate < this.endUpdate) {
            re.bindBuffer(1, this.buffer);
            this.data.position(this.startUpdate);
            re.setBufferSubData(1, this.startUpdate, this.endUpdate - this.startUpdate, this.data);
            this.data.limit(this.data.capacity());
            this.startUpdate = this.bufferSize;
            this.endUpdate = 0;
        }
        this.setUniformsSamplers(re, shaderProgram);
    }

    protected void prepareCopy(int offset, int length) {
        this.data.position(offset);
        if (offset < this.startUpdate) {
            this.startUpdate = offset;
        }
        if (offset + length > this.endUpdate) {
            this.endUpdate = offset + length;
        }
    }

    protected void copy(int value, ShaderUniformInfo shaderUniformInfo) {
        if (shaderUniformInfo.isUsed()) {
            this.prepareCopy(shaderUniformInfo.getOffset(), 4);
            this.data.putInt(value);
        }
    }

    protected void copy(int value, ShaderUniformInfo shaderUniformInfo, int index) {
        if (shaderUniformInfo.isUsed()) {
            this.prepareCopy(shaderUniformInfo.getOffset() + index * 4, 4);
            this.data.putInt(value);
        }
    }

    protected void copy(float value, ShaderUniformInfo shaderUniformInfo) {
        if (shaderUniformInfo.isUsed()) {
            this.prepareCopy(shaderUniformInfo.getOffset(), 4);
            this.data.putFloat(value);
        }
    }

    protected void copy(float value, ShaderUniformInfo shaderUniformInfo, int index) {
        if (shaderUniformInfo.isUsed()) {
            this.prepareCopy(shaderUniformInfo.getOffset() + index * 4, 4);
            this.data.putFloat(value);
        }
    }

    protected void copy(float[] values, ShaderUniformInfo shaderUniformInfo, int start, int end) {
        if (shaderUniformInfo.isUsed()) {
            this.prepareCopy(shaderUniformInfo.getOffset() + start * 4, (end - start) * 4);
            for (int i = start; i < end; ++i) {
                float value = values[i];
                if (Float.isNaN(value)) {
                    value = 0.0f;
                }
                this.data.putFloat(value);
            }
        }
    }

    protected void copy(int[] values, ShaderUniformInfo shaderUniformInfo, int start, int end) {
        if (shaderUniformInfo.isUsed()) {
            this.prepareCopy(shaderUniformInfo.getOffset() + start * 4, (end - start) * 4);
            for (int i = start; i < end; ++i) {
                this.data.putInt(values[i]);
            }
        }
    }

    protected void copy(boolean value, ShaderUniformInfo shaderUniformInfo) {
        this.copy(value ? 1 : 0, shaderUniformInfo);
    }

    @Override
    public void setTexEnable(int texEnable) {
        if (texEnable != this.getTexEnable()) {
            this.copy(texEnable, this.texEnable);
            super.setTexEnable(texEnable);
        }
    }

    @Override
    public void setBoneMatrix(int count, float[] boneMatrix) {
        if (count > 0) {
            float[] previousBoneMatrix = this.getBoneMatrix();
            int length = 16 * count;
            int start = -1;
            for (int i = 0; i < length; ++i) {
                if (previousBoneMatrix[i] == boneMatrix[i]) continue;
                start = i;
                break;
            }
            if (start >= 0) {
                int end = start + 1;
                for (int i = length - 1; i > start; --i) {
                    if (previousBoneMatrix[i] == boneMatrix[i]) continue;
                    end = i + 1;
                    break;
                }
                this.copy(boneMatrix, this.boneMatrix, start, end);
                super.setBoneMatrix(count, boneMatrix);
            }
        }
    }

    @Override
    public void setColorDoubling(float colorDoubling) {
        if (colorDoubling != this.getColorDoubling()) {
            this.copy(colorDoubling, this.colorDoubling);
            super.setColorDoubling(colorDoubling);
        }
    }

    @Override
    public void setCtestEnable(int ctestEnable) {
        if (ctestEnable != this.getCtestEnable()) {
            this.copy(ctestEnable, this.ctestEnable);
            super.setCtestEnable(ctestEnable);
        }
    }

    @Override
    public void setCtestFunc(int ctestFunc) {
        if (ctestFunc != this.getCtestFunc()) {
            this.copy(ctestFunc, this.ctestFunc);
            super.setCtestFunc(ctestFunc);
        }
    }

    @Override
    public void setCtestMsk(int index, int ctestMsk) {
        if (ctestMsk != this.getCtestMsk(index)) {
            this.copy(ctestMsk, this.ctestMsk, index);
            super.setCtestMsk(index, ctestMsk);
        }
    }

    @Override
    public void setCtestRef(int index, int ctestRef) {
        if (ctestRef != this.getCtestRef(index)) {
            this.copy(ctestRef, this.ctestRef, index);
            super.setCtestRef(index, ctestRef);
        }
    }

    @Override
    public void setLightEnabled(int light, int lightEnabled) {
        if (lightEnabled != this.getLightEnabled(light)) {
            this.copy(lightEnabled, this.lightEnabled, light);
            super.setLightEnabled(light, lightEnabled);
        }
    }

    @Override
    public void setLightingEnable(int lightingEnable) {
        if (lightingEnable != this.getLightingEnable()) {
            this.copy(lightingEnable, this.lightingEnable);
            super.setLightingEnable(lightingEnable);
        }
    }

    @Override
    public void setLightKind(int light, int lightKind) {
        if (lightKind != this.getLightKind(light)) {
            this.copy(lightKind, this.lightKind, light);
            super.setLightKind(light, lightKind);
        }
    }

    @Override
    public void setLightMode(int lightMode) {
        if (lightMode != this.getLightMode()) {
            this.copy(lightMode, this.lightMode);
            super.setLightMode(lightMode);
        }
    }

    @Override
    public void setLightType(int light, int lightType) {
        if (lightType != this.getLightType(light)) {
            this.copy(lightType, this.lightType, light);
            super.setLightType(light, lightType);
        }
    }

    @Override
    public void setMatFlags(int index, int matFlags) {
        if (matFlags != this.getMatFlags(index)) {
            this.copy(matFlags, this.matFlags, index);
            super.setMatFlags(index, matFlags);
        }
    }

    @Override
    public void setNormalScale(float normalScale) {
        if (normalScale != this.getNormalScale()) {
            this.copy(normalScale, this.normalScale);
            super.setNormalScale(normalScale);
        }
    }

    @Override
    public void setNumberBones(int numberBones) {
        if (numberBones != this.getNumberBones()) {
            this.copy(numberBones, this.numberBones);
            super.setNumberBones(numberBones);
        }
    }

    @Override
    public void setPositionScale(float positionScale) {
        if (positionScale != this.getPositionScale()) {
            this.copy(positionScale, this.positionScale);
            super.setPositionScale(positionScale);
        }
    }

    @Override
    public void setTexEnvMode(int index, int texEnvMode) {
        if (texEnvMode != this.getTexEnvMode(index)) {
            this.copy(texEnvMode, this.texEnvMode, index);
            super.setTexEnvMode(index, texEnvMode);
        }
    }

    @Override
    public void setTexMapMode(int texMapMode) {
        if (texMapMode != this.getTexMapMode()) {
            this.copy(texMapMode, this.texMapMode);
            super.setTexMapMode(texMapMode);
        }
    }

    @Override
    public void setTexMapProj(int texMapProj) {
        if (texMapProj != this.getTexMapProj()) {
            this.copy(texMapProj, this.texMapProj);
            super.setTexMapProj(texMapProj);
        }
    }

    @Override
    public void setTexShade(int index, int texShade) {
        if (texShade != this.getTexShade(index)) {
            this.copy(texShade, this.texShade, index);
            super.setTexShade(index, texShade);
        }
    }

    @Override
    public void setTextureScale(float textureScale) {
        if (textureScale != this.getTextureScale()) {
            this.copy(textureScale, this.textureScale);
            super.setTextureScale(textureScale);
        }
    }

    @Override
    public void setVinfoColor(int vinfoColor) {
        if (vinfoColor != this.getVinfoColor()) {
            this.copy(vinfoColor, this.vinfoColor);
            super.setVinfoColor(vinfoColor);
        }
    }

    @Override
    public void setVinfoPosition(int vinfoPosition) {
        if (vinfoPosition != this.getVinfoPosition()) {
            this.copy(vinfoPosition, this.vinfoPosition);
            super.setVinfoPosition(vinfoPosition);
        }
    }

    @Override
    public void setVinfoTransform2D(int vinfoTransform2D) {
        if (vinfoTransform2D != this.getVinfoTransform2D()) {
            this.copy(vinfoTransform2D, this.vinfoTransform2D);
            super.setVinfoTransform2D(vinfoTransform2D);
        }
    }

    @Override
    public void setWeightScale(float weightScale) {
        if (weightScale != this.getWeightScale()) {
            this.copy(weightScale, this.weightScale);
            super.setWeightScale(weightScale);
        }
    }

    @Override
    public void setClutShift(int clutShift) {
        if (clutShift != this.getClutShift()) {
            this.copy(clutShift, this.clutShift);
            super.setClutShift(clutShift);
        }
    }

    @Override
    public void setClutMask(int clutMask) {
        if (clutMask != this.getClutMask()) {
            this.copy(clutMask, this.clutMask);
            super.setClutMask(clutMask);
        }
    }

    @Override
    public void setClutOffset(int clutOffset) {
        if (clutOffset != this.getClutOffset()) {
            this.copy(clutOffset, this.clutOffset);
            super.setClutOffset(clutOffset);
        }
    }

    @Override
    public void setMipmapShareClut(boolean mipmapShareClut) {
        if (mipmapShareClut != this.isMipmapShareClut()) {
            this.copy(mipmapShareClut, this.mipmapShareClut);
            super.setMipmapShareClut(mipmapShareClut);
        }
    }

    @Override
    public void setTexPixelFormat(int texPixelFormat) {
        if (texPixelFormat != this.getTexPixelFormat()) {
            this.copy(texPixelFormat, this.texPixelFormat);
            super.setTexPixelFormat(texPixelFormat);
        }
    }

    @Override
    public void setVertexColor(float[] vertexColor) {
        float[] currentVertexColor = this.getVertexColor();
        if (vertexColor[0] != currentVertexColor[0] || vertexColor[1] != currentVertexColor[1] || vertexColor[2] != currentVertexColor[2] || vertexColor[3] != currentVertexColor[3]) {
            this.copy(vertexColor, this.vertexColor, 0, 4);
            super.setVertexColor(vertexColor);
        }
    }

    @Override
    public void setVinfoTexture(int vinfoTexture) {
        if (vinfoTexture != this.getVinfoTexture()) {
            this.copy(vinfoTexture, this.vinfoTexture);
            super.setVinfoTexture(vinfoTexture);
        }
    }

    @Override
    public void setVinfoNormal(int vinfoNormal) {
        if (vinfoNormal != this.getVinfoNormal()) {
            this.copy(vinfoNormal, this.vinfoNormal);
            super.setVinfoNormal(vinfoNormal);
        }
    }

    @Override
    public void setStencilTestEnable(int stencilTestEnable) {
        if (stencilTestEnable != this.getStencilTestEnable()) {
            this.copy(stencilTestEnable, this.stencilTestEnable);
            super.setStencilTestEnable(stencilTestEnable);
        }
    }

    @Override
    public void setStencilFunc(int stencilFunc) {
        if (stencilFunc != this.getStencilFunc()) {
            this.copy(stencilFunc, this.stencilFunc);
            super.setStencilFunc(stencilFunc);
        }
    }

    @Override
    public void setStencilMask(int stencilMask) {
        if (stencilMask != this.getStencilMask()) {
            this.copy(stencilMask, this.stencilMask);
            super.setStencilMask(stencilMask);
        }
    }

    @Override
    public void setStencilOpFail(int stencilOpFail) {
        if (stencilOpFail != this.getStencilOpFail()) {
            this.copy(stencilOpFail, this.stencilOpFail);
            super.setStencilOpFail(stencilOpFail);
        }
    }

    @Override
    public void setStencilOpZFail(int stencilOpZFail) {
        if (stencilOpZFail != this.getStencilOpZFail()) {
            this.copy(stencilOpZFail, this.stencilOpZFail);
            super.setStencilOpZFail(stencilOpZFail);
        }
    }

    @Override
    public void setStencilOpZPass(int stencilOpZPass) {
        if (stencilOpZPass != this.getStencilOpZPass()) {
            this.copy(stencilOpZPass, this.stencilOpZPass);
            super.setStencilOpZPass(stencilOpZPass);
        }
    }

    @Override
    public void setDepthTestEnable(int depthTestEnable) {
        if (depthTestEnable != this.getDepthTestEnable()) {
            this.copy(depthTestEnable, this.depthTestEnable);
            super.setDepthTestEnable(depthTestEnable);
        }
    }

    @Override
    public void setDepthFunc(int depthFunc) {
        if (depthFunc != this.getDepthFunc()) {
            this.copy(depthFunc, this.depthFunc);
            super.setDepthFunc(depthFunc);
        }
    }

    @Override
    public void setDepthMask(int depthMask) {
        if (depthMask != this.getDepthMask()) {
            this.copy(depthMask, this.depthMask);
            super.setDepthMask(depthMask);
        }
    }

    @Override
    public void setStencilRef(int stencilRef) {
        if (stencilRef != this.getStencilRef()) {
            this.copy(stencilRef, this.stencilRef);
            super.setStencilRef(stencilRef);
        }
    }

    @Override
    public void setColorMaskEnable(int colorMaskEnable) {
        if (colorMaskEnable != this.getColorMaskEnable()) {
            this.copy(colorMaskEnable, this.colorMaskEnable);
            super.setColorMaskEnable(colorMaskEnable);
        }
    }

    @Override
    public void setColorMask(int redMask, int greenMask, int blueMask, int alphaMask) {
        int[] currentColorMask = this.getColorMask();
        if (redMask != currentColorMask[0] || greenMask != currentColorMask[1] || blueMask != currentColorMask[2] || alphaMask != currentColorMask[3]) {
            this.copy(new int[]{redMask, greenMask, blueMask, alphaMask}, this.colorMask, 0, 4);
            super.setColorMask(redMask, greenMask, blueMask, alphaMask);
        }
    }

    @Override
    public void setNotColorMask(int notRedMask, int notGreenMask, int notBlueMask, int notAlphaMask) {
        int[] currentNotColorMask = this.getNotColorMask();
        if (notRedMask != currentNotColorMask[0] || notGreenMask != currentNotColorMask[1] || notBlueMask != currentNotColorMask[2] || notAlphaMask != currentNotColorMask[3]) {
            this.copy(new int[]{notRedMask, notGreenMask, notBlueMask, notAlphaMask}, this.notColorMask, 0, 4);
            super.setNotColorMask(notRedMask, notGreenMask, notBlueMask, notAlphaMask);
        }
    }

    @Override
    public void setAlphaTestEnable(int alphaTestEnable) {
        if (alphaTestEnable != this.getAlphaTestEnable()) {
            this.copy(alphaTestEnable, this.alphaTestEnable);
            super.setAlphaTestEnable(alphaTestEnable);
        }
    }

    @Override
    public void setAlphaTestFunc(int alphaTestFunc) {
        if (alphaTestFunc != this.getAlphaTestFunc()) {
            this.copy(alphaTestFunc, this.alphaTestFunc);
            super.setAlphaTestFunc(alphaTestFunc);
        }
    }

    @Override
    public void setAlphaTestRef(int alphaTestRef) {
        if (alphaTestRef != this.getAlphaTestRef()) {
            this.copy(alphaTestRef, this.alphaTestRef);
            super.setAlphaTestRef(alphaTestRef);
        }
    }

    @Override
    public void setAlphaTestMask(int alphaTestMask) {
        if (alphaTestMask != this.getAlphaTestMask()) {
            this.copy(alphaTestMask, this.alphaTestMask);
            super.setAlphaTestMask(alphaTestMask);
        }
    }

    @Override
    public void setBlendTestEnable(int blendTestEnable) {
        if (blendTestEnable != this.getBlendTestEnable()) {
            this.copy(blendTestEnable, this.blendTestEnable);
            super.setBlendTestEnable(blendTestEnable);
        }
    }

    @Override
    public void setBlendEquation(int blendEquation) {
        if (blendEquation != this.getBlendEquation()) {
            this.copy(blendEquation, this.blendEquation);
            super.setBlendEquation(blendEquation);
        }
    }

    @Override
    public void setBlendSrc(int blendSrc) {
        if (blendSrc != this.getBlendSrc()) {
            this.copy(blendSrc, this.blendSrc);
            super.setBlendSrc(blendSrc);
        }
    }

    @Override
    public void setBlendDst(int blendDst) {
        if (blendDst != this.getBlendDst()) {
            this.copy(blendDst, this.blendDst);
            super.setBlendDst(blendDst);
        }
    }

    @Override
    public void setBlendSFix(float[] blendSFix) {
        float[] sfix = this.getBlendSFix();
        if (blendSFix[0] != sfix[0] || blendSFix[1] != sfix[1] || blendSFix[2] != sfix[2]) {
            this.copy(blendSFix, this.blendSFix, 0, 3);
            super.setBlendSFix(blendSFix);
        }
    }

    @Override
    public void setBlendDFix(float[] blendDFix) {
        float[] dfix = this.getBlendDFix();
        if (blendDFix[0] != dfix[0] || blendDFix[1] != dfix[1] || blendDFix[2] != dfix[2]) {
            this.copy(blendDFix, this.blendDFix, 0, 3);
            super.setBlendDFix(blendDFix);
        }
    }

    @Override
    public void setCopyRedToAlpha(int copyRedToAlpha) {
        if (copyRedToAlpha != this.getCopyRedToAlpha()) {
            this.copy(copyRedToAlpha, this.copyRedToAlpha);
            super.setCopyRedToAlpha(copyRedToAlpha);
        }
    }

    @Override
    public void setWrapModeS(int wrapModeS) {
        if (wrapModeS != this.getWrapModeS()) {
            this.copy(wrapModeS, this.wrapModeS);
            super.setWrapModeS(wrapModeS);
        }
    }

    @Override
    public void setWrapModeT(int wrapModeT) {
        if (wrapModeT != this.getWrapModeT()) {
            this.copy(wrapModeT, this.wrapModeT);
            super.setWrapModeT(wrapModeT);
        }
    }

    @Override
    public void setFogEnable(int fogEnable) {
        if (fogEnable != this.getFogEnable()) {
            this.copy(fogEnable, this.fogEnable);
            super.setFogEnable(fogEnable);
        }
    }

    @Override
    public void setFogColor(float[] fogColor) {
        float[] currentFogColor = this.getFogColor();
        if (fogColor[0] != currentFogColor[0] || fogColor[1] != currentFogColor[1] || fogColor[2] != currentFogColor[2]) {
            this.copy(fogColor, this.fogColor, 0, 3);
            super.setFogColor(fogColor);
        }
    }

    @Override
    public void setFogEnd(float fogEnd) {
        if (fogEnd != this.getFogEnd()) {
            this.copy(fogEnd, this.fogEnd);
            super.setFogEnd(fogEnd);
        }
    }

    @Override
    public void setFogScale(float fogScale) {
        if (fogScale != this.getFogScale()) {
            this.copy(fogScale, this.fogScale);
            super.setFogScale(fogScale);
        }
    }

    @Override
    public void setClipPlaneEnable(int clipPlaneEnable) {
        if (clipPlaneEnable != this.getClipPlaneEnable()) {
            this.copy(clipPlaneEnable, this.clipPlaneEnable);
            super.setClipPlaneEnable(clipPlaneEnable);
        }
    }

    @Override
    public void setViewportPos(float x, float y, float z) {
        float[] currentViewportPos = this.getViewportPos();
        if (x != currentViewportPos[0] || y != currentViewportPos[1] || z != currentViewportPos[2]) {
            this.copy(new float[]{x, y, z}, this.viewportPos, 0, 3);
            super.setViewportPos(x, y, z);
        }
    }

    @Override
    public void setViewportScale(float sx, float sy, float sz) {
        float[] currentViewportScale = this.getViewportScale();
        if (sx != currentViewportScale[0] || sy != currentViewportScale[1] || sz != currentViewportScale[2]) {
            this.copy(new float[]{sx, sy, sz}, this.viewportScale, 0, 3);
            super.setViewportScale(sx, sy, sz);
        }
    }

    private static class ShaderUniformInfo {
        private String name;
        private String structureName;
        private String type;
        private int offset;
        private int matrixSize;
        private boolean used;

        public ShaderUniformInfo(Uniforms uniform, String type) {
            this.structureName = this.name = uniform.getUniformString();
            this.type = type;
            this.used = true;
            this.matrixSize = 0;
        }

        public ShaderUniformInfo(Uniforms uniform, String type, int matrixSize) {
            this.name = uniform.getUniformString();
            this.structureName = String.format("%s[%d]", this.name, matrixSize);
            this.type = type;
            this.matrixSize = matrixSize;
            this.used = true;
        }

        public String getName() {
            return this.name;
        }

        public String getStructureName() {
            return this.structureName;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        private String getType() {
            return this.type;
        }

        public boolean isUsed() {
            return this.used;
        }

        public void setUnused() {
            this.used = false;
        }

        public int getMatrixSize() {
            return this.matrixSize;
        }

        public String toString() {
            if (!this.isUsed()) {
                return String.format("%s(unused)", this.getName());
            }
            return String.format("%s(offset=%d)", this.getName(), this.getOffset());
        }
    }
}

