/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.externalge;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.graphics.RE.externalge.ExternalGE;
import jpcsp.graphics.RE.externalge.NativeUtils;
import jpcsp.memory.mmio.MMIOHandlerGe;
import org.apache.log4j.Logger;

public class CoreThreadMMIO
extends Thread {
    protected static Logger log = ExternalGE.log;
    private static CoreThreadMMIO instance;
    private volatile boolean exit;
    private Semaphore sync = new Semaphore(0);

    public static CoreThreadMMIO getInstance() {
        if (instance == null) {
            instance = new CoreThreadMMIO();
            instance.setDaemon(true);
            instance.setName("ExternalGE - Core Thread for MMIO");
            instance.start();
        }
        return instance;
    }

    public static void exit() {
        if (instance != null) {
            CoreThreadMMIO.instance.exit = true;
            instance = null;
        }
    }

    private CoreThreadMMIO() {
    }

    @Override
    public void run() {
        RuntimeContext.setLog4jMDC();
        while (!this.exit) {
            int interrupt;
            if (!NativeUtils.isCoreCtrlActive() || NativeUtils.getCoreMadr() == NativeUtils.getCoreSadr()) {
                if (!Emulator.pause && log.isTraceEnabled()) {
                    log.trace((Object)String.format("CoreThreadMMIO not active... waiting", new Object[0]));
                }
                this.waitForSync(1000);
                continue;
            }
            NativeUtils.updateMemoryUnsafeAddr();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("CoreThreadMMIO processing 0x%08X", NativeUtils.getCoreMadr()));
            }
            while (NativeUtils.coreInterpret()) {
                NativeUtils.updateMemoryUnsafeAddr();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("CoreThreadMMIO looping at 0x%08X", NativeUtils.getCoreMadr()));
                }
                if (NativeUtils.getRendererIndexCount() <= 0) continue;
            }
            if (((interrupt = NativeUtils.getCoreInterrupt()) & 2) != 0) {
                MMIOHandlerGe.getInstance().onGeInterrupt();
            }
            if (NativeUtils.getRendererIndexCount() <= 0) continue;
            ExternalGE.render();
        }
        log.info((Object)String.format("CoreThreadMMIO exited", new Object[0]));
    }

    public void sync() {
        if (this.sync != null) {
            this.sync.release();
        }
    }

    private boolean waitForSync(int millis) {
        while (true) {
            try {
                int availablePermits = this.sync.drainPermits();
                if (availablePermits <= 0 && !this.sync.tryAcquire(millis, TimeUnit.MILLISECONDS)) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                log.debug((Object)String.format("CoreThreadMMIO waitForSync %s", e));
                continue;
            }
            break;
        }
        return true;
    }
}

